/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class BasicArrowButton
extends JButton
implements SwingConstants {
    protected int direction;
    private Color shadow;
    private Color darkShadow;
    private Color highlight;

    public BasicArrowButton(int n2, Color color, Color color2, Color color3, Color color4) {
        this.setRequestFocusEnabled(false);
        this.setDirection(n2);
        this.setBackground(color);
        this.shadow = color2;
        this.darkShadow = color3;
        this.highlight = color4;
    }

    public BasicArrowButton(int n2) {
        this(n2, UIManager.getColor("control"), UIManager.getColor("controlShadow"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlLtHighlight"));
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n2) {
        this.direction = n2;
    }

    public void paint(Graphics graphics) {
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        Color color = graphics.getColor();
        boolean bl2 = this.getModel().isPressed();
        boolean bl3 = this.isEnabled();
        graphics.setColor(this.getBackground());
        graphics.fillRect(1, 1, n2 - 2, n3 - 2);
        if (bl2) {
            graphics.setColor(this.shadow);
            graphics.drawRect(0, 0, n2 - 1, n3 - 1);
        } else {
            graphics.drawLine(0, 0, 0, n3 - 1);
            graphics.drawLine(1, 0, n2 - 2, 0);
            graphics.setColor(this.highlight);
            graphics.drawLine(1, 1, 1, n3 - 3);
            graphics.drawLine(2, 1, n2 - 3, 1);
            graphics.setColor(this.shadow);
            graphics.drawLine(1, n3 - 2, n2 - 2, n3 - 2);
            graphics.drawLine(n2 - 2, 1, n2 - 2, n3 - 3);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(0, n3 - 1, n2 - 1, n3 - 1);
            graphics.drawLine(n2 - 1, n3 - 1, n2 - 1, 0);
        }
        if (n3 < 5 || n2 < 5) {
            graphics.setColor(color);
            return;
        }
        if (bl2) {
            graphics.translate(1, 1);
        }
        int n4 = Math.min((n3 - 4) / 3, (n2 - 4) / 3);
        n4 = Math.max(n4, 2);
        this.paintTriangle(graphics, (n2 - n4) / 2, (n3 - n4) / 2, n4, this.direction, bl3);
        if (bl2) {
            graphics.translate(-1, -1);
        }
        graphics.setColor(color);
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paintTriangle(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2) {
        Color color = graphics.getColor();
        int n6 = 0;
        n4 = Math.max(n4, 2);
        int n7 = n4 / 2 - 1;
        graphics.translate(n2, n3);
        if (bl2) {
            graphics.setColor(this.darkShadow);
        } else {
            graphics.setColor(this.shadow);
        }
        switch (n5) {
            case 1: {
                int n8 = 0;
                while (n8 < n4) {
                    graphics.drawLine(n7 - n8, n8, n7 + n8, n8);
                    ++n8;
                }
                if (bl2) break;
                graphics.setColor(this.highlight);
                graphics.drawLine(n7 - n8 + 2, n8, n7 + n8, n8);
                break;
            }
            case 5: {
                int n9;
                if (!bl2) {
                    graphics.translate(1, 1);
                    graphics.setColor(this.highlight);
                    n9 = n4 - 1;
                    while (n9 >= 0) {
                        graphics.drawLine(n7 - n9, n6, n7 + n9, n6);
                        ++n6;
                        --n9;
                    }
                    graphics.translate(-1, -1);
                    graphics.setColor(this.shadow);
                }
                n6 = 0;
                n9 = n4 - 1;
                while (n9 >= 0) {
                    graphics.drawLine(n7 - n9, n6, n7 + n9, n6);
                    ++n6;
                    --n9;
                }
                break;
            }
            case 7: {
                int n10 = 0;
                while (n10 < n4) {
                    graphics.drawLine(n10, n7 - n10, n10, n7 + n10);
                    ++n10;
                }
                if (bl2) break;
                graphics.setColor(this.highlight);
                graphics.drawLine(n10, n7 - n10 + 2, n10, n7 + n10);
                break;
            }
            case 3: {
                int n11;
                if (!bl2) {
                    graphics.translate(1, 1);
                    graphics.setColor(this.highlight);
                    n11 = n4 - 1;
                    while (n11 >= 0) {
                        graphics.drawLine(n6, n7 - n11, n6, n7 + n11);
                        ++n6;
                        --n11;
                    }
                    graphics.translate(-1, -1);
                    graphics.setColor(this.shadow);
                }
                n6 = 0;
                n11 = n4 - 1;
                while (n11 >= 0) {
                    graphics.drawLine(n6, n7 - n11, n6, n7 + n11);
                    ++n6;
                    --n11;
                }
                break;
            }
        }
        graphics.translate(-n2, -n3);
        graphics.setColor(color);
    }
}

