/*
 * Decompiled with CFR 0.152.
 */
package javax.accessibility;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class AccessibleBundle {
    private static Hashtable table = null;
    private final String defaultResourceBundleName = "com.sun.accessibility.internal.resources.accessibility";
    protected String key = null;

    protected String toDisplayString(String string, Locale locale) {
        this.loadResourceBundle(string, locale);
        Object object = table.get(this.key);
        if (object != null && object instanceof String) {
            return (String)object;
        }
        return this.key;
    }

    public String toDisplayString(Locale locale) {
        return this.toDisplayString("com.sun.accessibility.internal.resources.accessibility", locale);
    }

    public String toDisplayString() {
        return this.toDisplayString(Locale.getDefault());
    }

    public String toString() {
        return this.toDisplayString();
    }

    private void loadResourceBundle(String string, Locale locale) {
        if (table == null) {
            try {
                table = new Hashtable();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
                Enumeration enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    table.put(string2, resourceBundle.getObject(string2));
                }
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
    }
}

