/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.rmi.MarshalledObject;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.security.action.GetIntegerAction;

public abstract class ActivationGroup
extends UnicastRemoteObject
implements ActivationInstantiator {
    private ActivationGroupID groupID;
    private ActivationMonitor monitor;
    private long incarnation;
    private static ActivationGroup currGroup;
    private static ActivationGroupID currGroupID;
    private static ActivationSystem currSystem;
    private static boolean canCreate;
    private static Class[] groupConstrParams;
    private static final long serialVersionUID = -7696947875314805420L;
    static /* synthetic */ Class class$java$rmi$activation$ActivationGroupID;
    static /* synthetic */ Class class$java$rmi$MarshalledObject;
    static /* synthetic */ Class class$sun$rmi$server$ActivationGroupImpl;

    protected ActivationGroup(ActivationGroupID activationGroupID) throws RemoteException {
        this.groupID = activationGroupID;
    }

    public boolean inactiveObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        this.monitor.inactiveObject(activationID);
        return true;
    }

    public abstract void activeObject(ActivationID var1, Remote var2) throws ActivationException, UnknownObjectException, RemoteException;

    public static synchronized ActivationGroup createGroup(ActivationGroupID activationGroupID, final ActivationGroupDesc activationGroupDesc, long l2) throws ActivationException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        if (currGroup != null) {
            throw new ActivationException("group already exists");
        }
        if (!canCreate) {
            throw new ActivationException("group deactivated and cannot be recreated");
        }
        try {
            try {
                Class clazz;
                String string = activationGroupDesc.getClassName();
                if (string == null) {
                    string = (class$sun$rmi$server$ActivationGroupImpl == null ? (class$sun$rmi$server$ActivationGroupImpl = ActivationGroup.class$("sun.rmi.server.ActivationGroupImpl")) : class$sun$rmi$server$ActivationGroupImpl).getName();
                }
                final String string2 = string;
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException, MalformedURLException {
                            return RMIClassLoader.loadClass(activationGroupDesc.getLocation(), string2);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new ActivationException("Could not load default group implementation class", privilegedActionException.getException());
                }
                Constructor constructor = clazz.getConstructor(groupConstrParams);
                Object[] objectArray = new Object[]{activationGroupID, activationGroupDesc.getData()};
                Object object = constructor.newInstance(objectArray);
                if (!(object instanceof ActivationGroup)) {
                    throw new ActivationException("group not correct class: " + object.getClass().getName());
                }
                currGroup = (ActivationGroup)object;
                currGroupID = activationGroupID;
                currSystem = activationGroupID.getSystem();
                ActivationGroup.currGroup.incarnation = l2;
                ActivationGroup.currGroup.monitor = currSystem.activeGroup(activationGroupID, currGroup, l2);
                canCreate = false;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
                throw new ActivationException("exception in group constructor", invocationTargetException.getTargetException());
            }
            catch (ActivationException activationException) {
                throw activationException;
            }
            catch (Exception exception) {
                throw new ActivationException("exception creating group", exception);
            }
        }
        catch (ActivationException activationException) {
            ActivationGroup.destroyGroup();
            canCreate = true;
            throw activationException;
        }
        return currGroup;
    }

    public static synchronized ActivationGroupID currentGroupID() {
        return currGroupID;
    }

    static synchronized ActivationGroupID internalCurrentGroupID() throws ActivationException {
        if (currGroupID == null) {
            throw new ActivationException("nonexistent group");
        }
        return currGroupID;
    }

    public static synchronized void setSystem(ActivationSystem activationSystem) throws ActivationException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        if (currSystem != null) {
            throw new ActivationException("activation system already set");
        }
        currSystem = activationSystem;
    }

    public static synchronized ActivationSystem getSystem() throws ActivationException {
        if (currSystem == null) {
            try {
                int n2 = (Integer)AccessController.doPrivileged(new GetIntegerAction("java.rmi.activation.port", 1098));
                currSystem = (ActivationSystem)Naming.lookup("//:" + n2 + "/java.rmi.activation.ActivationSystem");
            }
            catch (Exception exception) {
                throw new ActivationException("ActivationSystem not running", exception);
            }
        }
        return currSystem;
    }

    protected void activeObject(ActivationID activationID, MarshalledObject marshalledObject) throws ActivationException, UnknownObjectException, RemoteException {
        this.monitor.activeObject(activationID, marshalledObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inactiveGroup() throws UnknownGroupException, RemoteException {
        try {
            this.monitor.inactiveGroup(this.groupID, this.incarnation);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            ActivationGroup.destroyGroup();
            throw throwable;
        }
        ActivationGroup.destroyGroup();
    }

    private static synchronized void destroyGroup() {
        currGroup = null;
        currGroupID = null;
    }

    static synchronized ActivationGroup currentGroup() throws ActivationException {
        if (currGroup == null) {
            throw new ActivationException("group is not active");
        }
        return currGroup;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        canCreate = true;
        groupConstrParams = new Class[]{class$java$rmi$activation$ActivationGroupID == null ? (class$java$rmi$activation$ActivationGroupID = ActivationGroup.class$("java.rmi.activation.ActivationGroupID")) : class$java$rmi$activation$ActivationGroupID, class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = ActivationGroup.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject};
    }
}

