/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;
import sun.misc.VM;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.ThreadLocalCoders;

public abstract class Charset
implements Comparable {
    private static CharsetProvider standardProvider = new StandardCharsets();
    private static volatile Object[] cache = null;
    private static ThreadLocal gate = new ThreadLocal();
    private final String name;
    private final String[] aliases;
    private Set aliasSet = null;
    static /* synthetic */ Class class$java$nio$charset$spi$CharsetProvider;

    private static void checkName(String string) {
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (!(c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == ':' || c2 == '_' || c2 == '.')) {
                throw new IllegalCharsetNameException(string);
            }
            ++n3;
        }
    }

    private static Charset cache(String string, Charset charset) {
        cache = new Object[]{string, charset};
        return charset;
    }

    private static Iterator providers() {
        return new Iterator(){
            Class c = class$java$nio$charset$spi$CharsetProvider == null ? (class$java$nio$charset$spi$CharsetProvider = Charset.class$("java.nio.charset.spi.CharsetProvider")) : class$java$nio$charset$spi$CharsetProvider;
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Iterator i = Service.providers(this.c, this.cl);
            Object next = null;

            private boolean getNext() {
                while (this.next == null) {
                    try {
                        if (!this.i.hasNext()) {
                            return false;
                        }
                        this.next = this.i.next();
                    }
                    catch (ServiceConfigurationError serviceConfigurationError) {
                        if (serviceConfigurationError.getCause() instanceof SecurityException) continue;
                        throw serviceConfigurationError;
                    }
                }
                return true;
            }

            public boolean hasNext() {
                return this.getNext();
            }

            public Object next() {
                if (!this.getNext()) {
                    throw new NoSuchElementException();
                }
                Object object = this.next;
                this.next = null;
                return object;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset lookupViaProviders(final String string) {
        if (!VM.isBooted()) {
            return null;
        }
        if (gate.get() != null) {
            return null;
        }
        try {
            gate.set(gate);
            Charset charset = (Charset)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator iterator = Charset.providers();
                    while (iterator.hasNext()) {
                        CharsetProvider charsetProvider = (CharsetProvider)iterator.next();
                        Charset charset = charsetProvider.charsetForName(string);
                        if (charset == null) continue;
                        return charset;
                    }
                    return null;
                }
            });
            Object var3_2 = null;
            gate.set(null);
            return charset;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            gate.set(null);
            throw throwable;
        }
    }

    private static Charset lookup(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null charset name");
        }
        Object[] objectArray = cache;
        if (objectArray != null && objectArray[0].equals(string)) {
            return (Charset)objectArray[1];
        }
        Charset charset = standardProvider.charsetForName(string);
        if (charset != null) {
            return Charset.cache(string, charset);
        }
        charset = Charset.lookupViaProviders(string);
        if (charset != null) {
            return Charset.cache(string, charset);
        }
        Charset.checkName(string);
        return null;
    }

    public static boolean isSupported(String string) {
        return Charset.lookup(string) != null;
    }

    public static Charset forName(String string) {
        Charset charset = Charset.lookup(string);
        if (charset != null) {
            return charset;
        }
        throw new UnsupportedCharsetException(string);
    }

    private static void put(Iterator iterator, Map map) {
        while (iterator.hasNext()) {
            Charset charset = (Charset)iterator.next();
            if (map.containsKey(charset.name())) continue;
            map.put(charset.name(), charset);
        }
    }

    public static SortedMap availableCharsets() {
        return (SortedMap)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                Charset.put(standardProvider.charsets(), treeMap);
                Iterator iterator = Charset.providers();
                while (iterator.hasNext()) {
                    CharsetProvider charsetProvider = (CharsetProvider)iterator.next();
                    Charset.put(charsetProvider.charsets(), treeMap);
                }
                return Collections.unmodifiableSortedMap(treeMap);
            }
        });
    }

    protected Charset(String string, String[] stringArray) {
        Charset.checkName(string);
        String[] stringArray2 = stringArray == null ? new String[]{} : stringArray;
        int n2 = 0;
        while (n2 < stringArray2.length) {
            Charset.checkName(stringArray2[n2]);
            ++n2;
        }
        this.name = string;
        this.aliases = stringArray2;
    }

    public final String name() {
        return this.name;
    }

    public final Set aliases() {
        if (this.aliasSet != null) {
            return this.aliasSet;
        }
        int n2 = this.aliases.length;
        HashSet hashSet = new HashSet(n2);
        int n3 = 0;
        while (n3 < n2) {
            hashSet.add(this.aliases[n3]);
            ++n3;
        }
        this.aliasSet = Collections.unmodifiableSet(hashSet);
        return this.aliasSet;
    }

    public String displayName() {
        return this.name;
    }

    public final boolean isRegistered() {
        return !this.name.startsWith("X-") && !this.name.startsWith("x-");
    }

    public String displayName(Locale locale) {
        return this.name;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final CharBuffer decode(ByteBuffer byteBuffer) {
        try {
            return ThreadLocalCoders.decoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error(characterCodingException);
        }
    }

    public final ByteBuffer encode(CharBuffer charBuffer) {
        try {
            return ThreadLocalCoders.encoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(charBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error(characterCodingException);
        }
    }

    public final ByteBuffer encode(String string) {
        return this.encode(CharBuffer.wrap(string));
    }

    public final int compareTo(Object object) {
        return this.name().compareToIgnoreCase(((Charset)object).name());
    }

    public final int hashCode() {
        return this.name().hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Charset)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.name.equals(((Charset)object).name());
    }

    public final String toString() {
        return this.name();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

