/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number
implements Comparable {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class TYPE = Class.getPrimitiveClass("int");
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private int value;
    private static final long serialVersionUID = 1360826667806852920L;

    public static String toString(int n2, int n3) {
        if (n3 < 2 || n3 > 36) {
            n3 = 10;
        }
        if (n3 == 10) {
            return Integer.toString(n2);
        }
        char[] cArray = new char[33];
        boolean bl2 = n2 < 0;
        int n4 = 32;
        if (!bl2) {
            n2 = -n2;
        }
        while (n2 <= -n3) {
            cArray[n4--] = digits[-(n2 % n3)];
            n2 /= n3;
        }
        cArray[n4] = digits[-n2];
        if (bl2) {
            cArray[--n4] = 45;
        }
        return new String(cArray, n4, 33 - n4);
    }

    public static String toHexString(int n2) {
        return Integer.toUnsignedString(n2, 4);
    }

    public static String toOctalString(int n2) {
        return Integer.toUnsignedString(n2, 3);
    }

    public static String toBinaryString(int n2) {
        return Integer.toUnsignedString(n2, 1);
    }

    private static String toUnsignedString(int n2, int n3) {
        char[] cArray = new char[32];
        int n4 = 32;
        int n5 = 1 << n3;
        int n6 = n5 - 1;
        do {
            cArray[--n4] = digits[n2 & n6];
        } while ((n2 >>>= n3) != 0);
        return new String(cArray, n4, 32 - n4);
    }

    public static String toString(int n2) {
        int n3;
        int n4;
        int n5 = 12;
        char[] cArray = new char[n5];
        int n6 = 0;
        if (n2 == Integer.MIN_VALUE) {
            return "-2147483648";
        }
        if (n2 < 0) {
            n6 = 45;
            n2 = -n2;
        }
        while (n2 >= 65536) {
            n4 = n2 / 100;
            n3 = n2 - ((n4 << 6) + (n4 << 5) + (n4 << 2));
            n2 = n4;
            cArray[--n5] = DigitOnes[n3];
            cArray[--n5] = DigitTens[n3];
        }
        do {
            n4 = n2 * 52429 >>> 19;
            n3 = n2 - ((n4 << 3) + (n4 << 1));
            cArray[--n5] = digits[n3];
        } while ((n2 = n4) != 0);
        if (n6 != 0) {
            cArray[--n5] = n6;
        }
        return new String(n5, 12 - n5, cArray);
    }

    public static int parseInt(String string, int n2) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (n2 < 2) {
            throw new NumberFormatException("radix " + n2 + " less than Character.MIN_RADIX");
        }
        if (n2 > 36) {
            throw new NumberFormatException("radix " + n2 + " greater than Character.MAX_RADIX");
        }
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = string.length();
        if (n5 > 0) {
            int n6;
            int n7;
            if (string.charAt(0) == '-') {
                bl2 = true;
                n7 = Integer.MIN_VALUE;
                ++n4;
            } else {
                n7 = -2147483647;
            }
            int n8 = n7 / n2;
            if (n4 < n5) {
                if ((n6 = Character.digit(string.charAt(n4++), n2)) < 0) {
                    throw new NumberFormatException(string);
                }
                n3 = -n6;
            }
            while (n4 < n5) {
                if ((n6 = Character.digit(string.charAt(n4++), n2)) < 0) {
                    throw new NumberFormatException(string);
                }
                if (n3 < n8) {
                    throw new NumberFormatException(string);
                }
                if ((n3 *= n2) < n7 + n6) {
                    throw new NumberFormatException(string);
                }
                n3 -= n6;
            }
        } else {
            throw new NumberFormatException(string);
        }
        if (bl2) {
            if (n4 > 1) {
                return n3;
            }
            throw new NumberFormatException(string);
        }
        return -n3;
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static Integer valueOf(String string, int n2) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, n2));
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, 10));
    }

    public Integer(int n2) {
        this.value = n2;
    }

    public Integer(String string) throws NumberFormatException {
        this.value = Integer.parseInt(string, 10);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Integer) {
            return this.value == (Integer)object;
        }
        return false;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, int n2) {
        Integer n3 = Integer.getInteger(string, null);
        return n3 == null ? new Integer(n2) : n3;
    }

    public static Integer getInteger(String string, Integer n2) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static Integer decode(String string) throws NumberFormatException {
        Integer n2;
        int n3 = 10;
        int n4 = 0;
        boolean bl2 = false;
        if (string.startsWith("-")) {
            bl2 = true;
            ++n4;
        }
        if (string.startsWith("0x", n4) || string.startsWith("0X", n4)) {
            n4 += 2;
            n3 = 16;
        } else if (string.startsWith("#", n4)) {
            ++n4;
            n3 = 16;
        } else if (string.startsWith("0", n4) && string.length() > 1 + n4) {
            ++n4;
            n3 = 8;
        }
        if (string.startsWith("-", n4)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            n2 = Integer.valueOf(string.substring(n4), n3);
            n2 = bl2 ? new Integer(-n2.intValue()) : n2;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl2 ? new String("-" + string.substring(n4)) : string.substring(n4);
            n2 = Integer.valueOf(string2, n3);
        }
        return n2;
    }

    public int compareTo(Integer n2) {
        int n3 = this.value;
        int n4 = n2.value;
        return n3 < n4 ? -1 : (n3 == n4 ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((Integer)object);
    }
}

