/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class WritableRaster
extends Raster {
    protected WritableRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, WritableRaster writableRaster) {
        super(sampleModel, dataBuffer, rectangle, point, writableRaster);
    }

    public WritableRaster getWritableParent() {
        return (WritableRaster)this.parent;
    }

    public WritableRaster createWritableTranslatedChild(int n2, int n3) {
        return this.createWritableChild(this.minX, this.minY, this.width, this.height, n2, n3, null);
    }

    public WritableRaster createWritableChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n2 < this.minX) {
            throw new RasterFormatException("parentX lies outside raster");
        }
        if (n3 < this.minY) {
            throw new RasterFormatException("parentY lies outside raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.width + this.minX) {
            throw new RasterFormatException("(parentX + width) is outside raster");
        }
        if (n3 + n5 < n3 || n3 + n5 > this.height + this.minY) {
            throw new RasterFormatException("(parentY + height) is outside raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n8 = n6 - n2;
        int n9 = n7 - n3;
        return new WritableRaster(sampleModel, this.dataBuffer, new Rectangle(n6, n7, n4, n5), new Point(this.sampleModelTranslateX + n8, this.sampleModelTranslateY + n9), this);
    }

    public void setDataElements(int n2, int n3, Object object) {
        this.sampleModel.setDataElements(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, object, this.dataBuffer);
    }

    public void setDataElements(int n2, int n3, Raster raster) {
        int n4 = n2 + raster.getMinX();
        int n5 = n3 + raster.getMinY();
        int n6 = raster.getWidth();
        int n7 = raster.getHeight();
        if (n4 < this.minX || n5 < this.minY || n4 + n6 > this.minX + this.width || n5 + n7 > this.minY + this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n8 = raster.getMinX();
        int n9 = raster.getMinY();
        Object object = null;
        int n10 = 0;
        while (n10 < n7) {
            object = raster.getDataElements(n8, n9 + n10, n6, 1, object);
            this.setDataElements(n4, n5 + n10, n6, 1, object);
            ++n10;
        }
    }

    public void setDataElements(int n2, int n3, int n4, int n5, Object object) {
        this.sampleModel.setDataElements(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, object, this.dataBuffer);
    }

    public void setRect(Raster raster) {
        this.setRect(0, 0, raster);
    }

    public void setRect(int n2, int n3, Raster raster) {
        int n4;
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        int n7 = raster.getMinX();
        int n8 = raster.getMinY();
        int n9 = n2 + n7;
        int n10 = n3 + n8;
        if (n9 < this.minX) {
            n4 = this.minX - n9;
            n5 -= n4;
            n7 += n4;
            n9 = this.minX;
        }
        if (n10 < this.minY) {
            n4 = this.minY - n10;
            n6 -= n4;
            n8 += n4;
            n10 = this.minY;
        }
        if (n9 + n5 > this.minX + this.width) {
            n5 = this.minX + this.width - n9;
        }
        if (n10 + n6 > this.minY + this.height) {
            n6 = this.minY + this.height - n10;
        }
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = null;
                int n11 = 0;
                while (n11 < n6) {
                    nArray = raster.getPixels(n7, n8 + n11, n5, 1, nArray);
                    this.setPixels(n9, n10 + n11, n5, 1, nArray);
                    ++n11;
                }
                break;
            }
            case 4: {
                float[] fArray = null;
                int n12 = 0;
                while (n12 < n6) {
                    fArray = raster.getPixels(n7, n8 + n12, n5, 1, fArray);
                    this.setPixels(n9, n10 + n12, n5, 1, fArray);
                    ++n12;
                }
                break;
            }
            case 5: {
                double[] dArray = null;
                int n13 = 0;
                while (n13 < n6) {
                    dArray = raster.getPixels(n7, n8 + n13, n5, 1, dArray);
                    this.setPixels(n9, n10 + n13, n5, 1, dArray);
                    ++n13;
                }
                break;
            }
        }
    }

    public void setPixel(int n2, int n3, int[] nArray) {
        this.sampleModel.setPixel(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, nArray, this.dataBuffer);
    }

    public void setPixel(int n2, int n3, float[] fArray) {
        this.sampleModel.setPixel(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public void setPixel(int n2, int n3, double[] dArray) {
        this.sampleModel.setPixel(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public void setPixels(int n2, int n3, int n4, int n5, int[] nArray) {
        this.sampleModel.setPixels(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, nArray, this.dataBuffer);
    }

    public void setPixels(int n2, int n3, int n4, int n5, float[] fArray) {
        this.sampleModel.setPixels(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, fArray, this.dataBuffer);
    }

    public void setPixels(int n2, int n3, int n4, int n5, double[] dArray) {
        this.sampleModel.setPixels(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, dArray, this.dataBuffer);
    }

    public void setSample(int n2, int n3, int n4, int n5) {
        this.sampleModel.setSample(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, this.dataBuffer);
    }

    public void setSample(int n2, int n3, int n4, float f2) {
        this.sampleModel.setSample(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, f2, this.dataBuffer);
    }

    public void setSample(int n2, int n3, int n4, double d2) {
        this.sampleModel.setSample(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, d2, this.dataBuffer);
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.sampleModel.setSamples(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, n6, nArray, this.dataBuffer);
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.sampleModel.setSamples(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, n6, fArray, this.dataBuffer);
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, double[] dArray) {
        this.sampleModel.setSamples(n2 - this.sampleModelTranslateX, n3 - this.sampleModelTranslateY, n4, n5, n6, dArray, this.dataBuffer);
    }
}

