/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.ior;

import com.sun.corba.se.internal.corba.EncapsOutputStream;
import com.sun.corba.se.internal.iiop.CDROutputStream;
import com.sun.corba.se.internal.ior.IIOPAddress;
import com.sun.corba.se.internal.ior.IIOPProfile;
import com.sun.corba.se.internal.ior.IdEncapsulationBase;
import com.sun.corba.se.internal.ior.IdEncapsulationContainerBase;
import com.sun.corba.se.internal.ior.ObjectId;
import com.sun.corba.se.internal.ior.ObjectKeyTemplate;
import com.sun.corba.se.internal.ior.TaggedProfile;
import com.sun.corba.se.internal.ior.TaggedProfileTemplate;
import org.omg.CORBA_2_3.portable.OutputStream;

public class IIOPProfileTemplate
extends IdEncapsulationContainerBase
implements TaggedProfileTemplate {
    private byte major;
    private byte minor;
    private IIOPAddress primary;
    private ObjectKeyTemplate okeyTemplate;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IIOPProfileTemplate)) {
            return false;
        }
        IIOPProfileTemplate iIOPProfileTemplate = (IIOPProfileTemplate)object;
        return super.equals(object) && this.major == iIOPProfileTemplate.major && this.minor == iIOPProfileTemplate.minor && this.primary.equals(iIOPProfileTemplate.primary) && this.okeyTemplate.equals(iIOPProfileTemplate.okeyTemplate);
    }

    public TaggedProfile create(ObjectId objectId) {
        return new IIOPProfile(objectId, this);
    }

    public byte getMajorVersion() {
        return this.major;
    }

    public byte getMinorVersion() {
        return this.minor;
    }

    public IIOPAddress getPrimaryAddress() {
        return this.primary;
    }

    public ObjectKeyTemplate getObjectKeyTemplate() {
        return this.okeyTemplate;
    }

    public IIOPProfileTemplate(byte by, byte by2, IIOPAddress iIOPAddress, ObjectKeyTemplate objectKeyTemplate) {
        this.major = by;
        this.minor = by2;
        this.primary = iIOPAddress;
        this.okeyTemplate = objectKeyTemplate;
        if (by2 == 0) {
            this.makeImmutable();
        }
    }

    public void write(ObjectId objectId, OutputStream outputStream) {
        outputStream.write_octet(this.major);
        outputStream.write_octet(this.minor);
        this.primary.write(outputStream);
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream(outputStream.orb(), ((CDROutputStream)outputStream).isLittleEndian());
        this.okeyTemplate.write(objectId, encapsOutputStream);
        IdEncapsulationBase.writeOutputStream(encapsOutputStream, outputStream);
        if (this.minor > 0) {
            this.writeIdEncapsulationSequence(outputStream);
        }
    }

    public int getId() {
        return 0;
    }

    public boolean isEquivalent(IIOPProfileTemplate iIOPProfileTemplate) {
        return this.primary.equals(iIOPProfileTemplate.primary) && this.okeyTemplate.equals(iIOPProfileTemplate.okeyTemplate);
    }
}

