/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.core;

import com.sun.corba.se.internal.corba.EncapsInputStream;
import com.sun.corba.se.internal.corba.EncapsOutputStream;
import com.sun.corba.se.internal.corba.ORB;
import com.sun.corba.se.internal.core.GIOPVersion;
import com.sun.corba.se.internal.iiop.CDRInputStream;
import com.sun.corba.se.internal.orbutil.ORBUtility;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public abstract class ServiceContext {
    protected InputStream in = null;

    protected ServiceContext() {
    }

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    protected ServiceContext(InputStream inputStream, GIOPVersion gIOPVersion) throws SystemException {
        ORB oRB = (ORB)((CDRInputStream)inputStream).orb();
        if (oRB.serviceContextDebugFlag) {
            this.dprint("Reading service context from stream");
        }
        int n2 = inputStream.read_long();
        if (oRB.serviceContextDebugFlag) {
            this.dprint("Service context length = " + n2);
        }
        byte[] byArray = new byte[n2];
        inputStream.read_octet_array(byArray, 0, n2);
        EncapsInputStream encapsInputStream = new EncapsInputStream(inputStream.orb(), byArray, byArray.length);
        encapsInputStream.consumeEndian();
        this.in = encapsInputStream;
    }

    public abstract int getId();

    public void write(OutputStream outputStream, GIOPVersion gIOPVersion) throws SystemException {
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream(outputStream.orb());
        encapsOutputStream.putEndian();
        this.writeData(encapsOutputStream);
        byte[] byArray = encapsOutputStream.toByteArray();
        outputStream.write_long(this.getId());
        outputStream.write_long(byArray.length);
        outputStream.write_octet_array(byArray, 0, byArray.length);
    }

    protected abstract void writeData(OutputStream var1);

    public String toString() {
        return "ServiceContext[ id=" + this.getId() + " ]";
    }
}

