/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.UnknownHostException;

public final class InetAddress
implements Serializable {
    private int address;
    transient byte[] addr;
    String hostName;
    int family;
    private static final long serialVersionUID = 3286316764910316507L;
    static final byte[] zeros = new byte[]{0, 0, 0, 0};
    static final InetAddress ANY_IF = new InetAddress(zeros, null);
    private static final byte[] localhostAddress = new byte[]{127, 0, 0, 1};
    private static InetAddress localhost = null;

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.addr = new byte[4];
        this.addr[3] = (byte)this.address;
        for (int i = 2; i >= 0; --i) {
            this.addr[i] = (byte)(this.address >>= 8);
        }
        this.family = InetAddress.getFamily(this.addr);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int len = this.addr.length;
        for (int i = len - 4; i < len; ++i) {
            this.address = this.address << 8 | this.addr[i] & 0xFF;
        }
        oos.defaultWriteObject();
    }

    private static native int getFamily(byte[] var0);

    InetAddress(byte[] address, String hostname) {
        this.addr = address;
        this.hostName = hostname;
        if (address != null) {
            this.family = InetAddress.getFamily(address);
        }
    }

    public boolean isMulticastAddress() {
        int len = this.addr.length;
        if (len == 4) {
            return (this.addr[0] & 0xF0) == 224;
        }
        if (len == 16) {
            return this.addr[0] == -1;
        }
        return false;
    }

    public String getHostName() {
        if (this.hostName == null) {
            InetAddress.lookup(null, this, false);
        }
        return this.hostName;
    }

    public byte[] getAddress() {
        return (byte[])this.addr.clone();
    }

    private static InetAddress[] allocArray(int count) {
        return new InetAddress[count];
    }

    private static SecurityException checkConnect(String hostname) {
        SecurityManager s = System.getSecurityManager();
        if (s == null) {
            return null;
        }
        try {
            s.checkConnect(hostname, -1);
            return null;
        }
        catch (SecurityException ex) {
            return ex;
        }
    }

    public String getHostAddress() {
        StringBuffer sbuf = new StringBuffer(40);
        int len = this.addr.length;
        int i = 0;
        if (len == 16) {
            while (true) {
                boolean empty;
                if (i >= 16) {
                    return sbuf.toString();
                }
                int x = (this.addr[i] & 0xFF) << 8 | this.addr[i + 1] & 0xFF;
                boolean bl = empty = sbuf.length() == 0;
                if (empty) {
                    if (i == 10 && x == 65535) {
                        sbuf.append(":FFFF:");
                        break;
                    }
                    if (i == 12) {
                        sbuf.append(':');
                        break;
                    }
                    if (i > 0) {
                        sbuf.append("::");
                    }
                } else {
                    sbuf.append(':');
                }
                if (x != 0 || i >= 14) {
                    sbuf.append(Integer.toHexString(x).toUpperCase());
                }
                i += 2;
            }
        }
        while (true) {
            sbuf.append(this.addr[i] & 0xFF);
            if (++i == len) break;
            sbuf.append('.');
        }
        return sbuf.toString();
    }

    public int hashCode() {
        int i;
        int hash = 0;
        int len = this.addr.length;
        int n = i = len > 4 ? len - 4 : 0;
        while (i < len) {
            hash = hash << 8 | this.addr[i] & 0xFF;
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof InetAddress)) {
            return false;
        }
        byte[] addr1 = this.addr;
        byte[] addr2 = ((InetAddress)obj).addr;
        if (addr1.length != addr2.length) {
            return false;
        }
        int i = addr1.length;
        while (--i >= 0) {
            if (addr1[i] == addr2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getHostName() + '/' + this.getHostAddress();
    }

    private static native byte[] aton(String var0);

    private static native InetAddress[] lookup(String var0, InetAddress var1, boolean var2);

    public static InetAddress getByName(String host) throws UnknownHostException {
        if (host == null) {
            return InetAddress.getLocalHost();
        }
        byte[] address = InetAddress.aton(host);
        if (address != null) {
            return new InetAddress(address, null);
        }
        InetAddress iaddr = new InetAddress(null, host);
        InetAddress.lookup(host, iaddr, false);
        return iaddr;
    }

    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        byte[] address = InetAddress.aton(host);
        if (address != null) {
            InetAddress[] result = new InetAddress[]{new InetAddress(address, null)};
            return result;
        }
        return InetAddress.lookup(host, null, true);
    }

    private static native String getLocalHostname();

    public static InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager s = System.getSecurityManager();
        if (localhost == null || s != null && InetAddress.localhost.addr != localhostAddress) {
            InetAddress.getLocalHost(s);
        }
        return localhost;
    }

    private static synchronized void getLocalHost(SecurityManager s) throws UnknownHostException {
        if (s == null && localhost != null) {
            return;
        }
        String hostname = InetAddress.getLocalHostname();
        if (s != null) {
            try {
                s.checkConnect(hostname, -1);
            }
            catch (SecurityException ex) {
                hostname = null;
            }
        }
        if (hostname != null) {
            try {
                localhost = new InetAddress(null, null);
                InetAddress.lookup(hostname, localhost, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (localhost == null) {
            localhost = new InetAddress(localhostAddress, "localhost");
        }
    }
}

