/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.beans.BeanInfoEmbryo;
import gnu.java.beans.ExplicitBeanInfo;
import gnu.java.beans.IntrospectionIncubator;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.ExplicitInfo;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Hashtable;

public class Introspector {
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int IGNORE_ALL_BEANINFO = 3;
    static String[] beanInfoSearchPath = new String[]{"gnu.java.beans.info"};
    static Hashtable beanInfoCache = new Hashtable();

    private Introspector() {
    }

    public static BeanInfo getBeanInfo(Class beanClass) throws IntrospectionException {
        Class clazz = beanClass;
        synchronized (clazz) {
            BeanInfo beanInfo;
            try {
                BeanInfo cachedInfo = (BeanInfo)beanInfoCache.get(beanClass);
                if (cachedInfo != null) {
                    BeanInfo beanInfo2 = cachedInfo;
                    Object var4_5 = null;
                    return beanInfo2;
                }
                cachedInfo = Introspector.getBeanInfo(beanClass, null);
                beanInfoCache.put(beanClass, cachedInfo);
                beanInfo = cachedInfo;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                throw throwable;
            }
            Object var4_6 = null;
            return beanInfo;
        }
    }

    public static BeanInfo getBeanInfo(Class beanClass, Class stopClass) throws IntrospectionException {
        MethodDescriptor[] m;
        EventSetDescriptor[] e;
        ExplicitInfo explicit = new ExplicitInfo(beanClass, stopClass);
        IntrospectionIncubator ii = new IntrospectionIncubator();
        ii.setPropertyStopClass(explicit.propertyStopClass);
        ii.setEventStopClass(explicit.eventStopClass);
        ii.setMethodStopClass(explicit.methodStopClass);
        ii.addMethods(beanClass.getMethods());
        BeanInfoEmbryo currentInfo = ii.getBeanInfoEmbryo();
        PropertyDescriptor[] p = explicit.explicitPropertyDescriptors;
        if (p != null) {
            for (int i = 0; i < p.length; ++i) {
                if (currentInfo.hasProperty(p[i])) continue;
                currentInfo.addProperty(p[i]);
            }
            if (explicit.defaultProperty != -1) {
                currentInfo.setDefaultPropertyName(p[explicit.defaultProperty].getName());
            }
        }
        if ((e = explicit.explicitEventSetDescriptors) != null) {
            for (int i = 0; i < e.length; ++i) {
                if (currentInfo.hasEvent(e[i])) continue;
                currentInfo.addEvent(e[i]);
            }
            if (explicit.defaultEvent != -1) {
                currentInfo.setDefaultEventName(e[explicit.defaultEvent].getName());
            }
        }
        if ((m = explicit.explicitMethodDescriptors) != null) {
            for (int i = 0; i < m.length; ++i) {
                if (currentInfo.hasMethod(m[i])) continue;
                currentInfo.addMethod(m[i]);
            }
        }
        if (explicit.explicitBeanDescriptor != null) {
            currentInfo.setBeanDescriptor(new BeanDescriptor(beanClass, explicit.explicitBeanDescriptor.getCustomizerClass()));
        } else {
            currentInfo.setBeanDescriptor(new BeanDescriptor(beanClass, null));
        }
        currentInfo.setAdditionalBeanInfo(explicit.explicitBeanInfo);
        currentInfo.setIcons(explicit.im);
        return currentInfo.getBeanInfo();
    }

    public static String[] getBeanInfoSearchPath() {
        return beanInfoSearchPath;
    }

    public static void setBeanInfoSearchPath(String[] beanInfoSearchPath) {
        Introspector.beanInfoSearchPath = beanInfoSearchPath;
    }

    public static String decapitalize(String name) {
        try {
            if (!Character.isUpperCase(name.charAt(0))) {
                return name;
            }
            try {
                if (Character.isUpperCase(name.charAt(1))) {
                    return name;
                }
                char[] c = name.toCharArray();
                c[0] = Character.toLowerCase(c[0]);
                return new String(c);
            }
            catch (StringIndexOutOfBoundsException E) {
                char[] c = new char[]{Character.toLowerCase(name.charAt(0))};
                return new String(c);
            }
        }
        catch (StringIndexOutOfBoundsException E) {
            return name;
        }
        catch (NullPointerException E) {
            return null;
        }
    }

    static BeanInfo copyBeanInfo(BeanInfo b) {
        Image[] icons = new Image[4];
        for (int i = 1; i <= 4; ++i) {
            icons[i - 1] = b.getIcon(i);
        }
        return new ExplicitBeanInfo(b.getBeanDescriptor(), b.getAdditionalBeanInfo(), b.getPropertyDescriptors(), b.getDefaultPropertyIndex(), b.getEventSetDescriptors(), b.getDefaultEventIndex(), b.getMethodDescriptors(), icons);
    }
}

