/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#ifndef RESOURCES_H
#define	RESOURCES_H

/* Resources */
static XtResource	resources[] =
       {{"rootDir",		"RootDir",
	 XtRString,		sizeof(String), 
	 XtOffsetOf(xfm_struct,root_dir),
	 XtRString,		NULL},
	{"iconDir",		"IconDir",
	 XtRString,		sizeof(String), 
	 XtOffsetOf(xfm_struct,icon_dir),
	 XtRString,		ICON_DIR},
	{"trashcan",		"Trashcan",
	 XtRString,		sizeof(String), 
	 XtOffsetOf(xfm_struct,trashcan),
	 XtRString,		DEFAULT_TRASHCAN},
	{"doubleClickInterval",	"DoubleClickInterval",
	 XtRDimension, 		sizeof(Dimension),
	 XtOffsetOf(xfm_struct,click_interval),
	 XtRImmediate, 		(XtPointer) MAX_INTERVAL},
	{"selectColor", 	"SelectColor",
	 XtRPixel, 		sizeof(Pixel),
	 XtOffsetOf(xfm_struct,select_color),
	 XtRString, 		(XtPointer) "steelblue"},
	{"iconFont",		"IconFont",
	 XtRFontStruct,		sizeof(XFontStruct *),
	 XtOffsetOf(xfm_struct,icon_font),
	 XtRString,		DEFAULT_ICON_FONT},
	{"multiWindow",		"MulitWindow",
	 XtRBoolean,		sizeof(Boolean),
	 XtOffsetOf(xfm_struct,multi_window),
	 XtRImmediate,		(XtPointer) TRUE},
	{"dragCopyAsk",		"DragCopyAsk",
	 XtRBoolean,		sizeof(Boolean),
	 XtOffsetOf(xfm_struct,drag_copy),
	 XtRImmediate,		(XtPointer) TRUE},
	{"dragMoveAsk",		"DragMoveAsk",
	 XtRBoolean,		sizeof(Boolean),
	 XtOffsetOf(xfm_struct,drag_move),
	 XtRImmediate,		(XtPointer) TRUE},
	{"dragExecAsk",		"DragExecAsk",
	 XtRBoolean,		sizeof(Boolean),
	 XtOffsetOf(xfm_struct,drag_exec),
	 XtRImmediate,		(XtPointer) TRUE},
	{"dragDeleteAsk",	"DragDeleteAsk",
	 XtRBoolean,		sizeof(Boolean),
	 XtOffsetOf(xfm_struct,drag_delete),
	 XtRImmediate,		(XtPointer) TRUE},
	{"saveWSOnExit",	"SaveWSOnExit",
	 XtRBoolean,		sizeof(Boolean),
	 XtOffsetOf(xfm_struct,save_ws_on_exit),
	 XtRImmediate,		(XtPointer) FALSE},
	{"iconGrid",		"IconGrid",
	 XtRDimension, 		sizeof(Dimension),
	 XtOffsetOf(xfm_struct,icon_grid),
	 XtRImmediate, 		(XtPointer) 75},
	{"snapGrid",		"snapGrid",
	 XtRDimension, 		sizeof(Dimension),
	 XtOffsetOf(xfm_struct,snap_grid),
	 XtRImmediate, 		(XtPointer) 1},
};


/*
 * Options
 */
static XrmOptionDescRec	options[] =
       {{"-rootDir", ".rootDir", XrmoptionSepArg, (caddr_t) NULL},
	{"-iconDir", ".iconDir", XrmoptionSepArg, (caddr_t) NULL},
	{"-trashcan", ".trashcan", XrmoptionSepArg, (caddr_t) "~/tmp"},
	{"-iconFont", ".iconFont", XrmoptionSepArg, (caddr_t) NULL},
	{"-selectColor", ".selectColor", XrmoptionSepArg, (caddr_t) NULL},
	{"-doubleClickInterval", ".doubleClickInterval", XrmoptionSepArg, (caddr_t) NULL},
	{"-multiWindow", ".multiWindow", XrmoptionNoArg, (caddr_t) "TRUE"},
	{"-singleWindow", ".multiWindow", XrmoptionNoArg, (caddr_t) "FALSE"},
	{"-noDragCopyAsk", ".dragCopyAsk", XrmoptionNoArg, (caddr_t) "FALSE"},
	{"-noDragMoveAsk", ".dragMoveAsk", XrmoptionNoArg, (caddr_t) "FALSE"},
	{"-noDragExecAsk", ".dragExecAsk", XrmoptionNoArg, (caddr_t) "FALSE"},
	{"-noDragDeleteAsk", ".dragDeleteAsk", XrmoptionNoArg, (caddr_t) "FALSE"},
	{"-saveWS", ".saveWSOnExit", XrmoptionNoArg, (caddr_t) "TRUE"},
       };


#endif
