// RUN: %dxc -Tlib_6_3 -Wno-unused-value -verify %s
// RUN: %dxc -Tps_6_0 -Wno-unused-value -verify %s

// To test with the classic compiler, run
// %sdxroot%\tools\x86\fxc.exe /T ps_5_1 uint4add3.hlsl
// :FXC_VERIFY_ARGUMENTS: /E main /T ps_5_1

// we use -Wno-unused-value because we generate some no-op expressions to yield errors
// without also putting them in a static assertion

/*<py>
import re
rxComments = re.compile(r'(//.*|/\*.*?\*\/)')
def strip_comments(line):
    line = rxComments.sub('', line)
    return line.strip()
def save_error_comments(lines):
    saved = {}
    for line in lines:
        key = strip_comments(line)
        if key and line.strip() != key:
            saved[key] = line
    return saved
def restore_error_comments(saved, lines):
    return [saved.get(line.strip(), line) for line in lines]
def modify(lines, newlines):
    return restore_error_comments(save_error_comments(lines), newlines)

vars = [('float%s' % n, 'f%s' % n) for n in ('', '1', '2', '4')]
vars += [('float%dx%d' % (r,c), 'm%dx%d' % (r,c)) for c in (1,2,4) for r in (1,2,4)]
def gen_code():
    lines = ['%s %s = 0;' % v for v in vars]
    for lt, lv in vars:
      for rt, rv in vars:
        lines.append('%s = %s + %s;' % (lv, lv, rv))
        lines.append('%s += %s;' % (lv, rv))
        lines.append('%s = %s + (%s)%s;' % (lv, lv, lt, rv))
        lines.append('%s += (%s)%s;' % (lv, lt, rv))
    return lines
</py>*/

[shader("pixel")]
float4 main(float4 a : A, float3 c :C) : SV_TARGET {

  // <py::lines('GENERATED_CODE')>modify(lines, gen_code())</py>
  // GENERATED_CODE:BEGIN
  float f = 0;
  float1 f1 = 0;
  float2 f2 = 0;
  float4 f4 = 0;
  float1x1 m1x1 = 0;
  float2x1 m2x1 = 0;
  float4x1 m4x1 = 0;
  float1x2 m1x2 = 0;
  float2x2 m2x2 = 0;
  float4x2 m4x2 = 0;
  float1x4 m1x4 = 0;
  float2x4 m2x4 = 0;
  float4x4 m4x4 = 0;
  f = f + f;
  f += f;
  f = f + (float)f;
  f += (float)f;
  f = f + f1;
  f += f1;
  f = f + (float)f1;
  f += (float)f1;
  f = f + f2;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f += f2;                                                  /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f = f + (float)f2;
  f += (float)f2;
  f = f + f4;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f += f4;                                                  /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f = f + (float)f4;
  f += (float)f4;
  f = f + m1x1;
  f += m1x1;
  f = f + (float)m1x1;
  f += (float)m1x1;
  f = f + m2x1;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f += m2x1;                                                /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f = f + (float)m2x1;
  f += (float)m2x1;
  f = f + m4x1;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f += m4x1;                                                /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f = f + (float)m4x1;
  f += (float)m4x1;
  f = f + m1x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f += m1x2;                                                /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f = f + (float)m1x2;
  f += (float)m1x2;
  f = f + m2x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f += m2x2;                                                /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f = f + (float)m2x2;
  f += (float)m2x2;
  f = f + m4x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f += m4x2;                                                /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f = f + (float)m4x2;
  f += (float)m4x2;
  f = f + m1x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f += m1x4;                                                /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f = f + (float)m1x4;
  f += (float)m1x4;
  f = f + m2x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f += m2x4;                                                /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f = f + (float)m2x4;
  f += (float)m2x4;
  f = f + m4x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f += m4x4;                                                /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f = f + (float)m4x4;
  f += (float)m4x4;
  f1 = f1 + f;
  f1 += f;
  f1 = f1 + (float1)f;
  f1 += (float1)f;
  f1 = f1 + f1;
  f1 += f1;
  f1 = f1 + (float1)f1;
  f1 += (float1)f1;
  f1 = f1 + f2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 += f2;                                                 /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 = f1 + (float1)f2;
  f1 += (float1)f2;
  f1 = f1 + f4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 += f4;                                                 /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 = f1 + (float1)f4;
  f1 += (float1)f4;
  f1 = f1 + m1x1;
  f1 += m1x1;
  f1 = f1 + (float1)m1x1;
  f1 += (float1)m1x1;
  f1 = f1 + m2x1;                                           /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 += m2x1;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 = f1 + (float1)m2x1;
  f1 += (float1)m2x1;
  f1 = f1 + m4x1;                                           /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 += m4x1;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 = f1 + (float1)m4x1;
  f1 += (float1)m4x1;
  f1 = f1 + m1x2;                                           /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 += m1x2;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 = f1 + (float1)m1x2;
  f1 += (float1)m1x2;
  f1 = f1 + m2x2;                                           /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 += m2x2;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 = f1 + (float1)m2x2;
  f1 += (float1)m2x2;
  f1 = f1 + m4x2;                                           /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 += m4x2;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 = f1 + (float1)m4x2;
  f1 += (float1)m4x2;
  f1 = f1 + m1x4;                                           /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 += m1x4;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 = f1 + (float1)m1x4;
  f1 += (float1)m1x4;
  f1 = f1 + m2x4;                                           /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 += m2x4;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 = f1 + (float1)m2x4;
  f1 += (float1)m2x4;
  f1 = f1 + m4x4;                                           /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 += m4x4;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f1 = f1 + (float1)m4x4;
  f1 += (float1)m4x4;
  f2 = f2 + f;
  f2 += f;
  f2 = f2 + (float2)f;
  f2 += (float2)f;
  f2 = f2 + f1;
  f2 += f1;
  f2 = f2 + (float2)f1;
  f2 += (float2)f1;
  f2 = f2 + f2;
  f2 += f2;
  f2 = f2 + (float2)f2;
  f2 += (float2)f2;
  f2 = f2 + f4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f2 += f4;                                                 /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f2 = f2 + (float2)f4;
  f2 += (float2)f4;
  f2 = f2 + m1x1;
  f2 += m1x1;
  f2 = f2 + (float2)m1x1;
  f2 += (float2)m1x1;
  f2 = f2 + m2x1;
  f2 += m2x1;
  f2 = f2 + (float2)m2x1;
  f2 += (float2)m2x1;
  f2 = f2 + m4x1;                                           /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f2 += m4x1;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f2 = f2 + (float2)m4x1;
  f2 += (float2)m4x1;
  f2 = f2 + m1x2;
  f2 += m1x2;
  f2 = f2 + (float2)m1x2;
  f2 += (float2)m1x2;
  f2 = f2 + m2x2;                                           /* expected-error {{cannot convert from 'float2x2' to 'float2'}} fxc-error {{X3020: type mismatch}} */
  f2 += m2x2;                                               /* expected-error {{cannot convert from 'float2x2' to 'float2'}} fxc-error {{X3020: type mismatch}} */
  f2 = f2 + (float2)m2x2;                                   /* expected-error {{cannot convert from 'float2x2' to 'float2'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float2'}} */
  f2 += (float2)m2x2;                                       /* expected-error {{cannot convert from 'float2x2' to 'float2'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float2'}} */
  f2 = f2 + m4x2;                                           /* expected-error {{cannot convert from 'float4x2' to 'float2'}} fxc-error {{X3020: type mismatch}} */
  f2 += m4x2;                                               /* expected-error {{cannot convert from 'float4x2' to 'float2'}} fxc-error {{X3020: type mismatch}} */
  f2 = f2 + (float2)m4x2;                                   /* expected-error {{cannot convert from 'float4x2' to 'float2'}} fxc-error {{X3017: cannot convert from 'float4x2' to 'float2'}} */
  f2 += (float2)m4x2;                                       /* expected-error {{cannot convert from 'float4x2' to 'float2'}} fxc-error {{X3017: cannot convert from 'float4x2' to 'float2'}} */
  f2 = f2 + m1x4;                                           /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f2 += m1x4;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f2 = f2 + (float2)m1x4;
  f2 += (float2)m1x4;
  f2 = f2 + m2x4;                                           /* expected-error {{cannot convert from 'float2x4' to 'float2'}} fxc-error {{X3020: type mismatch}} */
  f2 += m2x4;                                               /* expected-error {{cannot convert from 'float2x4' to 'float2'}} fxc-error {{X3020: type mismatch}} */
  f2 = f2 + (float2)m2x4;                                   /* expected-error {{cannot convert from 'float2x4' to 'float2'}} fxc-error {{X3017: cannot convert from 'float2x4' to 'float2'}} */
  f2 += (float2)m2x4;                                       /* expected-error {{cannot convert from 'float2x4' to 'float2'}} fxc-error {{X3017: cannot convert from 'float2x4' to 'float2'}} */
  f2 = f2 + m4x4;                                           /* expected-error {{cannot convert from 'float4x4' to 'float2'}} fxc-error {{X3020: type mismatch}} */
  f2 += m4x4;                                               /* expected-error {{cannot convert from 'float4x4' to 'float2'}} fxc-error {{X3020: type mismatch}} */
  f2 = f2 + (float2)m4x4;                                   /* expected-error {{cannot convert from 'float4x4' to 'float2'}} fxc-error {{X3017: cannot convert from 'float4x4' to 'float2'}} */
  f2 += (float2)m4x4;                                       /* expected-error {{cannot convert from 'float4x4' to 'float2'}} fxc-error {{X3017: cannot convert from 'float4x4' to 'float2'}} */
  f4 = f4 + f;
  f4 += f;
  f4 = f4 + (float4)f;
  f4 += (float4)f;
  f4 = f4 + f1;
  f4 += f1;
  f4 = f4 + (float4)f1;
  f4 += (float4)f1;
  f4 = f4 + f2;                                             /* expected-error {{cannot convert from 'float2' to 'float4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f4 += f2;                                                 /* expected-error {{cannot convert from 'float2' to 'float4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f4 = f4 + (float4)f2;                                     /* expected-error {{cannot convert from 'float2' to 'float4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4'}} */
  f4 += (float4)f2;                                         /* expected-error {{cannot convert from 'float2' to 'float4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4'}} */
  f4 = f4 + f4;
  f4 += f4;
  f4 = f4 + (float4)f4;
  f4 += (float4)f4;
  f4 = f4 + m1x1;
  f4 += m1x1;
  f4 = f4 + (float4)m1x1;
  f4 += (float4)m1x1;
  f4 = f4 + m2x1;                                           /* expected-error {{cannot convert from 'float2x1' to 'float4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f4 += m2x1;                                               /* expected-error {{cannot convert from 'float2x1' to 'float4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f4 = f4 + (float4)m2x1;                                   /* expected-error {{cannot convert from 'float2x1' to 'float4'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float4'}} */
  f4 += (float4)m2x1;                                       /* expected-error {{cannot convert from 'float2x1' to 'float4'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float4'}} */
  f4 = f4 + m4x1;
  f4 += m4x1;
  f4 = f4 + (float4)m4x1;
  f4 += (float4)m4x1;
  f4 = f4 + m1x2;                                           /* expected-error {{cannot convert from 'float1x2' to 'float4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f4 += m1x2;                                               /* expected-error {{cannot convert from 'float1x2' to 'float4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  f4 = f4 + (float4)m1x2;                                   /* expected-error {{cannot convert from 'float1x2' to 'float4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4'}} */
  f4 += (float4)m1x2;                                       /* expected-error {{cannot convert from 'float1x2' to 'float4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4'}} */
  f4 = f4 + m2x2;
  f4 += m2x2;
  f4 = f4 + (float4)m2x2;
  f4 += (float4)m2x2;
  f4 = f4 + m4x2;                                           /* expected-error {{cannot convert from 'float4x2' to 'float4'}} fxc-error {{X3020: type mismatch}} */
  f4 += m4x2;                                               /* expected-error {{cannot convert from 'float4x2' to 'float4'}} fxc-error {{X3020: type mismatch}} */
  f4 = f4 + (float4)m4x2;                                   /* expected-error {{cannot convert from 'float4x2' to 'float4'}} fxc-error {{X3017: cannot convert from 'float4x2' to 'float4'}} */
  f4 += (float4)m4x2;                                       /* expected-error {{cannot convert from 'float4x2' to 'float4'}} fxc-error {{X3017: cannot convert from 'float4x2' to 'float4'}} */
  f4 = f4 + m1x4;
  f4 += m1x4;
  f4 = f4 + (float4)m1x4;
  f4 += (float4)m1x4;
  f4 = f4 + m2x4;                                           /* expected-error {{cannot convert from 'float2x4' to 'float4'}} fxc-error {{X3020: type mismatch}} */
  f4 += m2x4;                                               /* expected-error {{cannot convert from 'float2x4' to 'float4'}} fxc-error {{X3020: type mismatch}} */
  f4 = f4 + (float4)m2x4;                                   /* expected-error {{cannot convert from 'float2x4' to 'float4'}} fxc-error {{X3017: cannot convert from 'float2x4' to 'float4'}} */
  f4 += (float4)m2x4;                                       /* expected-error {{cannot convert from 'float2x4' to 'float4'}} fxc-error {{X3017: cannot convert from 'float2x4' to 'float4'}} */
  f4 = f4 + m4x4;                                           /* expected-error {{cannot convert from 'float4x4' to 'float4'}} fxc-error {{X3020: type mismatch}} */
  f4 += m4x4;                                               /* expected-error {{cannot convert from 'float4x4' to 'float4'}} fxc-error {{X3020: type mismatch}} */
  f4 = f4 + (float4)m4x4;                                   /* expected-error {{cannot convert from 'float4x4' to 'float4'}} fxc-error {{X3017: cannot convert from 'float4x4' to 'float4'}} */
  f4 += (float4)m4x4;                                       /* expected-error {{cannot convert from 'float4x4' to 'float4'}} fxc-error {{X3017: cannot convert from 'float4x4' to 'float4'}} */
  m1x1 = m1x1 + f;
  m1x1 += f;
  m1x1 = m1x1 + (float1x1)f;
  m1x1 += (float1x1)f;
  m1x1 = m1x1 + f1;
  m1x1 += f1;
  m1x1 = m1x1 + (float1x1)f1;
  m1x1 += (float1x1)f1;
  m1x1 = m1x1 + f2;                                         /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 += f2;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 = m1x1 + (float1x1)f2;
  m1x1 += (float1x1)f2;
  m1x1 = m1x1 + f4;                                         /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 += f4;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 = m1x1 + (float1x1)f4;
  m1x1 += (float1x1)f4;
  m1x1 = m1x1 + m1x1;
  m1x1 += m1x1;
  m1x1 = m1x1 + (float1x1)m1x1;
  m1x1 += (float1x1)m1x1;
  m1x1 = m1x1 + m2x1;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 += m2x1;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 = m1x1 + (float1x1)m2x1;
  m1x1 += (float1x1)m2x1;
  m1x1 = m1x1 + m4x1;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 += m4x1;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 = m1x1 + (float1x1)m4x1;
  m1x1 += (float1x1)m4x1;
  m1x1 = m1x1 + m1x2;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 += m1x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 = m1x1 + (float1x1)m1x2;
  m1x1 += (float1x1)m1x2;
  m1x1 = m1x1 + m2x2;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 += m2x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 = m1x1 + (float1x1)m2x2;
  m1x1 += (float1x1)m2x2;
  m1x1 = m1x1 + m4x2;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 += m4x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 = m1x1 + (float1x1)m4x2;
  m1x1 += (float1x1)m4x2;
  m1x1 = m1x1 + m1x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 += m1x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 = m1x1 + (float1x1)m1x4;
  m1x1 += (float1x1)m1x4;
  m1x1 = m1x1 + m2x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 += m2x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 = m1x1 + (float1x1)m2x4;
  m1x1 += (float1x1)m2x4;
  m1x1 = m1x1 + m4x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 += m4x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x1 = m1x1 + (float1x1)m4x4;
  m1x1 += (float1x1)m4x4;
  m2x1 = m2x1 + f;
  m2x1 += f;
  m2x1 = m2x1 + (float2x1)f;
  m2x1 += (float2x1)f;
  m2x1 = m2x1 + f1;
  m2x1 += f1;
  m2x1 = m2x1 + (float2x1)f1;
  m2x1 += (float2x1)f1;
  m2x1 = m2x1 + f2;
  m2x1 += f2;
  m2x1 = m2x1 + (float2x1)f2;
  m2x1 += (float2x1)f2;
  m2x1 = m2x1 + f4;                                         /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 += f4;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 = m2x1 + (float2x1)f4;
  m2x1 += (float2x1)f4;
  m2x1 = m2x1 + m1x1;
  m2x1 += m1x1;
  m2x1 = m2x1 + (float2x1)m1x1;
  m2x1 += (float2x1)m1x1;
  m2x1 = m2x1 + m2x1;
  m2x1 += m2x1;
  m2x1 = m2x1 + (float2x1)m2x1;
  m2x1 += (float2x1)m2x1;
  m2x1 = m2x1 + m4x1;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 += m4x1;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 = m2x1 + (float2x1)m4x1;
  m2x1 += (float2x1)m4x1;
  m2x1 = m2x1 + m1x2;                                       /* expected-error {{cannot convert from 'float1x2' to 'float2x1'}} fxc-error {{X3020: type mismatch}} */
  m2x1 += m1x2;                                             /* expected-error {{cannot convert from 'float1x2' to 'float2x1'}} fxc-error {{X3020: type mismatch}} */
  m2x1 = m2x1 + (float2x1)m1x2;                             /* expected-error {{cannot convert from 'float1x2' to 'float2x1'}} fxc-error {{X3017: cannot convert from 'float2' to 'float2x1'}} */
  m2x1 += (float2x1)m1x2;                                   /* expected-error {{cannot convert from 'float1x2' to 'float2x1'}} fxc-error {{X3017: cannot convert from 'float2' to 'float2x1'}} */
  m2x1 = m2x1 + m2x2;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 += m2x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 = m2x1 + (float2x1)m2x2;
  m2x1 += (float2x1)m2x2;
  m2x1 = m2x1 + m4x2;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 += m4x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 = m2x1 + (float2x1)m4x2;
  m2x1 += (float2x1)m4x2;
  m2x1 = m2x1 + m1x4;                                       /* expected-error {{cannot convert from 'float1x4' to 'float2x1'}} fxc-error {{X3020: type mismatch}} */
  m2x1 += m1x4;                                             /* expected-error {{cannot convert from 'float1x4' to 'float2x1'}} fxc-error {{X3020: type mismatch}} */
  m2x1 = m2x1 + (float2x1)m1x4;                             /* expected-error {{cannot convert from 'float1x4' to 'float2x1'}} fxc-error {{X3017: cannot convert from 'float4' to 'float2x1'}} */
  m2x1 += (float2x1)m1x4;                                   /* expected-error {{cannot convert from 'float1x4' to 'float2x1'}} fxc-error {{X3017: cannot convert from 'float4' to 'float2x1'}} */
  m2x1 = m2x1 + m2x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 += m2x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 = m2x1 + (float2x1)m2x4;
  m2x1 += (float2x1)m2x4;
  m2x1 = m2x1 + m4x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 += m4x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x1 = m2x1 + (float2x1)m4x4;
  m2x1 += (float2x1)m4x4;
  m4x1 = m4x1 + f;
  m4x1 += f;
  m4x1 = m4x1 + (float4x1)f;
  m4x1 += (float4x1)f;
  m4x1 = m4x1 + f1;
  m4x1 += f1;
  m4x1 = m4x1 + (float4x1)f1;
  m4x1 += (float4x1)f1;
  m4x1 = m4x1 + f2;                                         /* expected-error {{cannot convert from 'float2' to 'float4x1'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4x1'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x1 += f2;                                               /* expected-error {{cannot convert from 'float2' to 'float4x1'}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4x1'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x1 = m4x1 + (float4x1)f2;                               /* expected-error {{cannot convert from 'float2' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x1'}} */
  m4x1 += (float4x1)f2;                                     /* expected-error {{cannot convert from 'float2' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x1'}} */
  m4x1 = m4x1 + f4;
  m4x1 += f4;
  m4x1 = m4x1 + (float4x1)f4;
  m4x1 += (float4x1)f4;
  m4x1 = m4x1 + m1x1;
  m4x1 += m1x1;
  m4x1 = m4x1 + (float4x1)m1x1;
  m4x1 += (float4x1)m1x1;
  m4x1 = m4x1 + m2x1;                                       /* expected-error {{cannot convert from 'float2x1' to 'float4x1'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float4x1'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x1 += m2x1;                                             /* expected-error {{cannot convert from 'float2x1' to 'float4x1'}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float4x1'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x1 = m4x1 + (float4x1)m2x1;                             /* expected-error {{cannot convert from 'float2x1' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float4x1'}} */
  m4x1 += (float4x1)m2x1;                                   /* expected-error {{cannot convert from 'float2x1' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float4x1'}} */
  m4x1 = m4x1 + m4x1;
  m4x1 += m4x1;
  m4x1 = m4x1 + (float4x1)m4x1;
  m4x1 += (float4x1)m4x1;
  m4x1 = m4x1 + m1x2;                                       /* expected-error {{cannot convert from 'float1x2' to 'float4x1'}} fxc-error {{X3020: type mismatch}} */
  m4x1 += m1x2;                                             /* expected-error {{cannot convert from 'float1x2' to 'float4x1'}} fxc-error {{X3020: type mismatch}} */
  m4x1 = m4x1 + (float4x1)m1x2;                             /* expected-error {{cannot convert from 'float1x2' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x1'}} */
  m4x1 += (float4x1)m1x2;                                   /* expected-error {{cannot convert from 'float1x2' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x1'}} */
  m4x1 = m4x1 + m2x2;                                       /* expected-error {{cannot convert from 'float2x2' to 'float4x1'}} fxc-error {{X3020: type mismatch}} */
  m4x1 += m2x2;                                             /* expected-error {{cannot convert from 'float2x2' to 'float4x1'}} fxc-error {{X3020: type mismatch}} */
  m4x1 = m4x1 + (float4x1)m2x2;                             /* expected-error {{cannot convert from 'float2x2' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float4x1'}} */
  m4x1 += (float4x1)m2x2;                                   /* expected-error {{cannot convert from 'float2x2' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float4x1'}} */
  m4x1 = m4x1 + m4x2;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x1 += m4x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x1 = m4x1 + (float4x1)m4x2;
  m4x1 += (float4x1)m4x2;
  m4x1 = m4x1 + m1x4;                                       /* expected-error {{cannot convert from 'float1x4' to 'float4x1'}} fxc-error {{X3020: type mismatch}} */
  m4x1 += m1x4;                                             /* expected-error {{cannot convert from 'float1x4' to 'float4x1'}} fxc-error {{X3020: type mismatch}} */
  m4x1 = m4x1 + (float4x1)m1x4;                             /* expected-error {{cannot convert from 'float1x4' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float4' to 'float4x1'}} */
  m4x1 += (float4x1)m1x4;                                   /* expected-error {{cannot convert from 'float1x4' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float4' to 'float4x1'}} */
  m4x1 = m4x1 + m2x4;                                       /* expected-error {{cannot convert from 'float2x4' to 'float4x1'}} fxc-error {{X3020: type mismatch}} */
  m4x1 += m2x4;                                             /* expected-error {{cannot convert from 'float2x4' to 'float4x1'}} fxc-error {{X3020: type mismatch}} */
  m4x1 = m4x1 + (float4x1)m2x4;                             /* expected-error {{cannot convert from 'float2x4' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float2x4' to 'float4x1'}} */
  m4x1 += (float4x1)m2x4;                                   /* expected-error {{cannot convert from 'float2x4' to 'float4x1'}} fxc-error {{X3017: cannot convert from 'float2x4' to 'float4x1'}} */
  m4x1 = m4x1 + m4x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x1 += m4x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x1 = m4x1 + (float4x1)m4x4;
  m4x1 += (float4x1)m4x4;
  m1x2 = m1x2 + f;
  m1x2 += f;
  m1x2 = m1x2 + (float1x2)f;
  m1x2 += (float1x2)f;
  m1x2 = m1x2 + f1;
  m1x2 += f1;
  m1x2 = m1x2 + (float1x2)f1;
  m1x2 += (float1x2)f1;
  m1x2 = m1x2 + f2;
  m1x2 += f2;
  m1x2 = m1x2 + (float1x2)f2;
  m1x2 += (float1x2)f2;
  m1x2 = m1x2 + f4;                                         /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 += f4;                                               /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 = m1x2 + (float1x2)f4;
  m1x2 += (float1x2)f4;
  m1x2 = m1x2 + m1x1;
  m1x2 += m1x1;
  m1x2 = m1x2 + (float1x2)m1x1;
  m1x2 += (float1x2)m1x1;
  m1x2 = m1x2 + m2x1;                                       /* expected-error {{cannot convert from 'float2x1' to 'float1x2'}} fxc-error {{X3020: type mismatch}} */
  m1x2 += m2x1;                                             /* expected-error {{cannot convert from 'float2x1' to 'float1x2'}} fxc-error {{X3020: type mismatch}} */
  m1x2 = m1x2 + (float1x2)m2x1;                             /* expected-error {{cannot convert from 'float2x1' to 'float1x2'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float2'}} */
  m1x2 += (float1x2)m2x1;                                   /* expected-error {{cannot convert from 'float2x1' to 'float1x2'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float2'}} */
  m1x2 = m1x2 + m4x1;                                       /* expected-error {{cannot convert from 'float4x1' to 'float1x2'}} fxc-error {{X3020: type mismatch}} */
  m1x2 += m4x1;                                             /* expected-error {{cannot convert from 'float4x1' to 'float1x2'}} fxc-error {{X3020: type mismatch}} */
  m1x2 = m1x2 + (float1x2)m4x1;                             /* expected-error {{cannot convert from 'float4x1' to 'float1x2'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float2'}} */
  m1x2 += (float1x2)m4x1;                                   /* expected-error {{cannot convert from 'float4x1' to 'float1x2'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float2'}} */
  m1x2 = m1x2 + m1x2;
  m1x2 += m1x2;
  m1x2 = m1x2 + (float1x2)m1x2;
  m1x2 += (float1x2)m1x2;
  m1x2 = m1x2 + m2x2;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 += m2x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 = m1x2 + (float1x2)m2x2;
  m1x2 += (float1x2)m2x2;
  m1x2 = m1x2 + m4x2;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 += m4x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 = m1x2 + (float1x2)m4x2;
  m1x2 += (float1x2)m4x2;
  m1x2 = m1x2 + m1x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 += m1x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 = m1x2 + (float1x2)m1x4;
  m1x2 += (float1x2)m1x4;
  m1x2 = m1x2 + m2x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 += m2x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 = m1x2 + (float1x2)m2x4;
  m1x2 += (float1x2)m2x4;
  m1x2 = m1x2 + m4x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 += m4x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x2 = m1x2 + (float1x2)m4x4;
  m1x2 += (float1x2)m4x4;
  m2x2 = m2x2 + f;
  m2x2 += f;
  m2x2 = m2x2 + (float2x2)f;
  m2x2 += (float2x2)f;
  m2x2 = m2x2 + f1;
  m2x2 += f1;
  m2x2 = m2x2 + (float2x2)f1;
  m2x2 += (float2x2)f1;
  m2x2 = m2x2 + f2;                                         /* expected-error {{cannot convert from 'float2' to 'float2x2'}} fxc-error {{X3020: type mismatch}} */
  m2x2 += f2;                                               /* expected-error {{cannot convert from 'float2' to 'float2x2'}} fxc-error {{X3020: type mismatch}} */
  m2x2 = m2x2 + (float2x2)f2;                               /* expected-error {{cannot convert from 'float2' to 'float2x2'}} fxc-error {{X3017: cannot convert from 'float2' to 'float2x2'}} */
  m2x2 += (float2x2)f2;                                     /* expected-error {{cannot convert from 'float2' to 'float2x2'}} fxc-error {{X3017: cannot convert from 'float2' to 'float2x2'}} */
  m2x2 = m2x2 + f4;
  m2x2 += f4;
  m2x2 = m2x2 + (float2x2)f4;
  m2x2 += (float2x2)f4;
  m2x2 = m2x2 + m1x1;
  m2x2 += m1x1;
  m2x2 = m2x2 + (float2x2)m1x1;
  m2x2 += (float2x2)m1x1;
  m2x2 = m2x2 + m2x1;                                       /* expected-error {{cannot convert from 'float2x1' to 'float2x2'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float2x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x2 += m2x1;                                             /* expected-error {{cannot convert from 'float2x1' to 'float2x2'}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float2x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x2 = m2x2 + (float2x2)m2x1;                             /* expected-error {{cannot convert from 'float2x1' to 'float2x2'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float2x2'}} */
  m2x2 += (float2x2)m2x1;                                   /* expected-error {{cannot convert from 'float2x1' to 'float2x2'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float2x2'}} */
  m2x2 = m2x2 + m4x1;                                       /* expected-error {{cannot convert from 'float4x1' to 'float2x2'}} fxc-error {{X3020: type mismatch}} */
  m2x2 += m4x1;                                             /* expected-error {{cannot convert from 'float4x1' to 'float2x2'}} fxc-error {{X3020: type mismatch}} */
  m2x2 = m2x2 + (float2x2)m4x1;                             /* expected-error {{cannot convert from 'float4x1' to 'float2x2'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float2x2'}} */
  m2x2 += (float2x2)m4x1;                                   /* expected-error {{cannot convert from 'float4x1' to 'float2x2'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float2x2'}} */
  m2x2 = m2x2 + m1x2;                                       /* expected-error {{cannot convert from 'float1x2' to 'float2x2'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float2x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x2 += m1x2;                                             /* expected-error {{cannot convert from 'float1x2' to 'float2x2'}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float2x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x2 = m2x2 + (float2x2)m1x2;                             /* expected-error {{cannot convert from 'float1x2' to 'float2x2'}} fxc-error {{X3017: cannot convert from 'float2' to 'float2x2'}} */
  m2x2 += (float2x2)m1x2;                                   /* expected-error {{cannot convert from 'float1x2' to 'float2x2'}} fxc-error {{X3017: cannot convert from 'float2' to 'float2x2'}} */
  m2x2 = m2x2 + m2x2;
  m2x2 += m2x2;
  m2x2 = m2x2 + (float2x2)m2x2;
  m2x2 += (float2x2)m2x2;
  m2x2 = m2x2 + m4x2;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x2 += m4x2;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x2 = m2x2 + (float2x2)m4x2;
  m2x2 += (float2x2)m4x2;
  m2x2 = m2x2 + m1x4;                                       /* expected-error {{cannot convert from 'float1x4' to 'float2x2'}} fxc-error {{X3020: type mismatch}} */
  m2x2 += m1x4;                                             /* expected-error {{cannot convert from 'float1x4' to 'float2x2'}} fxc-error {{X3020: type mismatch}} */
  m2x2 = m2x2 + (float2x2)m1x4;                             /* expected-error {{cannot convert from 'float1x4' to 'float2x2'}} fxc-error {{X3017: cannot convert from 'float4' to 'float2x2'}} */
  m2x2 += (float2x2)m1x4;                                   /* expected-error {{cannot convert from 'float1x4' to 'float2x2'}} fxc-error {{X3017: cannot convert from 'float4' to 'float2x2'}} */
  m2x2 = m2x2 + m2x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x2 += m2x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x2 = m2x2 + (float2x2)m2x4;
  m2x2 += (float2x2)m2x4;
  m2x2 = m2x2 + m4x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x2 += m4x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x2 = m2x2 + (float2x2)m4x4;
  m2x2 += (float2x2)m4x4;
  m4x2 = m4x2 + f;
  m4x2 += f;
  m4x2 = m4x2 + (float4x2)f;
  m4x2 += (float4x2)f;
  m4x2 = m4x2 + f1;
  m4x2 += f1;
  m4x2 = m4x2 + (float4x2)f1;
  m4x2 += (float4x2)f1;
  m4x2 = m4x2 + f2;                                         /* expected-error {{cannot convert from 'float2' to 'float4x2'}} fxc-error {{X3020: type mismatch}} */
  m4x2 += f2;                                               /* expected-error {{cannot convert from 'float2' to 'float4x2'}} fxc-error {{X3020: type mismatch}} */
  m4x2 = m4x2 + (float4x2)f2;                               /* expected-error {{cannot convert from 'float2' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x2'}} */
  m4x2 += (float4x2)f2;                                     /* expected-error {{cannot convert from 'float2' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x2'}} */
  m4x2 = m4x2 + f4;                                         /* expected-error {{cannot convert from 'float4' to 'float4x2'}} fxc-error {{X3020: type mismatch}} */
  m4x2 += f4;                                               /* expected-error {{cannot convert from 'float4' to 'float4x2'}} fxc-error {{X3020: type mismatch}} */
  m4x2 = m4x2 + (float4x2)f4;                               /* expected-error {{cannot convert from 'float4' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float4' to 'float4x2'}} */
  m4x2 += (float4x2)f4;                                     /* expected-error {{cannot convert from 'float4' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float4' to 'float4x2'}} */
  m4x2 = m4x2 + m1x1;
  m4x2 += m1x1;
  m4x2 = m4x2 + (float4x2)m1x1;
  m4x2 += (float4x2)m1x1;
  m4x2 = m4x2 + m2x1;                                       /* expected-error {{cannot convert from 'float2x1' to 'float4x2'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float4x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x2 += m2x1;                                             /* expected-error {{cannot convert from 'float2x1' to 'float4x2'}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float4x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x2 = m4x2 + (float4x2)m2x1;                             /* expected-error {{cannot convert from 'float2x1' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float4x2'}} */
  m4x2 += (float4x2)m2x1;                                   /* expected-error {{cannot convert from 'float2x1' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float4x2'}} */
  m4x2 = m4x2 + m4x1;                                       /* expected-error {{cannot convert from 'float4x1' to 'float4x2'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float4x1' to 'float4x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x2 += m4x1;                                             /* expected-error {{cannot convert from 'float4x1' to 'float4x2'}} fxc-error {{X3017: cannot implicitly convert from 'const float4x1' to 'float4x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x2 = m4x2 + (float4x2)m4x1;                             /* expected-error {{cannot convert from 'float4x1' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float4x2'}} */
  m4x2 += (float4x2)m4x1;                                   /* expected-error {{cannot convert from 'float4x1' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float4x2'}} */
  m4x2 = m4x2 + m1x2;                                       /* expected-error {{cannot convert from 'float1x2' to 'float4x2'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x2 += m1x2;                                             /* expected-error {{cannot convert from 'float1x2' to 'float4x2'}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x2 = m4x2 + (float4x2)m1x2;                             /* expected-error {{cannot convert from 'float1x2' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x2'}} */
  m4x2 += (float4x2)m1x2;                                   /* expected-error {{cannot convert from 'float1x2' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x2'}} */
  m4x2 = m4x2 + m2x2;                                       /* expected-error {{cannot convert from 'float2x2' to 'float4x2'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2x2' to 'float4x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x2 += m2x2;                                             /* expected-error {{cannot convert from 'float2x2' to 'float4x2'}} fxc-error {{X3017: cannot implicitly convert from 'const float2x2' to 'float4x2'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x2 = m4x2 + (float4x2)m2x2;                             /* expected-error {{cannot convert from 'float2x2' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float4x2'}} */
  m4x2 += (float4x2)m2x2;                                   /* expected-error {{cannot convert from 'float2x2' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float4x2'}} */
  m4x2 = m4x2 + m4x2;
  m4x2 += m4x2;
  m4x2 = m4x2 + (float4x2)m4x2;
  m4x2 += (float4x2)m4x2;
  m4x2 = m4x2 + m1x4;                                       /* expected-error {{cannot convert from 'float1x4' to 'float4x2'}} fxc-error {{X3020: type mismatch}} */
  m4x2 += m1x4;                                             /* expected-error {{cannot convert from 'float1x4' to 'float4x2'}} fxc-error {{X3020: type mismatch}} */
  m4x2 = m4x2 + (float4x2)m1x4;                             /* expected-error {{cannot convert from 'float1x4' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float4' to 'float4x2'}} */
  m4x2 += (float4x2)m1x4;                                   /* expected-error {{cannot convert from 'float1x4' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float4' to 'float4x2'}} */
  m4x2 = m4x2 + m2x4;                                       /* expected-error {{cannot convert from 'float2x4' to 'float4x2'}} fxc-error {{X3020: type mismatch}} */
  m4x2 += m2x4;                                             /* expected-error {{cannot convert from 'float2x4' to 'float4x2'}} fxc-error {{X3020: type mismatch}} */
  m4x2 = m4x2 + (float4x2)m2x4;                             /* expected-error {{cannot convert from 'float2x4' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float2x4' to 'float4x2'}} */
  m4x2 += (float4x2)m2x4;                                   /* expected-error {{cannot convert from 'float2x4' to 'float4x2'}} fxc-error {{X3017: cannot convert from 'float2x4' to 'float4x2'}} */
  m4x2 = m4x2 + m4x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x2 += m4x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x2 = m4x2 + (float4x2)m4x4;
  m4x2 += (float4x2)m4x4;
  m1x4 = m1x4 + f;
  m1x4 += f;
  m1x4 = m1x4 + (float1x4)f;
  m1x4 += (float1x4)f;
  m1x4 = m1x4 + f1;
  m1x4 += f1;
  m1x4 = m1x4 + (float1x4)f1;
  m1x4 += (float1x4)f1;
  m1x4 = m1x4 + f2;                                         /* expected-error {{cannot convert from 'float2' to 'float1x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x4 += f2;                                               /* expected-error {{cannot convert from 'float2' to 'float1x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x4 = m1x4 + (float1x4)f2;                               /* expected-error {{cannot convert from 'float2' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4'}} */
  m1x4 += (float1x4)f2;                                     /* expected-error {{cannot convert from 'float2' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4'}} */
  m1x4 = m1x4 + f4;
  m1x4 += f4;
  m1x4 = m1x4 + (float1x4)f4;
  m1x4 += (float1x4)f4;
  m1x4 = m1x4 + m1x1;
  m1x4 += m1x1;
  m1x4 = m1x4 + (float1x4)m1x1;
  m1x4 += (float1x4)m1x1;
  m1x4 = m1x4 + m2x1;                                       /* expected-error {{cannot convert from 'float2x1' to 'float1x4'}} fxc-error {{X3020: type mismatch}} */
  m1x4 += m2x1;                                             /* expected-error {{cannot convert from 'float2x1' to 'float1x4'}} fxc-error {{X3020: type mismatch}} */
  m1x4 = m1x4 + (float1x4)m2x1;                             /* expected-error {{cannot convert from 'float2x1' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float4'}} */
  m1x4 += (float1x4)m2x1;                                   /* expected-error {{cannot convert from 'float2x1' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float4'}} */
  m1x4 = m1x4 + m4x1;                                       /* expected-error {{cannot convert from 'float4x1' to 'float1x4'}} fxc-error {{X3020: type mismatch}} */
  m1x4 += m4x1;                                             /* expected-error {{cannot convert from 'float4x1' to 'float1x4'}} fxc-error {{X3020: type mismatch}} */
  m1x4 = m1x4 + (float1x4)m4x1;                             /* expected-error {{cannot convert from 'float4x1' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float4'}} */
  m1x4 += (float1x4)m4x1;                                   /* expected-error {{cannot convert from 'float4x1' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float4'}} */
  m1x4 = m1x4 + m1x2;                                       /* expected-error {{cannot convert from 'float1x2' to 'float1x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x4 += m1x2;                                             /* expected-error {{cannot convert from 'float1x2' to 'float1x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x4 = m1x4 + (float1x4)m1x2;                             /* expected-error {{cannot convert from 'float1x2' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4'}} */
  m1x4 += (float1x4)m1x2;                                   /* expected-error {{cannot convert from 'float1x2' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4'}} */
  m1x4 = m1x4 + m2x2;                                       /* expected-error {{cannot convert from 'float2x2' to 'float1x4'}} fxc-error {{X3020: type mismatch}} */
  m1x4 += m2x2;                                             /* expected-error {{cannot convert from 'float2x2' to 'float1x4'}} fxc-error {{X3020: type mismatch}} */
  m1x4 = m1x4 + (float1x4)m2x2;                             /* expected-error {{cannot convert from 'float2x2' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float4'}} */
  m1x4 += (float1x4)m2x2;                                   /* expected-error {{cannot convert from 'float2x2' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float4'}} */
  m1x4 = m1x4 + m4x2;                                       /* expected-error {{cannot convert from 'float4x2' to 'float1x4'}} fxc-error {{X3020: type mismatch}} */
  m1x4 += m4x2;                                             /* expected-error {{cannot convert from 'float4x2' to 'float1x4'}} fxc-error {{X3020: type mismatch}} */
  m1x4 = m1x4 + (float1x4)m4x2;                             /* expected-error {{cannot convert from 'float4x2' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float4x2' to 'float4'}} */
  m1x4 += (float1x4)m4x2;                                   /* expected-error {{cannot convert from 'float4x2' to 'float1x4'}} fxc-error {{X3017: cannot convert from 'float4x2' to 'float4'}} */
  m1x4 = m1x4 + m1x4;
  m1x4 += m1x4;
  m1x4 = m1x4 + (float1x4)m1x4;
  m1x4 += (float1x4)m1x4;
  m1x4 = m1x4 + m2x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x4 += m2x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x4 = m1x4 + (float1x4)m2x4;
  m1x4 += (float1x4)m2x4;
  m1x4 = m1x4 + m4x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x4 += m4x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m1x4 = m1x4 + (float1x4)m4x4;
  m1x4 += (float1x4)m4x4;
  m2x4 = m2x4 + f;
  m2x4 += f;
  m2x4 = m2x4 + (float2x4)f;
  m2x4 += (float2x4)f;
  m2x4 = m2x4 + f1;
  m2x4 += f1;
  m2x4 = m2x4 + (float2x4)f1;
  m2x4 += (float2x4)f1;
  m2x4 = m2x4 + f2;                                         /* expected-error {{cannot convert from 'float2' to 'float2x4'}} fxc-error {{X3020: type mismatch}} */
  m2x4 += f2;                                               /* expected-error {{cannot convert from 'float2' to 'float2x4'}} fxc-error {{X3020: type mismatch}} */
  m2x4 = m2x4 + (float2x4)f2;                               /* expected-error {{cannot convert from 'float2' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float2x4'}} */
  m2x4 += (float2x4)f2;                                     /* expected-error {{cannot convert from 'float2' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float2x4'}} */
  m2x4 = m2x4 + f4;                                         /* expected-error {{cannot convert from 'float4' to 'float2x4'}} fxc-error {{X3020: type mismatch}} */
  m2x4 += f4;                                               /* expected-error {{cannot convert from 'float4' to 'float2x4'}} fxc-error {{X3020: type mismatch}} */
  m2x4 = m2x4 + (float2x4)f4;                               /* expected-error {{cannot convert from 'float4' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float4' to 'float2x4'}} */
  m2x4 += (float2x4)f4;                                     /* expected-error {{cannot convert from 'float4' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float4' to 'float2x4'}} */
  m2x4 = m2x4 + m1x1;
  m2x4 += m1x1;
  m2x4 = m2x4 + (float2x4)m1x1;
  m2x4 += (float2x4)m1x1;
  m2x4 = m2x4 + m2x1;                                       /* expected-error {{cannot convert from 'float2x1' to 'float2x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float2x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x4 += m2x1;                                             /* expected-error {{cannot convert from 'float2x1' to 'float2x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float2x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x4 = m2x4 + (float2x4)m2x1;                             /* expected-error {{cannot convert from 'float2x1' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float2x4'}} */
  m2x4 += (float2x4)m2x1;                                   /* expected-error {{cannot convert from 'float2x1' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float2x4'}} */
  m2x4 = m2x4 + m4x1;                                       /* expected-error {{cannot convert from 'float4x1' to 'float2x4'}} fxc-error {{X3020: type mismatch}} */
  m2x4 += m4x1;                                             /* expected-error {{cannot convert from 'float4x1' to 'float2x4'}} fxc-error {{X3020: type mismatch}} */
  m2x4 = m2x4 + (float2x4)m4x1;                             /* expected-error {{cannot convert from 'float4x1' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float2x4'}} */
  m2x4 += (float2x4)m4x1;                                   /* expected-error {{cannot convert from 'float4x1' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float2x4'}} */
  m2x4 = m2x4 + m1x2;                                       /* expected-error {{cannot convert from 'float1x2' to 'float2x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float2x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x4 += m1x2;                                             /* expected-error {{cannot convert from 'float1x2' to 'float2x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float2x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x4 = m2x4 + (float2x4)m1x2;                             /* expected-error {{cannot convert from 'float1x2' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float2x4'}} */
  m2x4 += (float2x4)m1x2;                                   /* expected-error {{cannot convert from 'float1x2' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float2x4'}} */
  m2x4 = m2x4 + m2x2;                                       /* expected-error {{cannot convert from 'float2x2' to 'float2x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2x2' to 'float2x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x4 += m2x2;                                             /* expected-error {{cannot convert from 'float2x2' to 'float2x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2x2' to 'float2x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x4 = m2x4 + (float2x4)m2x2;                             /* expected-error {{cannot convert from 'float2x2' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float2x4'}} */
  m2x4 += (float2x4)m2x2;                                   /* expected-error {{cannot convert from 'float2x2' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float2x4'}} */
  m2x4 = m2x4 + m4x2;                                       /* expected-error {{cannot convert from 'float4x2' to 'float2x4'}} fxc-error {{X3020: type mismatch}} */
  m2x4 += m4x2;                                             /* expected-error {{cannot convert from 'float4x2' to 'float2x4'}} fxc-error {{X3020: type mismatch}} */
  m2x4 = m2x4 + (float2x4)m4x2;                             /* expected-error {{cannot convert from 'float4x2' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float4x2' to 'float2x4'}} */
  m2x4 += (float2x4)m4x2;                                   /* expected-error {{cannot convert from 'float4x2' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float4x2' to 'float2x4'}} */
  m2x4 = m2x4 + m1x4;                                       /* expected-error {{cannot convert from 'float1x4' to 'float2x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float4' to 'float2x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x4 += m1x4;                                             /* expected-error {{cannot convert from 'float1x4' to 'float2x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float4' to 'float2x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x4 = m2x4 + (float2x4)m1x4;                             /* expected-error {{cannot convert from 'float1x4' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float4' to 'float2x4'}} */
  m2x4 += (float2x4)m1x4;                                   /* expected-error {{cannot convert from 'float1x4' to 'float2x4'}} fxc-error {{X3017: cannot convert from 'float4' to 'float2x4'}} */
  m2x4 = m2x4 + m2x4;
  m2x4 += m2x4;
  m2x4 = m2x4 + (float2x4)m2x4;
  m2x4 += (float2x4)m2x4;
  m2x4 = m2x4 + m4x4;                                       /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x4 += m4x4;                                             /* expected-warning {{implicit truncation of vector type}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m2x4 = m2x4 + (float2x4)m4x4;
  m2x4 += (float2x4)m4x4;
  m4x4 = m4x4 + f;
  m4x4 += f;
  m4x4 = m4x4 + (float4x4)f;
  m4x4 += (float4x4)f;
  m4x4 = m4x4 + f1;
  m4x4 += f1;
  m4x4 = m4x4 + (float4x4)f1;
  m4x4 += (float4x4)f1;
  m4x4 = m4x4 + f2;                                         /* expected-error {{cannot convert from 'float2' to 'float4x4'}} fxc-error {{X3020: type mismatch}} */
  m4x4 += f2;                                               /* expected-error {{cannot convert from 'float2' to 'float4x4'}} fxc-error {{X3020: type mismatch}} */
  m4x4 = m4x4 + (float4x4)f2;                               /* expected-error {{cannot convert from 'float2' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x4'}} */
  m4x4 += (float4x4)f2;                                     /* expected-error {{cannot convert from 'float2' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x4'}} */
  m4x4 = m4x4 + f4;                                         /* expected-error {{cannot convert from 'float4' to 'float4x4'}} fxc-error {{X3020: type mismatch}} */
  m4x4 += f4;                                               /* expected-error {{cannot convert from 'float4' to 'float4x4'}} fxc-error {{X3020: type mismatch}} */
  m4x4 = m4x4 + (float4x4)f4;                               /* expected-error {{cannot convert from 'float4' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float4' to 'float4x4'}} */
  m4x4 += (float4x4)f4;                                     /* expected-error {{cannot convert from 'float4' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float4' to 'float4x4'}} */
  m4x4 = m4x4 + m1x1;
  m4x4 += m1x1;
  m4x4 = m4x4 + (float4x4)m1x1;
  m4x4 += (float4x4)m1x1;
  m4x4 = m4x4 + m2x1;                                       /* expected-error {{cannot convert from 'float2x1' to 'float4x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 += m2x1;                                             /* expected-error {{cannot convert from 'float2x1' to 'float4x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2x1' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 = m4x4 + (float4x4)m2x1;                             /* expected-error {{cannot convert from 'float2x1' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float4x4'}} */
  m4x4 += (float4x4)m2x1;                                   /* expected-error {{cannot convert from 'float2x1' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float2x1' to 'float4x4'}} */
  m4x4 = m4x4 + m4x1;                                       /* expected-error {{cannot convert from 'float4x1' to 'float4x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float4x1' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 += m4x1;                                             /* expected-error {{cannot convert from 'float4x1' to 'float4x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float4x1' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 = m4x4 + (float4x4)m4x1;                             /* expected-error {{cannot convert from 'float4x1' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float4x4'}} */
  m4x4 += (float4x4)m4x1;                                   /* expected-error {{cannot convert from 'float4x1' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float4x1' to 'float4x4'}} */
  m4x4 = m4x4 + m1x2;                                       /* expected-error {{cannot convert from 'float1x2' to 'float4x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 += m1x2;                                             /* expected-error {{cannot convert from 'float1x2' to 'float4x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 = m4x4 + (float4x4)m1x2;                             /* expected-error {{cannot convert from 'float1x2' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x4'}} */
  m4x4 += (float4x4)m1x2;                                   /* expected-error {{cannot convert from 'float1x2' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float2' to 'float4x4'}} */
  m4x4 = m4x4 + m2x2;                                       /* expected-error {{cannot convert from 'float2x2' to 'float4x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2x2' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 += m2x2;                                             /* expected-error {{cannot convert from 'float2x2' to 'float4x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2x2' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 = m4x4 + (float4x4)m2x2;                             /* expected-error {{cannot convert from 'float2x2' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float4x4'}} */
  m4x4 += (float4x4)m2x2;                                   /* expected-error {{cannot convert from 'float2x2' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float2x2' to 'float4x4'}} */
  m4x4 = m4x4 + m4x2;                                       /* expected-error {{cannot convert from 'float4x2' to 'float4x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float4x2' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 += m4x2;                                             /* expected-error {{cannot convert from 'float4x2' to 'float4x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float4x2' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 = m4x4 + (float4x4)m4x2;                             /* expected-error {{cannot convert from 'float4x2' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float4x2' to 'float4x4'}} */
  m4x4 += (float4x4)m4x2;                                   /* expected-error {{cannot convert from 'float4x2' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float4x2' to 'float4x4'}} */
  m4x4 = m4x4 + m1x4;                                       /* expected-error {{cannot convert from 'float1x4' to 'float4x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float4' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 += m1x4;                                             /* expected-error {{cannot convert from 'float1x4' to 'float4x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float4' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 = m4x4 + (float4x4)m1x4;                             /* expected-error {{cannot convert from 'float1x4' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float4' to 'float4x4'}} */
  m4x4 += (float4x4)m1x4;                                   /* expected-error {{cannot convert from 'float1x4' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float4' to 'float4x4'}} */
  m4x4 = m4x4 + m2x4;                                       /* expected-error {{cannot convert from 'float2x4' to 'float4x4'}} expected-warning {{implicit truncation of vector type}} fxc-error {{X3017: cannot implicitly convert from 'const float2x4' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 += m2x4;                                             /* expected-error {{cannot convert from 'float2x4' to 'float4x4'}} fxc-error {{X3017: cannot implicitly convert from 'const float2x4' to 'float4x4'}} fxc-warning {{X3206: implicit truncation of vector type}} */
  m4x4 = m4x4 + (float4x4)m2x4;                             /* expected-error {{cannot convert from 'float2x4' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float2x4' to 'float4x4'}} */
  m4x4 += (float4x4)m2x4;                                   /* expected-error {{cannot convert from 'float2x4' to 'float4x4'}} fxc-error {{X3017: cannot convert from 'float2x4' to 'float4x4'}} */
  m4x4 = m4x4 + m4x4;
  m4x4 += m4x4;
  m4x4 = m4x4 + (float4x4)m4x4;
  m4x4 += (float4x4)m4x4;
  // GENERATED_CODE:END

  return 0;
}
