/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.manager.util;

import java.io.File;
import java.util.ArrayList;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.manager.LocalRepositoryManager;
import org.openrdf.repository.manager.util.RepositoryManagerListener;

public class NotifyingLocalRepositoryManager
extends LocalRepositoryManager {
    private ArrayList<RepositoryManagerListener> listeners = new ArrayList();

    public NotifyingLocalRepositoryManager(File baseDir) {
        super(baseDir);
    }

    public void addRepositoryManagerListener(RepositoryManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeRepositoryManagerListener(RepositoryManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void initialize() throws RepositoryException {
        super.initialize();
        this.fireInitialized();
    }

    public void refresh() {
        super.refresh();
        this.fireRefreshed();
    }

    public void shutDown() {
        super.shutDown();
        this.fireShutDown();
    }

    private void fireInitialized() {
        for (RepositoryManagerListener listener : this.listeners) {
            listener.initialized(this);
        }
    }

    private void fireRefreshed() {
        for (RepositoryManagerListener listener : this.listeners) {
            listener.refreshed(this);
        }
    }

    private void fireShutDown() {
        for (RepositoryManagerListener listener : this.listeners) {
            listener.shutDown(this);
        }
    }
}

