/****************************************************************************
**
** Copyright (C) 2012 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this
** file. Please review the following information to ensure the GNU Lesser
** General Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU General
** Public License version 3.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of this
** file. Please review the following information to ensure the GNU General
** Public License version 3.0 requirements will be met:
** http://www.gnu.org/copyleft/gpl.html.
**
** Other Usage
** Alternatively, this file may be used in accordance with the terms and
** conditions contained in a signed written agreement between you and Nokia.
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qwindowsmobilestyle.h"
#include "qwindowsmobilestyle_p.h"

#if !defined(QT_NO_STYLE_WINDOWSMOBILE) || defined(QT_PLUGIN)

#include "qpainterpath.h"
#include "qapplication.h"
#include "qdesktopwidget.h"
#include "qwidget.h"
#include "qdockwidget.h"
#include "qframe.h"
#include "qmenu.h"
#include "qpaintengine.h"
#include "qpainter.h"
#include "qgroupbox.h"
#include "qstyleoption.h"
#include "qlistview.h"
#include "qdrawutil.h"
#include "qtoolbar.h"
#include "qabstractscrollarea.h"
#include "qabstractbutton.h"
#include "qcombobox.h"
#include "qabstractscrollarea.h"
#include "qframe.h"
#include "qscrollbar.h"
#include "qabstractitemview.h"
#include "qmenubar.h"
#include "qtoolbutton.h"
#include "qtextedit.h"
#include "qdialog.h"
#include "qdebug.h"
#include "qtabwidget.h"

#ifdef Q_WS_WINCE
#include "qt_windows.h"
#include "qguifunctions_wince.h"
extern bool qt_wince_is_high_dpi();          //defined in qguifunctions_wince.cpp
extern bool qt_wince_is_smartphone();        //defined in qguifunctions_wince.cpp
extern bool qt_wince_is_windows_mobile_65(); //defined in qguifunctions_wince.cpp
#endif // Q_WS_WINCE

#include "qstylehelper_p.h"

QT_BEGIN_NAMESPACE

static const int windowsItemFrame        =  1; // menu item frame width

static const int windowsMobileitemViewCheckBoxSize   = 13;
static const int windowsMobileFrameGroupBoxOffset    = 9;
static const int windowsMobileIndicatorSize          = 14;
static const int windowsMobileExclusiveIndicatorSize = 14;
static const int windowsMobileSliderThickness        = 6;
static const int windowsMobileIconSize               = 16;
static const int PE_IndicatorArrowUpBig         = 0xf000101;
static const int PE_IndicatorArrowDownBig       = 0xf000102;  
static const int PE_IndicatorArrowLeftBig       = 0xf000103;
static const int PE_IndicatorArrowRightBig      = 0xf000104;

/* XPM */
static const char *const radiobutton_xpm[] = {
    "30 30 2 1",
    " 	c None",
    ".	c #000000",
    "           ........           ",
    "        ..............        ",
    "       ....        ....       ",
    "     ....            ....     ",
    "    ...                ...    ",
    "   ...                  ...   ",
    "   ..                    ..   ",
    "  ..                      ..  ",
    " ...                      ... ",
    " ..                        .. ",
    " ..                        .. ",
    "..                          ..",
    "..                          ..",
    "..                          ..",
    "..                          ..",
    "..                          ..",
    "..                          ..",
    "..                          ..",
    "..                          ..",
    " ..                        .. ",
    " ..                        .. ",
    " ...                      ... ",
    "  ..                      ..  ",
    "   ..                    ..   ",
    "   ...                  ...   ",
    "    ...                ...    ",
    "     ....            ....     ",
    "       ....        ....       ",
    "        ..............        ",
    "           ........           "};

/* XPM */
static const char * const radiobutton_low_xpm[] = {
    "15 15 2 1",
    " 	c None",
    ".	c #000000",
    "     .....     ",
    "   ..     ..   ",
    "  .         .  ",
    " .           . ",
    " .           . ",
    ".             .",
    ".             .",
    ".             .",
    ".             .",
    ".             .",
    " .           . ",
    " .           . ",
    "  .         .  ",
    "   ..     ..   ",
    "     .....     "};

/* XPM */
    static const char * const arrowleft_big_xpm[] = {
        "9 17 2 1",
        "  c None",
        ". c #000000",
        "        .",
        "       ..",
        "      ...",
        "     ....",
        "    .....",
        "   ......",
        "  .......",
        " ........",
        ".........",
        " ........",
        "  .......",
        "   ......",
        "    .....",
        "     ....",
        "      ...",
        "       ..",
        "        ."};

/* XPM */
     static const char * const arrowleft_xpm[] = {
        "8 15 2 1",
        "  c None",
        ". c #000000",
        "       .",
        "      ..",
        "     ...",
        "    ....",
        "   .....",
        "  ......",
        " .......",
        "........",
        " .......",
        "  ......",
        "   .....",
        "    ....",
        "     ...",
        "      ..",
        "       ."};



/* XPM */
static const char *const horlines_xpm[] = {
    "2 2 2 1",
    "  c None",
    ". c #000000",
    "  ",
    ".."};

/* XPM */
static const char *const vertlines_xpm[] = {
    "2 2 2 1",
    "  c None",
    ". c #000000",
    ". ",
    ". "};

/* XPM */
static const char *const radiochecked_xpm[] = {
    "18 18 2 1",
    " 	c None",
    ".	c #000000",
    "      ......      ",
    "    ..........    ",
    "  ..............  ",
    "  ..............  ",
    " ................ ",
    " ................ ",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    "..................",
    " ................ ",
    " ................ ",
    "  ..............  ",
    "  ..............  ",
    "    ..........    ",
    "      ......      "};

/* XPM */
static const char * const radiochecked_low_xpm[] = {
    "9 9 2 1",
    "         c None",
    ".        c #000000", 
    "   ...   ",
    " ....... ",
    " ....... ",
    ".........",
    ".........",
    ".........",
    " ....... ",
    " ....... ",
    "   ...   "};

static const char *const arrowdown_xpm[] = {
    "15 8 2 1",
    " 	c None",
    ".	c #000000",
    "...............",
    " ............. ",
    "  ...........  ",
    "   .........   ",
    "    .......    ",
    "     .....     ",
    "      ...      ",
    "       .       "};


static const char *const arrowdown_big_xpm[] = {
    "17 9 2 1",
    " 	c None",
    ".	c #000000",
    ".................",
    " ............... ",
    "  .............  ",
    "   ...........   ",
    "    .........    ",
    "     .......     ",
    "      .....      ",
    "       ...       ",
    "        .        "};


/* XPM */
static const char *const checkedlight_xpm[] = {
    "24 24 2 1",
    " 	c None",
    ".	c #000000",
    "                        ",
    "                        ",
    "                        ",
    "                        ",
    "                        ",
    "                  .     ",
    "                 ..     ",
    "                ...     ",
    "               ....     ",
    "              .....     ",
    "             ......     ",
    "    .       ......      ",
    "    ..     ......       ",
    "    ...   ......        ",
    "    .... ......         ",
    "    ..........          ",
    "    .........           ",
    "     .......            ",
    "      .....             ",
    "       ...              ",
    "        .               ",
    "                        ",
    "                        ",
    "                        "};


/* XPM */
static const char *const checkedbold_xpm[] = {
    "26 26 2 1",
    " 	c None",
    ".	c #000000",
    "                          ",
    "                          ",
    "                          ",
    "                          ",
    "                          ",
    "                          ",
    "                    ..    ",
    "                   ...    ",
    "                  ....    ",
    "                 .....    ",
    "    ..          ......    ",
    "    ...        .......    ",
    "    ....      .......     ",
    "    .....    .......      ",
    "    ......  .......       ",
    "    ..............        ",
    "     ............         ",
    "      ..........          ",
    "       ........           ",
    "        ......            ",
    "         ....             ",
    "          ..              ",
    "                          ",
    "                          ",
    "                          ",
    "                          "};

/* XPM */
static const char * const checkedbold_low_xpm[] = {
    "9 8 2 1",
    " 	c None",
    ".	c #000000",
    "        .",
    "       ..",
    ".     ...",
    "..   ... ",
    "... ...  ",
    " .....   ",
    "  ...    ",
    "   .     "};

/* XPM */
static const char * const checkedlight_low_xpm[] = {
    "8 8 2 1",
    " 	c None",
    ".	c #000000",
    "       .",
    "      ..",
    "     ...",
    ".   ... ",
    ".. ...  ",
    ".....   ",
    " ...    ",
    "  .     "};

/* XPM */
static const char * const highlightedradiobutton_xpm[] = {
    "30 30 3 1",
    " 	c None",
    ".	c #000000",
    "+	c #0078CC",
    "           ........           ",
    "        ..............        ",
    "       ....++++++++....       ",
    "     ....++++++++++++....     ",
    "    ...++++        ++++...    ",
    "   ...+++            +++...   ",
    "   ..++                ++..   ",
    "  ..++                  ++..  ",
    " ...++                  ++... ",
    " ..++                    ++.. ",
    " ..++                    ++.. ",
    "..++                      ++..",
    "..++                      ++..",
    "..++                      ++..",
    "..++                      ++..",
    "..++                      ++..",
    "..++                      ++..",
    "..++                      ++..",
    "..++                      ++..",
    " ..++                    ++.. ",
    " ..++                    ++.. ",
    " ...++                  ++... ",
    "  ..++                  ++..  ",
    "   ..++                ++..   ",
    "   ...+++            +++...   ",
    "    ...++++        ++++...    ",
    "     ....++++++++++++....     ",
    "       ....++++++++....       ",
    "        ..............        ",
    "           ........           "};

/* XPM */
static const char * const highlightedradiobutton_low_xpm[] = {
    "15 15 3 1",
    " 	c None",
    ".	c #000000",
    "+	c #3192D6",
    "     .....     ",
    "   ..+++++..   ",
    "  .++     ++.  ",
    " .+         +. ",
    " .+         +. ",
    ".+           +.",
    ".+           +.",
    ".+           +.",
    ".+           +.",
    ".+           +.",
    " .+         +. ",
    " .+         +. ",
    "  .++     ++.  ",
    "   ..+++++..   ",
    "     .....     "};

/* XPM */
static const char * const cross_big_xpm[] = {
"28 28 4 1",
" 	c #09454A",
".	c #218C98",
"+	c #47D8E5",
"@	c #FDFFFC",
"                            ",
"                            ",
"  ++++++++++++++++++++++++  ",
"  ++++++++++++++++++++++++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++..@@@..........@@@..++  ",
"  ++..@@@@........@@@@..++  ",
"  ++..@@@@@......@@@@@..++  ",
"  ++...@@@@@....@@@@@...++  ",
"  ++....@@@@@..@@@@@....++  ",
"  ++.....@@@@@@@@@@.....++  ",
"  ++......@@@@@@@@......++  ",
"  ++.......@@@@@@.......++  ",
"  ++.......@@@@@@.......++  ",
"  ++......@@@@@@@@......++  ",
"  ++.....@@@@@@@@@@.....++  ",
"  ++....@@@@@..@@@@@....++  ",
"  ++...@@@@@....@@@@@...++  ",
"  ++..@@@@@......@@@@@..++  ",
"  ++..@@@@........@@@@..++  ",
"  ++..@@@..........@@@..++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++++++++++++++++++++++++  ",
"  ++++++++++++++++++++++++  ",
"                            ",
"                            "};

/* XPM */
static const char * const cross_small_xpm[] = {
"14 14 4 1",
" 	c #09454A",
".	c #218C98",
"+	c #47D8E5",
"@	c #FCFFFC",
"              ",
" ++++++++++++ ",
" +..........+ ",
" +.@@....@@.+ ",
" +.@@@..@@@.+ ",
" +..@@@@@@..+ ",
" +...@@@@...+ ",
" +...@@@@...+ ",
" +..@@@@@@..+ ",
" +.@@@..@@@.+ ",
" +.@@....@@.+ ",
" +..........+ ",
" ++++++++++++ ",
"              "};

/* XPM */
static const char * const max_big_xpm[] = {
"28 28 4 1",
" 	c #09454A",
".	c #218C98",
"+	c #47D8E5",
"@	c #FDFFFC",
"                            ",
"                            ",
"  ++++++++++++++++++++++++  ",
"  ++++++++++++++++++++++++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++++++++++++++++++++++++  ",
"  ++++++++++++++++++++++++  ",
"                            ",
"                            "};

/* XPM */
static const char * const max_small_xpm[] = {
"14 14 4 1",
" 	c #09454A",
".	c #218C98",
"+	c #47D8E5",
"@	c #FCFFFC",
"              ",
" ++++++++++++ ",
" +..........+ ",
" +..........+ ",
" +.@@@@@@@@.+ ",
" +.@@@@@@@@.+ ",
" +.@......@.+ ",
" +.@......@.+ ",
" +.@......@.+ ",
" +.@@@@@@@@.+ ",
" +..........+ ",
" +..........+ ",
" ++++++++++++ ",
"              "};

/* XPM */
static const char * const normal_big_xpm[] = {
"28 28 4 1",
" 	c #09454A",
".	c #218C98",
"+	c #47D8E5",
"@	c #FDFFFC",
"                            ",
"                            ",
"  ++++++++++++++++++++++++  ",
"  ++++++++++++++++++++++++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@............@@..++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++++++++++++++++++++++++  ",
"  ++++++++++++++++++++++++  ",
"                            ",
"                            "};

/* XPM */
static const char * const normal_small_xpm[] = {
"14 14 4 1",
" 	c #09454A",
".	c #218C98",
"+	c #47D8E5",
"@	c #FCFFFC",
"              ",
" ++++++++++++ ",
" +..........+ ",
" +.@@@@@@@@.+ ",
" +.@......@.+ ",
" +.@......@.+ ",
" +.@......@.+ ",
" +.@......@.+ ",
" +.@......@.+ ",
" +.@......@.+ ",
" +.@@@@@@@@.+ ",
" +..........+ ",
" ++++++++++++ ",
"              "};


/* XPM */
static const char * const min_big_xpm[] = {
"28 28 4 1",
" 	c #09454A",
".	c #218C98",
"+	c #47D8E5",
"@	c #FDFFFC",
"                            ",
"                            ",
"  ++++++++++++++++++++++++  ",
"  ++++++++++++++++++++++++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++..@@@@@@@@@@@@@@@@..++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++....................++  ",
"  ++++++++++++++++++++++++  ",
"  ++++++++++++++++++++++++  ",
"                            ",
"                            "};

/* XPM */
static const char * const min_small_xpm[] = {
"14 14 4 1",
" 	c #09454A",
".	c #218C98",
"+	c #47D8E5",
"@	c #FCFFFC",
"              ",
" ++++++++++++ ",
" +..........+ ",
" +..........+ ",
" +..........+ ",
" +..........+ ",
" +..........+ ",
" +..........+ ",
" +..........+ ",
" +.@@@@@@@@.+ ",
" +..........+ ",
" +..........+ ",
" ++++++++++++ ",
"              "};

#ifdef Q_WS_WINCE_WM

static char * sbhandleup_xpm[] = {
"26 41 45 1",
" 	c None",
".	c #000000",
"+	c #E7E7E7",
"@	c #D6D7D6",
"#	c #949294",
"$	c #737573",
"%	c #636563",
"&	c #636163",
"*	c #5A5D5A",
"=	c #5A595A",
"-	c #525552",
";	c #525152",
">	c #4A4D4A",
",	c #7B797B",
"'	c #CECFCE",
")	c #CED3CE",
"!	c #6B6D6B",
"~	c #6B696B",
"{	c #737173",
"]	c #7B7D7B",
"^	c #848684",
"/	c #848284",
"(	c #8C8A8C",
"_	c #8C8E8C",
":	c #B5B2B5",
"<	c #FFFFFF",
"[	c #949694",
"}	c #B5B6B5",
"|	c #9C9A9C",
"1	c #ADAEAD",
"2	c #9C9E9C",
"3	c #BDBABD",
"4	c #BDBEBD",
"5	c #F7F3F7",
"6	c #C6C3C6",
"7	c #C6C7C6",
"8	c #A5A2A5",
"9	c #CECBCE",
"0	c #FFFBFF",
"a	c #ADAAAD",
"b	c #A5A6A5",
"c	c #D6D3D6",
"d	c #B5BAB5",
"e	c #DEDFDE",
"f	c #DEDBDE",
"..........................",
"+@#$%%&&&**===---;;;;>=,'+",
"+@#$%%&&&**===---;;;;>=$'+",
")$!!~~%%&&&**===---;;;;>;'",
"#{$]],,$${{{!!~~%%%&&&*-;]",
"#{$]],,$${{{!!~~%%%&&&*-;]",
",$^//]],,$${{{!!~~%%%&&*;*",
",,(^^//]],$${!!!!!~~%%%&-*",
",,(^^//]],$${!!!!!~~%%%&-*",
"]]_((^^//]$!%%~!{{!!~~%%-*",
"//#__((^^]{:<<:~!{{{!!~~=*",
"//#__((^^]{:<<:~!{{{!!~~=&",
"//###__(/$:<<<<:~{${{!!~*&",
"^^[[##_^]:<<<<<<}!{$${{!*%",
"^^[[##_^]:<<<<<<}!{$${{!*%",
"((|[[#_/:<<<<<<<<}!$$${{&~",
"((||[#^1<<<<1:<<<<}!$$$$&~",
"((||[#^1<<<<1:<<<<}!$$$$&~",
"__2|#(1<<<<}],}<<<<}{$,$%~",
"##2|_1<<<<}^((]3<<<<}{$,~!",
"##2|_1<<<<}^((]3<<<<}{$,~!",
"##2#1<<<<3^###(/4<<<<}{,~{",
"##2#1<<<<3^###(/4<<<<}{,~!",
"[[2_5<<<4(#|[[#_/6<<<<,,!{",
"[|2_5<<4_[||||[[_/7<<<,]{$",
"[|2_5<<4_[||||[[_/7<<<,]{$",
"||8_5<6#|2222|||[_/9<<,]{$",
"228#06[28888222||[_/'<,/$,",
"228#06[28888222||[_/'<,/$,",
"22a|6[8bbbb88822||[(/c](,]",
"881b8baaabbbb88222|[(^(_,]",
"881b8baaabbbb88222|[(^(_,]",
"88111111aaabbb88822|[###]/",
"bb:::11111aaabbb8822||[[/^",
"bb:::11111aaabbb8822||[[//",
"bb:::::1111aaabbb8822||[/(",
"3a1::::::1111aaabb8822|_^8",
"da1::::::1111aaabb8822|_^8",
"e1aaabbbb888822||[[##__((@",
"+e4:aaabbbb88822||[[[#[b@+",
"+e4:aaabbbb88822||[[[#[bf+"};

static char * sbhandledown_xpm[] = {
"26 40 46 1",
" 	c None",
".	c #E7E7E7",
"+	c #DEDFDE",
"@	c #BDBEBD",
"#	c #B5B2B5",
"$	c #ADAAAD",
"%	c #A5A6A5",
"&	c #A5A2A5",
"*	c #9C9E9C",
"=	c #9C9A9C",
"-	c #949694",
";	c #949294",
">	c #D6D7D6",
",	c #DEDBDE",
"'	c #D6DBD6",
")	c #ADAEAD",
"!	c #8C8E8C",
"~	c #8C8A8C",
"{	c #BDBABD",
"]	c #848684",
"^	c #B5BAB5",
"/	c #848284",
"(	c #848A84",
"_	c #7B7D7B",
":	c #7B797B",
"<	c #C6C3C6",
"[	c #D6D3D6",
"}	c #FFFBFF",
"|	c #CECFCE",
"1	c #FFFFFF",
"2	c #737573",
"3	c #F7F3F7",
"4	c #CECBCE",
"5	c #737173",
"6	c #C6C7C6",
"7	c #6B6D6B",
"8	c #B5B6B5",
"9	c #6B696B",
"0	c #636563",
"a	c #636163",
"b	c #5A5D5A",
"c	c #5A595A",
"d	c #525552",
"e	c #525152",
"f	c #4A4D4A",
"g	c #C6CBC6",
".+@#$$$%%%%&&&**==---;-%>.",
".+@#$$$%%%%&&&**==---;-%,.",
"')$$$%%%%&&&&**==--;;!!~~>",
"{$)######))))$$$%%&&**=!]&",
"^$)######))))$$$%%&&**=!]&",
"%%#####))))$$$%%%&&**==-/(",
"%%###)))))$$$%%%&&**==--/]",
"%%###)))))$$$%%%&&**==--//",
"&&))))))$$$%%%&&&**=-;;;_/",
"&&)%&%$$$%%%%&&***=-~]~!:_",
"&&)%&%$$$%%%%&&***=-~]~!:_",
"**$=<-&%%%%&&&**==-~/[_~:_",
"**&;}<-*&&&&***==-!/|1:/2:",
"**&;}<-*&&&&***==-!/|1:/2:",
"==&!31<;=****===-!/411:_5:",
"-=*!311@!-====--!/6111:_52",
"-=*!311@!-====--!/6111:_52",
"--*!3111@~;=--;!/<1111::75",
";;*;)1111{];;;~/@111185:95",
";;*;)1111{];;;~/@111185:97",
";;*=!)11118]~~_{1111852:97",
";;*=!)11118]~~_{1111852:97",
"!!*=;~)11118_:81111852:207",
"~~==-;])1111)#1111872222a9",
"~~==-;])1111)#1111872222a9",
"~~=--;!/#111111118722255a0",
"]]--;;!]_#11111187522557b0",
"]]--;;!]_#11111187522557b0",
"//;;;!!~/2#1111#95255779ba",
"//;!!~~]]_5#11#975557799cb",
"//;!!~~]]_5#11#975557799ca",
"__!~~]]//_27009755779900db",
"::~]]//__:2257777799000adb",
"::~]]//__:2257777799000adb",
":2]//__::225557799000aabeb",
";52__::225557799000aaabde_",
";52__::225557799000aaabde_",
"[2779900aaabbcccdddeeeefeg",
".>;200aaabbcccdddeeeefc:|.",
".>;200aaabbcccdddeeeefc2|."};

static char * sbgripdown_xpm[] = {
"26 34 39 1",
" 	c None",
".	c #949294",
"+	c #9C9E9C",
"@	c #9C9A9C",
"#	c #949694",
"$	c #8C8E8C",
"%	c #8C8A8C",
"&	c #848684",
"*	c #848284",
"=	c #7B7D7B",
"-	c #7B797B",
";	c #6B696B",
">	c #636563",
",	c #737573",
"'	c #636163",
")	c #737173",
"!	c #5A5D5A",
"~	c #6B6D6B",
"{	c #5A595A",
"]	c #B5B6B5",
"^	c #BDBEBD",
"/	c #ADAEAD",
"(	c #BDBABD",
"_	c #525552",
":	c #313031",
"<	c #525152",
"[	c #ADAAAD",
"}	c #BDBAB5",
"|	c #4A4D4A",
"1	c #4A494A",
"2	c #C6C3C6",
"3	c #C6CBC6",
"4	c #E7E7E7",
"5	c #DEDFDE",
"6	c #E7E3E7",
"7	c #DEE3DE",
"8	c #CECBCE",
"9	c #8C928C",
"0	c #CECFCE",
"..+++@@@###...$$%&&**==-;>",
"$.++@@@@##...$$%%&**==-->>",
"$$+@@@@###..$$%%&&*==--,>>",
"$$@@@@###..$$%%&&**==-,,>'",
"%%@@@###..$$$%&&**==--,,''",
"%%@@###..$$$%&&**==--,,)''",
"%%@###...$$%%&&*==--,,))'!",
"&&###...$$%%&&**==--,)))!!",
"&&##...$$%%&&**==--,,))~!!",
"&&#...$$%%&&**==--,,))~~!{",
"**...$$%%&&**==--,,))~~;!{",
"**..$$%%&&**===--,)))~~;{{",
"**.$$%%&]^&===//,,))~~;;{{",
"==$$%%&&]^*==-((,))~~;;>{_",
"==$%%&&***::--,,::~~;;;>__",
"==%%&&&**=::-,,)::~~;;>>__",
"--%&&&**==--,,)))~~;;>>>__",
"--&&&**==--,,)))~~;;>>>'_<",
",-&&**==]^-,))[[~;;>>>''<<",
",,&**==-]^-)))}};;>>>'''<<",
",,**==--,,::)~~;::>>'''!<<",
"))*==--,,)::~~;;::>'''!!<|",
"))==--,,)))~~;;;>>'''!!!||",
"))=--,,)))~~;;;>>'''!!!{||",
"~~--,,)))~~;;;>>'''!!!{{||",
"~~-,,)))~~;;>>>'''!!!{{{|1",
";;,,)))~~;;>>>'''!!!{{{_1<",
"~;,)))~~;;>>>'''!!!{{{__1'",
"%>~))~~;;>>>'''!!!{{{__|1$",
"2>>~~~;;>>>''!!!{{{{__<113",
"4%'';;;>>>''!!!{{{{__<11%4",
"45-!!'>>>''!!!{{{{_<|11)64",
"447+!{{___<<<||||1111|+444",
"444489~__<<<||||111>$04444"};

static char * sbgripup_xpm[] = {
"26 34 38 1",
" 	c None",
".	c #E7E7E7",
"+	c #D6DBD6",
"@	c #C6C7C6",
"#	c #B5B6B5",
"$	c #ADAEAD",
"%	c #ADAAAD",
"&	c #A5A6A5",
"*	c #A5A2A5",
"=	c #BDBEBD",
"-	c #DEDFDE",
";	c #C6CBC6",
">	c #9C9E9C",
",	c #E7E3E7",
"'	c #BDBABD",
")	c #B5B2B5",
"!	c #9C9A9C",
"~	c #DEE3DE",
"{	c #949694",
"]	c #D6D7D6",
"^	c #949294",
"/	c #DEDBDE",
"(	c #8C8E8C",
"_	c #8C8A8C",
":	c #848684",
"<	c #D6D3CE",
"[	c #CECBCE",
"}	c #D6D3D6",
"|	c #848284",
"1	c #313031",
"2	c #7B7D7B",
"3	c #CECFCE",
"4	c #CECBC6",
"5	c #7B797B",
"6	c #737573",
"7	c #737173",
"8	c #6B6D6B",
"9	c #6B696B",
"....+@#$$%%%%&&&***$=-....",
"...;$$$$$%%%&&&&**>>>>@...",
".,'$$)#'#####)))$$$%*!!$~.",
".=$)#'''####))))$$$%%*!{'.",
"]$$''''#####)))$$$%%%&*{^/",
"=$#'''#####)))$$$$%%&&&!^#",
"$$'''#####))))$$$%%%&&*>(!",
"$$''#####))))$$$%%%&&&*>(^",
"$$######))))$$$$%%&&&**>(_",
"%$#####))))$$$$%%%&&***>__",
"%$####))))$$$$%%%&&&**>>__",
"%%###)))))$$$%%%&&&**>>>_:",
"%%##))))<])$$%[[&&***>>!::",
"%%#)))))<]$$%%}<&&**>>!!:|",
"&%)))))$$$11%%&&11*>>>!!:|",
"&&))))$$$$11%&&&11*>>!!{||",
"&&)))$$$$$%%%&&&**>>!!!{|2",
"&&))$$$$$%%%&&&**>>>!!{{|2",
"*&)$$$$$3]%&&&4@*>>!!{{{22",
"**$$$$$%3]%&&&<<>>!!!{{^25",
"**$$$$%%%%11&**>11!!{{^^25",
"**$$$%%%%&11***>11!!{{^^55",
"**$$%%%%&&&***>>!!!{{^^(55",
">>$%%%%&&&***>>>!!{{^^((56",
">>%%%%&&&&***>>!!!{{^^((66",
">>%%%&&&&***>>!!!{{^^((_67",
"!>%%&&&&***>>>!!{{{^^(__67",
"!!%&&&&***>>>!!!{{^^((_:77",
"!!&&&&***>>>!!!{{^^((__:77",
"!!&&&****>>!!!{{^^^(__::78",
"{!&&****>>>!!{{{^^((_::|88",
"{{&****>>>!!!{{^^((__:||88",
"{{****>>>!!!{{^^^(__::|289",
"{{***>>>!!!{{{^^((_::||289"};

static char * sbgripmiddle_xpm[] = {
"26 2 12 1",
" 	c None",
".	c #949294",
"+	c #A5A2A5",
"@	c #9C9E9C",
"#	c #9C9A9C",
"$	c #949694",
"%	c #8C8E8C",
"&	c #8C8A8C",
"*	c #848684",
"=	c #848284",
"-	c #7B7D7B",
";	c #6B696B",
"..++@@@###$$$..%%&&*==--;;",
"..++@@@###$$$..%%&&*==--;;"};


static char * listviewhighmiddle_xpm[] = {
"8 46 197 2",
"  	c None",
". 	c #66759E",
"+ 	c #6C789D",
"@ 	c #6A789E",
"# 	c #6B789E",
"$ 	c #6A779D",
"% 	c #6C789C",
"& 	c #6F7D9B",
"* 	c #6F7D9A",
"= 	c #9DB6EE",
"- 	c #9DB6ED",
"; 	c #9CB6ED",
"> 	c #A1B6EF",
", 	c #A2B6F0",
"' 	c #93AAE9",
") 	c #95ABEA",
"! 	c #94ABEA",
"~ 	c #94A9E8",
"{ 	c #8BA8EA",
"] 	c #8BA7EA",
"^ 	c #8AA7EA",
"/ 	c #8EAAE8",
"( 	c #8FAAE8",
"_ 	c #88A2E7",
": 	c #8CA3E8",
"< 	c #8BA3E7",
"[ 	c #8BA3E8",
"} 	c #8BA2E7",
"| 	c #8CA2E7",
"1 	c #8DA2E7",
"2 	c #87A1E8",
"3 	c #87A1E9",
"4 	c #86A0E8",
"5 	c #86A1E7",
"6 	c #87A2E7",
"7 	c #859EE9",
"8 	c #849DE9",
"9 	c #869EE9",
"0 	c #869FE9",
"a 	c #7C9BEA",
"b 	c #7C9CEA",
"c 	c #7B9CEA",
"d 	c #7C9BE9",
"e 	c #7E9CE9",
"f 	c #7B9AEA",
"g 	c #7C99E9",
"h 	c #7C9AEA",
"i 	c #7B9AE8",
"j 	c #7A9AEA",
"k 	c #7996E1",
"l 	c #7C96E4",
"m 	c #7B96E3",
"n 	c #7B95E3",
"o 	c #7E95E5",
"p 	c #7E95E6",
"q 	c #7292E1",
"r 	c #7490DF",
"s 	c #7591E0",
"t 	c #7590DF",
"u 	c #7392E1",
"v 	c #6D8CDE",
"w 	c #6F8EDD",
"x 	c #6E8DDD",
"y 	c #6E8DDE",
"z 	c #6F8EDE",
"A 	c #6E8EDE",
"B 	c #718EDD",
"C 	c #728EDD",
"D 	c #6B89E0",
"E 	c #6C89DF",
"F 	c #6D89E0",
"G 	c #6D89DF",
"H 	c #6C88DF",
"I 	c #6D88DF",
"J 	c #6D86DD",
"K 	c #6086E0",
"L 	c #6686E0",
"M 	c #6586E0",
"N 	c #6486E0",
"O 	c #6485E0",
"P 	c #6786DF",
"Q 	c #5F85E0",
"R 	c #6583DE",
"S 	c #6683DE",
"T 	c #6682DD",
"U 	c #6086DF",
"V 	c #5F86E0",
"W 	c #567ED7",
"X 	c #567ED8",
"Y 	c #557DD7",
"Z 	c #5A7FD8",
"` 	c #6281DA",
" .	c #5379D9",
"..	c #5278D9",
"+.	c #547BD8",
"@.	c #4C73D7",
"#.	c #4B72D2",
"$.	c #4C73D4",
"%.	c #4C73D3",
"&.	c #4B72D4",
"*.	c #4F75D3",
"=.	c #5074D2",
"-.	c #4971D0",
";.	c #4871D0",
">.	c #335ECF",
",.	c #325ECB",
"'.	c #335ECD",
").	c #335ECE",
"!.	c #325DCD",
"~.	c #2E59C9",
"{.	c #3059C9",
"].	c #2F59C9",
"^.	c #2F59C8",
"/.	c #2B59CA",
"(.	c #3355C6",
"_.	c #3354C5",
":.	c #3156C7",
"<.	c #3056C7",
"[.	c #3355C7",
"}.	c #3355C5",
"|.	c #254EBF",
"1.	c #1F51C1",
"2.	c #234FC0",
"3.	c #234FBF",
"4.	c #2350C0",
"5.	c #1E50BE",
"6.	c #1D50C0",
"7.	c #264DBE",
"8.	c #264CBD",
"9.	c #254DBE",
"0.	c #244EBF",
"a.	c #254DBF",
"b.	c #234CBF",
"c.	c #244CC0",
"d.	c #244BC0",
"e.	c #234BC0",
"f.	c #234BBF",
"g.	c #234CBE",
"h.	c #2049B7",
"i.	c #2A49B5",
"j.	c #2749B5",
"k.	c #2749B6",
"l.	c #2D49B4",
"m.	c #2649B6",
"n.	c #2946B5",
"o.	c #2A48B6",
"p.	c #2947B5",
"q.	c #2946B6",
"r.	c #2848B6",
"s.	c #2549B5",
"t.	c #2648B6",
"u.	c #2744B5",
"v.	c #2744B4",
"w.	c #2744AF",
"x.	c #2543B4",
"y.	c #2543B2",
"z.	c #2442B2",
"A.	c #2442B3",
"B.	c #2442B5",
"C.	c #2543B3",
"D.	c #1F40B1",
"E.	c #1E40B1",
"F.	c #243EAE",
"G.	c #273BAC",
"H.	c #263DAC",
"I.	c #253CAB",
"J.	c #273CAB",
"K.	c #273CAC",
"L.	c #263BAA",
"M.	c #253CAE",
"N.	c #263BA6",
"O.	c #253BA5",
"P.	c #253AA5",
"Q.	c #253BA6",
"R.	c #253CA7",
"S.	c #263AA6",
"T.	c #243CA6",
"U.	c #253CA5",
"V.	c #273BA8",
"W.	c #2F4DA4",
"X.	c #2F4DA3",
"Y.	c #1B2F85",
"Z.	c #B5B5B6",
"`.	c #B5B5B5",
" +	c #B5B6B6",
".+	c #B5B4B6",
"++	c #C2C3C5",
"@+	c #C0C3C3",
"#+	c #C1C3C4",
"$+	c #E3E3E3",
"%+	c #E3E3E4",
"&+	c #E4E3E4",
"*+	c #E2E3E4",
"=+	c #ECEEEB",
"-+	c #EBEDEA",
";+	c #EEF0ED",
">+	c #EFF0EE",
". + @ @ # # $ % ",
"& & * & & & & & ",
"= = - = = ; > , ",
"' ) ! ! ! ) ' ~ ",
"{ ] { { { ^ / ( ",
"_ : < [ : } | 1 ",
"2 2 2 3 2 4 5 6 ",
"7 7 7 7 7 8 9 0 ",
"a b a a a c d e ",
"f g h h h h i j ",
"k l m m m n o p ",
"q q q q q q q q ",
"r r s s s t q u ",
"v w x y z A B C ",
"D E F F G F H I ",
"J K L M N O P Q ",
"R R S S S T U V ",
"W W X X X Y Z ` ",
" . . . . ...+.W ",
" . . . . ..... .",
"@.#.$.$.%.&.*.=.",
"-.-.;.-.-.-.-.-.",
">.,.'.).).!.!.>.",
"~.{.].^.].^././.",
"(.(.(.(.(._.:.<.",
"(.(.[.[.[.[.(.}.",
"|.1.2.3.3.4.5.6.",
"7.7.7.7.7.8.9.0.",
"a.b.c.d.c.e.f.g.",
"h.i.j.k.j.k.l.m.",
"n.o.p.q.r.p.s.t.",
"u.u.v.u.u.u.u.u.",
"w.x.y.z.A.y.B.C.",
"D.D.E.D.D.D.D.D.",
"D.D.E.D.D.D.D.D.",
"F.G.H.I.J.K.L.M.",
"N.N.O.N.N.P.Q.R.",
"N.N.S.N.N.N.N.N.",
"T.N.T.T.T.U.N.V.",
"W.W.X.W.W.W.W.W.",
"W.W.W.W.W.W.W.W.",
"Y.Y.Y.Y.Y.Y.Y.Y.",
"Z.`. + +.+Z.`.`.",
"++@+#+#+#+#+@+@+",
"$+%+&+&+*+%+%+%+",
"=+-+;+-+-+>+-+-+"};



static char * listviewhighcornerleft_xpm[] = {
"100 46 1475 2",
"  	c None",
". 	c #FBFBFC",
"+ 	c #E8EAE7",
"@ 	c #758DC3",
"# 	c #42599E",
"$ 	c #28418A",
"% 	c #19418F",
"& 	c #3F5695",
"* 	c #415896",
"= 	c #435A98",
"- 	c #445C99",
"; 	c #465E9B",
"> 	c #48609B",
", 	c #49629C",
"' 	c #4A639D",
") 	c #49639D",
"! 	c #4A629D",
"~ 	c #4B639D",
"{ 	c #4B649D",
"] 	c #4C659D",
"^ 	c #4D669D",
"/ 	c #4E689D",
"( 	c #506A9D",
"_ 	c #516A9D",
": 	c #536B9C",
"< 	c #546C9C",
"[ 	c #566D9B",
"} 	c #576D9B",
"| 	c #586E9C",
"1 	c #5B6F9D",
"2 	c #61739D",
"3 	c #63749E",
"4 	c #64749E",
"5 	c #68769E",
"6 	c #6A779E",
"7 	c #6B789E",
"8 	c #66759E",
"9 	c #6C789D",
"0 	c #EEF0ED",
"a 	c #D0D3DC",
"b 	c #3E51A3",
"c 	c #28428B",
"d 	c #29428C",
"e 	c #425996",
"f 	c #455C99",
"g 	c #485F9C",
"h 	c #49619E",
"i 	c #4A63A0",
"j 	c #4B64A1",
"k 	c #4B65A1",
"l 	c #4C66A2",
"m 	c #4D67A2",
"n 	c #4F69A1",
"o 	c #516AA1",
"p 	c #536CA0",
"q 	c #556DA1",
"r 	c #576EA0",
"s 	c #586F9F",
"t 	c #586E9F",
"u 	c #596F9E",
"v 	c #5A6F9E",
"w 	c #5C709E",
"x 	c #5E719E",
"y 	c #5F729F",
"z 	c #62739F",
"A 	c #63739E",
"B 	c #64749D",
"C 	c #65749E",
"D 	c #69769D",
"E 	c #6C799E",
"F 	c #6D799F",
"G 	c #707D9F",
"H 	c #717F9E",
"I 	c #6E7AA1",
"J 	c #6C789E",
"K 	c #6F7C9C",
"L 	c #6F7D9B",
"M 	c #2A4AA0",
"N 	c #4971D0",
"O 	c #4C72D8",
"P 	c #5472C0",
"Q 	c #5573BF",
"R 	c #5774BF",
"S 	c #5875BF",
"T 	c #5976C1",
"U 	c #5A76C1",
"V 	c #5C78C2",
"W 	c #5E7AC2",
"X 	c #607CC3",
"Y 	c #627EC3",
"Z 	c #637FC4",
"` 	c #6581C5",
" .	c #6682C6",
"..	c #6783C7",
"+.	c #6984C8",
"@.	c #6B85C9",
"#.	c #6D87CA",
"$.	c #6F89CB",
"%.	c #718CCD",
"&.	c #748ECF",
"*.	c #7690D0",
"=.	c #7992D2",
"-.	c #7A93D3",
";.	c #7C95D5",
">.	c #7F98D7",
",.	c #8099D8",
"'.	c #859CDB",
").	c #8AA0DD",
"!.	c #8DA3DF",
"~.	c #8FA5E0",
"{.	c #90A5E0",
"].	c #91A6E1",
"^.	c #91A5E1",
"/.	c #90A4E0",
"(.	c #8EA3DE",
"_.	c #92A6E2",
":.	c #8FA4DF",
"<.	c #90A5DE",
"[.	c #90A5DC",
"}.	c #90A6DB",
"|.	c #91A6E0",
"1.	c #93A7E2",
"2.	c #95AAE6",
"3.	c #99AEEA",
"4.	c #9AB2EA",
"5.	c #99B1E9",
"6.	c #99B1E7",
"7.	c #98AFE6",
"8.	c #93A8E2",
"9.	c #97ACE7",
"0.	c #9AB3EB",
"a.	c #9DB5ED",
"b.	c #9DB6EE",
"c.	c #375095",
"d.	c #4056AD",
"e.	c #506DCD",
"f.	c #4360CC",
"g.	c #345ED6",
"h.	c #335ECF",
"i.	c #355ED6",
"j.	c #355FD6",
"k.	c #365FD6",
"l.	c #355FD0",
"m.	c #3760D5",
"n.	c #3A63D4",
"o.	c #3C63D1",
"p.	c #3B63CD",
"q.	c #3B63C9",
"r.	c #3B62C9",
"s.	c #3D63C8",
"t.	c #4065C5",
"u.	c #4567C5",
"v.	c #496BC5",
"w.	c #4F70C7",
"x.	c #5273C8",
"y.	c #5475CA",
"z.	c #5777CB",
"A.	c #5879CD",
"B.	c #5A7BCE",
"C.	c #5D7DCF",
"D.	c #5F7ECF",
"E.	c #617FD0",
"F.	c #6381D1",
"G.	c #6583D2",
"H.	c #6785D2",
"I.	c #6886D3",
"J.	c #6A88D4",
"K.	c #6C89D5",
"L.	c #6E8BD6",
"M.	c #708CD7",
"N.	c #718DD8",
"O.	c #738EDA",
"P.	c #748FDB",
"Q.	c #7691DC",
"R.	c #7893DD",
"S.	c #7994DD",
"T.	c #7A96DE",
"U.	c #7B97DF",
"V.	c #7C98E0",
"W.	c #7E9AE2",
"X.	c #7F9BE3",
"Y.	c #829DE4",
"Z.	c #849FE5",
"`.	c #87A0E6",
" +	c #88A1E7",
".+	c #89A2E6",
"++	c #8CA3E7",
"@+	c #8EA5E9",
"#+	c #8EA6E9",
"$+	c #8FA7E9",
"%+	c #8FA8E8",
"&+	c #8FA9E8",
"*+	c #91A9E8",
"=+	c #90A7E8",
"-+	c #8FA8EA",
";+	c #90AAEA",
">+	c #93ABEA",
",+	c #95ABEA",
"'+	c #93ABE9",
")+	c #94ABEA",
"!+	c #90A9EA",
"~+	c #93AAE9",
"{+	c #273E7E",
"]+	c #345ED5",
"^+	c #3D60CE",
"/+	c #3D60CF",
"(+	c #345ECF",
"_+	c #335ED0",
":+	c #355FD3",
"<+	c #3A60CE",
"[+	c #3A5FCB",
"}+	c #385FC9",
"|+	c #3B60C8",
"1+	c #3C63CB",
"2+	c #3E64CB",
"3+	c #4166CA",
"4+	c #4568C9",
"5+	c #4A6CC7",
"6+	c #4F71C8",
"7+	c #5172CA",
"8+	c #5475CE",
"9+	c #5678D3",
"0+	c #597CD6",
"a+	c #5C7ED7",
"b+	c #5E7FD8",
"c+	c #6181D9",
"d+	c #6383DA",
"e+	c #6585DA",
"f+	c #6786DB",
"g+	c #6988DC",
"h+	c #6B8ADD",
"i+	c #6D8BDE",
"j+	c #6F8DDE",
"k+	c #718EDF",
"l+	c #728FE0",
"m+	c #7390E1",
"n+	c #7390E2",
"o+	c #7491E3",
"p+	c #7592E4",
"q+	c #7693E4",
"r+	c #7794E5",
"s+	c #7894E5",
"t+	c #7995E6",
"u+	c #7B96E6",
"v+	c #7C97E7",
"w+	c #7D9AE8",
"x+	c #7F9CE9",
"y+	c #829DE9",
"z+	c #849EE9",
"A+	c #859EE9",
"B+	c #87A0E7",
"C+	c #8AA2E7",
"D+	c #8BA3E8",
"E+	c #89A2E7",
"F+	c #8CA6EA",
"G+	c #8BA6EA",
"H+	c #8BA7EA",
"I+	c #8CA3E8",
"J+	c #8BA8EA",
"K+	c #8CA7EA",
"L+	c #8CA8EA",
"M+	c #4659C7",
"N+	c #355ECF",
"O+	c #3660CF",
"P+	c #3860CE",
"Q+	c #3961CD",
"R+	c #3B61CB",
"S+	c #3B61CA",
"T+	c #3D62CA",
"U+	c #3D63CA",
"V+	c #4165CB",
"W+	c #456ACB",
"X+	c #4B6FCD",
"Y+	c #5174CE",
"Z+	c #5275D1",
"`+	c #5477D4",
" @	c #5678D9",
".@	c #587ADB",
"+@	c #597BDB",
"@@	c #5B7DDC",
"#@	c #5E7FDC",
"$@	c #6081DD",
"%@	c #6283DE",
"&@	c #6484DF",
"*@	c #6787E0",
"=@	c #6989E1",
"-@	c #6B8BE1",
";@	c #6D8DE2",
">@	c #6F8EE3",
",@	c #718FE4",
"'@	c #7290E4",
")@	c #7491E5",
"!@	c #7692E6",
"~@	c #7793E5",
"{@	c #7894E6",
"]@	c #7895E7",
"^@	c #7996E8",
"/@	c #7A97E8",
"(@	c #7B98E9",
"_@	c #7D99E8",
":@	c #7F9AE8",
"<@	c #7F9BE9",
"[@	c #7F9CEA",
"}@	c #859EE8",
"|@	c #859FE8",
"1@	c #85A0E9",
"2@	c #869FE9",
"3@	c #86A1E7",
"4@	c #86A0E9",
"5@	c #87A1E7",
"6@	c #88A2E7",
"7@	c #87A1E9",
"8@	c #5A6FCA",
"9@	c #365FCF",
"0@	c #345ED0",
"a@	c #385FCC",
"b@	c #385FCE",
"c@	c #3A61CC",
"d@	c #3B62CD",
"e@	c #3E64CD",
"f@	c #4167CF",
"g@	c #4469CF",
"h@	c #486CD1",
"i@	c #4D71D2",
"j@	c #5175D4",
"k@	c #5376D6",
"l@	c #5578DA",
"m@	c #5679DC",
"n@	c #587BDD",
"o@	c #5A7DDE",
"p@	c #5D80DE",
"q@	c #5F82DF",
"r@	c #6284DF",
"s@	c #6585E0",
"t@	c #6787E1",
"u@	c #6988E2",
"v@	c #6B8AE2",
"w@	c #6D8CE3",
"x@	c #6E8DE3",
"y@	c #708EE4",
"z@	c #718FE3",
"A@	c #7391E4",
"B@	c #7592E5",
"C@	c #7895E5",
"D@	c #7996E6",
"E@	c #7A97E6",
"F@	c #7B98E7",
"G@	c #7A98E8",
"H@	c #7B99E9",
"I@	c #7E9AE9",
"J@	c #7D9AE9",
"K@	c #7E9AEA",
"L@	c #809CE9",
"M@	c #819DE8",
"N@	c #7F9BEA",
"O@	c #819DE9",
"P@	c #819CE9",
"Q@	c #839EE9",
"R@	c #839EE8",
"S@	c #839DEA",
"T@	c #859FE9",
"U@	c #87A0E8",
"V@	c #86A0E8",
"W@	c #87A1E8",
"X@	c #3760CF",
"Y@	c #3A61CE",
"Z@	c #3A62CD",
"`@	c #3F66CE",
" #	c #4368D0",
".#	c #466CD2",
"+#	c #496DD5",
"@#	c #4E72D6",
"##	c #5175D8",
"$#	c #5276DA",
"%#	c #5578DC",
"&#	c #577ADC",
"*#	c #597CDD",
"=#	c #5B7DDD",
"-#	c #5D7FDE",
";#	c #5E81DE",
">#	c #6183DF",
",#	c #6386DF",
"'#	c #6687E0",
")#	c #6888E0",
"!#	c #6A89E1",
"~#	c #6C8AE1",
"{#	c #6E8CE2",
"]#	c #6F8DE2",
"^#	c #7390E4",
"/#	c #7390E3",
"(#	c #7491E4",
"_#	c #7693E5",
":#	c #7895E6",
"<#	c #7896E6",
"[#	c #7997E7",
"}#	c #7B97E7",
"|#	c #7B98E8",
"1#	c #7C98E8",
"2#	c #7E9BE9",
"3#	c #809CEA",
"4#	c #819CEA",
"5#	c #839DE9",
"6#	c #365FD0",
"7#	c #3660D0",
"8#	c #3961CF",
"9#	c #3B63CF",
"0#	c #3D64D0",
"a#	c #4067D0",
"b#	c #4469D2",
"c#	c #466BD3",
"d#	c #496ED5",
"e#	c #4C71D6",
"f#	c #4E72D8",
"g#	c #5074D9",
"h#	c #5376DB",
"i#	c #5578DB",
"j#	c #587ADC",
"k#	c #5B7CDC",
"l#	c #5D7EDD",
"m#	c #5F80DD",
"n#	c #6081DE",
"o#	c #6383DE",
"p#	c #6686DF",
"q#	c #6887E0",
"r#	c #6988E0",
"s#	c #6B89E1",
"t#	c #6C8AE0",
"u#	c #6E8CE1",
"v#	c #708EE2",
"w#	c #718FE2",
"x#	c #7290E3",
"y#	c #7391E2",
"z#	c #7492E1",
"A#	c #7592E2",
"B#	c #7691E3",
"C#	c #7591E3",
"D#	c #7692E3",
"E#	c #7693E3",
"F#	c #7793E4",
"G#	c #7893E4",
"H#	c #7994E5",
"I#	c #7D97E8",
"J#	c #7E98E8",
"K#	c #7D98E8",
"L#	c #7D99E9",
"M#	c #7D9BEA",
"N#	c #7D9CEA",
"O#	c #7E99E8",
"P#	c #7D9AEA",
"Q#	c #7C9BEA",
"R#	c #7C9CEA",
"S#	c #355FCF",
"T#	c #3860D0",
"U#	c #3A62D0",
"V#	c #3C64D1",
"W#	c #4167D1",
"X#	c #4369D3",
"Y#	c #466BD4",
"Z#	c #486DD5",
"`#	c #4A6ED7",
" $	c #4C70D8",
".$	c #5478D9",
"+$	c #577BDA",
"@$	c #597DDB",
"#$	c #5B7EDB",
"$$	c #5D7FDC",
"%$	c #6182DE",
"&$	c #6284DE",
"*$	c #6485DF",
"=$	c #6586DF",
"-$	c #6787DF",
";$	c #6888DF",
">$	c #6A8ADF",
",$	c #6C8BE0",
"'$	c #6D8CE0",
")$	c #6E8DE1",
"!$	c #6F8DE1",
"~$	c #708EE1",
"{$	c #718FE0",
"]$	c #728FE1",
"^$	c #7390E0",
"/$	c #738FE0",
"($	c #7490E1",
"_$	c #7590E1",
":$	c #7591E1",
"<$	c #7592E1",
"[$	c #7692E2",
"}$	c #7794E2",
"|$	c #7894E3",
"1$	c #7996E3",
"2$	c #7A96E5",
"3$	c #7B98E6",
"4$	c #7B9AE8",
"5$	c #7C99E8",
"6$	c #7C96E5",
"7$	c #7D97E7",
"8$	c #7C99E9",
"9$	c #7B9AE9",
"0$	c #7B9AEA",
"a$	c #5B6DCF",
"b$	c #305EC8",
"c$	c #335ECE",
"d$	c #305ECA",
"e$	c #345FCF",
"f$	c #3761D0",
"g$	c #3A62D1",
"h$	c #3C64D2",
"i$	c #4066D3",
"j$	c #466BD5",
"k$	c #486ED6",
"l$	c #4A6ED6",
"m$	c #4D71D8",
"n$	c #4F72D9",
"o$	c #5073D9",
"p$	c #4F72D8",
"q$	c #5074D8",
"r$	c #5276D9",
"s$	c #587ADA",
"t$	c #5B7CDB",
"u$	c #5D7EDC",
"v$	c #5F7FDD",
"w$	c #6081DC",
"x$	c #6182DD",
"y$	c #6283DD",
"z$	c #6484DE",
"A$	c #6585DD",
"B$	c #6787DE",
"C$	c #6988DF",
"D$	c #6A89DE",
"E$	c #6C8ADF",
"F$	c #6D8BDF",
"G$	c #6E8CE0",
"H$	c #6F8DE0",
"I$	c #718EE0",
"J$	c #728FDF",
"K$	c #728FDE",
"L$	c #7290E0",
"M$	c #7190E0",
"N$	c #7291E0",
"O$	c #7191E0",
"P$	c #7392E1",
"Q$	c #7493E1",
"R$	c #7594E1",
"S$	c #7594E2",
"T$	c #7694E2",
"U$	c #7695E2",
"V$	c #7A96E4",
"W$	c #7895E2",
"X$	c #7A96E2",
"Y$	c #7A96E3",
"Z$	c #7B96E3",
"`$	c #7996E1",
" %	c #7C96E4",
".%	c #305EC9",
"+%	c #315ECC",
"@%	c #325ECE",
"#%	c #3760D0",
"$%	c #3962D1",
"%%	c #3E66D3",
"&%	c #4268D4",
"*%	c #446BD5",
"=%	c #476CD6",
"-%	c #496ED7",
";%	c #4B6FD7",
">%	c #4C70D7",
",%	c #4E71D7",
"'%	c #5074D7",
")%	c #5276D8",
"!%	c #5376D8",
"~%	c #5779DA",
"{%	c #597ADA",
"]%	c #5A7BDB",
"^%	c #5B7CDA",
"/%	c #5D7EDB",
"(%	c #5E7FDB",
"_%	c #6182DB",
":%	c #6384DC",
"<%	c #6586DD",
"[%	c #6686DC",
"}%	c #6887DD",
"|%	c #6988DD",
"1%	c #6A8ADE",
"2%	c #6B8BDE",
"3%	c #6C8CDE",
"4%	c #6E8DDF",
"5%	c #6E8CDF",
"6%	c #6D8DDF",
"7%	c #6C8BDF",
"8%	c #6F8DDF",
"9%	c #718FDF",
"0%	c #7290DF",
"a%	c #7391E0",
"b%	c #7491E0",
"c%	c #7292E1",
"d%	c #3959C5",
"e%	c #345BC5",
"f%	c #315EC8",
"g%	c #355BC5",
"h%	c #325EC8",
"i%	c #315ECB",
"j%	c #345DCC",
"k%	c #335ECD",
"l%	c #345ECD",
"m%	c #355FCE",
"n%	c #3862D0",
"o%	c #3E66D2",
"p%	c #456BD5",
"q%	c #476CD5",
"r%	c #4B6ED7",
"s%	c #4B6FD6",
"t%	c #4B6FD5",
"u%	c #4D71D6",
"v%	c #5073D7",
"w%	c #5174D7",
"x%	c #5275D8",
"y%	c #5577D8",
"z%	c #5678D8",
"A%	c #5779D9",
"B%	c #587AD8",
"C%	c #597CD9",
"D%	c #5B7DD9",
"E%	c #5D7FDA",
"F%	c #5F80DB",
"G%	c #6182DC",
"H%	c #6484DC",
"I%	c #6585DC",
"J%	c #6787DD",
"K%	c #6988DE",
"L%	c #6B8ADE",
"M%	c #6B8ADF",
"N%	c #6989DE",
"O%	c #6B89DE",
"P%	c #6E8BDF",
"Q%	c #708CDE",
"R%	c #708DDF",
"S%	c #708FDF",
"T%	c #728EDF",
"U%	c #6F8EDD",
"V%	c #728EDD",
"W%	c #7390DF",
"X%	c #7490DF",
"Y%	c #335DC8",
"Z%	c #3759C5",
"`%	c #3859C5",
" &	c #335EC8",
".&	c #325DCA",
"+&	c #345CCB",
"@&	c #335DCC",
"#&	c #345DCD",
"$&	c #355FCD",
"%&	c #3861D0",
"&&	c #3B64D1",
"*&	c #3E65D2",
"=&	c #4168D3",
"-&	c #456AD5",
";&	c #4B6ED5",
">&	c #4C6FD4",
",&	c #4D70D5",
"'&	c #4F72D6",
")&	c #5173D6",
"!&	c #5375D7",
"~&	c #5476D8",
"{&	c #5577D7",
"]&	c #5477D8",
"^&	c #5677D8",
"/&	c #5879D9",
"(&	c #597AD9",
"_&	c #5C7DDA",
":&	c #6080DC",
"<&	c #6080DB",
"[&	c #6181DC",
"}&	c #6282DC",
"|&	c #6383DD",
"1&	c #6484DD",
"2&	c #6686DE",
"3&	c #6685DE",
"4&	c #6786DE",
"5&	c #6687DE",
"6&	c #6887DE",
"7&	c #6987DE",
"8&	c #6788DF",
"9&	c #6785DF",
"0&	c #6B89DF",
"a&	c #6C89DF",
"b&	c #6F8DDD",
"c&	c #6D8CDE",
"d&	c #445BBB",
"e&	c #3759BE",
"f&	c #375AC6",
"g&	c #355CC8",
"h&	c #345CCA",
"i&	c #355ECC",
"j&	c #365FCD",
"k&	c #3761CE",
"l&	c #3A63D0",
"m&	c #3D65D1",
"n&	c #466AD4",
"o&	c #476BD4",
"p&	c #486CD3",
"q&	c #4A6ED4",
"r&	c #4B6ED4",
"s&	c #4E71D6",
"t&	c #4F71D5",
"u&	c #5072D6",
"v&	c #5274D7",
"w&	c #5273D7",
"x&	c #5274D6",
"y&	c #5476D7",
"z&	c #5779D8",
"A&	c #587AD9",
"B&	c #5A7CDA",
"C&	c #5C7DDB",
"D&	c #5D7EDA",
"E&	c #6081DA",
"F&	c #6181DB",
"G&	c #6283DC",
"H&	c #6483DD",
"I&	c #6483DE",
"J&	c #6585DE",
"K&	c #6786DF",
"L&	c #6886DE",
"M&	c #6887DF",
"N&	c #6987DF",
"O&	c #6A88DF",
"P&	c #6786E0",
"Q&	c #6A86DE",
"R&	c #6B89E0",
"S&	c #365BC8",
"T&	c #365CC8",
"U&	c #375DCA",
"V&	c #375FCB",
"W&	c #3860CD",
"X&	c #3C63D0",
"Y&	c #4167D2",
"Z&	c #4268D2",
"`&	c #4368D2",
" *	c #4367D2",
".*	c #4568D2",
"+*	c #466AD2",
"@*	c #496CD3",
"#*	c #4A6DD3",
"$*	c #4A6DD4",
"%*	c #4D70D4",
"&*	c #4F72D5",
"**	c #4C70D4",
"=*	c #4E72D5",
"-*	c #5173D5",
";*	c #5375D6",
">*	c #597BDA",
",*	c #5B7DDA",
"'*	c #5C7EDB",
")*	c #5D7FDB",
"!*	c #5E80DB",
"~*	c #5E81DA",
"{*	c #5F81DB",
"]*	c #5F82DB",
"^*	c #6384DD",
"/*	c #6384DE",
"(*	c #6585DF",
"_*	c #6486E0",
":*	c #6583DD",
"<*	c #6386E0",
"[*	c #6686E0",
"}*	c #6B86DD",
"|*	c #6D86DD",
"1*	c #6086E0",
"2*	c #5573CD",
"3*	c #3959C3",
"4*	c #3959C4",
"5*	c #3759C0",
"6*	c #375BC7",
"7*	c #365CC7",
"8*	c #395FCC",
"9*	c #3B62CE",
"0*	c #3E64D0",
"a*	c #4066D1",
"b*	c #4166D1",
"c*	c #4064CF",
"d*	c #4065CF",
"e*	c #4266D0",
"f*	c #4468D1",
"g*	c #4569D1",
"h*	c #476BD2",
"i*	c #466AD1",
"j*	c #476AD2",
"k*	c #456AD1",
"l*	c #496DD2",
"m*	c #4A6FD3",
"n*	c #496ED2",
"o*	c #4B70D4",
"p*	c #4D71D4",
"q*	c #4E72D4",
"r*	c #5073D4",
"s*	c #5174D5",
"t*	c #5175D5",
"u*	c #5276D6",
"v*	c #5377D6",
"w*	c #5478D7",
"x*	c #5579D7",
"y*	c #567AD8",
"z*	c #577BD9",
"A*	c #597CD8",
"B*	c #5A7DD9",
"C*	c #5A7ED9",
"D*	c #5B7FDA",
"E*	c #5C80DA",
"F*	c #5D80DA",
"G*	c #5E81DB",
"H*	c #5D80DB",
"I*	c #6082DC",
"J*	c #6183DD",
"K*	c #6183DE",
"L*	c #6082DB",
"M*	c #6282DE",
"N*	c #6682DE",
"O*	c #6583DE",
"P*	c #3759BF",
"Q*	c #375AC2",
"R*	c #375AC1",
"S*	c #375AC4",
"T*	c #395DCA",
"U*	c #3A5ECA",
"V*	c #3C60CC",
"W*	c #3D61CD",
"X*	c #3D61CC",
"Y*	c #3C61CD",
"Z*	c #3E62CD",
"`*	c #3F64CE",
" =	c #4266CF",
".=	c #4468D0",
"+=	c #4267CF",
"@=	c #4166CE",
"#=	c #4065CE",
"$=	c #4166CD",
"%=	c #4267CE",
"&=	c #456AD0",
"*=	c #4368CE",
"==	c #4468CF",
"-=	c #4569D0",
";=	c #486BD1",
">=	c #4B6FD3",
",=	c #4C70D3",
"'=	c #4F73D4",
")=	c #5275D5",
"!=	c #5477D6",
"~=	c #577BD7",
"{=	c #587CD8",
"]=	c #577CD8",
"^=	c #597DD9",
"/=	c #5A7DDA",
"(=	c #597DDA",
"_=	c #587CDA",
":=	c #5A7EDA",
"<=	c #567BD8",
"[=	c #557AD9",
"}=	c #567BD9",
"|=	c #577CD9",
"1=	c #587DD9",
"2=	c #587ED9",
"3=	c #577ED8",
"4=	c #587DD8",
"5=	c #587ED8",
"6=	c #567ED7",
"7=	c #526ABD",
"8=	c #3759C1",
"9=	c #385BC7",
"0=	c #395CC8",
"a=	c #3B5DC9",
"b=	c #3B5ECA",
"c=	c #3A5FCA",
"d=	c #3B60CC",
"e=	c #3C61CC",
"f=	c #3D62CD",
"g=	c #3E63CD",
"h=	c #3C61CB",
"i=	c #3C61CA",
"j=	c #3D62CB",
"k=	c #3F64CC",
"l=	c #4065CD",
"m=	c #4669D0",
"n=	c #476AD0",
"o=	c #496BD1",
"p=	c #4A6DD2",
"q=	c #4B6ED2",
"r=	c #4D71D3",
"s=	c #4E73D4",
"t=	c #4F74D4",
"u=	c #5075D5",
"v=	c #5276D5",
"w=	c #5377D7",
"x=	c #5278D7",
"y=	c #5277D6",
"z=	c #5378D7",
"A=	c #5379D8",
"B=	c #5379D9",
"C=	c #5278D8",
"D=	c #5178D7",
"E=	c #3355C0",
"F=	c #3556C1",
"G=	c #395AC6",
"H=	c #385AC7",
"I=	c #395BC7",
"J=	c #395EC9",
"K=	c #395FCA",
"L=	c #3B60CA",
"M=	c #3B60CB",
"N=	c #375DC7",
"O=	c #385EC8",
"P=	c #395FC9",
"Q=	c #3A60CA",
"R=	c #3D63CC",
"S=	c #4367CF",
"T=	c #476BD1",
"U=	c #4A6ED2",
"V=	c #4B6FD2",
"W=	c #4C6FD2",
"X=	c #4D70D1",
"Y=	c #4E71D2",
"Z=	c #4E72D2",
"`=	c #4E74D4",
" -	c #4E75D5",
".-	c #4E75D4",
"+-	c #4F75D3",
"@-	c #5075D2",
"#-	c #5075D3",
"$-	c #5177D7",
"%-	c #5178D8",
"&-	c #4F75D5",
"*-	c #5076D5",
"=-	c #4F76D6",
"--	c #5279D9",
";-	c #3C52B1",
">-	c #3656C3",
",-	c #3757C5",
"'-	c #3758C6",
")-	c #3759C6",
"!-	c #375BC6",
"~-	c #385CC7",
"{-	c #385DC8",
"]-	c #365CC6",
"^-	c #355BC6",
"/-	c #355CC6",
"(-	c #365DC7",
"_-	c #375EC8",
":-	c #375CC6",
"<-	c #385EC6",
"[-	c #3A5FC7",
"}-	c #3C60C8",
"|-	c #3D61C9",
"1-	c #3E62CA",
"2-	c #4063CC",
"3-	c #4165CE",
"4-	c #4268D0",
"5-	c #4269D1",
"6-	c #436AD2",
"7-	c #446AD2",
"8-	c #456BD2",
"9-	c #496CD1",
"0-	c #4C6CD0",
"a-	c #4D6CCF",
"b-	c #4E6DD0",
"c-	c #4F6ECF",
"d-	c #4E6FCF",
"e-	c #4C70CF",
"f-	c #4A71D0",
"g-	c #4F6FCF",
"h-	c #4B71D0",
"i-	c #4A72D1",
"j-	c #4B73D4",
"k-	c #4F70D0",
"l-	c #4C73D3",
"m-	c #4C73D6",
"n-	c #4B72D2",
"o-	c #4B71D1",
"p-	c #4C73D7",
"q-	c #3354C0",
"r-	c #3152BE",
"s-	c #3052BE",
"t-	c #3051BF",
"u-	c #2E4FBF",
"v-	c #2E4FBE",
"w-	c #2E50BF",
"x-	c #2F50BF",
"y-	c #3156C4",
"z-	c #2F56C5",
"A-	c #2E57C5",
"B-	c #2F57C5",
"C-	c #3057C6",
"D-	c #3258C6",
"E-	c #3459C7",
"F-	c #365AC7",
"G-	c #385BC8",
"H-	c #3B5DCA",
"I-	c #3B5DCB",
"J-	c #3C5ECC",
"K-	c #3C60CD",
"L-	c #3C62CE",
"M-	c #3D65D0",
"N-	c #3D66D1",
"O-	c #4166D2",
"P-	c #4667D2",
"Q-	c #4A67D1",
"R-	c #4C68D0",
"S-	c #4C69CF",
"T-	c #4D6BCE",
"U-	c #4E6DCD",
"V-	c #4E6ECE",
"W-	c #4E6DCE",
"X-	c #4970D0",
"Y-	c #4770D0",
"Z-	c #4B6BCE",
"`-	c #4A6CCE",
" ;	c #496DCF",
".;	c #476FD0",
"+;	c #4870D0",
"@;	c #486DCF",
"#;	c #242F79",
"$;	c #2F41AC",
"%;	c #2040B8",
"&;	c #2041B8",
"*;	c #2243B3",
"=;	c #2243B8",
"-;	c #2343B8",
";;	c #2444B8",
">;	c #2445B8",
",;	c #2445B6",
"';	c #2445B7",
");	c #2444B9",
"!;	c #2949BE",
"~;	c #2649BF",
"{;	c #234BBF",
"];	c #224CBF",
"^;	c #224AC0",
"/;	c #244CC0",
"(;	c #254DC0",
"_;	c #254DC1",
":;	c #264DC2",
"<;	c #274EC3",
"[;	c #274CC3",
"};	c #274DC4",
"|;	c #254DC5",
"1;	c #214EC5",
"2;	c #204FC6",
"3;	c #1F50C8",
"4;	c #2151C9",
"5;	c #2B53C8",
"6;	c #3154C7",
"7;	c #3255C6",
"8;	c #2F57C7",
"9;	c #2C58C9",
"0;	c #2D59CA",
"a;	c #2D58C9",
"b;	c #2E5BCC",
"c;	c #325ECC",
"d;	c #325ECB",
"e;	c #1F40B1",
"f;	c #1F40B2",
"g;	c #1F40B3",
"h;	c #2A44BD",
"i;	c #2845BE",
"j;	c #2745BE",
"k;	c #2646BF",
"l;	c #2546BE",
"m;	c #2347BF",
"n;	c #2147BF",
"o;	c #2048C0",
"p;	c #1D48C0",
"q;	c #1C48C0",
"r;	c #1B47C0",
"s;	c #1C48BF",
"t;	c #1E49BE",
"u;	c #214ABD",
"v;	c #244CBD",
"w;	c #264DBE",
"x;	c #254EC0",
"y;	c #214FC2",
"z;	c #1B51C5",
"A;	c #1C51C7",
"B;	c #2250C8",
"C;	c #2A52C8",
"D;	c #3254C6",
"E;	c #3355C5",
"F;	c #3154C8",
"G;	c #3355C6",
"H;	c #2F57C8",
"I;	c #2E58C9",
"J;	c #2E59C9",
"K;	c #3059C9",
"L;	c #2040B6",
"M;	c #2743BB",
"N;	c #2844BC",
"O;	c #2743BD",
"P;	c #2844BE",
"Q;	c #2844BD",
"R;	c #2346BE",
"S;	c #2047BF",
"T;	c #1E48C0",
"U;	c #1D47C0",
"V;	c #1D49BF",
"W;	c #1F49BF",
"X;	c #204ABE",
"Y;	c #254DBF",
"Z;	c #234EC0",
"`;	c #2050C1",
" >	c #1C51C3",
".>	c #1F51C6",
"+>	c #2651C8",
"@>	c #2D53C7",
"#>	c #3155C6",
"$>	c #3155C7",
"%>	c #3355C7",
"&>	c #3254C7",
"*>	c #1E40B1",
"=>	c #2141B8",
"->	c #2442B9",
";>	c #2744BB",
">>	c #2945BB",
",>	c #2A45BB",
"'>	c #2944BA",
")>	c #2745BB",
"!>	c #2545BC",
"~>	c #2246BD",
"{>	c #2047BE",
"]>	c #1F47BD",
"^>	c #1D48BE",
"/>	c #1E49C0",
"(>	c #1F4AC0",
"_>	c #214BBF",
":>	c #244CBE",
"<>	c #254DBE",
"[>	c #244DBE",
"}>	c #224FBF",
"|>	c #2051C1",
"1>	c #2151C3",
"2>	c #2252C5",
"3>	c #2151C1",
"4>	c #2851C6",
"5>	c #2A50C6",
"6>	c #2E54C6",
"7>	c #1F51C2",
"8>	c #1D52C5",
"9>	c #2651C9",
"0>	c #2950C7",
"a>	c #2D40A5",
"b>	c #2040B0",
"c>	c #1F40B0",
"d>	c #223CAE",
"e>	c #233CAE",
"f>	c #253BAC",
"g>	c #253BAD",
"h>	c #233CB0",
"i>	c #213EB2",
"j>	c #1F3FB4",
"k>	c #1E40B6",
"l>	c #1F3FB7",
"m>	c #1E3EB8",
"n>	c #1F3FB8",
"o>	c #2040B7",
"p>	c #2141B6",
"q>	c #2140B7",
"r>	c #2241B6",
"s>	c #2342B5",
"t>	c #2442B6",
"u>	c #2543B5",
"v>	c #2643B4",
"w>	c #2544B6",
"x>	c #2346B8",
"y>	c #2247B9",
"z>	c #2048BC",
"A>	c #1F48BF",
"B>	c #2049C0",
"C>	c #214AC0",
"D>	c #224BBF",
"E>	c #234CBE",
"F>	c #244DBF",
"G>	c #234CBF",
"H>	c #264DC0",
"I>	c #274EBF",
"J>	c #264DBF",
"K>	c #254EBF",
"L>	c #2050C0",
"M>	c #1F51C1",
"N>	c #1E42A4",
"O>	c #263BA6",
"P>	c #253BA7",
"Q>	c #253CA7",
"R>	c #1E41A5",
"S>	c #1F40AF",
"T>	c #273AAC",
"U>	c #1E40B0",
"V>	c #1F40B5",
"W>	c #1F40B6",
"X>	c #1F40B8",
"Y>	c #1E40B8",
"Z>	c #1F3EB8",
"`>	c #203FB7",
" ,	c #2240B6",
".,	c #2341B7",
"+,	c #2345B9",
"@,	c #2147BB",
"#,	c #2148BA",
"$,	c #2049BB",
"%,	c #2049BD",
"&,	c #2049BF",
"*,	c #224BBE",
"=,	c #244DBD",
"-,	c #244CBF",
";,	c #182969",
">,	c #273BAD",
",,	c #2739AB",
"',	c #263AAC",
"),	c #243CAE",
"!,	c #233DAE",
"~,	c #213EAF",
"{,	c #1F3FB0",
"],	c #2040B4",
"^,	c #1F3FB6",
"/,	c #1E3EB7",
"(,	c #2240B7",
"_,	c #2341B6",
":,	c #2543B4",
"<,	c #2644B3",
"[,	c #2544B5",
"},	c #2545B5",
"|,	c #2547B6",
"1,	c #2548B7",
"2,	c #2349BA",
"3,	c #1F49BE",
"4,	c #2149BD",
"5,	c #2049BE",
"6,	c #214BBE",
"7,	c #2249BE",
"8,	c #234CBD",
"9,	c #2149BE",
"0,	c #1E49BF",
"a,	c #253BA9",
"b,	c #253BAB",
"c,	c #263AAB",
"d,	c #213DAF",
"e,	c #203EAF",
"f,	c #1D40AF",
"g,	c #1D40B0",
"h,	c #1E40B4",
"i,	c #2241B7",
"j,	c #2643B6",
"k,	c #2744B5",
"l,	c #2643B5",
"m,	c #2346B6",
"n,	c #2147B7",
"o,	c #2644B6",
"p,	c #2247B7",
"q,	c #2248B8",
"r,	c #2647B7",
"s,	c #2549B7",
"t,	c #2645B7",
"u,	c #2148B8",
"v,	c #2847B6",
"w,	c #2549B6",
"x,	c #2849B6",
"y,	c #2049B7",
"z,	c #2A49B5",
"A,	c #243BA4",
"B,	c #253BA5",
"C,	c #253BA6",
"D,	c #263AA7",
"E,	c #263AA8",
"F,	c #2739AA",
"G,	c #243CAD",
"H,	c #223DAE",
"I,	c #1F3EAF",
"J,	c #1E3FB0",
"K,	c #1D40B1",
"L,	c #1E3FB1",
"M,	c #1F3FB3",
"N,	c #1F3FB5",
"O,	c #2140B6",
"P,	c #2140B8",
"Q,	c #2744B4",
"R,	c #2746B6",
"S,	c #2947B6",
"T,	c #2946B5",
"U,	c #2A48B6",
"V,	c #3551A8",
"W,	c #1F399C",
"X,	c #143D9F",
"Y,	c #263BA5",
"Z,	c #273BA8",
"`,	c #273BAA",
" '	c #263AAD",
".'	c #233CAD",
"+'	c #213DAE",
"@'	c #203FB2",
"#'	c #2342B6",
"$'	c #2443B6",
"%'	c #2543B6",
"&'	c #2644B5",
"*'	c #133D9E",
"='	c #263BA7",
"-'	c #263BA9",
";'	c #273BA9",
">'	c #263AAA",
",'	c #2539AB",
"''	c #2639AB",
")'	c #253AAC",
"!'	c #243BAD",
"~'	c #223DAF",
"{'	c #203FB0",
"]'	c #2040B1",
"^'	c #2140B3",
"/'	c #2543B1",
"('	c #2744AF",
"_'	c #1A3CA0",
":'	c #1D3BA2",
"<'	c #233BA4",
"['	c #263AA5",
"}'	c #253AA5",
"|'	c #263AA6",
"1'	c #263BA4",
"2'	c #243BA5",
"3'	c #263BA8",
"4'	c #223EAF",
"5'	c #3B4CA5",
"6'	c #1D379A",
"7'	c #1E389C",
"8'	c #1E399F",
"9'	c #1F3BA2",
"0'	c #1F3BA3",
"a'	c #213BA4",
"b'	c #233AA3",
"c'	c #243AA3",
"d'	c #2539A4",
"e'	c #253AA6",
"f'	c #243BA7",
"g'	c #253CAA",
"h'	c #253CAC",
"i'	c #253CAD",
"j'	c #253CAE",
"k'	c #243DAE",
"l'	c #213FAF",
"m'	c #223FAF",
"n'	c #2040AF",
"o'	c #253D93",
"p'	c #1D3894",
"q'	c #1F379A",
"r'	c #1E389B",
"s'	c #1D399C",
"t'	c #1C3A9D",
"u'	c #1B3A9D",
"v'	c #183B9E",
"w'	c #163C9E",
"x'	c #153C9E",
"y'	c #163B9D",
"z'	c #173B9D",
"A'	c #193A9D",
"B'	c #1C3A9E",
"C'	c #1F3AA1",
"D'	c #223AA4",
"E'	c #253BA8",
"F'	c #273BA7",
"G'	c #263CAB",
"H'	c #263CAC",
"I'	c #243EAE",
"J'	c #273BAC",
"K'	c #2A3795",
"L'	c #1F389B",
"M'	c #1D389B",
"N'	c #1C399C",
"O'	c #1B399C",
"P'	c #1A3A9D",
"Q'	c #1D399B",
"R'	c #1B399B",
"S'	c #1A3A9C",
"T'	c #1B3A9F",
"U'	c #1D3AA0",
"V'	c #203BA2",
"W'	c #203BA3",
"X'	c #2639A6",
"Y'	c #1B3692",
"Z'	c #1C3794",
"`'	c #1D3796",
" )	c #1E3898",
".)	c #1E389A",
"+)	c #1F399B",
"@)	c #1A399C",
"#)	c #193A9E",
"$)	c #1A3BA0",
"%)	c #1C3BA2",
"&)	c #1D3CA3",
"*)	c #203CA4",
"=)	c #223BA5",
"-)	c #3C4699",
";)	c #2B4595",
">)	c #1C3793",
",)	c #1D3895",
"')	c #1E3897",
"))	c #1F3998",
"!)	c #1F3999",
"~)	c #1F399A",
"{)	c #1E399C",
"])	c #1C3B9E",
"^)	c #1D3BA0",
"/)	c #1E3CA2",
"()	c #223CA5",
"_)	c #243CA6",
":)	c #596FA9",
"<)	c #3B4894",
"[)	c #314993",
"})	c #29499F",
"|)	c #28489E",
"1)	c #2B4BA1",
"2)	c #2C4BA1",
"3)	c #2D4CA2",
"4)	c #2E4CA3",
"5)	c #2F4CA4",
"6)	c #2E4CA4",
"7)	c #2F4DA3",
"8)	c #2F4DA4",
"9)	c #D3D5D2",
"0)	c #3B4794",
"a)	c #314791",
"b)	c #304892",
"c)	c #304893",
"d)	c #2F4995",
"e)	c #2F4997",
"f)	c #2D4A9A",
"g)	c #2A4A9D",
"h)	c #294A9F",
"i)	c #284AA0",
"j)	c #294AA0",
"k)	c #2B4AA1",
"l)	c #2D4CA3",
"m)	c #C9CAC9",
"n)	c #455D9B",
"o)	c #242F78",
"p)	c #1B2F85",
"q)	c #C6C3C8",
"r)	c #B5B2B6",
"s)	c #B5B7B4",
"t)	c #B5B7B3",
"u)	c #B5B2B5",
"v)	c #B5B3B4",
"w)	c #B5B5B4",
"x)	c #B5B6B3",
"y)	c #B5B4B4",
"z)	c #B5B3B5",
"A)	c #B5B4B5",
"B)	c #B5B5B5",
"C)	c #B5B5B3",
"D)	c #B5B5B6",
"E)	c #BAC3BE",
"F)	c #B9C3BD",
"G)	c #C1C3C4",
"H)	c #BFC3C2",
"I)	c #B9C3BE",
"J)	c #BBC3BF",
"K)	c #BDC3C1",
"L)	c #C0C3C3",
"M)	c #BEC3C1",
"N)	c #C2C3C5",
"O)	c #E6E3E8",
"P)	c #E0E2DF",
"Q)	c #E1E1E1",
"R)	c #E2E1E3",
"S)	c #E4E1E6",
"T)	c #E4E2E7",
"U)	c #E4E2E6",
"V)	c #E3E3E4",
"W)	c #E2E3E3",
"X)	c #E1E3E2",
"Y)	c #E3E3E3",
"Z)	c #E3E3E2",
"`)	c #EBEDEA",
" !	c #EAECE9",
".!	c #E9EBE8",
"+!	c #ECEEEB",
". . + @ # $ $ $ $ $ $ $ % $ $ $ $ $ % $ $ $ $ $ $ % $ $ $ $ $ % $ $ $ $ $ $ $ $ $ % $ $ & * = - ; > , , ' ) ! ! ~ { ] ^ / ( _ : < [ } | | 1 2 3 3 4 4 4 4 4 4 4 5 6 4 4 4 5 6 7 8 9 4 5 6 7 8 9 6 7 8 9 ",
"0 a b % $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ $ c d d d d $ $ $ $ $ c d e f g h i i i i j k l m n o p q r s t u v w x y z 4 A B C D 9 9 E 9 E F G H I F J K L L L L J K L L L L L L L L ",
"@ % M N O O O O O O O O O O O O O O O O O O O O O O O O O O O O O O O O O O O O O O P Q R S T U V W X Y Z `  ...+.@.#.$.%.&.*.=.-.;.>.,.'.).!.~.{.].^./.(._.:.<.[.}.|.1.2.3.4.5.6.7.8.9.0.a.b.b.b.b.b.b.",
"c.$ d.O e.f.g.g.g.h.g.g.g.g.g.h.h.g.g.g.g.g.h.h.g.g.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.A.B.C.D.E.F.G.H.I.J.K.L.M.N.O.P.Q.R.S.T.U.V.W.X.Y.Z.`. +.+++@+#+$+@+$+%+&+*+=+$+-+;+>+,+'+)+!+;+>+,+~+,+>+,+~+,+",
"$ {+N N f.f.f.f.h.h.h.g.f.f.h.h.h.h.g.f.f.h.h.h.h.]+^+/+(+h._+:+<+[+}+|+1+2+3+4+5+6+7+8+9+0+a+b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+y+z+A+B+.+C+D+E+D+F+G+H+C+I+F+G+J+K+L+H+F+G+J+K+L+H+J+H+J+H+",
"{+{+N N M+M+h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.N+N+h.h.(+O+P+P+Q+R+S+T+U+V+W+X+Y+Z+`+ @.@+@@@#@$@%@&@*@=@-@;@>@,@'@)@!@~@{@]@^@/@(@_@:@<@[@[@y+}@|@1@A+1@2@3@ +2@4@2@5@C+D+6@D+7@5@C+D+6@I+C+D+6@I+",
"{+{+8@N M+M+h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.9@9@0@N+a@b@c@d@e@f@g@h@i@j@k@l@m@n@o@p@q@r@s@t@u@v@w@x@y@z@A@B@q+r+C@D@E@F@G@H@_@I@J@K@<@L@M@N@O@P@Q@R@S@T@A+A+U@V@W@W@A+2@U@V@W@W@U@V@W@W@",
"{+{+8@N f.M+h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.(+(+(+9@9@X@Y@Z@e@`@ #.#+#@###$#%#&#*#=#-#;#>#,#'#)#!#~#{#]#z@^#/#(#p+_#r+:#s+t+<#[#}#|#|#1#_@|#_@_@2#L@3#4#y+y+5#z+z+z+5#z+z+z+z+A+A+A+A+A+",
"{+{+8@8@f.f.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.(+6#7#8#9#0#a#b#c#d#e#f#g#h#i#j#k#l#m#n#o#&@p#q#r#s#t#u#v#w#x#x#y#y#z#A#B#C#D#E#E#F#G#H#F#H#H#u+v+I#J#K#L#J@J@M#N#O#P#M#M#M#N#M#Q#Q#R#",
"$ {+8@e.f.f.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.h.S#l.7#T#U#V#W#X#Y#Z#`# $f#g###.$+$@$#$$$$@%$&$*$=$-$;$>$,$'$)$!$~$~${$]$^$/$($($_$_$:$<$_$<$[$}$|$|$1$2$2$3$}#4$5$6$7$8$8$9$8$8$8$0$8$",
"$ {+a$e.f.f.h.h.h.h.h.h.h.h.h.b$h.c$c$c$c$c$d$c$c$c$c$c$c$c$c$c$c$e$e$7#f$g$h$i$X#j$k$l$m$n$o$p$q$r$l@s$t$u$v$w$x$y$z$A$B$C$D$E$F$G$G$H$I$J$J$K$K$J$L$L$L$L$L$M$N$O$P$Q$R$S$T$U$1$V$T$W$X$Y$1$V$Y$Z$`$ %",
"$ $ a$a$f.f.b$b$b$b$b$b$b$b$b$b$b$b$b$b$b$b$b$b$.%b$b$b$.%d$+%+%@%h.e$l.#%$%h$%%&%*%=%-%;%>%,%'%)%!% @ @~%{%]%^%/%(%w$_%:%<%[%}%|%D$1%2%3%4%5%4%4%6%5%5%4%4%4%5%7%5%8%9%L$0%a%a%a%P$b%P$P$z#z#z#P$c%c%c%",
"$ $ 8@e.f.f.d%b$b$b$b$b$d%b$b$b$b$b$b$e%f%b$b$b$b$b$g%h%b$.%i%i%j%k%l%m%X@n%h$o%&%p%q%`#r%s%t%u%v%w%x%y% @z%A%B%C%D%E%F%G%:%H%I%[%J%}%K%|%D$K%D$D$L%M%M%M%M%M%D$N%O%i+P%j+Q%R%S%T%0%U%V%W%W%W%W%X%X%X%X%",
"$ $ 8@8@f.f.d%d%b$b$b$b$d%d%b$b$b$h%Y%Z%Z%h%f%f%h%Y%`%`% &h%h%.&+&@&#&$&X@%&&&*&=&-&j$Z#+#;&>&,&'&)&)&!&~&{&]&^&/&(&^%_&(%:&<&[&}&|&1&A$A$2&3&4&4&5&B$6&7&B$7&8&9&6&7&0&a&a&i+i+i+b&a&a&j+U%c&U%j+U%c&U%",
"$ $ 8@8@d&e&d%d%d%d%d%d%d%d%d%d%d%`%d%d%d%d%`%`%`%d%d%d%d%`%`%f&g&h&j%i&j&k&l&m&=&X#Y#n&o&p&q&r&>&s&t&t&u&v&w&x&y&{&z&A&B&C&D&(%(%F%F%E&F&}&}&|&G&|&H&1&I%I&A$1&}&z$z$J&K&L&M&N&O&0&P&Q&0&a&R&a&a&a&R&a&",
"{+$ 8@8@e&e&d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%`%f&S&T&U&V&W&Y@X&Y&Z&`& *.*+*@*#*@*r&$*#*r&%*&***=*-*;*y&z%A%z&A&A&>*B&,*,*'*)*!*!*~*{*F&}&{*}&{*]*G%G%y$^*/*J&(*2&_*:*<*=$[*}*<*=$<*|*1*",
"{+{+8@2*e&e&d%d%d%d%d%d%d%d%d%e&3*4*4*4*4*4*5*4*4*4*4*4*4*4*4*4*`%f&6*6*7*8*9*0*a*b*c*d*e*f*g*h*i*j*+*k*h*l*m*n*m*o*p*q*r*s*t*u*v*w*x*y*y*z*A*B*C*D*E*F*G*E*G*F*H*G*F*~*]*{*I*x$J*K*L*G%K*M*o#o#I&N*O*O*",
"{+{+8@2*e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&P*e&e&e&e&e&e&P*P*e&e&e&P*P*5*Q*R*S*T*U*V*W*X*Y*Z*`*d* =.=+=@=#=$=%=g@&=*===-=i*;=l*>=,=q*'=s*)=k@!=x*~={=]=^=/=(=_=:=(=<=<=]=[=}=|=]=]=1=2=3=|=4=5=2=2=2=3=6=6=6=",
"{+{+7=e.e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&e&P*P*8=9=0=a=b=U*c=d=e=f=e@#=g=h=i=i=j=k=k=l=%===m=n=o=p=q=,=r=s=t=u=v=v*w=x=x=y=z=z=A=z=A=B=C=B=D=C=B=x=B=B=B=B=B=B=B=B=B=B=B=B=B=B=",
"{+{+7=7=e&e&e&e&E=E=e&e&e&e&E=E=E=e&e&e&e&E=E=E=e&e&e&e&E=E=e&e&e&e&E=E=E=F=d%G=G=H=I=J=K=L=M=R+}+N=O=P=Q=j=i=h=R=e@@=S=-=T=h@l*U=V=W=X=Y=Z=`= - - -.-+-@- -#-$-%-$-&-*-$-=-%-----C=$-%---------B=B=B=B=",
"{+{+7=7=;-;-E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=E=>-,-'-)-!-6*~-{-{-]-^-/-/-(-_-:-N=<-[-}-|-1-2-3- =4-5-6-7-8-9-0-0-a-b-c-d-e-f-g-h-h-i-j-k-h-h-i-j-l-m-n-o-i-j-l-m-n-j-l-p-n-",
"{+{+7=7=;-;-E=E=E=E=E=E=E=E=q-r-s-t-t-u-u-v-v-v-u-w-x-u-u-u-u-u-u-u-u-v-v-u-u-u-u-u-v-v-u-u-u-u-v-v-u-y-z-A-B-C-D-E-E-F-G-H-I-J-K-L-M-N-O-P-Q-R-S-T-U-U-V-W-V-e-X-Y-Z-`- ;.;Y-N N +;@;.;Y-N N N N N N N ",
"#;#;d&d&$;$;%;%;%;%;%;%;%;%;&;*;=;-;-;-;;;>;,;>;>;>;;;>;>;>;>;>;>;>;>;>;';);>;>;>;>;>;';>;>;>;>;>;';);!;~;{;];^;/;(;_;_;:;<;[;};};|;1;2;3;4;5;6;7;8;9;9;0;a;0;0;b;h.a;0;0;b;h.c;h.d;0;b;h.c;h.d;h.c;h.d;",
"#;#;;-;-$;$;e;e;e;e;e;e;e;e;e;e;e;f;f;f;f;e;e;e;f;f;f;f;f;f;f;f;f;f;f;f;g;%;f;f;f;f;f;g;f;f;f;f;f;g;%;h;i;j;k;l;m;n;o;p;q;r;r;s;t;u;v;w;x;y;z;A;B;C;6;D;E;F;G;G;H;I;F;G;G;H;I;J;J;K;G;H;I;J;J;K;I;J;J;K;",
"#;#;;-;-$;$;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;L;e;e;e;e;e;e;e;e;e;e;e;e;L;M;N;O;P;Q;i;i;k;R;S;T;U;q;q;V;W;X;{;Y;Z;`; >.>+>@>#>+>$>6;#>#>+>%>&>G;G;G;G;G;&>G;G;G;G;G;G;G;G;G;",
"#;#;d.;-$;$;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;*>e;e;e;e;e;e;e;e;e;e;e;e;*>=>->;>>>,>'>'>)>!>~>{>]>^>^>V;V;/>(>_>:><>[>}>|>1>2>3>2>4>5>6>7>8>9>0>G;G;G;G;9>0>G;G;G;G;G;G;G;G;",
"#;#;d.d.a>a>e;e;e;e;e;e;e;e;e;e;b>b>c>c>c>c>c>b>e;e;e;e;e;e;e;e;e;e;e;e;e;e;d>e>f>g>h>i>j>k>l>l>m>m>n>n>o>o>p>q>r>r>s>t>u>v>v>u>w>';x>y>z>t;A>B>C>D>E>E>F>G>F>H>H>I>F>Y;J>w;K>L>K>M>J>w;K>L>K>M>K>L>K>M>",
"#;#;d.d.a>a>N>e;N>O>O>O>N>e;N>O>O>P>Q>R>S>R>Q>O>O>O>N>e;N>O>O>O>N>e;N>N>O>T>e;e;e;U>U>U>U>f;V>W>o>o>o>o>X>X>Y>Y>n>n>Z>Z>`> ,.,t>t>u>u>w>+,@,#,$,%,A>&,*,=,B>[>-,w;<>C>[>-,w;w;w;w;w;-,w;w;w;w;w;w;w;w;w;",
"#;;,;-;-a>a>N>N>N>O>O>O>N>N>N>O>O>O>O>N>N>N>O>O>O>O>N>N>N>O>O>O>N>N>N>N>O>>,,,,,,,',g>),!,~,{,{,*>U>e;f;],o>%;o>^,^,/,/,l>q>(,_,t>u>:,<,v>[,},|,1,2,%,%,3,4,5,6,7,8,9,5,6,0,G>G>Y;G>6,0,G>G>Y;G>G>G>Y;G>",
";,;,;-;-O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>P>a,b,',',c,c,f>),e>d,e,{,{,U>U>f,f,U>U>g,g,*>g;h,^,^,`>`>q>i,t>j,k,k,l,w>m,n,o,p,q,r,s,t,p,u,v,w,x,y,z,u,v,w,x,y,z,w,x,y,z,",
";,;,b b O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>A,A,A,B,C,D,E,F,c,',g>G,!,H,~,e,{,I,J,J,K,K,U>f,f,J,L,M,N,L;O,i,P,.,l,Q,k,k,k,k,k,k,R,v,k,k,k,R,v,S,T,U,k,R,v,S,T,U,v,S,T,U,",
";,;,b V,W,W,X,X,O>X,X,X,X,X,O>X,X,X,X,X,X,O>X,X,X,X,X,X,O>X,X,X,X,X,O>X,X,O>O>O>O>B,B,B,B,Y,O>O>Z,`,T>T> '',g>.'+'e,{,{,e,+'+'e,e,{,J,K,e;@'N,O,#'$'%'%'j,%'j,&'k,k,%'j,&'k,k,k,k,k,&'k,k,k,k,k,k,k,k,k,",
";,;,b V,W,W,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,*'O>O>O>O>O>O>O>O>B,B,A,A,B,C,='-'`,;'>'>',''')'!'!'e>e>~'~'~,~,{'{,*>*>e;]']']']']']'^'/']']']'^'/':,(':,]'^'/':,(':,/':,(':,",
";,;,V,V,W,W,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,_':'<'['}'|'|'O>O>O>O>O>O>O>Y,Y,1'1'B,B,2'2'C,3'-'>'c,)')'!'),4'{'e;]'e;*>*>e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;e;",
";,;,5'5'W,W,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,X,W,6'6'6'7'8'9'0'a'b'c'd'd'}'}'O>O>O>O>O>O>O>O>Y,1'1'['['e'e'f'g'h'i'j'k'G,),!,l'j'm'n'b>b>),m'b>e;e;e;e;e;b>e;e;e;e;e;e;e;e;e;",
";,;,b b o'o'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'W,q'q'q'r's't'u'v'w'x'y'z'A'B'C'D'2'2'B,B,O>O>O>O>O>O>O>O>O>O>O>Y,Y,C,C,='='='E'F'3'3'3'G'Z,='F'F'G'H'I'J'F'F'G'H'I'J'G'H'I'J'",
";,;,b b K'K'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'W,W,W,W,W,L'L'q'r'M'N'O'P'u'N's'Q'R'S'A'T'U'C'V'9'0'W'D'}'X'|'O>O>B,B,O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>",
";,;,b b K'K'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'p'Y'Y'Y'Z'`' ).)+)+)+)W,W,W,W,L'L'q'q'r'r's'M'N'P'@)A'#)$)%)&)*)=)B,|'|'O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>O>",
"{+;,$ -);)K'p'p'o'p'p'p'p'p'o'p'p'p'p'p'p'o'p'p'p'p'p'p'o'p'p'p'p'p'o'o'p'p'p'p'p'p'p'p'p'p'>)>)Y'Y'>)Z',)')))!)~)+)W,W,W,W,W,W,W,W,W,W,W,L'L'{)s't'])^)/)])/)/)O>()])/)/)O>()O>_)O>/)O>()O>_)O>()O>_)O>",
":);,;,;)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)[)M M M M M M M M M M M M M M M M M M })})|)|)})M M 1)2)3)4)5)6)6)6)7)7)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)",
"9)#;;,;,$ -)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)<)0)a)a)a)b)c)d)e)f)g)h)i)i)j)j)M M M M M M M M M M M })})})})M k)k)M M k)l)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)8)",
"+ 9)m)n)$ #;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;#;o)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)p)",
"+ + 9)a m)q)r)s)r)s)r)s)r)s)r)r)s)r)s)r)s)r)r)s)r)s)r)s)r)s)r)s)r)s)r)s)r)t)u)v)w)x)x)w)y)z)A)A)B)B)B)B)w)w)C)C)w)w)B)B)B)B)B)w)w)w)w)B)B)B)B)B)B)B)B)B)B)B)B)B)B)B)B)B)B)B)B)B)D)B)B)B)B)B)D)B)B)B)D)B)",
". + + 9)9)9)q)E)q)E)q)E)q)E)q)q)E)q)E)q)E)q)q)E)q)E)q)E)q)E)q)E)q)E)q)E)q)F)G)H)E)I)J)K)H)L)L)L)L)L)L)L)H)H)M)M)H)H)L)L)G)L)L)H)H)H)H)L)L)L)L)L)L)L)L)L)L)L)L)L)L)L)L)L)L)L)L)L)N)L)L)L)L)L)N)L)L)L)N)L)",
". . 0 . + O)P)O)P)O)P)O)P)O)P)P)O)P)O)P)O)P)P)O)P)O)P)O)P)O)P)O)P)O)P)O)P)O)Q)R)S)T)U)V)W)X)W)W)V)V)V)V)V)V)V)V)Y)Y)Z)Z)Y)Z)Z)Y)Y)V)V)V)V)V)V)V)V)V)V)V)V)V)V)V)V)V)V)V)V)V)V)V)Y)V)V)V)V)V)Y)V)V)V)Y)V)",
". . . 0 0 0 . 0 0 0 + 0 + 0 + 0 + 0 + 0 + 0 0 + 0 + 0 + 0 + 0 + 0 + 0 + 0 0 `) !+ + + .! !`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)`)+!`)`)`)`)`)+!`)`)`)+!`)"};


static char * listviewhighcornerright_xpm[] = {
"100 46 780 2",
"  	c None",
". 	c #6A779D",
"+ 	c #6C789C",
"@ 	c #6C789D",
"# 	c #6B789D",
"$ 	c #6A779E",
"% 	c #66759E",
"& 	c #64749E",
"* 	c #63749E",
"= 	c #61739D",
"- 	c #576D9B",
"; 	c #556C9C",
"> 	c #4D679D",
", 	c #4A649D",
"' 	c #49629D",
") 	c #465E9C",
"! 	c #40579C",
"~ 	c #3B5394",
"{ 	c #2C4E97",
"] 	c #314993",
"^ 	c #2B4595",
"/ 	c #1B4296",
"( 	c #253D93",
"_ 	c #19418F",
": 	c #0F3C96",
"< 	c #42599E",
"[ 	c #758DC3",
"} 	c #E8EAE7",
"| 	c #EEF0ED",
"1 	c #FBFBFC",
"2 	c #6F7D9B",
"3 	c #6F7D9A",
"4 	c #6E7B9C",
"5 	c #67759E",
"6 	c #63739E",
"7 	c #62739D",
"8 	c #596F9C",
"9 	c #4A639D",
"0 	c #47609C",
"a 	c #445B9F",
"b 	c #3E5697",
"c 	c #2E509A",
"d 	c #2D509A",
"e 	c #2D4F99",
"f 	c #2D4F98",
"g 	c #28418A",
"h 	c #3E51A3",
"i 	c #D0D3DC",
"j 	c #A1B6EF",
"k 	c #A2B6F0",
"l 	c #A1B6F0",
"m 	c #A3B6F0",
"n 	c #A0B6EF",
"o 	c #9DB6EE",
"p 	c #9CB5EF",
"q 	c #9CB2F0",
"r 	c #9FB5EE",
"s 	c #9CB4EB",
"t 	c #9AB3EC",
"u 	c #9AB0EC",
"v 	c #9DB3EB",
"w 	c #9BB4EC",
"x 	c #9BB4EE",
"y 	c #9BB1EF",
"z 	c #9BB0F0",
"A 	c #90ACF0",
"B 	c #93ABEE",
"C 	c #91A8EB",
"D 	c #8BA3E8",
"E 	c #88A1E7",
"F 	c #809DE9",
"G 	c #7A99E8",
"H 	c #7491E5",
"I 	c #698AE4",
"J 	c #6184E3",
"K 	c #507EDC",
"L 	c #4E7CDB",
"M 	c #4F7DDC",
"N 	c #5479DA",
"O 	c #567BDC",
"P 	c #577CDD",
"Q 	c #5074DA",
"R 	c #5174DB",
"S 	c #5175DC",
"T 	c #5276DD",
"U 	c #4D71DE",
"V 	c #4C72D8",
"W 	c #3A6CE0",
"X 	c #2B49A6",
"Y 	c #E0E2DF",
"Z 	c #93AAE9",
"` 	c #94A9E8",
" .	c #94AAE9",
"..	c #93A9E9",
"+.	c #92AAE9",
"@.	c #8DA9E8",
"#.	c #8CA7E9",
"$.	c #92ABE9",
"%.	c #8EAAE9",
"&.	c #8EA9E9",
"*.	c #8FAAE9",
"=.	c #8CA8E9",
"-.	c #8CA2E7",
";.	c #86A1E6",
">.	c #839EE9",
",.	c #7F9CE9",
"'.	c #7A97E8",
").	c #7693E7",
"!.	c #6E8EE8",
"~.	c #678AE9",
"{.	c #5D84E3",
"].	c #577CDF",
"^.	c #4E77DF",
"/.	c #4A70DB",
"(.	c #4870DB",
"_.	c #4870DC",
":.	c #4770E3",
"<.	c #496FDC",
"[.	c #486EDB",
"}.	c #466FE4",
"|.	c #466EE3",
"1.	c #4167D9",
"2.	c #4066D8",
"3.	c #3F66D8",
"4.	c #3D64D7",
"5.	c #3960DA",
"6.	c #476DD9",
"7.	c #446EE5",
"8.	c #305EC8",
"9.	c #8EAAE8",
"0.	c #8FAAE8",
"a.	c #91AAE9",
"b.	c #8FA9E8",
"c.	c #8BA8E8",
"d.	c #8AA7E9",
"e.	c #8BA5EA",
"f.	c #8AA7E8",
"g.	c #87A2E6",
"h.	c #859FE8",
"i.	c #7F9DE8",
"j.	c #7C9AE8",
"k.	c #7B95E7",
"l.	c #7090E8",
"m.	c #6B8BE9",
"n.	c #6386E6",
"o.	c #5881E1",
"p.	c #5479DE",
"q.	c #4D74DE",
"r.	c #476EDB",
"s.	c #446EE1",
"t.	c #446EE0",
"u.	c #446EDF",
"v.	c #446DE0",
"w.	c #426ADF",
"x.	c #3C64DA",
"y.	c #4360CC",
"z.	c #D3D5D2",
"A.	c #E6E3E8",
"B.	c #8DA2E7",
"C.	c #8CA6EA",
"D.	c #8DA3E9",
"E.	c #88A2E7",
"F.	c #87A1E7",
"G.	c #8AA1E7",
"H.	c #849EE9",
"I.	c #7D9AE9",
"J.	c #7B98E8",
"K.	c #7796E5",
"L.	c #7191E7",
"M.	c #688CE9",
"N.	c #6687E5",
"O.	c #5C83E1",
"P.	c #557BDE",
"Q.	c #4F76DE",
"R.	c #4C72DE",
"S.	c #456EDF",
"T.	c #426AD9",
"U.	c #4269D9",
"V.	c #4269D8",
"W.	c #3D64D9",
"X.	c #3A61DA",
"Y.	c #345ED6",
"Z.	c #335ECF",
"`.	c #C6C3C8",
" +	c #86A1E7",
".+	c #87A2E7",
"++	c #87A0E7",
"@+	c #859EE8",
"#+	c #849DE9",
"$+	c #7E9BE9",
"%+	c #7A99E9",
"&+	c #7A95E5",
"*+	c #7593E7",
"=+	c #6F8EE9",
"-+	c #668AE5",
";+	c #6386E0",
">+	c #5B82DF",
",+	c #5379DE",
"'+	c #5075DE",
")+	c #4B6FDC",
"!+	c #446AD7",
"~+	c #4269D6",
"{+	c #4269D5",
"]+	c #3E65D7",
"^+	c #C9CAC9",
"/+	c #869EE9",
"(+	c #859FE9",
"_+	c #849FE9",
":+	c #829DE8",
"<+	c #819DE8",
"[+	c #7B9AE9",
"}+	c #7A96E6",
"|+	c #7290E8",
"1+	c #698CE6",
"2+	c #6689E0",
"3+	c #5D84E0",
"4+	c #587FDF",
"5+	c #5377DD",
"6+	c #4B74DE",
"7+	c #496BD8",
"8+	c #7C9BE9",
"9+	c #7E9CE9",
"0+	c #7D9AEA",
"a+	c #7D9BEA",
"b+	c #7D98E8",
"c+	c #7C98E8",
"d+	c #7796E4",
"e+	c #7592E6",
"f+	c #7390E1",
"g+	c #698DE0",
"h+	c #6588DE",
"i+	c #5E84E0",
"j+	c #5880DF",
"k+	c #5479DC",
"l+	c #4F75DE",
"m+	c #4A6FDB",
"n+	c #436AD7",
"o+	c #3F65D7",
"p+	c #BAC3BE",
"q+	c #7B9AE8",
"r+	c #7B9AEA",
"s+	c #7A9AEA",
"t+	c #7B99E9",
"u+	c #7D97E7",
"v+	c #7D95E6",
"w+	c #7D95E5",
"x+	c #7C95E6",
"y+	c #7493E3",
"z+	c #7290DF",
"A+	c #6C8DDE",
"B+	c #6B89E1",
"C+	c #6486DF",
"D+	c #5D81DF",
"E+	c #567DDE",
"F+	c #4F73DE",
"G+	c #496EDA",
"H+	c #355ED6",
"I+	c #345ED5",
"J+	c #7E95E5",
"K+	c #7C97E8",
"L+	c #7C97E7",
"M+	c #7B94E6",
"N+	c #7A95E4",
"O+	c #7695E5",
"P+	c #7694E4",
"Q+	c #7994E6",
"R+	c #7995E4",
"S+	c #7594E4",
"T+	c #7391E2",
"U+	c #6E8EDE",
"V+	c #6B8ADE",
"W+	c #6688DF",
"X+	c #5F84E0",
"Y+	c #5980E0",
"Z+	c #4D72DD",
"`+	c #456BD7",
" @	c #4168D6",
".@	c #3C64D7",
"+@	c #335ED0",
"@@	c #4659C7",
"#@	c #7292E1",
"$@	c #7392E1",
"%@	c #7492E1",
"&@	c #718FDF",
"*@	c #6F8EDE",
"=@	c #6D8BDE",
"-@	c #6B88DF",
";@	c #597FDF",
">@	c #557ADD",
",@	c #5176DC",
"'@	c #4D74DD",
")@	c #496DDA",
"!@	c #3860D8",
"~@	c #7391E0",
"{@	c #7290DE",
"]@	c #6D8EDD",
"^@	c #6D8DDD",
"/@	c #7190E0",
"(@	c #6C8DDD",
"_@	c #6B89DF",
":@	c #6487E0",
"<@	c #6085DF",
"[@	c #5F81DE",
"}@	c #567EDE",
"|@	c #4F74D9",
"1@	c #466BD7",
"2@	c #4067D5",
"3@	c #3C63D7",
"4@	c #335ED3",
"5@	c #335ED1",
"6@	c #718EDD",
"7@	c #728EDD",
"8@	c #748EDD",
"9@	c #708EDD",
"0@	c #6F8DDD",
"a@	c #6E8DDD",
"b@	c #6C8ADE",
"c@	c #6C89DF",
"d@	c #6988DF",
"e@	c #6387DF",
"f@	c #6282DE",
"g@	c #5681E0",
"h@	c #577BDD",
"i@	c #5277DB",
"j@	c #4D73D8",
"k@	c #4A70D8",
"l@	c #436AD5",
"m@	c #3F66D6",
"n@	c #3C63D8",
"o@	c #3960D8",
"p@	c #3860D7",
"q@	c #335ED2",
"r@	c #345ED4",
"s@	c #6C88DF",
"t@	c #6D88DF",
"u@	c #6B89DE",
"v@	c #6888DF",
"w@	c #6587E0",
"x@	c #6989DF",
"y@	c #6687E0",
"z@	c #6287E0",
"A@	c #6281DD",
"B@	c #5881E0",
"C@	c #557ADB",
"D@	c #5176D9",
"E@	c #4E75D7",
"F@	c #4A6FD8",
"G@	c #476BD6",
"H@	c #4067D6",
"I@	c #3C62D7",
"J@	c #3C60D4",
"K@	c #365ED1",
"L@	c #345ED3",
"M@	c #6786DF",
"N@	c #5F85E0",
"O@	c #5F86E0",
"P@	c #6186DF",
"Q@	c #6286E0",
"R@	c #6284DF",
"S@	c #6384DF",
"T@	c #5B7FDE",
"U@	c #577DDC",
"V@	c #557BDA",
"W@	c #5278D8",
"X@	c #4E76D6",
"Y@	c #4C72D7",
"Z@	c #486DD8",
"`@	c #4469D6",
" #	c #3F62D2",
".#	c #3C60CF",
"+#	c #345ECF",
"@#	c #6086DF",
"##	c #6085E0",
"$#	c #6285DF",
"%#	c #6383DD",
"&#	c #6481DC",
"*#	c #6380DD",
"=#	c #6183DE",
"-#	c #6083DD",
";#	c #6081DC",
">#	c #6080DD",
",#	c #6083DE",
"'#	c #6181DC",
")#	c #6280DD",
"!#	c #577EDB",
"~#	c #557CD7",
"{#	c #4F76D6",
"]#	c #4E74D7",
"^#	c #466CD7",
"/#	c #3B64D6",
"(#	c #4261CD",
"_#	c #375FCE",
":#	c #5A7FD8",
"<#	c #6281DA",
"[#	c #5F81D8",
"}#	c #5C80D8",
"|#	c #557DD7",
"1#	c #577ED8",
"2#	c #567ED7",
"3#	c #587DD8",
"4#	c #577DD8",
"5#	c #587ED8",
"6#	c #567DD8",
"7#	c #5379D9",
"8#	c #5177D7",
"9#	c #4D74D5",
"0#	c #486ED9",
"a#	c #4068D4",
"b#	c #3D65D2",
"c#	c #4361CC",
"d#	c #345ECE",
"e#	c #325DCF",
"f#	c #2C5AD1",
"g#	c #3959C5",
"h#	c #547BD8",
"i#	c #567DD7",
"j#	c #557BD8",
"k#	c #5279D9",
"l#	c #5278D9",
"m#	c #4D74D6",
"n#	c #4B71D8",
"o#	c #496CD8",
"p#	c #4669D7",
"q#	c #3D66D3",
"r#	c #3F62CF",
"s#	c #4260CC",
"t#	c #5379D8",
"u#	c #4E75D4",
"v#	c #4C73D7",
"w#	c #476CD7",
"x#	c #4869D0",
"y#	c #4067D2",
"z#	c #3D64D1",
"A#	c #4261CC",
"B#	c #395FCE",
"C#	c #4F75D3",
"D#	c #5074D2",
"E#	c #5174D1",
"F#	c #5175D1",
"G#	c #4F74D3",
"H#	c #4C73D5",
"I#	c #4C73D4",
"J#	c #4A72D1",
"K#	c #4B70CF",
"L#	c #506CCC",
"M#	c #4D6BCE",
"N#	c #4167D0",
"O#	c #3D65D1",
"P#	c #3F63CF",
"Q#	c #3B5FCD",
"R#	c #3159CD",
"S#	c #4971D0",
"T#	c #4870CF",
"U#	c #4C6FCF",
"V#	c #4E6CCE",
"W#	c #4E6BCE",
"X#	c #4769CF",
"Y#	c #3D66D0",
"Z#	c #3C65D1",
"`#	c #4062CE",
" $	c #3D5FCD",
".$	c #365FCF",
"+$	c #325DCD",
"@$	c #2D5AD0",
"#$	c #3859C5",
"$$	c #355FCF",
"%$	c #355ECF",
"&$	c #335ECE",
"*$	c #305CCD",
"=$	c #2B5ACE",
"-$	c #3056C9",
";$	c #2553C6",
">$	c #2153C8",
",$	c #1F4FC7",
"'$	c #274CC5",
")$	c #214AC7",
"!$	c #1C48C8",
"~$	c #1244C9",
"{$	c #1043C9",
"]$	c #1144C9",
"^$	c #2A45BE",
"/$	c #2744B5",
"($	c #1D49C0",
"_$	c #2B58DE",
":$	c #002D94",
"<$	c #2B59CA",
"[$	c #2A59CA",
"}$	c #2E57C8",
"|$	c #3255C6",
"1$	c #3355C5",
"2$	c #1C52C8",
"3$	c #1D50C7",
"4$	c #234FC6",
"5$	c #264CC5",
"6$	c #1D48C7",
"7$	c #1245C8",
"8$	c #1F44C2",
"9$	c #2945BE",
"0$	c #2A45BD",
"a$	c #2040BF",
"b$	c #3156C7",
"c$	c #3056C7",
"d$	c #3354C5",
"e$	c #3355C6",
"f$	c #3255C5",
"g$	c #3254C5",
"h$	c #1952C7",
"i$	c #1951C8",
"j$	c #2050C7",
"k$	c #274CC4",
"l$	c #244CC6",
"m$	c #1F49C7",
"n$	c #1E47C5",
"o$	c #2045C3",
"p$	c #1C44BF",
"q$	c #2045BE",
"r$	c #2040B8",
"s$	c #3254C6",
"t$	c #3055C6",
"u$	c #2A54C6",
"v$	c #2353C7",
"w$	c #3054C5",
"x$	c #2F55C5",
"y$	c #2A54C5",
"z$	c #2553C5",
"A$	c #2F54C5",
"B$	c #3155C6",
"C$	c #2A54C7",
"D$	c #1A52C8",
"E$	c #204FC2",
"F$	c #264DC6",
"G$	c #234BC5",
"H$	c #1D48C1",
"I$	c #1E48BF",
"J$	c #2646BE",
"K$	c #2B45BD",
"L$	c #1E43BE",
"M$	c #2643BF",
"N$	c #2243BF",
"O$	c #3049BC",
"P$	c #1E50BE",
"Q$	c #1D50C0",
"R$	c #1D50BF",
"S$	c #1852C1",
"T$	c #1E51C0",
"U$	c #214FBF",
"V$	c #2050C0",
"W$	c #244EBF",
"X$	c #2151C0",
"Y$	c #234FBF",
"Z$	c #2350C0",
"`$	c #2351C0",
" %	c #244FBF",
".%	c #2250C0",
"+%	c #2051C0",
"@%	c #1E50C0",
"#%	c #244DBE",
"$%	c #274DBF",
"%%	c #244CBF",
"&%	c #1C48C0",
"*%	c #2247BF",
"=%	c #2C44BD",
"-%	c #1C44BE",
";%	c #1444BF",
">%	c #1841BF",
",%	c #1F40BF",
"'%	c #254DBE",
")%	c #224FBE",
"!%	c #224FBF",
"~%	c #234EBF",
"{%	c #254CBD",
"]%	c #244DBD",
"^%	c #244CBD",
"/%	c #264DBE",
"(%	c #264DBD",
"_%	c #214BC0",
":%	c #1D48C0",
"<%	c #2347BF",
"[%	c #2B44BD",
"}%	c #2444BE",
"|%	c #0F42BF",
"1%	c #0641BF",
"2%	c #0F41BF",
"3%	c #1741BE",
"4%	c #1F40BD",
"5%	c #234BBF",
"6%	c #234CBE",
"7%	c #214BBE",
"8%	c #244CBE",
"9%	c #214ABE",
"0%	c #214ABF",
"a%	c #1F48C0",
"b%	c #2746BE",
"c%	c #1F43BE",
"d%	c #0941BE",
"e%	c #0342BA",
"f%	c #0242BC",
"g%	c #1241B8",
"h%	c #1F40B7",
"i%	c #2F41AC",
"j%	c #2644AE",
"k%	c #2D49B4",
"l%	c #2649B6",
"m%	c #2949B7",
"n%	c #2849B5",
"o%	c #2149B8",
"p%	c #1E49B9",
"q%	c #1F48B8",
"r%	c #1F49B9",
"s%	c #2545B6",
"t%	c #2744B7",
"u%	c #2844B7",
"v%	c #2043B8",
"w%	c #1241B7",
"x%	c #1340B8",
"y%	c #0D41B8",
"z%	c #1941B8",
"A%	c #1F40B8",
"B%	c #203FB8",
"C%	c #2549B5",
"D%	c #2648B6",
"E%	c #2547B7",
"F%	c #2248B7",
"G%	c #2048B7",
"H%	c #2346B6",
"I%	c #2146B6",
"J%	c #2247B7",
"K%	c #2148B7",
"L%	c #2743B4",
"M%	c #2643B5",
"N%	c #2542B6",
"O%	c #1D42B7",
"P%	c #0E42B8",
"Q%	c #0C41B8",
"R%	c #1341B8",
"S%	c #1740B8",
"T%	c #1C41B8",
"U%	c #1F40B1",
"V%	c #2644B5",
"W%	c #2544B5",
"X%	c #2544B4",
"Y%	c #2444B5",
"Z%	c #2444B4",
"`%	c #2744B4",
" &	c #2241B7",
".&	c #1D41B8",
"+&	c #0B42B8",
"@&	c #0942B8",
"#&	c #0C42B8",
"$&	c #0F41B8",
"%&	c #1641B8",
"&&	c #2442B5",
"*&	c #2543B3",
"=&	c #2342B2",
"-&	c #2341B4",
";&	c #2141B3",
">&	c #2141B5",
",&	c #2140B5",
"'&	c #2040B5",
")&	c #1C40B7",
"!&	c #1B41B3",
"~&	c #0142B6",
"{&	c #0E41B7",
"]&	c #1141B7",
"^&	c #1440B2",
"/&	c #113FB0",
"(&	c #1440B0",
"_&	c #213EAF",
":&	c #233DAE",
"<&	c #223EAF",
"[&	c #1E40B1",
"}&	c #173EAD",
"|&	c #1440AF",
"1&	c #0D40AF",
"2&	c #0941B0",
"3&	c #0D3FAE",
"4&	c #1B3CAC",
"5&	c #233CAD",
"6&	c #203FB0",
"7&	c #273BAD",
"8&	c #1D40B0",
"9&	c #2040B1",
"0&	c #1E40B0",
"a&	c #1C40B0",
"b&	c #1B3DAC",
"c&	c #143DAC",
"d&	c #193DAD",
"e&	c #1B3DAD",
"f&	c #173DAD",
"g&	c #153DAC",
"h&	c #1C3CAC",
"i&	c #243CAD",
"j&	c #213FB0",
"k&	c #263BAA",
"l&	c #253CAE",
"m&	c #273AAC",
"n&	c #273AAD",
"o&	c #253BAD",
"p&	c #1D3CAC",
"q&	c #243BAD",
"r&	c #1E3CAC",
"s&	c #263BAD",
"t&	c #1A3DAC",
"u&	c #143DAB",
"v&	c #163DAC",
"w&	c #1A3CAC",
"x&	c #1F3CAD",
"y&	c #263BAB",
"z&	c #263BA6",
"A&	c #1E42A4",
"B&	c #2D40A5",
"C&	c #253BA6",
"D&	c #253CA7",
"E&	c #263AA5",
"F&	c #253BA7",
"G&	c #1E3BA6",
"H&	c #193DA6",
"I&	c #173DA5",
"J&	c #143DA6",
"K&	c #1A3DA7",
"L&	c #133DA6",
"M&	c #123DA5",
"N&	c #1A3CA7",
"O&	c #243BA6",
"P&	c #263AA7",
"Q&	c #273BA7",
"R&	c #263AA6",
"S&	c #223BA6",
"T&	c #1D3BA6",
"U&	c #173CA6",
"V&	c #133DA5",
"W&	c #1B3DA6",
"X&	c #193DA5",
"Y&	c #123DA4",
"Z&	c #163CA5",
"`&	c #213CA6",
" *	c #273BA8",
".*	c #263BA7",
"+*	c #253BA5",
"@*	c #263BA5",
"#*	c #1C3BA6",
"$*	c #1B3BA9",
"%*	c #133BA8",
"&*	c #0A3BA7",
"**	c #083AA6",
"=*	c #123CA5",
"-*	c #0839A8",
";*	c #0239A6",
">*	c #123AA8",
",*	c #1F49C8",
"'*	c #2F4DA4",
")*	c #2E4DA3",
"!*	c #384CA4",
"~*	c #3C4DA7",
"{*	c #394EA7",
"]*	c #3B4CA5",
"^*	c #3C52B1",
"/*	c #3551A8",
"(*	c #3759BE",
"_*	c #4161C7",
":*	c #0033A8",
"<*	c #596FA9",
"[*	c #2F4DA3",
"}*	c #2D4BA5",
"|*	c #2E4CA4",
"1*	c #2C4AA5",
"2*	c #2D4BA4",
"3*	c #354DA4",
"4*	c #3A4BA4",
"5*	c #394DA6",
"6*	c #4056AD",
"7*	c #445BBB",
"8*	c #B5B7B4",
"9*	c #1B2F85",
"0*	c #242F79",
"a*	c #B5B5B5",
"b*	c #B5B2B6",
"c*	c #C0C3C3",
"d*	c #E3E3E4",
"e*	c #EBEDEA",
". + @ + # $ % & # $ % & # $ % & # $ % & & * = - ; > , ' ) ! ~ { { { { { { { ] ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ / / / ( / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / / _ _ / / : / < [ } | | | 1 1 ",
"2 2 2 2 3 2 4 @ 3 2 4 @ 3 2 4 @ 3 2 4 @ # 5 6 7 8 ; > 9 0 a b c d e f { { { ] ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ( ( ( ( ( ( ( ( ( / / / / / / / / / / / / / / / / / _ _ _ _ _ _ _ _ _ _ _ g g _ / / : : : h i } 1 | 1 ",
"j k l m n o p q n o p q r s t u v w x y z A B C D E F G H I J K L M N O P O O Q R S T T T T T T T T T T T T T T T T T T U U U U U U U U U U U U U U U U U U U U U U U U U U U U V V V U U W X : [ Y | | ",
"Z `  . ...+.@.#...+.@.#.Z $.%.&.Z $.*.=.-.;.>.,.'.).!.~.{.].^./.(._.:.<.[.}.|.1.2.3.4.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.6.7.8.: h Y } 1 ",
"9.0.a.b.c.c.d.e.f.c.d.e.f.c.d.e.f.c.d.e.g.h.i.j.k.l.m.n.o.p.q.r.s.s.t.u.u.v.w.x.4.4.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.y.5.7.6.: / z.A.} ",
"-.B.C.D.-.E.g.F.G.E.g.F.G.E.g.F.G.E.g.F.H.I.J.K.L.M.N.O.P.Q.R.S.T.U.V.V.U.U.W.X.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Z.y.Y.7.7.: : `.z.} ",
" +.+g.;.++F.@+#+++F.@+#+++F.@+#+++F.@+#+$+%+&+*+=+-+;+>+,+'+)+!+~+{+]+{+{+4.4.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.Y.Y.5.5.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Z.Z.Z.y.y.5.7.7.: : ^+z.Y ",
"/+(+_+#+H.H.>.:+H.H.>.:+H.H.>.:+H.H.>.<+[+}+*+|+1+2+3+4+5+6+7+{+{+4.4.4.4.4.4.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.Y.Y.Y.Y.Y.Y.Y.5.Y.Y.Y.Y.Y.Y.Y.Y.5.Y.Y.5.5.5.5.Y.Y.Y.Y.Y.Y.Z.Z.Z.Z.y.y.y.y.y.y.7.7.: : ^+i } ",
"8+9+0+0+a+0+0+b+a+0+0+b+a+0+0+b+a+0+0+c+d+e+f+g+h+i+j+k+l+m+n+o+4.4.4.4.5.5.5.5.5.5.Y.Y.5.5.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Y.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Y.Y.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.7.7.: : p+z.Y ",
"q+r+r+s+t+u+v+w+t+u+v+w+t+u+v+w+t+u+x+&+y+z+A+B+C+D+E+5+F+G+~+4.4.4.4.5.5.5.5.5.H+Y.Y.Y.Y.Y.Y.Y.Y.I+Y.Z.Y.Y.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.7.7.: : `.z.A.",
"J+v+K+L+M+N+O+P+Q+R+O+P+Q+R+O+P+Q+R+O+S+T+U+V+W+X+Y+P.T Z+`+ @4.4..@5.5.5.5.5.5.Y.Y.Y.I+I+I+I+I++@+@Z.Z.Y.Y.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.@@Z.7.7.: : p+z.Y ",
"#@$@$@%@%@$@#@&@#@#@#@&@#@#@#@&@#@#@#@*@=@-@;+i+;@>@,@'@)@ @4.X.5.5.H+Y.Y.Y.!@Y.Y.I++@+@Z.Z.+@Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.y.Z.6.6.: : `.z.A.",
"#@$@~@~@~@{@]@^@/@{@]@^@/@{@]@^@/@{@]@(@_@:@<@[@}@k+|@V 1@2@3@5.5.5.Y.Y.I+4@I+5@+@Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.y.Z.6.6.: : p+z.Y ",
"6@7@8@9@0@a@b@c@a@a@b@c@a@a@b@c@a@a@b@d@e@<@f@g@h@i@j@k@l@m@n@o@o@p@Y.I+q@q@r@+@Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.y.Z.6.6.: : `.z.A.",
"s@t@u@_@_@v@w@w@x@v@w@w@x@v@y@y@x@v@:@z@A@B@P C@D@E@F@G@H@I@J@K@5@+@+@+@r@I+L@Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.@@Z.W W : : p+z.Y ",
"M@N@O@P@C+Q@Q@R@C+;+Q@R@C+;+;+S@C+Q@Q@R@T@U@V@W@X@Y@Z@`@4. #.#+#Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.8.Z.Z.Z.Z.8.8.Z.Z.y.@@@@W W : : `.z.A.",
"@#O@O@##$#%#&#*#=#-#;#>#,#-#;#>#,#-#'#)#!#~#W@{#]#k@^#H@/#(#_#Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.Z.8.8.Z.Z.Z.Z.Z.Z.Z.8.8.8.8.8.8.8.8.8.8.8.Z.Z.y.y.@@W W : : p+z.Y ",
":#<#[#}#|#1#2#3#4#5#1#4#4#1#1#4#4#1#1#6#7#8#9#V 0#`+a#b#c#d#e#Z.Z.Z.f#Z.Z.Z.f#f#f#f#f#f#f#f#f#f#g#g#g#g#g#8.8.8.8.8.8.8.8.8.g#g#g#g#8.g#8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.y.y.@@W W : : `.z.A.",
"h#2#i#6#|#j#7#k#|#j#7#7#|#j#7#7#|#j#7#l#8#m#n#n#o#p#q#r#s#d#e#Z.Z.Z.f#f#f#f#Z.f#f#g#g#g#g#g#g#g#g#g#g#g#g#8.8.8.g#g#8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.8.y.y.y.y.8.8.8.y.y.@@W W : : p+z.Y ",
"l#7#7#l#7#7#7#W@7#7#7#W@7#7#k#W@t#7#7#W@u#v#n#w#x#y#z#A#B#Z.e#f#f#Z.f#f#f#Z.Z.g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#8.8.8.g#g#g#g#8.8.g#g#g#g#g#g#8.8.g#8.8.y.8.8.y.y.8.y.y.y.y.@@W W : : `.z.A.",
"C#D#E#F#G#H#I#J#G#H#I#J#G#H#I#J#G#H#I#J#K#L#M#N#O#P#s#Q#+#f#R#f#f#f#f#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#@@@@y.y.@@@@y.y.W W : : p+z.Y ",
"S#S#S#S#S#T#S#U#S#T#S#U#S#T#S#U#S#T#S#U#V#W#X#Y#Z#`# $.$+$@$#$g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#g#@@@@@@@@@@@@@@@@@@y.y.W W : : `.z.A.",
"+$Z..$$$%$+$&$*$%$+$&$*$%$+$&$*$%$+$&$*$=$-$;$>$,$'$)$!$~${$]$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$/$/$/$/$($($_$_$:$:$p+z.Y ",
"<$<$<$<$<$[$}$|$<$[$}$|$<$[$}$|$<$[$}$|$1$2$3$4$5$)$6$7$8$9$0$a$a$a$a$a$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$/$/$/$^$^$^$/$/$/$/$/$/$/$/$/$/$/$/$/$/$($($_$_$:$:$`.z.A.",
"b$c$c$c$d$e$e$f$g$|$|$1$d$e$e$1$d$e$e$1$h$i$j$k$l$m$n$o$p$9$q$a$a$a$a$a$a$a$a$^$a$a$^$^$^$^$^$^$a$r$r$r$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$^$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$($($_$_$:$:$p+z.Y ",
"e$1$s$s$1$t$u$v$w$x$y$z$A$x$u$v$g$B$C$>$D$E$F$G$H$I$J$K$L$M$N$a$a$a$a$a$a$a$a$^$r$r$a$^$^$^$a$r$r$r$r$r$/$^$r$^$^$^$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$O$($_$_$:$:$`.z.A.",
"P$Q$R$S$T$U$V$W$X$Y$Z$W$`$ %.%W$+%U$@%#%$%%%&%($*%=%-%;%>%>%,%r$r$r$r$r$a$a$a$/$/$/$r$r$r$r$r$r$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$O$($_$_$:$:$p+z.Y ",
"'%W$)%!%~%{%'%]%~%^%'%]%~%^%'%]%~%^%/%(%_%&%:%<%[%}%|%1%2%3%4%r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$/$r$/$/$r$r$r$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$/$r$/$/$/$/$/$O$($_$_$:$:$`.z.A.",
"5%6%'%'%6%7%8%9%6%7%8%9%6%7%8%9%6%7%8%0%&%a%<%b%[%c%d%e%f%g%h%r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$/$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$/$/$/$/$/$/$/$/$/$/$/$/$/$/$r$r$/$/$r$r$/$r$i%j%O$($_$_$:$:$p+z.Y ",
"k%l%m%n%o%o%p%q%o%o%r%q%o%o%r%q%o%o%p%q%s%t%/$u%v%w%x%y%z%A%B%r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$/$/$/$/$/$/$/$r$r$i%i%i%r$r$i%i%i%i%i%i%i%i%i%i%i%i%r$/$/$j%j%j%j%j%j%j%j%j%O$($_$_$:$:$`.z.A.",
"C%D%E%F%G%H%I%J%K%H%I%J%K%H%I%J%K%H%I%J%L%M%N%O%P%Q%R%S%T%A%B%r$r$r$r$r$r$r$r$r$r$r$r$r$r$r$U%U%r$r$i%i%/$/$r$r$/$/$/$/$r$r$i%i%i%i%i%i%i%i%i%i%i%i%i%i%j%i%j%j%j%j%j%j%j%j%j%j%j%j%j%O$($_$_$:$:$p+z.Y ",
"/$/$/$/$V%V%W%X%W%Y%Y%Z%W%W%Y%Z%W%W%W%`%`% &B%.&+&@&#&$&%&A%B%r$r$r$U%U%U%U%r$U%U%U%U%U%U%U%U%U%U%i%i%i%i%i%i%i%i%/$/$/$i%i%i%i%i%i%i%i%i%j%j%j%j%i%i%i%i%i%j%j%j%i%i%j%j%j%j%j%j%j%j%O$($_$_$:$:$`.z.A.",
"&&*&=&-&=&;&>&,&=&;&>&,&=&;&>&,&=&;&>&'&)&!&~&{&]&^&/&(&_&:&<&U%U%U%U%U%U%U%U%U%U%U%U%U%i%i%U%U%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%O$($_$_$:$:$p+z.Y ",
"U%U%U%U%U%U%U%U%U%U%U%U%U%U%U%U%U%U%U%U%[&}&|&1&2&3&4&5&_&6&U%7&U%U%U%U%U%U%U%U%i%i%U%U%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%O$O$_$_$:$:$`.z.A.",
"U%U%U%U%U%U%[&8&U%9&[&0&U%9&[&0&U%9&[&a&:&b&c&d&e&f&g&h&i&<&j&U%U%U%U%U%U%U%U%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%i%O$O$_$_$:$:$p+z.Y ",
"k&l&m&7&7&n&o&p&7&n&q&r&s&s&q&r&s&n&o&p&t&u&u&g&v&w&x&q&n&m&y&7&7&U%U%7&z&7&z&U%A&B&i%i%B&B&i%i%B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&i%B&O$O$_$_$:$:$`.z.A.",
"C&D&E&z&z&E&F&G&z&E&F&G&z&E&F&G&z&E&F&G&H&I&J&K&L&M&N&O&P&Q&z&z&z&z&z&z&z&z&z&z&z&z&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&O$O$_$_$:$:$p+z.Y ",
"z&z&z&z&R&S&T&U&R&S&T&U&R&S&T&U&R&S&T&U&V&V&W&X&Y&Z&`&C&R&z&z&z&z&z&z&z&z&z&z&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&O$O$_$_$:$:$^+z.A.",
"z& *.*+*@*#*$*%*@*#*$*%*@*#*$*%*@*#*$*%*&***=*-*;*>*k&P&+*z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&z&B&B&B&B&z&z&z&B&B&B&z&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&B&/$O$O$@@_$,*:$/ ^+z.Y ",
"'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*'*)*'*!*~*{*]*^*^*^*/*/*/*/*/*/*/*^*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*^*/*/*/*/*/*h h ^*h h ^*^*h h ^*^*^*^*h ^*^*^*^*h ^*^*^*(*_*_*_*_*_$:*:$<*`.z.} ",
"'*'*'*'*'*[*}*|*'*[*}*|*'*[*}*|*'*[*}*|*1*1*2*}*}*2*[*)*3*4*5*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*h h h h h h h h h h h h h h h h 6*7*_*_*_*_*^*:*:$: 8*z.Y } ",
"9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*9*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*0*( <*8*^+z.Y } 1 ",
"a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*a*8*b*8*b*8*b*8*b*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*b*8*8*8*8*b*8*`.z.A.Y | | ",
"c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*c*p+`.p+`.p+`.p+`.`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+`.p+^+`.^+^+z.z.Y Y | | 1 ",
"d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*d*A.Y A.Y A.Y A.Y Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y A.Y } } | | | | 1 1 ",
"e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*e*} | } | } | } | | } | } | } | } | } | } | } | } | } | } | } | } | } | } | } | } | } | } | } | } | } | } | } | } | } | | | | 1 | | | 1 1 1 "};


static char * tabmiddle_xpm[] = {
"33 42 32 1",
" 	c None",
".	c #CECFEF",
"+	c #CECBE7",
"@	c #C6C7E7",
"#	c #C6CBE7",
"$	c #BDBEDE",
"%	c #BDC3DE",
"&	c #CECBEF",
"*	c #B5B6D6",
"=	c #ADAECE",
"-	c #ADB2CE",
";	c #BDBAD6",
">	c #B5BAD6",
",	c #C6C3DE",
"'	c #ADAAC6",
")	c #B5B2CE",
"!	c #B5B6CE",
"~	c #A5A2BD",
"{	c #A5A6BD",
"]	c #9C9EB5",
"^	c #9CA2BD",
"/	c #ADAEC6",
"(	c #C6C3E7",
"_	c #9C9AB5",
":	c #A5A6C6",
"<	c #949AAD",
"[	c #A5AAC6",
"}	c #9496AD",
"|	c #BDBADE",
"1	c #BDBED6",
"2	c #9CA2B5",
"3	c #A5AABD",
"..........................+@.#.#.",
"........................$@%&#.#..",
"......................**$$@@&#.#.",
".....................=-;>,%+@.#..",
"....................'')!$$@@&#.#.",
"...................~{=)$$@@&#.#..",
"..................]^'/;;(%&#.#...",
"................._]:/*>,%&@.#.#..",
".................<{[)!$%+@.#.#...",
"................}~{=!$%@@.#......",
"................]^/-|$@@.#.......",
"................]'/*;@@&#........",
"...............<~[)>,%&#.#.......",
"...............]~=)$%+#.#........",
"...............]'/;1@@.#.........",
"...............~{)*,%&#..........",
"...............2/-$$@#...........",
"...............~[*>(@&#..........",
"...............^=)$%+#...........",
"...............{'*>(@.#..........",
"...............^=)$%+#...........",
"...............{'*>(@.#..........",
"...............^=)$%+#...........",
"...............{'*>(@.#..........",
"...............^=)$%+#...........",
"...............{'*>(@.#..........",
"...............^=)$%+#...........",
"...............{'*>@@.#..........",
"...............^=!$%&#...........",
"...............{/*;@@.#..........",
"...............{)!$%&#...........",
"..............]'/;1@@.#..........",
"..............23)>,%&#...........",
"..............~=-$$@@.#..........",
".............]{/*;@@.#...........",
"............<^[)>,%&#............",
"............]{/!$%@@.#...........",
"..........]^[-!$%@@.#............",
".........]^3/!>$@@.#.............",
".......<]^3/!>$@@&#..............",
".....<]2{[/!>$%@&#.#.............",
"}<<_]2{3/-!>$%@&#.#.............."};


static char * tabselectedbeginn_xpm[] = {
"33 39 28 1",
" 	c None",
".	c #CECFEF",
"+	c #EFF3EF",
"@	c #FFFBFF",
"#	c #F7FBF7",
"$	c #FFFFFF",
"%	c #EFEFEF",
"&	c #F7F7F7",
"*	c #DEDFDE",
"=	c #E7E7E7",
"-	c #D6D3D6",
";	c #DEE3DE",
">	c #EFEBEF",
",	c #F7F3F7",
"'	c #CECBCE",
")	c #CECFCE",
"!	c #D6D7D6",
"~	c #DEDBDE",
"{	c #E7EBE7",
"]	c #C6C7C6",
"^	c #E7E3E7",
"/	c #BDC3BD",
"(	c #CED3CE",
"_	c #BDBABD",
":	c #C6C3C6",
"<	c #C6CBC6",
"[	c #D6DBD6",
"}	c #BDBEBD",
"..........................+@#$#$$",
"........................%%&&@#$#$",
"......................*==%%&&@#$$",
"....................--*;>%,&@#$#$",
"...................')!~={,+@#$#$$",
"...................]-!^=%%&&@#$#$",
"................../'(~;>%&&@#$#$$",
"................._])!*={,&@#$#$$$",
"................_])~*>%&&$#$$$$$$",
"................:<![={&&@#$$$$$$$",
"................:)!^=,+@#$$$$$$$$",
"...............}'(*^%+@#$#$$$$$$$",
"...............:<!*>%&&$#$$$$$$$$",
".............../)!^{,&@#$$$$$$$$$",
"...............](*^%+@#$$$$$$$$$$",
"...............]!~=%&&$$$$$$$$$$$",
"...............'(*=,+@#$$$$$$$$$$",
"...............<!*>%&&$$$$$$$$$$$",
"...............'-^=,+@#$$$$$$$$$$",
"...............<!*>%&#$$$$$$$$$$$",
"...............'-^=,+@#$$$$$$$$$$",
"...............<!*>%&#$$$$$$$$$$$",
"...............'-^=,+@#$$$$$$$$$$",
"...............<!*>%&#$$$$$$$$$$$",
"...............'-^=,+@#$$$$$$$$$$",
"...............<!*>%&#$$$$$$$$$$$",
"...............'!^=,&@#$$$$$$$$$$",
"...............<~*>%&#$$$$$$$$$$$",
"...............)!^{,&@#$$$$$$$$$$",
"..............])~;%+@#$$$$$$$$$$$",
"..............]-[={&&$#$$$$$$$$$$",
".............])!^=,&@#$$$$$$$$$$$",
"............:'-*^%+@#$$$$$$$$$$$$",
"............])~*>%&&$#$$$$$$$$$$$",
"...........:'!*={,&@#$$$$$$$$$$$$",
"..........:'-~^=,+@#$$$$$$$$$$$$$",
".......}]'-~^=%,&@#$$$$$$$$$$$$$$",
".....}:])-~^=%,+@#$#$$$$$$$$$$$$$",
"}}}:]')-!*^=%,&@#$#$$$$$$$$$$$$$$"};


static char * tabselectedend_xpm[] = {
"33 42 33 1",
" 	c None",
".	c #FFFFFF",
"+	c #CECBE7",
"@	c #C6C7E7",
"#	c #CECFEF",
"$	c #C6CBE7",
"%	c #BDBEDE",
"&	c #BDC3DE",
"*	c #CECBEF",
"=	c #B5B6D6",
"-	c #ADAECE",
";	c #ADB2CE",
">	c #BDBAD6",
",	c #B5BAD6",
"'	c #C6C3DE",
")	c #ADAAC6",
"!	c #B5B2CE",
"~	c #B5B6CE",
"{	c #A5A2BD",
"]	c #A5A6BD",
"^	c #9C9EB5",
"/	c #9CA2BD",
"(	c #ADAEC6",
"_	c #C6C3E7",
":	c #9C9AB5",
"<	c #A5A6C6",
"[	c #949AAD",
"}	c #A5AAC6",
"|	c #9496AD",
"1	c #BDBADE",
"2	c #BDBED6",
"3	c #9CA2B5",
"4	c #A5AABD",
"..........................+@#$#$#",
"........................%@&*$#$##",
"......................==%%@@*$#$#",
".....................-;>,'&+@#$##",
"....................))!~%%@@*$#$#",
"...................{]-!%%@@*$#$##",
"..................^/)(>>_&*$#$###",
".................:^<(=,'&*@#$#$##",
".................[]}!~%&+@#$#$###",
"................|{]-~%&@@#$######",
"................^/(;1%@@#$#######",
"................^)(=>@@*$########",
"...............[{}!,'&*$#$#######",
"...............^{-!%&+$#$########",
"...............^)(>2@@#$#########",
"...............{]!='&*$##########",
"...............3(;%%@$###########",
"...............{}=,_@*$##########",
".............../-!%&+$###########",
"...............])=,_@#$##########",
".............../-!%&+$###########",
"...............])=,_@#$##########",
".............../-!%&+$###########",
"...............])=,_@#$##########",
".............../-!%&+$###########",
"...............])=,_@#$##########",
".............../-!%&+$###########",
"...............])=,@@#$##########",
".............../-~%&*$###########",
"...............](=>@@#$##########",
"...............]!~%&*$###########",
"..............^)(>2@@#$##########",
"..............34!,'&*$###########",
"..............{-;%%@@#$##########",
".............^](=>@@#$###########",
"............[/}!,'&*$############",
"............^](~%&@@#$###########",
"..........^/};~%&@@#$############",
".........^/4(~,%@@#$#############",
".......[^/4(~,%@@*$##############",
".....[^3]}(~,%&@*$#$#############",
"|[[:^3]4(;~,%&@*$#$##############"};


static char * tabend_xpm[] = {
"33 42 3 1",
" 	c None",
".	c #CECFEF",
"+	c #FFFFFF",
"..........................+++++++",
"........................+++++++++",
"......................+++++++++++",
".....................++++++++++++",
"....................+++++++++++++",
"...................++++++++++++++",
"..................+++++++++++++++",
".................++++++++++++++++",
".................++++++++++++++++",
"................+++++++++++++++++",
"................+++++++++++++++++",
"................+++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"...............++++++++++++++++++",
"..............+++++++++++++++++++",
"..............+++++++++++++++++++",
"..............+++++++++++++++++++",
".............++++++++++++++++++++",
"............+++++++++++++++++++++",
"............+++++++++++++++++++++",
"..........+++++++++++++++++++++++",
".........++++++++++++++++++++++++",
".......++++++++++++++++++++++++++",
".....++++++++++++++++++++++++++++",
"+++++++++++++++++++++++++++++++++"};




QColor fromHsl(QColor c)
{
    const qreal h = c.hueF();
    const qreal s = c.saturationF();
    const qreal l = c.valueF();

    qreal ca[3] = {0, 0, 0};

    if (s == 0 || h == 1) {
        // achromatic case 
        ca[0] = ca[1] = ca[2] = l;
    } else { 
        // chromatic case 
        qreal temp2; 
        if (l < qreal(0.5)) 
            temp2 = l * (qreal(1.0) + s); 
        else 
            temp2 = l + s - (l * s); 

        const qreal temp1 = (qreal(2.0) * l) - temp2; 
        qreal temp3[3] = { h + (qreal(1.0) / qreal(3.0)), 
            h, 
            h - (qreal(1.0) / qreal(3.0)) }; 

        for (int i = 0; i != 3; ++i) { 
            if (temp3[i] < qreal(0.0)) 
                temp3[i] += qreal(1.0); 
            else if (temp3[i] > qreal(1.0)) 
                temp3[i] -= qreal(1.0);

            const qreal sixtemp3 = temp3[i] * qreal(6.0);

            if (sixtemp3 < qreal(1.0)) 
                ca[i] = ((temp1 + (temp2 - temp1) * sixtemp3)); 
            else if ((temp3[i] * qreal(2.0)) < qreal(1.0)) 
                ca[i] = (temp2); 
            else if ((temp3[i] * qreal(3.0)) < qreal(2.0)) 
                ca[i] = temp1 + (temp2 -temp1) * (qreal(2.0) /qreal(3.0) - temp3[i]) * qreal(6.0);
            else ca[i] = temp1;
        }
    }
    
    return QColor::fromRgbF(ca[0], ca[1], ca[2]);
}

#define Q_MAX_3(a, b, c) ( ( a > b && a > c) ? a : (b > c ? b : c) )
#define Q_MIN_3(a, b, c) ( ( a < b && a < c) ? a : (b < c ? b : c) )

QColor toHsl(QColor c)
{
    QColor color; 
    qreal h;
    qreal s;
    qreal l;

    const qreal r = c.redF();
    const qreal g = c.greenF();
    const qreal b = c.blueF();
    const qreal max = Q_MAX_3(r, g, b); 
    const qreal min = Q_MIN_3(r, g, b); 
    const qreal delta = max - min;  
    const qreal delta2 = max + min; 
    const qreal lightness = qreal(0.5) * delta2; 
    l = (lightness);
    if (qFuzzyIsNull(delta)) { 
        // achromatic case, hue is undefined 
        h = 0;
        s = 0; 
    } else {
        // chromatic case 
        qreal hue = 0; 
        if (lightness < qreal(0.5)) 
            s = ((delta / delta2)); 
        else 
            s = ((delta / (qreal(2.0) - delta2))); 
        if (qFuzzyCompare(r, max)) { 
            hue = ((g - b) /delta); 
        } else if (qFuzzyCompare(g, max)) { 
            hue = (2.0 + (b - r) / delta); 
        } else if (qFuzzyCompare(b, max)) { 
            hue = (4.0 + (r - g) / delta); 
        } else { 
            Q_ASSERT_X(false, "QColor::toHsv", "internal error"); 
        }
        hue *= 60.0; 
        if (hue < 0.0) 
            hue += 360.0; 
        h = (hue * 100); 
    }

    h = h / 36000;

    return QColor::fromHsvF(h, s, l);
}

void tintColor(QColor &color, QColor tintColor, qreal _saturation)
{
    tintColor = toHsl(tintColor);
    color = toHsl(color);
    qreal hue = tintColor.hueF();

    qreal saturation = color.saturationF();
    if (_saturation)
        saturation = _saturation;
    qreal lightness = color.valueF();
    color.setHsvF(hue, saturation, lightness);

    color = fromHsl(color);
    color.toRgb();
}

void tintImagePal(QImage *image, QColor color, qreal saturation)
{
    QVector<QRgb> colorTable = image->colorTable();
    for (int i=2;i< colorTable.size();i++) {
        QColor c(toHsl(colorTable.at(i)));
        tintColor(c, color, saturation);
        colorTable[i] = c.rgb();
    }
    image->setColorTable(colorTable);
}


void tintImage(QImage *image, QColor color, qreal saturation)
{
    *image = image->convertToFormat(QImage::Format_RGB32);

    for (int x = 0; x < image->width(); x++)
        for (int y = 0; y < image->height(); y++) {
            QColor c(image->pixel(x,y));
            tintColor(c, color, saturation);
            image->setPixel(x, y, c.rgb());
        }
}

#endif //Q_WS_WINCE_WM


enum QSliderDirection { SliderUp, SliderDown, SliderLeft, SliderRight };

#ifdef Q_WS_WINCE_WM

void QWindowsMobileStylePrivate::tintImagesButton(QColor color)
{
    if (currentTintButton == color)
        return;
    currentTintButton = color;

    imageTabEnd = QImage(tabend_xpm);
    imageTabSelectedEnd = QImage(tabselectedend_xpm);
    imageTabSelectedBegin = QImage(tabselectedbeginn_xpm);
    imageTabMiddle = QImage(tabmiddle_xpm);
    tintImage(&imageTabEnd, color, 0.0);
    tintImage(&imageTabSelectedEnd, color, 0.0);
    tintImage(&imageTabSelectedBegin, color, 0.0);
    tintImage(&imageTabMiddle, color, 0.0);

    if (!doubleControls) {
        int height = imageTabMiddle.height() / 2 + 1;
        imageTabEnd = imageTabEnd.scaledToHeight(height);
        imageTabMiddle = imageTabMiddle.scaledToHeight(height);
        imageTabSelectedEnd = imageTabSelectedEnd.scaledToHeight(height);
        imageTabSelectedBegin = imageTabSelectedBegin.scaledToHeight(height);
    }
}

void QWindowsMobileStylePrivate::tintImagesHigh(QColor color)
{
    if (currentTintHigh == color)
        return;
    currentTintHigh = color;
    tintListViewHighlight(color);
    imageScrollbarHandleUpHigh = imageScrollbarHandleUp;
    imageScrollbarHandleDownHigh = imageScrollbarHandleDown;
    tintImagePal(&imageScrollbarHandleDownHigh, color, qreal(0.8));
    tintImagePal(&imageScrollbarHandleUpHigh, color, qreal(0.8));
}

void QWindowsMobileStylePrivate::tintListViewHighlight(QColor color)
{
    imageListViewHighlightCornerRight = QImage(listviewhighcornerright_xpm);
    tintImage(&imageListViewHighlightCornerRight, color, qreal(0.0));

    imageListViewHighlightCornerLeft = QImage(listviewhighcornerleft_xpm);
    tintImage(&imageListViewHighlightCornerLeft, color, qreal(0.0));

    imageListViewHighlightMiddle = QImage(listviewhighmiddle_xpm);
    tintImage(&imageListViewHighlightMiddle, color, qreal(0.0));
     
     int height = imageListViewHighlightMiddle.height();
     if (!doubleControls) {
         height = height / 2;
         imageListViewHighlightCornerRight = imageListViewHighlightCornerRight.scaledToHeight(height);
         imageListViewHighlightCornerLeft = imageListViewHighlightCornerLeft.scaledToHeight(height);
         imageListViewHighlightMiddle = imageListViewHighlightMiddle.scaledToHeight(height);
     }
}

#endif //Q_WS_WINCE_WM

void QWindowsMobileStylePrivate::setupWindowsMobileStyle65()
{
#ifdef Q_WS_WINCE_WM
    wm65 = qt_wince_is_windows_mobile_65();
    if (wm65) {
        imageScrollbarHandleUp =  QImage(sbhandleup_xpm);
        imageScrollbarHandleDown = QImage(sbhandledown_xpm);
        imageScrollbarGripUp = QImage(sbgripup_xpm);
        imageScrollbarGripDown = QImage(sbgripdown_xpm);
        imageScrollbarGripMiddle = QImage(sbgripmiddle_xpm);

        if (!doubleControls) {
            imageScrollbarHandleUp = imageScrollbarHandleUp.scaledToHeight(imageScrollbarHandleUp.height() / 2);
            imageScrollbarHandleDown = imageScrollbarHandleDown.scaledToHeight(imageScrollbarHandleDown.height() / 2);
            imageScrollbarGripMiddle = imageScrollbarGripMiddle.scaledToHeight(imageScrollbarGripMiddle.height() / 2);
            imageScrollbarGripUp = imageScrollbarGripUp.scaledToHeight(imageScrollbarGripUp.height() / 2);
            imageScrollbarGripDown = imageScrollbarGripDown.scaledToHeight(imageScrollbarGripDown.height() / 2);
        } else {
        }
        tintImagesHigh(Qt::blue);
    }
#endif //Q_WS_WINCE_WM
}

void QWindowsMobileStylePrivate::drawTabBarTab(QPainter *painter, const QStyleOptionTab *tab)
{
#ifndef QT_NO_TABBAR
#ifdef Q_WS_WINCE_WM
    if (wm65) {
        tintImagesButton(tab->palette.button().color());
        QRect r;
        r.setTopLeft(tab->rect.topRight() - QPoint(imageTabMiddle.width(), 0));
        r.setBottomRight(tab->rect.bottomRight());
        if (tab->state & QStyle::State_Selected) {
            painter->fillRect(tab->rect, tab->palette.window());
        } else {
            painter->fillRect(tab->rect, QColor(imageTabMiddle.pixel(0,0)));
        }
        if  (tab->selectedPosition ==  QStyleOptionTab::NextIsSelected) {
            painter->drawImage(r, imageTabSelectedBegin);
        } else if (tab->position == QStyleOptionTab::End ||
            tab->position == QStyleOptionTab::OnlyOneTab) {
                if (!(tab->state & QStyle::State_Selected)) {
                    painter->drawImage(r, imageTabEnd);
                }
        } else if (tab->state & QStyle::State_Selected) {
            painter->drawImage(r, imageTabSelectedEnd);
        } else {
            painter->drawImage(r, imageTabMiddle);
        }
        if (tab->position == QStyleOptionTab::Beginning && ! (tab->state & QStyle::State_Selected)) {
            painter->drawImage(tab->rect.topLeft() - QPoint(imageTabMiddle.width() * 0.60, 0), imageTabSelectedEnd);
        }
        //imageTabBarBig
        return;
    }
#endif //Q_WS_WINCE_WM
    painter->save();
    painter->setPen(tab->palette.shadow().color());
    if (doubleControls) {
        QPen pen = painter->pen();
        pen.setWidth(2);
        pen.setCapStyle(Qt::FlatCap);
        painter->setPen(pen);
    }
    if(tab->shape == QTabBar::RoundedNorth) {
        if (tab->state & QStyle::State_Selected) {
            painter->fillRect(tab->rect, tab->palette.light());
            painter->drawLine(tab->rect.topRight(), tab->rect.bottomRight());
        }
        else {
            painter->fillRect(tab->rect, tab->palette.button());
            painter->drawLine(tab->rect.bottomLeft() , tab->rect.bottomRight());
            painter->drawLine(tab->rect.topRight(), tab->rect.bottomRight());
        }
    }
    else if(tab->shape == QTabBar::RoundedSouth) {
        if (tab->state & QStyle::State_Selected) {
            painter->fillRect(tab->rect.adjusted(0,-2,0,0), tab->palette.light());
            painter->drawLine(tab->rect.topRight(), tab->rect.bottomRight());
        }
        else {
            painter->fillRect(tab->rect, tab->palette.button());
            if (doubleControls)
                painter->drawLine(tab->rect.topLeft() + QPoint(0,1), tab->rect.topRight() + QPoint(0,1));
            else
                painter->drawLine(tab->rect.topLeft(), tab->rect.topRight());
            painter->drawLine(tab->rect.topRight(), tab->rect.bottomRight());
        }
    }
    else if(tab->shape == QTabBar::RoundedEast) {
        if (tab->state & QStyle::State_Selected) {
            painter->fillRect(tab->rect, tab->palette.light());
            painter->drawLine(tab->rect.topLeft(), tab->rect.topRight());
        }
        else {
            painter->fillRect(tab->rect, tab->palette.button());
            painter->drawLine(tab->rect.topLeft(), tab->rect.bottomLeft());
            painter->drawLine(tab->rect.topLeft(), tab->rect.topRight());
        }
    }
    else if(tab->shape == QTabBar::RoundedWest) {
        if (tab->state & QStyle::State_Selected) {
            painter->fillRect(tab->rect, tab->palette.light());
            painter->drawLine(tab->rect.bottomLeft(), tab->rect.bottomRight());
        }
        else {
            painter->fillRect(tab->rect, tab->palette.button());
            painter->drawLine(tab->rect.topRight(), tab->rect.bottomRight());
            painter->drawLine(tab->rect.bottomLeft(), tab->rect.bottomRight());
        }
    }
    painter->restore();
#endif //QT_NO_TABBAR
}

void QWindowsMobileStylePrivate::drawPanelItemViewSelected(QPainter *painter, const QStyleOptionViewItemV4 *option, QRect rect)
{
#ifdef Q_WS_WINCE_WM
    if (wm65) {
        QRect r;
        if (rect.isValid())
            r = rect;
        else 
            r = option->rect;
        tintImagesHigh(option->palette.highlight().color());

        painter->setPen(QColor(Qt::lightGray));

        if (option->viewItemPosition ==  QStyleOptionViewItemV4::Middle) {
            painter->drawImage(r, imageListViewHighlightMiddle);
        } else if (option->viewItemPosition ==  QStyleOptionViewItemV4::Beginning) {
            painter->drawImage(r.adjusted(10, 0, 0, 0), imageListViewHighlightMiddle);
        } else if (option->viewItemPosition ==  QStyleOptionViewItemV4::End) {
            painter->drawImage(r.adjusted(0, 0, -10, 0), imageListViewHighlightMiddle);
        } else {
            painter->drawImage(r.adjusted(10, 0, -10, 0), imageListViewHighlightMiddle);
        }

        QImage cornerLeft = imageListViewHighlightCornerLeft;
        QImage cornerRight = imageListViewHighlightCornerRight;

        int width = r.width() > cornerRight.width() ? r.width() : cornerRight.width();

        if ((width * 2) > r.width()) {
            width = (r.width() - 5) / 2;
        }

        cornerLeft = cornerLeft.scaled(width, r.height());
        cornerRight = cornerRight.scaled(width, r.height());

        if ((option->viewItemPosition ==  QStyleOptionViewItemV4::Beginning) || (option->viewItemPosition ==  QStyleOptionViewItemV4::OnlyOne) || !option->viewItemPosition) {
            painter->drawImage(r.topLeft(), cornerLeft);
        }
        if ((option->viewItemPosition ==  QStyleOptionViewItemV4::End) || (option->viewItemPosition ==  QStyleOptionViewItemV4::OnlyOne) || !option->viewItemPosition) {
            painter->drawImage(r.topRight() - QPoint(cornerRight.width(),0), cornerRight);
        }
        return;
    }
#endif //Q_WS_WINCE_WM
    QPalette::ColorGroup cg = option->state & QStyle::State_Enabled
                                      ? QPalette::Normal : QPalette::Disabled;

    if (rect.isValid())
        painter->fillRect(rect, option->palette.brush(cg, QPalette::Highlight));
    else
        painter->fillRect(option->rect, option->palette.brush(cg, QPalette::Highlight));
}

void QWindowsMobileStylePrivate::drawScrollbarGrip(QPainter *p, QStyleOptionSlider *newScrollbar, const QStyleOptionComplex *option, bool drawCompleteFrame)
{
#ifdef Q_WS_WINCE_WM
    if (wm65) {
        if (newScrollbar->orientation == Qt::Horizontal) {
            QTransform transform;
            transform.rotate(-90);
            QRect r = newScrollbar->rect;
            p->drawImage(r.adjusted(10, 0, -10, 0), imageScrollbarGripMiddle.transformed(transform));
            p->drawImage(r.topLeft(), imageScrollbarGripUp.transformed(transform));
            p->drawImage(r.topRight() - QPoint(imageScrollbarGripDown.height() - 1, 0), imageScrollbarGripDown.transformed(transform));
        } else {
            QRect r = newScrollbar->rect;
            p->drawImage(r.adjusted(0, 10, 0, -10), imageScrollbarGripMiddle);
            p->drawImage(r.topLeft(), imageScrollbarGripUp);
            p->drawImage(r.bottomLeft() - QPoint(0, imageScrollbarGripDown.height() - 1), imageScrollbarGripDown);
        }
        return ;
    }
#endif
        if (newScrollbar->orientation == Qt::Horizontal) {
            p->fillRect(newScrollbar->rect,option->palette.button());
            QRect r = newScrollbar->rect;
            p->drawLine(r.topLeft(), r.bottomLeft());
            p->drawLine(r.topRight(), r.bottomRight());
            if (smartphone) {
                p->drawLine(r.topLeft(), r.topRight());
                p->drawLine(r.bottomLeft(), r.bottomRight());
            }
        }
        else {
            p->fillRect(newScrollbar->rect,option->palette.button());
            QRect r = newScrollbar->rect;
            p->drawLine(r.topLeft(), r.topRight());
            p->drawLine(r.bottomLeft(), r.bottomRight());
            if (smartphone) {
                p->drawLine(r.topLeft(), r.bottomLeft());
                p->drawLine(r.topRight(), r.bottomRight());
            }
        }
        if (newScrollbar->state & QStyle::State_HasFocus) {
            QStyleOptionFocusRect fropt;
            fropt.QStyleOption::operator=(*newScrollbar);
            fropt.rect.setRect(newScrollbar->rect.x() + 2, newScrollbar->rect.y() + 2,
                newScrollbar->rect.width() - 5,
                newScrollbar->rect.height() - 5);
        }
    int gripMargin = doubleControls ? 4 : 2;
    int doubleLines = doubleControls ? 2 : 1;
    //If there is a frame around the scrollbar (abstractScrollArea),
    //then the margin is different, because of the missing frame
    int gripMarginFrame = doubleControls ? 3 : 1;
    if (drawCompleteFrame)
        gripMarginFrame = 0;
    //draw grips
    if (!smartphone)
        if (newScrollbar->orientation == Qt::Horizontal) {
            for (int i = -3; i < 3; i += 2) {
                p->drawLine(
                    QPoint(newScrollbar->rect.center().x() + i * doubleLines + 1,
                    newScrollbar->rect.top() + gripMargin +gripMarginFrame),
                    QPoint(newScrollbar->rect.center().x() + i * doubleLines + 1,
                    newScrollbar->rect.bottom() - gripMargin));
            }
        } else {
            for (int i = -2; i < 4 ; i += 2) {
                p->drawLine(
                    QPoint(newScrollbar->rect.left() + gripMargin + gripMarginFrame ,
                    newScrollbar->rect.center().y() + 1 + i * doubleLines - 1),
                    QPoint(newScrollbar->rect.right() - gripMargin,
                    newScrollbar->rect.center().y() + 1 + i * doubleLines - 1));
            }
        }
        if (!smartphone) {
            QRect r;
            if (doubleControls)
                r = option->rect.adjusted(1, 1, -1, 0);
            else
                r = option->rect.adjusted(0, 0, -1, 0);
            if (drawCompleteFrame && doubleControls)
                r.adjust(0, 0, 0, -1);
            //Check if the scrollbar is part of an abstractItemView and draw the frame according
            if (drawCompleteFrame)
                p->drawRect(r);
            else
                if (newScrollbar->orientation == Qt::Horizontal)
                    p->drawLine(r.topLeft(), r.topRight());
                else
                    p->drawLine(r.topLeft(), r.bottomLeft());
        }
}

void QWindowsMobileStylePrivate::drawScrollbarHandleUp(QPainter *p, QStyleOptionSlider *opt, bool completeFrame, bool )
{
#ifdef Q_WS_WINCE_WM
    if (wm65) {
        tintImagesHigh(opt->palette.highlight().color());
        QRect r = opt->rect;
         if (opt->orientation == Qt::Horizontal) {
            QTransform transform;
            transform.rotate(-90);
            if (opt->state & QStyle::State_Sunken)
                p->drawImage(r.topLeft(), imageScrollbarHandleUpHigh.transformed(transform));
            else
                p->drawImage(r.topLeft(), imageScrollbarHandleUp.transformed(transform));
         } else {
             if (opt->state & QStyle::State_Sunken)
                 p->drawImage(r.topLeft(), imageScrollbarHandleUpHigh);
             else
                 p->drawImage(r.topLeft(), imageScrollbarHandleUp);
         }
        return ;
    }
#endif //Q_WS_WINCE_WM

    QBrush fill = opt->palette.button();
    if (opt->state & QStyle::State_Sunken)
        fill = opt->palette.shadow();

    QStyleOption arrowOpt = *opt;
    if (doubleControls)
        arrowOpt.rect = opt->rect.adjusted(4, 6, -5, -3);
    else
        arrowOpt.rect = opt->rect.adjusted(5, 6, -4, -3);

    bool horizontal = (opt->orientation == Qt::Horizontal);

    if (horizontal) {
        p->fillRect(opt->rect,fill);
        QRect r = opt->rect.adjusted(0,0,1,0);
        p->drawLine(r.topRight(), r.bottomRight());
        if (doubleControls)
            arrowOpt.rect.adjust(0, -2 ,0, -2);
        q_func()->proxy()->drawPrimitive(QStyle::PE_IndicatorArrowLeft, &arrowOpt, p, 0);
    } else {
        p->fillRect(opt->rect,fill);
        QRect r = opt->rect.adjusted(0, 0, 0, 1);
        p->drawLine(r.bottomLeft(), r.bottomRight());
        if (completeFrame)
            arrowOpt.rect.adjust(-2, 0, -2, 0);
        if (doubleControls)
            arrowOpt.rect.adjust(0, -4 , 0, -4);
        if (completeFrame && doubleControls)
            arrowOpt.rect.adjust(2, 0, 2, 0);
        q_func()->proxy()->drawPrimitive(QStyle::PE_IndicatorArrowUp, &arrowOpt, p, 0);
    }
}

void QWindowsMobileStylePrivate::drawScrollbarHandleDown(QPainter *p, QStyleOptionSlider *opt, bool completeFrame, bool secondScrollBar)
{
#ifndef QT_NO_SCROLLBAR
#ifdef Q_WS_WINCE_WM
    if (wm65) {
        tintImagesHigh(opt->palette.highlight().color());
        QRect r = opt->rect;
        if (opt->orientation == Qt::Horizontal) {
            QTransform transform;
            transform.rotate(-90);
            if (opt->state & QStyle::State_Sunken)
                p->drawImage(r.topLeft(), imageScrollbarHandleDownHigh.transformed(transform));
            else
                p->drawImage(r.topLeft(), imageScrollbarHandleDown.transformed(transform));
        } else {
            if (opt->state & QStyle::State_Sunken)
                p->drawImage(r.topLeft(), imageScrollbarHandleDownHigh);
            else
                p->drawImage(r.topLeft(), imageScrollbarHandleDown);
        }
        return ;
    }
#endif //Q_WS_WINCE_WM

    QBrush fill = opt->palette.button();
    if (opt->state & QStyle::State_Sunken)
        fill = opt->palette.shadow();

    QStyleOption arrowOpt = *opt;
    if (doubleControls)
        arrowOpt.rect = opt->rect.adjusted(4, 0, -5, 3);
    else
        arrowOpt.rect = opt->rect.adjusted(5, 6, -4, -3);

    bool horizontal = (opt->orientation == Qt::Horizontal);

    if (horizontal) {
        p->fillRect(opt->rect,fill);
        QRect r = opt->rect.adjusted(0, 0, 0, 0);
        p->drawLine(r.topLeft(), r.bottomLeft());
        if (secondScrollBar)
            p->drawLine(r.topRight(), r.bottomRight());
        if (doubleControls)
            arrowOpt.rect.adjust(0, 4, 0, 4 );
        q_func()->proxy()->drawPrimitive(QStyle::PE_IndicatorArrowRight, &arrowOpt, p, 0);
    } else {
        p->fillRect(opt->rect,fill);
        QRect r = opt->rect.adjusted(0, -1, 0, -1);
        p->drawLine(r.topLeft(), r.topRight());
        if (secondScrollBar)
            p->drawLine(r.bottomLeft() + QPoint(0,1), r.bottomRight() + QPoint(0, 1));
        if (completeFrame)
            arrowOpt.rect.adjust(-2, 0, -2, 0);
        if (doubleControls)
            arrowOpt.rect.adjust(1, 0, 1, 0 );
        if (completeFrame && doubleControls)
            arrowOpt.rect.adjust(1, 0, 1, 0);
        q_func()->proxy()->drawPrimitive(QStyle::PE_IndicatorArrowDown, &arrowOpt, p, 0);
    }
#endif //QT_NO_SCROLLBAR
}

void QWindowsMobileStylePrivate::drawScrollbarGroove(QPainter *p,const QStyleOptionSlider *opt)
{
#ifndef QT_NO_SCROLLBAR
#ifdef Q_OS_WINCE_WM
    if (wm65) {
        p->fillRect(opt->rect, QColor(231, 231, 231));
        return ;
    }
#endif
            QBrush fill;
            if (smartphone) {
                fill = opt->palette.light();
                p->fillRect(opt->rect, fill);
                fill = opt->palette.button();
                QImage image;
#ifndef QT_NO_IMAGEFORMAT_XPM
                if (opt->orientation == Qt::Horizontal)
                  image = QImage(vertlines_xpm);
                else
                  image = QImage(horlines_xpm);
#endif
                image.setColor(1, opt->palette.button().color().rgb());
                fill.setTextureImage(image);
            }
            else {
              fill = opt->palette.light();
            }
            p->fillRect(opt->rect, fill);
#endif //QT_NO_SCROLLBAR
}

QWindowsMobileStyle::QWindowsMobileStyle(QWindowsMobileStylePrivate &dd) : QWindowsStyle(dd) {
    qApp->setEffectEnabled(Qt::UI_FadeMenu, false);
    qApp->setEffectEnabled(Qt::UI_AnimateMenu, false);
}

QWindowsMobileStyle::QWindowsMobileStyle() : QWindowsStyle(*new QWindowsMobileStylePrivate) {
    qApp->setEffectEnabled(Qt::UI_FadeMenu, false);
    qApp->setEffectEnabled(Qt::UI_AnimateMenu, false);
}

QWindowsMobileStylePrivate::QWindowsMobileStylePrivate() :QWindowsStylePrivate() {

#ifdef Q_WS_WINCE
   doubleControls = qt_wince_is_high_dpi();
   smartphone = qt_wince_is_smartphone();
#else
   doubleControls = false;
   smartphone = false;
#endif //Q_WS_WINCE

#ifndef QT_NO_IMAGEFORMAT_XPM

   imageArrowDown = QImage(arrowdown_xpm);
   imageArrowUp = QImage(arrowdown_xpm).mirrored();
   imageArrowLeft = QImage(arrowleft_xpm);
   imageArrowRight = QImage(arrowleft_xpm).mirrored(true, false);
   if (doubleControls) {
       imageRadioButton = QImage(radiobutton_xpm);
       imageRadioButtonChecked = QImage(radiochecked_xpm);
       imageChecked = QImage(checkedlight_xpm);
       imageCheckedBold = QImage(checkedbold_xpm);
       imageRadioButtonHighlighted = QImage(highlightedradiobutton_xpm);
       imageClose = QImage(cross_big_xpm);
       imageMaximize = QImage(max_big_xpm);
       imageMinimize = QImage(min_big_xpm);
       imageNormalize = QImage(normal_big_xpm);
   } else {
       imageRadioButton = QImage(radiobutton_low_xpm);
       imageRadioButtonChecked = QImage(radiochecked_low_xpm);
       imageChecked = QImage(checkedlight_low_xpm);
       imageCheckedBold = QImage(checkedbold_low_xpm);
       imageRadioButtonHighlighted = QImage(highlightedradiobutton_low_xpm);
       imageClose = QImage(cross_small_xpm);
       imageMaximize = QImage(max_small_xpm);
       imageMinimize = QImage(min_small_xpm);
       imageNormalize = QImage(normal_small_xpm);
   }

   setupWindowsMobileStyle65();


   imageArrowDownBig = QImage(arrowdown_big_xpm);
   imageArrowUpBig = QImage(arrowdown_big_xpm).mirrored();
   imageArrowLeftBig = QImage(arrowleft_big_xpm);
   imageArrowRightBig = QImage(arrowleft_big_xpm).mirrored(true, false);

#endif
}

void QWindowsMobileStyle::drawPrimitive(PrimitiveElement element, const QStyleOption *option,
                                    QPainter *painter, const QWidget *widget) const {

   QWindowsMobileStylePrivate *d = const_cast<QWindowsMobileStylePrivate*>(d_func());

    bool doRestore = false;
    QRect rect = option->rect;
    painter->setClipping(false);

    switch (element) {
    case PE_PanelButtonTool: {
        int penSize = 1;
        if (d->doubleControls)
            penSize = 2;
        if (widget)
            if (QWidget *parent = widget->parentWidget())
#ifndef QT_NO_TABWIDGET
                if (qobject_cast<QTabWidget *>(parent->parentWidget())) {
#else
                if (false) {
#endif //QT_NO_TABBAR
                    rect.adjust(0,2*penSize,0,-1*penSize);
                        qDrawPlainRect(painter, rect, option->palette.shadow().color(), penSize, &option->palette.light());
                    if (option->state & (State_Sunken))
                        qDrawPlainRect(painter, rect, option->palette.shadow().color(), penSize, &option->palette.shadow());
                }
                else {
                    if (!(option->state & State_AutoRaise) || (option->state & (State_Sunken | State_On)))
                        qDrawPlainRect(painter,option->rect.adjusted(0, penSize, 0, -1 * penSize) ,
                                       option->palette.button().color(), 0, &option->palette.button());
                    if (option->state & (State_Sunken)) {
                        qDrawPlainRect(painter, rect, option->palette.shadow().color(), penSize, &option->palette.light());
                    }
                    if (option->state & (State_On)){
                        QBrush fill = QBrush(option->palette.light().color());
                        painter->fillRect(rect.adjusted(windowsItemFrame , windowsItemFrame ,
                                          -windowsItemFrame , -windowsItemFrame ), fill);
                        qDrawPlainRect(painter, rect, option->palette.shadow().color(), penSize, &option->palette.light());
                    }
                }
                break; }
    case PE_IndicatorButtonDropDown:
        if (d->doubleControls)
          qDrawPlainRect(painter, option->rect, option->palette.shadow().color(), 2, &option->palette.button());
        else
          qDrawPlainRect(painter, option->rect, option->palette.shadow().color(), 1, &option->palette.button());
        break;
#ifndef QT_NO_TABBAR
    case PE_IndicatorTabTear:
        if (const QStyleOptionTab *tab = qstyleoption_cast<const QStyleOptionTab *>(option)) {
            bool rtl = tab->direction == Qt::RightToLeft;
            QRect rect = tab->rect;
            QPainterPath path;
            rect.setTop(rect.top() + ((tab->state & State_Selected) ? 1 : 3));
            rect.setBottom(rect.bottom() - ((tab->state & State_Selected) ? 0 : 2));
            path.moveTo(QPoint(rtl ? rect.right() : rect.left(), rect.top()));
            int count = 3;
            for(int jags = 1; jags <= count; ++jags, rtl = !rtl)
                path.lineTo(QPoint(rtl ? rect.left() : rect.right(), rect.top() + jags * rect.height()/count));
            painter->setPen(QPen(tab->palette.light(), qreal(.8)));
            painter->setBrush(tab->palette.background());
            painter->setRenderHint(QPainter::Antialiasing);
            painter->drawPath(path);
        }
        break;
#endif //QT_NO_TABBAR

#ifndef QT_NO_TOOLBAR
    case PE_IndicatorToolBarSeparator: {
            painter->save();
            QPoint p1, p2;
            if (option->state & State_Horizontal) {
                p1 = QPoint(option->rect.width()/2, 0);
                p2 = QPoint(p1.x(), option->rect.height());
            } else {
                p1 = QPoint(0, option->rect.height()/2);
                p2 = QPoint(option->rect.width(), p1.y());
            }


            painter->setPen(option->palette.mid().color());
            if (d->doubleControls) {
                QPen pen = painter->pen();
                pen.setWidth(2);
                pen.setCapStyle(Qt::FlatCap);
                painter->setPen(pen);
            }
            painter->drawLine(p1, p2);
            painter->restore();
            break; }
#endif // QT_NO_TOOLBAR
    case PE_IndicatorToolBarHandle:
        painter->save();
        painter->translate(option->rect.x(), option->rect.y());
        if (option->state & State_Horizontal) {
            int x = option->rect.width() / 2 - 4;
            if (QApplication::layoutDirection() == Qt::RightToLeft)
                x -= 2;
            if (option->rect.height() > 4) {
                qDrawWinButton(painter,x-1,0,7,option->rect.height(), option->palette, false,  0);

                qDrawShadePanel(painter, x, 1, 3, option->rect.height() - 1,
                    option->palette, false,  0);
                qDrawShadePanel(painter, x + 3, 1, 3, option->rect.height() - 1,
                    option->palette, false,  0);
                painter->setPen(option->palette.button().color());
            }
        } else {
            if (option->rect.width() > 4) {
                int y = option->rect.height() / 2 - 4;
                qDrawShadePanel(painter, 2, y, option->rect.width() - 2, 3,
                    option->palette, false,  0);
                qDrawShadePanel(painter, 2, y + 3, option->rect.width() - 2, 3,
                    option->palette, false,  0);
            }
        }
        painter->restore();
        break;

#ifndef QT_NO_PROGRESSBAR
    case PE_IndicatorProgressChunk: {
            bool vertical = false;
            if (const QStyleOptionProgressBarV2 *pb2 = qstyleoption_cast<const QStyleOptionProgressBarV2 *>(option))
                vertical = (pb2->orientation == Qt::Vertical);
            if (!vertical) {
                painter->fillRect(option->rect.x(), option->rect.y()+2, option->rect.width(), option->rect.height()-4,
                            option->palette.brush(QPalette::Highlight));
            } else {
                painter->fillRect(option->rect.x()+2, option->rect.y(), option->rect.width()-4, option->rect.height(),
                            option->palette.brush(QPalette::Highlight));
            }
        }
        break;
#endif // QT_NO_PROGRESSBAR

    case PE_FrameButtonTool: {
#ifndef QT_NO_DOCKWIDGET
            if (widget && widget->inherits("QDockWidgetTitleButton")) {
                if (const QDockWidget *dw = qobject_cast<const QDockWidget *>(widget->parent()))
                    if (dw->isFloating()){
                        qDrawPlainRect(painter,option->rect.adjusted(1, 1, 0, 0),
                                       option->palette.shadow().color(),1,&option->palette.button());
                        return;
                    }
            }
#endif // QT_NO_DOCKWIDGET
        QBrush fill;
        bool stippled;
        bool panel = (element == PE_PanelButtonTool);
        if ((!(option->state & State_Sunken ))
            && (!(option->state & State_Enabled)
            || ((option->state & State_Enabled ) && !(option->state & State_MouseOver)))
            && (option->state & State_On)) {
                fill = QBrush(option->palette.light().color(), Qt::Dense4Pattern);
                stippled = true;
        } else {
            fill = option->palette.brush(QPalette::Button);
            stippled = false;
        }
        if (option->state & (State_Raised | State_Sunken | State_On)) {
            if (option->state & State_AutoRaise) {
                if(option->state & (State_Enabled | State_Sunken | State_On)){
                    if (panel)
                        qDrawPlainRect(painter, option->rect,option->palette.shadow().color(),d->doubleControls, &fill);
                    else
                        qDrawPlainRect(painter, option->rect,option->palette.shadow().color(),d->doubleControls, &fill);
                }
                if (stippled) {
                    painter->setPen(option->palette.button().color());
                    painter->drawRect(option->rect.adjusted(1, 1, -2, -2));
                }
            } else {
                qDrawPlainRect(painter, option->rect,option->palette.shadow().color(),d->doubleControls, &fill);
            }
        } else {
            painter->fillRect(option->rect, fill);
        }
        break; }

    case PE_FrameFocusRect:
        if (const QStyleOptionFocusRect *fropt = qstyleoption_cast<const QStyleOptionFocusRect *>(option)) {
            //### check for d->alt_down
            int penSize;
            d->doubleControls ? penSize = 2 : penSize = 1;
            bool alternateFocusStyle = false;
            if (!widget)
                alternateFocusStyle = true;
#ifndef QT_NO_COMBOBOX
            if (qobject_cast<const QComboBox*>(widget))
                alternateFocusStyle = true;
#endif
            if (!(fropt->state & State_KeyboardFocusChange) && !styleHint(SH_UnderlineShortcut, option))
                return;
            QRect r = option->rect;
            painter->save();
            painter->setBackgroundMode(Qt::TransparentMode);
            if (alternateFocusStyle) {
                QColor bg_col = fropt->backgroundColor;
                if (!bg_col.isValid())
                    bg_col = painter->background().color();
                // Create an "XOR" color.
                QColor patternCol((bg_col.red() ^ 0xff) & 0xff,
                    (bg_col.green() ^ 0xff) & 0xff,
                    (bg_col.blue() ^ 0xff) & 0xff);
                painter->setBrush(QBrush(patternCol, Qt::Dense4Pattern));
                painter->setBrushOrigin(r.topLeft());
            }
            else {
                painter->setPen(option->palette.highlight().color());
                painter->setBrush(option->palette.highlight());
            }
            painter->setPen(Qt::NoPen);
            painter->setBrushOrigin(r.topLeft());
            painter->drawRect(r.left(), r.top(), r.width(), penSize);    // Top
            painter->drawRect(r.left(), r.bottom(), r.width() + penSize - 1, penSize); // Bottom
            painter->drawRect(r.left(), r.top(), penSize, r.height());   // Left
            painter->drawRect(r.right(), r.top(), penSize, r.height());  // Right
            painter->restore();
        }
        break;

    case PE_PanelButtonBevel: {
        QBrush fill;
        bool panel = element != PE_FrameButtonBevel;
        painter->setBrushOrigin(option->rect.topLeft());
        if (!(option->state & State_Sunken) && (option->state & State_On))
            fill = QBrush(option->palette.light().color(), Qt::Dense4Pattern);
        else
            fill = option->palette.brush(QPalette::Button);

        if (option->state & (State_Raised | State_On | State_Sunken)) {
            if (d->doubleControls)
              qDrawPlainRect(painter, option->rect,option->palette.shadow().color(),2,&fill);
            else
              qDrawPlainRect(painter, option->rect,option->palette.shadow().color(),1,&fill);
        } else {
            if (panel)
                painter->fillRect(option->rect, fill);
            else
                painter->drawRect(option->rect);
        }
        break; }

    case PE_FrameGroupBox:
        if (const QStyleOptionFrame *frame = qstyleoption_cast<const QStyleOptionFrame *>(option)) {

            const QStyleOptionFrameV2 *frame2 = qstyleoption_cast<const QStyleOptionFrameV2 *>(option);
            if (frame2 && !(frame2->features & QStyleOptionFrameV2::Flat)) {
              QPen oldPen = painter->pen();
              QRect r = frame->rect;
              painter->setPen(frame->palette.shadow().color());
              painter->fillRect(r.x(), r.y(), r.x() + r.width()-1,
                                r.y() + r.height() - windowsMobileFrameGroupBoxOffset,
              frame->palette.light());
              painter ->drawLine(r.topLeft() + QPoint(-2, 1), r.topRight()+ QPoint(0, 1));
              if (d->doubleControls)
                painter ->drawLine(r.topLeft() + QPoint(-2, 2), r.topRight()+ QPoint(0, 2));
              painter->setPen(oldPen);
            }
        }
        break;

   case PE_IndicatorCheckBox: {
        QBrush fill;
        QRect r = d->doubleControls ? option->rect.adjusted(0,1,0,-1) : option->rect;
        if (option->state & State_NoChange)
            fill = QBrush(option->palette.shadow().color(), Qt::Dense4Pattern);
        else if (option->state & State_Sunken)
            fill = option->palette.button();
        else if (option->state & State_Enabled)
            fill = option->palette.base();
        else
            fill = option->palette.background();
        painter->save();
        doRestore = true;
        if (d->doubleControls && (option->state & State_NoChange))
            painter->fillRect(r, fill);
        else
            painter->fillRect(option->rect, fill);
        painter->setPen(option->palette.shadow().color());
        painter->drawLine(r.topLeft(), r.topRight());
        painter->drawLine(r.topRight(), r.bottomRight());
        painter->drawLine(r.bottomLeft(), r.bottomRight());
        painter->drawLine(r.bottomLeft(), r.topLeft());
        if (d->doubleControls) {
            QRect r0 = r.adjusted(1, 1, -1, -1);
            painter->drawLine(r0.topLeft(), r0.topRight());
            painter->drawLine(r0.topRight(), r0.bottomRight());
            painter->drawLine(r0.bottomLeft(), r0.bottomRight());
            painter->drawLine(r0.bottomLeft(), r0.topLeft());
        }
        if (option->state & State_HasFocus) {
            painter->setPen(option->palette.highlight().color());
            QRect r2 = d->doubleControls ? r.adjusted(2, 2, -2, -2) : r.adjusted(1, 1, -1, -1);
            painter->drawLine(r2.topLeft(), r2.topRight());
            painter->drawLine(r2.topRight(), r2.bottomRight());
            painter->drawLine(r2.bottomLeft(), r2.bottomRight());
            painter->drawLine(r2.bottomLeft(), r2.topLeft());
            if (d->doubleControls) {
                QRect r3 = r2.adjusted(1, 1, -1, -1);
                painter->drawLine(r3.topLeft(), r3.topRight());
                painter->drawLine(r3.topRight(), r3.bottomRight());
                painter->drawLine(r3.bottomLeft(), r3.bottomRight());
                painter->drawLine(r3.bottomLeft(), r3.topLeft());
            }
            painter->setPen(option->palette.shadow().color());
        }
        //fall through...
    }
    case PE_IndicatorViewItemCheck:
    case PE_Q3CheckListIndicator: {
        if (!doRestore) {
            painter->save();
            doRestore = true;
        }
        if (element == PE_Q3CheckListIndicator || element == PE_IndicatorViewItemCheck) {
            painter->setPen(option->palette.shadow().color());
            if (option->state & State_NoChange)
                painter->setBrush(option->palette.brush(QPalette::Button));
            if (d->doubleControls) {
                QRect r = QRect(option->rect.x(), option->rect.y(), windowsMobileitemViewCheckBoxSize * 2, windowsMobileitemViewCheckBoxSize * 2);
                qDrawPlainRect(painter, r, option->palette.shadow().color(), 2);
            } else {
                QRect r = QRect(option->rect.x(), option->rect.y(), windowsMobileitemViewCheckBoxSize, windowsMobileitemViewCheckBoxSize);
                qDrawPlainRect(painter, r, option->palette.shadow().color(), 1);
            }            
            if (option->state & State_Enabled)
                d->imageChecked.setColor(1, option->palette.shadow().color().rgba());
            else
              d->imageChecked.setColor(1, option->palette.dark().color().rgba());
            if (!(option->state & State_Off)) {
                if (d->doubleControls)
                    painter->drawImage(option->rect.x(), option->rect.y(), d->imageChecked);
                else
                    painter->drawImage(option->rect.x() + 3, option->rect.y() + 3, d->imageChecked);
            }
        }
        else {
            if (option->state & State_NoChange)
                d->imageCheckedBold.setColor(1, option->palette.dark().color().rgba());
            else if (option->state & State_Enabled)
                d->imageCheckedBold.setColor(1, option->palette.shadow().color().rgba());
            else
                d->imageCheckedBold.setColor(1, option->palette.dark().color().rgba());
            if (!(option->state & State_Off)) {
                if (d->doubleControls)
                    painter->drawImage(option->rect.x() + 2, option->rect.y(), d->imageCheckedBold);
                else
                    painter->drawImage(option->rect.x() + 3, option->rect.y() + 3, d->imageCheckedBold);
            }
        }
        if (doRestore)
            painter->restore();
        break; }
    case PE_IndicatorRadioButton: {
        painter->save();

        if (option->state & State_HasFocus) {
            d->imageRadioButtonHighlighted.setColor(1, option->palette.shadow().color().rgba());
            d->imageRadioButtonHighlighted.setColor(2, option->palette.highlight().color().rgba());
            painter->drawImage(option->rect.x(), option->rect.y(), d->imageRadioButtonHighlighted);
        }
        else {
            d->imageRadioButton.setColor(1, option->palette.shadow().color().rgba());
            painter->drawImage(option->rect.x(), option->rect.y(), d->imageRadioButton);
        }
        if (option->state & (State_Sunken | State_On)) {
            if  (option->state & State_Enabled)
                d->imageRadioButtonChecked.setColor(1, option->palette.shadow().color().rgba());
            else
                d->imageRadioButtonChecked.setColor(1, option->palette.dark().color().rgba());

            static const int offset = d->doubleControls ? 6 : 3;
            painter->drawImage(option->rect.x() + offset, option->rect.y() + offset, d->imageRadioButtonChecked);
        }
        painter->restore();
        break; }
   case PE_PanelButtonCommand:
       if (const QStyleOptionButton *button = qstyleoption_cast<const QStyleOptionButton *>(option)) {
           QBrush fill;
           State flags = option->state;
           QPalette pal = option->palette;
           QRect r = option->rect;
           if ((flags & State_Sunken || flags & State_On) )
               fill = pal.brush(QPalette::Shadow);
           else
               fill = pal.brush(QPalette::Button);
            int singleLine = 1;
            int doubleLine = 2;
            if (d->doubleControls) {
                singleLine = 2;
                doubleLine = 4;
            }
           if (button->features & QStyleOptionButton::DefaultButton && flags & State_Sunken) {
               if (d->doubleControls) {
                 qDrawPlainRect(painter, r, pal.shadow().color(), 1, &fill);
                 qDrawPlainRect(painter, r.adjusted(1, 1, -1, 1), pal.shadow().color(), 1, &fill);
               }
               else {
                    qDrawPlainRect(painter, r, pal.shadow().color(), 1, &fill);
               }
           } else if (flags & (State_Raised | State_Sunken | State_On | State_Sunken)) {
               qDrawPlainRect(painter, r, pal.shadow().color(), singleLine, &fill);
           } else {
               painter->fillRect(r, fill);
           }
       }
       break;
   case PE_FrameDefaultButton: {
       painter->save();
       painter->setPen(option->palette.shadow().color());
       QRect rect = option->rect;
       if (d->doubleControls) {
           rect.adjust(1, 1, -2, -2);
           painter->drawRect(rect);
           painter->drawRect(rect.adjusted(1, 1, -1, -1));
       }

       else {
            rect.adjust(2, 2, -3, -3);
            painter->drawRect(rect);
       }
       painter->restore();
       break; }
   case PE_IndicatorSpinPlus:
   case PE_IndicatorSpinMinus: {
       QRect r = option->rect;
       int fw = proxy()->pixelMetric(PM_DefaultFrameWidth, option, widget)+2;
       QRect br = r.adjusted(fw, fw, -fw, -fw);
       int offset = (option->state & State_Sunken) ? 1 : 0;
       int step = (br.width() + 4) / 5;
       painter->fillRect(br.x() + offset, br.y() + offset +br.height() / 2 - step / 2,
                         br.width(), step, option->palette.buttonText());
       if (element == PE_IndicatorSpinPlus)
           painter->fillRect(br.x() + br.width() / 2 - step / 2 + offset, br.y() + offset+4,
                             step, br.height() - 7, option->palette.buttonText());
       break; }
    case PE_IndicatorSpinUp:
    case PE_IndicatorSpinDown: {
        painter->save();
            QPoint points[7];
            switch (element) {
                case PE_IndicatorSpinUp:
                    points[0] = QPoint(-2, -4);
                    points[1] = QPoint(-2, 2);
                    points[2] = QPoint(-1, -3);
                    points[3] = QPoint(-1, 1);
                    points[4] = QPoint(0, -2);
                    points[5] = QPoint(0, 0);
                    points[6] = QPoint(1, -1);
                break;
                case PE_IndicatorSpinDown:
                    points[0] = QPoint(0, -4);
                    points[1] = QPoint(0, 2);
                    points[2] = QPoint(-1, -3);
                    points[3] = QPoint(-1, 1);
                    points[4] = QPoint(-2, -2);
                    points[5] = QPoint(-2, 0);
                    points[6] = QPoint(-3, -1);
                break;
                default:
                break;
            }
            if (option->state & State_Sunken)
                painter->translate(proxy()->pixelMetric(PM_ButtonShiftHorizontal),
                proxy()->pixelMetric(PM_ButtonShiftVertical));
            if (option->state & State_Enabled) {
                painter->translate(option->rect.x() + option->rect.width() / 2,
                                   option->rect.y() + option->rect.height() / 2);
                painter->setPen(option->palette.buttonText().color());
                painter->drawLine(points[0], points[1]);
                painter->drawLine(points[2], points[3]);
                painter->drawLine(points[4], points[5]);
                painter->drawPoint(points[6]);
            } else {
                painter->translate(option->rect.x() + option->rect.width() / 2 + 1,
                                   option->rect.y() + option->rect.height() / 2 + 1);
                painter->setPen(option->palette.light().color());
                painter->drawLine(points[0], points[1]);
                painter->drawLine(points[2], points[3]);
                painter->drawLine(points[4], points[5]);
                painter->drawPoint(points[6]);
                painter->translate(-1, -1);
                painter->setPen(option->palette.mid().color());
                painter->drawLine(points[0], points[1]);
                painter->drawLine(points[2], points[3]);
                painter->drawLine(points[4], points[5]);
                painter->drawPoint(points[6]);
            }
        painter->restore();
        break; }

    case PE_IndicatorArrowUpBig:
    case PE_IndicatorArrowDownBig:
    case PE_IndicatorArrowLeftBig:
    case PE_IndicatorArrowRightBig:

    case PE_IndicatorArrowUp:
    case PE_IndicatorArrowDown:
    case PE_IndicatorArrowRight:
    case PE_IndicatorArrowLeft: {
            painter->save();

            if (d->doubleControls) {
                QColor color;
                if (option->state & State_Sunken)
                    color = option->palette.light().color();
                else
                    color = option->palette.buttonText().color();
                QImage image;
                int xoffset, yoffset;
                bool isTabBarArrow = widget && widget->parent()
                                   && widget->inherits("QToolButton")
                                   && widget->parent()->inherits("QTabBar");

                switch (element) {
                    case PE_IndicatorArrowUp:
                          image = d->imageArrowUp;
                          xoffset = 1;
                          yoffset = 12;
                          break;
                    case PE_IndicatorArrowDown:
                          image = d->imageArrowDown;
                          xoffset = 1;
                          yoffset =12;
                          break;
                    case PE_IndicatorArrowLeft:
                          image = d->imageArrowLeft;
                          xoffset = 8;
                          yoffset = isTabBarArrow ? 12 : 2;
                          break;
                    case PE_IndicatorArrowRight:
                          image = d->imageArrowRight;
                          xoffset = 8;
                          yoffset = isTabBarArrow ? 12 : 2;
                          break;
                     case PE_IndicatorArrowUpBig:
                          image = d->imageArrowUpBig;
                          xoffset = 3;
                          yoffset = 12;
                          break;
                    case PE_IndicatorArrowDownBig:
                          image = d->imageArrowDownBig;
                          xoffset = 2;
                          yoffset =12;
                          break;
                    case PE_IndicatorArrowLeftBig:
                          image = d->imageArrowLeftBig;
                          xoffset = 8;
                          yoffset = 2;
                          break;
                    case PE_IndicatorArrowRightBig:
                          image = d->imageArrowRightBig;
                          xoffset = 8;
                          yoffset = 2;
                          break;
                    default:
                          break;
                }
                image.setColor(1, color.rgba());
                painter->drawImage(option->rect.x() + xoffset, option->rect.y() + yoffset, image);
            }
            else {                
                 QPoint points[7];
                 switch (element) {
                     case PE_IndicatorArrowUp:
                     case PE_IndicatorArrowUpBig:
                          points[0] = QPoint(-3, 1);
                          points[1] = QPoint(3, 1);
                          points[2] = QPoint(-2, 0);
                          points[3] = QPoint(2, 0);
                          points[4] = QPoint(-1, -1);
                          points[5] = QPoint(1, -1);
                          points[6] = QPoint(0, -2);
                          break;
                     case PE_IndicatorArrowDown:
                     case PE_IndicatorArrowDownBig:
                         points[0] = QPoint(-3, -1);
                         points[1] = QPoint(3, -1);
                         points[2] = QPoint(-2, 0);
                         points[3] = QPoint(2, 0);
                         points[4] = QPoint(-1, 1);
                         points[5] = QPoint(1, 1);
                         points[6] = QPoint(0, 2);
                         break;
                     case PE_IndicatorArrowRight:
                     case PE_IndicatorArrowRightBig:
                         points[0] = QPoint(-2, -3);
                         points[1] = QPoint(-2, 3);
                         points[2] = QPoint(-1, -2);
                         points[3] = QPoint(-1, 2);
                         points[4] = QPoint(0, -1);
                         points[5] = QPoint(0, 1);
                         points[6] = QPoint(1, 0);
                         break;
                     case PE_IndicatorArrowLeft:
                     case PE_IndicatorArrowLeftBig:
                         points[0] = QPoint(0, -3);
                         points[1] = QPoint(0, 3);
                         points[2] = QPoint(-1, -2);
                         points[3] = QPoint(-1, 2);
                         points[4] = QPoint(-2, -1);
                         points[5] = QPoint(-2, 1);
                         points[6] = QPoint(-3, 0);
                         break;
                     default:
                     break;
                    }
                    if (option->state & State_Sunken)
                        painter->setPen(option->palette.light().color());
                    else
                        painter->setPen(option->palette.buttonText().color());
                    if (option->state & State_Enabled) {
                        painter->translate(option->rect.x() + option->rect.width() / 2,
                            option->rect.y() + option->rect.height() / 2 - 1);
                        painter->drawLine(points[0], points[1]);
                        painter->drawLine(points[2], points[3]);
                        painter->drawLine(points[4], points[5]);
                        painter->drawPoint(points[6]);
                    } else {
                        painter->translate(option->rect.x() + option->rect.width() / 2,
                            option->rect.y() + option->rect.height() / 2 - 1);
                        painter->setPen(option->palette.mid().color());
                        painter->drawLine(points[0], points[1]);
                        painter->drawLine(points[2], points[3]);
                        painter->drawLine(points[4], points[5]);
                        painter->drawPoint(points[6]);
                    }                
            }
        painter->restore();
        break; }
#ifndef QT_NO_TABWIDGET
    case PE_FrameTabWidget:
        if (const QStyleOptionTabWidgetFrame *tab = qstyleoption_cast<const QStyleOptionTabWidgetFrame *>(option)) {
          QRect rect = option->rect;
        QPalette pal = option->palette;
        painter->save();
        QBrush fill = pal.light();
          painter->fillRect(rect, fill);
          painter->setPen(pal.shadow().color());
          if (d->doubleControls) {
              QPen pen = painter->pen();
              pen.setWidth(2);
              pen.setCapStyle(Qt::FlatCap);
              painter->setPen(pen);
          }
          switch (tab->shape) {
            case QTabBar::RoundedNorth:
#ifdef Q_WS_WINCE_WM
                if (!d->wm65)
#endif
                {
                if (d->doubleControls)
                    painter->drawLine(rect.topLeft() + QPoint(0, 1), rect.topRight() + QPoint(0, 1));
                else
                    painter->drawLine(rect.topLeft(), rect.topRight());
                }
                break;
            case QTabBar::RoundedSouth:
#ifdef Q_WS_WINCE_WM
                if (!d->wm65)
#endif
                {
                if (d->doubleControls)
                  painter->drawLine(rect.bottomLeft(), rect.bottomRight());
                else
                  painter->drawLine(rect.bottomLeft(), rect.bottomRight());
                }
                break;
            case QTabBar::RoundedEast:
#ifdef Q_WS_WINCE_WM
                if (!d->wm65)
#endif
                painter->drawLine(rect.topRight(), rect.bottomRight());
                break;
            case QTabBar::RoundedWest:
#ifdef Q_WS_WINCE_WM
                if (!d->wm65)
#endif
                painter->drawLine(rect.topLeft(), rect.bottomLeft());
                break;
            case QTabBar::TriangularWest:
            case QTabBar::TriangularEast:
            case QTabBar::TriangularSouth:
            case QTabBar::TriangularNorth:
                if (d->doubleControls)
                  qDrawPlainRect(painter, rect.adjusted(0,-2,0,0), option->palette.shadow().color(),2,&pal.light());
                else
                  qDrawPlainRect(painter, rect, option->palette.shadow().color(),1,&pal.light());
                break;
            default:
                break;
            }
            painter->restore();
        }
        break;
#endif //QT_NO_TABBAR
#ifndef QT_NO_ITEMVIEWS
    case PE_PanelItemViewRow:
        if (const QStyleOptionViewItemV4 *vopt = qstyleoption_cast<const QStyleOptionViewItemV4 *>(option)) {
            QPalette::ColorGroup cg = vopt->state & QStyle::State_Enabled
                                      ? QPalette::Normal : QPalette::Disabled;
            if (cg == QPalette::Normal && !(vopt->state & QStyle::State_Active))
                cg = QPalette::Inactive;

            if ((vopt->state & QStyle::State_Selected) &&  proxy()->styleHint(QStyle::SH_ItemView_ShowDecorationSelected, option, widget))
                 d->drawPanelItemViewSelected(painter, vopt);
            else if (vopt->features & QStyleOptionViewItemV2::Alternate)
                painter->fillRect(vopt->rect, vopt->palette.brush(cg, QPalette::AlternateBase));
            else if (!(vopt->state & QStyle::State_Enabled))
                painter->fillRect(vopt->rect, vopt->palette.brush(cg, QPalette::Base));
        }
        break;
    case PE_PanelItemViewItem:
        if (const QStyleOptionViewItemV4 *vopt = qstyleoption_cast<const QStyleOptionViewItemV4 *>(option)) {
            QPalette::ColorGroup cg = vopt->state & QStyle::State_Enabled
                                      ? QPalette::Normal : QPalette::Disabled;
            if (cg == QPalette::Normal && !(vopt->state & QStyle::State_Active))
                cg = QPalette::Inactive;

            if (vopt->showDecorationSelected && (vopt->state & QStyle::State_Selected)) {
                d->drawPanelItemViewSelected(painter, vopt);
            } else {
                if (vopt->backgroundBrush.style() != Qt::NoBrush) {
                    QPointF oldBO = painter->brushOrigin();
                    painter->setBrushOrigin(vopt->rect.topLeft());
                    painter->fillRect(vopt->rect, vopt->backgroundBrush);
                    painter->setBrushOrigin(oldBO);
                }

                if (vopt->state & QStyle::State_Selected) {
                    QRect textRect = proxy()->subElementRect(QStyle::SE_ItemViewItemText,  option, widget);
                    d->drawPanelItemViewSelected(painter, vopt, textRect);
                }
            }
        }
        break;
#endif //QT_NO_ITEMVIEWS

    case PE_FrameWindow: {
        QPalette popupPal = option->palette;
        popupPal.setColor(QPalette::Light, option->palette.background().color());
        popupPal.setColor(QPalette::Midlight, option->palette.light().color());
        if (d->doubleControls)
            qDrawPlainRect(painter, option->rect, popupPal.shadow().color(),2,0);
        else
            qDrawPlainRect(painter, option->rect, popupPal.shadow().color(),1,0);
        break; }
    case PE_FrameTabBarBase: {
        break; }
    case PE_Widget:
        break;
    case PE_IndicatorMenuCheckMark: {
        int markW = option->rect.width() > 7 ? 7 : option->rect.width();
        int markH = markW;
        if (d->doubleControls)
            markW*=2;
            markH*=2;
        int posX = option->rect.x() + (option->rect.width() - markW)/2 + 1;
        int posY = option->rect.y() + (option->rect.height() - markH)/2;

        QVector<QLineF> a;
        a.reserve(markH);

        int i, xx, yy;
        xx = posX;
        yy = 3 + posY;
        for (i = 0; i < markW/2; ++i) {
            a << QLineF(xx, yy, xx, yy + 2);
            ++xx;
            ++yy;
        }
        yy -= 2;
        for (; i < markH; ++i) {
            a << QLineF(xx, yy, xx, yy + 2);
            ++xx;
            --yy;
        }
        if (!(option->state & State_Enabled) && !(option->state & State_On)) {
            int pnt;
            painter->setPen(option->palette.highlightedText().color());
            QPoint offset(1, 1);
            for (pnt = 0; pnt < a.size(); ++pnt)
                a[pnt].translate(offset.x(), offset.y());
            painter->drawLines(a);
            for (pnt = 0; pnt < a.size(); ++pnt)
                a[pnt].translate(offset.x(), offset.y());
        }
        painter->setPen(option->palette.text().color());
        painter->drawLines(a);
        break; }
    case PE_IndicatorBranch: {
        // Copied from the Windows style.
        static const int decoration_size = d->doubleControls ? 18 : 9;
        static const int ofsA  = d->doubleControls ?  4 : 2;
        static const int ofsB  = d->doubleControls ?  8 : 4;
        static const int ofsC  = d->doubleControls ? 12 : 6;
        static const int ofsD  = d->doubleControls ? 1 : 0;
        int mid_h = option->rect.x() + option->rect.width() / 2;
        int mid_v = option->rect.y() + option->rect.height() / 2;
        int bef_h = mid_h;
        int bef_v = mid_v;
        int aft_h = mid_h;
        int aft_v = mid_v;
        if (option->state & State_Children) {
            int delta = decoration_size / 2;
            bef_h -= delta;
            bef_v -= delta;
            aft_h += delta;
            aft_v += delta;
            QPen oldPen = painter->pen();
            QPen crossPen = oldPen;
            crossPen.setWidth(2);
            painter->setPen(crossPen);
            painter->drawLine(bef_h + ofsA + ofsD, bef_v + ofsB + ofsD, bef_h + ofsC + ofsD, bef_v + ofsB + ofsD);
            if (!(option->state & State_Open))
                painter->drawLine(bef_h + ofsB + ofsD, bef_v + ofsA + ofsD, bef_h + ofsB + ofsD, bef_v + ofsC + ofsD);
            painter->setPen(option->palette.dark().color());
            painter->drawRect(bef_h, bef_v, decoration_size - 1, decoration_size - 1);
            if (d->doubleControls)
                painter->drawRect(bef_h + 1, bef_v + 1, decoration_size - 3, decoration_size - 3);
            painter->setPen(oldPen);
        }
        QBrush brush(option->palette.dark().color(), Qt::Dense4Pattern);
        if (option->state & State_Item) {
            if (option->direction == Qt::RightToLeft)
                painter->fillRect(option->rect.left(), mid_v, bef_h - option->rect.left(), 1, brush);
            else
                painter->fillRect(aft_h, mid_v, option->rect.right() - aft_h + 1, 1, brush);
        }
        if (option->state & State_Sibling)
            painter->fillRect(mid_h, aft_v, 1, option->rect.bottom() - aft_v + 1, brush);
        if (option->state & (State_Open | State_Children | State_Item | State_Sibling))
            painter->fillRect(mid_h, option->rect.y(), 1, bef_v - option->rect.y(), brush);
        break; }
    case PE_Frame:
        qDrawPlainRect(painter, option->rect, option->palette.shadow().color(),
                       d->doubleControls ? 2 : 1, &option->palette.background());
        break;
    case PE_FrameLineEdit:
    case PE_FrameMenu:
        if (d->doubleControls)
            qDrawPlainRect(painter, option->rect, option->palette.shadow().color(),2);
        else
            qDrawPlainRect(painter, option->rect, option->palette.shadow().color(),1);
        break;
    case PE_FrameStatusBar:
        if (d->doubleControls)
            qDrawPlainRect(painter, option->rect, option->palette.shadow().color(),2,0);
        else
            qDrawPlainRect(painter, option->rect, option->palette.shadow().color(),1,0);
        break;

    default:
        QWindowsStyle::drawPrimitive(element, option, painter, widget);
        break;
    }
}

void QWindowsMobileStyle::drawControl(ControlElement element, const QStyleOption *option,
                                      QPainter *painter, const QWidget *widget) const {


   QWindowsMobileStylePrivate *d = const_cast<QWindowsMobileStylePrivate*>(d_func());

   
   painter->setClipping(false);
   switch (element) {
   case CE_MenuBarEmptyArea:
        painter->setClipping(true);
        QWindowsStyle::drawControl(element, option, painter, widget);
        break;
   case CE_PushButtonBevel:
        if (const QStyleOptionButton *button = qstyleoption_cast<const QStyleOptionButton *>(option)) {
            QRect br = button->rect;
            int dbi = proxy()->pixelMetric(PM_ButtonDefaultIndicator, button, widget);

            if (button->features & QStyleOptionButton::AutoDefaultButton)
                br.setCoords(br.left() + dbi, br.top() + dbi, br.right() - dbi, br.bottom() - dbi);
            QStyleOptionButton tmpBtn = *button;
            tmpBtn.rect = br;
            proxy()->drawPrimitive(PE_PanelButtonCommand, &tmpBtn, painter, widget);
            if (button->features & QStyleOptionButton::HasMenu) {
                int mbi = proxy()->pixelMetric(PM_MenuButtonIndicator, button, widget);
                QRect ir = button->rect;
                QStyleOptionButton newButton = *button;
                if (d->doubleControls)
                    newButton.rect = QRect(ir.right() - mbi, ir.height() - 30, mbi, ir.height() - 4);
                else
                    newButton.rect = QRect(ir.right() - mbi, ir.height() - 20, mbi, ir.height() - 4);
                proxy()->drawPrimitive(PE_IndicatorArrowDown, &newButton, painter, widget);
            }
            if (button->features & QStyleOptionButton::DefaultButton)
                proxy()->drawPrimitive(PE_FrameDefaultButton, option, painter, widget);
        }
        break;
   case CE_RadioButton:
   case CE_CheckBox:
       if (const QStyleOptionButton *button = qstyleoption_cast<const QStyleOptionButton *>(option)) {
           bool isRadio = (element == CE_RadioButton);
           QStyleOptionButton subopt = *button;
           subopt.rect = proxy()->subElementRect(isRadio ? SE_RadioButtonIndicator
               : SE_CheckBoxIndicator, button, widget);
           proxy()->drawPrimitive(isRadio ? PE_IndicatorRadioButton : PE_IndicatorCheckBox,
               &subopt, painter, widget);
           subopt.rect = proxy()->subElementRect(isRadio ? SE_RadioButtonContents
               : SE_CheckBoxContents, button, widget);
           proxy()->drawControl(isRadio ? CE_RadioButtonLabel : CE_CheckBoxLabel, &subopt, painter, widget);
           if (button->state & State_HasFocus) {
               QStyleOptionFocusRect fropt;
               fropt.QStyleOption::operator=(*button);
               fropt.rect = proxy()->subElementRect(isRadio ? SE_RadioButtonFocusRect
                   : SE_CheckBoxFocusRect, button, widget);
               proxy()->drawPrimitive(PE_FrameFocusRect, &fropt, painter, widget);
           }
       }
       break;
   case CE_RadioButtonLabel:
   case CE_CheckBoxLabel:
       if (const QStyleOptionButton *button = qstyleoption_cast<const QStyleOptionButton *>(option)) {
           uint alignment = visualAlignment(button->direction, Qt::AlignLeft | Qt::AlignVCenter);
           if (!styleHint(SH_UnderlineShortcut, button, widget))
               alignment |= Qt::TextHideMnemonic;
           QPixmap pix;
           QRect textRect = button->rect;
           if (!button->icon.isNull()) {
               pix = button->icon.pixmap(button->iconSize, button->state & State_Enabled ? QIcon::Normal : QIcon::Disabled);
               proxy()->drawItemPixmap(painter, button->rect, alignment, pix);
               if (button->direction == Qt::RightToLeft)
                   textRect.setRight(textRect.right() - button->iconSize.width() - 4);
               else
                   textRect.setLeft(textRect.left() + button->iconSize.width() + 4);
           }
           if (!button->text.isEmpty()){
               if (button->state & State_Enabled)
                   proxy()->drawItemText(painter, textRect, alignment | Qt::TextShowMnemonic,
                   button->palette, false, button->text, QPalette::WindowText);
               else
                   proxy()->drawItemText(painter, textRect, alignment | Qt::TextShowMnemonic,
                   button->palette, false, button->text, QPalette::Mid);
           }
       }
       break;
#ifndef QT_NO_PROGRESSBAR
    case CE_ProgressBarGroove:
        if (d->doubleControls)
            qDrawPlainRect(painter, option->rect, option->palette.shadow().color(), 2, &option->palette.brush(QPalette::Window));
        else
            qDrawPlainRect(painter, option->rect, option->palette.shadow().color(), 1, &option->palette.brush(QPalette::Window));
        break;
#endif //QT_NO_PROGRESSBAR
#ifndef QT_NO_TABBAR
    case CE_TabBarTab:
        if (const QStyleOptionTab *tab = qstyleoption_cast<const QStyleOptionTab *>(option)) {
            proxy()->drawControl(CE_TabBarTabShape, tab, painter, widget);
            proxy()->drawControl(CE_TabBarTabLabel, tab, painter, widget);
        }
        break;
    case CE_TabBarTabShape:
        if (const QStyleOptionTab *tab = qstyleoption_cast<const QStyleOptionTab *>(option)) {
            
            if (tab->shape == QTabBar::RoundedNorth || tab->shape == QTabBar::RoundedEast ||
                tab->shape == QTabBar::RoundedSouth || tab->shape == QTabBar::RoundedWest) {
                    d->drawTabBarTab(painter, tab);
            } else {
                QCommonStyle::drawControl(element, option, painter, widget);
            }
            break; }

#endif // QT_NO_TABBAR

#ifndef QT_NO_TOOLBAR
    case CE_ToolBar:
        if (const QStyleOptionToolBar *toolBar = qstyleoption_cast<const QStyleOptionToolBar *>(option)) {
        QRect rect = option->rect;
        painter->save();
        painter->setPen(option->palette.dark().color());
        painter->fillRect(rect,option->palette.button());
        if (d->doubleControls) {
            QPen pen = painter->pen();
            pen.setWidth(4);
            painter->setPen(pen);
        }
        if (toolBar->toolBarArea == Qt::TopToolBarArea)
            painter->drawLine(rect.bottomLeft(), rect.bottomRight());
        else
            painter->drawLine(rect.topLeft(), rect.topRight());
        painter->restore();
        break; }
#endif //QT_NO_TOOLBAR
    case CE_Header:
        if (const QStyleOptionHeader *header = qstyleoption_cast<const QStyleOptionHeader *>(option)) {
            QRegion clipRegion = painter->clipRegion();
            painter->setClipRect(option->rect);
            proxy()->drawControl(CE_HeaderSection, header, painter, widget);
            QStyleOptionHeader subopt = *header;
            subopt.rect = proxy()->subElementRect(SE_HeaderLabel, header, widget);
            if (header->state & State_Sunken) 
                subopt.palette.setColor(QPalette::ButtonText, header->palette.brightText().color());
            subopt.state |= QStyle::State_On;
            if (subopt.rect.isValid())
                proxy()->drawControl(CE_HeaderLabel, &subopt, painter, widget);
            if (header->sortIndicator != QStyleOptionHeader::None) {
                subopt.rect = proxy()->subElementRect(SE_HeaderArrow, option, widget);
                proxy()->drawPrimitive(PE_IndicatorHeaderArrow, &subopt, painter, widget);
            }
            painter->setClipRegion(clipRegion);
        }
        break;

    case CE_HeaderSection:
        if (const QStyleOptionHeader *header = qstyleoption_cast<const QStyleOptionHeader *>(option)) {
            QBrush fill;
            QColor color;
            QRect rect = option->rect;
            painter->setPen(option->palette.shadow().color());

            int penSize = 1;

            if (d->doubleControls) {
                penSize = 2;
                QPen pen = painter->pen();
                pen.setWidth(2);
                pen.setCapStyle(Qt::FlatCap);
                painter->setPen(pen);
            }

            //fix Frame

            if (header->position == QStyleOptionHeader::End
                || (header->position == QStyleOptionHeader::OnlyOneSection
                && !header->text.isEmpty()))
                if (Qt::Horizontal == header->orientation )
                  rect.adjust(0, 0, penSize, 0);
                else
                  rect.adjust(0, 0, 0, penSize);

            if (option->state & State_Sunken) {
                fill = option->palette.brush(QPalette::Shadow);
                color = option->palette.light().color();
                painter->drawLine(rect.bottomLeft(), rect.bottomRight());
                painter->drawLine(rect.topRight(), rect.bottomRight());
                rect.adjust(0, 0, -penSize, -penSize);
            }
            else {
                fill = option->palette.brush(QPalette::Button);
                color = option->palette.shadow().color();
                if (Qt::Horizontal == header->orientation )
                    rect.adjust(-penSize, 0, 0, 0);
                else
                  rect.adjust(0, -penSize, 0, 0);
            }
            if (Qt::Horizontal == header->orientation )
                    rect.adjust(0,-penSize,0,0);
                else
                  rect.adjust(-penSize, 0, 0, 0);

            if (option->state & State_Sunken) {
                qDrawPlainRect(painter, rect, color, penSize, &fill);
            } else {
                //Corner
                rect.adjust(-penSize, 0, 0, 0);
                qDrawPlainRect(painter, rect, color, penSize, &fill);
            }

            //Hack to get rid of some double lines... StyleOptions need a clean flag for that
             rect = option->rect;
#ifndef QT_NO_SCROLLAREA
             if (const QAbstractScrollArea *abstractScrollArea = qobject_cast<const QAbstractScrollArea *> (widget) ) {
                 QRect rectScrollArea = abstractScrollArea->geometry();
                 if (Qt::Horizontal == header->orientation )
                     if ((rectScrollArea.right() - rect.right() ) > 1)
                         painter->drawLine(rect.topRight(), rect.bottomRight());
                     else ;
                 else
                     if ((rectScrollArea.bottom() - rect.bottom() ) > 1)
                         painter->drawLine(rect.bottomLeft(), rect.bottomRight());
             }
#endif // QT_NO_SCROLLAREA
            break;
        }
#ifndef QT_NO_COMBOBOX
    case CE_ComboBoxLabel:
        // This is copied from qcommonstyle.cpp with the difference, that
        // the editRect isn't adjusted when calling drawItemText.
        if (const QStyleOptionComboBox *cb = qstyleoption_cast<const QStyleOptionComboBox *>(option)) {
            QRect editRect = proxy()->subControlRect(CC_ComboBox, cb, SC_ComboBoxEditField, widget);
            painter->save();
            painter->setClipRect(editRect);
            if (!cb->currentIcon.isNull()) {
                QIcon::Mode mode = cb->state & State_Enabled ? QIcon::Normal
                                                             : QIcon::Disabled;
                QPixmap pixmap = cb->currentIcon.pixmap(cb->iconSize, mode);
                QRect iconRect(editRect);
                iconRect.setWidth(cb->iconSize.width() + 4);
                iconRect = alignedRect(cb->direction,
                                       Qt::AlignLeft | Qt::AlignVCenter,
                                       iconRect.size(), editRect);
                if (cb->editable)
                    painter->fillRect(iconRect, option->palette.brush(QPalette::Base));
                proxy()->drawItemPixmap(painter, iconRect, Qt::AlignCenter, pixmap);

                if (cb->direction == Qt::RightToLeft)
                    editRect.translate(-4 - cb->iconSize.width(), 0);
                else
                    editRect.translate(cb->iconSize.width() + 4, 0);
            }
            if (!cb->currentText.isEmpty() && !cb->editable) {
                proxy()->drawItemText(painter, editRect,
                             visualAlignment(cb->direction, Qt::AlignLeft | Qt::AlignVCenter),
                             cb->palette, cb->state & State_Enabled, cb->currentText);
            }
            painter->restore();
        }
        break;
#endif // QT_NO_COMBOBOX
#ifndef QT_NO_DOCKWIDGET
    case CE_DockWidgetTitle:
        if (const QStyleOptionDockWidget *dwOpt = qstyleoption_cast<const QStyleOptionDockWidget *>(option)) {
            const QStyleOptionDockWidgetV2 *v2
                = qstyleoption_cast<const QStyleOptionDockWidgetV2*>(option);
            bool verticalTitleBar = v2 == 0 ? false : v2->verticalTitleBar;

            QRect rect = dwOpt->rect;
            QRect r = rect;

            if (verticalTitleBar) {
                QSize s = r.size();
                s.transpose();
                r.setSize(s);

                painter->save();
                painter->translate(r.left(), r.top() + r.width());
                painter->rotate(-90);
                painter->translate(-r.left(), -r.top());
            }

            bool floating = false;
            bool active = dwOpt->state & State_Active;
            int menuOffset = 0; //used to center text when floated
            QColor inactiveCaptionTextColor = option->palette.highlightedText().color();
            if (dwOpt->movable) {
                QColor left, right;

                //Titlebar gradient
                if (widget && widget->isWindow()) {
                    floating = true;
                    if (active) {
                        right = option->palette.highlight().color();
                        left = right.lighter(125);
                    } else {
                        left  = option->palette.highlight().color().lighter(125);
                        right = QColor(0xff, 0xff, 0xff);
                    }
                    menuOffset = 2;
                    QBrush fillBrush(left);
                    if (left != right) {
                        QPoint p1(r.x(), r.top() + r.height()/2);
                        QPoint p2(rect.right(), r.top() + r.height()/2);
                        QLinearGradient lg(p1, p2);
                        lg.setColorAt(0, left);
                        lg.setColorAt(1, right);
                        fillBrush = lg;
                    }
                    painter->fillRect(r.adjusted(0, 0, 0, -3), fillBrush);
                } else {
                    painter->fillRect(r.adjusted(0, 0, 0, -3), option->palette.button().color());
                }
                painter->setPen(dwOpt->palette.color(QPalette::Light));
                if (!widget || !widget->isWindow()) {
                    painter->drawLine(r.topLeft(), r.topRight());
                    painter->setPen(dwOpt->palette.color(QPalette::Dark));
                    painter->drawLine(r.bottomLeft(), r.bottomRight());            }
            }
            if (!dwOpt->title.isEmpty()) {
                QFont oldFont = painter->font();
                QFont newFont = oldFont;
                if (newFont.pointSize() > 2)
                    newFont.setPointSize(newFont.pointSize() - 2);
                if (floating)
                    newFont.setBold(true);
                painter->setFont(newFont);
                QPalette palette = dwOpt->palette;
                palette.setColor(QPalette::Window, inactiveCaptionTextColor);
                QRect titleRect = proxy()->subElementRect(SE_DockWidgetTitleBarText, option, widget);
                if (verticalTitleBar) {
                    titleRect = QRect(r.left() + rect.bottom()
                                        - titleRect.bottom(),
                                    r.top() + titleRect.left() - rect.left(),
                                    titleRect.height(), titleRect.width());
                }
                proxy()->drawItemText(painter, titleRect,
                            Qt::AlignLeft | Qt::AlignVCenter | Qt::TextShowMnemonic, palette,
                            dwOpt->state & State_Enabled, dwOpt->title,
                            floating ? (active ? QPalette::BrightText : QPalette::Window) : QPalette::WindowText);
                painter->setFont(oldFont);
            }
            if (verticalTitleBar)
                painter->restore();
        }
        return;
#endif // QT_NO_DOCKWIDGET

    case CE_PushButtonLabel:
        if (const QStyleOptionButton *button = qstyleoption_cast<const QStyleOptionButton *>(option)) {
            painter->save();
            QRect ir = button->rect;
            QPalette::ColorRole colorRole;
            uint tf = Qt::AlignVCenter | Qt::TextShowMnemonic;
            if (!styleHint(SH_UnderlineShortcut, button, widget))
                tf |= Qt::TextHideMnemonic;

            if (button->state & (State_On | State_Sunken))
                colorRole = QPalette::Light;
            else
                colorRole = QPalette::ButtonText;

            if (!button->icon.isNull()) {
                QIcon::Mode mode = button->state & State_Enabled ? QIcon::Normal
                    : QIcon::Disabled;
                if (mode == QIcon::Normal && button->state & State_HasFocus)
                    mode = QIcon::Active;
                QIcon::State state = QIcon::Off;
                if (button->state & State_On)
                    state = QIcon::On;
                QPixmap pixmap = button->icon.pixmap(button->iconSize, mode, state);
                int pixw = pixmap.width();
                int pixh = pixmap.height();
                //Center the icon if there is no text

                QPoint point;
                if (button->text.isEmpty()) {
                    point = QPoint(ir.x() + ir.width() / 2 - pixw / 2,
                        ir.y() + ir.height() / 2 - pixh / 2);
                } else {
                    point = QPoint(ir.x() + 2, ir.y() + ir.height() / 2 - pixh / 2);
                }
                if (button->direction == Qt::RightToLeft)
                    point.rx() += pixw;

                if ((button->state & (State_On | State_Sunken)) && button->direction == Qt::RightToLeft)
                    point.rx() -= proxy()->pixelMetric(PM_ButtonShiftHorizontal, option, widget) * 2;

                painter->drawPixmap(visualPos(button->direction, button->rect, point), pixmap);

                if (button->direction == Qt::RightToLeft)
                    ir.translate(-4, 0);
                else
                    ir.translate(pixw + 4, 0);
                ir.setWidth(ir.width() - (pixw + 4));
                // left-align text if there is
                if (!button->text.isEmpty())
                    tf |= Qt::AlignLeft;
            } else {
                tf |= Qt::AlignHCenter;
            }
            if (button->state & State_Enabled)
                proxy()->drawItemText(painter, ir, tf, button->palette, true, button->text, colorRole);
            else
            proxy()->drawItemText(painter, ir, tf, button->palette, true, button->text, QPalette::Mid);
            painter->restore();
        }
        break;
        default:
            QWindowsStyle::drawControl(element, option, painter, widget);
            break;
    }
}

void QWindowsMobileStyle::drawComplexControl(ComplexControl control, const QStyleOptionComplex *option,
                                             QPainter *painter, const QWidget *widget) const {

    painter->setClipping(false);
    QWindowsMobileStylePrivate *d = const_cast<QWindowsMobileStylePrivate*>(d_func());

    switch (control) {
#ifndef QT_NO_SLIDER
    case CC_Slider:
        if (const QStyleOptionSlider *slider = qstyleoption_cast<const QStyleOptionSlider *>(option)) {
            int thickness  = proxy()->pixelMetric(PM_SliderControlThickness, slider, widget);
            int len        = proxy()->pixelMetric(PM_SliderLength, slider, widget);
            int ticks = slider->tickPosition;
            QRect groove = proxy()->subControlRect(CC_Slider, slider, SC_SliderGroove, widget);
            QRect handle = proxy()->subControlRect(CC_Slider, slider, SC_SliderHandle, widget);

            if ((slider->subControls & SC_SliderGroove) && groove.isValid()) {
                int mid = thickness / 2;
                if (ticks & QSlider::TicksAbove)
                    mid += len / 8;
                if (ticks & QSlider::TicksBelow)
                    mid -= len / 8;

                painter->setPen(slider->palette.shadow().color());
                if (slider->orientation == Qt::Horizontal) {
                    qDrawPlainRect(painter, groove.x(), groove.y() + mid - 2,
                        groove.width(), 4, option->palette.shadow().color(),1,0);
                } else {
                    qDrawPlainRect(painter, groove.x()+mid-2, groove.y(),
                        4, groove.height(), option->palette.shadow().color(),1,0);
                }
            }
            if (slider->subControls & SC_SliderTickmarks) {
                QStyleOptionSlider tmpSlider = *slider;
                tmpSlider.subControls = SC_SliderTickmarks;
                QCommonStyle::drawComplexControl(control, &tmpSlider, painter, widget);
            }

            if (slider->subControls & SC_SliderHandle) {
                const QColor c0 = slider->palette.shadow().color();
                const QColor c1 = slider->palette.dark().color();
                const QColor c3 = slider->palette.midlight().color();
                const QColor c4 = slider->palette.dark().color();
                QBrush handleBrush;

                if (slider->state & State_Enabled) {
                    handleBrush = slider->palette.color(QPalette::Light);
                } else {
                    handleBrush = QBrush(slider->palette.color(QPalette::Shadow),
                        Qt::Dense4Pattern);
                }
                int x = handle.x(), y = handle.y(),
                    wi = handle.width(), he = handle.height();
                int x1 = x;
                int x2 = x+wi-1;
                int y1 = y;
                int y2 = y+he-1;

                Qt::Orientation orient = slider->orientation;
                bool tickAbove = slider->tickPosition == QSlider::TicksAbove;
                bool tickBelow = slider->tickPosition == QSlider::TicksBelow;

                if (slider->state & State_HasFocus) {
                    QStyleOptionFocusRect fropt;
                    fropt.QStyleOption::operator=(*slider);
                    fropt.rect = proxy()->subElementRect(SE_SliderFocusRect, slider, widget);
                    proxy()->drawPrimitive(PE_FrameFocusRect, &fropt, painter, widget);
                }
                if ((tickAbove && tickBelow) || (!tickAbove && !tickBelow)) {
                    Qt::BGMode oldMode = painter->backgroundMode();
                    painter->setBackgroundMode(Qt::OpaqueMode);
                    qDrawPlainRect(painter, QRect(x, y, wi, he)
                        ,slider->palette.shadow().color(),1,&handleBrush);
                    painter->setBackgroundMode(oldMode);
                    QBrush fill = QBrush(option->palette.light().color(), Qt::Dense4Pattern);
                    if (slider->state & State_Sunken)
                        painter->fillRect(QRectF(x1 + 2, y1 + 2, x2 - x1 - 3, y2 - y1 - 3),fill);
                    return;
                }
                QSliderDirection dir;
                if (orient == Qt::Horizontal)
                    if (tickAbove)
                        dir = SliderUp;
                    else
                        dir = SliderDown;
                else
                    if (tickAbove)
                        dir = SliderLeft;
                    else
                        dir = SliderRight;
                QPolygon polygon;
                int d = 0;
                switch (dir) {
                  case SliderUp:
                      x2++;
                      y1 = y1 + wi / 2;
                      d =  (wi + 1) / 2 - 1;
                      polygon.setPoints(5, x1, y1, x1, y2, x2, y2, x2, y1, x1 + d,y1 - d);
                      break;
                  case SliderDown:
                      x2++;
                      y2 = y2 - wi/2;
                      d =  (wi + 1) / 2 - 1;
                      polygon.setPoints(5, x1, y1, x1, y2, x1 + d,y2 + d, x2, y2, x2, y1);
                  break;
                      case SliderLeft:
                      d =  (he + 1) / 2 - 1;
                      x1 = x1 + he/2;
                      polygon.setPoints(5, x1, y1, x1 - d, y1 + d, x1,y2, x2, y2, x2, y1);
                      y1--;
                      break;
                  case SliderRight:
                      d =  (he + 1) / 2 - 1;
                      x2 = x2 - he/2;
                      polygon.setPoints(5, x1, y1, x1, y2, x2,y2, x2 + d, y1 + d, x2, y1);
                      y1--;
                      break;
                }
                QBrush oldBrush = painter->brush();
                painter->setPen(Qt::NoPen);
                painter->setBrush(handleBrush);
                Qt::BGMode oldMode = painter->backgroundMode();
                painter->setBackgroundMode(Qt::OpaqueMode);
                painter->drawRect(x1, y1, x2-x1+1, y2-y1+1);
                painter->drawPolygon(polygon);
                QBrush fill = QBrush(option->palette.button().color(), Qt::Dense4Pattern);
                painter->setBrush(oldBrush);
                painter->setBackgroundMode(oldMode);
                if (slider->state & State_Sunken)
                    painter->fillRect(QRectF(x1, y1, x2 - x1 + 1, y2 - y1 + 1),fill);

                if (dir != SliderUp) {
                    painter->setPen(c0);
                    painter->drawLine(x1, y1, x2, y1);
                }
                if (dir != SliderLeft) {
                    painter->setPen(c0);
                    painter->drawLine(x1, y1, x1, y2);
                }
                if (dir != SliderRight) {
                    painter->setPen(c0);
                    painter->drawLine(x2, y1, x2, y2);
                }
                if (dir != SliderDown) {
                    painter->setPen(c0);
                    painter->drawLine(x1, y2, x2, y2);
                }
                switch (dir) {
                  case SliderUp:
                      if (slider->state & State_Sunken)
                          painter->fillRect(QRectF(x1 + 3, y1 - d + 2, x2 - x1 - 4, y1),fill);
                      painter->setPen(c0);
                      painter->drawLine(x1, y1, x1 + d, y1 - d);
                      d = wi - d - 1;
                      painter->drawLine(x2, y1, x2 -d , y1 -d );
                      d--;
                      break;
                  case SliderDown:
                      if (slider->state & State_Sunken)
                      painter->fillRect(QRectF(x1+3, y2 - d, x2 - x1  -4,y2 - 8),fill);
                      painter->setPen(c0);
                      painter->drawLine(x1, y2, x1 + d, y2 + d);
                      d = wi - d - 1;
                      painter->drawLine(x2, y2, x2 - d, y2 + d);
                      d--;
                      break;
                  case SliderLeft:
                      if (slider->state & State_Sunken)
                          painter->fillRect(QRectF(x1 - d + 2, y1 + 2, x1, y2 - y1 - 3),fill);
                      painter->setPen(c0);
                      painter->drawLine(x1, y1, x1 - d, y1 + d);
                      d = he - d - 1;
                      painter->drawLine(x1, y2, x1 - d, y2 - d);
                      d--;
                      break;
                  case SliderRight:
                      if (slider->state & State_Sunken)
                          painter->fillRect(QRectF(x2 - d - 4, y1 + 2, x2 - 4, y2 - y1 - 3),fill);
                      painter->setPen(c0);
                      painter->drawLine(x2, y1, x2 + d, y1 + d);
                      painter->setPen(c0);
                      d = he - d - 1;
                      painter->drawLine(x2, y2, x2 + d, y2 - d);
                      d--;
                      break;
                }
            }
        }
        break;
#endif //QT_NO_SLIDER
#ifndef QT_NO_SCROLLBAR
    case CC_ScrollBar:
        painter->save();
        painter->setPen(option->palette.shadow().color());
        if (d->doubleControls) {
            QPen pen = painter->pen();
            pen.setWidth(2);
            pen.setCapStyle(Qt::SquareCap);
            painter->setPen(pen);
        }
        if (const QStyleOptionSlider *scrollbar = qstyleoption_cast<const QStyleOptionSlider *>(option)) {
            d->drawScrollbarGroove(painter, scrollbar);
            // Make a copy here and reset it for each primitive.
            QStyleOptionSlider newScrollbar = *scrollbar;
            State saveFlags = scrollbar->state;
            //Check if the scrollbar is part of an abstractItemView and draw the frame according
            bool drawCompleteFrame = true;
            bool secondScrollBar = false;
            if (widget)
                if (QWidget *parent = widget->parentWidget()) {
                    if (QAbstractScrollArea *abstractScrollArea = qobject_cast<QAbstractScrollArea *>(parent->parentWidget())) {
                        drawCompleteFrame = (abstractScrollArea->frameStyle() == QFrame::NoFrame) ||  (abstractScrollArea->frameStyle() == QFrame::StyledPanel);
                        secondScrollBar = (abstractScrollArea->horizontalScrollBar()->isVisible()
                            && abstractScrollArea->verticalScrollBar()->isVisible()) ;
                    }
#ifndef QT_NO_LISTVIEW
                    if (QListView *listView = qobject_cast<QListView *>(parent->parentWidget()))
                            drawCompleteFrame = false;
#endif
                }
                if (scrollbar->minimum == scrollbar->maximum)
                    saveFlags |= State_Enabled;
                if (scrollbar->subControls & SC_ScrollBarSubLine) {
                    newScrollbar.state = saveFlags;
                    newScrollbar.rect = proxy()->subControlRect(control, &newScrollbar, SC_ScrollBarSubLine, widget);
                    if (newScrollbar.rect.isValid()) {
                        if (!(scrollbar->activeSubControls & SC_ScrollBarSubLine))
                            newScrollbar.state &= ~(State_Sunken | State_MouseOver);
                        d->drawScrollbarHandleUp(painter, &newScrollbar, drawCompleteFrame, secondScrollBar);
                    }
                }
                if (scrollbar->subControls & SC_ScrollBarAddLine) {
                    newScrollbar.rect = scrollbar->rect;
                    newScrollbar.state = saveFlags;
                    newScrollbar.rect = proxy()->subControlRect(control, &newScrollbar, SC_ScrollBarAddLine, widget);
                    if (newScrollbar.rect.isValid()) {
                        if (!(scrollbar->activeSubControls & SC_ScrollBarAddLine))
                            newScrollbar.state &= ~(State_Sunken | State_MouseOver);
                        d->drawScrollbarHandleDown(painter, &newScrollbar, drawCompleteFrame, secondScrollBar);
                    }
                }
                if (scrollbar->subControls & SC_ScrollBarSlider) {

                      newScrollbar.rect = scrollbar->rect;
                      newScrollbar.state = saveFlags;
                      newScrollbar.rect = proxy()->subControlRect(control, &newScrollbar, SC_ScrollBarSlider, widget);

                      if (newScrollbar.rect.isValid()) {
                          if (!(scrollbar->activeSubControls & SC_ScrollBarSlider))
                              newScrollbar.state &= ~(State_Sunken | State_MouseOver);
                          d->drawScrollbarGrip(painter, &newScrollbar, option, drawCompleteFrame);
                      }
                }
        }
        painter->restore();
        break;
#endif // QT_NO_SCROLLBAR
    case CC_ToolButton:
        if (const QStyleOptionToolButton *toolbutton
                = qstyleoption_cast<const QStyleOptionToolButton *>(option)) {
            QRect button, menuarea;
            bool isTabWidget = false;
#ifndef QT_NO_TABWIDGET
            if (widget)
                if (QWidget *parent = widget->parentWidget())
                    isTabWidget = (qobject_cast<QTabWidget *>(parent->parentWidget()));
#endif //QT_NO_TABWIDGET

            button = proxy()->subControlRect(control, toolbutton, SC_ToolButton, widget);
            menuarea = proxy()->subControlRect(control, toolbutton, SC_ToolButtonMenu, widget);
            State buttonFlags = toolbutton->state;
            if (buttonFlags & State_AutoRaise) {
                if (!(buttonFlags & State_MouseOver)) {
                    buttonFlags &= ~State_Raised;
                }
            }
            State menuFlags = buttonFlags;
            if (toolbutton->activeSubControls & SC_ToolButton)
                buttonFlags |= State_Sunken;
            if (toolbutton->activeSubControls & SC_ToolButtonMenu)
                menuFlags |= State_On;
            QStyleOption tool(0);
            tool.palette = toolbutton->palette;
            if (toolbutton->subControls & SC_ToolButton) {
                    tool.rect = button;
                    tool.state = buttonFlags;
                    proxy()->drawPrimitive(PE_PanelButtonTool, &tool, painter, widget);
            }
            if (toolbutton->subControls & SC_ToolButtonMenu) {
                tool.rect = menuarea;
                tool.state = buttonFlags & State_Enabled;
                QStyleOption toolMenu(0);
                toolMenu = *toolbutton;
                toolMenu.state = menuFlags;
                if (buttonFlags & State_Sunken)
                  proxy()->drawPrimitive(PE_PanelButtonTool, &toolMenu, painter, widget);
                QStyleOption arrowOpt(0);
                arrowOpt.rect = tool.rect;
                arrowOpt.palette = tool.palette;
                State flags = State_None;
                if (menuFlags & State_Enabled)
                    flags |= State_Enabled;
                if ((menuFlags & State_On) && !(buttonFlags & State_Sunken)) {
                    flags |= State_Sunken;
                    painter->fillRect(menuarea, option->palette.shadow());
                }
                arrowOpt.state = flags;
                proxy()->drawPrimitive(PE_IndicatorArrowDown, &arrowOpt, painter, widget);
            }
            if (toolbutton->state & State_HasFocus) {
                QStyleOptionFocusRect focusRect;
                focusRect.QStyleOption::operator=(*toolbutton);
                focusRect.rect.adjust(3, 3, -3, -3);
                if (toolbutton->features & QStyleOptionToolButton::Menu)
                    focusRect.rect.adjust(0, 0, -proxy()->pixelMetric(QStyle::PM_MenuButtonIndicator,
                                                         toolbutton, widget), 0);
                proxy()->drawPrimitive(PE_FrameFocusRect, &focusRect, painter, widget);
            }
            QStyleOptionToolButton label = *toolbutton;
            if (isTabWidget)
                label.state = toolbutton->state;
            else
              label.state = toolbutton->state & State_Enabled;
            int fw = proxy()->pixelMetric(PM_DefaultFrameWidth, option, widget);
            label.rect = button.adjusted(fw, fw, -fw, -fw);
            proxy()->drawControl(CE_ToolButtonLabel, &label, painter, widget);
        }
        break;

#ifndef QT_NO_GROUPBOX
    case CC_GroupBox:
        if (const QStyleOptionGroupBox *groupBox = qstyleoption_cast<const QStyleOptionGroupBox *>(option)) {
            // Draw frame
            painter->save();
            QFont font = painter->font();
            font.setBold(true);
            painter->setFont(font);
            QStyleOptionGroupBox groupBoxFont = *groupBox;
            groupBoxFont.fontMetrics = QFontMetrics(font);
            QRect textRect = proxy()->subControlRect(CC_GroupBox, &groupBoxFont, SC_GroupBoxLabel, widget);
            QRect checkBoxRect = proxy()->subControlRect(CC_GroupBox, option, SC_GroupBoxCheckBox, widget).adjusted(0,0,0,0);
            if (groupBox->subControls & QStyle::SC_GroupBoxFrame) {
                QStyleOptionFrameV2 frame;
                frame.QStyleOption::operator=(*groupBox);
                frame.features = groupBox->features;
                frame.lineWidth = groupBox->lineWidth;
                frame.midLineWidth = groupBox->midLineWidth;
                frame.rect = proxy()->subControlRect(CC_GroupBox, option, SC_GroupBoxFrame, widget);
                painter->save();
                QRegion region(groupBox->rect);
                if (!groupBox->text.isEmpty()) {
                    bool ltr = groupBox->direction == Qt::LeftToRight;
                    QRect finalRect = checkBoxRect.united(textRect);
                    if (groupBox->subControls & QStyle::SC_GroupBoxCheckBox)
                        finalRect.adjust(ltr ? -4 : 0, 0, ltr ? 0 : 4, 0);
                    region -= finalRect;
                }
                proxy()->drawPrimitive(PE_FrameGroupBox, &frame, painter, widget);
                painter->restore();
            }
             // Draw checkbox
            if (groupBox->subControls & SC_GroupBoxCheckBox) {
                QStyleOptionButton box;
                box.QStyleOption::operator=(*groupBox);
                box.rect = checkBoxRect;
                proxy()->drawPrimitive(PE_IndicatorCheckBox, &box, painter, widget);
            }
            // Draw title
            if ((groupBox->subControls & QStyle::SC_GroupBoxLabel) && !groupBox->text.isEmpty()) {
                QColor textColor = groupBox->textColor;
                if (textColor.isValid())
                    painter->setPen(textColor);
                else
                    painter->setPen(groupBox->palette.link().color());
                painter->setPen(groupBox->palette.link().color());

                int alignment = int(groupBox->textAlignment);
                if (!styleHint(QStyle::SH_UnderlineShortcut, option, widget))
                    alignment |= Qt::TextHideMnemonic;

                if (groupBox->state & State_Enabled)
                    proxy()->drawItemText(painter, textRect,  Qt::TextShowMnemonic | Qt::AlignHCenter | alignment,
                    groupBox->palette, true, groupBox->text,
                    textColor.isValid() ? QPalette::NoRole : QPalette::Link);
                else
                    proxy()->drawItemText(painter, textRect,  Qt::TextShowMnemonic | Qt::AlignHCenter | alignment,
                    groupBox->palette, true, groupBox->text, QPalette::Mid);
                if (groupBox->state & State_HasFocus) {
                    QStyleOptionFocusRect fropt;
                    fropt.QStyleOption::operator=(*groupBox);
                    fropt.rect = textRect;
                    proxy()->drawPrimitive(PE_FrameFocusRect, &fropt, painter, widget);
                }
            }
            painter->restore();
        }
        break;
#endif //QT_NO_GROUPBOX

#ifndef QT_NO_COMBOBOX
    case CC_ComboBox:
        if (const QStyleOptionComboBox *cmb = qstyleoption_cast<const QStyleOptionComboBox *>(option)) {
            QBrush editBrush = cmb->palette.brush(QPalette::Base);
            if ((cmb->subControls & SC_ComboBoxFrame) && cmb->frame)
                qDrawPlainRect(painter, option->rect, option->palette.shadow().color(), proxy()->pixelMetric(PM_ComboBoxFrameWidth, option, widget), &editBrush);
            else
                painter->fillRect(option->rect, editBrush);
            State flags = State_None;
            QRect ar = proxy()->subControlRect(CC_ComboBox, cmb, SC_ComboBoxArrow, widget);
            if ((option->state & State_On)) {
                painter->fillRect(ar.adjusted(0, 0, 1, 1),cmb->palette.brush(QPalette::Shadow));
            }
            if (d->doubleControls)
                ar.adjust(5, 0, 5, 0);
            else
                ar.adjust(2, 0, -2, 0);
            if (option->state & State_Enabled)
                flags |= State_Enabled;
            if (option->state & State_On)
                flags |= State_Sunken;
            QStyleOption arrowOpt(0);
            arrowOpt.rect = ar;
            arrowOpt.palette = cmb->palette;
            arrowOpt.state = flags;
            proxy()->drawPrimitive(PrimitiveElement(PE_IndicatorArrowDownBig), &arrowOpt, painter, widget);
            if (cmb->subControls & SC_ComboBoxEditField) {
                QRect re = proxy()->subControlRect(CC_ComboBox, cmb, SC_ComboBoxEditField, widget);
                if (cmb->state & State_HasFocus && !cmb->editable)
                    painter->fillRect(re.x(), re.y(), re.width(), re.height(),
                 cmb->palette.brush(QPalette::Highlight));
                 if (cmb->state & State_HasFocus) {
                    painter->setPen(cmb->palette.highlightedText().color());
                    painter->setBackground(cmb->palette.highlight());
                 } else {
                    painter->setPen(cmb->palette.text().color());
                    painter->setBackground(cmb->palette.background());
                 }
                 if (cmb->state & State_HasFocus && !cmb->editable) {
                    QStyleOptionFocusRect focus;
                    focus.QStyleOption::operator=(*cmb);
                    focus.rect = proxy()->subElementRect(SE_ComboBoxFocusRect, cmb, widget);
                    focus.state |= State_FocusAtBorder;
                    focus.backgroundColor = cmb->palette.highlight().color();
                    if ((option->state & State_On))
                      proxy()->drawPrimitive(PE_FrameFocusRect, &focus, painter, widget);
               }
            }
        }
        break;
#endif // QT_NO_COMBOBOX


#ifndef QT_NO_SPINBOX
    case CC_SpinBox:
        if (const QStyleOptionSpinBox *spinBox = qstyleoption_cast<const QStyleOptionSpinBox *>(option)) {
            QStyleOptionSpinBox copy = *spinBox;
            //PrimitiveElement primitiveElement;
            int primitiveElement;

            if (spinBox->frame && (spinBox->subControls & SC_SpinBoxFrame)) {
                QRect r = proxy()->subControlRect(CC_SpinBox, spinBox, SC_SpinBoxFrame, widget);
                qDrawPlainRect(painter, r, option->palette.shadow().color(), proxy()->pixelMetric(PM_SpinBoxFrameWidth, option, widget),0);
            }
            QPalette shadePal(option->palette);
            shadePal.setColor(QPalette::Button, option->palette.light().color());
            shadePal.setColor(QPalette::Light, option->palette.base().color());
            if (spinBox->subControls & SC_SpinBoxUp) {
                copy.subControls = SC_SpinBoxUp;
                QPalette pal2 = spinBox->palette;
                if (!(spinBox->stepEnabled & QAbstractSpinBox::StepUpEnabled)) {
                    pal2.setCurrentColorGroup(QPalette::Disabled);
                    copy.state &= ~State_Enabled;
                }
                copy.palette = pal2;
                if (spinBox->activeSubControls == SC_SpinBoxUp && (spinBox->state & State_Sunken)) {
                    copy.state |= State_On;
                    copy.state |= State_Sunken;
                } else {
                    copy.state |= State_Raised;
                    copy.state &= ~State_Sunken;
                }
                primitiveElement = (spinBox->buttonSymbols == QAbstractSpinBox::PlusMinus ? PE_IndicatorArrowUpBig
                    : PE_IndicatorArrowUpBig);
                copy.rect = proxy()->subControlRect(CC_SpinBox, spinBox, SC_SpinBoxUp, widget);
                if (copy.state & (State_Sunken | State_On))
                    qDrawPlainRect(painter, copy.rect, option->palette.shadow().color(), proxy()->pixelMetric(PM_SpinBoxFrameWidth, option, widget), &copy.palette.brush(QPalette::Shadow));
                else
                  qDrawPlainRect(painter, copy.rect, option->palette.shadow().color(), proxy()->pixelMetric(PM_SpinBoxFrameWidth, option, widget), &copy.palette.brush(QPalette::Base));
                copy.rect.adjust(proxy()->pixelMetric(PM_SpinBoxFrameWidth, option, widget), 0, -pixelMetric(PM_SpinBoxFrameWidth, option, widget), 0);
                proxy()->drawPrimitive(PrimitiveElement(primitiveElement), &copy, painter, widget);
            }
            if (spinBox->subControls & SC_SpinBoxDown) {
                copy.subControls = SC_SpinBoxDown;
                copy.state = spinBox->state;
                QPalette pal2 = spinBox->palette;
                if (!(spinBox->stepEnabled & QAbstractSpinBox::StepDownEnabled)) {
                    pal2.setCurrentColorGroup(QPalette::Disabled);
                    copy.state &= ~State_Enabled;
                }
                copy.palette = pal2;
                if (spinBox->activeSubControls == SC_SpinBoxDown && (spinBox->state & State_Sunken)) {
                    copy.state |= State_On;
                    copy.state |= State_Sunken;
                } else {
                    copy.state |= State_Raised;
                    copy.state &= ~State_Sunken;
                }
                primitiveElement = (spinBox->buttonSymbols == QAbstractSpinBox::PlusMinus ? PE_IndicatorArrowDownBig
                                                                       : PE_IndicatorArrowDownBig);
                copy.rect = proxy()->subControlRect(CC_SpinBox, spinBox, SC_SpinBoxDown, widget);
                qDrawPlainRect(painter, copy.rect, option->palette.shadow().color(), proxy()->pixelMetric(PM_SpinBoxFrameWidth, option, widget), &copy.palette.brush(QPalette::Base));
                if (copy.state & (State_Sunken | State_On))
                    qDrawPlainRect(painter, copy.rect, option->palette.shadow().color(), proxy()->pixelMetric(PM_SpinBoxFrameWidth, option, widget), &copy.palette.brush(QPalette::Shadow));
                else
                    qDrawPlainRect(painter, copy.rect, option->palette.shadow().color(), proxy()->pixelMetric(PM_SpinBoxFrameWidth, option, widget), &copy.palette.brush(QPalette::Base));
                copy.rect.adjust(3, 0, -4, 0);
                if (primitiveElement == PE_IndicatorArrowUp || primitiveElement == PE_IndicatorArrowDown) {
                    int frameWidth = proxy()->pixelMetric(PM_SpinBoxFrameWidth, option, widget);
                    copy.rect = copy.rect.adjusted(frameWidth, frameWidth, -frameWidth, -frameWidth);
                    proxy()->drawPrimitive(PrimitiveElement(primitiveElement), &copy, painter, widget);
                }
                else {
                    proxy()->drawPrimitive(PrimitiveElement(primitiveElement), &copy, painter, widget);
                }
                if (spinBox->frame && (spinBox->subControls & SC_SpinBoxFrame)) {
                    QRect r = proxy()->subControlRect(CC_SpinBox, spinBox, SC_SpinBoxEditField, widget);
                }
            }
        }
        break;
#endif // QT_NO_SPINBOX

    default:
        QWindowsStyle::drawComplexControl(control, option, painter, widget);
        break;
    }
}

QSize QWindowsMobileStyle::sizeFromContents(ContentsType type, const QStyleOption *option,
                                            const QSize &size, const QWidget *widget) const {

    QSize newSize = QWindowsStyle::sizeFromContents(type, option, size, widget);
    switch (type) {
    case CT_PushButton:
       if (const QStyleOptionButton *button = qstyleoption_cast<const QStyleOptionButton *>(option)) {
            newSize = QCommonStyle::sizeFromContents(type, option, size, widget);
            int w = newSize.width(),
                h = newSize.height();
            int defwidth = 0;
            if (button->features & QStyleOptionButton::AutoDefaultButton)
                defwidth = 2 * proxy()->pixelMetric(PM_ButtonDefaultIndicator, button, widget);

            int minwidth = int(QStyleHelper::dpiScaled(55.0f));
            int minheight = int(QStyleHelper::dpiScaled(19.0f));

            if (w < minwidth + defwidth && button->icon.isNull())
                w = minwidth + defwidth;
            if (h < minheight + defwidth)
                h = minheight + defwidth;
            newSize = QSize(w + 4, h + 4);
        }
        break;

#ifndef QT_NO_GROUPBOX
    case CT_GroupBox:
        if (const QGroupBox *grb = static_cast<const QGroupBox *>(widget)) {
            newSize = size + QSize(!grb->isFlat() ? 16 : 0, !grb->isFlat() ? 16 : 0);
        }
        break;
#endif // QT_NO_GROUPBOX

    case CT_RadioButton:
    case CT_CheckBox:
        newSize = size;
        if (const QStyleOptionButton *button = qstyleoption_cast<const QStyleOptionButton *>(option)) {
            bool isRadio = (type == CT_RadioButton);
            QRect irect = visualRect(button->direction, button->rect,
                                     proxy()->subElementRect(isRadio ? SE_RadioButtonIndicator
                                                            : SE_CheckBoxIndicator, button, widget));
            int h = proxy()->pixelMetric(isRadio ? PM_ExclusiveIndicatorHeight
                                        : PM_IndicatorHeight, button, widget);
            int margins = (!button->icon.isNull() && button->text.isEmpty()) ? 0 : 10;
             if (d_func()->doubleControls)
                 margins *= 2;
            newSize += QSize(irect.right() + margins, 1);
            newSize.setHeight(qMax(newSize.height(), h));
        }
        break;
#ifndef QT_NO_COMBOBOX
    case CT_ComboBox:
        if (const QStyleOptionComboBox *comboBox = qstyleoption_cast<const QStyleOptionComboBox *>(option)) {
            int fw = comboBox->frame ? proxy()->pixelMetric(PM_ComboBoxFrameWidth, option, widget) * 2 : 0;
            newSize = QSize(newSize.width() + fw + 9, newSize.height() + fw); //Nine is a magic Number - See CommonStyle for real magic (23)
        }
        break;
#endif
#ifndef QT_NO_SPINBOX
    case CT_SpinBox:
        if (const QStyleOptionSpinBox *spinBox = qstyleoption_cast<const QStyleOptionSpinBox *>(option)) {
            int fw = spinBox->frame ? proxy()->pixelMetric(PM_SpinBoxFrameWidth, option, widget) * 2 : 0;
            newSize = QSize(newSize.width() + fw-5, newSize.height() + fw-6);
        }
        break;
#endif
#ifndef QT_NO_LINEEDIT
    case CT_LineEdit:
        newSize += QSize(0,1);
        break;
#endif
    case CT_ToolButton:
        newSize = QSize(newSize.width() + 1, newSize.height());
        break;
    case CT_TabBarTab:
        if (d_func()->doubleControls)
            newSize = QSize(newSize.width(), 42);
        else
            newSize = QSize(newSize.width(), 21);
        break;
    case CT_HeaderSection:
        newSize += QSize(4, 2);
        break;
#ifndef QT_NO_ITEMVIEWS
#ifdef Q_WS_WINCE_WM
    case CT_ItemViewItem:
        if (d_func()->wm65)
            if (d_func()->doubleControls)
                newSize.setHeight(46);
            else
                newSize.setHeight(23);
        break;
#endif //Q_WS_WINCE_WM
#endif //QT_NO_ITEMVIEWS
    default:
        break;
    }
    return newSize;
}

QRect QWindowsMobileStyle::subElementRect(SubElement element, const QStyleOption *option, const QWidget *widget) const {

    QWindowsMobileStylePrivate *d = const_cast<QWindowsMobileStylePrivate*>(d_func());
    QRect rect = QWindowsStyle::subElementRect(element, option, widget);
    switch (element) {
#ifndef QT_NO_TABWIDGET
    case SE_TabWidgetTabBar:
        if (d->doubleControls)
            rect.adjust(-2, 0, 2, 0);
        else
            rect.adjust(-2, 0, 2, 0);
        break;
#endif //QT_NO_TABWIDGET
    case SE_CheckBoxFocusRect:
        rect.adjust(1,0,-2,-1);
        break;
    case SE_RadioButtonFocusRect:
        rect.adjust(1,1,-2,-2);
        break;
    default:
        break;
#ifndef QT_NO_SLIDER
    case SE_SliderFocusRect:
        if (const QStyleOptionSlider *slider = qstyleoption_cast<const QStyleOptionSlider *>(option)) {
            rect = slider->rect;
        }
        break;
    case SE_PushButtonFocusRect:
        if (d->doubleControls)
            rect.adjust(-1, -1, 0, 0);
        break;
#endif // QT_NO_SLIDER
#ifndef QT_NO_ITEMVIEWS
        case SE_ItemViewItemFocusRect:
#ifdef Q_WS_WINCE_WM
            if (d->wm65)
                rect = QRect();
#endif
        break;
#endif //QT_NO_ITEMVIEWS
    }
    return rect;
}

QRect QWindowsMobileStyle::subControlRect(ComplexControl control, const QStyleOptionComplex *option,
                                          SubControl subControl, const QWidget *widget) const {

    QWindowsMobileStylePrivate *d = const_cast<QWindowsMobileStylePrivate*>(d_func());

    QRect rect = QCommonStyle::subControlRect(control, option, subControl, widget);
    switch (control) {

#ifndef QT_NO_SCROLLBAR
    case CC_ScrollBar:
        if (const QStyleOptionSlider *scrollbar = qstyleoption_cast<const QStyleOptionSlider *>(option)) {
            int sliderButtonExtent = proxy()->pixelMetric(PM_ScrollBarExtent, scrollbar, widget);
            float stretchFactor = 1.4f;
            int sliderButtonExtentDir = int (sliderButtonExtent * stretchFactor);

#ifdef Q_WS_WINCE_WM
            if (d->wm65)
            {
                sliderButtonExtent = d->imageScrollbarHandleUp.width();
                sliderButtonExtentDir = d->imageScrollbarHandleUp.height();
            }
#endif //Q_WS_WINCE_WM

            int sliderlen;
            int maxlen = ((scrollbar->orientation == Qt::Horizontal) ?
                scrollbar->rect.width() : scrollbar->rect.height()) - (sliderButtonExtentDir * 2);
            // calculate slider length
            if (scrollbar->maximum != scrollbar->minimum) {
                uint range = scrollbar->maximum - scrollbar->minimum;
                sliderlen = (qint64(scrollbar->pageStep) * maxlen) / (range + scrollbar->pageStep);

                int slidermin = proxy()->pixelMetric(PM_ScrollBarSliderMin, scrollbar, widget);
                if (sliderlen < slidermin || range > INT_MAX / 2)
                    sliderlen = slidermin;
                if (sliderlen > maxlen)
                    sliderlen = maxlen;
            } else {
                sliderlen = maxlen;
            }
            int sliderstart = sliderButtonExtentDir + sliderPositionFromValue(scrollbar->minimum,
                scrollbar->maximum,
                scrollbar->sliderPosition,
                maxlen - sliderlen,
                scrollbar->upsideDown);
            if (d->smartphone) {
                sliderstart -= sliderButtonExtentDir;
                sliderlen += 2*sliderButtonExtent;
            }
            switch (subControl) {
            case SC_ScrollBarSubLine:            // top/left button
                if (scrollbar->orientation == Qt::Horizontal) {
                    int buttonWidth = qMin(scrollbar->rect.width() / 2, sliderButtonExtentDir );
                    rect.setRect(0, 0, buttonWidth, sliderButtonExtent);
                } else {
                    int buttonHeight = qMin(scrollbar->rect.height() / 2, sliderButtonExtentDir);
                    rect.setRect(0, 0, sliderButtonExtent, buttonHeight);
                }
                if (d->smartphone)
                    rect.setRect(0, 0, 0, 0);
                break;
            case SC_ScrollBarAddLine:            // bottom/right button
                if (scrollbar->orientation == Qt::Horizontal) {
                    int buttonWidth = qMin(scrollbar->rect.width()/2, sliderButtonExtentDir);
                    rect.setRect(scrollbar->rect.width() - buttonWidth, 0, buttonWidth, sliderButtonExtent);
                } else {
                    int buttonHeight = qMin(scrollbar->rect.height()/2, sliderButtonExtentDir );
                    rect.setRect(0, scrollbar->rect.height() - buttonHeight, sliderButtonExtent, buttonHeight);
                }
                if (d->smartphone)
                    rect.setRect(0, 0, 0, 0);
                break;
            case SC_ScrollBarSubPage:            // between top/left button and slider
                if (scrollbar->orientation == Qt::Horizontal)
                    if (d->smartphone)
                       rect.setRect(0, 0, sliderstart, sliderButtonExtent);
                    else
                      rect.setRect(sliderButtonExtent, 0, sliderstart - sliderButtonExtent, sliderButtonExtent);
                else
                    if (d->smartphone)
                      rect.setRect(0, 0, sliderButtonExtent, sliderstart);
                    else
                      rect.setRect(0, sliderButtonExtent, sliderButtonExtent, sliderstart - sliderButtonExtent);
                break;
            case SC_ScrollBarAddPage:            // between bottom/right button and slider
                if (scrollbar->orientation == Qt::Horizontal)
                    if (d->smartphone)
                      rect.setRect(sliderstart + sliderlen, 0,
                                  maxlen - sliderstart - sliderlen + 2*sliderButtonExtent, sliderButtonExtent);
                    else
                      rect.setRect(sliderstart + sliderlen, 0,
                                   maxlen - sliderstart - sliderlen + sliderButtonExtent, sliderButtonExtent);
                else
                    if (d->smartphone)
                      rect.setRect(0, sliderstart + sliderlen, sliderButtonExtent,
                                  maxlen - sliderstart - sliderlen + 2*sliderButtonExtent);
                    else
                       rect.setRect(0, sliderstart + sliderlen, sliderButtonExtent,
                                  maxlen - sliderstart - sliderlen + sliderButtonExtent);
                break;
            case SC_ScrollBarGroove:
                if (scrollbar->orientation == Qt::Horizontal)
                    rect.setRect(sliderButtonExtent, 0, scrollbar->rect.width() - sliderButtonExtent * 2,
                                scrollbar->rect.height());
                else
                    rect.setRect(0, sliderButtonExtent, scrollbar->rect.width(),
                                scrollbar->rect.height() - sliderButtonExtent * 2);
                break;
            case SC_ScrollBarSlider:
                if (scrollbar->orientation == Qt::Horizontal)
                    rect.setRect(sliderstart, 0, sliderlen, sliderButtonExtent);
                else
                    rect.setRect(0, sliderstart, sliderButtonExtent, sliderlen);
                break;
            default:
                break;
            }
            rect = visualRect(scrollbar->direction, scrollbar->rect, rect);
        }
        break;
#endif // QT_NO_SCROLLBAR



#ifndef QT_NO_TOOLBUTTON
    case CC_ToolButton:
        if (const QStyleOptionToolButton *toolButton = qstyleoption_cast<const QStyleOptionToolButton *>(option)) {
            int mbi = proxy()->pixelMetric(PM_MenuButtonIndicator, toolButton, widget);
            rect = toolButton->rect;
            switch (subControl) {
            case SC_ToolButton:
                if ((toolButton->features
                     & (QStyleOptionToolButton::Menu | QStyleOptionToolButton::PopupDelay))
                    == QStyleOptionToolButton::Menu)
                    rect.adjust(0, 0, -mbi, 0);
                break;
            case SC_ToolButtonMenu:
                if ((toolButton->features
                     & (QStyleOptionToolButton::Menu | QStyleOptionToolButton::PopupDelay))
                    == QStyleOptionToolButton::Menu)
                    rect.adjust(rect.width() - mbi, 1, 0, 1);
                break;
            default:
                break;
            }
            rect = visualRect(toolButton->direction, toolButton->rect, rect);
        }
        break;
#endif // QT_NO_TOOLBUTTON

#ifndef QT_NO_SLIDER
        case CC_Slider:
        if (const QStyleOptionSlider *slider = qstyleoption_cast<const QStyleOptionSlider *>(option)) {
            int tickOffset = proxy()->pixelMetric(PM_SliderTickmarkOffset, slider, widget);
            int thickness = proxy()->pixelMetric(PM_SliderControlThickness, slider, widget);
            switch (subControl) {
            case SC_SliderHandle: {
                int sliderPos = 0;
                int len = proxy()->pixelMetric(PM_SliderLength, slider, widget);
                bool horizontal = slider->orientation == Qt::Horizontal;
                sliderPos = sliderPositionFromValue(slider->minimum, slider->maximum,
                                                    slider->sliderPosition,
                                                    (horizontal ? slider->rect.width()
                                                                : slider->rect.height()) - len,
                                                    slider->upsideDown);
                if (horizontal)
                    rect.setRect(slider->rect.x() + sliderPos, slider->rect.y() + tickOffset, len, thickness);
                else
                    rect.setRect(slider->rect.x() + tickOffset, slider->rect.y() + sliderPos, thickness, len);
                break; }
            default:
                break;
            }
            rect = visualRect(slider->direction, slider->rect, rect);
        }
        break;
#endif //QT_NO_SLIDER
#ifndef QT_NO_COMBOBOX
    case CC_ComboBox:
        if (const QStyleOptionComboBox *comboBox = qstyleoption_cast<const QStyleOptionComboBox *>(option)) {
        int x = comboBox->rect.x(),
            y = comboBox->rect.y(),
            wi = comboBox->rect.width(),
            he = comboBox->rect.height();
        int xpos = x;
        int margin = comboBox->frame ? (d->doubleControls ? 2 : 1) : 0;
        int bmarg = comboBox->frame ? (d->doubleControls ? 2 : 1) :  0;
        if (subControl == SC_ComboBoxArrow)
          xpos += wi - int((he - 2*bmarg)*0.9) - bmarg;
        else
          xpos += wi - (he - 2*bmarg) - bmarg;
        switch (subControl) {
        case SC_ComboBoxArrow:
            rect.setRect(xpos, y + bmarg, he - 2*bmarg, he - 2*bmarg);
            break;
        case SC_ComboBoxEditField:
            rect.setRect(x + margin, y + margin, wi - 2 * margin - int((he - 2*bmarg) * 0.84f), he - 2 * margin);
            if (d->doubleControls) {
                if (comboBox->editable)
                    rect.adjust(2, 0, 0, 0);
                else
                    rect.adjust(4, 2, 0, -2);
            } else if (!comboBox->editable) {
                rect.adjust(2, 1, 0, -1);
            }
            break;
        case SC_ComboBoxFrame:
            rect = comboBox->rect;
            break;
        default:
        break;
        }
    }
#endif //QT_NO_COMBOBOX
#ifndef QT_NO_SPINBOX
    case CC_SpinBox:
        if (const QStyleOptionSpinBox *spinBox = qstyleoption_cast<const QStyleOptionSpinBox *>(option)) {
            QSize bs;
            int fw = spinBox->frame ? proxy()->pixelMetric(PM_SpinBoxFrameWidth, spinBox, widget) : 0;
            bs.setHeight(qMax(d->doubleControls ? 28 : 14, (spinBox->rect.height())));
            // 1.6 -approximate golden mean
            bs.setWidth(qMax(d->doubleControls ? 28 : 14, qMin((bs.height()*7/8), (spinBox->rect.width() / 8))));
            bs = bs.expandedTo(QApplication::globalStrut());
            int x, lx, rx;
            x = spinBox->rect.width() - bs.width()*2;
            lx = fw;
            rx = x - fw;
            switch (subControl) {
            case SC_SpinBoxUp:
                rect = QRect(x + proxy()->pixelMetric(PM_SpinBoxFrameWidth, option, widget), 0 , bs.width(), bs.height());
                break;
            case SC_SpinBoxDown:
                rect = QRect(x + bs.width(), 0, bs.width(), bs.height());
                break;
            case SC_SpinBoxEditField:
                if (spinBox->buttonSymbols == QAbstractSpinBox::NoButtons) {
                    rect = QRect(lx, fw, spinBox->rect.width() - 2*fw - 2, spinBox->rect.height() - 2*fw);
                } else {
                    rect = QRect(lx, fw, rx-2, spinBox->rect.height() - 2*fw);
                }
                break;
            case SC_SpinBoxFrame:
                rect = spinBox->rect;
            default:
                break;
          }
          rect = visualRect(spinBox->direction, spinBox->rect, rect);
        }
        break;
#endif // Qt_NO_SPINBOX
#ifndef QT_NO_GROUPBOX
    case CC_GroupBox: {
        if (const QStyleOptionGroupBox *groupBox = qstyleoption_cast<const QStyleOptionGroupBox *>(option)) {
            switch (subControl) {
            case SC_GroupBoxFrame:
                // FALL THROUGH
            case SC_GroupBoxContents: {
                int topMargin = 0;
                int topHeight = 0;
                int bottomMargin = 0;
                int labelMargin = 2;

                QRect frameRect = groupBox->rect;
                int verticalAlignment = styleHint(SH_GroupBox_TextLabelVerticalAlignment, groupBox, widget);
                if (groupBox->text.size()) {
                    topHeight = groupBox->fontMetrics.height();
                    if (verticalAlignment & Qt::AlignVCenter)
                        topMargin = topHeight+5;
                    else if (verticalAlignment & Qt::AlignTop)
                        topMargin = -topHeight+5;
                }
                if (subControl == SC_GroupBoxFrame) {
                    frameRect.setTop(topMargin);
                    frameRect.setBottom(frameRect.height() + bottomMargin);
                    rect = frameRect;
                    break;
                }
                int frameWidth = 0;
                if (groupBox->text.size()) {
                    frameWidth = proxy()->pixelMetric(PM_DefaultFrameWidth, groupBox, widget);
                    rect = frameRect.adjusted(frameWidth, frameWidth + topHeight + labelMargin, -frameWidth, -frameWidth);
                }
                else {
                   rect = groupBox->rect;
                }
                break;
            }
            case SC_GroupBoxCheckBox:
                // FALL THROUGH
            case SC_GroupBoxLabel: {
                QFontMetrics fontMetrics = groupBox->fontMetrics;
                int h = fontMetrics.height();
                int textWidth = fontMetrics.size(Qt::TextShowMnemonic, groupBox->text + QLatin1Char(' ')).width();
                int margX = (groupBox->features & QStyleOptionFrameV2::Flat) ? 0 : 2;
                int margY = (groupBox->features & QStyleOptionFrameV2::Flat) ? 0 : 2;
                rect = groupBox->rect.adjusted(margX, margY, -margX, 0);
                if (groupBox->text.size())
                    rect.setHeight(h);
                else
                  rect.setHeight(0);
                int indicatorWidth = proxy()->pixelMetric(PM_IndicatorWidth, option, widget);
                int indicatorSpace = proxy()->pixelMetric(PM_CheckBoxLabelSpacing, option, widget) - 1;
                bool hasCheckBox = groupBox->subControls & QStyle::SC_GroupBoxCheckBox;
                int checkBoxSize = hasCheckBox ? (indicatorWidth + indicatorSpace) : 0;

                // Adjusted rect for label + indicatorWidth + indicatorSpace
                QRect totalRect = alignedRect(groupBox->direction, groupBox->textAlignment,
                                              QSize(textWidth + checkBoxSize, h), rect);

                // Adjust totalRect if checkbox is set
                if (hasCheckBox) {
                    bool ltr = groupBox->direction == Qt::LeftToRight;
                    int left = 2;
                    // Adjust for check box
                    if (subControl == SC_GroupBoxCheckBox) {
                        int indicatorHeight = proxy()->pixelMetric(PM_IndicatorHeight, option, widget);
                        left = ltr ? totalRect.left() : (totalRect.right() - indicatorWidth);
                        int top = totalRect.top() + (fontMetrics.height() - indicatorHeight) / 2;
                        totalRect.setRect(left, top, indicatorWidth, indicatorHeight);
                    // Adjust for label
                    } else {
                        left = ltr ? (totalRect.left() + checkBoxSize - 2) : totalRect.left();
                        totalRect.setRect(left, totalRect.top(),
                                          totalRect.width() - checkBoxSize, totalRect.height());
                    }
                }
                  if ((subControl== SC_GroupBoxLabel))
                      totalRect.adjust(-2,0,6,0);
                  rect = totalRect;
                break;
            }
            default:
                break;
            }
        }
        break;
    }
#endif // QT_NO_GROUPBOX
    default:
        break;
    }
    return rect;
}

QPalette QWindowsMobileStyle::standardPalette() const {
    QPalette palette (Qt::black,QColor(198, 195, 198), QColor(222, 223, 222 ),
                      QColor(132, 130, 132), QColor(198, 195, 198), Qt::black, Qt::white, Qt::white, QColor(198, 195, 198));
    palette.setColor(QPalette::Window, QColor(206, 223, 239));
    palette.setColor(QPalette::Link, QColor(8,77,123)); //Alternate TextColor for labels...
    palette.setColor(QPalette::Base, Qt::white);
    palette.setColor(QPalette::Button, QColor(206, 223, 239));
    palette.setColor(QPalette::Highlight, QColor(49, 146, 214));
    palette.setColor(QPalette::Light, Qt::white);
    palette.setColor(QPalette::Text, Qt::black);
    palette.setColor(QPalette::ButtonText, Qt::black);
    palette.setColor(QPalette::Midlight, QColor(222, 223, 222 ));
    palette.setColor(QPalette::Dark, QColor(132, 130, 132));
    palette.setColor(QPalette::Mid, QColor(189, 190, 189));
    palette.setColor(QPalette::Shadow, QColor(0, 0, 0));
    palette.setColor(QPalette::BrightText, QColor(33, 162, 33)); //color for ItemView checked indicator (arrow)
    return palette;
}


/*! \reimp */
void QWindowsMobileStyle::polish(QApplication *application) {
    QWindowsStyle::polish(application);
}

/*! \reimp */
void QWindowsMobileStyle::polish(QWidget *widget) {

#ifndef QT_NO_TOOLBAR
    if (QToolBar *toolBar = qobject_cast<QToolBar*>(widget)) {
        QPalette pal = toolBar->palette();
        pal.setColor(QPalette::Background, pal.button().color());
        toolBar->setPalette(pal);
    }
    else
#endif //QT_NO_TOOLBAR

    QWindowsStyle::polish(widget);
}

void QWindowsMobileStyle::unpolish(QWidget *widget)
{
    QWindowsStyle::unpolish(widget);
}

void QWindowsMobileStyle::unpolish(QApplication *app)
{
    QWindowsStyle::unpolish(app);
}

/*! \reimp */
void QWindowsMobileStyle::polish(QPalette &palette) {
    QWindowsStyle::polish(palette);
}

int QWindowsMobileStyle::pixelMetric(PixelMetric pm, const QStyleOption *opt, const QWidget *widget) const {

    QWindowsMobileStylePrivate *d = const_cast<QWindowsMobileStylePrivate*>(d_func());
    int ret;

    switch (pm) {
    case PM_DefaultTopLevelMargin:
        ret =0;
        break;
    case PM_DefaultLayoutSpacing:
        d->doubleControls ? ret = 8 : ret = 4;
        break;
    case PM_HeaderMargin:
        d->doubleControls ? ret = 2 : ret = 1;
        break;
    case PM_DefaultChildMargin:
        d->doubleControls ? ret = 10 : ret = 5;
        break;
    case PM_ToolBarSeparatorExtent:
        d->doubleControls ? ret = 6 : ret = 3;
        break;
    case PM_DefaultFrameWidth:
        d->doubleControls ? ret = 2 : ret = 1;
        break;
    case PM_MenuVMargin:
        ret = 1;
        break;
    case PM_MenuHMargin:
        ret = 1;
        break;
    case PM_MenuButtonIndicator:
        ret = d->doubleControls ? 24 : 14;
        break;
    case PM_ComboBoxFrameWidth:
        d->doubleControls ? ret = 2 : ret = 1;
        break;
    case PM_SpinBoxFrameWidth:
        d->doubleControls ? ret = 2 : ret = 1;
        break;
    case PM_ButtonDefaultIndicator:
    case PM_ButtonShiftHorizontal:
    case PM_ButtonShiftVertical:
        d->doubleControls ? ret = 2 : ret = 1;
        break;
#ifndef QT_NO_TABBAR
   case PM_TabBarTabShiftHorizontal:
        ret = 0;
        break;
    case PM_TabBarTabShiftVertical:
        ret = 0;
        break;
#endif
    case PM_MaximumDragDistance:
        ret = 60;
        break;
   case PM_TabBarTabVSpace:
        ret = d->doubleControls ? 12 : 6;
        break;
   case PM_TabBarBaseHeight:
       ret = 0;
       break;
      case PM_IndicatorWidth:
          ret = d->doubleControls ? windowsMobileIndicatorSize * 2 : windowsMobileIndicatorSize;
        break;
    case PM_IndicatorHeight:
        ret = d->doubleControls ? windowsMobileIndicatorSize * 2 : windowsMobileIndicatorSize;
        break;
    case PM_ExclusiveIndicatorWidth:
        ret = d->doubleControls ? windowsMobileExclusiveIndicatorSize * 2 + 4: windowsMobileExclusiveIndicatorSize + 2;
        break;
    case PM_ExclusiveIndicatorHeight:
        ret = d->doubleControls ? windowsMobileExclusiveIndicatorSize * 2 + 4: windowsMobileExclusiveIndicatorSize + 2;
        break;
#ifndef QT_NO_SLIDER
    case PM_SliderLength:
        ret = d->doubleControls ? 16 : 8;
        break;
    case PM_FocusFrameHMargin:
        ret = d->doubleControls ? 1 : 2;
        break;
    case PM_SliderThickness:
        ret = d->doubleControls ? windowsMobileSliderThickness * 2: windowsMobileSliderThickness;
        break;
    case PM_TabBarScrollButtonWidth:
        ret = d->doubleControls ? 14 * 2 : 18;
        break;
    case PM_CheckBoxLabelSpacing:
    case PM_RadioButtonLabelSpacing:
        ret = d->doubleControls ? 6 * 2 : 6;
        break;
        // Returns the number of pixels to use for the business part of the
        // slider (i.e., the non-tickmark portion). The remaining space is shared
        // equally between the tickmark regions.
    case PM_SliderControlThickness:
        if (const QStyleOptionSlider *sl = qstyleoption_cast<const QStyleOptionSlider *>(opt)) {
            int space = (sl->orientation == Qt::Horizontal) ? sl->rect.height() : sl->rect.width();
            int ticks = sl->tickPosition;
            int n = 0;
            if (ticks & QSlider::TicksAbove)
                ++n;
            if (ticks & QSlider::TicksBelow)
                ++n;
            if (!n) {
                ret = space;
                break;
            }
            int thick = 8;
            if (ticks != QSlider::TicksBothSides && ticks != QSlider::NoTicks)
                thick += proxy()->pixelMetric(PM_SliderLength, sl, widget) / 4;

            space -= thick;
            if (space > 0)
                thick += (space * 2) / (n + 2);
            ret = thick;
        } else {
            ret = 0;
        }
        break;
#endif // QT_NO_SLIDER
#ifndef QT_NO_MENU
    case PM_SmallIconSize:
        d->doubleControls ? ret = windowsMobileIconSize * 2 : ret = windowsMobileIconSize;
        break;
    case PM_ButtonMargin:
        d->doubleControls ? ret = 8 : ret = 4;
        break;
    case PM_LargeIconSize:
        d->doubleControls ? ret = 64 : ret = 32;
        break;
    case PM_IconViewIconSize:
        ret = proxy()->pixelMetric(PM_LargeIconSize, opt, widget);
        break;
    case PM_ToolBarIconSize:
        d->doubleControls ? ret = 2 * windowsMobileIconSize : ret = windowsMobileIconSize;
        break;
    case PM_DockWidgetTitleMargin:
        ret = 2;
        break;
#if defined(Q_WS_WIN)
#else
    case PM_DockWidgetFrameWidth:
        ret = 4;
        break;
#endif // Q_WS_WIN
    break;
#endif // QT_NO_MENU

   case PM_TitleBarHeight:
        d->doubleControls ? ret = 42 : ret = 21;
        break;
   case PM_ScrollBarSliderMin:
#ifdef Q_WS_WINCE_WM
       if (d->wm65)
#else
       if (false)
#endif
       {
           d->doubleControls ? ret = 68 : ret = 34;
       } else {
           d->doubleControls ? ret = 36 : ret = 18;
       }
        break;
   case PM_ScrollBarExtent: {
       
       if (d->smartphone)
           ret = 9;
       else
         d->doubleControls ? ret = 25 : ret = 13;

#ifdef Q_WS_WINCE_WM
       if (d->wm65)
#else
       if (false)
#endif
       {
           d->doubleControls ? ret = 26 : ret = 13;
           break;
       }

#ifndef QT_NO_SCROLLAREA
       //Check if the scrollbar is part of an abstractItemView and set size according
       if (widget)
       if (QWidget *parent = widget->parentWidget())
           if (qobject_cast<QAbstractScrollArea *>(parent->parentWidget()))
               if (d->smartphone)
                 ret = 8;
               else
                 d->doubleControls ? ret = 24 : ret = 12;
#endif
       }
       break;
    case PM_SplitterWidth:
        ret = qMax(4, QApplication::globalStrut().width());
        break;

#if defined(Q_WS_WIN)
    case PM_MDIFrameWidth:
        ret = 1;
        break;
#endif
    case PM_ToolBarExtensionExtent:
        d->doubleControls ? ret = 32 : ret = 16;
        break;
    case PM_ToolBarItemMargin:
        d->doubleControls ? ret = 2 : ret = 1;
        break;
    case PM_ToolBarItemSpacing:
        d->doubleControls ? ret = 2 : ret = 1;
        break;
    case PM_ToolBarHandleExtent:
        d->doubleControls ? ret = 16 : ret = 8;
        break;
    case PM_ButtonIconSize:
        d->doubleControls ? ret = 32 : ret = 16;
        break;
    case PM_TextCursorWidth:
        ret = 2;
        break;
    case PM_TabBar_ScrollButtonOverlap:
        ret = 0;
        break;
    default:
        ret = QWindowsStyle::pixelMetric(pm, opt, widget);
        break;
    }
    return ret;
}

int QWindowsMobileStyle::styleHint(StyleHint hint, const QStyleOption *opt, const QWidget *widget,
                                   QStyleHintReturn *returnData) const {

    int ret;
    switch (hint) {
    case SH_Menu_MouseTracking:
    case SH_ComboBox_ListMouseTracking:
    case SH_EtchDisabledText:
        ret = 0;
        break;
    case SH_DitherDisabledText:
        ret = 0;
        break;
    case SH_ItemView_ShowDecorationSelected:
        ret = 0;
        break;
#ifndef QT_NO_TABWIDGET
    case SH_TabWidget_DefaultTabPosition:
        ret = QTabWidget::South;
        break;
#endif
    case SH_ToolBar_Movable:
        ret = false;
        break;
    case SH_ScrollBar_ContextMenu:
        ret = false;
        break;
    case SH_MenuBar_AltKeyNavigation:
        ret = false;
        break;
    case SH_RequestSoftwareInputPanel:
        ret = RSIP_OnMouseClick;
        break;
    default:
          ret = QWindowsStyle::styleHint(hint, opt, widget, returnData);
       break;
    }
    return ret;
}

QPixmap QWindowsMobileStyle::standardPixmap(StandardPixmap sp, const QStyleOption *option,
                                     const QWidget *widget) const {

    QWindowsMobileStylePrivate *d = const_cast<QWindowsMobileStylePrivate*>(d_func());
    switch (sp) {
#ifndef QT_NO_IMAGEFORMAT_XPM
    case SP_ToolBarHorizontalExtensionButton: {
        QPixmap pixmap = QCommonStyle::standardPixmap(sp, option, widget);
        if (d->doubleControls)
            return pixmap.scaledToHeight(pixmap.height() * 2);
        else
          return pixmap;
     }
     case SP_TitleBarMaxButton:
     case SP_TitleBarCloseButton:
     case SP_TitleBarNormalButton:
     case SP_TitleBarMinButton: {
         QImage image;
         switch (sp) {
            case SP_TitleBarMaxButton:
                image = d->imageMaximize;
            break;
            case SP_TitleBarCloseButton:
                image = d->imageClose;
            break;
            case SP_TitleBarNormalButton:
                image = d->imageNormalize;
            break;
            case SP_TitleBarMinButton:
                image = d->imageMinimize;
            break;
            default:
            break;
         }
         if (option) {
             image.setColor(0, option->palette.shadow().color().rgba());
             image.setColor(1, option->palette.highlight().color().rgba());
             image.setColor(2, option->palette.highlight().color().lighter(150).rgba());
             image.setColor(3, option->palette.highlightedText().color().rgba());
         }

         return QPixmap::fromImage(image);
     }

#endif
    default:
        return QWindowsStyle::standardPixmap(sp, option, widget);
    }
}

QPixmap QWindowsMobileStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap,
                                                 const QStyleOption *option) const {

    switch (iconMode) {
    case QIcon::Selected: {
#ifdef Q_WS_WINCE_WM
        if (d_func()->wm65)
            return pixmap;
#endif //Q_WS_WINCE_WM
        QImage img = pixmap.toImage().convertToFormat(QImage::Format_ARGB32);
        int imgh = img.height();
        int imgw = img.width();
        for (int y = 0; y < imgh; y += 2) {
            for (int x = 0; x < imgw; x += 2) {
                QColor c = option->palette.highlight().color().rgb();
                c.setAlpha( qAlpha(img.pixel(x, y)));
                QRgb pixel = c.rgba();
                img.setPixel(x, y, pixel);
            }
        }
        return QPixmap::fromImage(img);
    }
    default:
    break;
    }
    return QWindowsStyle::generatedIconPixmap(iconMode, pixmap, option);
}


bool QWindowsMobileStyle::doubleControls() const {

    QWindowsMobileStylePrivate *d = const_cast<QWindowsMobileStylePrivate*>(d_func());

    return d->doubleControls;
}

void QWindowsMobileStyle::setDoubleControls(bool doubleControls) {

   QWindowsMobileStylePrivate *d = const_cast<QWindowsMobileStylePrivate*>(d_func());

   d->doubleControls = doubleControls;
}

QT_END_NAMESPACE

#endif // QT_NO_STYLE_WINDOWSMOBILE

