/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*          Copyright (c) 1985-2010 AT&T Intellectual Property          *
*                      and is licensed under the                       *
*                  Common Public License, Version 1.0                  *
*                    by AT&T Intellectual Property                     *
*                                                                      *
*                A copy of the License is available at                 *
*            http://www.opensource.org/licenses/cpl1.0.txt             *
*         (with md5 checksum 059e8cd6165cb4c31e351f2b69388fd9)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                  David Korn <dgk@research.att.com>                   *
*                   Phong Vo <kpv@research.att.com>                    *
*                                                                      *
***********************************************************************/

/* : : generated by proto : : */

#if !defined(__PROTO__)
#  if defined(__STDC__) || defined(__cplusplus) || defined(_proto) || defined(c_plusplus)
#    if defined(__cplusplus)
#      define __LINKAGE__	"C"
#    else
#      define __LINKAGE__
#    endif
#    define __STDARG__
#    define __PROTO__(x)	x
#    define __OTORP__(x)
#    define __PARAM__(n,o)	n
#    if !defined(__STDC__) && !defined(__cplusplus)
#      if !defined(c_plusplus)
#      	define const
#      endif
#      define signed
#      define void		int
#      define volatile
#      define __V_		char
#    else
#      define __V_		void
#    endif
#  else
#    define __PROTO__(x)	()
#    define __OTORP__(x)	x
#    define __PARAM__(n,o)	o
#    define __LINKAGE__
#    define __V_		char
#    define const
#    define signed
#    define void		int
#    define volatile
#  endif
#  define __MANGLE__	__LINKAGE__
#  if defined(__cplusplus) || defined(c_plusplus)
#    define __VARARG__	...
#  else
#    define __VARARG__
#  endif
#  if defined(__STDARG__)
#    define __VA_START__(p,a)	va_start(p,a)
#  else
#    define __VA_START__(p,a)	va_start(p)
#  endif
#  if !defined(__INLINE__)
#    if defined(__cplusplus)
#      define __INLINE__	extern __MANGLE__ inline
#    else
#      if defined(_WIN32) && !defined(__GNUC__)
#      	define __INLINE__	__inline
#      endif
#    endif
#  endif
#endif
#if !defined(__LINKAGE__)
#define __LINKAGE__		/* 2004-08-11 transition */
#endif
#include <ast.h>
#include <error.h>

#if _UWIN

NoN(sysconf)

#else

/* : : generated by conf from /home/gsf/src/lib/libast/comp/conf.tab : : */

#include "confmap.h"
#include "conflib.h"
#include "FEATURE/unistd"
#include "FEATURE/limits"

_ast_intmax_t
sysconf __PARAM__((int op), (op)) __OTORP__(int op;){
	int	n;
#if _lib_sysconf
#undef	sysconf
	if ((n = op) >= 0 || -op <= confmap[0] && (n = confmap[-op]) >= 0)
	{
		_ast_intmax_t	val;
		int		olderrno;
		int		syserrno;

		olderrno = errno;
		errno = 0;
		val = sysconf(n);
		syserrno = errno;
		errno = olderrno;
		if (val != -1L || syserrno == 0)
			return(val);
	}
#endif
	switch (op)
	{
#if	_SC_ADVISORY_INFO+0
case _SC_ADVISORY_INFO:
#ifdef	ADVISORY_INFO
		return(ADVISORY_INFO-0);
#else
#ifdef	_POSIX_ADVISORY_INFO
		return(_POSIX_ADVISORY_INFO-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_AIO_LISTIO_MAX+0
case _SC_AIO_LISTIO_MAX:
#ifdef	AIO_LISTIO_MAX
		return(AIO_LISTIO_MAX-0);
#else
#ifdef	_POSIX_AIO_LISTIO_MAX
		return(_POSIX_AIO_LISTIO_MAX-0);
#else
		return(2-0);
#endif
#endif
#endif
#if	_SC_AIO_MAX+0
case _SC_AIO_MAX:
#ifdef	AIO_MAX
		return(AIO_MAX-0);
#else
#ifdef	_POSIX_AIO_MAX
		return(_POSIX_AIO_MAX-0);
#else
		return(1-0);
#endif
#endif
#endif
#if	_SC_AIO_PRIO_DELTA_MAX+0
case _SC_AIO_PRIO_DELTA_MAX:
#ifdef	AIO_PRIO_DELTA_MAX
		return(AIO_PRIO_DELTA_MAX-0);
#else
#ifdef	_POSIX_AIO_PRIO_DELTA_MAX
		return(_POSIX_AIO_PRIO_DELTA_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_ARG_MAX+0
case _SC_ARG_MAX:
#ifdef	ARG_MAX
		return(ARG_MAX-0);
#else
#ifdef	NCARGS
		return(NCARGS-0);
#else
#ifdef	_POSIX_ARG_MAX
		return(_POSIX_ARG_MAX-0);
#else
		return(4096-0);
#endif
#endif
#endif
#endif
#if	_SC_ASYNCHRONOUS_IO+0
case _SC_ASYNCHRONOUS_IO:
#ifdef	ASYNCHRONOUS_IO
		return(ASYNCHRONOUS_IO-0);
#else
#ifdef	_POSIX_ASYNCHRONOUS_IO
		return(_POSIX_ASYNCHRONOUS_IO-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_ATEXIT_MAX+0
case _SC_ATEXIT_MAX:
#ifdef	ATEXIT_MAX
		return(ATEXIT_MAX-0);
#else
#ifdef	_XOPEN_ATEXIT_MAX
		return(_XOPEN_ATEXIT_MAX-0);
#else
		return(32-0);
#endif
#endif
#endif
#if	_SC_AVPHYS_PAGES+0
case _SC_AVPHYS_PAGES:
#ifdef	AVPHYS_PAGES
		return(AVPHYS_PAGES-0);
#else
		break;
#endif
#endif
#if	_SC_BARRIERS+0
case _SC_BARRIERS:
#ifdef	BARRIERS
		return(BARRIERS-0);
#else
#ifdef	_POSIX_BARRIERS
		return(_POSIX_BARRIERS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_BASE+0
case _SC_BASE:
#ifdef	BASE
		return(BASE-0);
#else
#ifdef	_POSIX_BASE
		return(_POSIX_BASE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_BC_BASE_MAX+0
case _SC_BC_BASE_MAX:
#ifdef	BC_BASE_MAX
		return(BC_BASE_MAX-0);
#else
#ifdef	_POSIX2_BC_BASE_MAX
		return(_POSIX2_BC_BASE_MAX-0);
#else
		return(99-0);
#endif
#endif
#endif
#if	_SC_BC_DIM_MAX+0
case _SC_BC_DIM_MAX:
#ifdef	BC_DIM_MAX
		return(BC_DIM_MAX-0);
#else
#ifdef	_POSIX2_BC_DIM_MAX
		return(_POSIX2_BC_DIM_MAX-0);
#else
		return(2048-0);
#endif
#endif
#endif
#if	_SC_BC_SCALE_MAX+0
case _SC_BC_SCALE_MAX:
#ifdef	BC_SCALE_MAX
		return(BC_SCALE_MAX-0);
#else
#ifdef	_POSIX2_BC_SCALE_MAX
		return(_POSIX2_BC_SCALE_MAX-0);
#else
		return(99-0);
#endif
#endif
#endif
#if	_SC_BC_STRING_MAX+0
case _SC_BC_STRING_MAX:
#ifdef	BC_STRING_MAX
		return(BC_STRING_MAX-0);
#else
#ifdef	_POSIX2_BC_STRING_MAX
		return(_POSIX2_BC_STRING_MAX-0);
#else
		return(1000-0);
#endif
#endif
#endif
#if	_SC_CHARCLASS_NAME_MAX+0
case _SC_CHARCLASS_NAME_MAX:
#ifdef	CHARCLASS_NAME_MAX
		return(CHARCLASS_NAME_MAX-0);
#else
#ifdef	_POSIX_CHARCLASS_NAME_MAX
		return(_POSIX_CHARCLASS_NAME_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_CHAR_BIT+0
case _SC_CHAR_BIT:
#ifdef	CHAR_BIT
		return(CHAR_BIT-0);
#else
#ifdef	_POSIX_CHAR_BIT
		return(_POSIX_CHAR_BIT-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_CHAR_MAX+0
case _SC_CHAR_MAX:
#ifdef	CHAR_MAX
		return(CHAR_MAX-0);
#else
#ifdef	_POSIX_CHAR_MAX
		return(_POSIX_CHAR_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_CHAR_MIN+0
case _SC_CHAR_MIN:
#ifdef	CHAR_MIN
		return(CHAR_MIN-0);
#else
#ifdef	_POSIX_CHAR_MIN
		return(_POSIX_CHAR_MIN-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_2_CHAR_TERM+0
case _SC_2_CHAR_TERM:
#ifdef	_POSIX2_CHAR_TERM
		return(_POSIX2_CHAR_TERM-0);
#else
		break;
#endif
#endif
#if	_SC_CHILD_MAX+0
case _SC_CHILD_MAX:
#ifdef	CHILD_MAX
		return(CHILD_MAX-0);
#else
#ifdef	_LOCAL_CHILD_MAX
		return(_LOCAL_CHILD_MAX-0);
#else
#ifdef	_POSIX_CHILD_MAX
		return(_POSIX_CHILD_MAX-0);
#else
		return(6-0);
#endif
#endif
#endif
#endif
#if	_SC_CKPT+0
case _SC_CKPT:
#ifdef	CKPT
		return(CKPT-0);
#else
#ifdef	_POSIX_CKPT
		return(_POSIX_CKPT-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_CLK_TCK+0
case _SC_CLK_TCK:
#ifdef	CLK_TCK
		return(CLK_TCK-0);
#else
#ifdef	HZ
		return(HZ-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_CLOCKRES_MIN+0
case _SC_CLOCKRES_MIN:
#ifdef	CLOCKRES_MIN
		return(CLOCKRES_MIN-0);
#else
#ifdef	_POSIX_CLOCKRES_MIN
		return(_POSIX_CLOCKRES_MIN-0);
#else
		return(1-0);
#endif
#endif
#endif
#if	_SC_CLOCK_SELECTION+0
case _SC_CLOCK_SELECTION:
#ifdef	CLOCK_SELECTION
		return(CLOCK_SELECTION-0);
#else
#ifdef	_POSIX_CLOCK_SELECTION
		return(_POSIX_CLOCK_SELECTION-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_COLL_WEIGHTS_MAX+0
case _SC_COLL_WEIGHTS_MAX:
#ifdef	COLL_WEIGHTS_MAX
		return(COLL_WEIGHTS_MAX-0);
#else
#ifdef	_POSIX2_COLL_WEIGHTS_MAX
		return(_POSIX2_COLL_WEIGHTS_MAX-0);
#else
		return(2-0);
#endif
#endif
#endif
#if	_SC_CPUTIME+0
case _SC_CPUTIME:
#ifdef	CPUTIME
		return(CPUTIME-0);
#else
#ifdef	_POSIX_CPUTIME
		return(_POSIX_CPUTIME-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XOPEN_CRYPT+0
case _SC_XOPEN_CRYPT:
#ifdef	CRYPT
		return(CRYPT-0);
#else
#ifdef	_XOPEN_CRYPT
		return(_XOPEN_CRYPT-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_2_C_BIND+0
case _SC_2_C_BIND:
#ifdef	_POSIX2_C_BIND
		return(_POSIX2_C_BIND-0);
#else
		break;
#endif
#endif
#if	_SC_2_C_DEV+0
case _SC_2_C_DEV:
#ifdef	_POSIX2_C_DEV
		return(_POSIX2_C_DEV-0);
#else
		break;
#endif
#endif
#if	_SC_2_C_VERSION+0
case _SC_2_C_VERSION:
#ifdef	_POSIX2_C_VERSION
		return(_POSIX2_C_VERSION-0);
#else
		break;
#endif
#endif
#if	_SC_DELAYTIMER_MAX+0
case _SC_DELAYTIMER_MAX:
#ifdef	DELAYTIMER_MAX
		return(DELAYTIMER_MAX-0);
#else
#ifdef	_POSIX_DELAYTIMER_MAX
		return(_POSIX_DELAYTIMER_MAX-0);
#else
		return(32-0);
#endif
#endif
#endif
#if	_SC_DEVICE_IO+0
case _SC_DEVICE_IO:
#ifdef	DEVICE_IO
		return(DEVICE_IO-0);
#else
#ifdef	_POSIX_DEVICE_IO
		return(_POSIX_DEVICE_IO-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_DEVICE_SPECIFIC+0
case _SC_DEVICE_SPECIFIC:
#ifdef	DEVICE_SPECIFIC
		return(DEVICE_SPECIFIC-0);
#else
#ifdef	_POSIX_DEVICE_SPECIFIC
		return(_POSIX_DEVICE_SPECIFIC-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_DEVICE_SPECIFIC_R+0
case _SC_DEVICE_SPECIFIC_R:
#ifdef	DEVICE_SPECIFIC_R
		return(DEVICE_SPECIFIC_R-0);
#else
#ifdef	_POSIX_DEVICE_SPECIFIC_R
		return(_POSIX_DEVICE_SPECIFIC_R-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XOPEN_ENH_I18N+0
case _SC_XOPEN_ENH_I18N:
#ifdef	ENH_I18N
		return(ENH_I18N-0);
#else
#ifdef	_XOPEN_ENH_I18N
		return(_XOPEN_ENH_I18N-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_EQUIV_CLASS_MAX+0
case _SC_EQUIV_CLASS_MAX:
#ifdef	EQUIV_CLASS_MAX
		return(EQUIV_CLASS_MAX-0);
#else
#ifdef	_POSIX_EQUIV_CLASS_MAX
		return(_POSIX_EQUIV_CLASS_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_EXPR_NEST_MAX+0
case _SC_EXPR_NEST_MAX:
#ifdef	EXPR_NEST_MAX
		return(EXPR_NEST_MAX-0);
#else
#ifdef	_POSIX2_EXPR_NEST_MAX
		return(_POSIX2_EXPR_NEST_MAX-0);
#else
		return(32-0);
#endif
#endif
#endif
#if	_SC_FCHR_MAX+0
case _SC_FCHR_MAX:
#ifdef	FCHR_MAX
		return(FCHR_MAX-0);
#else
#ifdef	LONG_MAX
		return(LONG_MAX-0);
#else
#ifdef	_SVID_FCHR_MAX
		return(_SVID_FCHR_MAX-0);
#else
		return(2147483647-0);
#endif
#endif
#endif
#endif
#if	_SC_FD_MGMT+0
case _SC_FD_MGMT:
#ifdef	FD_MGMT
		return(FD_MGMT-0);
#else
#ifdef	_POSIX_FD_MGMT
		return(_POSIX_FD_MGMT-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_FIFO+0
case _SC_FIFO:
#ifdef	FIFO
		return(FIFO-0);
#else
#ifdef	_POSIX_FIFO
		return(_POSIX_FIFO-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_FILE_ATTRIBUTES+0
case _SC_FILE_ATTRIBUTES:
#ifdef	FILE_ATTRIBUTES
		return(FILE_ATTRIBUTES-0);
#else
#ifdef	_POSIX_FILE_ATTRIBUTES
		return(_POSIX_FILE_ATTRIBUTES-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_FILE_LOCKING+0
case _SC_FILE_LOCKING:
#ifdef	FILE_LOCKING
		return(FILE_LOCKING-0);
#else
#ifdef	_POSIX_FILE_LOCKING
		return(_POSIX_FILE_LOCKING-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_FILE_SYSTEM+0
case _SC_FILE_SYSTEM:
#ifdef	FILE_SYSTEM
		return(FILE_SYSTEM-0);
#else
#ifdef	_POSIX_FILE_SYSTEM
		return(_POSIX_FILE_SYSTEM-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_2_FORT_DEV+0
case _SC_2_FORT_DEV:
#ifdef	_POSIX2_FORT_DEV
		return(_POSIX2_FORT_DEV-0);
#else
		break;
#endif
#endif
#if	_SC_2_FORT_RUN+0
case _SC_2_FORT_RUN:
#ifdef	_POSIX2_FORT_RUN
		return(_POSIX2_FORT_RUN-0);
#else
		break;
#endif
#endif
#if	_SC_FSYNC+0
case _SC_FSYNC:
#ifdef	FSYNC
		return(FSYNC-0);
#else
#ifdef	_lib_fsync
		return(_lib_fsync-0);
#else
#ifdef	_POSIX_FSYNC
		return(_POSIX_FSYNC-0);
#else
		break;
#endif
#endif
#endif
#endif
#if	_SC_GETGR_R_SIZE_MAX+0
case _SC_GETGR_R_SIZE_MAX:
#ifdef	GETGR_R_SIZE_MAX
		return(GETGR_R_SIZE_MAX-0);
#else
#ifdef	_POSIX_GETGR_R_SIZE_MAX
		return(_POSIX_GETGR_R_SIZE_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_GETPW_R_SIZE_MAX+0
case _SC_GETPW_R_SIZE_MAX:
#ifdef	GETPW_R_SIZE_MAX
		return(GETPW_R_SIZE_MAX-0);
#else
#ifdef	_POSIX_GETPW_R_SIZE_MAX
		return(_POSIX_GETPW_R_SIZE_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_HOST_NAME_MAX+0
case _SC_HOST_NAME_MAX:
#ifdef	HOST_NAME_MAX
		return(HOST_NAME_MAX-0);
#else
#ifdef	_POSIX_HOST_NAME_MAX
		return(_POSIX_HOST_NAME_MAX-0);
#else
		return(255-0);
#endif
#endif
#endif
#if	_SC_XBS5_ILP32_OFF32+0
case _SC_XBS5_ILP32_OFF32:
#ifdef	ILP32_OFF32
		return(ILP32_OFF32-0);
#else
#ifdef	_XBS5_ILP32_OFF32
		return(_XBS5_ILP32_OFF32-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XBS5_ILP32_OFFBIG+0
case _SC_XBS5_ILP32_OFFBIG:
#ifdef	ILP32_OFFBIG
		return(ILP32_OFFBIG-0);
#else
#ifdef	_XBS5_ILP32_OFFBIG
		return(_XBS5_ILP32_OFFBIG-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_INT_MAX+0
case _SC_INT_MAX:
#ifdef	INT_MAX
		return(INT_MAX-0);
#else
#ifdef	_POSIX_INT_MAX
		return(_POSIX_INT_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_INT_MIN+0
case _SC_INT_MIN:
#ifdef	INT_MIN
		return(INT_MIN-0);
#else
#ifdef	_POSIX_INT_MIN
		return(_POSIX_INT_MIN-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_IOV_MAX+0
case _SC_IOV_MAX:
#ifdef	IOV_MAX
		return(IOV_MAX-0);
#else
#ifdef	_XOPEN_IOV_MAX
		return(_XOPEN_IOV_MAX-0);
#else
		return(16-0);
#endif
#endif
#endif
#if	_SC_IPV6+0
case _SC_IPV6:
#ifdef	IPV6
		return(IPV6-0);
#else
#ifdef	_POSIX_IPV6
		return(_POSIX_IPV6-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_JOB_CONTROL+0
case _SC_JOB_CONTROL:
#ifdef	JOB_CONTROL
		return(JOB_CONTROL-0);
#else
#ifdef	_LOCAL_JOB_CONTROL
		return(_LOCAL_JOB_CONTROL-0);
#else
#ifdef	_POSIX_JOB_CONTROL
		return(_POSIX_JOB_CONTROL-0);
#else
		break;
#endif
#endif
#endif
#endif
#if	_SC_KERNEL_CLIST+0
case _SC_KERNEL_CLIST:
#ifdef	KERNEL_CLIST
		return(KERNEL_CLIST-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_CLIST_MAX+0
case _SC_KERNEL_CLIST_MAX:
#ifdef	KERNEL_CLIST_MAX
		return(KERNEL_CLIST_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_DISK+0
case _SC_KERNEL_DISK:
#ifdef	KERNEL_DISK
		return(KERNEL_DISK-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_DISK_MAX+0
case _SC_KERNEL_DISK_MAX:
#ifdef	KERNEL_DISK_MAX
		return(KERNEL_DISK_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_DMABUF+0
case _SC_KERNEL_DMABUF:
#ifdef	KERNEL_DMABUF
		return(KERNEL_DMABUF-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_DMABUF_MAX+0
case _SC_KERNEL_DMABUF_MAX:
#ifdef	KERNEL_DMABUF_MAX
		return(KERNEL_DMABUF_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_FILE+0
case _SC_KERNEL_FILE:
#ifdef	KERNEL_FILE
		return(KERNEL_FILE-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_FILE_MAX+0
case _SC_KERNEL_FILE_MAX:
#ifdef	KERNEL_FILE_MAX
		return(KERNEL_FILE_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_FLCKREC+0
case _SC_KERNEL_FLCKREC:
#ifdef	KERNEL_FLCKREC
		return(KERNEL_FLCKREC-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_FLCKREC_MAX+0
case _SC_KERNEL_FLCKREC_MAX:
#ifdef	KERNEL_FLCKREC_MAX
		return(KERNEL_FLCKREC_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_INODE+0
case _SC_KERNEL_INODE:
#ifdef	KERNEL_INODE
		return(KERNEL_INODE-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_INODE_MAX+0
case _SC_KERNEL_INODE_MAX:
#ifdef	KERNEL_INODE_MAX
		return(KERNEL_INODE_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_MOUNT+0
case _SC_KERNEL_MOUNT:
#ifdef	KERNEL_MOUNT
		return(KERNEL_MOUNT-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_MOUNT_MAX+0
case _SC_KERNEL_MOUNT_MAX:
#ifdef	KERNEL_MOUNT_MAX
		return(KERNEL_MOUNT_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_PINODE+0
case _SC_KERNEL_PINODE:
#ifdef	KERNEL_PINODE
		return(KERNEL_PINODE-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_PINODE_MAX+0
case _SC_KERNEL_PINODE_MAX:
#ifdef	KERNEL_PINODE_MAX
		return(KERNEL_PINODE_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_PROC+0
case _SC_KERNEL_PROC:
#ifdef	KERNEL_PROC
		return(KERNEL_PROC-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_PROC_MAX+0
case _SC_KERNEL_PROC_MAX:
#ifdef	KERNEL_PROC_MAX
		return(KERNEL_PROC_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_REGION+0
case _SC_KERNEL_REGION:
#ifdef	KERNEL_REGION
		return(KERNEL_REGION-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_REGION_MAX+0
case _SC_KERNEL_REGION_MAX:
#ifdef	KERNEL_REGION_MAX
		return(KERNEL_REGION_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_S5INODE+0
case _SC_KERNEL_S5INODE:
#ifdef	KERNEL_S5INODE
		return(KERNEL_S5INODE-0);
#else
		break;
#endif
#endif
#if	_SC_KERNEL_S5INODE_MAX+0
case _SC_KERNEL_S5INODE_MAX:
#ifdef	KERNEL_S5INODE_MAX
		return(KERNEL_S5INODE_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_C_LANG_SUPPORT+0
case _SC_C_LANG_SUPPORT:
#ifdef	LANG_SUPPORT
		return(LANG_SUPPORT-0);
#else
		break;
#endif
#endif
#if	_SC_C_LANG_SUPPORT_R+0
case _SC_C_LANG_SUPPORT_R:
#ifdef	LANG_SUPPORT_R
		return(LANG_SUPPORT_R-0);
#else
		break;
#endif
#endif
#if	_SC_XOPEN_LEGACY+0
case _SC_XOPEN_LEGACY:
#ifdef	LEGACY
		return(LEGACY-0);
#else
#ifdef	_XOPEN_LEGACY
		return(_XOPEN_LEGACY-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL1_DCACHE_ASSOC+0
case _SC_LEVEL1_DCACHE_ASSOC:
#ifdef	LEVEL1_DCACHE_ASSOC
		return(LEVEL1_DCACHE_ASSOC-0);
#else
#ifdef	_POSIX_LEVEL1_DCACHE_ASSOC
		return(_POSIX_LEVEL1_DCACHE_ASSOC-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL1_DCACHE_LINESIZE+0
case _SC_LEVEL1_DCACHE_LINESIZE:
#ifdef	LEVEL1_DCACHE_LINESIZE
		return(LEVEL1_DCACHE_LINESIZE-0);
#else
#ifdef	_POSIX_LEVEL1_DCACHE_LINESIZE
		return(_POSIX_LEVEL1_DCACHE_LINESIZE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL1_DCACHE_SIZE+0
case _SC_LEVEL1_DCACHE_SIZE:
#ifdef	LEVEL1_DCACHE_SIZE
		return(LEVEL1_DCACHE_SIZE-0);
#else
#ifdef	_POSIX_LEVEL1_DCACHE_SIZE
		return(_POSIX_LEVEL1_DCACHE_SIZE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL1_ICACHE_ASSOC+0
case _SC_LEVEL1_ICACHE_ASSOC:
#ifdef	LEVEL1_ICACHE_ASSOC
		return(LEVEL1_ICACHE_ASSOC-0);
#else
#ifdef	_POSIX_LEVEL1_ICACHE_ASSOC
		return(_POSIX_LEVEL1_ICACHE_ASSOC-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL1_ICACHE_LINESIZE+0
case _SC_LEVEL1_ICACHE_LINESIZE:
#ifdef	LEVEL1_ICACHE_LINESIZE
		return(LEVEL1_ICACHE_LINESIZE-0);
#else
#ifdef	_POSIX_LEVEL1_ICACHE_LINESIZE
		return(_POSIX_LEVEL1_ICACHE_LINESIZE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL1_ICACHE_SIZE+0
case _SC_LEVEL1_ICACHE_SIZE:
#ifdef	LEVEL1_ICACHE_SIZE
		return(LEVEL1_ICACHE_SIZE-0);
#else
#ifdef	_POSIX_LEVEL1_ICACHE_SIZE
		return(_POSIX_LEVEL1_ICACHE_SIZE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL2_CACHE_ASSOC+0
case _SC_LEVEL2_CACHE_ASSOC:
#ifdef	LEVEL2_CACHE_ASSOC
		return(LEVEL2_CACHE_ASSOC-0);
#else
#ifdef	_POSIX_LEVEL2_CACHE_ASSOC
		return(_POSIX_LEVEL2_CACHE_ASSOC-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL2_CACHE_LINESIZE+0
case _SC_LEVEL2_CACHE_LINESIZE:
#ifdef	LEVEL2_CACHE_LINESIZE
		return(LEVEL2_CACHE_LINESIZE-0);
#else
#ifdef	_POSIX_LEVEL2_CACHE_LINESIZE
		return(_POSIX_LEVEL2_CACHE_LINESIZE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL2_CACHE_SIZE+0
case _SC_LEVEL2_CACHE_SIZE:
#ifdef	LEVEL2_CACHE_SIZE
		return(LEVEL2_CACHE_SIZE-0);
#else
#ifdef	_POSIX_LEVEL2_CACHE_SIZE
		return(_POSIX_LEVEL2_CACHE_SIZE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL3_CACHE_ASSOC+0
case _SC_LEVEL3_CACHE_ASSOC:
#ifdef	LEVEL3_CACHE_ASSOC
		return(LEVEL3_CACHE_ASSOC-0);
#else
#ifdef	_POSIX_LEVEL3_CACHE_ASSOC
		return(_POSIX_LEVEL3_CACHE_ASSOC-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL3_CACHE_LINESIZE+0
case _SC_LEVEL3_CACHE_LINESIZE:
#ifdef	LEVEL3_CACHE_LINESIZE
		return(LEVEL3_CACHE_LINESIZE-0);
#else
#ifdef	_POSIX_LEVEL3_CACHE_LINESIZE
		return(_POSIX_LEVEL3_CACHE_LINESIZE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL3_CACHE_SIZE+0
case _SC_LEVEL3_CACHE_SIZE:
#ifdef	LEVEL3_CACHE_SIZE
		return(LEVEL3_CACHE_SIZE-0);
#else
#ifdef	_POSIX_LEVEL3_CACHE_SIZE
		return(_POSIX_LEVEL3_CACHE_SIZE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL4_CACHE_ASSOC+0
case _SC_LEVEL4_CACHE_ASSOC:
#ifdef	LEVEL4_CACHE_ASSOC
		return(LEVEL4_CACHE_ASSOC-0);
#else
#ifdef	_POSIX_LEVEL4_CACHE_ASSOC
		return(_POSIX_LEVEL4_CACHE_ASSOC-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL4_CACHE_LINESIZE+0
case _SC_LEVEL4_CACHE_LINESIZE:
#ifdef	LEVEL4_CACHE_LINESIZE
		return(LEVEL4_CACHE_LINESIZE-0);
#else
#ifdef	_POSIX_LEVEL4_CACHE_LINESIZE
		return(_POSIX_LEVEL4_CACHE_LINESIZE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LEVEL4_CACHE_SIZE+0
case _SC_LEVEL4_CACHE_SIZE:
#ifdef	LEVEL4_CACHE_SIZE
		return(LEVEL4_CACHE_SIZE-0);
#else
#ifdef	_POSIX_LEVEL4_CACHE_SIZE
		return(_POSIX_LEVEL4_CACHE_SIZE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LINE_MAX+0
case _SC_LINE_MAX:
#ifdef	LINE_MAX
		return(LINE_MAX-0);
#else
#ifdef	_POSIX2_LINE_MAX
		return(_POSIX2_LINE_MAX-0);
#else
		return(2048-0);
#endif
#endif
#endif
#if	_SC_2_LOCALEDEF+0
case _SC_2_LOCALEDEF:
#ifdef	_POSIX2_LOCALEDEF
		return(_POSIX2_LOCALEDEF-0);
#else
		break;
#endif
#endif
#if	_SC_LOGIN_NAME_MAX+0
case _SC_LOGIN_NAME_MAX:
#ifdef	LOGIN_NAME_MAX
		return(LOGIN_NAME_MAX-0);
#else
#ifdef	_POSIX_LOGIN_NAME_MAX
		return(_POSIX_LOGIN_NAME_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_LOGNAME_MAX+0
case _SC_LOGNAME_MAX:
#ifdef	LOGNAME_MAX
		return(LOGNAME_MAX-0);
#else
#ifdef	_SVID_LOGNAME_MAX
		return(_SVID_LOGNAME_MAX-0);
#else
		return(8-0);
#endif
#endif
#endif
#if	_SC_LONG_BIT+0
case _SC_LONG_BIT:
#ifdef	LONG_BIT
		return(LONG_BIT-0);
#else
#ifdef	_POSIX_LONG_BIT
		return(_POSIX_LONG_BIT-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XBS5_LP64_OFF64+0
case _SC_XBS5_LP64_OFF64:
#ifdef	LP64_OFF64
		return(LP64_OFF64-0);
#else
#ifdef	_XBS5_LP64_OFF64
		return(_XBS5_LP64_OFF64-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XBS5_LPBIG_OFFBIG+0
case _SC_XBS5_LPBIG_OFFBIG:
#ifdef	LPBIG_OFFBIG
		return(LPBIG_OFFBIG-0);
#else
#ifdef	_XBS5_LPBIG_OFFBIG
		return(_XBS5_LPBIG_OFFBIG-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_MAPPED_FILES+0
case _SC_MAPPED_FILES:
#ifdef	MAPPED_FILES
		return(MAPPED_FILES-0);
#else
#ifdef	_lib_mmap
		return(_lib_mmap-0);
#else
#ifdef	_POSIX_MAPPED_FILES
		return(_POSIX_MAPPED_FILES-0);
#else
		break;
#endif
#endif
#endif
#endif
#if	_SC_MB_LEN_MAX+0
case _SC_MB_LEN_MAX:
#ifdef	MB_LEN_MAX
		return(MB_LEN_MAX-0);
#else
#ifdef	_POSIX_MB_LEN_MAX
		return(_POSIX_MB_LEN_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_MEMLOCK+0
case _SC_MEMLOCK:
#ifdef	MEMLOCK
		return(MEMLOCK-0);
#else
#ifdef	_POSIX_MEMLOCK
		return(_POSIX_MEMLOCK-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_MEMLOCK_RANGE+0
case _SC_MEMLOCK_RANGE:
#ifdef	MEMLOCK_RANGE
		return(MEMLOCK_RANGE-0);
#else
#ifdef	_POSIX_MEMLOCK_RANGE
		return(_POSIX_MEMLOCK_RANGE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_MEMORY_PROTECTION+0
case _SC_MEMORY_PROTECTION:
#ifdef	MEMORY_PROTECTION
		return(MEMORY_PROTECTION-0);
#else
#ifdef	_POSIX_MEMORY_PROTECTION
		return(_POSIX_MEMORY_PROTECTION-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_MESSAGE_PASSING+0
case _SC_MESSAGE_PASSING:
#ifdef	MESSAGE_PASSING
		return(MESSAGE_PASSING-0);
#else
#ifdef	_POSIX_MESSAGE_PASSING
		return(_POSIX_MESSAGE_PASSING-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_MONOTONIC_CLOCK+0
case _SC_MONOTONIC_CLOCK:
#ifdef	MONOTONIC_CLOCK
		return(MONOTONIC_CLOCK-0);
#else
#ifdef	_POSIX_MONOTONIC_CLOCK
		return(_POSIX_MONOTONIC_CLOCK-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_MQ_OPEN_MAX+0
case _SC_MQ_OPEN_MAX:
#ifdef	MQ_OPEN_MAX
		return(MQ_OPEN_MAX-0);
#else
#ifdef	_POSIX_MQ_OPEN_MAX
		return(_POSIX_MQ_OPEN_MAX-0);
#else
		return(8-0);
#endif
#endif
#endif
#if	_SC_MQ_PRIO_MAX+0
case _SC_MQ_PRIO_MAX:
#ifdef	MQ_PRIO_MAX
		return(MQ_PRIO_MAX-0);
#else
#ifdef	_POSIX_MQ_PRIO_MAX
		return(_POSIX_MQ_PRIO_MAX-0);
#else
		return(32-0);
#endif
#endif
#endif
#if	_SC_MULTI_PROCESS+0
case _SC_MULTI_PROCESS:
#ifdef	MULTI_PROCESS
		return(MULTI_PROCESS-0);
#else
#ifdef	_POSIX_MULTI_PROCESS
		return(_POSIX_MULTI_PROCESS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_NACLS_MAX+0
case _SC_NACLS_MAX:
#ifdef	NACLS_MAX
		return(NACLS_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_NETWORKING+0
case _SC_NETWORKING:
#ifdef	NETWORKING
		return(NETWORKING-0);
#else
#ifdef	_POSIX_NETWORKING
		return(_POSIX_NETWORKING-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_NGROUPS_MAX+0
case _SC_NGROUPS_MAX:
#ifdef	NGROUPS_MAX
		return(NGROUPS_MAX-0);
#else
#ifdef	_LOCAL_NGROUPS_MAX
		return(_LOCAL_NGROUPS_MAX-0);
#else
#ifdef	_POSIX_NGROUPS_MAX
		return(_POSIX_NGROUPS_MAX-0);
#else
		return(8-0);
#endif
#endif
#endif
#endif
#if	_SC_NL_ARGMAX+0
case _SC_NL_ARGMAX:
#ifdef	NL_ARGMAX
		return(NL_ARGMAX-0);
#else
#ifdef	_POSIX_NL_ARGMAX
		return(_POSIX_NL_ARGMAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_NL_LANGMAX+0
case _SC_NL_LANGMAX:
#ifdef	NL_LANGMAX
		return(NL_LANGMAX-0);
#else
#ifdef	_POSIX_NL_LANGMAX
		return(_POSIX_NL_LANGMAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_NL_MSGMAX+0
case _SC_NL_MSGMAX:
#ifdef	NL_MSGMAX
		return(NL_MSGMAX-0);
#else
#ifdef	_POSIX_NL_MSGMAX
		return(_POSIX_NL_MSGMAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_NL_NMAX+0
case _SC_NL_NMAX:
#ifdef	NL_NMAX
		return(NL_NMAX-0);
#else
#ifdef	_POSIX_NL_NMAX
		return(_POSIX_NL_NMAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_NL_SETMAX+0
case _SC_NL_SETMAX:
#ifdef	NL_SETMAX
		return(NL_SETMAX-0);
#else
#ifdef	_POSIX_NL_SETMAX
		return(_POSIX_NL_SETMAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_NL_TEXTMAX+0
case _SC_NL_TEXTMAX:
#ifdef	NL_TEXTMAX
		return(NL_TEXTMAX-0);
#else
#ifdef	_POSIX_NL_TEXTMAX
		return(_POSIX_NL_TEXTMAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_NPROCESSORS_CONF+0
case _SC_NPROCESSORS_CONF:
#ifdef	NPROCESSORS_CONF
		return(NPROCESSORS_CONF-0);
#else
		break;
#endif
#endif
#if	_SC_NPROCESSORS_ONLN+0
case _SC_NPROCESSORS_ONLN:
#ifdef	NPROCESSORS_ONLN
		return(NPROCESSORS_ONLN-0);
#else
		break;
#endif
#endif
#if	_SC_NZERO+0
case _SC_NZERO:
#ifdef	NZERO
		return(NZERO-0);
#else
#ifdef	_POSIX_NZERO
		return(_POSIX_NZERO-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_OPEN_MAX+0
case _SC_OPEN_MAX:
#ifdef	OPEN_MAX
		return(OPEN_MAX-0);
#else
#ifdef	_LOCAL_OPEN_MAX
		return(_LOCAL_OPEN_MAX-0);
#else
#ifdef	_POSIX_OPEN_MAX
		return(_POSIX_OPEN_MAX-0);
#else
		return(16-0);
#endif
#endif
#endif
#endif
#if	_SC_AES_OS_VERSION+0
case _SC_AES_OS_VERSION:
#ifdef	OS_VERSION
		return(OS_VERSION-0);
#else
#ifdef	_AES_OS_VERSION
		return(_AES_OS_VERSION-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PAGESIZE+0
case _SC_PAGESIZE:
#ifdef	PAGESIZE
		return(PAGESIZE-0);
#else
#ifdef	_LOCAL_PAGESIZE
		return(_LOCAL_PAGESIZE-0);
#else
#ifdef	PAGESIZE
		return(PAGESIZE-0);
#else
#ifdef	PAGE_SIZE
		return(PAGE_SIZE-0);
#else
#ifdef	_POSIX_PAGESIZE
		return(_POSIX_PAGESIZE-0);
#else
		return(4096-0);
#endif
#endif
#endif
#endif
#endif
#endif
#if	_SC_PAGE_SIZE+0
case _SC_PAGE_SIZE:
#ifdef	PAGE_SIZE
		return(PAGE_SIZE-0);
#else
#ifdef	_AST_PAGESIZE
		return(_AST_PAGESIZE-0);
#else
#ifdef	_POSIX_PAGE_SIZE
		return(_POSIX_PAGE_SIZE-0);
#else
		break;
#endif
#endif
#endif
#endif
#if	_SC_PASS_MAX+0
case _SC_PASS_MAX:
#ifdef	PASS_MAX
		return(PASS_MAX-0);
#else
#ifdef	_SVID_PASS_MAX
		return(_SVID_PASS_MAX-0);
#else
		return(8-0);
#endif
#endif
#endif
#if	_SC_2_PBS+0
case _SC_2_PBS:
#ifdef	_POSIX2_PBS
		return(_POSIX2_PBS-0);
#else
		break;
#endif
#endif
#if	_SC_2_PBS_ACCOUNTING+0
case _SC_2_PBS_ACCOUNTING:
#ifdef	_POSIX2_PBS_ACCOUNTING
		return(_POSIX2_PBS_ACCOUNTING-0);
#else
		break;
#endif
#endif
#if	_SC_2_PBS_CHECKPOINT+0
case _SC_2_PBS_CHECKPOINT:
#ifdef	_POSIX2_PBS_CHECKPOINT
		return(_POSIX2_PBS_CHECKPOINT-0);
#else
		break;
#endif
#endif
#if	_SC_2_PBS_LOCATE+0
case _SC_2_PBS_LOCATE:
#ifdef	_POSIX2_PBS_LOCATE
		return(_POSIX2_PBS_LOCATE-0);
#else
		break;
#endif
#endif
#if	_SC_2_PBS_MESSAGE+0
case _SC_2_PBS_MESSAGE:
#ifdef	_POSIX2_PBS_MESSAGE
		return(_POSIX2_PBS_MESSAGE-0);
#else
		break;
#endif
#endif
#if	_SC_2_PBS_TRACK+0
case _SC_2_PBS_TRACK:
#ifdef	_POSIX2_PBS_TRACK
		return(_POSIX2_PBS_TRACK-0);
#else
		break;
#endif
#endif
#if	_SC_PHYS_PAGES+0
case _SC_PHYS_PAGES:
#ifdef	PHYS_PAGES
		return(PHYS_PAGES-0);
#else
		break;
#endif
#endif
#if	_SC_PID_MAX+0
case _SC_PID_MAX:
#ifdef	PID_MAX
		return(PID_MAX-0);
#else
#ifdef	_LOCAL_PID_MAX
		return(_LOCAL_PID_MAX-0);
#else
#ifdef	_SVID_PID_MAX
		return(_SVID_PID_MAX-0);
#else
		break;
#endif
#endif
#endif
#endif
#if	_SC_PII+0
case _SC_PII:
#ifdef	PII
		return(PII-0);
#else
#ifdef	_POSIX_PII
		return(_POSIX_PII-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PII_INTERNET+0
case _SC_PII_INTERNET:
#ifdef	PII_INTERNET
		return(PII_INTERNET-0);
#else
#ifdef	_POSIX_PII_INTERNET
		return(_POSIX_PII_INTERNET-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PII_INTERNET_DGRAM+0
case _SC_PII_INTERNET_DGRAM:
#ifdef	PII_INTERNET_DGRAM
		return(PII_INTERNET_DGRAM-0);
#else
#ifdef	_POSIX_PII_INTERNET_DGRAM
		return(_POSIX_PII_INTERNET_DGRAM-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PII_INTERNET_STREAM+0
case _SC_PII_INTERNET_STREAM:
#ifdef	PII_INTERNET_STREAM
		return(PII_INTERNET_STREAM-0);
#else
#ifdef	_POSIX_PII_INTERNET_STREAM
		return(_POSIX_PII_INTERNET_STREAM-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PII_OSI+0
case _SC_PII_OSI:
#ifdef	PII_OSI
		return(PII_OSI-0);
#else
#ifdef	_POSIX_PII_OSI
		return(_POSIX_PII_OSI-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PII_OSI_CLTS+0
case _SC_PII_OSI_CLTS:
#ifdef	PII_OSI_CLTS
		return(PII_OSI_CLTS-0);
#else
#ifdef	_POSIX_PII_OSI_CLTS
		return(_POSIX_PII_OSI_CLTS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PII_OSI_COTS+0
case _SC_PII_OSI_COTS:
#ifdef	PII_OSI_COTS
		return(PII_OSI_COTS-0);
#else
#ifdef	_POSIX_PII_OSI_COTS
		return(_POSIX_PII_OSI_COTS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PII_OSI_M+0
case _SC_PII_OSI_M:
#ifdef	PII_OSI_M
		return(PII_OSI_M-0);
#else
#ifdef	_POSIX_PII_OSI_M
		return(_POSIX_PII_OSI_M-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PII_SOCKET+0
case _SC_PII_SOCKET:
#ifdef	PII_SOCKET
		return(PII_SOCKET-0);
#else
#ifdef	_POSIX_PII_SOCKET
		return(_POSIX_PII_SOCKET-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PII_XTI+0
case _SC_PII_XTI:
#ifdef	PII_XTI
		return(PII_XTI-0);
#else
#ifdef	_POSIX_PII_XTI
		return(_POSIX_PII_XTI-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PIPE+0
case _SC_PIPE:
#ifdef	PIPE
		return(PIPE-0);
#else
#ifdef	_POSIX_PIPE
		return(_POSIX_PIPE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_POLL+0
case _SC_POLL:
#ifdef	POLL
		return(POLL-0);
#else
#ifdef	_POSIX_POLL
		return(_POSIX_POLL-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PRIORITIZED_IO+0
case _SC_PRIORITIZED_IO:
#ifdef	PRIORITIZED_IO
		return(PRIORITIZED_IO-0);
#else
#ifdef	_POSIX_PRIORITIZED_IO
		return(_POSIX_PRIORITIZED_IO-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_PRIORITY_SCHEDULING+0
case _SC_PRIORITY_SCHEDULING:
#ifdef	PRIORITY_SCHEDULING
		return(PRIORITY_SCHEDULING-0);
#else
#ifdef	_POSIX_PRIORITY_SCHEDULING
		return(_POSIX_PRIORITY_SCHEDULING-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_RAW_SOCKETS+0
case _SC_RAW_SOCKETS:
#ifdef	RAW_SOCKETS
		return(RAW_SOCKETS-0);
#else
#ifdef	_POSIX_RAW_SOCKETS
		return(_POSIX_RAW_SOCKETS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_READER_WRITER_LOCKS+0
case _SC_READER_WRITER_LOCKS:
#ifdef	READER_WRITER_LOCKS
		return(READER_WRITER_LOCKS-0);
#else
#ifdef	_POSIX_READER_WRITER_LOCKS
		return(_POSIX_READER_WRITER_LOCKS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XOPEN_REALTIME+0
case _SC_XOPEN_REALTIME:
#ifdef	REALTIME
		return(REALTIME-0);
#else
#ifdef	_XOPEN_REALTIME
		return(_XOPEN_REALTIME-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_REALTIME_SIGNALS+0
case _SC_REALTIME_SIGNALS:
#ifdef	REALTIME_SIGNALS
		return(REALTIME_SIGNALS-0);
#else
#ifdef	_POSIX_REALTIME_SIGNALS
		return(_POSIX_REALTIME_SIGNALS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XOPEN_REALTIME_THREADS+0
case _SC_XOPEN_REALTIME_THREADS:
#ifdef	REALTIME_THREADS
		return(REALTIME_THREADS-0);
#else
#ifdef	_XOPEN_REALTIME_THREADS
		return(_XOPEN_REALTIME_THREADS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_REENTRANT_FUNCTIONS+0
case _SC_REENTRANT_FUNCTIONS:
#ifdef	REENTRANT_FUNCTIONS
		return(REENTRANT_FUNCTIONS-0);
#else
#ifdef	_POSIX_REENTRANT_FUNCTIONS
		return(_POSIX_REENTRANT_FUNCTIONS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_REGEXP+0
case _SC_REGEXP:
#ifdef	REGEXP
		return(REGEXP-0);
#else
#ifdef	_POSIX_REGEXP
		return(_POSIX_REGEXP-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_REGEX_VERSION+0
case _SC_REGEX_VERSION:
#ifdef	REGEX_VERSION
		return(REGEX_VERSION-0);
#else
#ifdef	_POSIX_REGEX_VERSION
		return(_POSIX_REGEX_VERSION-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_RESOURCE_LIMITS+0
case _SC_RESOURCE_LIMITS:
#ifdef	RESOURCE_LIMITS
		return(RESOURCE_LIMITS-0);
#else
#ifdef	_POSIX_RESOURCE_LIMITS
		return(_POSIX_RESOURCE_LIMITS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_RE_DUP_MAX+0
case _SC_RE_DUP_MAX:
#ifdef	RE_DUP_MAX
		return(RE_DUP_MAX-0);
#else
#ifdef	_POSIX2_RE_DUP_MAX
		return(_POSIX2_RE_DUP_MAX-0);
#else
		return(255-0);
#endif
#endif
#endif
#if	_SC_RTSIG_MAX+0
case _SC_RTSIG_MAX:
#ifdef	RTSIG_MAX
		return(RTSIG_MAX-0);
#else
#ifdef	_POSIX_RTSIG_MAX
		return(_POSIX_RTSIG_MAX-0);
#else
		return(8-0);
#endif
#endif
#endif
#if	_SC_SAVED_IDS+0
case _SC_SAVED_IDS:
#ifdef	SAVED_IDS
		return(SAVED_IDS-0);
#else
#ifdef	_LOCAL_SAVED_IDS
		return(_LOCAL_SAVED_IDS-0);
#else
#ifdef	_POSIX_SAVED_IDS
		return(_POSIX_SAVED_IDS-0);
#else
		break;
#endif
#endif
#endif
#endif
#if	_SC_SCHAR_MAX+0
case _SC_SCHAR_MAX:
#ifdef	SCHAR_MAX
		return(SCHAR_MAX-0);
#else
#ifdef	_POSIX_SCHAR_MAX
		return(_POSIX_SCHAR_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SCHAR_MIN+0
case _SC_SCHAR_MIN:
#ifdef	SCHAR_MIN
		return(SCHAR_MIN-0);
#else
#ifdef	_POSIX_SCHAR_MIN
		return(_POSIX_SCHAR_MIN-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SELECT+0
case _SC_SELECT:
#ifdef	SELECT
		return(SELECT-0);
#else
#ifdef	_POSIX_SELECT
		return(_POSIX_SELECT-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SEMAPHORES+0
case _SC_SEMAPHORES:
#ifdef	SEMAPHORES
		return(SEMAPHORES-0);
#else
#ifdef	_POSIX_SEMAPHORES
		return(_POSIX_SEMAPHORES-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SEM_NSEMS_MAX+0
case _SC_SEM_NSEMS_MAX:
#ifdef	SEM_NSEMS_MAX
		return(SEM_NSEMS_MAX-0);
#else
#ifdef	_POSIX_SEM_NSEMS_MAX
		return(_POSIX_SEM_NSEMS_MAX-0);
#else
		return(256-0);
#endif
#endif
#endif
#if	_SC_SEM_VALUE_MAX+0
case _SC_SEM_VALUE_MAX:
#ifdef	SEM_VALUE_MAX
		return(SEM_VALUE_MAX-0);
#else
#ifdef	_POSIX_SEM_VALUE_MAX
		return(_POSIX_SEM_VALUE_MAX-0);
#else
		return(32767-0);
#endif
#endif
#endif
#if	_SC_SHARED_MEMORY_OBJECTS+0
case _SC_SHARED_MEMORY_OBJECTS:
#ifdef	SHARED_MEMORY_OBJECTS
		return(SHARED_MEMORY_OBJECTS-0);
#else
#ifdef	_POSIX_SHARED_MEMORY_OBJECTS
		return(_POSIX_SHARED_MEMORY_OBJECTS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SHELL+0
case _SC_SHELL:
#ifdef	SHELL
		return(SHELL-0);
#else
#ifdef	_POSIX_SHELL
		return(_POSIX_SHELL-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XOPEN_SHM+0
case _SC_XOPEN_SHM:
#ifdef	SHM
		return(SHM-0);
#else
#ifdef	_XOPEN_SHM
		return(_XOPEN_SHM-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SHRT_MAX+0
case _SC_SHRT_MAX:
#ifdef	SHRT_MAX
		return(SHRT_MAX-0);
#else
#ifdef	_POSIX_SHRT_MAX
		return(_POSIX_SHRT_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SHRT_MIN+0
case _SC_SHRT_MIN:
#ifdef	SHRT_MIN
		return(SHRT_MIN-0);
#else
#ifdef	_POSIX_SHRT_MIN
		return(_POSIX_SHRT_MIN-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SIGNALS+0
case _SC_SIGNALS:
#ifdef	SIGNALS
		return(SIGNALS-0);
#else
#ifdef	_POSIX_SIGNALS
		return(_POSIX_SIGNALS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SIGQUEUE_MAX+0
case _SC_SIGQUEUE_MAX:
#ifdef	SIGQUEUE_MAX
		return(SIGQUEUE_MAX-0);
#else
#ifdef	_POSIX_SIGQUEUE_MAX
		return(_POSIX_SIGQUEUE_MAX-0);
#else
		return(32-0);
#endif
#endif
#endif
#if	_SC_SIGRT_MAX+0
case _SC_SIGRT_MAX:
#ifdef	SIGRT_MAX
		return(SIGRT_MAX-0);
#else
		break;
#endif
#endif
#if	_SC_SIGRT_MIN+0
case _SC_SIGRT_MIN:
#ifdef	SIGRT_MIN
		return(SIGRT_MIN-0);
#else
		break;
#endif
#endif
#if	_SC_SINGLE_PROCESS+0
case _SC_SINGLE_PROCESS:
#ifdef	SINGLE_PROCESS
		return(SINGLE_PROCESS-0);
#else
#ifdef	_POSIX_SINGLE_PROCESS
		return(_POSIX_SINGLE_PROCESS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SPAWN+0
case _SC_SPAWN:
#ifdef	SPAWN
		return(SPAWN-0);
#else
#ifdef	_POSIX_SPAWN
		return(_POSIX_SPAWN-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SPIN_LOCKS+0
case _SC_SPIN_LOCKS:
#ifdef	SPIN_LOCKS
		return(SPIN_LOCKS-0);
#else
#ifdef	_POSIX_SPIN_LOCKS
		return(_POSIX_SPIN_LOCKS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SPORADIC_SERVER+0
case _SC_SPORADIC_SERVER:
#ifdef	SPORADIC_SERVER
		return(SPORADIC_SERVER-0);
#else
#ifdef	_POSIX_SPORADIC_SERVER
		return(_POSIX_SPORADIC_SERVER-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SSIZE_MAX+0
case _SC_SSIZE_MAX:
#ifdef	SSIZE_MAX
		return(SSIZE_MAX-0);
#else
#ifdef	_POSIX_SSIZE_MAX
		return(_POSIX_SSIZE_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_STD_BLK+0
case _SC_STD_BLK:
#ifdef	STD_BLK
		return(STD_BLK-0);
#else
#ifdef	_SVID_STD_BLK
		return(_SVID_STD_BLK-0);
#else
		return(1024-0);
#endif
#endif
#endif
#if	_SC_STREAMS+0
case _SC_STREAMS:
#ifdef	STREAMS
		return(STREAMS-0);
#else
#ifdef	_POSIX_STREAMS
		return(_POSIX_STREAMS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_STREAM_MAX+0
case _SC_STREAM_MAX:
#ifdef	STREAM_MAX
		return(STREAM_MAX-0);
#else
#ifdef	OPEN_MAX
		return(OPEN_MAX-0);
#else
#ifdef	_POSIX_STREAM_MAX
		return(_POSIX_STREAM_MAX-0);
#else
		return(8-0);
#endif
#endif
#endif
#endif
#if	_SC_2_SW_DEV+0
case _SC_2_SW_DEV:
#ifdef	_POSIX2_SW_DEV
		return(_POSIX2_SW_DEV-0);
#else
		break;
#endif
#endif
#if	_SC_SYMLOOP_MAX+0
case _SC_SYMLOOP_MAX:
#ifdef	SYMLOOP_MAX
		return(SYMLOOP_MAX-0);
#else
#ifdef	_POSIX_SYMLOOP_MAX
		return(_POSIX_SYMLOOP_MAX-0);
#else
		return(8-0);
#endif
#endif
#endif
#if	_SC_SYNCHRONIZED_IO+0
case _SC_SYNCHRONIZED_IO:
#ifdef	SYNCHRONIZED_IO
		return(SYNCHRONIZED_IO-0);
#else
#ifdef	_POSIX_SYNCHRONIZED_IO
		return(_POSIX_SYNCHRONIZED_IO-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SYSPID_MAX+0
case _SC_SYSPID_MAX:
#ifdef	SYSPID_MAX
		return(SYSPID_MAX-0);
#else
#ifdef	_SVID_SYSPID_MAX
		return(_SVID_SYSPID_MAX-0);
#else
		return(2-0);
#endif
#endif
#endif
#if	_SC_SYSTEM_DATABASE+0
case _SC_SYSTEM_DATABASE:
#ifdef	SYSTEM_DATABASE
		return(SYSTEM_DATABASE-0);
#else
#ifdef	_POSIX_SYSTEM_DATABASE
		return(_POSIX_SYSTEM_DATABASE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_SYSTEM_DATABASE_R+0
case _SC_SYSTEM_DATABASE_R:
#ifdef	SYSTEM_DATABASE_R
		return(SYSTEM_DATABASE_R-0);
#else
#ifdef	_POSIX_SYSTEM_DATABASE_R
		return(_POSIX_SYSTEM_DATABASE_R-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREADS+0
case _SC_THREADS:
#ifdef	THREADS
		return(THREADS-0);
#else
#ifdef	_POSIX_THREADS
		return(_POSIX_THREADS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREADS_PRIO_CEILING+0
case _SC_THREADS_PRIO_CEILING:
#ifdef	THREADS_PRIO_CEILING
		return(THREADS_PRIO_CEILING-0);
#else
#ifdef	_POSIX_THREADS_PRIO_CEILING
		return(_POSIX_THREADS_PRIO_CEILING-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREADS_PRIO_INHERIT+0
case _SC_THREADS_PRIO_INHERIT:
#ifdef	THREADS_PRIO_INHERIT
		return(THREADS_PRIO_INHERIT-0);
#else
#ifdef	_POSIX_THREADS_PRIO_INHERIT
		return(_POSIX_THREADS_PRIO_INHERIT-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREAD_ATTR_STACKADDR+0
case _SC_THREAD_ATTR_STACKADDR:
#ifdef	THREAD_ATTR_STACKADDR
		return(THREAD_ATTR_STACKADDR-0);
#else
#ifdef	_POSIX_THREAD_ATTR_STACKADDR
		return(_POSIX_THREAD_ATTR_STACKADDR-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREAD_ATTR_STACKSIZE+0
case _SC_THREAD_ATTR_STACKSIZE:
#ifdef	THREAD_ATTR_STACKSIZE
		return(THREAD_ATTR_STACKSIZE-0);
#else
#ifdef	_POSIX_THREAD_ATTR_STACKSIZE
		return(_POSIX_THREAD_ATTR_STACKSIZE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREAD_CPUTIME+0
case _SC_THREAD_CPUTIME:
#ifdef	THREAD_CPUTIME
		return(THREAD_CPUTIME-0);
#else
#ifdef	_POSIX_THREAD_CPUTIME
		return(_POSIX_THREAD_CPUTIME-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREAD_DESTRUCTOR_ITERATIONS+0
case _SC_THREAD_DESTRUCTOR_ITERATIONS:
#ifdef	THREAD_DESTRUCTOR_ITERATIONS
		return(THREAD_DESTRUCTOR_ITERATIONS-0);
#else
#ifdef	PTHREAD_DESTRUCTOR_ITERATIONS
		return(PTHREAD_DESTRUCTOR_ITERATIONS-0);
#else
#ifdef	_POSIX_THREAD_DESTRUCTOR_ITERATIONS
		return(_POSIX_THREAD_DESTRUCTOR_ITERATIONS-0);
#else
		return(4-0);
#endif
#endif
#endif
#endif
#if	_SC_THREAD_KEYS_MAX+0
case _SC_THREAD_KEYS_MAX:
#ifdef	THREAD_KEYS_MAX
		return(THREAD_KEYS_MAX-0);
#else
#ifdef	PTHREAD_KEYS_MAX
		return(PTHREAD_KEYS_MAX-0);
#else
#ifdef	_POSIX_THREAD_KEYS_MAX
		return(_POSIX_THREAD_KEYS_MAX-0);
#else
		return(128-0);
#endif
#endif
#endif
#endif
#if	_SC_THREAD_PRIORITY_SCHEDULING+0
case _SC_THREAD_PRIORITY_SCHEDULING:
#ifdef	THREAD_PRIORITY_SCHEDULING
		return(THREAD_PRIORITY_SCHEDULING-0);
#else
#ifdef	_POSIX_THREAD_PRIORITY_SCHEDULING
		return(_POSIX_THREAD_PRIORITY_SCHEDULING-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREAD_PRIO_INHERIT+0
case _SC_THREAD_PRIO_INHERIT:
#ifdef	THREAD_PRIO_INHERIT
		return(THREAD_PRIO_INHERIT-0);
#else
#ifdef	_POSIX_THREAD_PRIO_INHERIT
		return(_POSIX_THREAD_PRIO_INHERIT-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREAD_PRIO_PROTECT+0
case _SC_THREAD_PRIO_PROTECT:
#ifdef	THREAD_PRIO_PROTECT
		return(THREAD_PRIO_PROTECT-0);
#else
#ifdef	_POSIX_THREAD_PRIO_PROTECT
		return(_POSIX_THREAD_PRIO_PROTECT-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREAD_PROCESS_SHARED+0
case _SC_THREAD_PROCESS_SHARED:
#ifdef	THREAD_PROCESS_SHARED
		return(THREAD_PROCESS_SHARED-0);
#else
#ifdef	_POSIX_THREAD_PROCESS_SHARED
		return(_POSIX_THREAD_PROCESS_SHARED-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREAD_SAFE_FUNCTIONS+0
case _SC_THREAD_SAFE_FUNCTIONS:
#ifdef	THREAD_SAFE_FUNCTIONS
		return(THREAD_SAFE_FUNCTIONS-0);
#else
#ifdef	_POSIX_THREAD_SAFE_FUNCTIONS
		return(_POSIX_THREAD_SAFE_FUNCTIONS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREAD_SPORADIC_SERVER+0
case _SC_THREAD_SPORADIC_SERVER:
#ifdef	THREAD_SPORADIC_SERVER
		return(THREAD_SPORADIC_SERVER-0);
#else
#ifdef	_POSIX_THREAD_SPORADIC_SERVER
		return(_POSIX_THREAD_SPORADIC_SERVER-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREAD_STACK_MIN+0
case _SC_THREAD_STACK_MIN:
#ifdef	THREAD_STACK_MIN
		return(THREAD_STACK_MIN-0);
#else
#ifdef	PTHREAD_STACK_MIN
		return(PTHREAD_STACK_MIN-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_THREAD_THREADS_MAX+0
case _SC_THREAD_THREADS_MAX:
#ifdef	THREAD_THREADS_MAX
		return(THREAD_THREADS_MAX-0);
#else
#ifdef	PTHREAD_THREADS_MAX
		return(PTHREAD_THREADS_MAX-0);
#else
#ifdef	_POSIX_THREAD_THREADS_MAX
		return(_POSIX_THREAD_THREADS_MAX-0);
#else
		return(64-0);
#endif
#endif
#endif
#endif
#if	_SC_TIMEOUTS+0
case _SC_TIMEOUTS:
#ifdef	TIMEOUTS
		return(TIMEOUTS-0);
#else
#ifdef	_POSIX_TIMEOUTS
		return(_POSIX_TIMEOUTS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_TIMERS+0
case _SC_TIMERS:
#ifdef	TIMERS
		return(TIMERS-0);
#else
#ifdef	_POSIX_TIMERS
		return(_POSIX_TIMERS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_TIMER_MAX+0
case _SC_TIMER_MAX:
#ifdef	TIMER_MAX
		return(TIMER_MAX-0);
#else
#ifdef	_POSIX_TIMER_MAX
		return(_POSIX_TIMER_MAX-0);
#else
		return(32-0);
#endif
#endif
#endif
#if	_SC_TMP_MAX+0
case _SC_TMP_MAX:
#ifdef	TMP_MAX
		return(TMP_MAX-0);
#else
		return(33520641-0);
#endif
#endif
#if	_SC_TRACE+0
case _SC_TRACE:
#ifdef	TRACE
		return(TRACE-0);
#else
#ifdef	_POSIX_TRACE
		return(_POSIX_TRACE-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_TRACE_EVENT_FILTER+0
case _SC_TRACE_EVENT_FILTER:
#ifdef	TRACE_EVENT_FILTER
		return(TRACE_EVENT_FILTER-0);
#else
#ifdef	_POSIX_TRACE_EVENT_FILTER
		return(_POSIX_TRACE_EVENT_FILTER-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_TRACE_INHERIT+0
case _SC_TRACE_INHERIT:
#ifdef	TRACE_INHERIT
		return(TRACE_INHERIT-0);
#else
#ifdef	_POSIX_TRACE_INHERIT
		return(_POSIX_TRACE_INHERIT-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_TRACE_LOG+0
case _SC_TRACE_LOG:
#ifdef	TRACE_LOG
		return(TRACE_LOG-0);
#else
#ifdef	_POSIX_TRACE_LOG
		return(_POSIX_TRACE_LOG-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_TTY_NAME_MAX+0
case _SC_TTY_NAME_MAX:
#ifdef	TTY_NAME_MAX
		return(TTY_NAME_MAX-0);
#else
#ifdef	_POSIX_TTY_NAME_MAX
		return(_POSIX_TTY_NAME_MAX-0);
#else
		return(9-0);
#endif
#endif
#endif
#if	_SC_TYPED_MEMORY_OBJECTS+0
case _SC_TYPED_MEMORY_OBJECTS:
#ifdef	TYPED_MEMORY_OBJECTS
		return(TYPED_MEMORY_OBJECTS-0);
#else
#ifdef	_POSIX_TYPED_MEMORY_OBJECTS
		return(_POSIX_TYPED_MEMORY_OBJECTS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_TZNAME_MAX+0
case _SC_TZNAME_MAX:
#ifdef	TZNAME_MAX
		return(TZNAME_MAX-0);
#else
#ifdef	_POSIX_TZNAME_MAX
		return(_POSIX_TZNAME_MAX-0);
#else
		return(6-0);
#endif
#endif
#endif
#if	_SC_T_IOV_MAX+0
case _SC_T_IOV_MAX:
#ifdef	T_IOV_MAX
		return(T_IOV_MAX-0);
#else
#ifdef	_POSIX_T_IOV_MAX
		return(_POSIX_T_IOV_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_UCHAR_MAX+0
case _SC_UCHAR_MAX:
#ifdef	UCHAR_MAX
		return(UCHAR_MAX-0);
#else
#ifdef	_POSIX_UCHAR_MAX
		return(_POSIX_UCHAR_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_UID_MAX+0
case _SC_UID_MAX:
#ifdef	UID_MAX
		return(UID_MAX-0);
#else
#ifdef	_SVID_UID_MAX
		return(_SVID_UID_MAX-0);
#else
		return(60002-0);
#endif
#endif
#endif
#if	_SC_UINT_MAX+0
case _SC_UINT_MAX:
#ifdef	UINT_MAX
		return(UINT_MAX-0);
#else
#ifdef	_POSIX_UINT_MAX
		return(_POSIX_UINT_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_UIO_MAXIOV+0
case _SC_UIO_MAXIOV:
#ifdef	UIO_MAXIOV
		return(UIO_MAXIOV-0);
#else
#ifdef	_POSIX_UIO_MAXIOV
		return(_POSIX_UIO_MAXIOV-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_ULONG_MAX+0
case _SC_ULONG_MAX:
#ifdef	ULONG_MAX
		return(ULONG_MAX-0);
#else
#ifdef	_POSIX_ULONG_MAX
		return(_POSIX_ULONG_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XOPEN_UNIX+0
case _SC_XOPEN_UNIX:
#ifdef	UNIX
		return(UNIX-0);
#else
#ifdef	_XOPEN_UNIX
		return(_XOPEN_UNIX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_2_UPE+0
case _SC_2_UPE:
#ifdef	_POSIX2_UPE
		return(_POSIX2_UPE-0);
#else
		break;
#endif
#endif
#if	_SC_USER_GROUPS+0
case _SC_USER_GROUPS:
#ifdef	USER_GROUPS
		return(USER_GROUPS-0);
#else
#ifdef	_POSIX_USER_GROUPS
		return(_POSIX_USER_GROUPS-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_USER_GROUPS_R+0
case _SC_USER_GROUPS_R:
#ifdef	USER_GROUPS_R
		return(USER_GROUPS_R-0);
#else
#ifdef	_POSIX_USER_GROUPS_R
		return(_POSIX_USER_GROUPS_R-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_USHRT_MAX+0
case _SC_USHRT_MAX:
#ifdef	USHRT_MAX
		return(USHRT_MAX-0);
#else
#ifdef	_POSIX_USHRT_MAX
		return(_POSIX_USHRT_MAX-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_V6_ILP32_OFF32+0
case _SC_V6_ILP32_OFF32:
#ifdef	V6_ILP32_OFF32
		return(V6_ILP32_OFF32-0);
#else
#ifdef	_POSIX_V6_ILP32_OFF32
		return(_POSIX_V6_ILP32_OFF32-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_V6_ILP32_OFFBIG+0
case _SC_V6_ILP32_OFFBIG:
#ifdef	V6_ILP32_OFFBIG
		return(V6_ILP32_OFFBIG-0);
#else
#ifdef	_POSIX_V6_ILP32_OFFBIG
		return(_POSIX_V6_ILP32_OFFBIG-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_V6_LP64_OFF64+0
case _SC_V6_LP64_OFF64:
#ifdef	V6_LP64_OFF64
		return(V6_LP64_OFF64-0);
#else
#ifdef	_POSIX_V6_LP64_OFF64
		return(_POSIX_V6_LP64_OFF64-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_V6_LPBIG_OFFBIG+0
case _SC_V6_LPBIG_OFFBIG:
#ifdef	V6_LPBIG_OFFBIG
		return(V6_LPBIG_OFFBIG-0);
#else
#ifdef	_POSIX_V6_LPBIG_OFFBIG
		return(_POSIX_V6_LPBIG_OFFBIG-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_VERSION+0
case _SC_VERSION:
#ifdef	VERSION
		return(VERSION-0);
#else
#ifdef	_POSIX_VERSION
		return(_POSIX_VERSION-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_2_VERSION+0
case _SC_2_VERSION:
#ifdef	_POSIX2_VERSION
		return(_POSIX2_VERSION-0);
#else
		break;
#endif
#endif
#if	_SC_XOPEN_VERSION+0
case _SC_XOPEN_VERSION:
#ifdef	VERSION
		return(VERSION-0);
#else
#ifdef	_XOPEN_VERSION
		return(_XOPEN_VERSION-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_3_VERSION+0
case _SC_3_VERSION:
#ifdef	_XPG3_VERSION
		return(_XPG3_VERSION-0);
#else
		break;
#endif
#endif
#if	_SC_4_VERSION+0
case _SC_4_VERSION:
#ifdef	_XPG4_VERSION
		return(_XPG4_VERSION-0);
#else
		break;
#endif
#endif
#if	_SC_VERSION_88+0
case _SC_VERSION_88:
#ifdef	VERSION_88
		return(VERSION_88-0);
#else
#ifdef	_POSIX_VERSION_88
		return(_POSIX_VERSION_88-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_VERSION_90+0
case _SC_VERSION_90:
#ifdef	VERSION_90
		return(VERSION_90-0);
#else
#ifdef	_POSIX_VERSION_90
		return(_POSIX_VERSION_90-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_VERSION_93+0
case _SC_VERSION_93:
#ifdef	VERSION_93
		return(VERSION_93-0);
#else
#ifdef	_POSIX_VERSION_93
		return(_POSIX_VERSION_93-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_WORD_BIT+0
case _SC_WORD_BIT:
#ifdef	WORD_BIT
		return(WORD_BIT-0);
#else
#ifdef	_POSIX_WORD_BIT
		return(_POSIX_WORD_BIT-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XOPEN_XCU_VERSION+0
case _SC_XOPEN_XCU_VERSION:
#ifdef	XCU_VERSION
		return(XCU_VERSION-0);
#else
#ifdef	_XOPEN_XCU_VERSION
		return(_XOPEN_XCU_VERSION-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XOPEN_XPG2+0
case _SC_XOPEN_XPG2:
#ifdef	XPG2
		return(XPG2-0);
#else
#ifdef	_XOPEN_XPG2
		return(_XOPEN_XPG2-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XOPEN_XPG3+0
case _SC_XOPEN_XPG3:
#ifdef	XPG3
		return(XPG3-0);
#else
#ifdef	_XOPEN_XPG3
		return(_XOPEN_XPG3-0);
#else
		break;
#endif
#endif
#endif
#if	_SC_XOPEN_XPG4+0
case _SC_XOPEN_XPG4:
#ifdef	XPG4
		return(XPG4-0);
#else
#ifdef	_XOPEN_XPG4
		return(_XOPEN_XPG4-0);
#else
		break;
#endif
#endif
#endif
	default:
		break;
	}
	errno = EINVAL;
	return(-1);
}

#endif
