/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLElement.h"

#include "Element.h"
#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLNames.h"
#include "JSElement.h"
#include "JSHTMLCollection.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLElement);

/* Hash table */

static const HashTableValue JSHTMLElementTableValues[16] =
{
    { "id", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementId), (intptr_t)setJSHTMLElementId },
    { "title", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementTitle), (intptr_t)setJSHTMLElementTitle },
    { "lang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementLang), (intptr_t)setJSHTMLElementLang },
    { "dir", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementDir), (intptr_t)setJSHTMLElementDir },
    { "className", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementClassName), (intptr_t)setJSHTMLElementClassName },
    { "tabIndex", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementTabIndex), (intptr_t)setJSHTMLElementTabIndex },
    { "draggable", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementDraggable), (intptr_t)setJSHTMLElementDraggable },
    { "innerHTML", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementInnerHTML), (intptr_t)setJSHTMLElementInnerHTML },
    { "innerText", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementInnerText), (intptr_t)setJSHTMLElementInnerText },
    { "outerHTML", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOuterHTML), (intptr_t)setJSHTMLElementOuterHTML },
    { "outerText", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOuterText), (intptr_t)setJSHTMLElementOuterText },
    { "children", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementChildren), (intptr_t)0 },
    { "contentEditable", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementContentEditable), (intptr_t)setJSHTMLElementContentEditable },
    { "isContentEditable", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementIsContentEditable), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 511, JSHTMLElementTableValues, 0 };
#else
    { 34, 31, JSHTMLElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLElementConstructorTableValues, 0 };
#endif

class JSHTMLElementConstructor : public DOMConstructorObject {
public:
    JSHTMLElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLElementConstructor::s_info = { "HTMLElementConstructor", 0, &JSHTMLElementConstructorTable, 0 };

bool JSHTMLElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLElementConstructor, DOMObject>(exec, &JSHTMLElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLElementConstructor, DOMObject>(exec, &JSHTMLElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLElementPrototypeTableValues[4] =
{
    { "insertAdjacentElement", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsHTMLElementPrototypeFunctionInsertAdjacentElement), (intptr_t)2 },
    { "insertAdjacentHTML", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsHTMLElementPrototypeFunctionInsertAdjacentHTML), (intptr_t)2 },
    { "insertAdjacentText", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsHTMLElementPrototypeFunctionInsertAdjacentText), (intptr_t)2 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSHTMLElementPrototypeTableValues, 0 };
#else
    { 8, 7, JSHTMLElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLElementPrototype::s_info = { "HTMLElementPrototype", 0, &JSHTMLElementPrototypeTable, 0 };

JSObject* JSHTMLElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLElement>(exec, globalObject);
}

bool JSHTMLElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLElementPrototypeTable, this, propertyName, slot);
}

bool JSHTMLElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHTMLElement::s_info = { "HTMLElement", &JSElement::s_info, &JSHTMLElementTable, 0 };

JSHTMLElement::JSHTMLElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLElement> impl)
    : JSElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLElementPrototype(JSHTMLElementPrototype::createStructure(JSElementPrototype::self(exec, globalObject)));
}

bool JSHTMLElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLElement, Base>(exec, &JSHTMLElementTable, this, propertyName, slot);
}

bool JSHTMLElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLElement, Base>(exec, &JSHTMLElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLElementId(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::idAttr));
    return result;
}

JSValue jsHTMLElementTitle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::titleAttr));
    return result;
}

JSValue jsHTMLElementLang(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::langAttr));
    return result;
}

JSValue jsHTMLElementDir(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::dirAttr));
    return result;
}

JSValue jsHTMLElementClassName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::classAttr));
    return result;
}

JSValue jsHTMLElementTabIndex(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->tabIndex());
    return result;
}

JSValue jsHTMLElementDraggable(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->draggable());
    return result;
}

JSValue jsHTMLElementInnerHTML(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->innerHTML());
    return result;
}

JSValue jsHTMLElementInnerText(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->innerText());
    return result;
}

JSValue jsHTMLElementOuterHTML(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->outerHTML());
    return result;
}

JSValue jsHTMLElementOuterText(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->outerText());
    return result;
}

JSValue jsHTMLElementChildren(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->children()));
    return result;
}

JSValue jsHTMLElementContentEditable(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->contentEditable());
    return result;
}

JSValue jsHTMLElementIsContentEditable(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* castedThis = static_cast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->isContentEditable());
    return result;
}

JSValue jsHTMLElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLElement* domObject = static_cast<JSHTMLElement*>(asObject(slotBase));
    return JSHTMLElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLElement, Base>(exec, propertyName, value, &JSHTMLElementTable, this, slot);
}

void setJSHTMLElementId(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::idAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLElementTitle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::titleAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLElementLang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::langAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLElementDir(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::dirAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLElementClassName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::classAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLElementTabIndex(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    imp->setTabIndex(value.toInt32(exec));
}

void setJSHTMLElementDraggable(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    imp->setDraggable(value.toBoolean(exec));
}

void setJSHTMLElementInnerHTML(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setInnerHTML(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSHTMLElementInnerText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setInnerText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSHTMLElementOuterHTML(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setOuterHTML(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSHTMLElementOuterText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setOuterText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSHTMLElementContentEditable(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(thisObject);
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    imp->setContentEditable(valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentElement(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(asObject(thisValue));
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& where = args.at(0).toString(exec);
    Element* element = toElement(args.at(1));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->insertAdjacentElement(where, element, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentHTML(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(asObject(thisValue));
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& where = args.at(0).toString(exec);
    const UString& html = args.at(1).toString(exec);

    imp->insertAdjacentHTML(where, html, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentText(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLElement* castedThisObj = static_cast<JSHTMLElement*>(asObject(thisValue));
    HTMLElement* imp = static_cast<HTMLElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& where = args.at(0).toString(exec);
    const UString& text = args.at(1).toString(exec);

    imp->insertAdjacentText(where, text, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

HTMLElement* toHTMLElement(JSC::JSValue value)
{
    return value.inherits(&JSHTMLElement::s_info) ? static_cast<JSHTMLElement*>(asObject(value))->impl() : 0;
}

}
