.\" $XFree86: xc/programs/xvidtune/xvidtune.man,v $
.\"
.\" Copyright (c) 1995  Kaleb S. KEITHLEY
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL Kaleb S. KEITHLEY BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of Kaleb S. KEITHLEY shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from Kaleb S. KEITHLEY.
.\"
.TH xvidtune __appmansuffix__ __vendorversion__
.SH NAME
xvidtune \- video mode tuner for __xservername__
.SH SYNOPSIS
.B xvidtune
[
.B -show
|
.B -prev
|
.B -next
|
.B -unlock
] [
.I \-toolkitoption
\&.\|.\|. ]
.SH DESCRIPTION
Xvidtune is a client interface to the X server video mode
extension (XFree86-VidModeExtension).
.PP
When given one of the non-toolkit options, xvidtune provides
a command line interface to either print or switch the video mode.
.PP
Without any options (or with only toolkit options) it
presents the user with various buttons and sliders that can be
used to interactively adjust existing video modes.
It will also print the settings in a format suitable for inclusion
in an __xconfigfile__ file.
.PP
Normally the __xservername__ X servers only allow changes to be made with
the XFree86-VidModeExtension from clients connected via a local
connection type.
.PP
Note:  The original mode settings can be restored by pressing the `R' key,
and this can be used to restore a stable screen in situations where the
screen becomes unreadable.
.PP
The available buttons are:
.PP
.nf
.B Left
.B Right
.B Up
.B Down
.fi
.RS 10
Adjust the video mode so that the display will be moved in the
appropriate direction.
.RE
.PP
.nf
.B Wider
.B Narrower
.B Shorter
.B Taller
.fi
.RS 10
Adjust the video mode so that the display size is altered
appropriately.
.RE
.TP 10
.B Quit
Exit the program.
.TP 10
.B Apply
Adjust the current video mode to match the selected settings.
.TP 10
.B Auto
Cause the Up/Down/Right/Left, Wider/Narrower/Shorter/Taller, Restore,
and the special S3 buttons to be applied immediately.
This button can be toggled.
.TP 10
.B Test
Temporarily switch to the selected settings.
.TP 10
.B Restore
Return the settings to their original values.
.TP 10
.B Fetch
Query the server for its current settings.
.TP 10
.B Show
Print the currently selected settings to stdout in __xconfigfile__
"Modeline" format.  The primary selection is similarly set.
.TP 10
.B Next
Switch the Xserver to the next video mode.
.TP 10
.B Prev
Switch the Xserver to the previous video mode.
.PP
For some S3-based cards (964 and 968) the following are also available:
.TP 10
.B InvertVCLK
Change the VCLK invert/non-invert state.
.TP 10
.B EarlySC
Change the Early SC state.  This affects screen wrapping.
.PP
.nf
.B BlankDelay1
.B BlankDelay2
.fi
.RS 10
Set the blank delay values.  This affects screen wrapping.  Acceptable
values are in the range 0\-7.  The values may be incremented or decremented
with the `+' and `-' buttons, or by pressing the `+' or `-' keys in the
text field.
.RE
.PP
For S3-864/868 based cards \fIInvertVCLK\fP and \fIBlankDelay1\fP may
be useful.  For S3 Trio32/Trio64 cards only \fIInvertVCLK\fP is available.
At the moment there are no default settings available for these chips 
in the video mode extension and thus this feature is disabled in xvidtune.
It can be enabled by setting any of the optional S3 commands in the
screen section of __xconfigfile__, e.g. using
.RS 10
.B blank_delay \fI"\(**"\fP 0
.RE
.SH OPTIONS
\fIxvidtune\fP accepts the standard X Toolkit command line options as well
as the following:
.TP 10
.B \-show
Print the current settings to stdout in __xconfigfile__
"Modeline" format and exit.
.TP 10
.B \-prev
Switch the Xserver to the previous video mode.
.TP 10
.B \-next
Switch the Xserver to the next video mode.
.TP 10
.B \-unlock
Normally, \fIxvidtune\fP will disable the switching of video modes
via hot-keys while it is running.  If for some reason the program
did not exit cleanly and they are still disabled, the program can
be re-run with this option to re-enable the mode switching key
combinations.
.SH SEE ALSO
.BR xrandr (__appmansuffix__),
.BR __xservername__ (__appmansuffix__),
.BR __xconfigfile__ (__filemansuffix__).
.SH AUTHORS
Kaleb S. Keithley, X Consortium.
.br
Additions and modifications by Jon Tombs, David Dawes, and Joe Moss.
.SH BUGS
X Error handling, i.e. when the server does not allow xvidtune
clients to write new modes, could be better.
