/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.concurrent.locks.Lock;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import info.aduna.iteration.Iterations;
import info.aduna.iteration.IteratorIteration;
import info.aduna.iteration.LockingIteration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.impl.BindingAssigner;
import org.openrdf.query.algebra.evaluation.impl.CompareOptimizer;
import org.openrdf.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.openrdf.query.algebra.evaluation.impl.ConstantOptimizer;
import org.openrdf.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.impl.FilterOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.openrdf.query.algebra.evaluation.impl.QueryModelPruner;
import org.openrdf.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.openrdf.query.algebra.evaluation.util.QueryOptimizerList;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.helpers.NotifyingSailConnectionBase;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.openrdf.sail.nativerdf.NativeEvaluationStatistics;
import org.openrdf.sail.nativerdf.NativeStatementIterator;
import org.openrdf.sail.nativerdf.NativeStore;
import org.openrdf.sail.nativerdf.NativeTripleSource;
import org.openrdf.sail.nativerdf.TripleStore;
import org.openrdf.sail.nativerdf.ValueStore;
import org.openrdf.sail.nativerdf.btree.RecordIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeStoreConnection
extends NotifyingSailConnectionBase
implements InferencerConnection {
    protected final NativeStore nativeStore;
    private DefaultSailChangedEvent sailChangedEvent;
    private Lock txnLock;

    protected NativeStoreConnection(NativeStore nativeStore) throws IOException {
        super(nativeStore);
        this.nativeStore = nativeStore;
        this.sailChangedEvent = new DefaultSailChangedEvent(nativeStore);
    }

    @Override
    protected void closeInternal() {
    }

    @Override
    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.logger.trace("Incoming query model:\n{}", (Object)tupleExpr.toString());
        tupleExpr = tupleExpr.clone();
        if (!(tupleExpr instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        Lock readLock = this.nativeStore.getReadLock();
        try {
            this.replaceValues(tupleExpr);
            NativeTripleSource tripleSource = new NativeTripleSource(this.nativeStore, includeInferred, this.transactionActive());
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl(tripleSource, dataset);
            QueryOptimizerList optimizerList = new QueryOptimizerList();
            optimizerList.add(new BindingAssigner());
            optimizerList.add(new ConstantOptimizer(strategy));
            optimizerList.add(new CompareOptimizer());
            optimizerList.add(new ConjunctiveConstraintSplitter());
            optimizerList.add(new DisjunctiveConstraintOptimizer());
            optimizerList.add(new SameTermFilterOptimizer());
            optimizerList.add(new QueryModelPruner());
            optimizerList.add(new QueryJoinOptimizer(new NativeEvaluationStatistics(this.nativeStore)));
            optimizerList.add(new FilterOptimizer());
            optimizerList.optimize(tupleExpr, dataset, bindings);
            this.logger.trace("Optimized query model:\n{}", (Object)tupleExpr.toString());
            CloseableIteration<BindingSet, QueryEvaluationException> iter = strategy.evaluate(tupleExpr, EmptyBindingSet.getInstance());
            return new LockingIteration<BindingSet, QueryEvaluationException>(readLock, iter);
        }
        catch (QueryEvaluationException e) {
            readLock.release();
            throw new SailException(e);
        }
        catch (RuntimeException e) {
            readLock.release();
            throw e;
        }
    }

    protected void replaceValues(TupleExpr tupleExpr) throws SailException {
        tupleExpr.visit(new QueryModelVisitorBase<SailException>(){

            @Override
            public void meet(Var var) {
                if (var.hasValue()) {
                    var.setValue(NativeStoreConnection.this.nativeStore.getValueStore().getNativeValue(var.getValue()));
                }
            }
        });
    }

    @Override
    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        Lock readLock = this.nativeStore.getReadLock();
        try {
            CloseableIteration<Resource, IOException> contextIter = this.nativeStore.getContextIDs(this.transactionActive());
            contextIter = new LockingIteration<Resource, IOException>(readLock, contextIter);
            return new ExceptionConvertingIteration<Resource, SailException>(contextIter){

                @Override
                protected SailException convert(Exception e) {
                    if (e instanceof IOException) {
                        return new SailException(e);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e == null) {
                        throw new IllegalArgumentException("e must not be null");
                    }
                    throw new IllegalArgumentException("Unexpected exception type: " + e.getClass());
                }
            };
        }
        catch (IOException e) {
            readLock.release();
            throw new SailException(e);
        }
        catch (RuntimeException e) {
            readLock.release();
            throw e;
        }
    }

    @Override
    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        Lock readLock = this.nativeStore.getReadLock();
        try {
            CloseableIteration<? extends Statement, IOException> iter = this.nativeStore.createStatementIterator(subj, pred, obj, includeInferred, this.transactionActive(), contexts);
            iter = new LockingIteration<Statement, IOException>(readLock, iter);
            return new ExceptionConvertingIteration<Statement, SailException>(iter){

                @Override
                protected SailException convert(Exception e) {
                    if (e instanceof IOException) {
                        return new SailException(e);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e == null) {
                        throw new IllegalArgumentException("e must not be null");
                    }
                    throw new IllegalArgumentException("Unexpected exception type: " + e.getClass());
                }
            };
        }
        catch (IOException e) {
            readLock.release();
            throw new SailException("Unable to get statements", e);
        }
        catch (RuntimeException e) {
            readLock.release();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long sizeInternal(Resource ... contexts) throws SailException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        Lock readLock = this.nativeStore.getReadLock();
        try {
            List<Integer> contextIDs = contexts.length == 0 ? Arrays.asList(-1) : this.nativeStore.getContextIDs(contexts);
            long size = 0L;
            for (int contextID : contextIDs) {
                RecordIterator iter = this.nativeStore.getTripleStore().getTriples(-1, -1, -1, contextID, true, this.transactionActive());
                try {
                    while (iter.next() != null) {
                        ++size;
                    }
                }
                finally {
                    iter.close();
                }
            }
            long l = size;
            return l;
        }
        catch (IOException e) {
            throw new SailException(e);
        }
        finally {
            readLock.release();
        }
    }

    @Override
    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        Lock readLock = this.nativeStore.getReadLock();
        try {
            return new LockingIteration<NamespaceImpl, SailException>(readLock, new IteratorIteration(this.nativeStore.getNamespaceStore().iterator()));
        }
        catch (RuntimeException e) {
            readLock.release();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getNamespaceInternal(String prefix) throws SailException {
        Lock readLock = this.nativeStore.getReadLock();
        try {
            String string = this.nativeStore.getNamespaceStore().getNamespace(prefix);
            return string;
        }
        finally {
            readLock.release();
        }
    }

    @Override
    protected void startTransactionInternal() throws SailException {
        this.txnLock = this.nativeStore.getTransactionLock();
        try {
            this.nativeStore.getTripleStore().startTransaction();
        }
        catch (IOException e) {
            throw new SailException(e);
        }
    }

    @Override
    protected void commitInternal() throws SailException {
        Lock storeReadLock = this.nativeStore.getReadLock();
        try {
            this.nativeStore.getValueStore().sync();
            this.nativeStore.getTripleStore().commit();
            this.nativeStore.getNamespaceStore().sync();
            this.txnLock.release();
        }
        catch (IOException e) {
            throw new SailException(e);
        }
        catch (RuntimeException e) {
            this.logger.error("Encountered an unexpected problem while trying to commit", (Throwable)e);
            throw e;
        }
        finally {
            storeReadLock.release();
        }
        this.nativeStore.notifySailChanged(this.sailChangedEvent);
        this.sailChangedEvent = new DefaultSailChangedEvent(this.nativeStore);
    }

    @Override
    protected void rollbackInternal() throws SailException {
        Lock storeReadLock = this.nativeStore.getReadLock();
        try {
            this.nativeStore.getValueStore().sync();
            this.nativeStore.getTripleStore().rollback();
        }
        catch (IOException e) {
            throw new SailException(e);
        }
        catch (RuntimeException e) {
            this.logger.error("Encountered an unexpected problem while trying to roll back", (Throwable)e);
            throw e;
        }
        finally {
            this.txnLock.release();
            storeReadLock.release();
        }
    }

    @Override
    protected void addStatementInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.addStatement(subj, pred, obj, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                boolean bl = this.addStatement(subj, pred, obj, false, contexts);
                txnLock.release();
                return bl;
            }
            catch (Throwable throwable) {
                txnLock.release();
                throw throwable;
            }
        }
        finally {
            conLock.release();
        }
    }

    private boolean addStatement(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        boolean result = false;
        try {
            ValueStore valueStore = this.nativeStore.getValueStore();
            int subjID = valueStore.storeValue(subj);
            int predID = valueStore.storeValue(pred);
            int objID = valueStore.storeValue(obj);
            if (contexts.length == 0) {
                contexts = new Resource[]{null};
            }
            for (Resource context : contexts) {
                int contextID = 0;
                if (context != null) {
                    contextID = valueStore.storeValue(context);
                }
                boolean wasNew = this.nativeStore.getTripleStore().storeTriple(subjID, predID, objID, contextID, explicit);
                result |= wasNew;
                if (!wasNew) continue;
                this.sailChangedEvent.setStatementsAdded(true);
                if (!this.hasConnectionListeners()) continue;
                Statement st = context != null ? valueStore.createStatement(subj, pred, obj, context) : valueStore.createStatement(subj, pred, obj);
                this.notifyStatementAdded(st);
            }
        }
        catch (IOException e) {
            throw new SailException(e);
        }
        catch (RuntimeException e) {
            this.logger.error("Encountered an unexpected problem while trying to add a statement", (Throwable)e);
            throw e;
        }
        return result;
    }

    @Override
    protected void removeStatementsInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.removeStatements(subj, pred, obj, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeInferredStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                int removeCount = this.removeStatements(subj, pred, obj, false, contexts);
                boolean bl = removeCount > 0;
                txnLock.release();
                return bl;
            }
            catch (Throwable throwable) {
                txnLock.release();
                throw throwable;
            }
        }
        finally {
            conLock.release();
        }
    }

    private int removeStatements(Resource subj, URI pred, Value obj, boolean explicit, Resource ... contexts) throws SailException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        try {
            TripleStore tripleStore = this.nativeStore.getTripleStore();
            ValueStore valueStore = this.nativeStore.getValueStore();
            int subjID = -1;
            if (subj != null && (subjID = valueStore.getID(subj)) == -1) {
                return 0;
            }
            int predID = -1;
            if (pred != null && (predID = valueStore.getID(pred)) == -1) {
                return 0;
            }
            int objID = -1;
            if (obj != null && (objID = valueStore.getID(obj)) == -1) {
                return 0;
            }
            ArrayList<Integer> contextIDList = new ArrayList<Integer>(contexts.length);
            if (contexts.length == 0) {
                contextIDList.add(-1);
            } else {
                for (Resource context : contexts) {
                    if (context == null) {
                        contextIDList.add(0);
                        continue;
                    }
                    int contextID = valueStore.getID(context);
                    if (contextID == -1) continue;
                    contextIDList.add(contextID);
                }
            }
            int removeCount = 0;
            for (int i = 0; i < contextIDList.size(); ++i) {
                int contextID = (Integer)contextIDList.get(i);
                List<Object> removedStatements = Collections.emptyList();
                if (this.hasConnectionListeners()) {
                    RecordIterator btreeIter = tripleStore.getTriples(subjID, predID, objID, contextID, explicit, true);
                    NativeStatementIterator iter = new NativeStatementIterator(btreeIter, valueStore);
                    removedStatements = Iterations.asList(iter);
                }
                removeCount += tripleStore.removeTriples(subjID, predID, objID, contextID, explicit);
                for (Statement st : removedStatements) {
                    this.notifyStatementRemoved(st);
                }
            }
            if (removeCount > 0) {
                this.sailChangedEvent.setStatementsRemoved(true);
            }
            return removeCount;
        }
        catch (IOException e) {
            throw new SailException(e);
        }
        catch (RuntimeException e) {
            this.logger.error("Encountered an unexpected problem while trying to remove statements", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void clearInternal(Resource ... contexts) throws SailException {
        this.removeStatements(null, null, null, true, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearInferred(Resource ... contexts) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                this.removeStatements(null, null, null, false, contexts);
            }
            finally {
                txnLock.release();
            }
        }
        finally {
            conLock.release();
        }
    }

    @Override
    public void flushUpdates() {
    }

    @Override
    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        this.nativeStore.getNamespaceStore().setNamespace(prefix, name);
    }

    @Override
    protected void removeNamespaceInternal(String prefix) throws SailException {
        this.nativeStore.getNamespaceStore().removeNamespace(prefix);
    }

    @Override
    protected void clearNamespacesInternal() throws SailException {
        this.nativeStore.getNamespaceStore().clear();
    }
}

