/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedString.h"

#include "KURL.h"
#include "PlatformString.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedString);

/* Hash table */

static const HashTableValue JSSVGAnimatedStringTableValues[3] =
{
    { "baseVal", DontDelete, (intptr_t)jsSVGAnimatedStringBaseVal, (intptr_t)setJSSVGAnimatedStringBaseVal },
    { "animVal", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedStringAnimVal, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedStringTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSSVGAnimatedStringTableValues, 0 };
#else
    { 4, 3, JSSVGAnimatedStringTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedStringPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedStringPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGAnimatedStringPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGAnimatedStringPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGAnimatedStringPrototype::s_info = { "SVGAnimatedStringPrototype", 0, &JSSVGAnimatedStringPrototypeTable, 0 };

JSObject* JSSVGAnimatedStringPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedString>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedString::s_info = { "SVGAnimatedString", 0, &JSSVGAnimatedStringTable, 0 };

JSSVGAnimatedString::JSSVGAnimatedString(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedString> impl, SVGElement* context)
    : DOMObjectWithSVGContext(structure, globalObject, context)
    , m_impl(impl)
{
}

JSSVGAnimatedString::~JSSVGAnimatedString()
{
    forgetDOMObject(this, impl());
}

JSObject* JSSVGAnimatedString::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGAnimatedStringPrototype(JSSVGAnimatedStringPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGAnimatedString::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedString, Base>(exec, &JSSVGAnimatedStringTable, this, propertyName, slot);
}

bool JSSVGAnimatedString::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedString, Base>(exec, &JSSVGAnimatedStringTable, this, propertyName, descriptor);
}

JSValue jsSVGAnimatedStringBaseVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedString* castedThis = static_cast<JSSVGAnimatedString*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(castedThis->impl());
    return jsString(exec, imp->baseVal());
}

JSValue jsSVGAnimatedStringAnimVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedString* castedThis = static_cast<JSSVGAnimatedString*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(castedThis->impl());
    return jsString(exec, imp->animVal());
}

void JSSVGAnimatedString::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGAnimatedString, Base>(exec, propertyName, value, &JSSVGAnimatedStringTable, this, slot);
}

void setJSSVGAnimatedStringBaseVal(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(static_cast<JSSVGAnimatedString*>(thisObject)->impl());
    imp->setBaseVal(value.toString(exec));
    if (static_cast<JSSVGAnimatedString*>(thisObject)->context())
        static_cast<JSSVGAnimatedString*>(thisObject)->context()->svgAttributeChanged(static_cast<JSSVGAnimatedString*>(thisObject)->impl()->associatedAttributeName());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedString* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedString>(exec, globalObject, object, context);
}
SVGAnimatedString* toSVGAnimatedString(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedString::s_info) ? static_cast<JSSVGAnimatedString*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
