'\" t
.ig
roff.man

This file is part of groff, the GNU roff type-setting system.

Copyright (C) 2000, 2001, 2002, 2003, 2004, 2006, 2007, 2008, 2009
Free Software Foundation, Inc.
written by Bernd Warken <bwarken@mayn.de>
maintained by Werner Lemberg <wl@gnu.org>

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or
any later version published by the Free Software Foundation; with the
Invariant Sections being this .ig-section and AUTHORS, with no
Front-Cover Texts, and with no Back-Cover Texts.

A copy of the Free Documentation License is included as a file called
FDL in the main directory of the groff source package.
..
.
.
.\" --------------------------------------------------------------------
.\" Local macros
.
.de Esc
.  ds @1 \\$1
.  shift
.  nop \f[B]\[rs]\\*[@1]\f[]\\$*
.  rm @1
..
.
.
.de QuotedChar
.  ds @1 \\$1
.  shift
.  nop `\f[B]\\*[@1]\f[]'\\$*
.  rm @1
..
.
.
.\" --------------------------------------------------------------------
.\" Title
.\" --------------------------------------------------------------------
.
.TH ROFF @MAN7EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
roff \- concepts and history of roff typesetting
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.
.I roff
is the general name for a set of text formatting programs, known under
names like
.BR troff ,
.BR nroff ,
.BR ditroff ,
.BR groff ,
etc.
.
A
.I roff
system consists of an extensible text formatting language and a set of
programs for printing and converting to other text formats.
.
Unix-like operating systems distribute a
.I roff
system as a core package.
.
.P
The most common
.I roff
system today is the free software implementation \f[CR]GNU\f[]
.IR roff ,
.BR groff (@MAN1EXT@).
.
.I groff
implements the look-and-feel and functionality of its ancestors, with many
extensions.
.
.P
The ancestry of
.I roff
is described in section
.BR HISTORY .
.
In this document, the term
.I roff
always refers to the general class of roff programs, not to the
.B roff
command provided in early UNIX systems.
.
.P
In spite of its age,
.I roff
is in wide use today, for example, the manual pages on UNIX systems
.RI ( man\~pages\/ ),
many software books, system documentation, standards, and corporate
documents are written in roff.
.
The
.I roff
output for text devices is still unmatched, and its graphical output
has the same quality as other free type-setting programs and is better
than some of the commercial systems.
.
.P
.I roff
is used to format UNIX
.IR "manual pages" ,
(or
.IR "man pages" ),
the standard documentation system on many UNIX-derived operating systems.
.
.P
This document describes the history of the development of the
.IR "roff system" ;
some usage aspects common to all
.I roff
versions, details on the
.I roff
pipeline, which is usually hidden behind front-ends like
.BR groff (@MAN1EXT@);
a general overview of the formatting language; some tips for editing
.I roff
files; and many pointers to further readings.
.
.
.\" --------------------------------------------------------------------
.SH "HISTORY"
.\" --------------------------------------------------------------------
.
Document formatting by computer dates back to the 1960s.
.
The
.I roff
system itself is intimately connected to the Unix operating system, but its
roots go back to the earlier operating systems CTSS and Multics.
.
.
.\" --------------------------------------------------------------------
.SS "The Predecessor RUNOFF"
.\" --------------------------------------------------------------------
.
.BR roff 's
ancestor
.B RUNOFF
was written in the MAD language by
.I Jerry Saltzer
for the
.IR "Compatible Time Sharing System (CTSS)" ,
a project of the Massachusetts Institute of Technology (MIT), in 1963 and
1964 \[en] note that CTSS commands were all uppercase.
.
.P
In 1965, MIT's Project MAC teamed with Bell Telephone Laboratories (BTL)
and General Electric to begin the
.UR http://\:www.multicians.org
.I Multics
system
.UE .
.
A command called
.B runoff
was written for Multics in the late 60s in the BCPL language, by
.IR "Bob Morris" ,
.IR "Doug McIlroy" ,
and other members of the Multics team.
.
.P
Like its CTSS ancestor, Multics
.B runoff
formatted an input file consisting of text and command lines; commands began
with a period and were two letters.
.
Output from these commands was to terminal devices such as IBM Selectric
terminals.
.
Multics
.B runoff
had additional features added, such as the ability to do two-pass
formatting; it became the main format for Multics documentation and text
processing.
.
.P
BCPL and
.B runoff
were ported to the GCOS system at Bell Labs when BTL left the development of
Multics.
.
.
.\" --------------------------------------------------------------------
.SS "The Classical nroff/troff System"
.\" --------------------------------------------------------------------
.
At BTL, there was a need to drive the
.I Graphic Systems CAT
typesetter, a graphical output device from a PDP-11 computer running Unix.
.
As
.B runoff
was too limited for this task it was further developed into a more
powerful text formatting system by
.IR "Joseph F.\& Ossanna" ,
who already programmed several runoff ports.
.
.P
The name
.I runoff
was shortened to
.IR roff .
.
The greatly enlarged language of Ossanna's version already included all
elements of a full
.IR "roff system" .
.
All modern
.I roff
systems try to implement compatibility to this system.
.
So Joe Ossanna can be called the father of all
.I roff
systems.
.
.P
This first
.I roff system
had three formatter programs.
.
.TP
.B troff
.RI ( "typesetter roff\/" )
generated a graphical output for the
.I CAT
typesetter as its only device.
.
.TP
.B nroff
produced text output suitable for terminals and line printers.
.
.TP
.B roff
was the reimplementation of the former
.B runoff
program with its limited features; this program was abandoned in later
versions.
.
Today, the name
.I roff
is used to refer to a
.I troff/\:nroff
sytem as a whole.
.
.P
Ossanna's first version was written in the PDP-11 assembly language and
released in 1973.
.
.I Brian Kernighan
joined the
.I roff
development by rewriting it in the C\~programming language.
.
The C\~version was released in 1975.
.
.P
The syntax of the formatting language of the
.BR nroff /\: troff
programs was documented in the famous
.IR "Troff User's Manual [CSTR\~#54]" ,
first published in 1976, with further revisions up to 1992 by Brian
Kernighan.
.
This document is the specification of the
.IR "classical troff" .
.
All later
.I roff
systems tried to establish compatibility with this specification.
.
.P
After Ossanna's death in 1977, Kernighan went on with developing
.IR troff .
.
In the late 1970s, Kernighan equipped
.I troff
with a general interface to support more devices, the intermediate
output format, and the postprocessor system.
.
This completed the structure of a
.I "roff system"
as it is still in use today; see section
.BR "USING ROFF" .
.
In 1979, these novelties were described in the paper
.IR "[CSTR\~#97]" .
.
This new
.I troff
version is the basis for all existing newer troff systems, including
.IR groff .
.
On some systems, this
.I device independent troff
got a binary of its own, called
.BR ditroff (@MAN7EXT@).
.
All modern
.B troff
programs already provide the full
.B ditroff
capabilities automatically.
.
.
.\" --------------------------------------------------------------------
.SS "Availability"
.\" --------------------------------------------------------------------
.
The source code of both the ancient Unix and classical
.I troff
weren't available for two decades.
.
Meanwhile, it is accessible again (on-line) for non-commercial use,
cf.\& section
.BR "SEE ALSO" .
.
.
.\" --------------------------------------------------------------------
.SS "Free roff"
.\" --------------------------------------------------------------------
.
The most important free
.I roff
project was the \f[CR]GNU\f[] implementation of
.IR troff ,
written from scratch by
.I James Clark
and put under the
.UR http://\:www.gnu.org/\:copyleft
GNU Public License
.UE .
.
It was called
.I groff
(\f[CR]GNU\f[]
.IR roff ).
.
See
.BR groff (@MAN1EXT@)
for an overview.
.
.P
The
.I groff
system is still actively developed.
.
It is compatible to the classical
.IR troff ,
but many extensions were added.
.
It is the first
.I roff
system that is available on almost all operating systems \[en] and it is
free.
.
This makes
.I groff
the de-facto
.I roff
standard today.
.
.P
An alternative is
.IR "Gunnar Ritter" 's
.UR http://\:heirloom.sf.net
Heirloom Documentation Tools
.UE
project, started in 2005, which provides enhanced versions of the various
roff tools found in the OpenSolaris and Plan\~9 operating systems, now
available under free licenses.
.
.
.\" --------------------------------------------------------------------
.SH "USING ROFF"
.\" --------------------------------------------------------------------
.
Most people won't even notice that they are actually using
.IR roff .
.
When you read a system manual page (man page)
.I roff
is working in the background.
.
.I roff
documents can be viewed with a native viewer called
.BR \%xditview (1x),
a standard program of the X window distribution, see
.BR X (7x).
.
But using
.I roff
explicitly isn't difficult either.
.
.P
Some
.I roff
implementations provide wrapper programs that make it easy to use the
.I roff
system on the shell command line.
.
For example, the \f[CR]GNU\f[]
.I roff
implementation
.BR groff (@MAN1EXT@)
provides command line options to avoid the long command pipes of
classical
.IR troff ;
a program
.BR grog (@MAN1EXT@)
tries to guess from the document which arguments should be used for a
run of
.BR groff ;
people who do not like specifying command line options should try the
.BR groffer (@MAN1EXT@)
program for graphically displaying
.I groff
files and man pages.
.
.
.\" --------------------------------------------------------------------
.SS "The roff Pipe"
.\" --------------------------------------------------------------------
.
Each
.I roff
system consists of preprocessors,
.I roff
formatter programs, and a set of device postprocessors.
.
This concept makes heavy use of the
.I piping
mechanism, that is, a series of programs is called one after the other,
where the output of each program in the queue is taken as the input
for the next program.
.
.RS
.P
cat \f[I]file\f[P] \
| .\|.\|. \
| \f[I]preproc\f[P] \
| .\|.\|. \
| troff \f[I]options\f[P] \
| \f[I]postproc\f[P]
.RE
.
.P
The preprocessors generate
.I roff
code that is fed into a
.I roff
formatter (e.g.\&
.BR troff ),
which in turn generates
.I intermediate output
that is fed into a device postprocessor program for printing or final
output.
.
.P
All of these parts use programming languages of their own; each
language is totally unrelated to the other parts.
.
Moreover,
.I roff
macro packages that were tailored for special purposes can be
included.
.
.P
Most
.I roff
documents use the macros of some package, intermixed with code for one
or more preprocessors, spiced with some elements from the plain
.I roff
language.
.
The full power of the
.I roff
formatting language is seldom needed by users; only programmers of
macro packages need to know about the gory details.
.
.
.
.\" --------------------------------------------------------------------
.SS "Preprocessors"
.\" --------------------------------------------------------------------
.
A
.I roff
preprocessor is any program that generates output that syntactically
obeys the rules of the
.I roff
formatting language.
.
Each preprocessor defines a language of its own that is translated
into
.I roff
code when run through the preprocessor program.
.
Parts written in these languages may be included within a
.I roff
document; they are identified by special
.I roff
requests or macros.
.
Each document that is enhanced by preprocessor code must be run
through all corresponding preprocessors before it is fed into the
actual
.I roff
formatter program, for the formatter just ignores all alien code.
.
The preprocessor programs extract and transform only the document
parts that are determined for them.
.
.P
There are a lot of free and commercial
.I roff
preprocessors.
.
Some of them aren't available on each system, but there is a small
set of preprocessors that are considered as an integral part of each
.I roff
system.
.
The classical preprocessors are
.
.RS
.TS
tab (@);
lb l.
tbl@for tables.
eqn@for mathematical formul\[ae].
pic@for drawing diagrams.
refer@for bibliographic references.
soelim@for including macro files from standard locations.
chem@for drawing chemical formul\[ae].
.TE
.RE
.
.P
Other known preprocessors that are not available on all systems
include
.
.RS
.TS
tab (@);
lb l.
grap@for constructing graphical elements.
grn@for including \fBgremlin\fR(1) pictures.
.TE
.RE
.
.\" --------------------------------------------------------------------
.SS "Formatter Programs"
.\" --------------------------------------------------------------------
.
A
.I roff formatter
is a program that parses documents written in the
.I roff
formatting language or uses some of the
.I roff
macro packages.
.
It generates
.IR "intermediate output" ,
which is intended to be fed into a single device postprocessor that
must be specified by a command-line option to the formatter program.
.
The documents must have been run through all necessary preprocessors
before.
.
.P
The output produced by a
.I roff
formatter is represented in yet another language, the
.IR "intermediate output format"
or
.IR "troff output" .
.
This language was first specified in
.IR "[CSTR\~#97]" ;
its \f[CR]GNU\f[] extension is documented in
.BR groff_out (@MAN5EXT@).
.
The intermediate output language is a kind of assembly language
compared to the high-level
.I roff
language.
.
The generated intermediate output is optimized for a special device,
but the language is the same for every device.
.
.P
The
.I roff
formatter is the heart of the
.I roff
system.
.
The traditional
.I roff
had two formatters,
.B nroff
for text devices and
.B troff
for graphical devices.
.
.P
Often, the name
.I troff
is used as a general term to refer to both formatters.
.
.
.\" --------------------------------------------------------------------
.SS "Devices and Postprocessors"
.\" --------------------------------------------------------------------
.
Devices are hardware interfaces like printers, text or graphical
terminals, etc., or software interfaces such as a conversion into a
different text or graphical format.
.
.P
A
.I roff
postprocessor is a program that transforms
.I troff
output into a form suitable for a special device.
.
The
.I roff
postprocessors are like device drivers for the output target.
.
.P
For each device there is a postprocessor program that fits the device
optimally.
.
The postprocessor parses the generated intermediate output and
generates device-specific code that is sent directly to the device.
.
.P
The names of the devices and the postprocessor programs are not fixed
because they greatly depend on the software and hardware abilities of
the actual computer.
.
For example, the classical devices mentioned in
.I [CSTR\~#54]
have greatly changed since the classical times.
.
The old hardware doesn't exist any longer and the old graphical
conversions were quite imprecise when compared to their modern
counterparts.
.
.P
For example, the Postscript device
.I post
in classical
.I troff
had a resolution of 720 units per inch, while
.IR groff 's
.I ps
device has 72000, a refinement of factor 100.
.
.P
Today the operating systems provide device drivers for most
printer-like hardware, so it isn't necessary to write a special
hardware postprocessor for each printer.
.
.
.\" --------------------------------------------------------------------
.SH "ROFF PROGRAMMING"
.\" --------------------------------------------------------------------
.
Documents using
.I roff
are normal text files decorated by
.I roff
formatting elements.
.
The
.I roff
formatting language is quite powerful; it is almost a full programming
language and provides elements to enlarge the language.
.
With these, it became possible to develop macro packages that are
tailored for special applications.
.
Such macro packages are much handier than plain
.IR roff .
.
So most people will choose a macro package without worrying about the
internals of the
.I roff
language.
.
.
.\" --------------------------------------------------------------------
.SS "Macro Packages"
.\" --------------------------------------------------------------------
.
Macro packages are collections of macros that are suitable to format a
special kind of documents in a convenient way.
.
This greatly eases the usage of
.IR roff .
.
The macro definitions of a package are kept in a file called
.IB name .tmac
(classically
.BI tmac. name\c
).
.
All tmac files are stored in one or more directories at standardized
positions.
.
Details on the naming of macro packages and their placement is found
in
.BR groff_tmac (@MAN5EXT@).
.
.P
A macro package that is to be used in a document can be announced to
the formatter by the command line option
.BR \-m ,
see
.BR troff (@MAN1EXT@),
or it can be specified within a document using the file inclusion
requests of the
.I roff
language, see
.BR groff (@MAN7EXT@).
.
.P
Famous classical macro packages are
.I man
for traditional man pages,
.I mdoc
for \f[CR]BSD\f[]-style manual pages;
the macro sets for books, articles, and letters are
.I me
(probably from the first name of its creator
.I Eric
Allman),
.I ms
(from
.IR "Manuscript Macros\/" ),
and
.I mm
(from
.IR "Memorandum Macros\/" ).
.
.
.\" --------------------------------------------------------------------
.SS "The roff Formatting Language"
.\" --------------------------------------------------------------------
.
The classical
.I roff
formatting language is documented in the
.I Troff User's Manual
.IR "[CSTR\~#54]" .
.
The
.I roff
language is a full programming language providing requests, definition
of macros, escape sequences, string variables, number or size
registers, and flow controls.
.
.P
.I Requests
are the predefined basic formatting commands similar to the commands
at the shell prompt.
.
The user can define request-like elements using predefined
.I roff
elements.
.
These are then called
.IR macros .
.
A document writer will not note any difference in usage for requests
or macros; both are written on a line on their own starting with a dot.
.
.P
.I Escape sequences
are
.I roff
elements starting with a backslash
.QuotedChar \[rs] .
.
They can be inserted anywhere, also in the midst of text in a line.
.
They are used to implement various features, including the insertion of
non-\f[CR]ASCII\f[] characters with
.Esc ( ,
font changes with
.Esc f ,
in-line comments with
.Esc \[dq] ,
the escaping of special control characters like
.Esc \[rs] ,
and many other features.
.
.P
.I Strings
are variables that can store a string.
.
A string is stored by the
.B .ds
request.
.
The stored string can be retrieved later by the
.B \[rs]*
escape sequence.
.
.P
.I Registers
store numbers and sizes.
.
A register can be set with the request
.B .nr
and its value can be retrieved by the escape sequence
.BR "\[rs]n" .
.
.
.\" --------------------------------------------------------------------
.SH "FILE NAME EXTENSIONS"
.\" --------------------------------------------------------------------
.
Manual pages (man pages) take the section number as a file name
extension, e.g., the filename for this document is
.IR roff.7 ,
i.e., it is kept in section\~7
of the man pages.
.
.P
The classical macro packages take the package name as an extension, e.g.\&
.IB file. me
for a document using the
.I me
macro package,
.IB file. mm
for
.IR mm ,
.IB file. ms
for
.IR ms ,
.IB file. pic
for
.I pic
files,
etc.
.
.P
But there is no general naming scheme for
.I roff
documents, though
.IB file. tr
for
.I troff file
is seen now and then.
.
Maybe there should be a standardization for the filename extensions of
.I roff
files.
.
.P
File name extensions can be very handy in conjunction with the
.BR less (1)
pager.
.
It provides the possibility to feed all input into a command-line pipe
that is specified in the shell environment variable
.BR LESSOPEN .
.
This process is not well documented, so here an example:
.
.RS
.P
.EX
LESSOPEN='|lesspipe %s'
.EE
.RE
.
.P
where
.B lesspipe
is either a system supplied command or a shell script of your own.
.
.
.\" --------------------------------------------------------------------
.SH "EDITING ROFF"
.\" --------------------------------------------------------------------
.
The best program for editing a
.I roff
document is Emacs (or Xemacs), see
.BR emacs (1).
.
It provides an
.I nroff
mode that is suitable for all kinds of
.I roff
dialects.
.
This mode can be activated by the following methods.
.
.P
When editing a file within Emacs the mode can be changed by typing
.RI ` "M-x nroff-mode" ',
where
.B M-x
means to hold down the
.B Meta
key (or
.BR Alt )
and hitting the
.BR x\~ key
at the same time.
.
.P
But it is also possible to have the mode automatically selected when
the file is loaded into the editor.
.
.IP \(bu
The most general method is to include the following 3 comment lines at
the end of the file.
.
.RS
.IP
.EX
\&.\[rs]" Local Variables:
\&.\[rs]" mode: nroff
\&.\[rs]" End:
.EE
.RE
.
.IP \(bu
There is a set of file name extensions, e.g.\& the man pages that
trigger the automatic activation of the
.I nroff
mode.
.
.IP \(bu
Theoretically, it is possible to write the sequence
.
.RS
.IP
.EX
\&.\[rs]" \%-*-\ nroff\ -*-
.EE
.RE
.
.IP
as the first line of a file to have it started in
.I nroff
mode when loaded.
.
Unfortunately, some applications such as the
.B man
program are confused by this; so this is deprecated.
.
.P
All
.I roff
formatters provide automated line breaks and horizontal and vertical
spacing.
.
In order to not disturb this, the following tips can be helpful.
.
.IP \(bu
Never include empty or blank lines in a
.I roff
document.
.
Instead, use the empty request (a line consisting of a dot only) or a
line comment
.B .\[rs]"
if a structuring element is needed.
.
.IP \(bu
Never start a line with whitespace because this can lead to
unexpected behavior.
.
Indented paragraphs can be constructed in a controlled way by
.I roff
requests.
.
.IP \(bu
Start each sentence on a line of its own, for the spacing after a dot
is handled differently depending on whether it terminates an
abbreviation or a sentence.
.
To distinguish both cases, do a line break after each sentence.
.
.IP \(bu
To additionally use the auto-fill mode in Emacs, it is best to insert
an empty
.I roff
request (a line consisting of a dot only) after each sentence.
.
.P
The following example shows how optimal
.I roff
editing could look.
.
.RS
.P
.EX
This is an example for a
\&.I roff
document.
\&.
This is the next sentence in the same paragraph.
\&.
This is a longer sentence stretching over several
lines; abbreviations like `cf.' are easily
identified because the dot is not followed by a
line break.
\&.
In the output, this will still go to the same
paragraph.
.EE
.RE
.
.P
Besides Emacs, some other editors provide
.I nroff
style files too, e.g.\&
.BR vim (1),
an extension of the
.BR vi (1)
program.
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
There is a lot of documentation on
.IR roff .
.
The original papers on classical
.I troff
are still available, and all aspects of
.I groff
are documented in great detail.
.
.
.\" --------------------------------------------------------------------
.SS "Internet sites"
.\" --------------------------------------------------------------------
.
.TP
troff.org
.UR http://\:www.troff.org
The historical troff site
.UE
provides an overview and pointers to all historical aspects of
.IR roff .
.
.TP
Multics
.UR http://\:www.multicians.org
The Multics site
.UE
contains a lot of information on the MIT projects, CTSS, Multics,
early Unix, including
.IR runoff ;
especially useful are a glossary and the many links to ancient
documents.
.
.TP
Unix Archive
.UR http://\:www.tuhs.org/\:Archive/
The Ancient Unixes Archive
.UE
.
provides the source code and some binaries of the ancient Unixes
(including the source code of
.I troff
and its documentation) that were made public by Caldera since 2001,
e.g.\& of the famous Unix version\~7 for PDP-11 at the
.UR http://\:www.tuhs.org/\:Archive/\:PDP-11/\:Trees/\:V7
Unix V7 site
.UE .
.
.TP
Developers at AT&T Bell Labs
.UR http://\:www.bell-labs.com/
Bell Labs Computing and Mathematical Sciences Research
.UE
.
provides a search facility for tracking information on the early
developers.
.
.TP
Plan 9
.UR http://\:plan9.bell-labs.com
The Plan\~9 operating system
.UE
.
by AT&T Bell Labs.
.
.TP
runoff
.UR http://\:web.mit.edu/\:Saltzer/\:www/\:publications/\:pubs.html
Jerry Saltzer's home page
.UE
.
stores some documents using the ancient RUNOFF formatting language.
.
.TP
CSTR Papers
.UR http://\:cm.bell-labs.com/\:cm/\:cs/\:cstr.html
The Bell Labs CSTR site
.UE
.
stores the original
.I troff
manuals (CSTR #54, #97, #114, #116, #122) and famous historical
documents on programming.
.
.TP
\f[CR]GNU\f[] \f[I]roff\f[]
.UR http://\:www.gnu.org/\:software/\:groff
The groff web site
.UE
provides the free
.I roff
implementation
.IR groff ,
the actual standard
.IR roff .
.
.
.\" --------------------------------------------------------------------
.SS "Historical roff Documentation"
.\" --------------------------------------------------------------------
.
Many classical
.B troff
documents are still available on-line.
.
The two main manuals of the
.I troff
language are
.
.TP
[CSTR\~#54]
J. F. Ossanna,
.UR http://\:cm.bell-labs.com/\:cm/\:cs/\:cstr/\:54.ps.gz
.I "Nroff/\:Troff User's Manual"
.UE ;
.
Bell Labs, 1976; revised by Brian Kernighan, 1992.
.
.TP
[CSTR\~#97]
Brian Kernighan,
.UR http://\:cm.bell-labs.com/\:cm/\:cs/\:cstr/\:97.ps.gz
.I "A Typesetter-independent TROFF"
.UE ,
.
Bell Labs, 1981, revised March 1982.
.
.P
The \[lq]little language\[rq]
.I roff
papers are
.
.TP
[CSTR\~#114]
Jon L. Bentley and Brian W. Kernighan,
.UR http://\:cm.bell-labs.com/\:cm/\:cs/\:cstr/\:114.ps.gz
.I "GRAP \[en] A Language for Typesetting Graphs"
.UE ;
.
Bell Labs, August 1984.
.
.TP
[CSTR\~#116]
Brian W. Kernighan,
.UR http://\:cm.bell-labs.com/\:cm/\:cs/\:cstr/\:116.ps.gz
.I "PIC \[en] A Graphics Language for Typesetting"
.UE ;
.
Bell Labs, December 1984.
.
.TP
[CSTR\~#122]
J. L. Bentley, L. W. Jelinski, and B. W. Kernighan,
.UR http://\:cm.bell-labs.com/\:cm/\:cs/\:cstr/\:122.ps.gz
.I "CHEM \[en] A Program for Typesetting Chemical Structure Diagrams,"
.I "Computers and Chemistry"
.UE ;
.
Bell Labs, April 1986.
.
.
.\" --------------------------------------------------------------------
.SS "Manual Pages"
.\" --------------------------------------------------------------------
.
Due to its complex structure, a full
.I roff
system has many man pages, each describing a single aspect of
.IR roff .
.
Unfortunately, there is no general naming scheme for the documentation
among the different
.I roff
implementations.
.
.P
In
.IR groff ,
the man page
.BR groff (@MAN1EXT@)
contains a survey of all documentation available in
.IR groff .
.
.P
On other systems, you are on your own, but
.BR troff (1)
might be a good starting point.
.
.
.\" --------------------------------------------------------------------
.SH AUTHORS
.\" --------------------------------------------------------------------
.
Copyright (C) 2000, 2001, 2002, 2003, 2004, 2006, 2007, 2008, 2009
Free Software Foundation, Inc.
.
.P
This document is distributed under the terms of the \f[CR]FDL\f[]
(\f[CR]GNU Free Documentation License\f[]) version 1.3 or later.
.
You should have received a copy of the \f[CR]FDL\f[] on your system,
it is also available on-line at the
.UR http://\:www.gnu.org/\:copyleft/\:fdl.html
GNU copyleft site
.UE .
.
.P
This document is part of
.IR groff ,
the \f[CR]GNU\f[]
.I roff
distribution.
.
It was written by
.MT bwarken@mayn.de
Bernd Warken
.ME ;
it is maintained by
.MT wl@gnu.org
Werner Lemberg
.ME .
.
.\" --------------------------------------------------------------------
.\" Emacs setup
.\" --------------------------------------------------------------------
.
.\" Local Variables:
.\" mode: nroff
.\" End:
