/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.java.net.URLParseError;
import gnu.java.net.protocol.core.Handler;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.StringTokenizer;

public final class URL
implements Serializable {
    private static final String DEFAULT_SEARCH_PATH = "gnu.java.net.protocol|sun.net.www.protocol";
    private String protocol;
    private String authority;
    private String host;
    private int port;
    private String file;
    private String ref;
    private int hashCode;
    transient URLStreamHandler ph;
    private static URLStreamHandlerFactory factory;
    private static final long serialVersionUID = -7627629688361524110L;
    private static HashMap ph_cache;
    private static boolean cache_handlers;

    private /* synthetic */ void finit$() {
        this.port = -1;
        this.hashCode = 0;
    }

    public URL(String protocol, String host, int port, String file) throws MalformedURLException {
        this(protocol, host, port, file, null);
    }

    public URL(String protocol, String host, String file) throws MalformedURLException {
        this(protocol, host, -1, file, null);
    }

    public URL(String protocol, String host, int port, String file, URLStreamHandler ph) throws MalformedURLException {
        this.finit$();
        if (protocol == null) {
            throw new MalformedURLException("null protocol");
        }
        this.protocol = protocol.toLowerCase();
        if (ph != null) {
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                s.checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.ph = ph;
        } else {
            this.ph = URL.getURLStreamHandler(protocol);
        }
        if (this.ph == null) {
            throw new MalformedURLException("Protocol handler not found: " + protocol);
        }
        this.host = host;
        this.port = port;
        this.authority = null;
        int hashAt = file.indexOf(35);
        if (hashAt < 0) {
            this.file = file;
            this.ref = null;
        } else {
            this.file = file.substring(0, hashAt);
            this.ref = file.substring(hashAt + 1);
        }
        this.hashCode = this.hashCode();
    }

    public URL(String spec) throws MalformedURLException {
        this((URL)null, spec, (URLStreamHandler)null);
    }

    public URL(URL context, String spec) throws MalformedURLException {
        this(context, spec, null);
    }

    public URL(URL context, String spec, URLStreamHandler ph) throws MalformedURLException {
        int slash;
        this.finit$();
        int colon = spec.indexOf("://", 1);
        if (colon > 0 && !spec.regionMatches(colon, "://:", 0, 4)) {
            context = null;
        }
        if ((colon = spec.indexOf(58)) > 0 && (colon < (slash = spec.indexOf(47)) || slash < 0)) {
            this.protocol = spec.substring(0, colon).toLowerCase();
            if (context != null && context.protocol.equals(this.protocol)) {
                this.host = context.host;
                this.port = context.port;
                this.file = context.file;
                if (this.file == null || this.file.length() == 0) {
                    this.file = "/";
                }
                this.authority = context.authority;
            }
        } else if (context != null) {
            colon = -1;
            this.protocol = context.protocol;
            this.host = context.host;
            this.port = context.port;
            this.file = context.file;
            if (this.file == null || this.file.length() == 0) {
                this.file = "/";
            }
            this.authority = context.authority;
        } else {
            throw new MalformedURLException("Absolute URL required with null context");
        }
        if (ph != null) {
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                s.checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.ph = ph;
        } else {
            this.ph = URL.getURLStreamHandler(this.protocol);
        }
        if (this.ph == null) {
            throw new MalformedURLException("Protocol handler not found: " + this.protocol);
        }
        int hashAt = spec.indexOf(35, colon + 1);
        try {
            this.ph.parseURL(this, spec, colon + 1, hashAt < 0 ? spec.length() : hashAt);
        }
        catch (URLParseError e) {
            throw new MalformedURLException(e.getMessage());
        }
        if (hashAt >= 0) {
            this.ref = spec.substring(hashAt + 1);
        }
        this.hashCode = this.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URL)) {
            return false;
        }
        return this.ph.equals(this, (URL)obj);
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public final Object getContent(Class[] classes) throws IOException {
        return this.getContent();
    }

    public String getFile() {
        if (this.file == null) {
            return "";
        }
        return this.file;
    }

    public String getPath() {
        int quest;
        int n = quest = this.file == null ? -1 : this.file.indexOf(63);
        if (quest < 0) {
            return this.getFile();
        }
        return this.file.substring(0, quest);
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getHost() {
        int at;
        int n = at = this.host == null ? -1 : this.host.indexOf(64);
        if (at < 0) {
            return this.host;
        }
        return this.host.substring(at + 1, this.host.length());
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.ph.getDefaultPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.ref;
    }

    public String getUserInfo() {
        int at;
        int n = at = this.host == null ? -1 : this.host.indexOf(64);
        if (at < 0) {
            return null;
        }
        return this.host.substring(0, at);
    }

    public String getQuery() {
        int quest;
        int n = quest = this.file == null ? -1 : this.file.indexOf(63);
        if (quest < 0) {
            return null;
        }
        return this.file.substring(quest + 1, this.file.length());
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        return this.ph.hashCode(this);
    }

    public URLConnection openConnection() throws IOException {
        return this.ph.openConnection(this);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public boolean sameFile(URL other) {
        return this.ph.sameFile(this, other);
    }

    protected void set(String protocol, String host, int port, String file, String ref) {
        this.ph = URL.getURLStreamHandler(protocol);
        this.protocol = protocol.toLowerCase();
        this.authority = null;
        this.port = port;
        this.host = host;
        this.file = file;
        this.ref = ref;
        this.hashCode = this.hashCode();
    }

    protected void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        this.ph = URL.getURLStreamHandler(protocol);
        this.protocol = protocol.toLowerCase();
        this.host = userInfo == null ? host : userInfo + "@" + host;
        this.port = port;
        this.file = query == null ? path : path + "?" + query;
        this.ref = ref;
        this.hashCode = this.hashCode();
    }

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory fac) {
        if (factory != null) {
            throw new Error("URLStreamHandlerFactory already set");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkSetFactory();
        }
        factory = fac;
    }

    public String toExternalForm() {
        return this.ph.toExternalForm(this);
    }

    public String toString() {
        return this.ph.toExternalForm(this);
    }

    private static synchronized URLStreamHandler getURLStreamHandler(String protocol) {
        URLStreamHandler ph = null;
        if (cache_handlers && (ph = (URLStreamHandler)ph_cache.get(protocol)) != null) {
            return ph;
        }
        if (factory != null) {
            ph = factory.createURLStreamHandler(protocol);
        } else if (protocol.equals("core")) {
            ph = new Handler();
        } else if (protocol.equals("file")) {
            ph = new gnu.java.net.protocol.file.Handler();
        }
        if (ph == null) {
            String ph_search_path = System.getProperty("java.protocol.handler.pkgs");
            ph_search_path = ph_search_path != null ? ph_search_path + "|gnu.java.net.protocol|sun.net.www.protocol" : DEFAULT_SEARCH_PATH;
            StringTokenizer pkgPrefix = new StringTokenizer(ph_search_path, "|");
            do {
                String clsName = pkgPrefix.nextToken() + "." + protocol + ".Handler";
                try {
                    Object obj = Class.forName(clsName).newInstance();
                    if (!(obj instanceof URLStreamHandler)) continue;
                    ph = (URLStreamHandler)obj;
                }
                catch (Exception e) {
                    // empty catch block
                }
            } while (!(ph instanceof URLStreamHandler) && pkgPrefix.hasMoreTokens());
        }
        if (ph != null && cache_handlers) {
            if (ph instanceof URLStreamHandler) {
                ph_cache.put(protocol, ph);
            } else {
                ph = null;
            }
        }
        return ph;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.ph = URL.getURLStreamHandler(this.protocol);
        if (this.ph == null) {
            throw new IOException("Handler for protocol " + this.protocol + " not found");
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    static {
        DEFAULT_SEARCH_PATH = DEFAULT_SEARCH_PATH;
        ph_cache = new HashMap();
        String s = System.getProperty("gnu.java.net.nocache_protocol_handlers");
        cache_handlers = s == null;
    }
}

