/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkArgList;
import gnu.java.awt.peer.gtk.GtkCheckboxGroupPeer;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.peer.CheckboxPeer;

public class GtkCheckboxPeer
extends GtkComponentPeer
implements CheckboxPeer {
    public GtkCheckboxGroupPeer old_group;
    private boolean currentState;

    public native void nativeCreate(GtkCheckboxGroupPeer var1, boolean var2);

    public native void nativeSetCheckboxGroup(GtkCheckboxGroupPeer var1);

    public native void connectSignals();

    public GtkCheckboxPeer(Checkbox c) {
        super(c);
    }

    public void create() {
        CheckboxGroup g = ((Checkbox)this.awtComponent).getCheckboxGroup();
        this.old_group = GtkCheckboxGroupPeer.getCheckboxGroupPeer(g);
        this.currentState = ((Checkbox)this.awtComponent).getState();
        this.nativeCreate(this.old_group, this.currentState);
    }

    public void setState(boolean state) {
        if (this.currentState != state) {
            this.set("active", state);
        }
    }

    public void setLabel(String label) {
        this.set("label", label);
    }

    public void setCheckboxGroup(CheckboxGroup group) {
        GtkCheckboxGroupPeer gp = GtkCheckboxGroupPeer.getCheckboxGroupPeer(group);
        if (gp != this.old_group) {
            if (this.old_group != null) {
                this.old_group.remove(this);
            }
            this.nativeSetCheckboxGroup(gp);
            this.old_group = gp;
        }
    }

    public void getArgs(Component component, GtkArgList args) {
        super.getArgs(component, args);
        args.add("active", ((Checkbox)component).getState());
        args.add("label", (Object)((Checkbox)component).getLabel());
    }

    public void postItemEvent(Object item, int stateChange) {
        Checkbox currentCheckBox = (Checkbox)this.awtComponent;
        if (!currentCheckBox.getState() && stateChange == 1 || currentCheckBox.getState() && stateChange == 2) {
            super.postItemEvent(this.awtComponent, stateChange);
            this.currentState = currentCheckBox.getState() ^ true;
            currentCheckBox.setState(this.currentState);
        }
    }

    public void dispose() {
        if (this.old_group != null) {
            this.old_group.remove(this);
        }
        super.dispose();
    }
}

