/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.prefs;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class NodeWriter {
    private final Preferences prefs;
    private final BufferedWriter bw;
    private boolean subtree;

    public NodeWriter(Preferences prefs, Writer w) {
        this.prefs = prefs;
        this.bw = w instanceof BufferedWriter ? (BufferedWriter)w : new BufferedWriter(w);
    }

    public NodeWriter(Preferences prefs, OutputStream os) {
        this(prefs, new OutputStreamWriter(os));
    }

    public void writePrefsTree() throws BackingStoreException, IOException {
        this.subtree = true;
        this.writeHeader();
        this.writePreferences();
        this.bw.flush();
    }

    public void writePrefs() throws BackingStoreException, IOException {
        this.subtree = false;
        this.writeHeader();
        this.writePreferences();
        this.bw.flush();
    }

    private void writeHeader() throws BackingStoreException, IOException {
        this.bw.write("<?xml version=\"1.0\"?>");
        this.bw.newLine();
        this.bw.newLine();
        this.bw.write("<!-- GNU Classpath java.util.prefs Preferences ");
        if (this.prefs.isUserNode()) {
            this.bw.write("user");
        } else {
            this.bw.write("system");
        }
        if (this.prefs.parent() == null) {
            this.bw.write(" root");
        }
        if (this.subtree) {
            this.bw.write(" tree");
        } else {
            this.bw.write(" node");
        }
        if (this.prefs.parent() != null) {
            this.bw.newLine();
            this.bw.write("     '");
            this.bw.write(this.prefs.absolutePath());
            this.bw.write(39);
            this.bw.newLine();
        }
        this.bw.write(" -->");
        this.bw.newLine();
        this.bw.newLine();
    }

    private void writePreferences() throws BackingStoreException, IOException {
        this.bw.write("<preferences>");
        this.bw.newLine();
        this.writeRoot();
        this.bw.write("</preferences>");
        this.bw.newLine();
    }

    private void writeRoot() throws BackingStoreException, IOException {
        this.bw.write("  <root type=\"");
        if (this.prefs.isUserNode()) {
            this.bw.write("user");
        } else {
            this.bw.write("system");
        }
        this.bw.write("\"/>");
        this.writeRootMap();
        this.writeNode();
        this.bw.write("  </root>");
        this.bw.newLine();
    }

    private void writeRootMap() throws BackingStoreException, IOException {
        if (this.prefs.parent() == null && this.prefs.keys().length > 0) {
            this.bw.newLine();
            this.writeMap(this.prefs, 2);
        } else {
            this.bw.write("<map/>");
            this.bw.newLine();
        }
    }

    private int writeParents() throws IOException {
        int parents;
        String path = this.prefs.absolutePath();
        int lastslash = path.lastIndexOf("/");
        if (lastslash > 0) {
            path = path.substring(1, lastslash);
            StringTokenizer st = new StringTokenizer(path);
            parents = st.countTokens();
            System.out.println("path: " + path);
            System.out.println("parents: " + parents);
            for (int i = 0; i < parents; ++i) {
                String name = st.nextToken();
                this.indent(i + 2);
                this.bw.write("<node name=\"" + name + "\">");
                this.bw.write("<map/>");
                this.bw.write("</node>");
                this.bw.newLine();
            }
        } else {
            parents = 0;
        }
        return parents;
    }

    private void writeCloseParents(int parents) throws IOException {
        while (parents > 0) {
            this.indent(parents + 1);
            this.bw.write("</node>");
            this.bw.newLine();
            --parents;
        }
    }

    private void writeNode() throws BackingStoreException, IOException {
        int parents = this.writeParents();
        int indent = this.prefs.parent() == null ? parents + 1 : parents + 2;
        this.writeNode(this.prefs, indent);
        this.writeCloseParents(parents);
    }

    private void writeNode(Preferences node, int indent) throws BackingStoreException, IOException {
        if (node.parent() != null) {
            this.indent(indent);
            this.bw.write("<node name=\"" + node.name() + "\">");
            if (node.keys().length > 0) {
                this.bw.newLine();
            }
            this.writeMap(node, indent + 1);
        }
        if (this.subtree) {
            String[] children = node.childrenNames();
            for (int i = 0; i < children.length; ++i) {
                Preferences child = node.node(children[i]);
                this.writeNode(child, indent + 1);
            }
        }
        if (node.parent() != null) {
            this.indent(indent);
            this.bw.write("</node>");
            this.bw.newLine();
        }
    }

    private void writeMap(Preferences node, int indent) throws BackingStoreException, IOException {
        StringBuffer indentBuffer = new StringBuffer(2 * indent);
        for (int i = 0; i < indent; ++i) {
            indentBuffer.append("  ");
        }
        String indentString = indentBuffer.toString();
        if (node.keys().length > 0) {
            this.bw.write(indentString);
            this.bw.write("<map>");
            this.bw.newLine();
            this.writeEntries(node, indentString + "  ");
            this.bw.write(indentString);
            this.bw.write("</map>");
        } else {
            this.bw.write("<map/>");
        }
        this.bw.newLine();
    }

    private void writeEntries(Preferences node, String indent) throws BackingStoreException, IOException {
        String[] keys = node.keys();
        for (int i = 0; i < keys.length; ++i) {
            String value = node.get(keys[i], null);
            if (value == null) {
                throw new BackingStoreException("null value for key '" + keys[i] + "'");
            }
            this.bw.write(indent);
            this.bw.write("<entry key=\"" + keys[i] + "\"" + " value=\"" + value + "\"/>");
            this.bw.newLine();
        }
    }

    private void indent(int x) throws IOException {
        for (int i = 0; i < x; ++i) {
            this.bw.write("  ");
        }
    }
}

