/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkFontMetrics;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkImagePainter;
import gnu.java.awt.peer.gtk.GtkOffScreenImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

public class GdkGraphics
extends Graphics {
    private final int native_state;
    Color color;
    Color xorColor;
    GtkComponentPeer component;
    Font font;
    Rectangle clip;
    int xOffset;
    int yOffset;
    static final int GDK_COPY = 0;
    static final int GDK_XOR = 2;

    private /* synthetic */ void finit$() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
        this.xOffset = 0;
        this.yOffset = 0;
    }

    native int[] initState(GtkComponentPeer var1);

    native void initState(int var1, int var2);

    native void copyState(GdkGraphics var1);

    GdkGraphics(GdkGraphics g) {
        this.finit$();
        this.color = g.color;
        this.xorColor = g.xorColor;
        this.font = g.font;
        this.clip = new Rectangle(g.clip);
        this.component = g.component;
        this.copyState(g);
    }

    GdkGraphics(int width, int height) {
        this.finit$();
        this.initState(width, height);
        this.color = Color.black;
        this.clip = new Rectangle(0, 0, width, height);
        this.font = new Font("Dialog", 0, 10);
    }

    GdkGraphics(GtkComponentPeer component) {
        this.finit$();
        this.component = component;
        int[] rgb = this.initState(component);
        this.color = new Color(rgb[0], rgb[1], rgb[2]);
        this.font = new Font("Dialog", 0, 10);
        Dimension d = component.awtComponent.getSize();
        this.clip = new Rectangle(0, 0, d.width, d.height);
    }

    public native void clearRect(int var1, int var2, int var3, int var4);

    public void clipRect(int x, int y, int width, int height) {
        this.clip = this.clip.intersection(new Rectangle(x, y, width, height));
        this.setClipRectangle(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public Graphics create() {
        return new GdkGraphics(this);
    }

    public native void dispose();

    native void copyPixmap(Graphics var1, int var2, int var3, int var4, int var5);

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (img instanceof GtkOffScreenImage) {
            this.copyPixmap(img.getGraphics(), x, y, img.getWidth(null), img.getHeight(null));
            return true;
        }
        GtkImage image = (GtkImage)img;
        new GtkImagePainter(image, this, x, y, -1, -1, bgcolor);
        return image.isLoaded();
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (img instanceof GtkOffScreenImage) {
            this.copyPixmap(img.getGraphics(), x, y, img.getWidth(null), img.getHeight(null));
            return true;
        }
        return this.drawImage(img, x, y, this.component.getBackground(), observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (img instanceof GtkOffScreenImage) {
            throw new RuntimeException();
        }
        GtkImage image = (GtkImage)img;
        new GtkImagePainter(image, this, x, y, width, height, bgcolor);
        return image.isLoaded();
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, this.component.getBackground(), observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (img instanceof GtkOffScreenImage) {
            throw new RuntimeException();
        }
        GtkImage image = (GtkImage)img;
        new GtkImagePainter(image, this, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor);
        return image.isLoaded();
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this.component.getBackground(), observer);
    }

    public native void drawLine(int var1, int var2, int var3, int var4);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawOval(int var1, int var2, int var3, int var4);

    public native void fillOval(int var1, int var2, int var3, int var4);

    public native void drawPolygon(int[] var1, int[] var2, int var3);

    public native void fillPolygon(int[] var1, int[] var2, int var3);

    public native void drawPolyline(int[] var1, int[] var2, int var3);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    native void drawString(String var1, int var2, int var3, String var4, int var5);

    public void drawString(String str, int x, int y) {
        this.drawString(str, x, y, this.font.getName(), this.font.getSize());
    }

    public void drawString(AttributedCharacterIterator ci, int x, int y) {
        throw new Error("not implemented");
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        return new Rectangle(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return new GdkFontMetrics(font);
    }

    native void setClipRectangle(int var1, int var2, int var3, int var4);

    public void setClip(int x, int y, int width, int height) {
        this.clip.x = x;
        this.clip.y = y;
        this.clip.width = width;
        this.clip.height = height;
        this.setClipRectangle(x, y, width, height);
    }

    public void setClip(Rectangle clip) {
        this.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public void setClip(Shape clip) {
        this.setClip(clip.getBounds());
    }

    private native void setFGColor(int var1, int var2, int var3);

    public void setColor(Color c) {
        this.color = c;
        if (this.xorColor == null) {
            this.setFGColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        } else {
            this.setFGColor(this.color.getRed() ^ this.xorColor.getRed(), this.color.getGreen() ^ this.xorColor.getGreen(), this.color.getBlue() ^ this.xorColor.getBlue());
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    native void setFunction(int var1);

    public void setPaintMode() {
        this.xorColor = null;
        this.setFunction(0);
        this.setFGColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    public void setXORMode(Color c) {
        this.xorColor = c;
        this.setFunction(2);
        this.setFGColor(this.color.getRed() ^ this.xorColor.getRed(), this.color.getGreen() ^ this.xorColor.getGreen(), this.color.getBlue() ^ this.xorColor.getBlue());
    }

    public native void translateNative(int var1, int var2);

    public void translate(int x, int y) {
        this.clip.x -= x;
        this.clip.y -= y;
        this.translateNative(x, y);
    }
}

