#ifndef __LS_ICONBOXWINCONFIG_H__
#define __LS_ICONBOXWINCONFIG_H__

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-client.h>
#include <libxfce4mcs/mcs-common.h>
#include <libxfce4mcs/mcs-manager.h>
#include <xfce-mcs-manager/manager-plugin.h>

#include <ls_iconbox.h>

typedef struct _LSIconBoxConf LSIconBoxConf;
typedef struct _LSIconBoxConfPrivate LSIconBoxConfPrivate;

struct _LSIconBoxConf
{
    LSIconBoxConfPrivate *priv;
};

struct _LSIconBoxConfPrivate
{
  GtkWindow             *pWindow;
  McsManager		*pmcsManager;
  McsPlugin		*pmcsPlugin;

  struct _LSIconBoxConfPrivateWidgets
  {
    GtkWindow           *pWindow;
    /* GLOBAL									*/
    GtkVBox		*main;
    /* FIRST frame								*/
    GtkVBox		*frame_1;
    GtkOptionMenu	*frame_1_combo_1;
    GtkMenuShell	*frame_1_combo_1_shell;
    GtkRadioButton	*frame_1_btn_group_1[4];
    /* SECOND frame								*/
    GtkVBox		*frame_2;
    GtkCheckButton	*frame_2_btn_0;
    GtkCheckButton	*frame_2_btn_1;
    GtkCheckButton	*frame_2_btn_2;
    GtkCheckButton	*frame_2_btn_3;
    /* DIALOG WIDGETS								*/
    GtkButton		*close;
    GtkButton		*apply;
  } widgets;
};

LSIconBoxConf 	*ls_iconboxconf_create_configwin(LSIconBoxWin *plsibw);
gboolean 	ls_iconboxconf_write(LSIconBoxConf *plsibwcw, 
    		  McsManager *pmcsm);
gboolean	ls_iconboxconf_read(LSIconBoxConf *plsibwcw, 
    		  McsManager *pmcsm);
void		ls_iconboxconf_connect_signals(
    		  LSIconBoxConf *plsibw);
void		ls_iconboxconf_open_channel(
    		  LSIconBoxConf *plsibwcw);
void		ls_iconboxconf_close_channel(
    		  LSIconBoxConf *plsibwcw);
void		ls_iconboxconf_set_mcsmanager(
    		  LSIconBoxConf *plsibw, McsManager *pmcsm);
void		ls_iconboxconf_re_evaluate_settings(
    		  LSIconBoxConf *plsibw);
#endif
