/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __pglobal_h__
#define __pglobal_h__

#include <qmap.h>

#include <kpanelapplet.h>
#include <kpanelextension.h>
#include <kurl.h>

namespace KickerLib
{

/*
 * Functions to convert between various enums
 */
KDE_EXPORT KPanelExtension::Position directionToPosition(KPanelApplet::Direction d);
KDE_EXPORT KPanelExtension::Position directionToPopupPosition(KPanelApplet::Direction d);
KDE_EXPORT KPanelApplet::Direction positionToDirection(KPanelExtension::Position p);
KDE_EXPORT int sizeValue(KPanelExtension::Size s);

/*
 * Pixel sizes for but sizes and margins
 */
KDE_EXPORT int maxButtonDim();
KDE_EXPORT int iconMargin();

/*
 * Tint the image to reflect the current color scheme
 * Used, for instance, by KMenu side bar
 */
KDE_EXPORT void colorize(QImage& image);

/*
 * Create or copy .desktop files for use in kicker safely and easily
 */
KDE_EXPORT QString copyDesktopFile(const KURL&url);
KDE_EXPORT QString newDesktopFile(const KURL&url);

/**
 * Calculate the appropriate position for a popup menu based on the
 * direction, the size of the menu, the widget geometry, and a optional
 * point in the local coordinates of the widget.
 */
KDE_EXPORT QPoint popupPosition(KPanelApplet::Direction d,
                                const QWidget* popup,
                                const QWidget* source,
                                const QPoint& offset = QPoint(0, 0));
}

#endif // __pglobal_h__
