/* This file is part of the KDE project
   Copyright (C) 2004 Alexander Dymo <cloudtemple@mksat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef KDEVDESIGNERINTEGRATION_H
#define KDEVDESIGNERINTEGRATION_H

#include <designer.h>
#include <qobject.h>
#include <qdom.h>

class KDevDesignerIntegration : public QObject
{
Q_OBJECT
public:
    KDevDesignerIntegration(QObject *parent = 0, const char *name = 0);
    ~KDevDesignerIntegration();
    
    virtual void saveSettings(QDomDocument dom, QString path) = 0;
    virtual void loadSettings(QDomDocument dom, QString path) = 0;
    
public slots:
    virtual void addFunction(const QString &formName, KInterfaceDesigner::Function function) = 0;
    virtual void removeFunction(const QString &formName, KInterfaceDesigner::Function function) = 0;
    virtual void editFunction(const QString &formName, KInterfaceDesigner::Function oldFunction, KInterfaceDesigner::Function function) = 0;

    virtual void openFunction(const QString &formName, const QString &functionName) = 0;
};

#endif
