/*
    Copyright (C) 2001-2003 KSVG Team
    This file is part of the KDE project

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "SVGAnimatedNumberImpl.h"
#include "SVGFEPointLightElementImpl.h"

using namespace KSVG;

SVGFEPointLightElementImpl::SVGFEPointLightElementImpl(DOM::ElementImpl *impl) : SVGElementImpl(impl)
{
	m_x = new SVGAnimatedNumberImpl();
	m_x->ref();
	
	m_y = new SVGAnimatedNumberImpl();
	m_y->ref();

	m_z = new SVGAnimatedNumberImpl();
	m_z->ref();
}

SVGFEPointLightElementImpl::~SVGFEPointLightElementImpl()
{
	if(m_x)
		m_x->deref();
	if(m_y)
		m_y->deref();
	if(m_z)
		m_z->deref();
}

SVGAnimatedNumberImpl *SVGFEPointLightElementImpl::x() const
{
	return m_x;
}

SVGAnimatedNumberImpl *SVGFEPointLightElementImpl::y() const
{
	return m_y;
}

SVGAnimatedNumberImpl *SVGFEPointLightElementImpl::z() const
{
	return m_z;
}

// vim:ts=4:noet
