/*
 * xfce4    - (c) 2002 Olivier Fourdan
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTKTOXEVENT_H__
#define __GTKTOXEVENT_H__

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>

typedef enum
{
    XEV_FILTER_STOP = TRUE,
    XEV_FILTER_CONTINUE = FALSE
}
GtkToXEventFilterStatus;

typedef GtkToXEventFilterStatus (*GtkToXEventFilter) (XEvent * xevent,
						      gpointer data);

typedef struct GtkToXEventFilterStack
{
    GtkToXEventFilter filter;
    gpointer data;
    struct GtkToXEventFilterStack *next;
}
GtkToXEventFilterStack;

GtkToXEventFilterStack *pushEventFilter (GtkToXEventFilter filter,
					 gpointer data);
GtkToXEventFilterStack *popEventFilter (void);
GtkToXEventFilterStack *initEventFilter (long event_mask, gpointer data,
					 const gchar * widget_name);
void closeEventFilter (void);
GtkWidget *getDefaultGtkWidget (void);
Window getDefaultXWindow (void);
GdkWindow *getGdkEventWindow (void);
GdkWindow *getDefaultGdkWindow (void);

#endif /* __GTKTOXEVENT_H__ */
