//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2002 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#ifndef PMLIBRARYOBJECTPREVIEW_H
#define PMLIBRARYOBJECTPREVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qimage.h>

#include <kurl.h>

class QLabel;
class QLineEdit;
class QMultiLineEdit;
class QPushButton;
class QFrame;
class PMPart;
class PMTreeView;

/**
 * Preview widget for Library Objects.
 */
class PMLibraryObjectPreview: public QWidget
{
   Q_OBJECT
public:
   PMLibraryObjectPreview( QWidget *parent );
   /** Allow editing of the objects */
   void allowEdit( bool b );
   /** Called to show the file preview. 
    *  Returns true if the previous file was saved to disk. */
   bool showPreview( KURL url );
   /** Clears the preview */
   virtual void clearPreview( );
   
private slots:
   /** Called when description or keywords are changed */
   void textChanged( );
   /** Called when the name is changed */
   void textChanged( const QString& s );
   /** Called when the set preview button is clicked */
   void slotPreviewClicked( );
private:

   /** Called to load the object tree. */
   void loadObjects( QByteArray* obj );

   PMPart*         m_pPart;
   QLineEdit*      m_pName;
   QMultiLineEdit* m_pDescription;
   QMultiLineEdit* m_pKeywords;
   PMTreeView*     m_pContentsPreview;
   QPushButton*    m_pSetPreviewImageButton;

   QImage          m_image;
   KURL            m_currentObjectURL;

   bool m_needsSave;
};

#endif
