//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;

/**

 Class representing data about an application startup notification.
 Such data include the icon of the starting application, the desktop on which
 the application should start, the binary name of the application, etc.
		@author Lubos Lunak <l.lunak@kde.org>

		@version  kstartupinfo.h,v 1.28 2003/10/23 17:40:25 lunakl
 
		@short    Class representing data about an application startup notification.
		@see KStartupInfo
		@see KStartupInfoId

*/
public class KStartupInfoData implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KStartupInfoData(Class dummy){}

	public static final int Yes = 0;
	public static final int No = 1;
	public static final int Unknown = 2;

	/**	
		 Sets the binary name of the application ( e.g. 'kcontrol' ).
			@param bin the new binary name of the application
			 		@short    Sets the binary name of the application ( e.
	*/
	public native void setBin(String bin);
	/**	
		 Returns the binary name of the starting application
				@return the new binary name of the application
	 
		@short    Returns the binary name of the starting application
	*/
	public native String bin();
	/**	
		 Sets the name for the notification (e.g. 'Control Center')
			 		@short    Sets the name for the notification (e.
	*/
	public native void setName(String name);
	/**	
		 Returns the name of the startup notification. If it's not available,
		 it tries to use other information (binary name).
				@return the name of the startup notification
	 
		@short    Returns the name of the startup notification.
	*/
	public native String findName();
	/**	
		 Returns the name of the startup notification, or empty if not available.
				@return the name of the startup notification, or an empty string
         if not set.
	 
		@short    Returns the name of the startup notification, or empty if not available.
	*/
	public native String name();
	/**	
		 Sets the description for the notification (e.g. 'Launching Control Center').
		 I.e. name() describes what is being started, while description() is
		 the actual action performed by the starting.
				@short    Sets the description for the notification (e.
	*/
	public native void setDescription(String descr);
	/**	
		 Returns the description of the startup notification. If it's not available,
		 it returns name().
				@return the description of the startup notification

		@short    Returns the description of the startup notification.
	*/
	public native String findDescription();
	/**	
		 Returns the name of the startup notification, or empty if not available.
				@return the name of the startup notificaiton, or an empty string
         if not set.

		@short    Returns the name of the startup notification, or empty if not available.
	*/
	public native String description();
	/**	
		 Sets the icon for the startup notification ( e.g. 'kcontrol' )
			@param icon the name of the icon
			 		@short    Sets the icon for the startup notification ( e.
	*/
	public native void setIcon(String icon);
	/**	
		 Returns the icon of the startup notification, and if it's not available,
		 tries to get it from the binary name.
				@return the name of the startup notification's icon, or the name of
         the binary if not set
	 
		@short    Returns the icon of the startup notification, and if it's not available,  tries to get it from the binary name.
	*/
	public native String findIcon();
	/**	
		 Returns the icon of the startup notification, or empty if not available.
				@return the name of the icon, or an empty string if not set.
	 
		@short    Returns the icon of the startup notification, or empty if not available.
	*/
	public native String icon();
	/**	
		 Sets the desktop for the startup notification ( i.e. the desktop on which
		 the starting application should appear ).
			@param desktop the desktop for the startup notification
			 		@short    Sets the desktop for the startup notification ( i.
	*/
	public native void setDesktop(int desktop);
	/**	
		 Returns the desktop for the startup notification.
				@return the desktop for the startup notification
	 
		@short    Returns the desktop for the startup notification.
	*/
	public native int desktop();
	/**	
		 Sets a WM_CLASS value for the startup notification, it may be used for increasing
		 the chance that the windows created by the starting application will be
		 detected correctly.
			@param wmclass the WM_CLASS value for the startup notification
			 		@short    Sets a WM_CLASS value for the startup notification, it may be used for increasing  the chance that the windows created by the starting application will be  detected correctly.
	*/
	public native void setWMClass(String wmclass);
	/**	
		 Returns the WM_CLASS value for the startup notification, or binary name if not
		 available.
				@return the WM_CLASS value for the startup notification, or the binary name
         if not set
	 
		@short    Returns the WM_CLASS value for the startup notification, or binary name if not  available.
	*/
	public native String findWMClass();
	/**	
		 Returns the WM_CLASS value for the startup notification, or empty if not available.
				@return the WM_CLASS value for the startup notification, or empty
         if not set
	 
		@short    Returns the WM_CLASS value for the startup notification, or empty if not available.
	*/
	public native String WMClass();
	/**	
		 Adds a PID to the list of processes that belong to the startup notification. It
		 may be used to increase the chance that the windows created by the starting
		 application will be detected correctly, and also for detecting if the application
		 has quit without creating any window.
			@param pid the PID to add
			 		@short    Adds a PID to the list of processes that belong to the startup notification.
	*/
	public native void addPid(int pid);
	/**	
		 Returns all PIDs for the startup notification.
				@return the list of all PIDs
	 
		@short    Returns all PIDs for the startup notification.
	*/
	// const QValueList< pid_t >& pids(); >>>> NOT CONVERTED
	/**	
		 Checks whether the given <code>pid</code> is in the list of PIDs for starup
		 notification.
				@return true if the given <code>pid</code> is in the list of PIDs for the startup notification
	 
		@short    Checks whether the given <code>pid</code> is in the list of PIDs for starup  notification.
	*/
	public native boolean is_pid(int pid);
	/**	
		 Sets the hostname on which the application is starting. It's necessary to set
		 it if PIDs are set.
			@param hostname the application's hostname. If it's a null string, the current hostname is used
			 		@short    Sets the hostname on which the application is starting.
	*/
	public native void setHostname(String hostname);
	public native void setHostname();
	/**	
		 Returns the hostname for the startup notification.
				@return the hostname
	 
		@short    Returns the hostname for the startup notification.
	*/
	public native String hostname();
	/**	
		 Sets whether the visual feedback for this startup notification
		 should be silenced (temporarily suspended).
				@short    Sets whether the visual feedback for this startup notification  should be silenced (temporarily suspended).
	*/
	public native void setSilent(int state);
	/**	
		 Return the silence status for the startup notification.
				@return KStartupInfoData.Yes if visual feedback is silenced

		@short    Return the silence status for the startup notification.
	*/
	public native int silent();
	/**	
		 Sets timestamp for the startup notification. The timestamp is expressed
		 as XServer time, and is used to prevent activation of the matching
		 window if user interaction took place after this timestamp.
		 Value -1 means no timestamp set, value 0 means that the window should
		 not be activated.
		         		@short    Sets timestamp for the startup notification.
	*/
	public native void setTimestamp(long time);
	/**	
		 Return the timestamp for the startup notification, or -1 if no timestamp
		 is set.
		         		@short    Return the timestamp for the startup notification, or -1 if no timestamp  is set.
	*/
	public native long timestamp();
	/**	
		 The X11 screen on which the startup notification is happening, -1 if unknown.
		         		@short    The X11 screen on which the startup notification is happening, -1 if unknown.
	*/
	public native int screen();
	/**	
		 Sets the X11 screen on which the startup notification should happen.
		 This is usually not necessary to set, as it's set by default to qt_xscreen().
		         		@short    Sets the X11 screen on which the startup notification should happen.
	*/
	public native void setScreen(int screen);
	/**	
		 Updates the notification data from the given data. Some data, such as the desktop
		 or the name, won't be rewritten if already set.
			@param data the data to update
			 		@short    Updates the notification data from the given data.
	*/
	public native void update(KStartupInfoData data);
	/**	
		 Constructor. Initializes all the data to their default empty values.
			 		@short    Constructor.
	*/
	public KStartupInfoData() {
		newKStartupInfoData();
	}
	private native void newKStartupInfoData();
	/**	
		 Copy constructor.
			 		@short    Copy constructor.
	*/
	public KStartupInfoData(KStartupInfoData data) {
		newKStartupInfoData(data);
	}
	private native void newKStartupInfoData(KStartupInfoData data);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
