/* kasgrouppopup.cpp
**
** Copyright (C) 2001-2003 Richard Moore <rich@kde.org>
** Contributor: Mosfet
**     All rights reserved.
**
** KasBar is dual-licensed: you can choose the GPL or the BSD license.
** Short forms of both licenses are included below.
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
** MA 02111-1307, USA.
*/

/*
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/
#include <qlayout.h>
#include <qtimer.h>

#include <kapplication.h>

#include "kasgroupitem.h"
#include "kastasker.h"

#include "kasgrouppopup.h"
#include "kasgrouppopup.moc"

static const int KAS_GROUP_POPUP_KILL_DELAY = 6000;
KasGroupPopup::KasGroupPopup( KasGroupItem *item, const char *name )
    : KasPopup( item, name )
{
    this->item = item;

    QHBoxLayout *box = new QHBoxLayout( this );

    KasTasker *master = static_cast<KasTasker *> (kasbar());
    childBar_ = new KasTasker( ( kasbar()->orientation() == Horizontal ) ? Vertical : Horizontal,
			       master, this );
    childBar_->setConfig( master->config());

    box->addWidget( childBar_ );
    resize( childBar_->size() );

    killTimer_ = new QTimer( this, "kill_timer" );
    connect( killTimer_, SIGNAL( timeout() ), this, SLOT( maybeHide() ) );
    killTimer_->start( KAS_GROUP_POPUP_KILL_DELAY, true );
}

KasGroupPopup::~KasGroupPopup()
{
}

void KasGroupPopup::maybeHide()
{
    if ( childBar_->itemUnderMouse() ) {
	killTimer_->start( KAS_GROUP_POPUP_KILL_DELAY, true );
	return;
    }

    doHide();
}

void KasGroupPopup::doHide()
{
    item->hidePopup();
}

