/*
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "galeon-embed-event.h"

#include <glib/gi18n.h>
#include <glib/ghash.h>
#include <gtk/gtktypeutils.h>

struct GaleonEmbedEventPrivate
{
	GHashTable *props;
};

static void
galeon_embed_event_class_init (GaleonEmbedEventClass *klass);
static void
galeon_embed_event_init (GaleonEmbedEvent *ges);
static void
galeon_embed_event_finalize (GObject *object);

static GObjectClass *parent_class = NULL;

GType
galeon_embed_event_get_type (void)
{
       static GType galeon_embed_event_type = 0;

        if (galeon_embed_event_type == 0)
        {
                static const GTypeInfo our_info =
                {
                        sizeof (GaleonEmbedEventClass),
                        NULL, /* base_init */
                        NULL, /* base_finalize */
                        (GClassInitFunc) galeon_embed_event_class_init,
                        NULL, /* class_finalize */
                        NULL, /* class_data */
                        sizeof (GaleonEmbedEvent),
                        0,    /* n_preallocs */
                        (GInstanceInitFunc) galeon_embed_event_init
                };

                galeon_embed_event_type = g_type_register_static (G_TYPE_OBJECT,
                                                                  "GaleonEmbedEvent",
                                                                  &our_info, 0);
        }

        return galeon_embed_event_type;
}

static void
galeon_embed_event_class_init (GaleonEmbedEventClass *klass)
{
        GObjectClass *object_class = G_OBJECT_CLASS (klass);

        parent_class = g_type_class_peek_parent (klass);
	
        object_class->finalize = galeon_embed_event_finalize;
}

static void
free_g_value (gpointer value)
{
	g_value_unset (value);
	g_free (value);
}

static void
galeon_embed_event_init (GaleonEmbedEvent *event)
{
        event->priv = g_new0 (GaleonEmbedEventPrivate, 1);

	event->priv->props = 
		g_hash_table_new_full (g_str_hash, g_str_equal, 
				       g_free, free_g_value);
}

static void
galeon_embed_event_finalize (GObject *object)
{
        GaleonEmbedEvent *event;

        g_return_if_fail (object != NULL);
        g_return_if_fail (IS_GALEON_EMBED_EVENT (object));

        event = GALEON_EMBED_EVENT (object);

        g_return_if_fail (event->priv != NULL);

	g_hash_table_destroy (event->priv->props);
	
	g_free (event->priv);
	
        G_OBJECT_CLASS (parent_class)->finalize (object);
}


GaleonEmbedEvent *
galeon_embed_event_new (void)
{
	GaleonEmbedEvent *event;

        event = GALEON_EMBED_EVENT (g_object_new (GALEON_EMBED_EVENT_TYPE, NULL));

        g_return_val_if_fail (event->priv != NULL, NULL);

        return event;
}

gresult
galeon_embed_event_get_modifier (GaleonEmbedEvent *event,
				 guint *modifier)
{
	*modifier = event->modifier;
	return G_OK;
}

gresult
galeon_embed_event_get_mouse_button (GaleonEmbedEvent *event,
		          	     guint *mouse_button)
{
	*mouse_button = event->mouse_button;
	return G_OK;
}

gresult
galeon_embed_event_get_coords	(GaleonEmbedEvent *event,
				 guint *x, guint *y)
{
	*x = event->x;
	*y = event->y;
	return G_OK;
}

gresult 
galeon_embed_event_get_context (GaleonEmbedEvent *event,
				EmbedEventContext *context)
{
	*context = event->context;
	return G_OK;
}

void 
galeon_embed_event_set_property (GaleonEmbedEvent *event,
				  const char *name,
				  GValue *value)
{
	g_hash_table_insert (event->priv->props, 
                             g_strdup (name),
                             value);
}

void
galeon_embed_event_get_property	(GaleonEmbedEvent *event,
				 const char *name,
				 const GValue **value)
{
	
	*value = g_hash_table_lookup (event->priv->props,
	   		     	      name);
}

gboolean
galeon_embed_event_has_property	(GaleonEmbedEvent *event,
				 const char *name)
{
	gpointer tmp;
	
	tmp = g_hash_table_lookup (event->priv->props,
	   			   name);

	return tmp != NULL;
}
