/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 	/* ------------------------------------------------------------
 	*
 	*              Read country data  from disk
 	*--------------------------------------------------------------*/

#include "readctydata.h"
#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif


    int  readctydata(void)
    {
    	extern char prefixlines[MAX_DBLINES][17];
    	extern char zonearray[MAX_DBLINES][3];
	extern char ituarray[MAX_DBLINES][3];
	extern int dataindex[MAX_DBLINES];
	extern char datalines[MAX_DATALINES][81];

    	char buf[81] = "";
	char ctydb_location[80];
    	int  n = 0, j  = 0, k = 0;

	FILE  *fp_db;

	strcpy(ctydb_location, PACKAGE_DATA_DIR) ;
	strcat(ctydb_location, "/ctydb.dat") ;

         if ( (fp_db  = fopen (ctydb_location, "r")) ==  NULL)
    {
    	mvprintw(4,0,  "Error opening ctydb.dat  file.\n");
		refresh();
		sleep(5);
    	endwin();
    	exit(1);
    }
/* read  ctydb.dat file ---------------------------------------------------- */


    while ( !feof(fp_db))
    {
     	fgets (buf,  180,  fp_db);
     	
     	n =(strcspn(buf, "(["));                           /*  problem  to be fixed */
     	
  	
    	if ((strspn(buf,  "  ") != 0)){                     /*  prefix line */
    		   	
    		   	if (  n == strlen(buf)){
          			strncpy (prefixlines[j], buf + 4, strlen(buf) - 5);
          			}
          		else
          			{
          			strncpy (prefixlines[j], buf + 4, n - 4 );    /* remove zone  info */
          			
          			n = strcspn(buf,  "(");
          			
          			if (n  !=  strlen(buf)){
					if (buf[n+2] != ')') {
						zonearray[j][0]  = buf[n+1];
          			 		zonearray[j][1]  = buf[n+2];
					}  else {
						zonearray[j][0]  = '0';
          			 		zonearray[j][1]  = buf[n+1];
					}
          			 	zonearray[j][2] =  '\0';
          			}
          			else
          				zonearray[j][0] = '\0';
          				
					n  =  strcspn(buf,  "[");

					if (n != strlen(buf)){                       // to be fixed (2])
					 	ituarray[j][0] = buf[n+1];
					 	ituarray[j][1] = buf[n+2];
					 	ituarray[j][2] = '\0';

					}
					else
						ituarray[j][0] = '\0';
          				
          			}
            dataindex[j] = k -  1;
            j++;
  			}
     	else
     		{
     		if (strlen(buf) >=  2){
     			strncpy (datalines[k],  buf, 80);         /*  data line  */
                k++ ;
     			 }
     		}

//mvprintw(14,0, "                                       ");
//mvprintw(14,0, "%s|     %d|%s|\n%s", prefixlines[j-1], dataindex[j-1], zonearray[j-1],datalines[dataindex[j-1]]);
//refresh();
//sleep(1);

    }

 	fclose(fp_db);
 	
	return(0);
    }

