/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#define NDEBUG
#define NEWCODE = 1

#include "tlf.h"
#include "main.h"
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


  SCREEN *mainscreen;
  SCREEN *packetscreen;
  WINDOW *sclwin, *entwin;

 extern int lan_active;

  int prsock = 0;
  char pr_hostaddress[16]="131.155.192.179";
  int portnum = 0;
  struct tln_logline  *loghead = NULL;
  struct tln_logline   *logtail = NULL;
  struct tln_logline  *viewing = NULL;
  struct tln_logline *temp=NULL;

  int use_rxvt = 0;
  int debugflag = 0;
  int editor = EDITOR_JOE;
  int use_vk = 0;
  int cqww = 0;
  int cqwwm2=0;
  int wpx  =  0;
  int pfxmult = 1;
  int exc_cont = 0;
  int dxped = 0;
  int sprint = 0;
  int arrldx_usa = 0;
  int arrl_fd=0;
  int arrlss=0;
  int pacc_pa_flg = 0;
  int universal=0;
  int addcallarea;
  int manise80;
  int other_flg;
  int one_point=0;
  int two_point=0;
  int three_point=0;
  int two_eu_three_dx_points=0;
  /* LZ3NY mods */
	char contest_name[50];
	int multiplier_points=-1;
	int my_country_points=-1;
	int my_cont_points=-1;
	int dx_cont_points=-1;
	char mit_multiplier_list[255][6];
	char multiplier_list[50];
	int multiplier_only=0;
	int mult_side=0;
	char *mit_mult_array;
	int in_country_list;
/* end LZ3NY mods */

  int portable_x2=0;
  int recall_mult=0;
  int exchange_serial=0;
  int wysiwyg_once=0;
  int wysiwyg_multi=0;
  int country_mult=0;
  int fixedmult=0;
  int sectn_mult=0;
  int dx_arrlsections = 0;
  int serial_section_mult = 0;
  int qso_once = 0;
  int addcallarea_once = 0;
  int noleadingzeros;
  int ctcomp = 0;
  int isdupe = 0; //0 if nodupe -- for auto qso b4 (LZ3NY)
  int nob4 = 0;   // allow auto b4
  int emptydir = 0;
  int verbose = 0;

  int pacc_qsos[10][10];
  int ve_cty;
  int w_cty;
  int zl_cty;
  int ja_cty;
  int py_cty;
  int ce_cty;
  int lu_cty;
  int vk_cty;
  int zs_cty;
  int ua9_cty;

  char tlfversion[80] = "";
  char multiplierlist[40]="";
  int timeoffset=0;
  int multi = 0;                /* 0 = SO , 1 = MOST, 2 = MM */
  int trxmode = CWMODE;
  int mixedmode = 0;
  char his_rst[4] = "599";
  char my_rst[4] = "599";
  int mults_per_band = 1;		/* mults count per band */
  int shortqsonr =  LONGCW;     /*   1  =  short  cw char in exchange              */
  int cluster = NOCLUSTER;      /*   0 = OFF, 1 = FOLLOW     2  = spots  3 = all   */
  int searchflg  = 0;		    /*   1  = display search  window */
  int show_time=0;
  int cqmode  = CQ;             /* 1  = CQ  0 = S&P  */
  int demode  = 0;              /* 1 =  send DE  before s&p call  */
  int contest = 0;		        /* 0 =  General,  1  = contest */
  int announcefilter  = FILTER_ANN;	/*  filter cluster  announcements */
  int showscore_flag = 0;		/* show  score window */
  char exchange[40];
  char sp_return[80] = " \n";
  char cq_return[80] = " \n";
  char whichcontest[40] = "qso";
  int defer_store = 0;
  char buffer[162];
  char call[20];
  char logfile[120] = "general.log";
  char markerfile[120] = "";
  int xplanet = 0;
  char message[25][80] = {"TEST %\n","@ DE %\n","@ [\n","TU 73\n"," @\n","%\n","@ SRI QSO B4 GL\n","AGN\n",
  						" ?\n"," QRZ?\n"," PSE K\n","TEST % %\n","@ [\n","TU %\n","","","","","","","","","","",""};
  char ph_message[14][40] = {"","","","","","","","","","","",""}; 		// voice keyer file names
  char hiscall[20];
  char lastcall[20];
  char lastcomment[40];
  char qsonrstr[5] =  "0001";
  char band[9][4] = {"160"," 80"," 40"," 30"," 20"," 17"," 15"," 12"," 10"};
  char comment[80];
  char mode[20] = "Log     ";
  char cqzone[3]  = "";
  char mycqzone[3] = "";
  char ituzone[3] = "";
  char continent[3] = "";
  char mycontinent[3]  = "";
  char pxstr[11]  = "";
  int bandindex = 0;
  int nr_of_px = 0;
  int totalmults = 0;
  int totalcountries = 0;
  int totalzones = 0;
  int secs = 0;
  int countrynr;
  int mycountrynr = 215;
  int points = 0;
  char pointstring[2]  = "";
  int total  = 0;
  int band_score[9];
  int dupe = 0;
  int callfound=0;
  int partials=0;
  int use_part=0;
  int bigpartlist=0;
  int block_part=0;
  char para_word[80] ="LODNCFS:3C\n"; /* longcw, cluster, search,  DE, contest, filter,  speed,  delay */
  char lastmsg[1000]="";
/*-------------------------------------keyer------------------------------*/
  int keyerport = NO_KEYER;
  int speed = 10;
  int txdelay = 0;
  int weight = 0;
  char weightbuf[3];
  char speedstr[50] = CW_SPEEDS;
  char tonestr[5]  = "600";
  int cqdelay = 3;
  char wkeyerbuffer[400];
  int keyspeed = 5;
  int cfd;  				/* cwkeyer file descriptor */
  int data_ready = 0;
	char keyer_device[10]= "";	// ttyS0, ttyS1, lp0-2
	char portaddress[10]= "";	// port address (0x378 etc)
	int k_tune;
	int k_pin14;
	int k_ptt;

/*-------------------------------------packet-------------------------------*/
  char spot_ptr[100][82];
  int spotarray[100];
  char spotinfo[32][82];
  int ptr;
  int spot_rdr;
  long int *wwv_ptr;
  int packetinterface = 0;
  int fdSertnc=0;
  int fdFIFO=0;
  int tncport=1;
  int in_packetclient;
  int tnc_serial_rate = 2400;


/*-------------------------------------rigctl-------------------------------*/
#ifdef HAVE_LIBHAMLIB
	rig_model_t myrig_model=351;
	RIG *my_rig;		/* handle to rig (instance) */
	freq_t rigfreq;		/* input frequency  */
	freq_t outfreq;             /* output  to rig */
	rmode_t rmode;		/* radio mode of operation */
	pbwidth_t width;
	vfo_t vfo;			/* vfo selection */
	port_t myport;
#else
	int outfreq;             /* output  to rig */
#endif
	int serial_rate = 2400;
	int rig_port=0;
/*---------------------------------simulator-------------------------------*/

   int simulator = 0;
   int simulator_mode=0;
   int simulator_seed=8327;
   long system_secs;
   char tonecpy[5];
   char simulator_tone[5];
/*---------------------------------end simulator-------------------------------*/


  char qsos[MAX_QSOS][82];
  int nr_qsos = 0 ;
  char datalines[MAX_DATALINES][81];         /* country  database */
  char prefixlines[MAX_DBLINES][17];
  char zonearray[MAX_DBLINES][3];
  char ituarray[MAX_DBLINES][3];
  int dataindex[MAX_DBLINES];      /*  index to  datalines */
  char callarray[MAX_CALLS][12];       /*  internal log representation for duping  */
  char call_exchange[MAX_CALLS][12];
  int  call_band[MAX_CALLS];
  int call_country[MAX_CALLS];
  char prefixes_worked[MAX_CALLS][6];
  int  countries[MAX_DATALINES];
  int  zones[41];                   /* using 1 - 40, cqzones */
  char mults[MAX_MULTS][12];
  char mults_possible[MAX_MULTS][12];
  int multlist = 0;
  int max_multipliers;
  int mult_bands[MAX_MULTS];
  char callmasterarray[28000][9];
  char callmaster_result[50][9];
  int max_callmastercalls;
  int callareas[20];
  int multscore[6];
  int multarray_nr = 0;
  int wysiwygmults = 0;
  int callarray_nr =  0;
  int zonescore[6];
  int countryscore[6];
  int zonedisplay = 0;
  int addzone = 0;                   /* flag for new zone */
  int addcty = 0;                    /* flag for new country */
  int shownewmult = -1;

  int bandinx = 2;  /* 40m */
  int qsonum = 1;
  int bufloc = 0;
  int ymax, xmax;
  int cury, curx;                    /* to remember cursor position */
  int oldtens = 0;
  char lastwwv[120] = "" ;
  int bandmap_pos = 0;
  int nroflines;

  	pid_t pid;
	struct tm *time_ptr;


  char logline0[81] = "";
  char logline1[81] = "";
  char logline2[81] = "";
  char logline3[81] = "";
  char logline4[240] = "";
  char qrg_string[8];
  float freq;
  float mem;
  int rit;
  int trx_control = 0;
  int showfreq = 0;
  float bandfrequency[9] = {1830.0, 3525.0, 7010.0, 10105.0, 14025.0, 18070.0, 21025.0, 24900.0, 28025.0};
  char spot_target[8][40];

  char headerline[81] = "   1=CQ  2=DE  3=RST 4=73  5=HIS  6=MY  7=B4   8=AGN  9=?  \n";
  char infoline[81]  =  "";
  char backgrnd_str[81] = "                                                                                ";

  char terminal1[81] = "";
  char terminal2[81] = "";
  char terminal3[81] = "";
  char terminal4[81] = "";
  char termbuf[81] = "";
  int termbufcount = 0;

  char C_QTH_Lat[7] = "51";
  char C_QTH_Long[8] = "-5";
  char C_DEST_Lat[7] = "51";
  char C_DEST_Long[8] = "1";

  double yt = -4.9;      /* for muf calculation */
  double xt = 52.4;
  double yr = 5.0;
  double xr = 50.0;
  double r = 50;
  int m = 1;
  char hiscountry[40];

  double range, bearing;
  double sunrise;
  double sundown;

  int this_second;
  int stop_backgrnd_process = 1;      /* dont start until we know what we are doing */


/* ------------------------------------------------------------------------*/
/*     Main loop of the program			                           */
/* ------------------------------------------------------------------------*/

int main(int argc, char *argv[])
{
	int j;
  	pthread_t thrd1, thrd2;
  	int ret;
	int retval;
	char keyerbuff[3];
	int nopacket = 0;

while ((argc > 1) && (argv[1][0] == '-')) {
	switch (argv[1][1]) {
		/* verbose option */
		case 'd':				// debug rigctl
			debugflag = 1;
			break;
		case 'v':				// verbose startup
			verbose = 1;
			break;
		case 'V':				// output version
			printf("Version: tlf-%s\n", VERSION);
			exit(0);
			break;
		case 'n':				// output version
			nopacket = 1;
			break;
		case 'x':
			use_rxvt = 1;
			break;
		default:
			printf("Use: tlf [-v] Verbose\n");
			printf("         [-V] Version\n");
			printf("         [-d] Debug mode\n");
			printf("         [-h] This message\n");
			printf("         [-n] Start without packet\n");
			printf("         [-x] Use rxvt colours\n");
			exit(0);
			break;
	}
	--argc;
	++argv;
}


buffer[0] = '\0';
buffer[79] = '\0';
bufloc = 0;

strcat (logline0,  backgrnd_str);
strcat (logline1,  backgrnd_str);
strcat (logline2,  backgrnd_str);
strcat (logline3,  backgrnd_str);
strcat (logline4,  backgrnd_str);

strcat (terminal1,  backgrnd_str);
strcat (terminal2,  backgrnd_str);
strcat (terminal3,  backgrnd_str);
strcat (terminal4,  backgrnd_str);


termbuf[0] = '\0';
hiscall[0] = '\0';




if ((mainscreen = newterm(NULL, stdout, stdin)) == NULL){         /* activate ncurses terminal control */
 		perror("initscr");
		printf("\n Sorry, wrong terminal type !!!!! Try a  linux text terminal or a rxvt!!!" );
		sleep(5);

 		exit(EXIT_FAILURE);
 	}


getmaxyx(stdscr, ymax, xmax);
noecho();
crmode();

strcpy(sp_return, message[12]);
strcpy(cq_return,  message[13]);

refresh();


 	if (has_colors()){
 		if (start_color() == ERR){
 			perror("start_color");
 			endwin();
			printf("\n Sorry, wrong terminal type !!!!! \nTry a linux text terminal or rxvt!!!" );
			sleep(5);
	 		exit(EXIT_FAILURE);
	 		}
    // use linux console colours
		init_pair(COLOR_BLACK, COLOR_BLACK, COLOR_WHITE);
	 	init_pair(COLOR_GREEN, COLOR_GREEN, COLOR_YELLOW);
	 	init_pair(COLOR_RED, COLOR_WHITE, COLOR_RED);
	 	init_pair(COLOR_CYAN, COLOR_CYAN, COLOR_WHITE);
	 	init_pair(COLOR_WHITE, COLOR_WHITE, COLOR_BLACK);
	 	init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_WHITE);
	 	init_pair(COLOR_BLUE, COLOR_BLUE, COLOR_YELLOW);
	 	init_pair(COLOR_YELLOW, COLOR_CYAN, COLOR_YELLOW);


		strcpy(tlfversion, "        Welcome to tlf-");
		strcat(tlfversion, VERSION);
		strcat(tlfversion, " by PA0RCT!!");
		mvprintw(0, 0, tlfversion);


		refresh();

 mvprintw(3,0, "reading country data");
 refresh();

		readctydata();          /* read ctydb.dat */

 mvprintw(4,0, "reading configuration data");
 refresh();


		read_logcfg();          /* read the configuration file */

if (use_rxvt == 1) {                                  // use rxvt colours
			init_pair(COLOR_BLACK, COLOR_BLACK, COLOR_RED);
	 		init_pair(COLOR_GREEN, COLOR_GREEN, COLOR_YELLOW);
	 		init_pair(COLOR_RED, COLOR_WHITE, COLOR_RED);
	 		init_pair(COLOR_CYAN, COLOR_CYAN, COLOR_RED);
	 		init_pair(COLOR_WHITE, COLOR_WHITE, COLOR_BLACK);
			init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_RED);
	 		init_pair(COLOR_BLUE, COLOR_BLUE, COLOR_YELLOW);
	 		init_pair(COLOR_YELLOW, COLOR_CYAN, COLOR_YELLOW);
}


if (multlist ==1) {
	 mvprintw(4,0, "reading multiplier data      ");
 	refresh();

		max_multipliers = load_multipliers();

}

  attron(COLOR_PAIR(COLOR_BLACK));
  mvprintw(5,0, "reading callmaster data");
  refresh();

  		max_callmastercalls = load_callmaster();

#ifdef HAVE_LIBHAMLIB                                    // Code for hamlib interface
mvprintw(8,0, "%s\n", "HAMLIB defined");
refresh();
		if (trx_control  != 0){

			mvprintw(6,0, "Rig model nr = %d", (int)myrig_model);
			mvprintw(7,0, "Rig speed = %d", serial_rate) ;
 			refresh();


			mvprintw(8,0, "Trying to start rig ctrl");
 			refresh();

			init_tlf_rig () ;
		}
#else
		if  (trx_control  != 0) {
			trx_control = 0;
			mvprintw(8,0, "No Hamlib library, switching rigcontrol off");
 			refresh();
			sleep(1);
		}
#endif                                                   // end code for hamlib interface

		if (keyerport == NET_KEYER)  {
			mvprintw(9,0, "Keyer = %s", "cwdaemon") ;
 			refresh();
			if (verbose == 1) sleep(1);
		 }

		if(lan_active == 1) {
			retval = lanrecv_init();

			if (retval < 0)         /* set up the network */
			 	mvprintw(10,0, "LAN receive  init failed, %d",retval) ;
			else
			 	mvprintw(10,0, "LAN receive  initialized") ;

			if (lan_send_init() < 0)
				mvprintw(11,0, "LAN send init failed");
			else
				mvprintw(11,0, "LAN send initialized");

      			refresh();
		}
		if (verbose == 1) sleep(5);

		checkparameters() ;    /* check .paras file */

		clear();
		strcpy(tlfversion, "        Welcome to tlf-");
		strcat(tlfversion, VERSION);
		strcat(tlfversion, " by PA0RCT!!\n\n");
		mvprintw(0, 0, tlfversion);
		refresh();
		getmessages();          /* read .paras file */
		
		if (nopacket == 1) packetinterface = 0;

		if (packetinterface != 0){

			if (init_packet() == 0)
			 	packet();
			else
				cleanup_telnet();

		}


		set_term(mainscreen);

		refresh();

		if (keyerport == LPT_KEYER) {    /* open keyer interface if it is there */
			cfd = open("/dev/cwkeyer0", O_RDWR  );
			if (cfd == -1) {
				mvprintw(24,0, "Cannot open LPT keyer module > switching to SSB !");
				refresh();
				sleep(1);
				trxmode = SSBMODE;
			}
		}
			else if  (keyerport == COM1_KEYER) {
					cfd = open("/dev/cwkeyer", O_RDONLY  );
					if (cfd == -1) {
							mvprintw(24,0, "Cannot open COM keyer module > switching to SSB !");
							refresh();
							sleep(1);
							trxmode = SSBMODE;
					}
			}
			else if (keyerport == NET_KEYER) {
						if (netkeyer_init() < 0)
						{
							mvprintw(24,0, "Cannot open NET keyer daemon ");
							refresh();
							sleep(1);

						}else {
							sprintf(weightbuf, "%d", weight);

							strncpy(keyerbuff, speedstr+(speed * 2), 2);
							keyerbuff[2] = '\0';

							netkeyer(K_SPEED, keyerbuff);	// set speed

							netkeyer(K_WEIGHT, weightbuf);	// set weight
							
							if (strlen(keyer_device) > 0)
								netkeyer(K_DEVICE, keyer_device); // set device
								
							if (strlen(portaddress) > 0)
								netkeyer(K_ADDRESS, portaddress); // set port address

							sprintf(keyerbuff, "%d", txdelay);

							netkeyer (K_TOD, keyerbuff);		// set TOD

						}

			write_tone();
			}

		checklogfile();         /* make sure logfile is there */

		getwwv();               /* get the latest wwv info from packet */

		scroll_log(); 			/* read the last 5  log lines and set the qso number */

		nr_qsos = readcalls();            /* read the logfile for score and dupe */

		clear_display();        /* tidy up the display */
		
		qrb();


		attron(COLOR_PAIR(7)  |  A_STANDOUT);

		for (j = 13 ;  j  <= 23 ; j++){         /* wipe lower window */
	 		mvprintw(j, 0, backgrnd_str);
		}

			/* Create the first thread */
	                ret = pthread_create(&thrd1, NULL, (void *)logit, NULL);
	                if(ret) {
		                perror("pthread_create: logit");
		                endwin();
		                exit(EXIT_FAILURE);
	                }
	
	                /* Create the second thread */
	                ret = pthread_create(&thrd2, NULL, (void *)background_process, NULL);
			if(ret) {
		                perror("pthread_create: backgound_process");
		                endwin();
		                exit(EXIT_FAILURE);
	                }

	                pthread_join(thrd2, NULL);
	                pthread_join(thrd1, NULL);
	                endwin();
                        exit(EXIT_SUCCESS);

	}else  {
 			printf("Terminal does not support color\n" );
			printf("Try TERM=rxvt or use a text console !!\n");
 			refresh();
			sleep(2);
        }
 	cleanup_telnet();

	if (trxmode == CWMODE && keyerport == NET_KEYER)
		 	netkeyer_close();
    	else
		     	close(cfd);         /* close keyer */

	endwin();



return(0);	
}
























