/* $Id: tstIEMAImplDataFpuLdSt-Amd.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data Amd - r150740 on AMD Ryzen Threadripper 3990X 64-Core Processor.
 */

/*
 * Copyright (C) 2022 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

FPU_ST_I16_TEST_T const g_aTests_fistt_r80_to_i16_amd[] =
{
    { 0x0305, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/0/0 */
    { 0x030d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/0/2 */
    { 0x0315, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/0/4 */
    { 0x031d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/0/6 */
    { 0x0325, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/0/8 */
    { 0x032d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/0/10 */
    { 0x0335, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/0/12 */
    { 0x033d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/0/14 */
    { 0x0705, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/1/0 */
    { 0x070d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/1/2 */
    { 0x0715, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/1/4 */
    { 0x071d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/1/6 */
    { 0x0725, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/1/8 */
    { 0x072d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/1/10 */
    { 0x0735, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/1/12 */
    { 0x073d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/1/14 */
    { 0x0b05, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/2/0 */
    { 0x0b0d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/2/2 */
    { 0x0b15, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/2/4 */
    { 0x0b1d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/2/6 */
    { 0x0b25, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/2/8 */
    { 0x0b2d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/2/10 */
    { 0x0b35, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/2/12 */
    { 0x0b3d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/2/14 */
    { 0x0f05, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/3/0 */
    { 0x0f0d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/3/2 */
    { 0x0f15, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/3/4 */
    { 0x0f1d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/3/6 */
    { 0x0f25, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/3/8 */
    { 0x0f2d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/3/10 */
    { 0x0f35, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/3/12 */
    { 0x0f3d, 0xcd6c, 0x4501, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #0/3/14 */
    { 0x0003, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/0/0 */
    { 0x000b, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/0/2 */
    { 0x0013, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/0/4 */
    { 0x001b, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/0/6 */
    { 0x0023, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/0/8 */
    { 0x002b, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/0/10 */
    { 0x0033, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/0/12 */
    { 0x003b, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/0/14 */
    { 0x0403, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/1/0 */
    { 0x040b, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/1/2 */
    { 0x0413, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/1/4 */
    { 0x041b, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/1/6 */
    { 0x0423, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/1/8 */
    { 0x042b, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/1/10 */
    { 0x0433, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/1/12 */
    { 0x043b, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/1/14 */
    { 0x0803, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/2/0 */
    { 0x080b, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/2/2 */
    { 0x0813, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/2/4 */
    { 0x081b, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/2/6 */
    { 0x0823, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/2/8 */
    { 0x082b, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/2/10 */
    { 0x0833, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/2/12 */
    { 0x083b, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/2/14 */
    { 0x0c03, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/3/0 */
    { 0x0c0b, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/3/2 */
    { 0x0c13, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/3/4 */
    { 0x0c1b, 0x1551, 0x85a0, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/3/6 */
    { 0x0c23, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/3/8 */
    { 0x0c2b, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/3/10 */
    { 0x0c33, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/3/12 */
    { 0x0c3b, 0x1551, 0x0520, RTFLOAT80U_INIT_C(1,0xf26ec704ef668043,16383), INT16_C(-1) }, /* #1/3/14 */
    { 0x0043, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/0/0 */
    { 0x004b, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/0/2 */
    { 0x0053, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/0/4 */
    { 0x005b, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/0/6 */
    { 0x0063, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/0/8 */
    { 0x006b, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/0/10 */
    { 0x0073, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/0/12 */
    { 0x007b, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/0/14 */
    { 0x0443, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/1/0 */
    { 0x044b, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/1/2 */
    { 0x0453, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/1/4 */
    { 0x045b, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/1/6 */
    { 0x0463, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/1/8 */
    { 0x046b, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/1/10 */
    { 0x0473, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/1/12 */
    { 0x047b, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/1/14 */
    { 0x0843, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/2/0 */
    { 0x084b, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/2/2 */
    { 0x0853, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/2/4 */
    { 0x085b, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/2/6 */
    { 0x0863, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/2/8 */
    { 0x086b, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/2/10 */
    { 0x0873, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/2/12 */
    { 0x087b, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/2/14 */
    { 0x0c43, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/3/0 */
    { 0x0c4b, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/3/2 */
    { 0x0c53, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/3/4 */
    { 0x0c5b, 0x3839, 0x80a0, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/3/6 */
    { 0x0c63, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/3/8 */
    { 0x0c6b, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/3/10 */
    { 0x0c73, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/3/12 */
    { 0x0c7b, 0x3839, 0x0020, RTFLOAT80U_INIT_C(1,0xc0524cbcaf2b3f71,16397), INT16_C(-24617) }, /* #2/3/14 */
    { 0x0301, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/0/0 */
    { 0x0309, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/0/2 */
    { 0x0311, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/0/4 */
    { 0x0319, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/0/6 */
    { 0x0321, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/0/8 */
    { 0x0329, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/0/10 */
    { 0x0331, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/0/12 */
    { 0x0339, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/0/14 */
    { 0x0701, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/1/0 */
    { 0x0709, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/1/2 */
    { 0x0711, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/1/4 */
    { 0x0719, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/1/6 */
    { 0x0721, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/1/8 */
    { 0x0729, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/1/10 */
    { 0x0731, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/1/12 */
    { 0x0739, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/1/14 */
    { 0x0b01, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/2/0 */
    { 0x0b09, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/2/2 */
    { 0x0b11, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/2/4 */
    { 0x0b19, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/2/6 */
    { 0x0b21, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/2/8 */
    { 0x0b29, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/2/10 */
    { 0x0b31, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/2/12 */
    { 0x0b39, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/2/14 */
    { 0x0f01, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/3/0 */
    { 0x0f09, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/3/2 */
    { 0x0f11, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/3/4 */
    { 0x0f19, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/3/6 */
    { 0x0f21, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/3/8 */
    { 0x0f29, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/3/10 */
    { 0x0f31, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/3/12 */
    { 0x0f39, 0x2605, 0x0401, RTFLOAT80U_INIT_C(1,0x321e10119ecd3433,26059), INT16_MIN }, /* #3/3/14 */
    { 0x0106, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/0/0 */
    { 0x010e, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/0/2 */
    { 0x0116, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/0/4 */
    { 0x011e, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/0/6 */
    { 0x0126, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/0/8 */
    { 0x012e, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/0/10 */
    { 0x0136, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/0/12 */
    { 0x013e, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/0/14 */
    { 0x0506, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/1/0 */
    { 0x050e, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/1/2 */
    { 0x0516, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/1/4 */
    { 0x051e, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/1/6 */
    { 0x0526, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/1/8 */
    { 0x052e, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/1/10 */
    { 0x0536, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/1/12 */
    { 0x053e, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/1/14 */
    { 0x0906, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/2/0 */
    { 0x090e, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/2/2 */
    { 0x0916, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/2/4 */
    { 0x091e, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/2/6 */
    { 0x0926, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/2/8 */
    { 0x092e, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/2/10 */
    { 0x0936, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/2/12 */
    { 0x093e, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/2/14 */
    { 0x0d06, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/3/0 */
    { 0x0d0e, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/3/2 */
    { 0x0d16, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/3/4 */
    { 0x0d1e, 0xf157, 0xc1a0, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/3/6 */
    { 0x0d26, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/3/8 */
    { 0x0d2e, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/3/10 */
    { 0x0d36, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/3/12 */
    { 0x0d3e, 0xf157, 0x4120, RTFLOAT80U_INIT_C(1,0x888a49de62b4bf87,4659), INT16_C(0) }, /* #4/3/14 */
    { 0x0142, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/0/0 */
    { 0x014a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/0/2 */
    { 0x0152, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/0/4 */
    { 0x015a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/0/6 */
    { 0x0162, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/0/8 */
    { 0x016a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/0/10 */
    { 0x0172, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/0/12 */
    { 0x017a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/0/14 */
    { 0x0542, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/1/0 */
    { 0x054a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/1/2 */
    { 0x0552, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/1/4 */
    { 0x055a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/1/6 */
    { 0x0562, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/1/8 */
    { 0x056a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/1/10 */
    { 0x0572, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/1/12 */
    { 0x057a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/1/14 */
    { 0x0942, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/2/0 */
    { 0x094a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/2/2 */
    { 0x0952, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/2/4 */
    { 0x095a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/2/6 */
    { 0x0962, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/2/8 */
    { 0x096a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/2/10 */
    { 0x0972, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/2/12 */
    { 0x097a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/2/14 */
    { 0x0d42, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/3/0 */
    { 0x0d4a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/3/2 */
    { 0x0d52, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/3/4 */
    { 0x0d5a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/3/6 */
    { 0x0d62, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/3/8 */
    { 0x0d6a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/3/10 */
    { 0x0d72, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/3/12 */
    { 0x0d7a, 0x4440, 0xfc81, RTFLOAT80U_INIT_C(0,0x340376ac1111fd28,20917), INT16_C(-3) }, /* #5/3/14 */
    { 0x0242, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/0/0 */
    { 0x024a, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/0/2 */
    { 0x0252, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/0/4 */
    { 0x025a, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/0/6 */
    { 0x0262, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/0/8 */
    { 0x026a, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/0/10 */
    { 0x0272, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/0/12 */
    { 0x027a, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/0/14 */
    { 0x0642, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/1/0 */
    { 0x064a, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/1/2 */
    { 0x0652, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/1/4 */
    { 0x065a, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/1/6 */
    { 0x0662, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/1/8 */
    { 0x066a, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/1/10 */
    { 0x0672, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/1/12 */
    { 0x067a, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/1/14 */
    { 0x0a42, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/2/0 */
    { 0x0a4a, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/2/2 */
    { 0x0a52, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/2/4 */
    { 0x0a5a, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/2/6 */
    { 0x0a62, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/2/8 */
    { 0x0a6a, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/2/10 */
    { 0x0a72, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/2/12 */
    { 0x0a7a, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/2/14 */
    { 0x0e42, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/3/0 */
    { 0x0e4a, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/3/2 */
    { 0x0e52, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/3/4 */
    { 0x0e5a, 0x31ea, 0x81a0, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/3/6 */
    { 0x0e62, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/3/8 */
    { 0x0e6a, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/3/10 */
    { 0x0e72, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/3/12 */
    { 0x0e7a, 0x31ea, 0x0120, RTFLOAT80U_INIT_C(1,0x473226ca88521e0a,0), INT16_C(0) }, /* #6/3/14 */
    { 0x0001, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/0/0 */
    { 0x0009, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/0/2 */
    { 0x0011, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/0/4 */
    { 0x0019, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/0/6 */
    { 0x0021, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/0/8 */
    { 0x0029, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/0/10 */
    { 0x0031, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/0/12 */
    { 0x0039, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/0/14 */
    { 0x0401, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/1/0 */
    { 0x0409, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/1/2 */
    { 0x0411, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/1/4 */
    { 0x0419, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/1/6 */
    { 0x0421, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/1/8 */
    { 0x0429, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/1/10 */
    { 0x0431, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/1/12 */
    { 0x0439, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/1/14 */
    { 0x0801, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/2/0 */
    { 0x0809, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/2/2 */
    { 0x0811, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/2/4 */
    { 0x0819, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/2/6 */
    { 0x0821, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/2/8 */
    { 0x0829, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/2/10 */
    { 0x0831, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/2/12 */
    { 0x0839, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/2/14 */
    { 0x0c01, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/3/0 */
    { 0x0c09, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/3/2 */
    { 0x0c11, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/3/4 */
    { 0x0c19, 0x4266, 0xc0a0, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/3/6 */
    { 0x0c21, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/3/8 */
    { 0x0c29, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/3/10 */
    { 0x0c31, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/3/12 */
    { 0x0c39, 0x4266, 0x4020, RTFLOAT80U_INIT_C(0,0x64891a56bbca6474,0), INT16_C(0) }, /* #7/3/14 */
    { 0x0245, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/0/0 */
    { 0x024d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/0/2 */
    { 0x0255, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/0/4 */
    { 0x025d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/0/6 */
    { 0x0265, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/0/8 */
    { 0x026d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/0/10 */
    { 0x0275, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/0/12 */
    { 0x027d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/0/14 */
    { 0x0645, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/1/0 */
    { 0x064d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/1/2 */
    { 0x0655, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/1/4 */
    { 0x065d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/1/6 */
    { 0x0665, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/1/8 */
    { 0x066d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/1/10 */
    { 0x0675, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/1/12 */
    { 0x067d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/1/14 */
    { 0x0a45, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/2/0 */
    { 0x0a4d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/2/2 */
    { 0x0a55, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/2/4 */
    { 0x0a5d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/2/6 */
    { 0x0a65, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/2/8 */
    { 0x0a6d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/2/10 */
    { 0x0a75, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/2/12 */
    { 0x0a7d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/2/14 */
    { 0x0e45, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/3/0 */
    { 0x0e4d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/3/2 */
    { 0x0e55, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/3/4 */
    { 0x0e5d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/3/6 */
    { 0x0e65, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/3/8 */
    { 0x0e6d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/3/10 */
    { 0x0e75, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/3/12 */
    { 0x0e7d, 0xad78, 0x0501, RTFLOAT80U_INIT_C(1,0x27912f36e778bc48,32767), INT16_MIN }, /* #8/3/14 */
    { 0x0103, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/0/0 */
    { 0x010b, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/0/2 */
    { 0x0113, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/0/4 */
    { 0x011b, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/0/6 */
    { 0x0123, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/0/8 */
    { 0x012b, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/0/10 */
    { 0x0133, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/0/12 */
    { 0x013b, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/0/14 */
    { 0x0503, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/1/0 */
    { 0x050b, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/1/2 */
    { 0x0513, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/1/4 */
    { 0x051b, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/1/6 */
    { 0x0523, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/1/8 */
    { 0x052b, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/1/10 */
    { 0x0533, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/1/12 */
    { 0x053b, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/1/14 */
    { 0x0903, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/2/0 */
    { 0x090b, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/2/2 */
    { 0x0913, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/2/4 */
    { 0x091b, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/2/6 */
    { 0x0923, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/2/8 */
    { 0x092b, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/2/10 */
    { 0x0933, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/2/12 */
    { 0x093b, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/2/14 */
    { 0x0d03, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/3/0 */
    { 0x0d0b, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/3/2 */
    { 0x0d13, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/3/4 */
    { 0x0d1b, 0x8d65, 0x85a0, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/3/6 */
    { 0x0d23, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/3/8 */
    { 0x0d2b, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/3/10 */
    { 0x0d33, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/3/12 */
    { 0x0d3b, 0x8d65, 0x0520, RTFLOAT80U_INIT_C(1,0xdf9d1706b8fcee8f,16383), INT16_C(-1) }, /* #9/3/14 */
    { 0x0202, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/0/0 */
    { 0x020a, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/0/2 */
    { 0x0212, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/0/4 */
    { 0x021a, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/0/6 */
    { 0x0222, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/0/8 */
    { 0x022a, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/0/10 */
    { 0x0232, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/0/12 */
    { 0x023a, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/0/14 */
    { 0x0602, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/1/0 */
    { 0x060a, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/1/2 */
    { 0x0612, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/1/4 */
    { 0x061a, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/1/6 */
    { 0x0622, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/1/8 */
    { 0x062a, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/1/10 */
    { 0x0632, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/1/12 */
    { 0x063a, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/1/14 */
    { 0x0a02, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/2/0 */
    { 0x0a0a, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/2/2 */
    { 0x0a12, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/2/4 */
    { 0x0a1a, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/2/6 */
    { 0x0a22, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/2/8 */
    { 0x0a2a, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/2/10 */
    { 0x0a32, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/2/12 */
    { 0x0a3a, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/2/14 */
    { 0x0e02, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/3/0 */
    { 0x0e0a, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/3/2 */
    { 0x0e12, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/3/4 */
    { 0x0e1a, 0xf48e, 0xc4a0, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/3/6 */
    { 0x0e22, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/3/8 */
    { 0x0e2a, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/3/10 */
    { 0x0e32, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/3/12 */
    { 0x0e3a, 0xf48e, 0x4420, RTFLOAT80U_INIT_C(0,0xb165271faa38b6bc,16397), INT16_C(22706) }, /* #10/3/14 */
    { 0x0340, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/0/0 */
    { 0x0348, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/0/2 */
    { 0x0350, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/0/4 */
    { 0x0358, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/0/6 */
    { 0x0360, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/0/8 */
    { 0x0368, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/0/10 */
    { 0x0370, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/0/12 */
    { 0x0378, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/0/14 */
    { 0x0740, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/1/0 */
    { 0x0748, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/1/2 */
    { 0x0750, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/1/4 */
    { 0x0758, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/1/6 */
    { 0x0760, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/1/8 */
    { 0x0768, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/1/10 */
    { 0x0770, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/1/12 */
    { 0x0778, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/1/14 */
    { 0x0b40, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/2/0 */
    { 0x0b48, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/2/2 */
    { 0x0b50, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/2/4 */
    { 0x0b58, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/2/6 */
    { 0x0b60, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/2/8 */
    { 0x0b68, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/2/10 */
    { 0x0b70, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/2/12 */
    { 0x0b78, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/2/14 */
    { 0x0f40, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/3/0 */
    { 0x0f48, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/3/2 */
    { 0x0f50, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/3/4 */
    { 0x0f58, 0x928b, 0x80a0, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/3/6 */
    { 0x0f60, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/3/8 */
    { 0x0f68, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/3/10 */
    { 0x0f70, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/3/12 */
    { 0x0f78, 0x928b, 0x0020, RTFLOAT80U_INIT_C(0,0x93e1bbf23794f310,5904), INT16_C(0) }, /* #11/3/14 */
    { 0x0003, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/0/0 */
    { 0x000b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/0/2 */
    { 0x0013, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/0/4 */
    { 0x001b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/0/6 */
    { 0x0023, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/0/8 */
    { 0x002b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/0/10 */
    { 0x0033, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/0/12 */
    { 0x003b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/0/14 */
    { 0x0403, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/1/0 */
    { 0x040b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/1/2 */
    { 0x0413, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/1/4 */
    { 0x041b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/1/6 */
    { 0x0423, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/1/8 */
    { 0x042b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/1/10 */
    { 0x0433, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/1/12 */
    { 0x043b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/1/14 */
    { 0x0803, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/2/0 */
    { 0x080b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/2/2 */
    { 0x0813, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/2/4 */
    { 0x081b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/2/6 */
    { 0x0823, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/2/8 */
    { 0x082b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/2/10 */
    { 0x0833, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/2/12 */
    { 0x083b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/2/14 */
    { 0x0c03, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/3/0 */
    { 0x0c0b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/3/2 */
    { 0x0c13, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/3/4 */
    { 0x0c1b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/3/6 */
    { 0x0c23, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/3/8 */
    { 0x0c2b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/3/10 */
    { 0x0c33, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/3/12 */
    { 0x0c3b, 0x95f5, 0x0501, RTFLOAT80U_INIT_C(0,0xa66d5abd41e513a7,32767), INT16_MIN }, /* #12/3/14 */
    { 0x0246, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/0/0 */
    { 0x024e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/0/2 */
    { 0x0256, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/0/4 */
    { 0x025e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/0/6 */
    { 0x0266, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/0/8 */
    { 0x026e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/0/10 */
    { 0x0276, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/0/12 */
    { 0x027e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/0/14 */
    { 0x0646, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/1/0 */
    { 0x064e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/1/2 */
    { 0x0656, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/1/4 */
    { 0x065e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/1/6 */
    { 0x0666, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/1/8 */
    { 0x066e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/1/10 */
    { 0x0676, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/1/12 */
    { 0x067e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/1/14 */
    { 0x0a46, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/2/0 */
    { 0x0a4e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/2/2 */
    { 0x0a56, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/2/4 */
    { 0x0a5e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/2/6 */
    { 0x0a66, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/2/8 */
    { 0x0a6e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/2/10 */
    { 0x0a76, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/2/12 */
    { 0x0a7e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/2/14 */
    { 0x0e46, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/3/0 */
    { 0x0e4e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/3/2 */
    { 0x0e56, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/3/4 */
    { 0x0e5e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/3/6 */
    { 0x0e66, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/3/8 */
    { 0x0e6e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/3/10 */
    { 0x0e76, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/3/12 */
    { 0x0e7e, 0xa668, 0xbc81, RTFLOAT80U_INIT_C(0,0x0,32767), INT16_C(-3) }, /* #13/3/14 */
    { 0x0100, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/0/0 */
    { 0x0108, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/0/2 */
    { 0x0110, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/0/4 */
    { 0x0118, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/0/6 */
    { 0x0120, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/0/8 */
    { 0x0128, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/0/10 */
    { 0x0130, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/0/12 */
    { 0x0138, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/0/14 */
    { 0x0500, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/1/0 */
    { 0x0508, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/1/2 */
    { 0x0510, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/1/4 */
    { 0x0518, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/1/6 */
    { 0x0520, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/1/8 */
    { 0x0528, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/1/10 */
    { 0x0530, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/1/12 */
    { 0x0538, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/1/14 */
    { 0x0900, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/2/0 */
    { 0x0908, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/2/2 */
    { 0x0910, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/2/4 */
    { 0x0918, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/2/6 */
    { 0x0920, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/2/8 */
    { 0x0928, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/2/10 */
    { 0x0930, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/2/12 */
    { 0x0938, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/2/14 */
    { 0x0d00, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/3/0 */
    { 0x0d08, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/3/2 */
    { 0x0d10, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/3/4 */
    { 0x0d18, 0x269b, 0x84a0, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/3/6 */
    { 0x0d20, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/3/8 */
    { 0x0d28, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/3/10 */
    { 0x0d30, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/3/12 */
    { 0x0d38, 0x269b, 0x0420, RTFLOAT80U_INIT_C(0,0xa5151b9786c8bd8f,16397), INT16_C(21130) }, /* #14/3/14 */
    { 0x0141, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/0/0 */
    { 0x0149, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/0/2 */
    { 0x0151, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/0/4 */
    { 0x0159, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/0/6 */
    { 0x0161, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/0/8 */
    { 0x0169, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/0/10 */
    { 0x0171, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/0/12 */
    { 0x0179, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/0/14 */
    { 0x0541, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/1/0 */
    { 0x0549, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/1/2 */
    { 0x0551, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/1/4 */
    { 0x0559, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/1/6 */
    { 0x0561, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/1/8 */
    { 0x0569, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/1/10 */
    { 0x0571, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/1/12 */
    { 0x0579, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/1/14 */
    { 0x0941, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/2/0 */
    { 0x0949, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/2/2 */
    { 0x0951, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/2/4 */
    { 0x0959, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/2/6 */
    { 0x0961, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/2/8 */
    { 0x0969, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/2/10 */
    { 0x0971, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/2/12 */
    { 0x0979, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/2/14 */
    { 0x0d41, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/3/0 */
    { 0x0d49, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/3/2 */
    { 0x0d51, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/3/4 */
    { 0x0d59, 0x9ea5, 0x84a0, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/3/6 */
    { 0x0d61, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/3/8 */
    { 0x0d69, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/3/10 */
    { 0x0d71, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/3/12 */
    { 0x0d79, 0x9ea5, 0x0420, RTFLOAT80U_INIT_C(1,0x23a4be60e3199194,0), INT16_C(0) }, /* #15/3/14 */
    { 0x0342, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/0/0 */
    { 0x034a, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/0/2 */
    { 0x0352, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/0/4 */
    { 0x035a, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/0/6 */
    { 0x0362, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/0/8 */
    { 0x036a, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/0/10 */
    { 0x0372, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/0/12 */
    { 0x037a, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/0/14 */
    { 0x0742, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/1/0 */
    { 0x074a, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/1/2 */
    { 0x0752, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/1/4 */
    { 0x075a, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/1/6 */
    { 0x0762, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/1/8 */
    { 0x076a, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/1/10 */
    { 0x0772, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/1/12 */
    { 0x077a, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/1/14 */
    { 0x0b42, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/2/0 */
    { 0x0b4a, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/2/2 */
    { 0x0b52, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/2/4 */
    { 0x0b5a, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/2/6 */
    { 0x0b62, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/2/8 */
    { 0x0b6a, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/2/10 */
    { 0x0b72, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/2/12 */
    { 0x0b7a, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/2/14 */
    { 0x0f42, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/3/0 */
    { 0x0f4a, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/3/2 */
    { 0x0f52, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/3/4 */
    { 0x0f5a, 0xcc5b, 0xc4a0, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/3/6 */
    { 0x0f62, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/3/8 */
    { 0x0f6a, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/3/10 */
    { 0x0f72, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/3/12 */
    { 0x0f7a, 0xcc5b, 0x4420, RTFLOAT80U_INIT_C(1,0xe0e06d4a211caa0d,16383), INT16_C(-1) }, /* #16/3/14 */
    { 0x0004, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/0/0 */
    { 0x000c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/0/2 */
    { 0x0014, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/0/4 */
    { 0x001c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/0/6 */
    { 0x0024, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/0/8 */
    { 0x002c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/0/10 */
    { 0x0034, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/0/12 */
    { 0x003c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/0/14 */
    { 0x0404, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/1/0 */
    { 0x040c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/1/2 */
    { 0x0414, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/1/4 */
    { 0x041c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/1/6 */
    { 0x0424, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/1/8 */
    { 0x042c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/1/10 */
    { 0x0434, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/1/12 */
    { 0x043c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/1/14 */
    { 0x0804, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/2/0 */
    { 0x080c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/2/2 */
    { 0x0814, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/2/4 */
    { 0x081c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/2/6 */
    { 0x0824, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/2/8 */
    { 0x082c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/2/10 */
    { 0x0834, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/2/12 */
    { 0x083c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/2/14 */
    { 0x0c04, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/3/0 */
    { 0x0c0c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/3/2 */
    { 0x0c14, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/3/4 */
    { 0x0c1c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/3/6 */
    { 0x0c24, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/3/8 */
    { 0x0c2c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/3/10 */
    { 0x0c34, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/3/12 */
    { 0x0c3c, 0x64af, 0xfc81, RTFLOAT80U_INIT_C(1,0x19f935047b55406e,9966), INT16_C(-3) }, /* #17/3/14 */
    { 0x0103, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/0/0 */
    { 0x010b, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/0/2 */
    { 0x0113, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/0/4 */
    { 0x011b, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/0/6 */
    { 0x0123, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/0/8 */
    { 0x012b, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/0/10 */
    { 0x0133, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/0/12 */
    { 0x013b, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/0/14 */
    { 0x0503, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/1/0 */
    { 0x050b, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/1/2 */
    { 0x0513, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/1/4 */
    { 0x051b, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/1/6 */
    { 0x0523, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/1/8 */
    { 0x052b, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/1/10 */
    { 0x0533, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/1/12 */
    { 0x053b, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/1/14 */
    { 0x0903, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/2/0 */
    { 0x090b, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/2/2 */
    { 0x0913, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/2/4 */
    { 0x091b, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/2/6 */
    { 0x0923, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/2/8 */
    { 0x092b, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/2/10 */
    { 0x0933, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/2/12 */
    { 0x093b, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/2/14 */
    { 0x0d03, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/3/0 */
    { 0x0d0b, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/3/2 */
    { 0x0d13, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/3/4 */
    { 0x0d1b, 0x8b8a, 0x81a0, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/3/6 */
    { 0x0d23, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/3/8 */
    { 0x0d2b, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/3/10 */
    { 0x0d33, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/3/12 */
    { 0x0d3b, 0x8b8a, 0x0120, RTFLOAT80U_INIT_C(1,0xb59ebacc590d42d5,16397), INT16_C(-23247) }, /* #18/3/14 */
    { 0x0044, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/0/0 */
    { 0x004c, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/0/2 */
    { 0x0054, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/0/4 */
    { 0x005c, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/0/6 */
    { 0x0064, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/0/8 */
    { 0x006c, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/0/10 */
    { 0x0074, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/0/12 */
    { 0x007c, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/0/14 */
    { 0x0444, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/1/0 */
    { 0x044c, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/1/2 */
    { 0x0454, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/1/4 */
    { 0x045c, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/1/6 */
    { 0x0464, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/1/8 */
    { 0x046c, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/1/10 */
    { 0x0474, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/1/12 */
    { 0x047c, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/1/14 */
    { 0x0844, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/2/0 */
    { 0x084c, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/2/2 */
    { 0x0854, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/2/4 */
    { 0x085c, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/2/6 */
    { 0x0864, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/2/8 */
    { 0x086c, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/2/10 */
    { 0x0874, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/2/12 */
    { 0x087c, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/2/14 */
    { 0x0c44, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/3/0 */
    { 0x0c4c, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/3/2 */
    { 0x0c54, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/3/4 */
    { 0x0c5c, 0xf9a9, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/3/6 */
    { 0x0c64, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/3/8 */
    { 0x0c6c, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/3/10 */
    { 0x0c74, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/3/12 */
    { 0x0c7c, 0xf9a9, 0x4120, RTFLOAT80U_INIT_C(1,0x8b993f53ffbfd677,16383), INT16_C(-1) }, /* #19/3/14 */
    { 0x0000, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/0/0 */
    { 0x0008, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/0/2 */
    { 0x0010, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/0/4 */
    { 0x0018, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/0/6 */
    { 0x0020, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/0/8 */
    { 0x0028, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/0/10 */
    { 0x0030, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/0/12 */
    { 0x0038, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/0/14 */
    { 0x0400, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/1/0 */
    { 0x0408, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/1/2 */
    { 0x0410, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/1/4 */
    { 0x0418, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/1/6 */
    { 0x0420, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/1/8 */
    { 0x0428, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/1/10 */
    { 0x0430, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/1/12 */
    { 0x0438, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/1/14 */
    { 0x0800, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/2/0 */
    { 0x0808, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/2/2 */
    { 0x0810, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/2/4 */
    { 0x0818, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/2/6 */
    { 0x0820, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/2/8 */
    { 0x0828, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/2/10 */
    { 0x0830, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/2/12 */
    { 0x0838, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/2/14 */
    { 0x0c00, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/3/0 */
    { 0x0c08, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/3/2 */
    { 0x0c10, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/3/4 */
    { 0x0c18, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/3/6 */
    { 0x0c20, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/3/8 */
    { 0x0c28, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/3/10 */
    { 0x0c30, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/3/12 */
    { 0x0c38, 0xa632, 0xbc81, RTFLOAT80U_INIT_C(1,0xb025b918434043d6,28505), INT16_C(-3) }, /* #20/3/14 */
    { 0x0305, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/0/0 */
    { 0x030d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/0/2 */
    { 0x0315, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/0/4 */
    { 0x031d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/0/6 */
    { 0x0325, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/0/8 */
    { 0x032d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/0/10 */
    { 0x0335, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/0/12 */
    { 0x033d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/0/14 */
    { 0x0705, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/1/0 */
    { 0x070d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/1/2 */
    { 0x0715, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/1/4 */
    { 0x071d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/1/6 */
    { 0x0725, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/1/8 */
    { 0x072d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/1/10 */
    { 0x0735, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/1/12 */
    { 0x073d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/1/14 */
    { 0x0b05, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/2/0 */
    { 0x0b0d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/2/2 */
    { 0x0b15, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/2/4 */
    { 0x0b1d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/2/6 */
    { 0x0b25, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/2/8 */
    { 0x0b2d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/2/10 */
    { 0x0b35, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/2/12 */
    { 0x0b3d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/2/14 */
    { 0x0f05, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/3/0 */
    { 0x0f0d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/3/2 */
    { 0x0f15, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/3/4 */
    { 0x0f1d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/3/6 */
    { 0x0f25, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/3/8 */
    { 0x0f2d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/3/10 */
    { 0x0f35, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/3/12 */
    { 0x0f3d, 0xafba, 0x0501, RTFLOAT80U_INIT_C(0,0x800000000000007c,32767), INT16_MIN }, /* #21/3/14 */
    { 0x0300, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/0/0 */
    { 0x0308, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/0/2 */
    { 0x0310, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/0/4 */
    { 0x0318, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/0/6 */
    { 0x0320, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/0/8 */
    { 0x0328, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/0/10 */
    { 0x0330, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/0/12 */
    { 0x0338, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/0/14 */
    { 0x0700, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/1/0 */
    { 0x0708, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/1/2 */
    { 0x0710, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/1/4 */
    { 0x0718, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/1/6 */
    { 0x0720, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/1/8 */
    { 0x0728, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/1/10 */
    { 0x0730, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/1/12 */
    { 0x0738, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/1/14 */
    { 0x0b00, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/2/0 */
    { 0x0b08, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/2/2 */
    { 0x0b10, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/2/4 */
    { 0x0b18, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/2/6 */
    { 0x0b20, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/2/8 */
    { 0x0b28, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/2/10 */
    { 0x0b30, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/2/12 */
    { 0x0b38, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/2/14 */
    { 0x0f00, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/3/0 */
    { 0x0f08, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/3/2 */
    { 0x0f10, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/3/4 */
    { 0x0f18, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/3/6 */
    { 0x0f20, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/3/8 */
    { 0x0f28, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/3/10 */
    { 0x0f30, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/3/12 */
    { 0x0f38, 0xd03f, 0xf881, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_C(-3) }, /* #22/3/14 */
    { 0x0343, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/0/0 */
    { 0x034b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/0/2 */
    { 0x0353, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/0/4 */
    { 0x035b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/0/6 */
    { 0x0363, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/0/8 */
    { 0x036b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/0/10 */
    { 0x0373, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/0/12 */
    { 0x037b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/0/14 */
    { 0x0743, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/1/0 */
    { 0x074b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/1/2 */
    { 0x0753, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/1/4 */
    { 0x075b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/1/6 */
    { 0x0763, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/1/8 */
    { 0x076b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/1/10 */
    { 0x0773, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/1/12 */
    { 0x077b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/1/14 */
    { 0x0b43, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/2/0 */
    { 0x0b4b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/2/2 */
    { 0x0b53, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/2/4 */
    { 0x0b5b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/2/6 */
    { 0x0b63, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/2/8 */
    { 0x0b6b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/2/10 */
    { 0x0b73, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/2/12 */
    { 0x0b7b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/2/14 */
    { 0x0f43, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/3/0 */
    { 0x0f4b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/3/2 */
    { 0x0f53, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/3/4 */
    { 0x0f5b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/3/6 */
    { 0x0f63, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/3/8 */
    { 0x0f6b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/3/10 */
    { 0x0f73, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/3/12 */
    { 0x0f7b, 0x6dc0, 0x4501, RTFLOAT80U_INIT_C(0,0x7a7f4555cfaa5feb,3655), INT16_MIN }, /* #23/3/14 */
    { 0x0045, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/0/0 */
    { 0x004d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/0/2 */
    { 0x0055, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/0/4 */
    { 0x005d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/0/6 */
    { 0x0065, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/0/8 */
    { 0x006d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/0/10 */
    { 0x0075, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/0/12 */
    { 0x007d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/0/14 */
    { 0x0445, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/1/0 */
    { 0x044d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/1/2 */
    { 0x0455, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/1/4 */
    { 0x045d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/1/6 */
    { 0x0465, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/1/8 */
    { 0x046d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/1/10 */
    { 0x0475, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/1/12 */
    { 0x047d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/1/14 */
    { 0x0845, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/2/0 */
    { 0x084d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/2/2 */
    { 0x0855, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/2/4 */
    { 0x085d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/2/6 */
    { 0x0865, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/2/8 */
    { 0x086d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/2/10 */
    { 0x0875, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/2/12 */
    { 0x087d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/2/14 */
    { 0x0c45, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/3/0 */
    { 0x0c4d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/3/2 */
    { 0x0c55, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/3/4 */
    { 0x0c5d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/3/6 */
    { 0x0c65, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/3/8 */
    { 0x0c6d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/3/10 */
    { 0x0c75, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/3/12 */
    { 0x0c7d, 0x4af9, 0x4001, RTFLOAT80U_INIT_C(0,0x292,31533), INT16_MIN }, /* #24/3/14 */
    { 0x0243, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/0/0 */
    { 0x024b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/0/2 */
    { 0x0253, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/0/4 */
    { 0x025b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/0/6 */
    { 0x0263, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/0/8 */
    { 0x026b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/0/10 */
    { 0x0273, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/0/12 */
    { 0x027b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/0/14 */
    { 0x0643, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/1/0 */
    { 0x064b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/1/2 */
    { 0x0653, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/1/4 */
    { 0x065b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/1/6 */
    { 0x0663, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/1/8 */
    { 0x066b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/1/10 */
    { 0x0673, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/1/12 */
    { 0x067b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/1/14 */
    { 0x0a43, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/2/0 */
    { 0x0a4b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/2/2 */
    { 0x0a53, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/2/4 */
    { 0x0a5b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/2/6 */
    { 0x0a63, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/2/8 */
    { 0x0a6b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/2/10 */
    { 0x0a73, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/2/12 */
    { 0x0a7b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/2/14 */
    { 0x0e43, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/3/0 */
    { 0x0e4b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/3/2 */
    { 0x0e53, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/3/4 */
    { 0x0e5b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/3/6 */
    { 0x0e63, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/3/8 */
    { 0x0e6b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/3/10 */
    { 0x0e73, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/3/12 */
    { 0x0e7b, 0x7601, 0x4401, RTFLOAT80U_INIT_C(0,0xdcc3140578255c1f,25347), INT16_MIN }, /* #25/3/14 */
    { 0x0046, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/0/0 */
    { 0x004e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/0/2 */
    { 0x0056, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/0/4 */
    { 0x005e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/0/6 */
    { 0x0066, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/0/8 */
    { 0x006e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/0/10 */
    { 0x0076, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/0/12 */
    { 0x007e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/0/14 */
    { 0x0446, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/1/0 */
    { 0x044e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/1/2 */
    { 0x0456, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/1/4 */
    { 0x045e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/1/6 */
    { 0x0466, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/1/8 */
    { 0x046e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/1/10 */
    { 0x0476, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/1/12 */
    { 0x047e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/1/14 */
    { 0x0846, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/2/0 */
    { 0x084e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/2/2 */
    { 0x0856, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/2/4 */
    { 0x085e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/2/6 */
    { 0x0866, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/2/8 */
    { 0x086e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/2/10 */
    { 0x0876, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/2/12 */
    { 0x087e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/2/14 */
    { 0x0c46, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/3/0 */
    { 0x0c4e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/3/2 */
    { 0x0c56, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/3/4 */
    { 0x0c5e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/3/6 */
    { 0x0c66, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/3/8 */
    { 0x0c6e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/3/10 */
    { 0x0c76, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/3/12 */
    { 0x0c7e, 0x987a, 0xb881, RTFLOAT80U_INIT_C(0,0xa1de1c9746a78c16,32767), INT16_C(-3) }, /* #26/3/14 */
    { 0x0201, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/0/0 */
    { 0x0209, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/0/2 */
    { 0x0211, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/0/4 */
    { 0x0219, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/0/6 */
    { 0x0221, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/0/8 */
    { 0x0229, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/0/10 */
    { 0x0231, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/0/12 */
    { 0x0239, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/0/14 */
    { 0x0601, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/1/0 */
    { 0x0609, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/1/2 */
    { 0x0611, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/1/4 */
    { 0x0619, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/1/6 */
    { 0x0621, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/1/8 */
    { 0x0629, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/1/10 */
    { 0x0631, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/1/12 */
    { 0x0639, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/1/14 */
    { 0x0a01, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/2/0 */
    { 0x0a09, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/2/2 */
    { 0x0a11, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/2/4 */
    { 0x0a19, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/2/6 */
    { 0x0a21, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/2/8 */
    { 0x0a29, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/2/10 */
    { 0x0a31, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/2/12 */
    { 0x0a39, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/2/14 */
    { 0x0e01, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/3/0 */
    { 0x0e09, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/3/2 */
    { 0x0e11, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/3/4 */
    { 0x0e19, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/3/6 */
    { 0x0e21, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/3/8 */
    { 0x0e29, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/3/10 */
    { 0x0e31, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/3/12 */
    { 0x0e39, 0x5106, 0x4101, RTFLOAT80U_INIT_C(1,0xc00000002869a942,32767), INT16_MIN }, /* #27/3/14 */
    { 0x0346, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/0/0 */
    { 0x034e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/0/2 */
    { 0x0356, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/0/4 */
    { 0x035e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/0/6 */
    { 0x0366, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/0/8 */
    { 0x036e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/0/10 */
    { 0x0376, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/0/12 */
    { 0x037e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/0/14 */
    { 0x0746, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/1/0 */
    { 0x074e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/1/2 */
    { 0x0756, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/1/4 */
    { 0x075e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/1/6 */
    { 0x0766, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/1/8 */
    { 0x076e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/1/10 */
    { 0x0776, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/1/12 */
    { 0x077e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/1/14 */
    { 0x0b46, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/2/0 */
    { 0x0b4e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/2/2 */
    { 0x0b56, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/2/4 */
    { 0x0b5e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/2/6 */
    { 0x0b66, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/2/8 */
    { 0x0b6e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/2/10 */
    { 0x0b76, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/2/12 */
    { 0x0b7e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/2/14 */
    { 0x0f46, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/3/0 */
    { 0x0f4e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/3/2 */
    { 0x0f56, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/3/4 */
    { 0x0f5e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/3/6 */
    { 0x0f66, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/3/8 */
    { 0x0f6e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/3/10 */
    { 0x0f76, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/3/12 */
    { 0x0f7e, 0xd9b7, 0xf981, RTFLOAT80U_INIT_C(1,0x262e480365d1a326,32767), INT16_C(-3) }, /* #28/3/14 */
    { 0x0247, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/0/0 */
    { 0x024f, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/0/2 */
    { 0x0257, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/0/4 */
    { 0x025f, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/0/6 */
    { 0x0267, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/0/8 */
    { 0x026f, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/0/10 */
    { 0x0277, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/0/12 */
    { 0x027f, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/0/14 */
    { 0x0647, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/1/0 */
    { 0x064f, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/1/2 */
    { 0x0657, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/1/4 */
    { 0x065f, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/1/6 */
    { 0x0667, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/1/8 */
    { 0x066f, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/1/10 */
    { 0x0677, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/1/12 */
    { 0x067f, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/1/14 */
    { 0x0a47, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/2/0 */
    { 0x0a4f, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/2/2 */
    { 0x0a57, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/2/4 */
    { 0x0a5f, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/2/6 */
    { 0x0a67, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/2/8 */
    { 0x0a6f, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/2/10 */
    { 0x0a77, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/2/12 */
    { 0x0a7f, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/2/14 */
    { 0x0e47, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/3/0 */
    { 0x0e4f, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/3/2 */
    { 0x0e57, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/3/4 */
    { 0x0e5f, 0xee32, 0xc4a0, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/3/6 */
    { 0x0e67, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/3/8 */
    { 0x0e6f, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/3/10 */
    { 0x0e77, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/3/12 */
    { 0x0e7f, 0xee32, 0x4420, RTFLOAT80U_INIT_C(0,0x9e8fb8661e5213c,0), INT16_C(0) }, /* #29/3/14 */
    { 0x0000, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/0/0 */
    { 0x0008, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/0/2 */
    { 0x0010, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/0/4 */
    { 0x0018, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/0/6 */
    { 0x0020, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/0/8 */
    { 0x0028, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/0/10 */
    { 0x0030, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/0/12 */
    { 0x0038, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/0/14 */
    { 0x0400, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/1/0 */
    { 0x0408, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/1/2 */
    { 0x0410, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/1/4 */
    { 0x0418, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/1/6 */
    { 0x0420, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/1/8 */
    { 0x0428, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/1/10 */
    { 0x0430, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/1/12 */
    { 0x0438, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/1/14 */
    { 0x0800, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/2/0 */
    { 0x0808, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/2/2 */
    { 0x0810, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/2/4 */
    { 0x0818, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/2/6 */
    { 0x0820, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/2/8 */
    { 0x0828, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/2/10 */
    { 0x0830, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/2/12 */
    { 0x0838, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/2/14 */
    { 0x0c00, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/3/0 */
    { 0x0c08, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/3/2 */
    { 0x0c10, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/3/4 */
    { 0x0c18, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/3/6 */
    { 0x0c20, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/3/8 */
    { 0x0c28, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/3/10 */
    { 0x0c30, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/3/12 */
    { 0x0c38, 0xa86e, 0xb881, RTFLOAT80U_INIT_C(1,0x20c3c,32767), INT16_C(-3) }, /* #30/3/14 */
    { 0x0200, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/0/0 */
    { 0x0208, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/0/2 */
    { 0x0210, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/0/4 */
    { 0x0218, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/0/6 */
    { 0x0220, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/0/8 */
    { 0x0228, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/0/10 */
    { 0x0230, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/0/12 */
    { 0x0238, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/0/14 */
    { 0x0600, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/1/0 */
    { 0x0608, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/1/2 */
    { 0x0610, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/1/4 */
    { 0x0618, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/1/6 */
    { 0x0620, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/1/8 */
    { 0x0628, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/1/10 */
    { 0x0630, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/1/12 */
    { 0x0638, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/1/14 */
    { 0x0a00, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/2/0 */
    { 0x0a08, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/2/2 */
    { 0x0a10, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/2/4 */
    { 0x0a18, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/2/6 */
    { 0x0a20, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/2/8 */
    { 0x0a28, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/2/10 */
    { 0x0a30, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/2/12 */
    { 0x0a38, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/2/14 */
    { 0x0e00, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/3/0 */
    { 0x0e08, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/3/2 */
    { 0x0e10, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/3/4 */
    { 0x0e18, 0x0e23, 0x84a0, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/3/6 */
    { 0x0e20, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/3/8 */
    { 0x0e28, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/3/10 */
    { 0x0e30, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/3/12 */
    { 0x0e38, 0x0e23, 0x0420, RTFLOAT80U_INIT_C(1,0x6c9ac9b9d7892401,0), INT16_C(0) }, /* #31/3/14 */
    { 0x0240, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/0/0 */
    { 0x0248, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/0/2 */
    { 0x0250, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/0/4 */
    { 0x0258, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/0/6 */
    { 0x0260, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/0/8 */
    { 0x0268, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/0/10 */
    { 0x0270, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/0/12 */
    { 0x0278, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/0/14 */
    { 0x0640, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/1/0 */
    { 0x0648, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/1/2 */
    { 0x0650, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/1/4 */
    { 0x0658, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/1/6 */
    { 0x0660, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/1/8 */
    { 0x0668, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/1/10 */
    { 0x0670, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/1/12 */
    { 0x0678, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/1/14 */
    { 0x0a40, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/2/0 */
    { 0x0a48, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/2/2 */
    { 0x0a50, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/2/4 */
    { 0x0a58, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/2/6 */
    { 0x0a60, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/2/8 */
    { 0x0a68, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/2/10 */
    { 0x0a70, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/2/12 */
    { 0x0a78, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/2/14 */
    { 0x0e40, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/3/0 */
    { 0x0e48, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/3/2 */
    { 0x0e50, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/3/4 */
    { 0x0e58, 0x3d50, 0x85a0, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/3/6 */
    { 0x0e60, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/3/8 */
    { 0x0e68, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/3/10 */
    { 0x0e70, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/3/12 */
    { 0x0e78, 0x3d50, 0x0520, RTFLOAT80U_INIT_C(0,0xc735035fe8cf6227,0), INT16_C(0) }, /* #32/3/14 */
    { 0x0001, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/0/0 */
    { 0x0009, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/0/2 */
    { 0x0011, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/0/4 */
    { 0x0019, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/0/6 */
    { 0x0021, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/0/8 */
    { 0x0029, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/0/10 */
    { 0x0031, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/0/12 */
    { 0x0039, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/0/14 */
    { 0x0401, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/1/0 */
    { 0x0409, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/1/2 */
    { 0x0411, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/1/4 */
    { 0x0419, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/1/6 */
    { 0x0421, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/1/8 */
    { 0x0429, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/1/10 */
    { 0x0431, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/1/12 */
    { 0x0439, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/1/14 */
    { 0x0801, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/2/0 */
    { 0x0809, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/2/2 */
    { 0x0811, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/2/4 */
    { 0x0819, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/2/6 */
    { 0x0821, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/2/8 */
    { 0x0829, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/2/10 */
    { 0x0831, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/2/12 */
    { 0x0839, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/2/14 */
    { 0x0c01, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/3/0 */
    { 0x0c09, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/3/2 */
    { 0x0c11, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/3/4 */
    { 0x0c19, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/3/6 */
    { 0x0c21, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/3/8 */
    { 0x0c29, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/3/10 */
    { 0x0c31, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/3/12 */
    { 0x0c39, 0xbed8, 0x0401, RTFLOAT80U_INIT_C(0,0x4e1af1261573,7641), INT16_MIN }, /* #33/3/14 */
    { 0x0306, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/0/0 */
    { 0x030e, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/0/2 */
    { 0x0316, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/0/4 */
    { 0x031e, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/0/6 */
    { 0x0326, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/0/8 */
    { 0x032e, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/0/10 */
    { 0x0336, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/0/12 */
    { 0x033e, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/0/14 */
    { 0x0706, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/1/0 */
    { 0x070e, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/1/2 */
    { 0x0716, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/1/4 */
    { 0x071e, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/1/6 */
    { 0x0726, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/1/8 */
    { 0x072e, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/1/10 */
    { 0x0736, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/1/12 */
    { 0x073e, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/1/14 */
    { 0x0b06, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/2/0 */
    { 0x0b0e, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/2/2 */
    { 0x0b16, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/2/4 */
    { 0x0b1e, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/2/6 */
    { 0x0b26, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/2/8 */
    { 0x0b2e, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/2/10 */
    { 0x0b36, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/2/12 */
    { 0x0b3e, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/2/14 */
    { 0x0f06, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/3/0 */
    { 0x0f0e, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/3/2 */
    { 0x0f16, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/3/4 */
    { 0x0f1e, 0x45b2, 0xc5a0, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/3/6 */
    { 0x0f26, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/3/8 */
    { 0x0f2e, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/3/10 */
    { 0x0f36, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/3/12 */
    { 0x0f3e, 0x45b2, 0x4520, RTFLOAT80U_INIT_C(0,0xb5e93394d664d533,16397), INT16_C(23284) }, /* #34/3/14 */
    { 0x0144, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/0/0 */
    { 0x014c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/0/2 */
    { 0x0154, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/0/4 */
    { 0x015c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/0/6 */
    { 0x0164, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/0/8 */
    { 0x016c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/0/10 */
    { 0x0174, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/0/12 */
    { 0x017c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/0/14 */
    { 0x0544, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/1/0 */
    { 0x054c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/1/2 */
    { 0x0554, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/1/4 */
    { 0x055c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/1/6 */
    { 0x0564, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/1/8 */
    { 0x056c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/1/10 */
    { 0x0574, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/1/12 */
    { 0x057c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/1/14 */
    { 0x0944, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/2/0 */
    { 0x094c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/2/2 */
    { 0x0954, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/2/4 */
    { 0x095c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/2/6 */
    { 0x0964, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/2/8 */
    { 0x096c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/2/10 */
    { 0x0974, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/2/12 */
    { 0x097c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/2/14 */
    { 0x0d44, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/3/0 */
    { 0x0d4c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/3/2 */
    { 0x0d54, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/3/4 */
    { 0x0d5c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/3/6 */
    { 0x0d64, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/3/8 */
    { 0x0d6c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/3/10 */
    { 0x0d74, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/3/12 */
    { 0x0d7c, 0xd89e, 0xf881, RTFLOAT80U_INIT_C(1,0xf365a7604270ace0,32767), INT16_C(-3) }, /* #35/3/14 */
    { 0x0205, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/0/0 */
    { 0x020d, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/0/2 */
    { 0x0215, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/0/4 */
    { 0x021d, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/0/6 */
    { 0x0225, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/0/8 */
    { 0x022d, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/0/10 */
    { 0x0235, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/0/12 */
    { 0x023d, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/0/14 */
    { 0x0605, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/1/0 */
    { 0x060d, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/1/2 */
    { 0x0615, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/1/4 */
    { 0x061d, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/1/6 */
    { 0x0625, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/1/8 */
    { 0x062d, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/1/10 */
    { 0x0635, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/1/12 */
    { 0x063d, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/1/14 */
    { 0x0a05, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/2/0 */
    { 0x0a0d, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/2/2 */
    { 0x0a15, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/2/4 */
    { 0x0a1d, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/2/6 */
    { 0x0a25, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/2/8 */
    { 0x0a2d, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/2/10 */
    { 0x0a35, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/2/12 */
    { 0x0a3d, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/2/14 */
    { 0x0e05, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/3/0 */
    { 0x0e0d, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/3/2 */
    { 0x0e15, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/3/4 */
    { 0x0e1d, 0xb838, 0x80a0, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/3/6 */
    { 0x0e25, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/3/8 */
    { 0x0e2d, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/3/10 */
    { 0x0e35, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/3/12 */
    { 0x0e3d, 0xb838, 0x0020, RTFLOAT80U_INIT_C(0,0xaf73803a29069644,16397), INT16_C(22457) }, /* #36/3/14 */
    { 0x0002, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/0/0 */
    { 0x000a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/0/2 */
    { 0x0012, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/0/4 */
    { 0x001a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/0/6 */
    { 0x0022, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/0/8 */
    { 0x002a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/0/10 */
    { 0x0032, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/0/12 */
    { 0x003a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/0/14 */
    { 0x0402, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/1/0 */
    { 0x040a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/1/2 */
    { 0x0412, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/1/4 */
    { 0x041a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/1/6 */
    { 0x0422, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/1/8 */
    { 0x042a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/1/10 */
    { 0x0432, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/1/12 */
    { 0x043a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/1/14 */
    { 0x0802, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/2/0 */
    { 0x080a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/2/2 */
    { 0x0812, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/2/4 */
    { 0x081a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/2/6 */
    { 0x0822, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/2/8 */
    { 0x082a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/2/10 */
    { 0x0832, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/2/12 */
    { 0x083a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/2/14 */
    { 0x0c02, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/3/0 */
    { 0x0c0a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/3/2 */
    { 0x0c12, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/3/4 */
    { 0x0c1a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/3/6 */
    { 0x0c22, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/3/8 */
    { 0x0c2a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/3/10 */
    { 0x0c32, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/3/12 */
    { 0x0c3a, 0x3574, 0xbd81, RTFLOAT80U_INIT_C(1,0x912d5fe175b25dd1,32767), INT16_C(-3) }, /* #37/3/14 */
    { 0x0207, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/0/0 */
    { 0x020f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/0/2 */
    { 0x0217, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/0/4 */
    { 0x021f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/0/6 */
    { 0x0227, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/0/8 */
    { 0x022f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/0/10 */
    { 0x0237, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/0/12 */
    { 0x023f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/0/14 */
    { 0x0607, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/1/0 */
    { 0x060f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/1/2 */
    { 0x0617, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/1/4 */
    { 0x061f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/1/6 */
    { 0x0627, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/1/8 */
    { 0x062f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/1/10 */
    { 0x0637, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/1/12 */
    { 0x063f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/1/14 */
    { 0x0a07, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/2/0 */
    { 0x0a0f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/2/2 */
    { 0x0a17, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/2/4 */
    { 0x0a1f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/2/6 */
    { 0x0a27, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/2/8 */
    { 0x0a2f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/2/10 */
    { 0x0a37, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/2/12 */
    { 0x0a3f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/2/14 */
    { 0x0e07, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/3/0 */
    { 0x0e0f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/3/2 */
    { 0x0e17, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/3/4 */
    { 0x0e1f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/3/6 */
    { 0x0e27, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/3/8 */
    { 0x0e2f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/3/10 */
    { 0x0e37, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/3/12 */
    { 0x0e3f, 0xa83c, 0x0001, RTFLOAT80U_INIT_C(0,0x1e126,23219), INT16_MIN }, /* #38/3/14 */
    { 0x0205, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/0/0 */
    { 0x020d, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/0/2 */
    { 0x0215, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/0/4 */
    { 0x021d, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/0/6 */
    { 0x0225, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/0/8 */
    { 0x022d, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/0/10 */
    { 0x0235, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/0/12 */
    { 0x023d, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/0/14 */
    { 0x0605, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/1/0 */
    { 0x060d, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/1/2 */
    { 0x0615, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/1/4 */
    { 0x061d, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/1/6 */
    { 0x0625, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/1/8 */
    { 0x062d, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/1/10 */
    { 0x0635, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/1/12 */
    { 0x063d, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/1/14 */
    { 0x0a05, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/2/0 */
    { 0x0a0d, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/2/2 */
    { 0x0a15, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/2/4 */
    { 0x0a1d, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/2/6 */
    { 0x0a25, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/2/8 */
    { 0x0a2d, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/2/10 */
    { 0x0a35, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/2/12 */
    { 0x0a3d, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/2/14 */
    { 0x0e05, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/3/0 */
    { 0x0e0d, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/3/2 */
    { 0x0e15, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/3/4 */
    { 0x0e1d, 0x38df, 0x80a0, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/3/6 */
    { 0x0e25, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/3/8 */
    { 0x0e2d, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/3/10 */
    { 0x0e35, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/3/12 */
    { 0x0e3d, 0x38df, 0x0020, RTFLOAT80U_INIT_C(0,0xb4ce945cf3afc15d,16397), INT16_C(23143) }, /* #39/3/14 */
    { 0x0245, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/0/0 */
    { 0x024d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/0/2 */
    { 0x0255, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/0/4 */
    { 0x025d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/0/6 */
    { 0x0265, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/0/8 */
    { 0x026d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/0/10 */
    { 0x0275, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/0/12 */
    { 0x027d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/0/14 */
    { 0x0645, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/1/0 */
    { 0x064d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/1/2 */
    { 0x0655, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/1/4 */
    { 0x065d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/1/6 */
    { 0x0665, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/1/8 */
    { 0x066d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/1/10 */
    { 0x0675, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/1/12 */
    { 0x067d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/1/14 */
    { 0x0a45, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/2/0 */
    { 0x0a4d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/2/2 */
    { 0x0a55, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/2/4 */
    { 0x0a5d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/2/6 */
    { 0x0a65, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/2/8 */
    { 0x0a6d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/2/10 */
    { 0x0a75, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/2/12 */
    { 0x0a7d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/2/14 */
    { 0x0e45, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/3/0 */
    { 0x0e4d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/3/2 */
    { 0x0e55, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/3/4 */
    { 0x0e5d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/3/6 */
    { 0x0e65, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/3/8 */
    { 0x0e6d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/3/10 */
    { 0x0e75, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/3/12 */
    { 0x0e7d, 0x7989, 0x4101, RTFLOAT80U_INIT_C(1,0x8f75b1a950cc3814,32767), INT16_MIN }, /* #40/3/14 */
    { 0x0301, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/0/0 */
    { 0x0309, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/0/2 */
    { 0x0311, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/0/4 */
    { 0x0319, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/0/6 */
    { 0x0321, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/0/8 */
    { 0x0329, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/0/10 */
    { 0x0331, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/0/12 */
    { 0x0339, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/0/14 */
    { 0x0701, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/1/0 */
    { 0x0709, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/1/2 */
    { 0x0711, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/1/4 */
    { 0x0719, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/1/6 */
    { 0x0721, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/1/8 */
    { 0x0729, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/1/10 */
    { 0x0731, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/1/12 */
    { 0x0739, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/1/14 */
    { 0x0b01, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/2/0 */
    { 0x0b09, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/2/2 */
    { 0x0b11, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/2/4 */
    { 0x0b19, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/2/6 */
    { 0x0b21, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/2/8 */
    { 0x0b29, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/2/10 */
    { 0x0b31, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/2/12 */
    { 0x0b39, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/2/14 */
    { 0x0f01, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/3/0 */
    { 0x0f09, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/3/2 */
    { 0x0f11, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/3/4 */
    { 0x0f19, 0xca35, 0xc0a0, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/3/6 */
    { 0x0f21, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/3/8 */
    { 0x0f29, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/3/10 */
    { 0x0f31, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/3/12 */
    { 0x0f39, 0xca35, 0x4020, RTFLOAT80U_INIT_C(1,0xc498b63a8b726a2d,16383), INT16_C(-1) }, /* #41/3/14 */
    { 0x0047, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/0/0 */
    { 0x004f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/0/2 */
    { 0x0057, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/0/4 */
    { 0x005f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/0/6 */
    { 0x0067, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/0/8 */
    { 0x006f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/0/10 */
    { 0x0077, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/0/12 */
    { 0x007f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/0/14 */
    { 0x0447, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/1/0 */
    { 0x044f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/1/2 */
    { 0x0457, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/1/4 */
    { 0x045f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/1/6 */
    { 0x0467, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/1/8 */
    { 0x046f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/1/10 */
    { 0x0477, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/1/12 */
    { 0x047f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/1/14 */
    { 0x0847, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/2/0 */
    { 0x084f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/2/2 */
    { 0x0857, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/2/4 */
    { 0x085f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/2/6 */
    { 0x0867, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/2/8 */
    { 0x086f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/2/10 */
    { 0x0877, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/2/12 */
    { 0x087f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/2/14 */
    { 0x0c47, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/3/0 */
    { 0x0c4f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/3/2 */
    { 0x0c57, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/3/4 */
    { 0x0c5f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/3/6 */
    { 0x0c67, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/3/8 */
    { 0x0c6f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/3/10 */
    { 0x0c77, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/3/12 */
    { 0x0c7f, 0x5077, 0x4001, RTFLOAT80U_INIT_C(0,0xd96830cb5ce94f,18579), INT16_MIN }, /* #42/3/14 */
    { 0x0101, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/0/0 */
    { 0x0109, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/0/2 */
    { 0x0111, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/0/4 */
    { 0x0119, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/0/6 */
    { 0x0121, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/0/8 */
    { 0x0129, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/0/10 */
    { 0x0131, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/0/12 */
    { 0x0139, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/0/14 */
    { 0x0501, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/1/0 */
    { 0x0509, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/1/2 */
    { 0x0511, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/1/4 */
    { 0x0519, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/1/6 */
    { 0x0521, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/1/8 */
    { 0x0529, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/1/10 */
    { 0x0531, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/1/12 */
    { 0x0539, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/1/14 */
    { 0x0901, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/2/0 */
    { 0x0909, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/2/2 */
    { 0x0911, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/2/4 */
    { 0x0919, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/2/6 */
    { 0x0921, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/2/8 */
    { 0x0929, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/2/10 */
    { 0x0931, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/2/12 */
    { 0x0939, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/2/14 */
    { 0x0d01, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/3/0 */
    { 0x0d09, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/3/2 */
    { 0x0d11, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/3/4 */
    { 0x0d19, 0x94ac, 0x84a0, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/3/6 */
    { 0x0d21, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/3/8 */
    { 0x0d29, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/3/10 */
    { 0x0d31, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/3/12 */
    { 0x0d39, 0x94ac, 0x0420, RTFLOAT80U_INIT_C(1,0x4be54d53eb9de7ec,0), INT16_C(0) }, /* #43/3/14 */
    { 0x0306, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/0/0 */
    { 0x030e, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/0/2 */
    { 0x0316, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/0/4 */
    { 0x031e, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/0/6 */
    { 0x0326, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/0/8 */
    { 0x032e, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/0/10 */
    { 0x0336, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/0/12 */
    { 0x033e, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/0/14 */
    { 0x0706, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/1/0 */
    { 0x070e, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/1/2 */
    { 0x0716, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/1/4 */
    { 0x071e, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/1/6 */
    { 0x0726, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/1/8 */
    { 0x072e, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/1/10 */
    { 0x0736, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/1/12 */
    { 0x073e, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/1/14 */
    { 0x0b06, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/2/0 */
    { 0x0b0e, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/2/2 */
    { 0x0b16, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/2/4 */
    { 0x0b1e, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/2/6 */
    { 0x0b26, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/2/8 */
    { 0x0b2e, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/2/10 */
    { 0x0b36, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/2/12 */
    { 0x0b3e, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/2/14 */
    { 0x0f06, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/3/0 */
    { 0x0f0e, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/3/2 */
    { 0x0f16, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/3/4 */
    { 0x0f1e, 0x4e08, 0xc4a0, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/3/6 */
    { 0x0f26, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/3/8 */
    { 0x0f2e, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/3/10 */
    { 0x0f36, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/3/12 */
    { 0x0f3e, 0x4e08, 0x4420, RTFLOAT80U_INIT_C(1,0xf589e2d6d3f1090f,16383), INT16_C(-1) }, /* #44/3/14 */
    { 0x0342, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/0/0 */
    { 0x034a, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/0/2 */
    { 0x0352, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/0/4 */
    { 0x035a, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/0/6 */
    { 0x0362, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/0/8 */
    { 0x036a, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/0/10 */
    { 0x0372, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/0/12 */
    { 0x037a, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/0/14 */
    { 0x0742, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/1/0 */
    { 0x074a, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/1/2 */
    { 0x0752, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/1/4 */
    { 0x075a, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/1/6 */
    { 0x0762, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/1/8 */
    { 0x076a, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/1/10 */
    { 0x0772, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/1/12 */
    { 0x077a, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/1/14 */
    { 0x0b42, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/2/0 */
    { 0x0b4a, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/2/2 */
    { 0x0b52, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/2/4 */
    { 0x0b5a, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/2/6 */
    { 0x0b62, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/2/8 */
    { 0x0b6a, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/2/10 */
    { 0x0b72, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/2/12 */
    { 0x0b7a, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/2/14 */
    { 0x0f42, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/3/0 */
    { 0x0f4a, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/3/2 */
    { 0x0f52, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/3/4 */
    { 0x0f5a, 0xfa0b, 0xc0a0, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/3/6 */
    { 0x0f62, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/3/8 */
    { 0x0f6a, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/3/10 */
    { 0x0f72, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/3/12 */
    { 0x0f7a, 0xfa0b, 0x4020, RTFLOAT80U_INIT_C(1,0xd1a3e82cc2c11279,10688), INT16_C(0) }, /* #45/3/14 */
    { 0x0305, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/0/0 */
    { 0x030d, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/0/2 */
    { 0x0315, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/0/4 */
    { 0x031d, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/0/6 */
    { 0x0325, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/0/8 */
    { 0x032d, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/0/10 */
    { 0x0335, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/0/12 */
    { 0x033d, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/0/14 */
    { 0x0705, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/1/0 */
    { 0x070d, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/1/2 */
    { 0x0715, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/1/4 */
    { 0x071d, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/1/6 */
    { 0x0725, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/1/8 */
    { 0x072d, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/1/10 */
    { 0x0735, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/1/12 */
    { 0x073d, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/1/14 */
    { 0x0b05, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/2/0 */
    { 0x0b0d, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/2/2 */
    { 0x0b15, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/2/4 */
    { 0x0b1d, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/2/6 */
    { 0x0b25, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/2/8 */
    { 0x0b2d, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/2/10 */
    { 0x0b35, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/2/12 */
    { 0x0b3d, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/2/14 */
    { 0x0f05, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/3/0 */
    { 0x0f0d, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/3/2 */
    { 0x0f15, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/3/4 */
    { 0x0f1d, 0x5fdf, 0xc5a0, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/3/6 */
    { 0x0f25, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/3/8 */
    { 0x0f2d, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/3/10 */
    { 0x0f35, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/3/12 */
    { 0x0f3d, 0x5fdf, 0x4520, RTFLOAT80U_INIT_C(1,0xe0a7a6ff8a0547b8,16383), INT16_C(-1) }, /* #46/3/14 */
    { 0x0106, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/0/0 */
    { 0x010e, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/0/2 */
    { 0x0116, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/0/4 */
    { 0x011e, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/0/6 */
    { 0x0126, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/0/8 */
    { 0x012e, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/0/10 */
    { 0x0136, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/0/12 */
    { 0x013e, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/0/14 */
    { 0x0506, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/1/0 */
    { 0x050e, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/1/2 */
    { 0x0516, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/1/4 */
    { 0x051e, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/1/6 */
    { 0x0526, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/1/8 */
    { 0x052e, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/1/10 */
    { 0x0536, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/1/12 */
    { 0x053e, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/1/14 */
    { 0x0906, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/2/0 */
    { 0x090e, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/2/2 */
    { 0x0916, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/2/4 */
    { 0x091e, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/2/6 */
    { 0x0926, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/2/8 */
    { 0x092e, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/2/10 */
    { 0x0936, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/2/12 */
    { 0x093e, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/2/14 */
    { 0x0d06, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/3/0 */
    { 0x0d0e, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/3/2 */
    { 0x0d16, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/3/4 */
    { 0x0d1e, 0xd634, 0xc4a0, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/3/6 */
    { 0x0d26, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/3/8 */
    { 0x0d2e, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/3/10 */
    { 0x0d36, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/3/12 */
    { 0x0d3e, 0xd634, 0x4420, RTFLOAT80U_INIT_C(1,0xca9a9ff91c50096c,0), INT16_C(0) }, /* #47/3/14 */
    { 0x0343, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/0/0 */
    { 0x034b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/0/2 */
    { 0x0353, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/0/4 */
    { 0x035b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/0/6 */
    { 0x0363, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/0/8 */
    { 0x036b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/0/10 */
    { 0x0373, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/0/12 */
    { 0x037b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/0/14 */
    { 0x0743, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/1/0 */
    { 0x074b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/1/2 */
    { 0x0753, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/1/4 */
    { 0x075b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/1/6 */
    { 0x0763, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/1/8 */
    { 0x076b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/1/10 */
    { 0x0773, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/1/12 */
    { 0x077b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/1/14 */
    { 0x0b43, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/2/0 */
    { 0x0b4b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/2/2 */
    { 0x0b53, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/2/4 */
    { 0x0b5b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/2/6 */
    { 0x0b63, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/2/8 */
    { 0x0b6b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/2/10 */
    { 0x0b73, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/2/12 */
    { 0x0b7b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/2/14 */
    { 0x0f43, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/3/0 */
    { 0x0f4b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/3/2 */
    { 0x0f53, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/3/4 */
    { 0x0f5b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/3/6 */
    { 0x0f63, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/3/8 */
    { 0x0f6b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/3/10 */
    { 0x0f73, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/3/12 */
    { 0x0f7b, 0x8114, 0x0101, RTFLOAT80U_INIT_C(1,0x132d64a15485a94,5347), INT16_MIN }, /* #48/3/14 */
    { 0x0106, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/0/0 */
    { 0x010e, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/0/2 */
    { 0x0116, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/0/4 */
    { 0x011e, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/0/6 */
    { 0x0126, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/0/8 */
    { 0x012e, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/0/10 */
    { 0x0136, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/0/12 */
    { 0x013e, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/0/14 */
    { 0x0506, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/1/0 */
    { 0x050e, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/1/2 */
    { 0x0516, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/1/4 */
    { 0x051e, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/1/6 */
    { 0x0526, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/1/8 */
    { 0x052e, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/1/10 */
    { 0x0536, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/1/12 */
    { 0x053e, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/1/14 */
    { 0x0906, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/2/0 */
    { 0x090e, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/2/2 */
    { 0x0916, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/2/4 */
    { 0x091e, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/2/6 */
    { 0x0926, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/2/8 */
    { 0x092e, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/2/10 */
    { 0x0936, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/2/12 */
    { 0x093e, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/2/14 */
    { 0x0d06, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/3/0 */
    { 0x0d0e, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/3/2 */
    { 0x0d16, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/3/4 */
    { 0x0d1e, 0x5b3d, 0xc1a0, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/3/6 */
    { 0x0d26, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/3/8 */
    { 0x0d2e, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/3/10 */
    { 0x0d36, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/3/12 */
    { 0x0d3e, 0x5b3d, 0x4120, RTFLOAT80U_INIT_C(0,0x98319d1e1fcd3099,16397), INT16_C(19480) }, /* #49/3/14 */
    { 0x0243, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/0/0 */
    { 0x024b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/0/2 */
    { 0x0253, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/0/4 */
    { 0x025b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/0/6 */
    { 0x0263, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/0/8 */
    { 0x026b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/0/10 */
    { 0x0273, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/0/12 */
    { 0x027b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/0/14 */
    { 0x0643, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/1/0 */
    { 0x064b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/1/2 */
    { 0x0653, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/1/4 */
    { 0x065b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/1/6 */
    { 0x0663, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/1/8 */
    { 0x066b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/1/10 */
    { 0x0673, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/1/12 */
    { 0x067b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/1/14 */
    { 0x0a43, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/2/0 */
    { 0x0a4b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/2/2 */
    { 0x0a53, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/2/4 */
    { 0x0a5b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/2/6 */
    { 0x0a63, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/2/8 */
    { 0x0a6b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/2/10 */
    { 0x0a73, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/2/12 */
    { 0x0a7b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/2/14 */
    { 0x0e43, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/3/0 */
    { 0x0e4b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/3/2 */
    { 0x0e53, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/3/4 */
    { 0x0e5b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/3/6 */
    { 0x0e63, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/3/8 */
    { 0x0e6b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/3/10 */
    { 0x0e73, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/3/12 */
    { 0x0e7b, 0x68a7, 0x4001, RTFLOAT80U_INIT_C(0,0x7091dee0ba3cd822,23817), INT16_MIN }, /* #50/3/14 */
    { 0x0103, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/0/0 */
    { 0x010b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/0/2 */
    { 0x0113, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/0/4 */
    { 0x011b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/0/6 */
    { 0x0123, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/0/8 */
    { 0x012b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/0/10 */
    { 0x0133, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/0/12 */
    { 0x013b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/0/14 */
    { 0x0503, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/1/0 */
    { 0x050b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/1/2 */
    { 0x0513, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/1/4 */
    { 0x051b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/1/6 */
    { 0x0523, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/1/8 */
    { 0x052b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/1/10 */
    { 0x0533, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/1/12 */
    { 0x053b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/1/14 */
    { 0x0903, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/2/0 */
    { 0x090b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/2/2 */
    { 0x0913, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/2/4 */
    { 0x091b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/2/6 */
    { 0x0923, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/2/8 */
    { 0x092b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/2/10 */
    { 0x0933, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/2/12 */
    { 0x093b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/2/14 */
    { 0x0d03, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/3/0 */
    { 0x0d0b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/3/2 */
    { 0x0d13, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/3/4 */
    { 0x0d1b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/3/6 */
    { 0x0d23, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/3/8 */
    { 0x0d2b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/3/10 */
    { 0x0d33, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/3/12 */
    { 0x0d3b, 0xdca0, 0x4401, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), INT16_MIN }, /* #51/3/14 */
    { 0x0102, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/0/0 */
    { 0x010a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/0/2 */
    { 0x0112, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/0/4 */
    { 0x011a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/0/6 */
    { 0x0122, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/0/8 */
    { 0x012a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/0/10 */
    { 0x0132, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/0/12 */
    { 0x013a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/0/14 */
    { 0x0502, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/1/0 */
    { 0x050a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/1/2 */
    { 0x0512, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/1/4 */
    { 0x051a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/1/6 */
    { 0x0522, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/1/8 */
    { 0x052a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/1/10 */
    { 0x0532, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/1/12 */
    { 0x053a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/1/14 */
    { 0x0902, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/2/0 */
    { 0x090a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/2/2 */
    { 0x0912, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/2/4 */
    { 0x091a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/2/6 */
    { 0x0922, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/2/8 */
    { 0x092a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/2/10 */
    { 0x0932, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/2/12 */
    { 0x093a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/2/14 */
    { 0x0d02, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/3/0 */
    { 0x0d0a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/3/2 */
    { 0x0d12, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/3/4 */
    { 0x0d1a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/3/6 */
    { 0x0d22, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/3/8 */
    { 0x0d2a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/3/10 */
    { 0x0d32, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/3/12 */
    { 0x0d3a, 0x631b, 0xf981, RTFLOAT80U_INIT_C(1,0x5e65db808cd1bf4b,16407), INT16_C(-3) }, /* #52/3/14 */
    { 0x0244, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/0/0 */
    { 0x024c, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/0/2 */
    { 0x0254, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/0/4 */
    { 0x025c, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/0/6 */
    { 0x0264, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/0/8 */
    { 0x026c, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/0/10 */
    { 0x0274, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/0/12 */
    { 0x027c, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/0/14 */
    { 0x0644, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/1/0 */
    { 0x064c, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/1/2 */
    { 0x0654, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/1/4 */
    { 0x065c, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/1/6 */
    { 0x0664, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/1/8 */
    { 0x066c, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/1/10 */
    { 0x0674, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/1/12 */
    { 0x067c, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/1/14 */
    { 0x0a44, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/2/0 */
    { 0x0a4c, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/2/2 */
    { 0x0a54, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/2/4 */
    { 0x0a5c, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/2/6 */
    { 0x0a64, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/2/8 */
    { 0x0a6c, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/2/10 */
    { 0x0a74, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/2/12 */
    { 0x0a7c, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/2/14 */
    { 0x0e44, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/3/0 */
    { 0x0e4c, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/3/2 */
    { 0x0e54, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/3/4 */
    { 0x0e5c, 0x2962, 0x81a0, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/3/6 */
    { 0x0e64, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/3/8 */
    { 0x0e6c, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/3/10 */
    { 0x0e74, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/3/12 */
    { 0x0e7c, 0x2962, 0x0120, RTFLOAT80U_INIT_C(0,0xe82664bfd353e22e,16397), INT16_C(29715) }, /* #53/3/14 */
    { 0x0202, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/0/0 */
    { 0x020a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/0/2 */
    { 0x0212, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/0/4 */
    { 0x021a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/0/6 */
    { 0x0222, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/0/8 */
    { 0x022a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/0/10 */
    { 0x0232, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/0/12 */
    { 0x023a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/0/14 */
    { 0x0602, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/1/0 */
    { 0x060a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/1/2 */
    { 0x0612, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/1/4 */
    { 0x061a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/1/6 */
    { 0x0622, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/1/8 */
    { 0x062a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/1/10 */
    { 0x0632, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/1/12 */
    { 0x063a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/1/14 */
    { 0x0a02, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/2/0 */
    { 0x0a0a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/2/2 */
    { 0x0a12, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/2/4 */
    { 0x0a1a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/2/6 */
    { 0x0a22, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/2/8 */
    { 0x0a2a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/2/10 */
    { 0x0a32, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/2/12 */
    { 0x0a3a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/2/14 */
    { 0x0e02, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/3/0 */
    { 0x0e0a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/3/2 */
    { 0x0e12, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/3/4 */
    { 0x0e1a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/3/6 */
    { 0x0e22, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/3/8 */
    { 0x0e2a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/3/10 */
    { 0x0e32, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/3/12 */
    { 0x0e3a, 0xab17, 0xb981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_C(-3) }, /* #54/3/14 */
    { 0x0107, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/0/0 */
    { 0x010f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/0/2 */
    { 0x0117, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/0/4 */
    { 0x011f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/0/6 */
    { 0x0127, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/0/8 */
    { 0x012f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/0/10 */
    { 0x0137, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/0/12 */
    { 0x013f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/0/14 */
    { 0x0507, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/1/0 */
    { 0x050f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/1/2 */
    { 0x0517, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/1/4 */
    { 0x051f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/1/6 */
    { 0x0527, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/1/8 */
    { 0x052f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/1/10 */
    { 0x0537, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/1/12 */
    { 0x053f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/1/14 */
    { 0x0907, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/2/0 */
    { 0x090f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/2/2 */
    { 0x0917, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/2/4 */
    { 0x091f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/2/6 */
    { 0x0927, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/2/8 */
    { 0x092f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/2/10 */
    { 0x0937, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/2/12 */
    { 0x093f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/2/14 */
    { 0x0d07, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/3/0 */
    { 0x0d0f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/3/2 */
    { 0x0d17, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/3/4 */
    { 0x0d1f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/3/6 */
    { 0x0d27, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/3/8 */
    { 0x0d2f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/3/10 */
    { 0x0d37, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/3/12 */
    { 0x0d3f, 0x026f, 0x0001, RTFLOAT80U_INIT_C(1,0x78d4839873bafb7b,11809), INT16_MIN }, /* #55/3/14 */
    { 0x0101, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/0/0 */
    { 0x0109, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/0/2 */
    { 0x0111, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/0/4 */
    { 0x0119, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/0/6 */
    { 0x0121, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/0/8 */
    { 0x0129, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/0/10 */
    { 0x0131, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/0/12 */
    { 0x0139, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/0/14 */
    { 0x0501, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/1/0 */
    { 0x0509, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/1/2 */
    { 0x0511, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/1/4 */
    { 0x0519, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/1/6 */
    { 0x0521, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/1/8 */
    { 0x0529, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/1/10 */
    { 0x0531, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/1/12 */
    { 0x0539, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/1/14 */
    { 0x0901, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/2/0 */
    { 0x0909, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/2/2 */
    { 0x0911, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/2/4 */
    { 0x0919, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/2/6 */
    { 0x0921, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/2/8 */
    { 0x0929, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/2/10 */
    { 0x0931, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/2/12 */
    { 0x0939, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/2/14 */
    { 0x0d01, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/3/0 */
    { 0x0d09, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/3/2 */
    { 0x0d11, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/3/4 */
    { 0x0d19, 0xea8e, 0xc0a0, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/3/6 */
    { 0x0d21, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/3/8 */
    { 0x0d29, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/3/10 */
    { 0x0d31, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/3/12 */
    { 0x0d39, 0xea8e, 0x4020, RTFLOAT80U_INIT_C(1,0xee1b3406d6744fae,3471), INT16_C(0) }, /* #56/3/14 */
    { 0x0141, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/0/0 */
    { 0x0149, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/0/2 */
    { 0x0151, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/0/4 */
    { 0x0159, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/0/6 */
    { 0x0161, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/0/8 */
    { 0x0169, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/0/10 */
    { 0x0171, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/0/12 */
    { 0x0179, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/0/14 */
    { 0x0541, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/1/0 */
    { 0x0549, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/1/2 */
    { 0x0551, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/1/4 */
    { 0x0559, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/1/6 */
    { 0x0561, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/1/8 */
    { 0x0569, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/1/10 */
    { 0x0571, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/1/12 */
    { 0x0579, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/1/14 */
    { 0x0941, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/2/0 */
    { 0x0949, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/2/2 */
    { 0x0951, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/2/4 */
    { 0x0959, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/2/6 */
    { 0x0961, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/2/8 */
    { 0x0969, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/2/10 */
    { 0x0971, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/2/12 */
    { 0x0979, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/2/14 */
    { 0x0d41, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/3/0 */
    { 0x0d49, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/3/2 */
    { 0x0d51, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/3/4 */
    { 0x0d59, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/3/6 */
    { 0x0d61, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/3/8 */
    { 0x0d69, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/3/10 */
    { 0x0d71, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/3/12 */
    { 0x0d79, 0x5b68, 0x4101, RTFLOAT80U_INIT_C(1,0x59ca2c2601b71133,4), INT16_MIN }, /* #57/3/14 */
    { 0x0301, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/0/0 */
    { 0x0309, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/0/2 */
    { 0x0311, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/0/4 */
    { 0x0319, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/0/6 */
    { 0x0321, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/0/8 */
    { 0x0329, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/0/10 */
    { 0x0331, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/0/12 */
    { 0x0339, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/0/14 */
    { 0x0701, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/1/0 */
    { 0x0709, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/1/2 */
    { 0x0711, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/1/4 */
    { 0x0719, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/1/6 */
    { 0x0721, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/1/8 */
    { 0x0729, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/1/10 */
    { 0x0731, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/1/12 */
    { 0x0739, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/1/14 */
    { 0x0b01, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/2/0 */
    { 0x0b09, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/2/2 */
    { 0x0b11, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/2/4 */
    { 0x0b19, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/2/6 */
    { 0x0b21, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/2/8 */
    { 0x0b29, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/2/10 */
    { 0x0b31, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/2/12 */
    { 0x0b39, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/2/14 */
    { 0x0f01, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/3/0 */
    { 0x0f09, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/3/2 */
    { 0x0f11, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/3/4 */
    { 0x0f19, 0x1c93, 0x84a0, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/3/6 */
    { 0x0f21, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/3/8 */
    { 0x0f29, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/3/10 */
    { 0x0f31, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/3/12 */
    { 0x0f39, 0x1c93, 0x0420, RTFLOAT80U_INIT_C(1,0x861474e7f73d011e,16397), INT16_C(-17162) }, /* #58/3/14 */
    { 0x0041, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/0/0 */
    { 0x0049, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/0/2 */
    { 0x0051, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/0/4 */
    { 0x0059, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/0/6 */
    { 0x0061, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/0/8 */
    { 0x0069, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/0/10 */
    { 0x0071, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/0/12 */
    { 0x0079, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/0/14 */
    { 0x0441, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/1/0 */
    { 0x0449, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/1/2 */
    { 0x0451, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/1/4 */
    { 0x0459, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/1/6 */
    { 0x0461, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/1/8 */
    { 0x0469, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/1/10 */
    { 0x0471, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/1/12 */
    { 0x0479, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/1/14 */
    { 0x0841, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/2/0 */
    { 0x0849, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/2/2 */
    { 0x0851, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/2/4 */
    { 0x0859, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/2/6 */
    { 0x0861, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/2/8 */
    { 0x0869, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/2/10 */
    { 0x0871, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/2/12 */
    { 0x0879, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/2/14 */
    { 0x0c41, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/3/0 */
    { 0x0c49, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/3/2 */
    { 0x0c51, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/3/4 */
    { 0x0c59, 0xe05f, 0xc0a0, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/3/6 */
    { 0x0c61, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/3/8 */
    { 0x0c69, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/3/10 */
    { 0x0c71, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/3/12 */
    { 0x0c79, 0xe05f, 0x4020, RTFLOAT80U_INIT_C(1,0xae46d7647568b8f4,16397), INT16_C(-22307) }, /* #59/3/14 */
    { 0x0104, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/0/0 */
    { 0x010c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/0/2 */
    { 0x0114, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/0/4 */
    { 0x011c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/0/6 */
    { 0x0124, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/0/8 */
    { 0x012c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/0/10 */
    { 0x0134, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/0/12 */
    { 0x013c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/0/14 */
    { 0x0504, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/1/0 */
    { 0x050c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/1/2 */
    { 0x0514, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/1/4 */
    { 0x051c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/1/6 */
    { 0x0524, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/1/8 */
    { 0x052c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/1/10 */
    { 0x0534, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/1/12 */
    { 0x053c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/1/14 */
    { 0x0904, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/2/0 */
    { 0x090c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/2/2 */
    { 0x0914, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/2/4 */
    { 0x091c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/2/6 */
    { 0x0924, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/2/8 */
    { 0x092c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/2/10 */
    { 0x0934, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/2/12 */
    { 0x093c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/2/14 */
    { 0x0d04, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/3/0 */
    { 0x0d0c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/3/2 */
    { 0x0d14, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/3/4 */
    { 0x0d1c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/3/6 */
    { 0x0d24, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/3/8 */
    { 0x0d2c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/3/10 */
    { 0x0d34, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/3/12 */
    { 0x0d3c, 0x9493, 0xbc81, RTFLOAT80U_INIT_C(1,0x9eb3,32767), INT16_C(-3) }, /* #60/3/14 */
    { 0x0346, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/0/0 */
    { 0x034e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/0/2 */
    { 0x0356, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/0/4 */
    { 0x035e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/0/6 */
    { 0x0366, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/0/8 */
    { 0x036e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/0/10 */
    { 0x0376, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/0/12 */
    { 0x037e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/0/14 */
    { 0x0746, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/1/0 */
    { 0x074e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/1/2 */
    { 0x0756, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/1/4 */
    { 0x075e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/1/6 */
    { 0x0766, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/1/8 */
    { 0x076e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/1/10 */
    { 0x0776, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/1/12 */
    { 0x077e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/1/14 */
    { 0x0b46, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/2/0 */
    { 0x0b4e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/2/2 */
    { 0x0b56, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/2/4 */
    { 0x0b5e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/2/6 */
    { 0x0b66, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/2/8 */
    { 0x0b6e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/2/10 */
    { 0x0b76, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/2/12 */
    { 0x0b7e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/2/14 */
    { 0x0f46, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/3/0 */
    { 0x0f4e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/3/2 */
    { 0x0f56, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/3/4 */
    { 0x0f5e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/3/6 */
    { 0x0f66, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/3/8 */
    { 0x0f6e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/3/10 */
    { 0x0f76, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/3/12 */
    { 0x0f7e, 0x81a5, 0xb981, RTFLOAT80U_INIT_C(0,0x2c7a65b4c24a8d2c,32767), INT16_C(-3) }, /* #61/3/14 */
    { 0x0243, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/0/0 */
    { 0x024b, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/0/2 */
    { 0x0253, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/0/4 */
    { 0x025b, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/0/6 */
    { 0x0263, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/0/8 */
    { 0x026b, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/0/10 */
    { 0x0273, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/0/12 */
    { 0x027b, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/0/14 */
    { 0x0643, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/1/0 */
    { 0x064b, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/1/2 */
    { 0x0653, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/1/4 */
    { 0x065b, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/1/6 */
    { 0x0663, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/1/8 */
    { 0x066b, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/1/10 */
    { 0x0673, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/1/12 */
    { 0x067b, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/1/14 */
    { 0x0a43, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/2/0 */
    { 0x0a4b, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/2/2 */
    { 0x0a53, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/2/4 */
    { 0x0a5b, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/2/6 */
    { 0x0a63, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/2/8 */
    { 0x0a6b, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/2/10 */
    { 0x0a73, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/2/12 */
    { 0x0a7b, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/2/14 */
    { 0x0e43, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/3/0 */
    { 0x0e4b, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/3/2 */
    { 0x0e53, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/3/4 */
    { 0x0e5b, 0x9e0e, 0x84a0, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/3/6 */
    { 0x0e63, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/3/8 */
    { 0x0e6b, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/3/10 */
    { 0x0e73, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/3/12 */
    { 0x0e7b, 0x9e0e, 0x0420, RTFLOAT80U_INIT_C(0,0xe24b530f962fe4a2,3935), INT16_C(0) }, /* #62/3/14 */
    { 0x0002, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/0/0 */
    { 0x000a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/0/2 */
    { 0x0012, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/0/4 */
    { 0x001a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/0/6 */
    { 0x0022, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/0/8 */
    { 0x002a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/0/10 */
    { 0x0032, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/0/12 */
    { 0x003a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/0/14 */
    { 0x0402, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/1/0 */
    { 0x040a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/1/2 */
    { 0x0412, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/1/4 */
    { 0x041a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/1/6 */
    { 0x0422, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/1/8 */
    { 0x042a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/1/10 */
    { 0x0432, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/1/12 */
    { 0x043a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/1/14 */
    { 0x0802, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/2/0 */
    { 0x080a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/2/2 */
    { 0x0812, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/2/4 */
    { 0x081a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/2/6 */
    { 0x0822, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/2/8 */
    { 0x082a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/2/10 */
    { 0x0832, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/2/12 */
    { 0x083a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/2/14 */
    { 0x0c02, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/3/0 */
    { 0x0c0a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/3/2 */
    { 0x0c12, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/3/4 */
    { 0x0c1a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/3/6 */
    { 0x0c22, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/3/8 */
    { 0x0c2a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/3/10 */
    { 0x0c32, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/3/12 */
    { 0x0c3a, 0xf7de, 0x4500, RTFLOAT80U_INIT_C(0,0x0,0), INT16_C(0) }, /* #63/3/14 */
    { 0x0144, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/0/0 */
    { 0x014c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/0/2 */
    { 0x0154, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/0/4 */
    { 0x015c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/0/6 */
    { 0x0164, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/0/8 */
    { 0x016c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/0/10 */
    { 0x0174, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/0/12 */
    { 0x017c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/0/14 */
    { 0x0544, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/1/0 */
    { 0x054c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/1/2 */
    { 0x0554, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/1/4 */
    { 0x055c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/1/6 */
    { 0x0564, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/1/8 */
    { 0x056c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/1/10 */
    { 0x0574, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/1/12 */
    { 0x057c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/1/14 */
    { 0x0944, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/2/0 */
    { 0x094c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/2/2 */
    { 0x0954, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/2/4 */
    { 0x095c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/2/6 */
    { 0x0964, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/2/8 */
    { 0x096c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/2/10 */
    { 0x0974, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/2/12 */
    { 0x097c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/2/14 */
    { 0x0d44, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/3/0 */
    { 0x0d4c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/3/2 */
    { 0x0d54, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/3/4 */
    { 0x0d5c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/3/6 */
    { 0x0d64, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/3/8 */
    { 0x0d6c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/3/10 */
    { 0x0d74, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/3/12 */
    { 0x0d7c, 0x3064, 0xb881, RTFLOAT80U_INIT_C(1,0x1ac71b,19119), INT16_C(-3) }, /* #64/3/14 */
    { 0x0305, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/0/0 */
    { 0x030d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/0/2 */
    { 0x0315, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/0/4 */
    { 0x031d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/0/6 */
    { 0x0325, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/0/8 */
    { 0x032d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/0/10 */
    { 0x0335, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/0/12 */
    { 0x033d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/0/14 */
    { 0x0705, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/1/0 */
    { 0x070d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/1/2 */
    { 0x0715, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/1/4 */
    { 0x071d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/1/6 */
    { 0x0725, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/1/8 */
    { 0x072d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/1/10 */
    { 0x0735, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/1/12 */
    { 0x073d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/1/14 */
    { 0x0b05, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/2/0 */
    { 0x0b0d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/2/2 */
    { 0x0b15, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/2/4 */
    { 0x0b1d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/2/6 */
    { 0x0b25, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/2/8 */
    { 0x0b2d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/2/10 */
    { 0x0b35, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/2/12 */
    { 0x0b3d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/2/14 */
    { 0x0f05, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/3/0 */
    { 0x0f0d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/3/2 */
    { 0x0f15, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/3/4 */
    { 0x0f1d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/3/6 */
    { 0x0f25, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/3/8 */
    { 0x0f2d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/3/10 */
    { 0x0f35, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/3/12 */
    { 0x0f3d, 0x0a53, 0x0001, RTFLOAT80U_INIT_C(0,0x2681be92d43dd1,23634), INT16_MIN }, /* #65/3/14 */
    { 0x0044, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/0/0 */
    { 0x004c, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/0/2 */
    { 0x0054, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/0/4 */
    { 0x005c, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/0/6 */
    { 0x0064, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/0/8 */
    { 0x006c, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/0/10 */
    { 0x0074, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/0/12 */
    { 0x007c, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/0/14 */
    { 0x0444, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/1/0 */
    { 0x044c, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/1/2 */
    { 0x0454, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/1/4 */
    { 0x045c, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/1/6 */
    { 0x0464, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/1/8 */
    { 0x046c, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/1/10 */
    { 0x0474, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/1/12 */
    { 0x047c, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/1/14 */
    { 0x0844, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/2/0 */
    { 0x084c, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/2/2 */
    { 0x0854, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/2/4 */
    { 0x085c, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/2/6 */
    { 0x0864, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/2/8 */
    { 0x086c, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/2/10 */
    { 0x0874, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/2/12 */
    { 0x087c, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/2/14 */
    { 0x0c44, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/3/0 */
    { 0x0c4c, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/3/2 */
    { 0x0c54, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/3/4 */
    { 0x0c5c, 0x5ee1, 0xc4a0, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/3/6 */
    { 0x0c64, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/3/8 */
    { 0x0c6c, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/3/10 */
    { 0x0c74, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/3/12 */
    { 0x0c7c, 0x5ee1, 0x4420, RTFLOAT80U_INIT_C(1,0x50ee8b805,0), INT16_C(0) }, /* #66/3/14 */
    { 0x0245, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/0/0 */
    { 0x024d, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/0/2 */
    { 0x0255, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/0/4 */
    { 0x025d, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/0/6 */
    { 0x0265, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/0/8 */
    { 0x026d, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/0/10 */
    { 0x0275, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/0/12 */
    { 0x027d, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/0/14 */
    { 0x0645, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/1/0 */
    { 0x064d, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/1/2 */
    { 0x0655, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/1/4 */
    { 0x065d, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/1/6 */
    { 0x0665, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/1/8 */
    { 0x066d, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/1/10 */
    { 0x0675, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/1/12 */
    { 0x067d, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/1/14 */
    { 0x0a45, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/2/0 */
    { 0x0a4d, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/2/2 */
    { 0x0a55, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/2/4 */
    { 0x0a5d, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/2/6 */
    { 0x0a65, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/2/8 */
    { 0x0a6d, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/2/10 */
    { 0x0a75, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/2/12 */
    { 0x0a7d, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/2/14 */
    { 0x0e45, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/3/0 */
    { 0x0e4d, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/3/2 */
    { 0x0e55, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/3/4 */
    { 0x0e5d, 0x7338, 0xc1a0, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/3/6 */
    { 0x0e65, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/3/8 */
    { 0x0e6d, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/3/10 */
    { 0x0e75, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/3/12 */
    { 0x0e7d, 0x7338, 0x4120, RTFLOAT80U_INIT_C(0,0xf3e080077d798074,16397), INT16_C(31216) }, /* #67/3/14 */
    { 0x0241, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/0/0 */
    { 0x0249, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/0/2 */
    { 0x0251, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/0/4 */
    { 0x0259, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/0/6 */
    { 0x0261, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/0/8 */
    { 0x0269, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/0/10 */
    { 0x0271, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/0/12 */
    { 0x0279, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/0/14 */
    { 0x0641, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/1/0 */
    { 0x0649, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/1/2 */
    { 0x0651, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/1/4 */
    { 0x0659, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/1/6 */
    { 0x0661, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/1/8 */
    { 0x0669, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/1/10 */
    { 0x0671, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/1/12 */
    { 0x0679, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/1/14 */
    { 0x0a41, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/2/0 */
    { 0x0a49, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/2/2 */
    { 0x0a51, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/2/4 */
    { 0x0a59, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/2/6 */
    { 0x0a61, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/2/8 */
    { 0x0a69, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/2/10 */
    { 0x0a71, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/2/12 */
    { 0x0a79, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/2/14 */
    { 0x0e41, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/3/0 */
    { 0x0e49, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/3/2 */
    { 0x0e51, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/3/4 */
    { 0x0e59, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/3/6 */
    { 0x0e61, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/3/8 */
    { 0x0e69, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/3/10 */
    { 0x0e71, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/3/12 */
    { 0x0e79, 0x6f8c, 0x4501, RTFLOAT80U_INIT_C(1,0x43efdeabcc806ee2,32767), INT16_MIN }, /* #68/3/14 */
    { 0x0004, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/0/0 */
    { 0x000c, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/0/2 */
    { 0x0014, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/0/4 */
    { 0x001c, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/0/6 */
    { 0x0024, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/0/8 */
    { 0x002c, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/0/10 */
    { 0x0034, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/0/12 */
    { 0x003c, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/0/14 */
    { 0x0404, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/1/0 */
    { 0x040c, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/1/2 */
    { 0x0414, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/1/4 */
    { 0x041c, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/1/6 */
    { 0x0424, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/1/8 */
    { 0x042c, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/1/10 */
    { 0x0434, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/1/12 */
    { 0x043c, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/1/14 */
    { 0x0804, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/2/0 */
    { 0x080c, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/2/2 */
    { 0x0814, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/2/4 */
    { 0x081c, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/2/6 */
    { 0x0824, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/2/8 */
    { 0x082c, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/2/10 */
    { 0x0834, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/2/12 */
    { 0x083c, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/2/14 */
    { 0x0c04, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/3/0 */
    { 0x0c0c, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/3/2 */
    { 0x0c14, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/3/4 */
    { 0x0c1c, 0xce84, 0xc4a0, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/3/6 */
    { 0x0c24, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/3/8 */
    { 0x0c2c, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/3/10 */
    { 0x0c34, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/3/12 */
    { 0x0c3c, 0xce84, 0x4420, RTFLOAT80U_INIT_C(0,0xfb6d247b44cf4599,16383), INT16_C(1) }, /* #69/3/14 */
    { 0x0141, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/0/0 */
    { 0x0149, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/0/2 */
    { 0x0151, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/0/4 */
    { 0x0159, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/0/6 */
    { 0x0161, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/0/8 */
    { 0x0169, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/0/10 */
    { 0x0171, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/0/12 */
    { 0x0179, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/0/14 */
    { 0x0541, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/1/0 */
    { 0x0549, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/1/2 */
    { 0x0551, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/1/4 */
    { 0x0559, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/1/6 */
    { 0x0561, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/1/8 */
    { 0x0569, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/1/10 */
    { 0x0571, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/1/12 */
    { 0x0579, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/1/14 */
    { 0x0941, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/2/0 */
    { 0x0949, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/2/2 */
    { 0x0951, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/2/4 */
    { 0x0959, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/2/6 */
    { 0x0961, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/2/8 */
    { 0x0969, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/2/10 */
    { 0x0971, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/2/12 */
    { 0x0979, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/2/14 */
    { 0x0d41, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/3/0 */
    { 0x0d49, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/3/2 */
    { 0x0d51, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/3/4 */
    { 0x0d59, 0x42b1, 0xc0a0, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/3/6 */
    { 0x0d61, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/3/8 */
    { 0x0d69, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/3/10 */
    { 0x0d71, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/3/12 */
    { 0x0d79, 0x42b1, 0x4020, RTFLOAT80U_INIT_C(1,0xba3a4cc339b483d1,16383), INT16_C(-1) }, /* #70/3/14 */
    { 0x0040, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/0/0 */
    { 0x0048, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/0/2 */
    { 0x0050, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/0/4 */
    { 0x0058, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/0/6 */
    { 0x0060, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/0/8 */
    { 0x0068, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/0/10 */
    { 0x0070, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/0/12 */
    { 0x0078, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/0/14 */
    { 0x0440, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/1/0 */
    { 0x0448, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/1/2 */
    { 0x0450, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/1/4 */
    { 0x0458, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/1/6 */
    { 0x0460, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/1/8 */
    { 0x0468, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/1/10 */
    { 0x0470, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/1/12 */
    { 0x0478, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/1/14 */
    { 0x0840, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/2/0 */
    { 0x0848, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/2/2 */
    { 0x0850, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/2/4 */
    { 0x0858, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/2/6 */
    { 0x0860, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/2/8 */
    { 0x0868, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/2/10 */
    { 0x0870, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/2/12 */
    { 0x0878, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/2/14 */
    { 0x0c40, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/3/0 */
    { 0x0c48, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/3/2 */
    { 0x0c50, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/3/4 */
    { 0x0c58, 0x82bf, 0x80a0, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/3/6 */
    { 0x0c60, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/3/8 */
    { 0x0c68, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/3/10 */
    { 0x0c70, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/3/12 */
    { 0x0c78, 0x82bf, 0x0020, RTFLOAT80U_INIT_C(0,0xd03be5641ad2f699,0), INT16_C(0) }, /* #71/3/14 */
    { 0x0341, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/0/0 */
    { 0x0349, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/0/2 */
    { 0x0351, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/0/4 */
    { 0x0359, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/0/6 */
    { 0x0361, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/0/8 */
    { 0x0369, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/0/10 */
    { 0x0371, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/0/12 */
    { 0x0379, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/0/14 */
    { 0x0741, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/1/0 */
    { 0x0749, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/1/2 */
    { 0x0751, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/1/4 */
    { 0x0759, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/1/6 */
    { 0x0761, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/1/8 */
    { 0x0769, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/1/10 */
    { 0x0771, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/1/12 */
    { 0x0779, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/1/14 */
    { 0x0b41, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/2/0 */
    { 0x0b49, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/2/2 */
    { 0x0b51, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/2/4 */
    { 0x0b59, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/2/6 */
    { 0x0b61, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/2/8 */
    { 0x0b69, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/2/10 */
    { 0x0b71, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/2/12 */
    { 0x0b79, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/2/14 */
    { 0x0f41, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/3/0 */
    { 0x0f49, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/3/2 */
    { 0x0f51, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/3/4 */
    { 0x0f59, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/3/6 */
    { 0x0f61, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/3/8 */
    { 0x0f69, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/3/10 */
    { 0x0f71, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/3/12 */
    { 0x0f79, 0xf2ab, 0x4001, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), INT16_MIN }, /* #72/3/14 */
    { 0x0201, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/0/0 */
    { 0x0209, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/0/2 */
    { 0x0211, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/0/4 */
    { 0x0219, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/0/6 */
    { 0x0221, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/0/8 */
    { 0x0229, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/0/10 */
    { 0x0231, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/0/12 */
    { 0x0239, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/0/14 */
    { 0x0601, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/1/0 */
    { 0x0609, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/1/2 */
    { 0x0611, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/1/4 */
    { 0x0619, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/1/6 */
    { 0x0621, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/1/8 */
    { 0x0629, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/1/10 */
    { 0x0631, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/1/12 */
    { 0x0639, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/1/14 */
    { 0x0a01, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/2/0 */
    { 0x0a09, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/2/2 */
    { 0x0a11, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/2/4 */
    { 0x0a19, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/2/6 */
    { 0x0a21, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/2/8 */
    { 0x0a29, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/2/10 */
    { 0x0a31, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/2/12 */
    { 0x0a39, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/2/14 */
    { 0x0e01, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/3/0 */
    { 0x0e09, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/3/2 */
    { 0x0e11, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/3/4 */
    { 0x0e19, 0x0dc7, 0x85a0, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/3/6 */
    { 0x0e21, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/3/8 */
    { 0x0e29, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/3/10 */
    { 0x0e31, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/3/12 */
    { 0x0e39, 0x0dc7, 0x0520, RTFLOAT80U_INIT_C(0,0xfbc35c532d20ab22,16397), INT16_C(32225) }, /* #73/3/14 */
    { 0x0103, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/0/0 */
    { 0x010b, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/0/2 */
    { 0x0113, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/0/4 */
    { 0x011b, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/0/6 */
    { 0x0123, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/0/8 */
    { 0x012b, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/0/10 */
    { 0x0133, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/0/12 */
    { 0x013b, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/0/14 */
    { 0x0503, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/1/0 */
    { 0x050b, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/1/2 */
    { 0x0513, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/1/4 */
    { 0x051b, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/1/6 */
    { 0x0523, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/1/8 */
    { 0x052b, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/1/10 */
    { 0x0533, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/1/12 */
    { 0x053b, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/1/14 */
    { 0x0903, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/2/0 */
    { 0x090b, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/2/2 */
    { 0x0913, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/2/4 */
    { 0x091b, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/2/6 */
    { 0x0923, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/2/8 */
    { 0x092b, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/2/10 */
    { 0x0933, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/2/12 */
    { 0x093b, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/2/14 */
    { 0x0d03, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/3/0 */
    { 0x0d0b, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/3/2 */
    { 0x0d13, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/3/4 */
    { 0x0d1b, 0x1762, 0x85a0, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/3/6 */
    { 0x0d23, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/3/8 */
    { 0x0d2b, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/3/10 */
    { 0x0d33, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/3/12 */
    { 0x0d3b, 0x1762, 0x0520, RTFLOAT80U_INIT_C(1,0xd846be5817ee36a9,16383), INT16_C(-1) }, /* #74/3/14 */
    { 0x0303, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/0/0 */
    { 0x030b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/0/2 */
    { 0x0313, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/0/4 */
    { 0x031b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/0/6 */
    { 0x0323, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/0/8 */
    { 0x032b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/0/10 */
    { 0x0333, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/0/12 */
    { 0x033b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/0/14 */
    { 0x0703, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/1/0 */
    { 0x070b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/1/2 */
    { 0x0713, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/1/4 */
    { 0x071b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/1/6 */
    { 0x0723, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/1/8 */
    { 0x072b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/1/10 */
    { 0x0733, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/1/12 */
    { 0x073b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/1/14 */
    { 0x0b03, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/2/0 */
    { 0x0b0b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/2/2 */
    { 0x0b13, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/2/4 */
    { 0x0b1b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/2/6 */
    { 0x0b23, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/2/8 */
    { 0x0b2b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/2/10 */
    { 0x0b33, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/2/12 */
    { 0x0b3b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/2/14 */
    { 0x0f03, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/3/0 */
    { 0x0f0b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/3/2 */
    { 0x0f13, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/3/4 */
    { 0x0f1b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/3/6 */
    { 0x0f23, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/3/8 */
    { 0x0f2b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/3/10 */
    { 0x0f33, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/3/12 */
    { 0x0f3b, 0x451c, 0x4501, RTFLOAT80U_INIT_C(1,0x1ebfd896e3dd6f72,32767), INT16_MIN }, /* #75/3/14 */
    { 0x0341, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/0/0 */
    { 0x0349, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/0/2 */
    { 0x0351, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/0/4 */
    { 0x0359, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/0/6 */
    { 0x0361, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/0/8 */
    { 0x0369, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/0/10 */
    { 0x0371, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/0/12 */
    { 0x0379, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/0/14 */
    { 0x0741, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/1/0 */
    { 0x0749, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/1/2 */
    { 0x0751, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/1/4 */
    { 0x0759, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/1/6 */
    { 0x0761, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/1/8 */
    { 0x0769, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/1/10 */
    { 0x0771, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/1/12 */
    { 0x0779, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/1/14 */
    { 0x0b41, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/2/0 */
    { 0x0b49, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/2/2 */
    { 0x0b51, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/2/4 */
    { 0x0b59, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/2/6 */
    { 0x0b61, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/2/8 */
    { 0x0b69, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/2/10 */
    { 0x0b71, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/2/12 */
    { 0x0b79, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/2/14 */
    { 0x0f41, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/3/0 */
    { 0x0f49, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/3/2 */
    { 0x0f51, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/3/4 */
    { 0x0f59, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/3/6 */
    { 0x0f61, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/3/8 */
    { 0x0f69, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/3/10 */
    { 0x0f71, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/3/12 */
    { 0x0f79, 0x8309, 0x0101, RTFLOAT80U_INIT_C(1,0x3493fb81006fee83,6904), INT16_MIN }, /* #76/3/14 */
    { 0x0146, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/0/0 */
    { 0x014e, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/0/2 */
    { 0x0156, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/0/4 */
    { 0x015e, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/0/6 */
    { 0x0166, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/0/8 */
    { 0x016e, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/0/10 */
    { 0x0176, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/0/12 */
    { 0x017e, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/0/14 */
    { 0x0546, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/1/0 */
    { 0x054e, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/1/2 */
    { 0x0556, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/1/4 */
    { 0x055e, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/1/6 */
    { 0x0566, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/1/8 */
    { 0x056e, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/1/10 */
    { 0x0576, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/1/12 */
    { 0x057e, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/1/14 */
    { 0x0946, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/2/0 */
    { 0x094e, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/2/2 */
    { 0x0956, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/2/4 */
    { 0x095e, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/2/6 */
    { 0x0966, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/2/8 */
    { 0x096e, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/2/10 */
    { 0x0976, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/2/12 */
    { 0x097e, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/2/14 */
    { 0x0d46, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/3/0 */
    { 0x0d4e, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/3/2 */
    { 0x0d56, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/3/4 */
    { 0x0d5e, 0xd3e7, 0xc1a0, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/3/6 */
    { 0x0d66, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/3/8 */
    { 0x0d6e, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/3/10 */
    { 0x0d76, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/3/12 */
    { 0x0d7e, 0xd3e7, 0x4120, RTFLOAT80U_INIT_C(0,0xa75ec2827254f3fe,6610), INT16_C(0) }, /* #77/3/14 */
    { 0x0304, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/0/0 */
    { 0x030c, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/0/2 */
    { 0x0314, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/0/4 */
    { 0x031c, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/0/6 */
    { 0x0324, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/0/8 */
    { 0x032c, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/0/10 */
    { 0x0334, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/0/12 */
    { 0x033c, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/0/14 */
    { 0x0704, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/1/0 */
    { 0x070c, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/1/2 */
    { 0x0714, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/1/4 */
    { 0x071c, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/1/6 */
    { 0x0724, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/1/8 */
    { 0x072c, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/1/10 */
    { 0x0734, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/1/12 */
    { 0x073c, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/1/14 */
    { 0x0b04, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/2/0 */
    { 0x0b0c, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/2/2 */
    { 0x0b14, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/2/4 */
    { 0x0b1c, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/2/6 */
    { 0x0b24, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/2/8 */
    { 0x0b2c, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/2/10 */
    { 0x0b34, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/2/12 */
    { 0x0b3c, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/2/14 */
    { 0x0f04, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/3/0 */
    { 0x0f0c, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/3/2 */
    { 0x0f14, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/3/4 */
    { 0x0f1c, 0x2749, 0x85a0, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/3/6 */
    { 0x0f24, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/3/8 */
    { 0x0f2c, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/3/10 */
    { 0x0f34, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/3/12 */
    { 0x0f3c, 0x2749, 0x0520, RTFLOAT80U_INIT_C(0,0x28ac769,0), INT16_C(0) }, /* #78/3/14 */
    { 0x0046, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/0/0 */
    { 0x004e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/0/2 */
    { 0x0056, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/0/4 */
    { 0x005e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/0/6 */
    { 0x0066, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/0/8 */
    { 0x006e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/0/10 */
    { 0x0076, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/0/12 */
    { 0x007e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/0/14 */
    { 0x0446, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/1/0 */
    { 0x044e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/1/2 */
    { 0x0456, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/1/4 */
    { 0x045e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/1/6 */
    { 0x0466, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/1/8 */
    { 0x046e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/1/10 */
    { 0x0476, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/1/12 */
    { 0x047e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/1/14 */
    { 0x0846, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/2/0 */
    { 0x084e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/2/2 */
    { 0x0856, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/2/4 */
    { 0x085e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/2/6 */
    { 0x0866, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/2/8 */
    { 0x086e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/2/10 */
    { 0x0876, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/2/12 */
    { 0x087e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/2/14 */
    { 0x0c46, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/3/0 */
    { 0x0c4e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/3/2 */
    { 0x0c56, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/3/4 */
    { 0x0c5e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/3/6 */
    { 0x0c66, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/3/8 */
    { 0x0c6e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/3/10 */
    { 0x0c76, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/3/12 */
    { 0x0c7e, 0x16d1, 0xbc81, RTFLOAT80U_INIT_C(0,0x78b63dfaa491332a,9728), INT16_C(-3) }, /* #79/3/14 */
    { 0x0244, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/0/0 */
    { 0x024c, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/0/2 */
    { 0x0254, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/0/4 */
    { 0x025c, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/0/6 */
    { 0x0264, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/0/8 */
    { 0x026c, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/0/10 */
    { 0x0274, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/0/12 */
    { 0x027c, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/0/14 */
    { 0x0644, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/1/0 */
    { 0x064c, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/1/2 */
    { 0x0654, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/1/4 */
    { 0x065c, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/1/6 */
    { 0x0664, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/1/8 */
    { 0x066c, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/1/10 */
    { 0x0674, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/1/12 */
    { 0x067c, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/1/14 */
    { 0x0a44, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/2/0 */
    { 0x0a4c, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/2/2 */
    { 0x0a54, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/2/4 */
    { 0x0a5c, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/2/6 */
    { 0x0a64, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/2/8 */
    { 0x0a6c, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/2/10 */
    { 0x0a74, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/2/12 */
    { 0x0a7c, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/2/14 */
    { 0x0e44, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/3/0 */
    { 0x0e4c, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/3/2 */
    { 0x0e54, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/3/4 */
    { 0x0e5c, 0x3446, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/3/6 */
    { 0x0e64, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/3/8 */
    { 0x0e6c, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/3/10 */
    { 0x0e74, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/3/12 */
    { 0x0e7c, 0x3446, 0x0420, RTFLOAT80U_INIT_C(1,0x8000000000000025,0), INT16_C(0) }, /* #80/3/14 */
    { 0x0206, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/0/0 */
    { 0x020e, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/0/2 */
    { 0x0216, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/0/4 */
    { 0x021e, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/0/6 */
    { 0x0226, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/0/8 */
    { 0x022e, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/0/10 */
    { 0x0236, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/0/12 */
    { 0x023e, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/0/14 */
    { 0x0606, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/1/0 */
    { 0x060e, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/1/2 */
    { 0x0616, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/1/4 */
    { 0x061e, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/1/6 */
    { 0x0626, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/1/8 */
    { 0x062e, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/1/10 */
    { 0x0636, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/1/12 */
    { 0x063e, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/1/14 */
    { 0x0a06, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/2/0 */
    { 0x0a0e, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/2/2 */
    { 0x0a16, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/2/4 */
    { 0x0a1e, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/2/6 */
    { 0x0a26, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/2/8 */
    { 0x0a2e, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/2/10 */
    { 0x0a36, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/2/12 */
    { 0x0a3e, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/2/14 */
    { 0x0e06, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/3/0 */
    { 0x0e0e, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/3/2 */
    { 0x0e16, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/3/4 */
    { 0x0e1e, 0xa75f, 0x85a0, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/3/6 */
    { 0x0e26, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/3/8 */
    { 0x0e2e, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/3/10 */
    { 0x0e36, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/3/12 */
    { 0x0e3e, 0xa75f, 0x0520, RTFLOAT80U_INIT_C(0,0x2d44d69bcc84,0), INT16_C(0) }, /* #81/3/14 */
    { 0x0340, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/0/0 */
    { 0x0348, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/0/2 */
    { 0x0350, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/0/4 */
    { 0x0358, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/0/6 */
    { 0x0360, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/0/8 */
    { 0x0368, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/0/10 */
    { 0x0370, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/0/12 */
    { 0x0378, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/0/14 */
    { 0x0740, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/1/0 */
    { 0x0748, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/1/2 */
    { 0x0750, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/1/4 */
    { 0x0758, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/1/6 */
    { 0x0760, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/1/8 */
    { 0x0768, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/1/10 */
    { 0x0770, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/1/12 */
    { 0x0778, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/1/14 */
    { 0x0b40, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/2/0 */
    { 0x0b48, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/2/2 */
    { 0x0b50, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/2/4 */
    { 0x0b58, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/2/6 */
    { 0x0b60, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/2/8 */
    { 0x0b68, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/2/10 */
    { 0x0b70, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/2/12 */
    { 0x0b78, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/2/14 */
    { 0x0f40, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/3/0 */
    { 0x0f48, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/3/2 */
    { 0x0f50, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/3/4 */
    { 0x0f58, 0xd2c7, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/3/6 */
    { 0x0f60, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/3/8 */
    { 0x0f68, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/3/10 */
    { 0x0f70, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/3/12 */
    { 0x0f78, 0xd2c7, 0x4020, RTFLOAT80U_INIT_C(1,0x8cdc7bc0e9c040c5,8620), INT16_C(0) }, /* #82/3/14 */
    { 0x0103, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/0/0 */
    { 0x010b, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/0/2 */
    { 0x0113, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/0/4 */
    { 0x011b, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/0/6 */
    { 0x0123, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/0/8 */
    { 0x012b, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/0/10 */
    { 0x0133, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/0/12 */
    { 0x013b, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/0/14 */
    { 0x0503, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/1/0 */
    { 0x050b, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/1/2 */
    { 0x0513, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/1/4 */
    { 0x051b, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/1/6 */
    { 0x0523, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/1/8 */
    { 0x052b, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/1/10 */
    { 0x0533, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/1/12 */
    { 0x053b, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/1/14 */
    { 0x0903, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/2/0 */
    { 0x090b, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/2/2 */
    { 0x0913, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/2/4 */
    { 0x091b, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/2/6 */
    { 0x0923, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/2/8 */
    { 0x092b, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/2/10 */
    { 0x0933, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/2/12 */
    { 0x093b, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/2/14 */
    { 0x0d03, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/3/0 */
    { 0x0d0b, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/3/2 */
    { 0x0d13, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/3/4 */
    { 0x0d1b, 0xeca8, 0xc4a0, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/3/6 */
    { 0x0d23, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/3/8 */
    { 0x0d2b, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/3/10 */
    { 0x0d33, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/3/12 */
    { 0x0d3b, 0xeca8, 0x4420, RTFLOAT80U_INIT_C(1,0xc4f686c7fd2013d6,5680), INT16_C(0) }, /* #83/3/14 */
    { 0x0141, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/0/0 */
    { 0x0149, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/0/2 */
    { 0x0151, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/0/4 */
    { 0x0159, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/0/6 */
    { 0x0161, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/0/8 */
    { 0x0169, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/0/10 */
    { 0x0171, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/0/12 */
    { 0x0179, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/0/14 */
    { 0x0541, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/1/0 */
    { 0x0549, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/1/2 */
    { 0x0551, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/1/4 */
    { 0x0559, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/1/6 */
    { 0x0561, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/1/8 */
    { 0x0569, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/1/10 */
    { 0x0571, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/1/12 */
    { 0x0579, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/1/14 */
    { 0x0941, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/2/0 */
    { 0x0949, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/2/2 */
    { 0x0951, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/2/4 */
    { 0x0959, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/2/6 */
    { 0x0961, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/2/8 */
    { 0x0969, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/2/10 */
    { 0x0971, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/2/12 */
    { 0x0979, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/2/14 */
    { 0x0d41, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/3/0 */
    { 0x0d49, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/3/2 */
    { 0x0d51, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/3/4 */
    { 0x0d59, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/3/6 */
    { 0x0d61, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/3/8 */
    { 0x0d69, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/3/10 */
    { 0x0d71, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/3/12 */
    { 0x0d79, 0xb0e0, 0x0001, RTFLOAT80U_INIT_C(1,0x3de5a6d0cc5d72e6,16751), INT16_MIN }, /* #84/3/14 */
    { 0x0146, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/0/0 */
    { 0x014e, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/0/2 */
    { 0x0156, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/0/4 */
    { 0x015e, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/0/6 */
    { 0x0166, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/0/8 */
    { 0x016e, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/0/10 */
    { 0x0176, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/0/12 */
    { 0x017e, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/0/14 */
    { 0x0546, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/1/0 */
    { 0x054e, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/1/2 */
    { 0x0556, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/1/4 */
    { 0x055e, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/1/6 */
    { 0x0566, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/1/8 */
    { 0x056e, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/1/10 */
    { 0x0576, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/1/12 */
    { 0x057e, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/1/14 */
    { 0x0946, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/2/0 */
    { 0x094e, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/2/2 */
    { 0x0956, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/2/4 */
    { 0x095e, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/2/6 */
    { 0x0966, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/2/8 */
    { 0x096e, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/2/10 */
    { 0x0976, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/2/12 */
    { 0x097e, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/2/14 */
    { 0x0d46, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/3/0 */
    { 0x0d4e, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/3/2 */
    { 0x0d56, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/3/4 */
    { 0x0d5e, 0xba56, 0x80a0, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/3/6 */
    { 0x0d66, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/3/8 */
    { 0x0d6e, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/3/10 */
    { 0x0d76, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/3/12 */
    { 0x0d7e, 0xba56, 0x0020, RTFLOAT80U_INIT_C(1,0xc,0), INT16_C(0) }, /* #85/3/14 */
    { 0x0141, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/0/0 */
    { 0x0149, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/0/2 */
    { 0x0151, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/0/4 */
    { 0x0159, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/0/6 */
    { 0x0161, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/0/8 */
    { 0x0169, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/0/10 */
    { 0x0171, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/0/12 */
    { 0x0179, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/0/14 */
    { 0x0541, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/1/0 */
    { 0x0549, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/1/2 */
    { 0x0551, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/1/4 */
    { 0x0559, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/1/6 */
    { 0x0561, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/1/8 */
    { 0x0569, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/1/10 */
    { 0x0571, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/1/12 */
    { 0x0579, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/1/14 */
    { 0x0941, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/2/0 */
    { 0x0949, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/2/2 */
    { 0x0951, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/2/4 */
    { 0x0959, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/2/6 */
    { 0x0961, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/2/8 */
    { 0x0969, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/2/10 */
    { 0x0971, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/2/12 */
    { 0x0979, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/2/14 */
    { 0x0d41, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/3/0 */
    { 0x0d49, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/3/2 */
    { 0x0d51, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/3/4 */
    { 0x0d59, 0x3df7, 0x85a0, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/3/6 */
    { 0x0d61, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/3/8 */
    { 0x0d69, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/3/10 */
    { 0x0d71, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/3/12 */
    { 0x0d79, 0x3df7, 0x0520, RTFLOAT80U_INIT_C(0,0xad3fa0b91903629e,16383), INT16_C(1) }, /* #86/3/14 */
    { 0x0142, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/0/0 */
    { 0x014a, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/0/2 */
    { 0x0152, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/0/4 */
    { 0x015a, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/0/6 */
    { 0x0162, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/0/8 */
    { 0x016a, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/0/10 */
    { 0x0172, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/0/12 */
    { 0x017a, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/0/14 */
    { 0x0542, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/1/0 */
    { 0x054a, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/1/2 */
    { 0x0552, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/1/4 */
    { 0x055a, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/1/6 */
    { 0x0562, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/1/8 */
    { 0x056a, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/1/10 */
    { 0x0572, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/1/12 */
    { 0x057a, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/1/14 */
    { 0x0942, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/2/0 */
    { 0x094a, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/2/2 */
    { 0x0952, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/2/4 */
    { 0x095a, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/2/6 */
    { 0x0962, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/2/8 */
    { 0x096a, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/2/10 */
    { 0x0972, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/2/12 */
    { 0x097a, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/2/14 */
    { 0x0d42, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/3/0 */
    { 0x0d4a, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/3/2 */
    { 0x0d52, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/3/4 */
    { 0x0d5a, 0x6589, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/3/6 */
    { 0x0d62, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/3/8 */
    { 0x0d6a, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/3/10 */
    { 0x0d72, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/3/12 */
    { 0x0d7a, 0x6589, 0x4520, RTFLOAT80U_INIT_C(1,0x8306a6fb38be88ca,0), INT16_C(0) }, /* #87/3/14 */
    { 0x0201, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/0/0 */
    { 0x0209, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/0/2 */
    { 0x0211, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/0/4 */
    { 0x0219, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/0/6 */
    { 0x0221, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/0/8 */
    { 0x0229, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/0/10 */
    { 0x0231, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/0/12 */
    { 0x0239, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/0/14 */
    { 0x0601, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/1/0 */
    { 0x0609, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/1/2 */
    { 0x0611, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/1/4 */
    { 0x0619, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/1/6 */
    { 0x0621, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/1/8 */
    { 0x0629, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/1/10 */
    { 0x0631, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/1/12 */
    { 0x0639, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/1/14 */
    { 0x0a01, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/2/0 */
    { 0x0a09, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/2/2 */
    { 0x0a11, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/2/4 */
    { 0x0a19, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/2/6 */
    { 0x0a21, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/2/8 */
    { 0x0a29, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/2/10 */
    { 0x0a31, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/2/12 */
    { 0x0a39, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/2/14 */
    { 0x0e01, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/3/0 */
    { 0x0e09, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/3/2 */
    { 0x0e11, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/3/4 */
    { 0x0e19, 0x6043, 0xc0a0, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/3/6 */
    { 0x0e21, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/3/8 */
    { 0x0e29, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/3/10 */
    { 0x0e31, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/3/12 */
    { 0x0e39, 0x6043, 0x4020, RTFLOAT80U_INIT_C(0,0xf426916e0800ea8c,16383), INT16_C(1) }, /* #88/3/14 */
    { 0x0345, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/0/0 */
    { 0x034d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/0/2 */
    { 0x0355, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/0/4 */
    { 0x035d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/0/6 */
    { 0x0365, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/0/8 */
    { 0x036d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/0/10 */
    { 0x0375, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/0/12 */
    { 0x037d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/0/14 */
    { 0x0745, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/1/0 */
    { 0x074d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/1/2 */
    { 0x0755, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/1/4 */
    { 0x075d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/1/6 */
    { 0x0765, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/1/8 */
    { 0x076d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/1/10 */
    { 0x0775, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/1/12 */
    { 0x077d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/1/14 */
    { 0x0b45, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/2/0 */
    { 0x0b4d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/2/2 */
    { 0x0b55, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/2/4 */
    { 0x0b5d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/2/6 */
    { 0x0b65, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/2/8 */
    { 0x0b6d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/2/10 */
    { 0x0b75, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/2/12 */
    { 0x0b7d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/2/14 */
    { 0x0f45, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/3/0 */
    { 0x0f4d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/3/2 */
    { 0x0f55, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/3/4 */
    { 0x0f5d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/3/6 */
    { 0x0f65, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/3/8 */
    { 0x0f6d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/3/10 */
    { 0x0f75, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/3/12 */
    { 0x0f7d, 0xc785, 0x4501, RTFLOAT80U_INIT_C(1,0x8000000bff7e42c3,32767), INT16_MIN }, /* #89/3/14 */
    { 0x0303, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/0/0 */
    { 0x030b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/0/2 */
    { 0x0313, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/0/4 */
    { 0x031b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/0/6 */
    { 0x0323, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/0/8 */
    { 0x032b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/0/10 */
    { 0x0333, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/0/12 */
    { 0x033b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/0/14 */
    { 0x0703, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/1/0 */
    { 0x070b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/1/2 */
    { 0x0713, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/1/4 */
    { 0x071b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/1/6 */
    { 0x0723, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/1/8 */
    { 0x072b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/1/10 */
    { 0x0733, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/1/12 */
    { 0x073b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/1/14 */
    { 0x0b03, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/2/0 */
    { 0x0b0b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/2/2 */
    { 0x0b13, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/2/4 */
    { 0x0b1b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/2/6 */
    { 0x0b23, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/2/8 */
    { 0x0b2b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/2/10 */
    { 0x0b33, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/2/12 */
    { 0x0b3b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/2/14 */
    { 0x0f03, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/3/0 */
    { 0x0f0b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/3/2 */
    { 0x0f13, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/3/4 */
    { 0x0f1b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/3/6 */
    { 0x0f23, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/3/8 */
    { 0x0f2b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/3/10 */
    { 0x0f33, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/3/12 */
    { 0x0f3b, 0x269c, 0x0401, RTFLOAT80U_INIT_C(1,0x6480b09f973eee15,10609), INT16_MIN }, /* #90/3/14 */
    { 0x0005, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/0/0 */
    { 0x000d, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/0/2 */
    { 0x0015, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/0/4 */
    { 0x001d, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/0/6 */
    { 0x0025, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/0/8 */
    { 0x002d, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/0/10 */
    { 0x0035, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/0/12 */
    { 0x003d, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/0/14 */
    { 0x0405, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/1/0 */
    { 0x040d, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/1/2 */
    { 0x0415, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/1/4 */
    { 0x041d, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/1/6 */
    { 0x0425, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/1/8 */
    { 0x042d, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/1/10 */
    { 0x0435, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/1/12 */
    { 0x043d, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/1/14 */
    { 0x0805, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/2/0 */
    { 0x080d, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/2/2 */
    { 0x0815, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/2/4 */
    { 0x081d, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/2/6 */
    { 0x0825, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/2/8 */
    { 0x082d, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/2/10 */
    { 0x0835, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/2/12 */
    { 0x083d, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/2/14 */
    { 0x0c05, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/3/0 */
    { 0x0c0d, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/3/2 */
    { 0x0c15, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/3/4 */
    { 0x0c1d, 0x5f8f, 0xc5a0, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/3/6 */
    { 0x0c25, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/3/8 */
    { 0x0c2d, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/3/10 */
    { 0x0c35, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/3/12 */
    { 0x0c3d, 0x5f8f, 0x4520, RTFLOAT80U_INIT_C(1,0xeaa97d47657ce52b,16383), INT16_C(-1) }, /* #91/3/14 */
    { 0x0203, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/0/0 */
    { 0x020b, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/0/2 */
    { 0x0213, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/0/4 */
    { 0x021b, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/0/6 */
    { 0x0223, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/0/8 */
    { 0x022b, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/0/10 */
    { 0x0233, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/0/12 */
    { 0x023b, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/0/14 */
    { 0x0603, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/1/0 */
    { 0x060b, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/1/2 */
    { 0x0613, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/1/4 */
    { 0x061b, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/1/6 */
    { 0x0623, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/1/8 */
    { 0x062b, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/1/10 */
    { 0x0633, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/1/12 */
    { 0x063b, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/1/14 */
    { 0x0a03, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/2/0 */
    { 0x0a0b, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/2/2 */
    { 0x0a13, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/2/4 */
    { 0x0a1b, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/2/6 */
    { 0x0a23, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/2/8 */
    { 0x0a2b, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/2/10 */
    { 0x0a33, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/2/12 */
    { 0x0a3b, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/2/14 */
    { 0x0e03, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/3/0 */
    { 0x0e0b, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/3/2 */
    { 0x0e13, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/3/4 */
    { 0x0e1b, 0xfba7, 0xc1a0, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/3/6 */
    { 0x0e23, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/3/8 */
    { 0x0e2b, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/3/10 */
    { 0x0e33, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/3/12 */
    { 0x0e3b, 0xfba7, 0x4120, RTFLOAT80U_INIT_C(0,0x2,0), INT16_C(0) }, /* #92/3/14 */
    { 0x0342, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/0/0 */
    { 0x034a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/0/2 */
    { 0x0352, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/0/4 */
    { 0x035a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/0/6 */
    { 0x0362, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/0/8 */
    { 0x036a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/0/10 */
    { 0x0372, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/0/12 */
    { 0x037a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/0/14 */
    { 0x0742, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/1/0 */
    { 0x074a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/1/2 */
    { 0x0752, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/1/4 */
    { 0x075a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/1/6 */
    { 0x0762, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/1/8 */
    { 0x076a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/1/10 */
    { 0x0772, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/1/12 */
    { 0x077a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/1/14 */
    { 0x0b42, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/2/0 */
    { 0x0b4a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/2/2 */
    { 0x0b52, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/2/4 */
    { 0x0b5a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/2/6 */
    { 0x0b62, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/2/8 */
    { 0x0b6a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/2/10 */
    { 0x0b72, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/2/12 */
    { 0x0b7a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/2/14 */
    { 0x0f42, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/3/0 */
    { 0x0f4a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/3/2 */
    { 0x0f52, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/3/4 */
    { 0x0f5a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/3/6 */
    { 0x0f62, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/3/8 */
    { 0x0f6a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/3/10 */
    { 0x0f72, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/3/12 */
    { 0x0f7a, 0xf41a, 0xfc81, RTFLOAT80U_INIT_C(1,0xbbde1e676300978,27107), INT16_C(-3) }, /* #93/3/14 */
    { 0x0103, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/0/0 */
    { 0x010b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/0/2 */
    { 0x0113, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/0/4 */
    { 0x011b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/0/6 */
    { 0x0123, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/0/8 */
    { 0x012b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/0/10 */
    { 0x0133, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/0/12 */
    { 0x013b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/0/14 */
    { 0x0503, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/1/0 */
    { 0x050b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/1/2 */
    { 0x0513, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/1/4 */
    { 0x051b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/1/6 */
    { 0x0523, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/1/8 */
    { 0x052b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/1/10 */
    { 0x0533, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/1/12 */
    { 0x053b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/1/14 */
    { 0x0903, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/2/0 */
    { 0x090b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/2/2 */
    { 0x0913, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/2/4 */
    { 0x091b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/2/6 */
    { 0x0923, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/2/8 */
    { 0x092b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/2/10 */
    { 0x0933, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/2/12 */
    { 0x093b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/2/14 */
    { 0x0d03, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/3/0 */
    { 0x0d0b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/3/2 */
    { 0x0d13, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/3/4 */
    { 0x0d1b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/3/6 */
    { 0x0d23, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/3/8 */
    { 0x0d2b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/3/10 */
    { 0x0d33, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/3/12 */
    { 0x0d3b, 0x03cc, 0x0101, RTFLOAT80U_INIT_C(0,0xa2afef76f0486c15,24216), INT16_MIN }, /* #94/3/14 */
    { 0x0343, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/0/0 */
    { 0x034b, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/0/2 */
    { 0x0353, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/0/4 */
    { 0x035b, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/0/6 */
    { 0x0363, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/0/8 */
    { 0x036b, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/0/10 */
    { 0x0373, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/0/12 */
    { 0x037b, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/0/14 */
    { 0x0743, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/1/0 */
    { 0x074b, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/1/2 */
    { 0x0753, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/1/4 */
    { 0x075b, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/1/6 */
    { 0x0763, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/1/8 */
    { 0x076b, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/1/10 */
    { 0x0773, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/1/12 */
    { 0x077b, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/1/14 */
    { 0x0b43, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/2/0 */
    { 0x0b4b, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/2/2 */
    { 0x0b53, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/2/4 */
    { 0x0b5b, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/2/6 */
    { 0x0b63, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/2/8 */
    { 0x0b6b, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/2/10 */
    { 0x0b73, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/2/12 */
    { 0x0b7b, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/2/14 */
    { 0x0f43, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/3/0 */
    { 0x0f4b, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/3/2 */
    { 0x0f53, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/3/4 */
    { 0x0f5b, 0x2007, 0x80a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/3/6 */
    { 0x0f63, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/3/8 */
    { 0x0f6b, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/3/10 */
    { 0x0f73, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/3/12 */
    { 0x0f7b, 0x2007, 0x0020, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,16383), INT16_C(1) }, /* #95/3/14 */
    { 0x0342, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/0 */
    { 0x034a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/2 */
    { 0x0352, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/4 */
    { 0x035a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/6 */
    { 0x0362, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/8 */
    { 0x036a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/10 */
    { 0x0372, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/12 */
    { 0x037a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/0/14 */
    { 0x0742, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/0 */
    { 0x074a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/2 */
    { 0x0752, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/4 */
    { 0x075a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/6 */
    { 0x0762, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/8 */
    { 0x076a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/10 */
    { 0x0772, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/12 */
    { 0x077a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/1/14 */
    { 0x0b42, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/0 */
    { 0x0b4a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/2 */
    { 0x0b52, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/4 */
    { 0x0b5a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/6 */
    { 0x0b62, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/8 */
    { 0x0b6a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/10 */
    { 0x0b72, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/12 */
    { 0x0b7a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/2/14 */
    { 0x0f42, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/0 */
    { 0x0f4a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/2 */
    { 0x0f52, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/4 */
    { 0x0f5a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/6 */
    { 0x0f62, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/8 */
    { 0x0f6a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/10 */
    { 0x0f72, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/12 */
    { 0x0f7a, 0x039e, 0x0100, RTFLOAT80U_INIT_C(0,0x8000000000000000,16396), INT16_C(8192) }, /* #96/3/14 */
    { 0x0203, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/0 */
    { 0x020b, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/2 */
    { 0x0213, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/4 */
    { 0x021b, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/6 */
    { 0x0223, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/8 */
    { 0x022b, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/10 */
    { 0x0233, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/12 */
    { 0x023b, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/0/14 */
    { 0x0603, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/0 */
    { 0x060b, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/2 */
    { 0x0613, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/4 */
    { 0x061b, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/6 */
    { 0x0623, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/8 */
    { 0x062b, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/10 */
    { 0x0633, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/12 */
    { 0x063b, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/1/14 */
    { 0x0a03, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/0 */
    { 0x0a0b, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/2 */
    { 0x0a13, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/4 */
    { 0x0a1b, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/6 */
    { 0x0a23, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/8 */
    { 0x0a2b, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/10 */
    { 0x0a33, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/12 */
    { 0x0a3b, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/2/14 */
    { 0x0e03, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/0 */
    { 0x0e0b, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/2 */
    { 0x0e13, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/4 */
    { 0x0e1b, 0xb4f7, 0x84a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/6 */
    { 0x0e23, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/8 */
    { 0x0e2b, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/10 */
    { 0x0e33, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/12 */
    { 0x0e3b, 0xb4f7, 0x0420, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16396), INT16_C(16383) }, /* #97/3/14 */
    { 0x0101, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/0 */
    { 0x0109, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/2 */
    { 0x0111, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/4 */
    { 0x0119, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/6 */
    { 0x0121, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/8 */
    { 0x0129, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/10 */
    { 0x0131, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/12 */
    { 0x0139, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/0/14 */
    { 0x0501, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/0 */
    { 0x0509, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/2 */
    { 0x0511, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/4 */
    { 0x0519, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/6 */
    { 0x0521, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/8 */
    { 0x0529, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/10 */
    { 0x0531, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/12 */
    { 0x0539, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/1/14 */
    { 0x0901, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/0 */
    { 0x0909, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/2 */
    { 0x0911, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/4 */
    { 0x0919, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/6 */
    { 0x0921, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/8 */
    { 0x0929, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/10 */
    { 0x0931, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/12 */
    { 0x0939, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/2/14 */
    { 0x0d01, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/0 */
    { 0x0d09, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/2 */
    { 0x0d11, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/4 */
    { 0x0d19, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/6 */
    { 0x0d21, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/8 */
    { 0x0d29, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/10 */
    { 0x0d31, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/12 */
    { 0x0d39, 0xce3d, 0x4400, RTFLOAT80U_INIT_C(0,0x8000000000000000,16397), INT16_C(16384) }, /* #98/3/14 */
    { 0x0346, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/0 */
    { 0x034e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/2 */
    { 0x0356, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/4 */
    { 0x035e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/6 */
    { 0x0366, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/8 */
    { 0x036e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/10 */
    { 0x0376, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/12 */
    { 0x037e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/0/14 */
    { 0x0746, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/0 */
    { 0x074e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/2 */
    { 0x0756, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/4 */
    { 0x075e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/6 */
    { 0x0766, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/8 */
    { 0x076e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/10 */
    { 0x0776, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/12 */
    { 0x077e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/1/14 */
    { 0x0b46, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/0 */
    { 0x0b4e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/2 */
    { 0x0b56, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/4 */
    { 0x0b5e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/6 */
    { 0x0b66, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/8 */
    { 0x0b6e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/10 */
    { 0x0b76, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/12 */
    { 0x0b7e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/2/14 */
    { 0x0f46, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/0 */
    { 0x0f4e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/2 */
    { 0x0f56, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/4 */
    { 0x0f5e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/6 */
    { 0x0f66, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/8 */
    { 0x0f6e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/10 */
    { 0x0f76, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/12 */
    { 0x0f7e, 0xa984, 0x0100, RTFLOAT80U_INIT_C(1,0x8000000000000000,16397), INT16_C(-16384) }, /* #99/3/14 */
    { 0x0147, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/0 */
    { 0x014f, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/2 */
    { 0x0157, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/4 */
    { 0x015f, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/6 */
    { 0x0167, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/8 */
    { 0x016f, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/10 */
    { 0x0177, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/12 */
    { 0x017f, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/0/14 */
    { 0x0547, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/0 */
    { 0x054f, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/2 */
    { 0x0557, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/4 */
    { 0x055f, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/6 */
    { 0x0567, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/8 */
    { 0x056f, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/10 */
    { 0x0577, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/12 */
    { 0x057f, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/1/14 */
    { 0x0947, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/0 */
    { 0x094f, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/2 */
    { 0x0957, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/4 */
    { 0x095f, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/6 */
    { 0x0967, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/8 */
    { 0x096f, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/10 */
    { 0x0977, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/12 */
    { 0x097f, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/2/14 */
    { 0x0d47, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/0 */
    { 0x0d4f, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/2 */
    { 0x0d57, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/4 */
    { 0x0d5f, 0xa6a6, 0x84a0, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/6 */
    { 0x0d67, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/8 */
    { 0x0d6f, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/10 */
    { 0x0d77, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/12 */
    { 0x0d7f, 0xa6a6, 0x0420, RTFLOAT80U_INIT_C(0,0x8000080000000000,16397), INT16_C(16384) }, /* #100/3/14 */
    { 0x0346, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/0 */
    { 0x034e, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/2 */
    { 0x0356, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/4 */
    { 0x035e, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/6 */
    { 0x0366, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/8 */
    { 0x036e, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/10 */
    { 0x0376, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/12 */
    { 0x037e, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/0/14 */
    { 0x0746, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/0 */
    { 0x074e, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/2 */
    { 0x0756, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/4 */
    { 0x075e, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/6 */
    { 0x0766, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/8 */
    { 0x076e, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/10 */
    { 0x0776, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/12 */
    { 0x077e, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/1/14 */
    { 0x0b46, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/0 */
    { 0x0b4e, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/2 */
    { 0x0b56, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/4 */
    { 0x0b5e, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/6 */
    { 0x0b66, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/8 */
    { 0x0b6e, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/10 */
    { 0x0b76, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/12 */
    { 0x0b7e, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/2/14 */
    { 0x0f46, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/0 */
    { 0x0f4e, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/2 */
    { 0x0f56, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/4 */
    { 0x0f5e, 0x815e, 0x81a0, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/6 */
    { 0x0f66, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/8 */
    { 0x0f6e, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/10 */
    { 0x0f76, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/12 */
    { 0x0f7e, 0x815e, 0x0120, RTFLOAT80U_INIT_C(1,0x8000080000000000,16397), INT16_C(-16384) }, /* #101/3/14 */
    { 0x0106, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/0 */
    { 0x010e, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/2 */
    { 0x0116, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/4 */
    { 0x011e, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/6 */
    { 0x0126, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/8 */
    { 0x012e, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/10 */
    { 0x0136, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/12 */
    { 0x013e, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/0/14 */
    { 0x0506, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/0 */
    { 0x050e, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/2 */
    { 0x0516, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/4 */
    { 0x051e, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/6 */
    { 0x0526, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/8 */
    { 0x052e, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/10 */
    { 0x0536, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/12 */
    { 0x053e, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/1/14 */
    { 0x0906, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/0 */
    { 0x090e, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/2 */
    { 0x0916, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/4 */
    { 0x091e, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/6 */
    { 0x0926, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/8 */
    { 0x092e, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/10 */
    { 0x0936, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/12 */
    { 0x093e, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/2/14 */
    { 0x0d06, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/0 */
    { 0x0d0e, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/2 */
    { 0x0d16, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/4 */
    { 0x0d1e, 0x19e9, 0x81a0, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/6 */
    { 0x0d26, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/8 */
    { 0x0d2e, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/10 */
    { 0x0d36, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/12 */
    { 0x0d3e, 0x19e9, 0x0120, RTFLOAT80U_INIT_C(0,0x8000100000000000,16397), INT16_C(16384) }, /* #102/3/14 */
    { 0x0002, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/0 */
    { 0x000a, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/2 */
    { 0x0012, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/4 */
    { 0x001a, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/6 */
    { 0x0022, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/8 */
    { 0x002a, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/10 */
    { 0x0032, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/12 */
    { 0x003a, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/0/14 */
    { 0x0402, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/0 */
    { 0x040a, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/2 */
    { 0x0412, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/4 */
    { 0x041a, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/6 */
    { 0x0422, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/8 */
    { 0x042a, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/10 */
    { 0x0432, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/12 */
    { 0x043a, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/1/14 */
    { 0x0802, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/0 */
    { 0x080a, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/2 */
    { 0x0812, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/4 */
    { 0x081a, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/6 */
    { 0x0822, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/8 */
    { 0x082a, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/10 */
    { 0x0832, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/12 */
    { 0x083a, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/2/14 */
    { 0x0c02, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/0 */
    { 0x0c0a, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/2 */
    { 0x0c12, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/4 */
    { 0x0c1a, 0xde02, 0xc4a0, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/6 */
    { 0x0c22, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/8 */
    { 0x0c2a, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/10 */
    { 0x0c32, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/12 */
    { 0x0c3a, 0xde02, 0x4420, RTFLOAT80U_INIT_C(1,0x8000100000000000,16397), INT16_C(-16384) }, /* #103/3/14 */
    { 0x0340, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/0 */
    { 0x0348, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/2 */
    { 0x0350, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/4 */
    { 0x0358, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/6 */
    { 0x0360, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/8 */
    { 0x0368, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/10 */
    { 0x0370, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/12 */
    { 0x0378, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/0/14 */
    { 0x0740, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/0 */
    { 0x0748, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/2 */
    { 0x0750, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/4 */
    { 0x0758, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/6 */
    { 0x0760, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/8 */
    { 0x0768, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/10 */
    { 0x0770, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/12 */
    { 0x0778, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/1/14 */
    { 0x0b40, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/0 */
    { 0x0b48, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/2 */
    { 0x0b50, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/4 */
    { 0x0b58, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/6 */
    { 0x0b60, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/8 */
    { 0x0b68, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/10 */
    { 0x0b70, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/12 */
    { 0x0b78, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/2/14 */
    { 0x0f40, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/0 */
    { 0x0f48, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/2 */
    { 0x0f50, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/4 */
    { 0x0f58, 0xf174, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/6 */
    { 0x0f60, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/8 */
    { 0x0f68, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/10 */
    { 0x0f70, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/12 */
    { 0x0f78, 0xf174, 0x4120, RTFLOAT80U_INIT_C(0,0x8000200000000000,16397), INT16_C(16384) }, /* #104/3/14 */
    { 0x0304, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/0 */
    { 0x030c, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/2 */
    { 0x0314, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/4 */
    { 0x031c, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/6 */
    { 0x0324, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/8 */
    { 0x032c, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/10 */
    { 0x0334, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/12 */
    { 0x033c, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/0/14 */
    { 0x0704, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/0 */
    { 0x070c, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/2 */
    { 0x0714, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/4 */
    { 0x071c, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/6 */
    { 0x0724, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/8 */
    { 0x072c, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/10 */
    { 0x0734, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/12 */
    { 0x073c, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/1/14 */
    { 0x0b04, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/0 */
    { 0x0b0c, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/2 */
    { 0x0b14, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/4 */
    { 0x0b1c, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/6 */
    { 0x0b24, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/8 */
    { 0x0b2c, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/10 */
    { 0x0b34, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/12 */
    { 0x0b3c, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/2/14 */
    { 0x0f04, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/0 */
    { 0x0f0c, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/2 */
    { 0x0f14, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/4 */
    { 0x0f1c, 0xd897, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/6 */
    { 0x0f24, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/8 */
    { 0x0f2c, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/10 */
    { 0x0f34, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/12 */
    { 0x0f3c, 0xd897, 0x4020, RTFLOAT80U_INIT_C(1,0x8000200000000000,16397), INT16_C(-16384) }, /* #105/3/14 */
    { 0x0302, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/0 */
    { 0x030a, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/2 */
    { 0x0312, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/4 */
    { 0x031a, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/6 */
    { 0x0322, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/8 */
    { 0x032a, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/10 */
    { 0x0332, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/12 */
    { 0x033a, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/0/14 */
    { 0x0702, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/0 */
    { 0x070a, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/2 */
    { 0x0712, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/4 */
    { 0x071a, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/6 */
    { 0x0722, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/8 */
    { 0x072a, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/10 */
    { 0x0732, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/12 */
    { 0x073a, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/1/14 */
    { 0x0b02, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/0 */
    { 0x0b0a, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/2 */
    { 0x0b12, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/4 */
    { 0x0b1a, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/6 */
    { 0x0b22, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/8 */
    { 0x0b2a, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/10 */
    { 0x0b32, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/12 */
    { 0x0b3a, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/2/14 */
    { 0x0f02, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/0 */
    { 0x0f0a, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/2 */
    { 0x0f12, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/4 */
    { 0x0f1a, 0x7ee7, 0xc4a0, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/6 */
    { 0x0f22, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/8 */
    { 0x0f2a, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/10 */
    { 0x0f32, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/12 */
    { 0x0f3a, 0x7ee7, 0x4420, RTFLOAT80U_INIT_C(0,0x8000400000000000,16397), INT16_C(16384) }, /* #106/3/14 */
    { 0x0001, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/0 */
    { 0x0009, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/2 */
    { 0x0011, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/4 */
    { 0x0019, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/6 */
    { 0x0021, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/8 */
    { 0x0029, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/10 */
    { 0x0031, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/12 */
    { 0x0039, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/0/14 */
    { 0x0401, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/0 */
    { 0x0409, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/2 */
    { 0x0411, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/4 */
    { 0x0419, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/6 */
    { 0x0421, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/8 */
    { 0x0429, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/10 */
    { 0x0431, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/12 */
    { 0x0439, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/1/14 */
    { 0x0801, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/0 */
    { 0x0809, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/2 */
    { 0x0811, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/4 */
    { 0x0819, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/6 */
    { 0x0821, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/8 */
    { 0x0829, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/10 */
    { 0x0831, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/12 */
    { 0x0839, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/2/14 */
    { 0x0c01, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/0 */
    { 0x0c09, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/2 */
    { 0x0c11, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/4 */
    { 0x0c19, 0xdba1, 0xc1a0, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/6 */
    { 0x0c21, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/8 */
    { 0x0c29, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/10 */
    { 0x0c31, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/12 */
    { 0x0c39, 0xdba1, 0x4120, RTFLOAT80U_INIT_C(1,0x8000400000000000,16397), INT16_C(-16384) }, /* #107/3/14 */
    { 0x0243, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/0 */
    { 0x024b, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/2 */
    { 0x0253, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/4 */
    { 0x025b, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/6 */
    { 0x0263, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/8 */
    { 0x026b, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/10 */
    { 0x0273, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/12 */
    { 0x027b, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/0/14 */
    { 0x0643, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/0 */
    { 0x064b, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/2 */
    { 0x0653, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/4 */
    { 0x065b, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/6 */
    { 0x0663, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/8 */
    { 0x066b, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/10 */
    { 0x0673, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/12 */
    { 0x067b, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/1/14 */
    { 0x0a43, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/0 */
    { 0x0a4b, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/2 */
    { 0x0a53, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/4 */
    { 0x0a5b, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/6 */
    { 0x0a63, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/8 */
    { 0x0a6b, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/10 */
    { 0x0a73, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/12 */
    { 0x0a7b, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/2/14 */
    { 0x0e43, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/0 */
    { 0x0e4b, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/2 */
    { 0x0e53, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/4 */
    { 0x0e5b, 0xb26a, 0x80a0, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/6 */
    { 0x0e63, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/8 */
    { 0x0e6b, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/10 */
    { 0x0e73, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/12 */
    { 0x0e7b, 0xb26a, 0x0020, RTFLOAT80U_INIT_C(0,0x8000800000000000,16397), INT16_C(16384) }, /* #108/3/14 */
    { 0x0146, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/0 */
    { 0x014e, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/2 */
    { 0x0156, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/4 */
    { 0x015e, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/6 */
    { 0x0166, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/8 */
    { 0x016e, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/10 */
    { 0x0176, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/12 */
    { 0x017e, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/0/14 */
    { 0x0546, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/0 */
    { 0x054e, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/2 */
    { 0x0556, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/4 */
    { 0x055e, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/6 */
    { 0x0566, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/8 */
    { 0x056e, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/10 */
    { 0x0576, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/12 */
    { 0x057e, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/1/14 */
    { 0x0946, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/0 */
    { 0x094e, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/2 */
    { 0x0956, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/4 */
    { 0x095e, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/6 */
    { 0x0966, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/8 */
    { 0x096e, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/10 */
    { 0x0976, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/12 */
    { 0x097e, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/2/14 */
    { 0x0d46, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/0 */
    { 0x0d4e, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/2 */
    { 0x0d56, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/4 */
    { 0x0d5e, 0x459f, 0xc5a0, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/6 */
    { 0x0d66, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/8 */
    { 0x0d6e, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/10 */
    { 0x0d76, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/12 */
    { 0x0d7e, 0x459f, 0x4520, RTFLOAT80U_INIT_C(1,0x8000800000000000,16397), INT16_C(-16384) }, /* #109/3/14 */
    { 0x0246, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/0 */
    { 0x024e, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/2 */
    { 0x0256, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/4 */
    { 0x025e, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/6 */
    { 0x0266, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/8 */
    { 0x026e, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/10 */
    { 0x0276, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/12 */
    { 0x027e, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/0/14 */
    { 0x0646, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/0 */
    { 0x064e, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/2 */
    { 0x0656, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/4 */
    { 0x065e, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/6 */
    { 0x0666, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/8 */
    { 0x066e, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/10 */
    { 0x0676, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/12 */
    { 0x067e, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/1/14 */
    { 0x0a46, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/0 */
    { 0x0a4e, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/2 */
    { 0x0a56, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/4 */
    { 0x0a5e, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/6 */
    { 0x0a66, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/8 */
    { 0x0a6e, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/10 */
    { 0x0a76, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/12 */
    { 0x0a7e, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/2/14 */
    { 0x0e46, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/0 */
    { 0x0e4e, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/2 */
    { 0x0e56, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/4 */
    { 0x0e5e, 0x1e47, 0x84a0, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/6 */
    { 0x0e66, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/8 */
    { 0x0e6e, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/10 */
    { 0x0e76, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/12 */
    { 0x0e7e, 0x1e47, 0x0420, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16397), INT16_C(-16384) }, /* #110/3/14 */
    { 0x0105, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/0 */
    { 0x010d, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/2 */
    { 0x0115, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/4 */
    { 0x011d, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/6 */
    { 0x0125, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/8 */
    { 0x012d, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/10 */
    { 0x0135, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/12 */
    { 0x013d, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/0/14 */
    { 0x0505, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/0 */
    { 0x050d, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/2 */
    { 0x0515, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/4 */
    { 0x051d, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/6 */
    { 0x0525, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/8 */
    { 0x052d, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/10 */
    { 0x0535, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/12 */
    { 0x053d, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/1/14 */
    { 0x0905, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/0 */
    { 0x090d, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/2 */
    { 0x0915, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/4 */
    { 0x091d, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/6 */
    { 0x0925, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/8 */
    { 0x092d, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/10 */
    { 0x0935, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/12 */
    { 0x093d, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/2/14 */
    { 0x0d05, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/0 */
    { 0x0d0d, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/2 */
    { 0x0d15, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/4 */
    { 0x0d1d, 0x5972, 0xc1a0, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/6 */
    { 0x0d25, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/8 */
    { 0x0d2d, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/10 */
    { 0x0d35, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/12 */
    { 0x0d3d, 0x5972, 0x4120, RTFLOAT80U_INIT_C(0,0x8001000000000000,16397), INT16_C(16384) }, /* #111/3/14 */
    { 0x0242, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/0 */
    { 0x024a, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/2 */
    { 0x0252, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/4 */
    { 0x025a, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/6 */
    { 0x0262, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/8 */
    { 0x026a, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/10 */
    { 0x0272, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/12 */
    { 0x027a, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/0/14 */
    { 0x0642, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/0 */
    { 0x064a, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/2 */
    { 0x0652, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/4 */
    { 0x065a, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/6 */
    { 0x0662, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/8 */
    { 0x066a, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/10 */
    { 0x0672, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/12 */
    { 0x067a, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/1/14 */
    { 0x0a42, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/0 */
    { 0x0a4a, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/2 */
    { 0x0a52, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/4 */
    { 0x0a5a, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/6 */
    { 0x0a62, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/8 */
    { 0x0a6a, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/10 */
    { 0x0a72, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/12 */
    { 0x0a7a, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/2/14 */
    { 0x0e42, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/0 */
    { 0x0e4a, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/2 */
    { 0x0e52, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/4 */
    { 0x0e5a, 0x6a3a, 0xc0a0, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/6 */
    { 0x0e62, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/8 */
    { 0x0e6a, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/10 */
    { 0x0e72, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/12 */
    { 0x0e7a, 0x6a3a, 0x4020, RTFLOAT80U_INIT_C(1,0x8001000000000000,16397), INT16_C(-16384) }, /* #112/3/14 */
    { 0x0347, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/0 */
    { 0x034f, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/2 */
    { 0x0357, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/4 */
    { 0x035f, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/6 */
    { 0x0367, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/8 */
    { 0x036f, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/10 */
    { 0x0377, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/12 */
    { 0x037f, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/0/14 */
    { 0x0747, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/0 */
    { 0x074f, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/2 */
    { 0x0757, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/4 */
    { 0x075f, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/6 */
    { 0x0767, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/8 */
    { 0x076f, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/10 */
    { 0x0777, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/12 */
    { 0x077f, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/1/14 */
    { 0x0b47, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/0 */
    { 0x0b4f, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/2 */
    { 0x0b57, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/4 */
    { 0x0b5f, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/6 */
    { 0x0b67, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/8 */
    { 0x0b6f, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/10 */
    { 0x0b77, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/12 */
    { 0x0b7f, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/2/14 */
    { 0x0f47, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/0 */
    { 0x0f4f, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/2 */
    { 0x0f57, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/4 */
    { 0x0f5f, 0x8a93, 0x80a0, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/6 */
    { 0x0f67, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/8 */
    { 0x0f6f, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/10 */
    { 0x0f77, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/12 */
    { 0x0f7f, 0x8a93, 0x0020, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16397), INT16_MAX }, /* #113/3/14 */
    { 0x0207, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/0 */
    { 0x020f, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/2 */
    { 0x0217, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/4 */
    { 0x021f, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/6 */
    { 0x0227, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/8 */
    { 0x022f, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/10 */
    { 0x0237, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/12 */
    { 0x023f, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/0/14 */
    { 0x0607, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/0 */
    { 0x060f, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/2 */
    { 0x0617, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/4 */
    { 0x061f, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/6 */
    { 0x0627, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/8 */
    { 0x062f, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/10 */
    { 0x0637, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/12 */
    { 0x063f, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/1/14 */
    { 0x0a07, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/0 */
    { 0x0a0f, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/2 */
    { 0x0a17, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/4 */
    { 0x0a1f, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/6 */
    { 0x0a27, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/8 */
    { 0x0a2f, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/10 */
    { 0x0a37, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/12 */
    { 0x0a3f, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/2/14 */
    { 0x0e07, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/0 */
    { 0x0e0f, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/2 */
    { 0x0e17, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/4 */
    { 0x0e1f, 0xbdae, 0x85a0, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/6 */
    { 0x0e27, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/8 */
    { 0x0e2f, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/10 */
    { 0x0e37, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/12 */
    { 0x0e3f, 0xbdae, 0x0520, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16397), INT16_C(-32767) }, /* #114/3/14 */
    { 0x0003, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/0 */
    { 0x000b, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/2 */
    { 0x0013, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/4 */
    { 0x001b, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/6 */
    { 0x0023, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/8 */
    { 0x002b, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/10 */
    { 0x0033, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/12 */
    { 0x003b, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/0/14 */
    { 0x0403, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/0 */
    { 0x040b, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/2 */
    { 0x0413, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/4 */
    { 0x041b, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/6 */
    { 0x0423, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/8 */
    { 0x042b, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/10 */
    { 0x0433, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/12 */
    { 0x043b, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/1/14 */
    { 0x0803, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/0 */
    { 0x080b, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/2 */
    { 0x0813, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/4 */
    { 0x081b, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/6 */
    { 0x0823, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/8 */
    { 0x082b, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/10 */
    { 0x0833, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/12 */
    { 0x083b, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/2/14 */
    { 0x0c03, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/0 */
    { 0x0c0b, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/2 */
    { 0x0c13, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/4 */
    { 0x0c1b, 0x7f07, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/6 */
    { 0x0c23, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/8 */
    { 0x0c2b, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/10 */
    { 0x0c33, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/12 */
    { 0x0c3b, 0x7f07, 0x4520, RTFLOAT80U_INIT_C(0,0xffff800000000000,16397), INT16_MAX }, /* #115/3/14 */
    { 0x0302, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/0 */
    { 0x030a, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/2 */
    { 0x0312, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/4 */
    { 0x031a, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/6 */
    { 0x0322, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/8 */
    { 0x032a, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/10 */
    { 0x0332, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/12 */
    { 0x033a, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/0/14 */
    { 0x0702, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/0 */
    { 0x070a, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/2 */
    { 0x0712, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/4 */
    { 0x071a, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/6 */
    { 0x0722, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/8 */
    { 0x072a, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/10 */
    { 0x0732, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/12 */
    { 0x073a, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/1/14 */
    { 0x0b02, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/0 */
    { 0x0b0a, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/2 */
    { 0x0b12, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/4 */
    { 0x0b1a, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/6 */
    { 0x0b22, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/8 */
    { 0x0b2a, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/10 */
    { 0x0b32, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/12 */
    { 0x0b3a, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/2/14 */
    { 0x0f02, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/0 */
    { 0x0f0a, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/2 */
    { 0x0f12, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/4 */
    { 0x0f1a, 0xfdf5, 0xc5a0, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/6 */
    { 0x0f22, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/8 */
    { 0x0f2a, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/10 */
    { 0x0f32, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/12 */
    { 0x0f3a, 0xfdf5, 0x4520, RTFLOAT80U_INIT_C(0,0xffff000000000000,16397), INT16_MAX }, /* #116/3/14 */
    { 0x0041, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/0 */
    { 0x0049, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/2 */
    { 0x0051, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/4 */
    { 0x0059, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/6 */
    { 0x0061, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/8 */
    { 0x0069, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/10 */
    { 0x0071, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/12 */
    { 0x0079, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/0/14 */
    { 0x0441, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/0 */
    { 0x0449, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/2 */
    { 0x0451, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/4 */
    { 0x0459, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/6 */
    { 0x0461, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/8 */
    { 0x0469, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/10 */
    { 0x0471, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/12 */
    { 0x0479, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/1/14 */
    { 0x0841, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/0 */
    { 0x0849, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/2 */
    { 0x0851, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/4 */
    { 0x0859, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/6 */
    { 0x0861, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/8 */
    { 0x0869, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/10 */
    { 0x0871, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/12 */
    { 0x0879, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/2/14 */
    { 0x0c41, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/0 */
    { 0x0c49, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/2 */
    { 0x0c51, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/4 */
    { 0x0c59, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/6 */
    { 0x0c61, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/8 */
    { 0x0c69, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/10 */
    { 0x0c71, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/12 */
    { 0x0c79, 0xaf08, 0x0500, RTFLOAT80U_INIT_C(0,0xfffe000000000000,16397), INT16_MAX }, /* #117/3/14 */
    { 0x0140, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/0 */
    { 0x0148, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/2 */
    { 0x0150, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/4 */
    { 0x0158, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/6 */
    { 0x0160, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/8 */
    { 0x0168, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/10 */
    { 0x0170, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/12 */
    { 0x0178, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/0/14 */
    { 0x0540, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/0 */
    { 0x0548, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/2 */
    { 0x0550, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/4 */
    { 0x0558, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/6 */
    { 0x0560, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/8 */
    { 0x0568, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/10 */
    { 0x0570, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/12 */
    { 0x0578, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/1/14 */
    { 0x0940, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/0 */
    { 0x0948, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/2 */
    { 0x0950, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/4 */
    { 0x0958, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/6 */
    { 0x0960, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/8 */
    { 0x0968, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/10 */
    { 0x0970, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/12 */
    { 0x0978, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/2/14 */
    { 0x0d40, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/0 */
    { 0x0d48, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/2 */
    { 0x0d50, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/4 */
    { 0x0d58, 0xb5b5, 0x85a0, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/6 */
    { 0x0d60, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/8 */
    { 0x0d68, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/10 */
    { 0x0d70, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/12 */
    { 0x0d78, 0xb5b5, 0x0520, RTFLOAT80U_INIT_C(1,0xffff800000000000,16397), INT16_C(-32767) }, /* #118/3/14 */
    { 0x0301, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/0 */
    { 0x0309, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/2 */
    { 0x0311, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/4 */
    { 0x0319, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/6 */
    { 0x0321, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/8 */
    { 0x0329, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/10 */
    { 0x0331, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/12 */
    { 0x0339, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/0/14 */
    { 0x0701, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/0 */
    { 0x0709, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/2 */
    { 0x0711, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/4 */
    { 0x0719, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/6 */
    { 0x0721, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/8 */
    { 0x0729, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/10 */
    { 0x0731, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/12 */
    { 0x0739, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/1/14 */
    { 0x0b01, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/0 */
    { 0x0b09, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/2 */
    { 0x0b11, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/4 */
    { 0x0b19, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/6 */
    { 0x0b21, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/8 */
    { 0x0b29, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/10 */
    { 0x0b31, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/12 */
    { 0x0b39, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/2/14 */
    { 0x0f01, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/0 */
    { 0x0f09, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/2 */
    { 0x0f11, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/4 */
    { 0x0f19, 0xc5e6, 0xc5a0, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/6 */
    { 0x0f21, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/8 */
    { 0x0f29, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/10 */
    { 0x0f31, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/12 */
    { 0x0f39, 0xc5e6, 0x4520, RTFLOAT80U_INIT_C(1,0xffff000000000000,16397), INT16_C(-32767) }, /* #119/3/14 */
    { 0x0307, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/0 */
    { 0x030f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/2 */
    { 0x0317, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/4 */
    { 0x031f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/6 */
    { 0x0327, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/8 */
    { 0x032f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/10 */
    { 0x0337, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/12 */
    { 0x033f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/0/14 */
    { 0x0707, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/0 */
    { 0x070f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/2 */
    { 0x0717, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/4 */
    { 0x071f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/6 */
    { 0x0727, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/8 */
    { 0x072f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/10 */
    { 0x0737, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/12 */
    { 0x073f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/1/14 */
    { 0x0b07, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/0 */
    { 0x0b0f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/2 */
    { 0x0b17, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/4 */
    { 0x0b1f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/6 */
    { 0x0b27, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/8 */
    { 0x0b2f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/10 */
    { 0x0b37, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/12 */
    { 0x0b3f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/2/14 */
    { 0x0f07, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/0 */
    { 0x0f0f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/2 */
    { 0x0f17, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/4 */
    { 0x0f1f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/6 */
    { 0x0f27, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/8 */
    { 0x0f2f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/10 */
    { 0x0f37, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/12 */
    { 0x0f3f, 0x1037, 0x0000, RTFLOAT80U_INIT_C(1,0xfffe000000000000,16397), INT16_C(-32767) }, /* #120/3/14 */
    { 0x0041, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/0/0 */
    { 0x0049, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/0/2 */
    { 0x0051, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/0/4 */
    { 0x0059, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/0/6 */
    { 0x0061, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/0/8 */
    { 0x0069, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/0/10 */
    { 0x0071, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/0/12 */
    { 0x0079, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/0/14 */
    { 0x0441, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/1/0 */
    { 0x0449, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/1/2 */
    { 0x0451, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/1/4 */
    { 0x0459, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/1/6 */
    { 0x0461, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/1/8 */
    { 0x0469, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/1/10 */
    { 0x0471, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/1/12 */
    { 0x0479, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/1/14 */
    { 0x0841, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/2/0 */
    { 0x0849, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/2/2 */
    { 0x0851, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/2/4 */
    { 0x0859, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/2/6 */
    { 0x0861, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/2/8 */
    { 0x0869, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/2/10 */
    { 0x0871, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/2/12 */
    { 0x0879, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/2/14 */
    { 0x0c41, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/3/0 */
    { 0x0c49, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/3/2 */
    { 0x0c51, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/3/4 */
    { 0x0c59, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/3/6 */
    { 0x0c61, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/3/8 */
    { 0x0c69, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/3/10 */
    { 0x0c71, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/3/12 */
    { 0x0c79, 0xaa43, 0x0001, RTFLOAT80U_INIT_C(0,0x8000000000000000,16398), INT16_MIN }, /* #121/3/14 */
    { 0x0247, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/0/0 */
    { 0x024f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/0/2 */
    { 0x0257, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/0/4 */
    { 0x025f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/0/6 */
    { 0x0267, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/0/8 */
    { 0x026f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/0/10 */
    { 0x0277, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/0/12 */
    { 0x027f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/0/14 */
    { 0x0647, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/1/0 */
    { 0x064f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/1/2 */
    { 0x0657, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/1/4 */
    { 0x065f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/1/6 */
    { 0x0667, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/1/8 */
    { 0x066f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/1/10 */
    { 0x0677, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/1/12 */
    { 0x067f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/1/14 */
    { 0x0a47, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/2/0 */
    { 0x0a4f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/2/2 */
    { 0x0a57, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/2/4 */
    { 0x0a5f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/2/6 */
    { 0x0a67, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/2/8 */
    { 0x0a6f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/2/10 */
    { 0x0a77, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/2/12 */
    { 0x0a7f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/2/14 */
    { 0x0e47, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/3/0 */
    { 0x0e4f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/3/2 */
    { 0x0e57, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/3/4 */
    { 0x0e5f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/3/6 */
    { 0x0e67, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/3/8 */
    { 0x0e6f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/3/10 */
    { 0x0e77, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/3/12 */
    { 0x0e7f, 0x41a8, 0x4101, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16398), INT16_MIN }, /* #122/3/14 */
    { 0x0041, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/0 */
    { 0x0049, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/2 */
    { 0x0051, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/4 */
    { 0x0059, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/6 */
    { 0x0061, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/8 */
    { 0x0069, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/10 */
    { 0x0071, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/12 */
    { 0x0079, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/0/14 */
    { 0x0441, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/0 */
    { 0x0449, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/2 */
    { 0x0451, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/4 */
    { 0x0459, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/6 */
    { 0x0461, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/8 */
    { 0x0469, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/10 */
    { 0x0471, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/12 */
    { 0x0479, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/1/14 */
    { 0x0841, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/0 */
    { 0x0849, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/2 */
    { 0x0851, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/4 */
    { 0x0859, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/6 */
    { 0x0861, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/8 */
    { 0x0869, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/10 */
    { 0x0871, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/12 */
    { 0x0879, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/2/14 */
    { 0x0c41, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/0 */
    { 0x0c49, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/2 */
    { 0x0c51, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/4 */
    { 0x0c59, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/6 */
    { 0x0c61, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/8 */
    { 0x0c69, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/10 */
    { 0x0c71, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/12 */
    { 0x0c79, 0x0ed1, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16399), INT16_MIN }, /* #123/3/14 */
    { 0x0146, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/0/0 */
    { 0x014e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/0/2 */
    { 0x0156, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/0/4 */
    { 0x015e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/0/6 */
    { 0x0166, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/0/8 */
    { 0x016e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/0/10 */
    { 0x0176, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/0/12 */
    { 0x017e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/0/14 */
    { 0x0546, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/1/0 */
    { 0x054e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/1/2 */
    { 0x0556, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/1/4 */
    { 0x055e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/1/6 */
    { 0x0566, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/1/8 */
    { 0x056e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/1/10 */
    { 0x0576, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/1/12 */
    { 0x057e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/1/14 */
    { 0x0946, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/2/0 */
    { 0x094e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/2/2 */
    { 0x0956, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/2/4 */
    { 0x095e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/2/6 */
    { 0x0966, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/2/8 */
    { 0x096e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/2/10 */
    { 0x0976, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/2/12 */
    { 0x097e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/2/14 */
    { 0x0d46, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/3/0 */
    { 0x0d4e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/3/2 */
    { 0x0d56, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/3/4 */
    { 0x0d5e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/3/6 */
    { 0x0d66, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/3/8 */
    { 0x0d6e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/3/10 */
    { 0x0d76, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/3/12 */
    { 0x0d7e, 0x97a4, 0xbd81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16400), INT16_C(-3) }, /* #124/3/14 */
    { 0x0206, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/0/0 */
    { 0x020e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/0/2 */
    { 0x0216, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/0/4 */
    { 0x021e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/0/6 */
    { 0x0226, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/0/8 */
    { 0x022e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/0/10 */
    { 0x0236, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/0/12 */
    { 0x023e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/0/14 */
    { 0x0606, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/1/0 */
    { 0x060e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/1/2 */
    { 0x0616, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/1/4 */
    { 0x061e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/1/6 */
    { 0x0626, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/1/8 */
    { 0x062e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/1/10 */
    { 0x0636, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/1/12 */
    { 0x063e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/1/14 */
    { 0x0a06, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/2/0 */
    { 0x0a0e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/2/2 */
    { 0x0a16, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/2/4 */
    { 0x0a1e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/2/6 */
    { 0x0a26, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/2/8 */
    { 0x0a2e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/2/10 */
    { 0x0a36, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/2/12 */
    { 0x0a3e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/2/14 */
    { 0x0e06, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/3/0 */
    { 0x0e0e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/3/2 */
    { 0x0e16, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/3/4 */
    { 0x0e1e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/3/6 */
    { 0x0e26, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/3/8 */
    { 0x0e2e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/3/10 */
    { 0x0e36, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/3/12 */
    { 0x0e3e, 0x3b91, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16403), INT16_C(-3) }, /* #125/3/14 */
    { 0x0144, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/0/0 */
    { 0x014c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/0/2 */
    { 0x0154, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/0/4 */
    { 0x015c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/0/6 */
    { 0x0164, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/0/8 */
    { 0x016c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/0/10 */
    { 0x0174, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/0/12 */
    { 0x017c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/0/14 */
    { 0x0544, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/1/0 */
    { 0x054c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/1/2 */
    { 0x0554, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/1/4 */
    { 0x055c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/1/6 */
    { 0x0564, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/1/8 */
    { 0x056c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/1/10 */
    { 0x0574, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/1/12 */
    { 0x057c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/1/14 */
    { 0x0944, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/2/0 */
    { 0x094c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/2/2 */
    { 0x0954, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/2/4 */
    { 0x095c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/2/6 */
    { 0x0964, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/2/8 */
    { 0x096c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/2/10 */
    { 0x0974, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/2/12 */
    { 0x097c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/2/14 */
    { 0x0d44, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/3/0 */
    { 0x0d4c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/3/2 */
    { 0x0d54, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/3/4 */
    { 0x0d5c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/3/6 */
    { 0x0d64, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/3/8 */
    { 0x0d6c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/3/10 */
    { 0x0d74, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/3/12 */
    { 0x0d7c, 0xbc85, 0xbc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,16407), INT16_C(-3) }, /* #126/3/14 */
    { 0x0347, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/0 */
    { 0x034f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/2 */
    { 0x0357, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/4 */
    { 0x035f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/6 */
    { 0x0367, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/8 */
    { 0x036f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/10 */
    { 0x0377, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/12 */
    { 0x037f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/0/14 */
    { 0x0747, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/0 */
    { 0x074f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/2 */
    { 0x0757, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/4 */
    { 0x075f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/6 */
    { 0x0767, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/8 */
    { 0x076f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/10 */
    { 0x0777, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/12 */
    { 0x077f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/1/14 */
    { 0x0b47, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/0 */
    { 0x0b4f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/2 */
    { 0x0b57, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/4 */
    { 0x0b5f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/6 */
    { 0x0b67, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/8 */
    { 0x0b6f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/10 */
    { 0x0b77, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/12 */
    { 0x0b7f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/2/14 */
    { 0x0f47, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/0 */
    { 0x0f4f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/2 */
    { 0x0f57, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/4 */
    { 0x0f5f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/6 */
    { 0x0f67, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/8 */
    { 0x0f6f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/10 */
    { 0x0f77, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/12 */
    { 0x0f7f, 0x05ae, 0x0501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16411), INT16_MIN }, /* #127/3/14 */
    { 0x0241, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/0 */
    { 0x0249, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/2 */
    { 0x0251, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/4 */
    { 0x0259, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/6 */
    { 0x0261, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/8 */
    { 0x0269, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/10 */
    { 0x0271, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/12 */
    { 0x0279, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/0/14 */
    { 0x0641, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/0 */
    { 0x0649, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/2 */
    { 0x0651, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/4 */
    { 0x0659, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/6 */
    { 0x0661, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/8 */
    { 0x0669, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/10 */
    { 0x0671, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/12 */
    { 0x0679, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/1/14 */
    { 0x0a41, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/0 */
    { 0x0a49, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/2 */
    { 0x0a51, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/4 */
    { 0x0a59, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/6 */
    { 0x0a61, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/8 */
    { 0x0a69, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/10 */
    { 0x0a71, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/12 */
    { 0x0a79, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/2/14 */
    { 0x0e41, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/0 */
    { 0x0e49, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/2 */
    { 0x0e51, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/4 */
    { 0x0e59, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/6 */
    { 0x0e61, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/8 */
    { 0x0e69, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/10 */
    { 0x0e71, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/12 */
    { 0x0e79, 0xb447, 0x0401, RTFLOAT80U_INIT_C(0,0x8000000000000000,16413), INT16_MIN }, /* #128/3/14 */
    { 0x0000, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/0 */
    { 0x0008, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/2 */
    { 0x0010, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/4 */
    { 0x0018, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/6 */
    { 0x0020, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/8 */
    { 0x0028, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/10 */
    { 0x0030, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/12 */
    { 0x0038, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/0/14 */
    { 0x0400, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/0 */
    { 0x0408, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/2 */
    { 0x0410, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/4 */
    { 0x0418, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/6 */
    { 0x0420, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/8 */
    { 0x0428, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/10 */
    { 0x0430, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/12 */
    { 0x0438, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/1/14 */
    { 0x0800, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/0 */
    { 0x0808, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/2 */
    { 0x0810, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/4 */
    { 0x0818, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/6 */
    { 0x0820, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/8 */
    { 0x0828, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/10 */
    { 0x0830, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/12 */
    { 0x0838, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/2/14 */
    { 0x0c00, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/0 */
    { 0x0c08, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/2 */
    { 0x0c10, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/4 */
    { 0x0c18, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/6 */
    { 0x0c20, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/8 */
    { 0x0c28, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/10 */
    { 0x0c30, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/12 */
    { 0x0c38, 0x202e, 0xb881, RTFLOAT80U_INIT_C(1,0x8000000000000000,16413), INT16_C(-3) }, /* #129/3/14 */
    { 0x0043, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/0 */
    { 0x004b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/2 */
    { 0x0053, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/4 */
    { 0x005b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/6 */
    { 0x0063, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/8 */
    { 0x006b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/10 */
    { 0x0073, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/12 */
    { 0x007b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/0/14 */
    { 0x0443, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/0 */
    { 0x044b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/2 */
    { 0x0453, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/4 */
    { 0x045b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/6 */
    { 0x0463, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/8 */
    { 0x046b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/10 */
    { 0x0473, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/12 */
    { 0x047b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/1/14 */
    { 0x0843, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/0 */
    { 0x084b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/2 */
    { 0x0853, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/4 */
    { 0x085b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/6 */
    { 0x0863, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/8 */
    { 0x086b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/10 */
    { 0x0873, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/12 */
    { 0x087b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/2/14 */
    { 0x0c43, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/0 */
    { 0x0c4b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/2 */
    { 0x0c53, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/4 */
    { 0x0c5b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/6 */
    { 0x0c63, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/8 */
    { 0x0c6b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/10 */
    { 0x0c73, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/12 */
    { 0x0c7b, 0x7a12, 0x4001, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16413), INT16_MIN }, /* #130/3/14 */
    { 0x0303, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/0/0 */
    { 0x030b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/0/2 */
    { 0x0313, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/0/4 */
    { 0x031b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/0/6 */
    { 0x0323, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/0/8 */
    { 0x032b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/0/10 */
    { 0x0333, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/0/12 */
    { 0x033b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/0/14 */
    { 0x0703, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/1/0 */
    { 0x070b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/1/2 */
    { 0x0713, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/1/4 */
    { 0x071b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/1/6 */
    { 0x0723, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/1/8 */
    { 0x072b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/1/10 */
    { 0x0733, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/1/12 */
    { 0x073b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/1/14 */
    { 0x0b03, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/2/0 */
    { 0x0b0b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/2/2 */
    { 0x0b13, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/2/4 */
    { 0x0b1b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/2/6 */
    { 0x0b23, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/2/8 */
    { 0x0b2b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/2/10 */
    { 0x0b33, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/2/12 */
    { 0x0b3b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/2/14 */
    { 0x0f03, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/3/0 */
    { 0x0f0b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/3/2 */
    { 0x0f13, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/3/4 */
    { 0x0f1b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/3/6 */
    { 0x0f23, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/3/8 */
    { 0x0f2b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/3/10 */
    { 0x0f33, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/3/12 */
    { 0x0f3b, 0x267e, 0x0401, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16413), INT16_MIN }, /* #131/3/14 */
    { 0x0002, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/0/0 */
    { 0x000a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/0/2 */
    { 0x0012, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/0/4 */
    { 0x001a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/0/6 */
    { 0x0022, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/0/8 */
    { 0x002a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/0/10 */
    { 0x0032, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/0/12 */
    { 0x003a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/0/14 */
    { 0x0402, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/1/0 */
    { 0x040a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/1/2 */
    { 0x0412, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/1/4 */
    { 0x041a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/1/6 */
    { 0x0422, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/1/8 */
    { 0x042a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/1/10 */
    { 0x0432, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/1/12 */
    { 0x043a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/1/14 */
    { 0x0802, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/2/0 */
    { 0x080a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/2/2 */
    { 0x0812, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/2/4 */
    { 0x081a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/2/6 */
    { 0x0822, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/2/8 */
    { 0x082a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/2/10 */
    { 0x0832, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/2/12 */
    { 0x083a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/2/14 */
    { 0x0c02, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/3/0 */
    { 0x0c0a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/3/2 */
    { 0x0c12, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/3/4 */
    { 0x0c1a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/3/6 */
    { 0x0c22, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/3/8 */
    { 0x0c2a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/3/10 */
    { 0x0c32, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/3/12 */
    { 0x0c3a, 0x93ab, 0xb981, RTFLOAT80U_INIT_C(0,0x8000000000000000,16414), INT16_C(-3) }, /* #132/3/14 */
    { 0x0000, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/0 */
    { 0x0008, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/2 */
    { 0x0010, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/4 */
    { 0x0018, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/6 */
    { 0x0020, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/8 */
    { 0x0028, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/10 */
    { 0x0030, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/12 */
    { 0x0038, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/0/14 */
    { 0x0400, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/0 */
    { 0x0408, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/2 */
    { 0x0410, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/4 */
    { 0x0418, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/6 */
    { 0x0420, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/8 */
    { 0x0428, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/10 */
    { 0x0430, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/12 */
    { 0x0438, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/1/14 */
    { 0x0800, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/0 */
    { 0x0808, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/2 */
    { 0x0810, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/4 */
    { 0x0818, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/6 */
    { 0x0820, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/8 */
    { 0x0828, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/10 */
    { 0x0830, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/12 */
    { 0x0838, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/2/14 */
    { 0x0c00, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/0 */
    { 0x0c08, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/2 */
    { 0x0c10, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/4 */
    { 0x0c18, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/6 */
    { 0x0c20, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/8 */
    { 0x0c28, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/10 */
    { 0x0c30, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/12 */
    { 0x0c38, 0x6413, 0xfc81, RTFLOAT80U_INIT_C(1,0x8000000000000000,16414), INT16_C(-3) }, /* #133/3/14 */
    { 0x0300, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/0 */
    { 0x0308, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/2 */
    { 0x0310, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/4 */
    { 0x0318, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/6 */
    { 0x0320, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/8 */
    { 0x0328, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/10 */
    { 0x0330, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/12 */
    { 0x0338, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/0/14 */
    { 0x0700, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/0 */
    { 0x0708, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/2 */
    { 0x0710, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/4 */
    { 0x0718, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/6 */
    { 0x0720, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/8 */
    { 0x0728, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/10 */
    { 0x0730, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/12 */
    { 0x0738, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/1/14 */
    { 0x0b00, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/0 */
    { 0x0b08, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/2 */
    { 0x0b10, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/4 */
    { 0x0b18, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/6 */
    { 0x0b20, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/8 */
    { 0x0b28, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/10 */
    { 0x0b30, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/12 */
    { 0x0b38, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/2/14 */
    { 0x0f00, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/0 */
    { 0x0f08, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/2 */
    { 0x0f10, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/4 */
    { 0x0f18, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/6 */
    { 0x0f20, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/8 */
    { 0x0f28, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/10 */
    { 0x0f30, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/12 */
    { 0x0f38, 0xe4bc, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000001,16414), INT16_C(-3) }, /* #134/3/14 */
    { 0x0001, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/0/0 */
    { 0x0009, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/0/2 */
    { 0x0011, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/0/4 */
    { 0x0019, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/0/6 */
    { 0x0021, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/0/8 */
    { 0x0029, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/0/10 */
    { 0x0031, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/0/12 */
    { 0x0039, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/0/14 */
    { 0x0401, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/1/0 */
    { 0x0409, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/1/2 */
    { 0x0411, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/1/4 */
    { 0x0419, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/1/6 */
    { 0x0421, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/1/8 */
    { 0x0429, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/1/10 */
    { 0x0431, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/1/12 */
    { 0x0439, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/1/14 */
    { 0x0801, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/2/0 */
    { 0x0809, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/2/2 */
    { 0x0811, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/2/4 */
    { 0x0819, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/2/6 */
    { 0x0821, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/2/8 */
    { 0x0829, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/2/10 */
    { 0x0831, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/2/12 */
    { 0x0839, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/2/14 */
    { 0x0c01, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/3/0 */
    { 0x0c09, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/3/2 */
    { 0x0c11, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/3/4 */
    { 0x0c19, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/3/6 */
    { 0x0c21, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/3/8 */
    { 0x0c29, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/3/10 */
    { 0x0c31, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/3/12 */
    { 0x0c39, 0x0433, 0x0401, RTFLOAT80U_INIT_C(1,0x8000000000000001,16414), INT16_MIN }, /* #135/3/14 */
    { 0x0340, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/0/0 */
    { 0x0348, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/0/2 */
    { 0x0350, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/0/4 */
    { 0x0358, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/0/6 */
    { 0x0360, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/0/8 */
    { 0x0368, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/0/10 */
    { 0x0370, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/0/12 */
    { 0x0378, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/0/14 */
    { 0x0740, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/1/0 */
    { 0x0748, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/1/2 */
    { 0x0750, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/1/4 */
    { 0x0758, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/1/6 */
    { 0x0760, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/1/8 */
    { 0x0768, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/1/10 */
    { 0x0770, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/1/12 */
    { 0x0778, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/1/14 */
    { 0x0b40, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/2/0 */
    { 0x0b48, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/2/2 */
    { 0x0b50, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/2/4 */
    { 0x0b58, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/2/6 */
    { 0x0b60, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/2/8 */
    { 0x0b68, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/2/10 */
    { 0x0b70, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/2/12 */
    { 0x0b78, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/2/14 */
    { 0x0f40, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/3/0 */
    { 0x0f48, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/3/2 */
    { 0x0f50, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/3/4 */
    { 0x0f58, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/3/6 */
    { 0x0f60, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/3/8 */
    { 0x0f68, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/3/10 */
    { 0x0f70, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/3/12 */
    { 0x0f78, 0x2963, 0xb981, RTFLOAT80U_INIT_C(0,0x8000ffffffffffff,16414), INT16_C(-3) }, /* #136/3/14 */
    { 0x0145, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/0 */
    { 0x014d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/2 */
    { 0x0155, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/4 */
    { 0x015d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/6 */
    { 0x0165, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/8 */
    { 0x016d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/10 */
    { 0x0175, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/12 */
    { 0x017d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/0/14 */
    { 0x0545, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/0 */
    { 0x054d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/2 */
    { 0x0555, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/4 */
    { 0x055d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/6 */
    { 0x0565, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/8 */
    { 0x056d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/10 */
    { 0x0575, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/12 */
    { 0x057d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/1/14 */
    { 0x0945, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/0 */
    { 0x094d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/2 */
    { 0x0955, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/4 */
    { 0x095d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/6 */
    { 0x0965, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/8 */
    { 0x096d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/10 */
    { 0x0975, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/12 */
    { 0x097d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/2/14 */
    { 0x0d45, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/0 */
    { 0x0d4d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/2 */
    { 0x0d55, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/4 */
    { 0x0d5d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/6 */
    { 0x0d65, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/8 */
    { 0x0d6d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/10 */
    { 0x0d75, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/12 */
    { 0x0d7d, 0xa121, 0x0101, RTFLOAT80U_INIT_C(1,0x8000ffffffffffff,16414), INT16_MIN }, /* #137/3/14 */
    { 0x0047, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/0 */
    { 0x004f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/2 */
    { 0x0057, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/4 */
    { 0x005f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/6 */
    { 0x0067, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/8 */
    { 0x006f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/10 */
    { 0x0077, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/12 */
    { 0x007f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/0/14 */
    { 0x0447, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/0 */
    { 0x044f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/2 */
    { 0x0457, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/4 */
    { 0x045f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/6 */
    { 0x0467, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/8 */
    { 0x046f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/10 */
    { 0x0477, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/12 */
    { 0x047f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/1/14 */
    { 0x0847, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/0 */
    { 0x084f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/2 */
    { 0x0857, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/4 */
    { 0x085f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/6 */
    { 0x0867, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/8 */
    { 0x086f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/10 */
    { 0x0877, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/12 */
    { 0x087f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/2/14 */
    { 0x0c47, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/0 */
    { 0x0c4f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/2 */
    { 0x0c57, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/4 */
    { 0x0c5f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/6 */
    { 0x0c67, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/8 */
    { 0x0c6f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/10 */
    { 0x0c77, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/12 */
    { 0x0c7f, 0xb1b8, 0x0101, RTFLOAT80U_INIT_C(0,0x8001000000000000,16414), INT16_MIN }, /* #138/3/14 */
    { 0x0303, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/0 */
    { 0x030b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/2 */
    { 0x0313, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/4 */
    { 0x031b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/6 */
    { 0x0323, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/8 */
    { 0x032b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/10 */
    { 0x0333, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/12 */
    { 0x033b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/0/14 */
    { 0x0703, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/0 */
    { 0x070b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/2 */
    { 0x0713, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/4 */
    { 0x071b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/6 */
    { 0x0723, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/8 */
    { 0x072b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/10 */
    { 0x0733, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/12 */
    { 0x073b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/1/14 */
    { 0x0b03, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/0 */
    { 0x0b0b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/2 */
    { 0x0b13, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/4 */
    { 0x0b1b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/6 */
    { 0x0b23, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/8 */
    { 0x0b2b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/10 */
    { 0x0b33, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/12 */
    { 0x0b3b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/2/14 */
    { 0x0f03, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/0 */
    { 0x0f0b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/2 */
    { 0x0f13, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/4 */
    { 0x0f1b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/6 */
    { 0x0f23, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/8 */
    { 0x0f2b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/10 */
    { 0x0f33, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/12 */
    { 0x0f3b, 0x61b6, 0x4101, RTFLOAT80U_INIT_C(1,0x8001000000000000,16414), INT16_MIN }, /* #139/3/14 */
    { 0x0102, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/0 */
    { 0x010a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/2 */
    { 0x0112, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/4 */
    { 0x011a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/6 */
    { 0x0122, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/8 */
    { 0x012a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/10 */
    { 0x0132, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/12 */
    { 0x013a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/0/14 */
    { 0x0502, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/0 */
    { 0x050a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/2 */
    { 0x0512, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/4 */
    { 0x051a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/6 */
    { 0x0522, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/8 */
    { 0x052a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/10 */
    { 0x0532, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/12 */
    { 0x053a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/1/14 */
    { 0x0902, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/0 */
    { 0x090a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/2 */
    { 0x0912, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/4 */
    { 0x091a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/6 */
    { 0x0922, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/8 */
    { 0x092a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/10 */
    { 0x0932, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/12 */
    { 0x093a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/2/14 */
    { 0x0d02, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/0 */
    { 0x0d0a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/2 */
    { 0x0d12, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/4 */
    { 0x0d1a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/6 */
    { 0x0d22, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/8 */
    { 0x0d2a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/10 */
    { 0x0d32, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/12 */
    { 0x0d3a, 0x3e64, 0xbc81, RTFLOAT80U_INIT_C(0,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #140/3/14 */
    { 0x0242, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/0 */
    { 0x024a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/2 */
    { 0x0252, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/4 */
    { 0x025a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/6 */
    { 0x0262, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/8 */
    { 0x026a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/10 */
    { 0x0272, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/12 */
    { 0x027a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/0/14 */
    { 0x0642, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/0 */
    { 0x064a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/2 */
    { 0x0652, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/4 */
    { 0x065a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/6 */
    { 0x0662, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/8 */
    { 0x066a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/10 */
    { 0x0672, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/12 */
    { 0x067a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/1/14 */
    { 0x0a42, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/0 */
    { 0x0a4a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/2 */
    { 0x0a52, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/4 */
    { 0x0a5a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/6 */
    { 0x0a62, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/8 */
    { 0x0a6a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/10 */
    { 0x0a72, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/12 */
    { 0x0a7a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/2/14 */
    { 0x0e42, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/0 */
    { 0x0e4a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/2 */
    { 0x0e52, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/4 */
    { 0x0e5a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/6 */
    { 0x0e62, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/8 */
    { 0x0e6a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/10 */
    { 0x0e72, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/12 */
    { 0x0e7a, 0x9ef3, 0xbc81, RTFLOAT80U_INIT_C(1,0xfffffffffffffff0,16414), INT16_C(-3) }, /* #141/3/14 */
    { 0x0043, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/0 */
    { 0x004b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/2 */
    { 0x0053, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/4 */
    { 0x005b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/6 */
    { 0x0063, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/8 */
    { 0x006b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/10 */
    { 0x0073, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/12 */
    { 0x007b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/0/14 */
    { 0x0443, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/0 */
    { 0x044b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/2 */
    { 0x0453, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/4 */
    { 0x045b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/6 */
    { 0x0463, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/8 */
    { 0x046b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/10 */
    { 0x0473, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/12 */
    { 0x047b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/1/14 */
    { 0x0843, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/0 */
    { 0x084b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/2 */
    { 0x0853, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/4 */
    { 0x085b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/6 */
    { 0x0863, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/8 */
    { 0x086b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/10 */
    { 0x0873, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/12 */
    { 0x087b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/2/14 */
    { 0x0c43, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/0 */
    { 0x0c4b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/2 */
    { 0x0c53, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/4 */
    { 0x0c5b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/6 */
    { 0x0c63, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/8 */
    { 0x0c6b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/10 */
    { 0x0c73, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/12 */
    { 0x0c7b, 0x6ded, 0x4501, RTFLOAT80U_INIT_C(0,0x8000000000000000,16415), INT16_MIN }, /* #142/3/14 */
};
uint32_t const g_cTests_fistt_r80_to_i16_amd = RT_ELEMENTS(g_aTests_fistt_r80_to_i16_amd);


/* end of file */
