#line 10 "messagelexer.l"
/*
 * This file is part of Wireless Display Software for Linux OS
 *
 * Copyright (C) 2015 Intel Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include <stdint.h>

#define YY_NO_UNISTD_H 1



#line 30 "gen/messagescanner.cpp"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE message_restart(yyin ,yyscanner )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via message_restart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void message_restart (FILE *input_file ,yyscan_t yyscanner );
void message__switch_to_buffer (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
YY_BUFFER_STATE message__create_buffer (FILE *file,int size ,yyscan_t yyscanner );
void message__delete_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void message__flush_buffer (YY_BUFFER_STATE b ,yyscan_t yyscanner );
void message_push_buffer_state (YY_BUFFER_STATE new_buffer ,yyscan_t yyscanner );
void message_pop_buffer_state (yyscan_t yyscanner );

static void message_ensure_buffer_stack (yyscan_t yyscanner );
static void message__load_buffer_state (yyscan_t yyscanner );
static void message__init_buffer (YY_BUFFER_STATE b,FILE *file ,yyscan_t yyscanner );

#define YY_FLUSH_BUFFER message__flush_buffer(YY_CURRENT_BUFFER ,yyscanner)

YY_BUFFER_STATE message__scan_buffer (char *base,yy_size_t size ,yyscan_t yyscanner );
YY_BUFFER_STATE message__scan_string (yyconst char *yy_str ,yyscan_t yyscanner );
YY_BUFFER_STATE message__scan_bytes (yyconst char *bytes,int len ,yyscan_t yyscanner );

void *message_alloc (yy_size_t ,yyscan_t yyscanner );
void *message_realloc (void *,yy_size_t ,yyscan_t yyscanner );
void message_free (void * ,yyscan_t yyscanner );

#define yy_new_buffer message__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        message_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            message__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        message_ensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            message__create_buffer(yyin,YY_BUF_SIZE ,yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define message_wrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state (yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  ,yyscan_t yyscanner);
static int yy_get_next_buffer (yyscan_t yyscanner );
static void yy_fatal_error (yyconst char msg[] ,yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 82
#define YY_END_OF_BUFFER 83
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[1147] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   83,   81,
       11,    2,    3,    7,    6,    5,   10,   69,    9,    8,
        4,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       81,   81,   81,   81,   81,   81,   68,   68,   68,   68,
       68,   81,   68,   45,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   47,   48,   48,   48,

       48,   48,   48,   48,   48,   48,   48,   48,   48,   11,
        1,   69,    0,    0,   38,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   68,   68,
       68,   38,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,    0,    0,    0,    0,
        0,    0,    0,    0,   68,   68,   68,   68,   68,   68,
       68,    0,   68,   45,   46,   46,   46,   46,   46,   46,
       46,   46,   47,   48,   48,   48,   48,   48,   48,   48,

       48,   14,   15,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   37,    0,    0,
       14,   15,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   37,   68,   68,   68,
        0,    0,    0,    0,    0,    0,    0,    0,   68,   68,
       68,   68,   68,   68,   68,    0,   68,   14,   15,   14,
       15,   14,   15,   14,   15,    0,    0,    0,    0,    0,
        0,   25,    0,    0,    0,    0,   13,    0,    0,    0,

        0,   12,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   68,   68,   68,   68,   68,   68,   25,   68,   68,
       68,   68,   13,   68,   68,   68,   68,   12,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   70,    0,    0,
        0,    0,   75,    0,    0,    0,   68,   68,   68,   68,
       68,   68,   68,    0,   68,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   28,    0,   41,
       18,    0,    0,    0,    0,    0,    0,   39,    0,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       28,   68,   41,   68,   68,   68,   68,   68,   68,   68,

       68,   68,   68,   68,   68,   68,   68,   68,   68,   39,
       68,    0,    0,    0,   77,   74,    0,    0,   68,   68,
       68,   68,   68,   68,    0,   32,    0,   43,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   40,   32,   68,   43,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   40,    0,    0,    0,    0,
        0,   68,   68,   68,   68,    0,   42,   24,   33,   16,
       17,    0,    0,    0,    0,    0,    0,    0,   21,    0,

        0,    0,    0,    0,   42,   24,   33,   68,   68,   68,
       68,   68,   68,   21,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   59,   68,   68,   68,   68,
       68,   68,   68,    0,   71,    0,    0,    0,   68,   68,
       68,   68,    0,    0,    0,   36,    0,   31,   27,    0,
        0,    0,    0,    0,    0,    0,   68,   68,   36,   68,
       31,   27,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,    0,    0,    0,   76,   68,   68,   68,
        0,    0,    0,    0,   20,    0,    0,    0,   22,    0,

       44,   68,   68,   68,   68,   68,   22,   68,   44,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       58,   68,   68,   68,   68,    0,    0,    0,   68,   68,
        0,    0,    0,    0,    0,    0,    0,   30,    0,    0,
        0,   68,   68,   68,   30,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,    0,    0,    0,   68,   68,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   29,   68,   68,
       68,   68,   29,   68,   68,   68,   68,   68,   68,   68,

       68,   68,   68,   68,   65,   68,   68,   68,   68,    0,
        0,    0,   68,   68,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,    0,    0,    0,   68,
       68,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   34,    0,
       68,   68,   68,   34,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,

       73,    0,   72,   68,   68,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   35,    0,    0,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   78,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   68,   68,   68,   68,   68,   68,   68,   68,
       68,   68,   67,   68,   68,   68,   68,   68,   68,   68,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

       68,   68,   68,   49,   68,   68,   68,   68,   54,   53,
       68,   68,   68,   68,   68,   63,   68,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   26,    0,    0,   68,   68,   68,   68,   68,
       68,   68,   68,   68,   68,   68,   50,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   68,   68,   68,
       68,   66,   68,   68,   68,   68,   55,   68,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   19,   68,   68,

       68,   68,   68,   68,   68,   68,   62,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   23,   51,
       68,   57,   68,   68,   56,   68,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   68,   68,   68,
       68,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   68,   52,   68,   68,    0,   68,   68,   68,
        0,   68,   68,   68,    0,   68,   68,   68,    0,   68,
       61,   68,    0,   60,   68,    0,   68,    0,   64,    0,
        0,    0,    0,   79,   80,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    1,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   17,   17,   17,   18,   19,    1,
       20,    1,    1,    1,   21,   22,   23,   24,   25,   26,
       27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
       37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
        1,    1,    1,    1,   47,    1,   48,   49,   50,   51,

       52,   53,   54,   55,   56,   57,   58,   59,   60,   61,
       62,   63,   64,   65,   66,   67,   68,   69,   70,   44,
       71,   72,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[73] =
    {   0,
        1,    2,    3,    4,    2,    1,    1,    5,    1,    1,
        6,    6,    6,    6,    6,    6,    6,    1,    1,    1,
        6,    6,    6,    6,    6,    6,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    6,    6,    6,
        6,    6,    6,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5
    } ;

static yyconst flex_int16_t yy_base[1154] =
    {   0,
        0,   72,  142,  145,  148,  150,  129,  131,    0,    0,
        0,    0,  117,  119,  188,  231,  274,  317, 1671, 4324,
      157, 4324, 1667, 4324, 4324, 4324, 4324,  161, 4324, 4324,
     4324,  158,  121,  159,  160,  156,  197,  320,  189,  189,
      206,  196,  310,  198,  239,  253,  321,  195,  206,  236,
      287,  227,  254,  247,  275,    0,  296,  323,  319,  319,
      330,  320,  322,  323,  326,  335,  367,  320,  368,  364,
        0,  370,  362,  378,  376,  378,  379,  371,  417,  404,
      387,  417,  421,  300,  427,  374,  426,  422,  419,    0,
      478,  475,  460,  484,  488,  464,  539,  495,  419,  449,

      477,  483,    0,  546,  525,  516,  553,  556,  557,  213,
     4324,  572,  497, 1655, 4324,  548,  552,  572,  576,  577,
      578,  585,  568,  569,  593,  595,  590,  616,  587,  597,
      595,  594,  608,  598,  597,  612, 1660,  608,    0,  618,
     1646,    0,  611,  606,  626,  617,  631,  640,  639,  622,
      624,  647,  649,  644,  671,  642,  653,  651,  649,  663,
      653,  652,  667,  670, 1610,  669, 1555,  685,  659,  674,
      663,  685,  687,  687,  700,  678,  693,  681,  708,  713,
      709,  702,  719,  758,    0,  727, 1544,  726,  739,  755,
      767,  771,  784,    0,  741, 1540,  746,  786,  787,  797,

      791, 4324, 4324,  777,  792,  794,  797,  783,  789,  803,
      789,  787,  791,  810,  800,  813,  803,  804,  807,  823,
      816,  825,  826, 1543,  827,  836,  828, 4324,  840,  845,
        0,    0,  843,  849,  850,  849,  836,  841,  855,  841,
      839,  842,  860,  851,  861,  848,  852,  857,  873,  860,
      869,  875, 1542,  877,  888,  880,    0, 1494,  891,  896,
     1462, 1417,  891, 1454,  882,  879,  881,  888, 1415,  901,
     1390,  892,  888,  893,  897,  900,  902,    0,    0,  931,
      943,    0,    0,  946,  947,  908,  929,  923,  918,  919,
     1351, 1012,  950,  932,  934,  940, 4324, 1026,  951,  948,

      944, 4324, 1020,  963,  945,  965,  954,  957,  955,  963,
      975,  967,  984,  976,  971,  969, 1025,  984,  993,  978,
      980,  986,    0,  921,  997,  994,  988,    0,  912, 1004,
      986,  994,  997,  995, 1044, 1005, 1014, 4324, 1006, 1008,
     1001, 1029, 4324, 1024, 1026, 1039, 1028, 1037, 1049,    0,
     1039, 1040, 1053,  775,  766, 1057, 1047, 1063, 1064, 1058,
      774, 1074, 1060,  701, 1079, 1093, 1080, 4324, 1077, 4324,
     4324, 1080, 1094, 1079, 1098, 1101, 1089, 4324, 1103, 1108,
     1098, 1106, 1103, 1095,  735, 1111, 1098,  696, 1108, 1117,
        0, 1099,    0, 1102, 1117, 1123, 1125, 1113, 1128, 1129,

     1140, 1133, 1160, 1130, 1141, 1140, 1143, 1153, 1154,    0,
     1160, 1165, 1153, 1162, 4324, 4324, 1169, 1156, 1171, 1159,
        0,    0, 1173, 1161,  732, 4324, 1175, 4324, 1178, 1179,
      175, 1184, 1181, 1193, 1199, 1186, 1193, 1191, 1184, 1207,
     1198, 1214, 1196, 1197, 4324,    0, 1213,    0, 1216, 1215,
     1220, 1217, 1221, 1222, 1208, 1212, 1205, 1225, 1233, 1216,
     1218,  651, 1235,  619, 1231, 1236, 1239, 1256, 1242, 1257,
     1243, 1267, 1260, 1268, 1267,    0, 1254, 1254, 1273, 1257,
     1253, 1260, 1260, 1262, 1258,  613, 4324,  565, 4324, 4324,
     4324, 1266, 1279, 1287, 1279, 1288, 1292, 1273, 4324, 1289,

      531, 1293, 1297, 1308,    0,  488,    0, 1298, 1312, 1317,
     1311, 1319, 1303,    0, 1310, 1308, 1312, 1323, 1307, 1321,
     1326, 1328, 1322, 1318, 1319,    0,  477, 1352, 1317, 1332,
     1340, 1345, 1360, 1365, 4324,  512, 1366, 1354, 1369,    0,
     1371, 1362,    0, 1374,  472, 4324, 1358, 4324, 4324, 1355,
     1378, 1368, 1362, 1361, 1363, 1383, 1385,  424,    0, 1369,
        0,    0, 1387, 1377, 1371, 1379, 1397, 1393, 1392, 1398,
     1405, 1415, 1416, 1411, 1412, 1407, 1421, 1425, 1426, 1428,
     1426,  421, 1420, 1423, 1414, 1425, 4324, 1426, 1428,    0,
     1478, 1448, 1442, 1450, 4324, 1448, 1441, 1463, 4324, 1474,

     4324, 1477, 1467, 1475, 1476, 1465,    0, 1483,    0, 1483,
      420, 1471, 1470, 1488, 1478, 1488, 1494, 1491, 1479, 1484,
        0, 1497, 1495, 1512,  419, 1496, 1496, 1498, 1503, 1504,
     1552, 1568, 1577, 1586, 1494, 1531, 1569, 4324, 1566, 1569,
     1578, 1571, 1579, 1582,    0, 1572, 1583, 1587, 1590, 1581,
      417, 1575, 1576, 1593, 1574, 1583, 1583, 1582, 1579, 1587,
     1605, 1602, 1602, 1589, 1606, 1606, 1611, 1618, 1559, 1650,
     1675, 1684, 1693, 1702, 1711, 1720, 1729, 1738, 1747, 1756,
     1765, 1774,  416, 1637, 1659, 1677,  443, 4324,  411, 1691,
     1713, 1731,    0, 1749, 1757, 1773, 1757, 1761,  407,  371,

      368, 1756, 1773, 1778,  364,  359, 1764, 1761, 1767, 1778,
      307, 1779, 1780, 1781, 1801, 1825, 1834, 1843, 1852, 1861,
     1870, 1879, 1888, 1897, 1906, 1915, 1924, 1933, 1942, 1951,
     1960, 1776, 1804, 1815, 1830, 1857, 1875, 1876, 1914, 1929,
      271, 1946, 1938, 1940, 1943, 1946, 1944, 1959, 1960, 1962,
     1947, 1951, 1957, 1970, 1952, 1955, 1956,  298, 1957, 1958,
     1960, 2015, 2024, 2033, 2042, 2051, 2060, 2069, 2078, 2087,
     2096, 2105, 2114, 2123, 2132, 2005,  286, 2079, 4324, 2009,
     2023,  253, 2088,    0, 2062, 2117,  225, 2115,  224, 2114,
     2124, 2130, 2116,  223, 2127, 2132, 2133, 2138, 2132, 2129,

     4324,  258, 4324,    0,    0, 2159, 2181, 2190, 2199, 2208,
     2217, 2226, 2235, 2244, 2253, 2262, 2271, 2280, 2289, 2298,
     2307, 2316, 2125, 4324,  221, 2171, 2170,  219, 2183, 2231,
     2240,  217, 2232, 2273, 2283, 2297, 2294, 2312, 2302, 2299,
     2299, 2311, 2307, 2321, 4324, 2334, 2343, 2361, 2370, 2379,
     2388, 2397, 2406, 2415, 2424, 2433, 2442, 2451, 2460, 2322,
     2339, 2357, 2376, 2393, 2396, 2431, 2450, 2443, 2436, 2442,
     2452, 2460,    0, 2456, 2452, 2446, 2460, 2457, 2463, 2451,
     2510, 2520, 2530, 2540, 2487, 2550, 2559, 2568, 2577, 2586,
     2595, 2604, 2613, 2622, 2631, 2640, 2649,  243, 2531, 2548,

      210, 2549, 2581,    0, 2602, 2597, 2631, 2643,    0,    0,
     2630,  182, 2637, 2636, 2643,    0, 2634, 2663, 2670, 2698,
     2708, 2725, 2735, 2745, 2755, 2765, 2775, 2785, 2795, 2805,
     2815, 2825, 4324, 2662, 2663, 2664, 2683, 2671, 2806, 2820,
     2823, 2811, 2807, 2824, 2826, 2811,    0, 2841, 2870, 2886,
     2895, 2904, 2913, 2923, 2933, 2943, 2953, 2963, 2973, 2983,
     2993, 3003, 3013, 3023, 3033, 2821, 2822, 2823, 2824, 2838,
     2826,    0, 3012, 3021, 3016,  181,    0, 3011, 3046, 3074,
     3089, 3098, 3107, 3116, 3125, 3134, 3143, 3152, 3161, 3170,
     3179, 3188, 3197, 3206, 3215, 3224,  207, 4324,  206, 3026,

     3041, 3028, 3039, 3048, 3210, 3220,    0, 3060, 3235, 3244,
     3262, 3271, 3280, 3289, 3298, 3307, 3316, 3325, 3334, 3343,
     3352, 3361, 3370, 3379, 3388, 3397, 3406, 3415, 3424, 3433,
     3442, 3451, 3460, 3469, 3478, 3487, 3496, 3505, 4324,    0,
      178,    0, 3488, 3480,    0, 3505, 3518, 3527, 3545, 3554,
     3563, 3572, 3581, 3590, 3599, 3608, 3617, 3626, 3635, 3644,
     3653, 3662, 3671, 3680, 3689, 3698, 3707, 3716, 3725, 3734,
     3743, 3752, 3761, 3770, 3779, 3788, 3797, 3775, 3782,  174,
     3781, 3251, 3809, 3818, 3836, 3845, 3854, 3863, 3872, 3881,
     3890, 3899, 3908, 3917, 3926, 3935, 3944, 3953, 3962, 3971,

     3980, 3989, 3998, 4007, 4016, 4025, 4034, 4043, 4052, 4061,
     4070, 4079, 4068,    0, 4065, 4078, 4091, 4076, 4075, 4089,
     4101, 4090, 4096, 4092, 4116, 4088, 4098, 4102, 4157, 4108,
        0, 4110, 4164,    0, 4115, 4185, 4113, 4196,    0, 4223,
     4230, 4246, 4256, 4271, 4280, 4324, 4297, 4303, 4305, 4311,
      214,  213, 4317
    } ;

static yyconst flex_int16_t yy_def[1154] =
    {   0,
     1146, 1146, 1147, 1147, 1148, 1148,    1,    2,    1,    2,
        1,    2,    1,    2,    1,    2,    1,    2, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1150, 1146, 1146, 1146, 1146, 1146, 1149, 1149, 1149, 1149,
     1149, 1146, 1149, 1151, 1151, 1151, 1151, 1151, 1151, 1151,
     1149,   91,   91,   91,   91,   91, 1152, 1152, 1152, 1152,

     1152, 1152, 1152,   91,  104,  104,  104,  104,  104, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1150, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1146, 1149, 1151, 1151, 1151, 1151, 1151,   91,   91,
       91,   91, 1152, 1152, 1152, 1152, 1152,  104,  104,  104,

      104, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1146, 1149, 1151, 1151,   91,
       91, 1152, 1152,  104,  104, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,

     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1146, 1149, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,

     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1149, 1149,
     1149, 1149, 1149, 1149, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1146, 1146, 1146, 1146,
     1146, 1149, 1149, 1149, 1149, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,

     1146, 1146, 1146, 1146, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1146, 1146, 1146, 1146, 1146, 1149, 1149,
     1149, 1149, 1153, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1146, 1146, 1146, 1146, 1149, 1149, 1149,
     1153, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,

     1146, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1146, 1146, 1146, 1149, 1149,
     1153, 1153, 1153, 1153, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1146, 1146, 1146, 1149, 1149, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1146, 1146, 1146, 1146, 1146, 1146, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,

     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1146,
     1146, 1146, 1149, 1149, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1146, 1146, 1146, 1146, 1146, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1146, 1146, 1146, 1149,
     1149, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1146, 1146, 1146, 1146, 1146,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,

     1146, 1146, 1146, 1149, 1149, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1146, 1146, 1146, 1146, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1146, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1146,
     1146, 1146, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1146, 1146, 1146,

     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1146, 1146, 1146, 1149, 1149, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1146, 1146, 1149, 1149, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1146, 1146, 1149, 1149,

     1149, 1149, 1149, 1149, 1149, 1149, 1149, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1146, 1149,
     1149, 1149, 1149, 1149, 1149, 1149, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1149, 1149, 1149,
     1149, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,

     1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153, 1153,
     1153, 1153, 1149, 1149, 1149, 1149, 1153, 1149, 1149, 1149,
     1153, 1149, 1149, 1149, 1153, 1149, 1149, 1149, 1153, 1149,
     1149, 1149, 1153, 1149, 1149, 1153, 1149, 1153, 1149, 1153,
     1153, 1153, 1153, 1153, 1153,    0, 1146, 1146, 1146, 1146,
     1146, 1146, 1146
    } ;

static yyconst flex_int16_t yy_nxt[4397] =
    {   0,
       20,   21,   22,   23,   21,   24,   25,   26,   20,   27,
       28,   28,   28,   28,   28,   28,   28,   29,   30,   31,
       32,   33,   34,   35,   36,   20,   37,   38,   39,   40,
       41,   42,   43,   44,   20,   45,   20,   46,   47,   20,
       48,   20,   49,   20,   20,   50,   20,   32,   33,   34,
       35,   36,   20,   37,   38,   39,   40,   41,   42,   43,
       44,   20,   45,   20,   46,   47,   20,   48,   20,   49,
       20,   50,   20,   21,   22,   23,   21,   24,   25,   26,
       20,   27,   28,   28,   28,   28,   28,   28,   28,   29,
       30,   31,   51,   52,   53,   54,   55,   56,   57,   58,

       59,   60,   61,   62,   63,   64,   56,   65,   56,   66,
       67,   56,   68,   56,   69,   56,   56,   70,   20,   51,
       52,   53,   54,   55,   56,   57,   58,   59,   60,   61,
       62,   63,   64,   56,   65,   56,   66,   67,   56,   68,
       56,   69,   56,   70,   22,   23,   20,   22,   23,   20,
       22,   23,   22,   23,   82,   72,   83,   77,  110,   20,
      115,  110,   20,   73,   74,   78,   79,   75,   76,   80,
       81,  112,  112,  112,  112,  112,  112,  112,  113,  116,
      114,   82,   72,   83,   77,  490,  491,  115,  117,  118,
       73,   74,   78,   79,   75,   76,   80,   81,   84,   84,

       84,   84,   84,   84,   84,  113,  116,  114,   85,   86,
       87,   88,   89,   90,  110,  117,  118,  110,  194,  185,
     1115,  119,  122,  123, 1078, 1039, 1039, 1006,  943,  933,
      124,  125,  128,  136,  137,   85,   86,   87,   88,   89,
       90,   84,   84,   84,   84,   84,   84,   84,  119,  122,
      123,   91,   92,   93,   94,   95,   96,  124,  125,  128,
      136,  137,  933,  868,  138,  864,  142,  861,  845,  838,
      833,  831,  824,  129,  143,  144,  130,  131,   91,   92,
       93,   94,   95,   96,   97,   97,   97,   97,   97,   97,
       97,  138,  132,  142,   98,   99,  100,  101,  102,  103,

      129,  143,  144,  130,  131,  824,  802,  140,  145,  141,
      184,  184,  184,  184,  184,  184,  184,  785,  758,  132,
      146,   98,   99,  100,  101,  102,  103,   97,   97,   97,
       97,   97,   97,   97,  140,  145,  141,  104,  105,  106,
      107,  108,  109,  120,  126,  133,  147,  146,  121,  134,
      127,  148,  149,  150,  151,  152,  153,  155,  163,  158,
      156,  135,  154,  157,  104,  105,  106,  107,  108,  109,
      120,  126,  133,  147,  159,  121,  134,  127,  148,  149,
      150,  151,  152,  153,  155,  163,  158,  156,  135,  154,
      157,  160,  166,  164,  168,  161,  165,  169,  171,  170,

      173,  159,  174,  175,  134,  753,  176,  162,  177,  172,
      752,  181,  129,  115,  748,  130,  135,  747,  160,  166,
      164,  168,  161,  165,  169,  171,  170,  173,  180,  174,
      175,  134,  161,  176,  162,  177,  172,  178,  181,  129,
      115,  131,  130,  135,  162,  158,  188,  186,  179,  187,
      117,  156,  118,  746,  157,  180,  182,  737,  115,  161,
      183,  736,  732,  697,  178,  663,  649,  624,  131,  197,
      603,  162,  158,  188,  186,  179,  187,  117,  156,  118,
      192,  157,  189,  182,  189,  115,  189,  183,  189,  189,
      189,  189,  189,  189,  189,  189,  197,  189,  190,  189,

      191,  189,  189,  189,  189,  117,  189,  192,  189,  189,
      189,  189,  144,  189,  142,  195,  118,  196,  593,  202,
      585,  145,  189,  576,  189,  190,  189,  191,  189,  189,
      189,  189,  117,  189,  557,  189,  201,  189,  198,  144,
      553,  142,  195,  118,  196,  198,  202,  198,  145,  193,
      193,  193,  193,  193,  193,  193,  198,  198,  198,  198,
      198,  198,  198,  201,  142,  198,  199,  198,  200,  198,
      198,  198,  198,  198,  198,  198,  198,  198,  198,  198,
      204,  144,  112,  112,  112,  112,  112,  112,  112,  145,
      205,  142,  206,  199,  198,  200,  198,  198,  198,  209,

      198,  210,  198,  198,  198,  198,  198,  204,  144,  207,
      211,  544,  213,  214,  208,  215,  145,  205,  216,  206,
      212,  218,  543,  219,  221,  222,  209,  223,  210,  224,
      225,  226,  227,  228,  230,  217,  207,  211,  213,  214,
      231,  208,  215,  233,  234,  216,  235,  212,  218,  220,
      236,  221,  222,  238,  223,  237,  224,  225,  226,  227,
      228,  230,  217,  239,  240,  521,  242,  231,  243,  244,
      233,  234,  245,  235,  241,  247,  220,  236,  248,  250,
      238,  251,  237,  252,  253,  254,  255,  256,  257,  246,
      239,  240,  242,  258,  243,  260,  244,  519,  263,  245,

      264,  241,  247,  265,  249,  266,  250,  268,  251,  225,
      252,  253,  254,  255,  256,  257,  246,  270,  207,  271,
      258,  272,  260,  208,  262,  263,  267,  264,  273,  275,
      265,  249,  266,  236,  268,  254,  225,  224,  237,  269,
      276,  486,  453,  431,  270,  207,  271,  434,  272,  278,
      208,  262,  274,  267,  253,  273,  275,  277,  204,  189,
      236,  189,  254,  282,  224,  237,  269,  276,  184,  184,
      184,  184,  184,  184,  184,  189,  278,  280,  204,  274,
      281,  253,  431,  425,  277,  204,  189,  189,  189,  189,
      282,  189,  425,  189,  193,  193,  193,  193,  193,  193,

      193,  286,  189,  233,  280,  204,  198,  198,  198,  284,
      285,  198,  287,  198,  189,  288,  189,  198,  189,  198,
      189,  289,  290,  233,  291,  292,  293,  294,  286,  295,
      233,  296,  297,  198,  198,  198,  284,  298,  198,  287,
      198,  299,  288,  300,  198,  301,  198,  302,  289,  290,
      233,  291,  292,  293,  294,  303,  295,  304,  296,  297,
      305,  307,  308,  309,  298,  310,  311,  312,  299,  313,
      300,  314,  301,  315,  302,  316,  317,  318,  319,  320,
      321,  322,  303,  323,  304,  324,  325,  305,  307,  308,
      309,  326,  310,  311,  312,  327,  313,  328,  314,  329,

      315,  330,  316,  317,  318,  319,  320,  321,  322,  331,
      323,  332,  324,  325,  333,  334,  336,  337,  326,  340,
      342,  344,  327,  343,  328,  346,  329,  345,  330,  348,
      349,  371,  350,  351,  353,  354,  331,  355,  332,  352,
      367,  333,  334,  336,  337,  356,  340,  342,  344,  343,
      357,  189,  346,  189,  358,  359,  348,  349,  350,  360,
      351,  353,  354,  189,  355,  189,  198,  198,  198,  198,
      363,  364,  356,  365,  366,  368,  369,  357,  189,  370,
      189,  358,  359,  372,  373,  374,  360,  375,  376,  377,
      189,  378,  189,  198,  198,  198,  198,  363,  364,  379,

      365,  366,  368,  369,  380,  381,  370,  382,  383,  384,
      372,  373,  374,  387,  375,  376,  377,  388,  378,  389,
      390,  391,  392,  393,  394,  395,  379,  396,  397,  398,
      386,  380,  381,  410,  382,  383,  384,  385,  411,  371,
      387,  412,  413,  414,  388,  367,  389,  390,  391,  392,
      393,  394,  395,  415,  396,  397,  398,  399,  362,  416,
      410,  417,  418,  419,  400,  411,  401,  402,  412,  413,
      414,  420,  403,  421,  422,  423,  424,  426,  427,  404,
      415,  405,  406,  407,  408,  409,  416,  428,  417,  418,
      419,  400,  429,  401,  402,  430,  432,  433,  420,  403,

      421,  422,  423,  424,  426,  427,  404,  435,  405,  406,
      407,  408,  409,  436,  428,  437,  438,  439,  440,  429,
      441,  442,  430,  432,  433,  443,  444,  445,  446,  447,
      448,  449,  450,  451,  435,  452,  454,  455,  456,  457,
      436,  458,  437,  438,  439,  440,  459,  441,  442,  460,
      461,  462,  443,  444,  445,  446,  447,  448,  449,  450,
      451,  467,  452,  454,  455,  456,  457,  470,  458,  463,
      464,  465,  468,  459,  466,  471,  460,  461,  462,  472,
      473,  474,  475,  469,  476,  477,  478,  479,  467,  480,
      481,  482,  483,  484,  470,  485,  463,  464,  465,  487,

      488,  466,  471,  489,  492,  493,  472,  473,  474,  475,
      469,  476,  477,  478,  479,  494,  480,  481,  482,  483,
      484,  495,  485,  496,  497,  498,  487,  488,  499,  500,
      489,  492,  493,  501,  502,  503,  504,  505,  506,  507,
      508,  509,  494,  510,  511,  512,  513,  515,  495,  514,
      496,  497,  498,  516,  499,  517,  500,  518,  520,  522,
      501,  502,  503,  504,  505,  506,  507,  508,  509,  523,
      510,  511,  512,  513,  515,  514,  524,  525,  526,  527,
      516,  528,  517,  529,  518,  520,  522,  530,  531,  532,
      533,  534,  535,  536,  537,  538,  523,  539,  540,  541,

      542,  545,  546,  524,  525,  526,  527,  547,  528,  548,
      529,  549,  550,  551,  530,  531,  532,  533,  534,  535,
      536,  537,  538,  552,  539,  540,  541,  542,  545,  546,
      554,  555,  556,  558,  547,  559,  548,  560,  549,  550,
      551,  561,  562,  563,  564,  565,  566,  567,  568,  569,
      552,  570,  571,  574,  575,  572,  579,  554,  555,  556,
      558,  573,  559,  361,  560,  580,  581,  582,  561,  562,
      563,  564,  565,  566,  567,  568,  569,  577,  570,  571,
      574,  575,  572,  579,  583,  584,  586,  587,  573,  588,
      578,  589,  580,  581,  582,  590,  592,  594,  341,  595,

      596,  597,  598,  600,  577,  599,  601,  602,  604,  605,
      606,  583,  584,  586,  587,  607,  588,  578,  589,  608,
      609,  610,  590,  592,  594,  595,  611,  596,  597,  598,
      600,  599,  612,  601,  602,  604,  605,  606,  613,  614,
      615,  607,  616,  617,  618,  619,  608,  609,  610,  620,
      621,  622,  623,  611,  625,  626,  627,  628,  629,  612,
      630,  347,  341,  339,  338,  613,  614,  615,  635,  616,
      617,  618,  619,  636,  637,  638,  620,  621,  622,  623,
      639,  625,  626,  627,  628,  629,  640,  630,  631,  632,
      633,  634,  634,  634,  634,  635,  641,  642,  643,  644,

      636,  637,  638,  645,  646,  647,  648,  639,  650,  651,
      652,  653,  654,  640,  655,  656,  657,  658,  659,  660,
      664,  665,  666,  641,  642,  643,  644,  667,  668,  683,
      645,  646,  647,  648,  661,  650,  651,  652,  653,  654,
      335,  655,  656,  657,  658,  659,  660,  664,  665,  666,
      662,  306,  306,  283,  667,  668,  683,  279,  261,  684,
      669,  661,  631,  632,  633,  634,  634,  634,  634,  715,
      716,  717,  718,  718,  718,  718,  669,  662,  670,  671,
      672,  673,  673,  673,  673,  669,  684,  674,  675,  676,
      677,  677,  678,  679,  669,  685,  680,  681,  682,  679,

      679,  679,  679,  686,  687,  688,  689,  690,  691,  692,
      693,  694,  695,  696,  698,  699,  700,  259,  701,  702,
      703,  704,  685,  705,  706,  707,  708,  709,  710,  711,
      686,  687,  688,  689,  690,  691,  692,  693,  694,  695,
      696,  698,  699,  700,  701,  712,  702,  703,  704,  705,
      713,  706,  707,  708,  709,  710,  711,  714,  669,  232,
      680,  681,  682,  679,  679,  679,  679,  229,  203,  111,
     1146, 1146,  712, 1146, 1146,  733, 1146,  713, 1146, 1146,
     1146, 1146, 1146,  669,  714,  719,  720,  721,  722,  722,
      722,  722,  669,  734,  723,  724,  725,  726,  726,  727,

      728,  669,  733,  729,  730,  731,  728,  728,  728,  728,
      669,  735,  680,  681,  682,  679,  679,  679,  679,  669,
      734,  719,  720,  721,  722,  722,  722,  722,  669,  738,
      723,  724,  725,  726,  726,  727,  728,  669,  735,  729,
      730,  731,  728,  728,  728,  728,  669,  739,  729,  730,
      731,  728,  728,  728,  679,  669,  738,  680,  681,  682,
      679,  679,  679,  679,  669,  740,  631,  632,  633,  634,
      634,  634,  634,  669,  739,  670,  671,  672,  673,  673,
      673,  673,  669,  741,  674,  675,  676,  677,  677,  678,
      679,  742,  740,  743,  744,  745,  749,  750,  751,  754,

      755,  756,  757,  759,  760,  761, 1146,  776, 1146,  762,
      741,  631,  632,  633,  634,  634,  634,  634,  742, 1146,
      743,  744,  745,  749,  750,  751,  754,  755,  756,  757,
      759,  760,  761,  762,  776,  763,  764,  765,  766,  766,
      766,  766,  762,  777,  767,  768,  769,  770,  770,  771,
      772,  762,  778,  773,  774,  775,  772,  772,  772,  772,
      669,  779,  680,  681,  682,  679,  679,  679,  679,  669,
      777,  719,  720,  721,  722,  722,  722,  722,  669,  778,
      723,  724,  725,  726,  726,  727,  728,  669,  779,  729,
      730,  731,  728,  728,  728,  728,  669,  780,  680,  681,

      682,  679,  679,  679,  679,  669,  781,  719,  720,  721,
      722,  722,  722,  722,  669,  782,  723,  724,  725,  726,
      726,  727,  728,  669,  780,  729,  730,  731,  728,  728,
      728,  728,  669,  781,  729,  730,  731,  728,  728,  728,
      679,  669,  782,  680,  681,  682,  679,  679,  679,  679,
      669,  783,  631,  632,  633,  634,  634,  634,  634,  669,
      784,  670,  671,  672,  673,  673,  673,  673,  669,  786,
      674,  675,  676,  677,  677,  678,  679,  787,  783,  788,
      789,  790,  791,  792,  793,  794,  795,  784,  796,  797,
      798,  799,  800,  801,  803,  804,  786,  805, 1146, 1146,

     1146, 1146, 1146, 1146,  787, 1146,  788,  789,  790,  791,
      792,  793,  794,  795, 1146,  796,  797,  798,  799,  800,
      801,  803,  804, 1146,  805,  806,  807,  808,  809,  809,
      809,  809,  762,  823,  773,  774,  775,  772,  772,  772,
      772,  762,  826,  810,  811,  812,  813,  813,  813,  813,
      762,  827,  814,  815,  816,  817,  817,  818,  819,  762,
      823,  820,  821,  822,  819,  819,  819,  819,  762,  826,
      773,  774,  775,  772,  772,  772,  772,  762,  827,  810,
      811,  812,  813,  813,  813,  813,  762,  829,  814,  815,
      816,  817,  817,  818,  819,  762, 1146,  820,  821,  822,

      819,  819,  819,  819,  762, 1146,  820,  821,  822,  819,
      819,  819,  679,  762,  829,  680,  681,  682,  679,  679,
      679,  679,  762,  825,  631,  632,  633,  634,  634,  634,
      634,  762,  828,  670,  671,  672,  673,  673,  673,  673,
      762,  830,  674,  675,  676,  677,  677,  678,  679,  825,
      832,  834,  835,  836,  837,  839,  840,  841,  828,  842,
      843,  844, 1146,  860, 1146, 1146, 1146,  846,  830,  631,
      632,  633,  634,  634,  634,  634, 1146,  832,  834,  835,
      836,  837,  839,  840,  841, 1146,  842,  843,  844,  846,
      860,  847,  848,  849,  850,  850,  850,  850,  846,  862,

      851,  852,  853,  854,  854,  855,  856,  846,  863,  857,
      858,  859,  856,  856,  856,  856,  762,  865,  680,  681,
      682,  679,  679,  679,  679,  762,  862,  719,  720,  721,
      722,  722,  722,  722,  762,  863,  723,  724,  725,  726,
      726,  727,  728,  762,  865,  729,  730,  731,  728,  728,
      728,  728,  762,  866,  680,  681,  682,  679,  679,  679,
      679,  762,  867,  719,  720,  721,  722,  722,  722,  722,
      762,  869,  723,  724,  725,  726,  726,  727,  728,  762,
      866,  729,  730,  731,  728,  728,  728,  728,  762,  867,
      729,  730,  731,  728,  728,  728,  679,  762,  869,  680,

      681,  682,  679,  679,  679,  679,  762,  870,  631,  632,
      633,  634,  634,  634,  634,  762,  871,  670,  671,  672,
      673,  673,  673,  673,  762,  872,  674,  675,  676,  677,
      677,  678,  679,  873,  870,  874,  875,  876,  877,  878,
      879,  880, 1146,  871,  881,  882,  883,  884,  884,  884,
      884,  846,  872,  857,  858,  859,  856,  856,  856,  856,
      873,  898,  874,  875,  876,  877,  878,  879,  880,  846,
      899,  885,  886,  887,  888,  888,  888,  888,  846,  900,
      889,  890,  891,  892,  892,  893,  894,  846,  898,  895,
      896,  897,  894,  894,  894,  894,  846,  899,  857,  858,

      859,  856,  856,  856,  856,  846,  900,  885,  886,  887,
      888,  888,  888,  888,  846,  901,  889,  890,  891,  892,
      892,  893,  894,  846,  902,  895,  896,  897,  894,  894,
      894,  894,  846,  903,  895,  896,  897,  894,  894,  894,
      679,  846,  901,  680,  681,  682,  679,  679,  679,  679,
      846,  902,  631,  632,  633,  634,  634,  634,  634,  846,
      903,  670,  671,  672,  673,  673,  673,  673,  846,  904,
      674,  675,  676,  677,  677,  678,  679,  905,  906, 1146,
      907,  908,  909,  910,  911,  912,  913,  914,  915,  916,
      917, 1146, 1146, 1146, 1146,  846,  904,  680,  681,  682,

      679,  679,  679,  679,  905,  906,  907, 1146,  908,  909,
      910,  911,  912,  913,  914,  915,  916,  917,  846,  918,
      631,  632,  633,  634,  634,  634,  634,  919,  846,  918,
      920,  921,  922,  923,  923,  923,  923,  919,  846,  918,
      924,  925,  926,  927,  927,  928,  929,  919,  846,  918,
      930,  931,  932,  929,  929,  929,  929,  919,  846,  934,
      719,  720,  721,  722,  722,  722,  722,  846,  935,  723,
      724,  725,  726,  726,  727,  728,  846,  936,  729,  730,
      731,  728,  728,  728,  728,  846,  934,  680,  681,  682,
      679,  679,  679,  679,  846,  935,  719,  720,  721,  722,

      722,  722,  722,  846,  936,  723,  724,  725,  726,  726,
      727,  728,  846,  937,  729,  730,  731,  728,  728,  728,
      728,  846,  938,  729,  730,  731,  728,  728,  728,  679,
      846,  939,  680,  681,  682,  679,  679,  679,  679,  846,
      937,  631,  632,  633,  634,  634,  634,  634,  846,  938,
      670,  671,  672,  673,  673,  673,  673,  846,  939,  674,
      675,  676,  677,  677,  678,  679,  940,  941,  942,  944,
      945,  946,  947,  631,  632,  633,  634,  634,  634,  634,
      949,  950,  951,  952,  952,  952,  952, 1146, 1146, 1146,
     1146, 1146, 1146,  940,  941,  942,  944,  945,  946,  947,

      966,  967,  968,  969,  970,  948,  846,  918,  930,  931,
      932,  929,  929,  929,  929,  919,  846,  918,  953,  954,
      955,  956,  956,  956,  956,  919, 1146,  966,  967,  968,
      969,  970,  948,  846,  918,  957,  958,  959,  960,  960,
      961,  962,  919,  846,  918,  963,  964,  965,  962,  962,
      962,  962,  919,  846,  918,  930,  931,  932,  929,  929,
      929,  929,  919,  846,  918,  953,  954,  955,  956,  956,
      956,  956,  919,  846,  918,  957,  958,  959,  960,  960,
      961,  962,  919,  846,  918,  963,  964,  965,  962,  962,
      962,  962,  919,  846,  918,  963,  964,  965,  962,  962,

      962,  679,  919,  846,  918,  680,  681,  682,  679,  679,
      679,  679,  919,  846,  918,  631,  632,  633,  634,  634,
      634,  634,  919,  846,  918,  670,  671,  672,  673,  673,
      673,  673,  919,  846,  918,  674,  675,  676,  677,  677,
      678,  679,  919,  971,  972,  973,  974,  975,  976,  977,
      978,  631,  632,  633,  634,  634,  634,  634, 1146, 1146,
      997,  998,  999, 1000, 1001, 1002,  979, 1146, 1146, 1146,
      971,  972,  973,  974,  975,  976,  977,  978,  669,  918,
      980,  981,  982,  983,  983,  983,  983,  997,  998,  999,
     1000, 1001, 1002,  979,  669,  918,  984,  985,  986,  987,

      987,  987,  987,  669,  918,  988,  989,  990,  991,  991,
      992,  993,  669,  918,  994,  995,  996,  993,  993,  993,
      993,  846,  918,  680,  681,  682,  679,  679,  679,  679,
      919,  846,  918,  719,  720,  721,  722,  722,  722,  722,
      919,  846,  918,  723,  724,  725,  726,  726,  727,  728,
      919,  846,  918,  729,  730,  731,  728,  728,  728,  728,
      919,  846,  918,  680,  681,  682,  679,  679,  679,  679,
      919,  846,  918,  719,  720,  721,  722,  722,  722,  722,
      919,  846,  918,  723,  724,  725,  726,  726,  727,  728,
      919,  846,  918,  729,  730,  731,  728,  728,  728,  728,

      919,  846,  918,  729,  730,  731,  728,  728,  728,  679,
      919,  846,  918,  680,  681,  682,  679,  679,  679,  679,
      919,  846,  918,  631,  632,  633,  634,  634,  634,  634,
      919,  846,  918,  670,  671,  672,  673,  673,  673,  673,
      919,  846,  918,  674,  675,  676,  677,  677,  678,  679,
      919, 1003, 1004, 1005, 1146, 1007,  631,  632,  633,  634,
      634,  634,  634, 1146, 1040, 1041, 1042, 1043, 1044, 1008,
      631, 1047,  633,  634,  634,  634,  634, 1146, 1003, 1004,
     1005, 1007,  669,  918, 1009, 1010, 1011, 1012, 1012, 1012,
     1012, 1040, 1041, 1042, 1043, 1044, 1008,  669,  918, 1013,

     1014, 1015, 1016, 1016, 1016, 1016,  669,  918, 1017, 1018,
     1019, 1020, 1020, 1021, 1022,  669,  918, 1023, 1024, 1025,
     1022, 1022, 1022, 1022,  669,  918, 1023, 1024, 1025, 1022,
     1022, 1022, 1022,  669,  918, 1026, 1027, 1028, 1029, 1029,
     1029, 1029,  669,  918, 1030, 1031, 1032, 1033, 1033, 1034,
     1035,  669,  918, 1036, 1037, 1038, 1035, 1035, 1035, 1035,
      669,  918, 1023, 1024, 1025, 1022, 1022, 1022, 1022,  669,
      918, 1026, 1027, 1028, 1029, 1029, 1029, 1029,  669,  918,
     1030, 1031, 1032, 1033, 1033, 1034, 1035,  669,  918, 1036,
     1037, 1038, 1035, 1035, 1035, 1035,  669,  918, 1036, 1037,

     1038, 1035, 1035, 1035, 1022,  669,  918, 1023, 1024, 1025,
     1022, 1022, 1022, 1022,  669,  918, 1009, 1010, 1011, 1012,
     1012, 1012, 1012,  669,  918, 1013, 1014, 1015, 1016, 1016,
     1016, 1016,  669,  918, 1017, 1018, 1019, 1020, 1020, 1021,
     1022, 1045, 1046,  669,  918, 1048, 1049, 1050, 1051, 1051,
     1051, 1051,  669,  918, 1052, 1053, 1054, 1055, 1055, 1055,
     1055, 1117,  716,  717,  718,  718,  718,  718, 1045, 1046,
      669,  918, 1056, 1057, 1058, 1059, 1059, 1060, 1061,  669,
      918, 1062, 1063, 1064, 1061, 1061, 1061, 1061,  669,  918,
     1062, 1063, 1064, 1061, 1061, 1061, 1061,  669,  918, 1065,

     1066, 1067, 1068, 1068, 1068, 1068,  669,  918, 1069, 1070,
     1071, 1072, 1072, 1073, 1074,  669,  918, 1075, 1076, 1077,
     1074, 1074, 1074, 1074,  669,  918, 1062, 1063, 1064, 1061,
     1061, 1061, 1061,  669,  918, 1065, 1066, 1067, 1068, 1068,
     1068, 1068,  669,  918, 1069, 1070, 1071, 1072, 1072, 1073,
     1074,  669,  918, 1075, 1076, 1077, 1074, 1074, 1074, 1074,
      669,  918, 1075, 1076, 1077, 1074, 1074, 1074, 1061,  669,
      918, 1062, 1063, 1064, 1061, 1061, 1061, 1061,  669,  918,
     1048, 1049, 1050, 1051, 1051, 1051, 1051,  669,  918, 1052,
     1053, 1054, 1055, 1055, 1055, 1055,  669,  918, 1056, 1057,

     1058, 1059, 1059, 1060, 1061,  669,  918, 1062, 1063, 1064,
     1061, 1061, 1061, 1061,  669,  918, 1065, 1066, 1067, 1068,
     1068, 1068, 1068,  669,  918, 1069, 1070, 1071, 1072, 1072,
     1073, 1074,  669,  918, 1075, 1076, 1077, 1074, 1074, 1074,
     1074,  669,  918, 1062, 1063, 1064, 1061, 1061, 1061, 1061,
      669,  918, 1065, 1066, 1067, 1068, 1068, 1068, 1068,  669,
      918, 1069, 1070, 1071, 1072, 1072, 1073, 1074,  669,  918,
     1075, 1076, 1077, 1074, 1074, 1074, 1074,  669,  918, 1075,
     1076, 1077, 1074, 1074, 1074, 1061,  669,  918, 1062, 1063,
     1064, 1061, 1061, 1061, 1061,  669,  918, 1048, 1049, 1050,

     1051, 1051, 1051, 1051,  669,  918, 1052, 1053, 1054, 1055,
     1055, 1055, 1055,  669,  918, 1056, 1057, 1058, 1059, 1059,
     1060, 1061, 1079, 1146, 1080, 1081, 1082, 1146,  670,  671,
      672,  673,  673,  673,  673,  669,  918, 1083, 1084, 1085,
     1086, 1086, 1086, 1086, 1146, 1146, 1146, 1146, 1146, 1079,
     1080, 1146, 1081,  669,  918, 1087, 1088, 1089, 1090, 1090,
     1090, 1090,  669,  918, 1091, 1092, 1093, 1094, 1094, 1095,
     1096,  669,  918, 1097, 1098, 1099, 1096, 1096, 1096, 1096,
      669,  918, 1097, 1098, 1099, 1096, 1096, 1096, 1096,  669,
      918, 1100, 1101, 1102, 1103, 1103, 1103, 1103,  669,  918,

     1104, 1105, 1106, 1107, 1107, 1108, 1109,  669,  918, 1110,
     1111, 1112, 1109, 1109, 1109, 1109,  669,  918, 1097, 1098,
     1099, 1096, 1096, 1096, 1096,  669,  918, 1100, 1101, 1102,
     1103, 1103, 1103, 1103,  669,  918, 1104, 1105, 1106, 1107,
     1107, 1108, 1109,  669,  918, 1110, 1111, 1112, 1109, 1109,
     1109, 1109,  669,  918, 1110, 1111, 1112, 1109, 1109, 1109,
     1096,  669,  918, 1097, 1098, 1099, 1096, 1096, 1096, 1096,
      669,  918, 1083, 1084, 1085, 1086, 1086, 1086, 1086,  669,
      918, 1087, 1088, 1089, 1090, 1090, 1090, 1090,  669,  918,
     1091, 1092, 1093, 1094, 1094, 1095, 1096,  669,  918, 1097,

     1098, 1099, 1096, 1096, 1096, 1096,  669,  918, 1100, 1101,
     1102, 1103, 1103, 1103, 1103,  669,  918, 1104, 1105, 1106,
     1107, 1107, 1108, 1109,  669,  918, 1110, 1111, 1112, 1109,
     1109, 1109, 1109,  669,  918, 1097, 1098, 1099, 1096, 1096,
     1096, 1096,  669,  918, 1100, 1101, 1102, 1103, 1103, 1103,
     1103,  669,  918, 1104, 1105, 1106, 1107, 1107, 1108, 1109,
      669,  918, 1110, 1111, 1112, 1109, 1109, 1109, 1109,  669,
      918, 1110, 1111, 1112, 1109, 1109, 1109, 1096,  669,  918,
     1097, 1098, 1099, 1096, 1096, 1096, 1096,  669,  918, 1083,
     1084, 1085, 1086, 1086, 1086, 1086,  669,  918, 1087, 1088,

     1089, 1090, 1090, 1090, 1090,  669,  918, 1091, 1092, 1093,
     1094, 1094, 1095, 1096, 1113, 1114, 1116,  669,  918,  631,
      632,  633,  634,  634,  634,  634,  669,  918,  670,  671,
      672,  673,  673,  673,  673, 1146, 1146, 1146, 1146, 1146,
     1146, 1113, 1114, 1116,  669,  918,  674,  675,  676,  677,
      677,  678,  679,  669,  918,  680,  681,  682,  679,  679,
      679,  679,  669,  918,  680,  681,  682,  679,  679,  679,
      679,  669,  918,  719,  720,  721,  722,  722,  722,  722,
      669,  918,  723,  724,  725,  726,  726,  727,  728,  669,
      918,  729,  730,  731,  728,  728,  728,  728,  669,  918,

      680,  681,  682,  679,  679,  679,  679,  669,  918,  719,
      720,  721,  722,  722,  722,  722,  669,  918,  723,  724,
      725,  726,  726,  727,  728,  669,  918,  729,  730,  731,
      728,  728,  728,  728,  669,  918,  729,  730,  731,  728,
      728,  728,  679,  669,  918,  680,  681,  682,  679,  679,
      679,  679,  669,  918,  631,  632,  633,  634,  634,  634,
      634,  669,  918,  670,  671,  672,  673,  673,  673,  673,
      669,  918,  674,  675,  676,  677,  677,  678,  679,  669,
      918,  680,  681,  682,  679,  679,  679,  679,  669,  918,
      719,  720,  721,  722,  722,  722,  722,  669,  918,  723,

      724,  725,  726,  726,  727,  728,  669,  918,  729,  730,
      731,  728,  728,  728,  728,  669,  918,  680,  681,  682,
      679,  679,  679,  679,  669,  918,  719,  720,  721,  722,
      722,  722,  722,  669,  918,  723,  724,  725,  726,  726,
      727,  728,  669,  918,  729,  730,  731,  728,  728,  728,
      728,  669,  918,  729,  730,  731,  728,  728,  728,  679,
      669,  918,  680,  681,  682,  679,  679,  679,  679,  669,
      918,  631,  632,  633,  634,  634,  634,  634,  669,  918,
      670,  671,  672,  673,  673,  673,  673,  669,  918,  674,
      675,  676,  677,  677,  678,  679, 1118, 1119, 1120,  762,

     1121,  631,  632,  633,  634,  634,  634,  634, 1122, 1123,
     1124,  631,  632,  633,  634,  634,  634,  634, 1126, 1127,
     1128, 1130, 1131, 1118, 1119, 1120,  631,  632,  633,  634,
      634,  634,  634, 1132, 1134, 1122, 1123, 1124, 1135, 1125,
     1146, 1146, 1146, 1146, 1146, 1126, 1127, 1128, 1130, 1131,
     1146, 1146, 1146, 1146, 1137, 1129, 1146, 1139, 1146, 1146,
     1132, 1134, 1146, 1146, 1146, 1135, 1125,  631,  632,  633,
      634,  634,  634,  634,  631,  632,  633,  634,  634,  634,
      634, 1137, 1129, 1139, 1146, 1146, 1146, 1146, 1136, 1146,
     1146, 1146, 1146, 1146, 1133,  631,  632,  633,  634,  634,

      634,  634, 1146, 1146, 1146, 1138,  631,  632,  633,  634,
      634,  634,  634, 1146, 1146, 1136, 1146, 1146, 1146, 1146,
     1146, 1133, 1146, 1146, 1146, 1146, 1146, 1146, 1140, 1146,
     1146, 1146, 1138,  631,  632,  633,  634,  634,  634,  634,
      631,  632,  633,  634,  634,  634,  634, 1146, 1146, 1146,
     1146, 1141, 1146, 1142, 1146, 1140,  631,  632,  633,  634,
      634,  634,  634, 1146, 1146, 1143, 1144, 1145,  633,  634,
      634,  634,  634, 1146, 1146, 1146, 1146, 1146, 1141,  669,
     1142,  631,  632,  633,  634,  634,  634,  634,  669, 1146,
      670,  671,  672,  673,  673,  673,  673,   71,   71,   71,

       71,   71,   71,   20,   20,   20,   20,   20,   20,  139,
      139,  167,  167, 1146, 1146,  167,  167,  591, 1146, 1146,
      591,  591,  591,   19, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146

    } ;

static yyconst flex_int16_t yy_chk[4397] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,

        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    3,    3,    3,    4,    4,    4,
        5,    5,    6,    6,   13,    7,   14,    8,   21,    3,
       33,   21,    4,    7,    7,    8,    8,    7,    7,    8,
        8,   28,   28,   28,   28,   28,   28,   28,   32,   34,
       32,   13,    7,   14,    8,  431,  431,   33,   35,   36,
        7,    7,    8,    8,    7,    7,    8,    8,   15,   15,

       15,   15,   15,   15,   15,   32,   34,   32,   15,   15,
       15,   15,   15,   15,  110,   35,   36,  110, 1152, 1151,
     1080,   37,   39,   40, 1041,  999,  997,  976,  912,  901,
       41,   42,   44,   48,   49,   15,   15,   15,   15,   15,
       15,   16,   16,   16,   16,   16,   16,   16,   37,   39,
       40,   16,   16,   16,   16,   16,   16,   41,   42,   44,
       48,   49,  898,  832,   50,  828,   52,  825,  802,  794,
      789,  787,  782,   45,   53,   54,   45,   46,   16,   16,
       16,   16,   16,   16,   17,   17,   17,   17,   17,   17,
       17,   50,   46,   52,   17,   17,   17,   17,   17,   17,

       45,   53,   54,   45,   46,  777,  758,   51,   55,   51,
       84,   84,   84,   84,   84,   84,   84,  741,  711,   46,
       57,   17,   17,   17,   17,   17,   17,   18,   18,   18,
       18,   18,   18,   18,   51,   55,   51,   18,   18,   18,
       18,   18,   18,   38,   43,   47,   58,   57,   38,   47,
       43,   58,   59,   60,   61,   62,   63,   64,   68,   66,
       65,   47,   63,   65,   18,   18,   18,   18,   18,   18,
       38,   43,   47,   58,   66,   38,   47,   43,   58,   59,
       60,   61,   62,   63,   64,   68,   66,   65,   47,   63,
       65,   67,   70,   69,   72,   67,   69,   73,   74,   73,

       75,   66,   76,   77,   75,  706,   78,   67,   78,   74,
      705,   81,   74,   86,  701,   74,   75,  700,   67,   70,
       69,   72,   67,   69,   73,   74,   73,   75,   80,   76,
       77,   75,   80,   78,   67,   78,   74,   79,   81,   74,
       86,   82,   74,   75,   80,   83,   87,   85,   79,   85,
       88,   79,   89,  699,   79,   80,   82,  689,   99,   80,
       83,  687,  683,  651,   79,  625,  611,  582,   82,  100,
      558,   80,   83,   87,   85,   79,   85,   88,   79,   89,
       93,   79,   93,   82,   96,   99,   96,   83,   91,   91,
       91,   91,   91,   91,   91,   92,  100,   92,   91,   91,

       91,   91,   91,   91,   94,  101,   94,   93,   95,   93,
       95,   96,   94,   96,   92,   98,  102,   98,  545,  113,
      536,   95,   92,  527,   92,   91,   91,   91,   91,   91,
       91,   94,  101,   94,  506,   95,  106,   95,  106,   94,
      501,   92,   98,  102,   98,  105,  113,  105,   95,   97,
       97,   97,   97,   97,   97,   97,  104,  104,  104,  104,
      104,  104,  104,  106,  105,  106,  104,  104,  104,  104,
      104,  104,  105,  107,  105,  107,  108,  109,  108,  109,
      116,  107,  112,  112,  112,  112,  112,  112,  112,  108,
      117,  105,  118,  104,  104,  104,  104,  104,  104,  120,

      107,  121,  107,  108,  109,  108,  109,  116,  107,  119,
      122,  488,  123,  124,  119,  125,  108,  117,  126,  118,
      122,  127,  486,  128,  129,  130,  120,  131,  121,  132,
      133,  134,  135,  136,  138,  126,  119,  122,  123,  124,
      140,  119,  125,  143,  144,  126,  145,  122,  127,  128,
      146,  129,  130,  147,  131,  146,  132,  133,  134,  135,
      136,  138,  126,  148,  149,  464,  150,  140,  151,  152,
      143,  144,  153,  145,  149,  154,  128,  146,  155,  156,
      147,  157,  146,  158,  159,  160,  161,  162,  163,  153,
      148,  149,  150,  164,  151,  166,  152,  462,  169,  153,

      170,  149,  154,  171,  155,  172,  156,  174,  157,  173,
      158,  159,  160,  161,  162,  163,  153,  176,  168,  177,
      164,  178,  166,  168,  168,  169,  173,  170,  179,  181,
      171,  155,  172,  175,  174,  180,  173,  182,  175,  175,
      182,  425,  388,  385,  176,  168,  177,  364,  178,  186,
      168,  168,  180,  173,  183,  179,  181,  183,  188,  189,
      175,  189,  180,  195,  182,  175,  175,  182,  184,  184,
      184,  184,  184,  184,  184,  190,  186,  190,  197,  180,
      191,  183,  361,  355,  183,  188,  189,  191,  189,  191,
      195,  192,  354,  192,  193,  193,  193,  193,  193,  193,

      193,  204,  190,  192,  190,  197,  198,  199,  198,  199,
      200,  201,  205,  201,  191,  206,  191,  200,  192,  200,
      192,  207,  208,  201,  209,  210,  211,  212,  204,  213,
      192,  214,  215,  198,  199,  198,  199,  216,  201,  205,
      201,  217,  206,  218,  200,  219,  200,  220,  207,  208,
      201,  209,  210,  211,  212,  221,  213,  222,  214,  215,
      223,  225,  226,  227,  216,  229,  230,  233,  217,  234,
      218,  235,  219,  236,  220,  237,  238,  239,  240,  241,
      242,  243,  221,  244,  222,  245,  246,  223,  225,  226,
      227,  247,  229,  230,  233,  248,  234,  249,  235,  250,

      236,  251,  237,  238,  239,  240,  241,  242,  243,  252,
      244,  254,  245,  246,  255,  256,  259,  260,  247,  263,
      265,  267,  248,  266,  249,  268,  250,  267,  251,  270,
      272,  329,  273,  274,  275,  276,  252,  277,  254,  274,
      324,  255,  256,  259,  260,  286,  263,  265,  267,  266,
      287,  280,  268,  280,  288,  289,  270,  272,  273,  290,
      274,  275,  276,  281,  277,  281,  284,  285,  284,  285,
      293,  294,  286,  295,  296,  299,  300,  287,  280,  301,
      280,  288,  289,  304,  305,  306,  290,  307,  308,  309,
      281,  310,  281,  284,  285,  284,  285,  293,  294,  311,

      295,  296,  299,  300,  312,  313,  301,  314,  315,  316,
      304,  305,  306,  319,  307,  308,  309,  320,  310,  321,
      322,  325,  326,  327,  330,  331,  311,  332,  333,  334,
      318,  312,  313,  336,  314,  315,  316,  317,  337,  303,
      319,  339,  340,  341,  320,  298,  321,  322,  325,  326,
      327,  330,  331,  342,  332,  333,  334,  335,  292,  344,
      336,  345,  346,  347,  335,  337,  335,  335,  339,  340,
      341,  348,  335,  349,  351,  352,  353,  356,  357,  335,
      342,  335,  335,  335,  335,  335,  344,  358,  345,  346,
      347,  335,  359,  335,  335,  360,  362,  363,  348,  335,

      349,  351,  352,  353,  356,  357,  335,  365,  335,  335,
      335,  335,  335,  366,  358,  367,  369,  372,  373,  359,
      374,  375,  360,  362,  363,  376,  377,  379,  380,  381,
      382,  383,  384,  386,  365,  387,  389,  390,  392,  394,
      366,  395,  367,  369,  372,  373,  396,  374,  375,  397,
      398,  399,  376,  377,  379,  380,  381,  382,  383,  384,
      386,  402,  387,  389,  390,  392,  394,  404,  395,  400,
      400,  401,  403,  396,  401,  405,  397,  398,  399,  406,
      407,  408,  409,  403,  411,  412,  413,  414,  402,  417,
      418,  419,  420,  423,  404,  424,  400,  400,  401,  427,

      429,  401,  405,  430,  432,  433,  406,  407,  408,  409,
      403,  411,  412,  413,  414,  434,  417,  418,  419,  420,
      423,  435,  424,  436,  437,  438,  427,  429,  439,  440,
      430,  432,  433,  441,  442,  443,  444,  447,  449,  450,
      451,  452,  434,  453,  454,  455,  456,  458,  435,  457,
      436,  437,  438,  459,  439,  460,  440,  461,  463,  465,
      441,  442,  443,  444,  447,  449,  450,  451,  452,  466,
      453,  454,  455,  456,  458,  457,  466,  467,  468,  469,
      459,  470,  460,  471,  461,  463,  465,  472,  473,  474,
      475,  477,  478,  479,  480,  481,  466,  482,  483,  484,

      485,  492,  493,  466,  467,  468,  469,  494,  470,  495,
      471,  496,  497,  498,  472,  473,  474,  475,  477,  478,
      479,  480,  481,  500,  482,  483,  484,  485,  492,  493,
      502,  503,  504,  508,  494,  509,  495,  510,  496,  497,
      498,  511,  512,  513,  515,  516,  517,  518,  519,  520,
      500,  521,  522,  524,  525,  523,  529,  502,  503,  504,
      508,  523,  509,  291,  510,  530,  531,  532,  511,  512,
      513,  515,  516,  517,  518,  519,  520,  528,  521,  522,
      524,  525,  523,  529,  533,  534,  537,  538,  523,  539,
      528,  541,  530,  531,  532,  542,  544,  547,  271,  550,

      551,  552,  553,  555,  528,  554,  556,  557,  560,  563,
      564,  533,  534,  537,  538,  565,  539,  528,  541,  566,
      567,  568,  542,  544,  547,  550,  569,  551,  552,  553,
      555,  554,  570,  556,  557,  560,  563,  564,  571,  572,
      573,  565,  574,  575,  576,  577,  566,  567,  568,  578,
      579,  580,  581,  569,  583,  584,  585,  586,  588,  570,
      589,  269,  264,  262,  261,  571,  572,  573,  592,  574,
      575,  576,  577,  593,  594,  596,  578,  579,  580,  581,
      597,  583,  584,  585,  586,  588,  598,  589,  591,  591,
      591,  591,  591,  591,  591,  592,  600,  602,  603,  604,

      593,  594,  596,  605,  606,  608,  610,  597,  612,  613,
      614,  615,  616,  598,  617,  618,  619,  620,  622,  623,
      626,  627,  628,  600,  602,  603,  604,  629,  630,  635,
      605,  606,  608,  610,  624,  612,  613,  614,  615,  616,
      258,  617,  618,  619,  620,  622,  623,  626,  627,  628,
      624,  253,  224,  196,  629,  630,  635,  187,  167,  636,
      631,  624,  631,  631,  631,  631,  631,  631,  631,  669,
      669,  669,  669,  669,  669,  669,  632,  624,  632,  632,
      632,  632,  632,  632,  632,  633,  636,  633,  633,  633,
      633,  633,  633,  633,  634,  637,  634,  634,  634,  634,

      634,  634,  634,  639,  640,  641,  642,  643,  644,  646,
      647,  648,  649,  650,  652,  653,  654,  165,  655,  656,
      657,  658,  637,  659,  660,  661,  662,  663,  664,  665,
      639,  640,  641,  642,  643,  644,  646,  647,  648,  649,
      650,  652,  653,  654,  655,  666,  656,  657,  658,  659,
      667,  660,  661,  662,  663,  664,  665,  668,  670,  141,
      670,  670,  670,  670,  670,  670,  670,  137,  114,   23,
       19,    0,  666,    0,    0,  684,    0,  667,    0,    0,
        0,    0,    0,  671,  668,  671,  671,  671,  671,  671,
      671,  671,  672,  685,  672,  672,  672,  672,  672,  672,

      672,  673,  684,  673,  673,  673,  673,  673,  673,  673,
      674,  686,  674,  674,  674,  674,  674,  674,  674,  675,
      685,  675,  675,  675,  675,  675,  675,  675,  676,  690,
      676,  676,  676,  676,  676,  676,  676,  677,  686,  677,
      677,  677,  677,  677,  677,  677,  678,  691,  678,  678,
      678,  678,  678,  678,  678,  679,  690,  679,  679,  679,
      679,  679,  679,  679,  680,  692,  680,  680,  680,  680,
      680,  680,  680,  681,  691,  681,  681,  681,  681,  681,
      681,  681,  682,  694,  682,  682,  682,  682,  682,  682,
      682,  695,  692,  696,  697,  698,  702,  703,  704,  707,

      708,  709,  710,  712,  713,  714,    0,  732,    0,  715,
      694,  715,  715,  715,  715,  715,  715,  715,  695,    0,
      696,  697,  698,  702,  703,  704,  707,  708,  709,  710,
      712,  713,  714,  716,  732,  716,  716,  716,  716,  716,
      716,  716,  717,  733,  717,  717,  717,  717,  717,  717,
      717,  718,  734,  718,  718,  718,  718,  718,  718,  718,
      719,  735,  719,  719,  719,  719,  719,  719,  719,  720,
      733,  720,  720,  720,  720,  720,  720,  720,  721,  734,
      721,  721,  721,  721,  721,  721,  721,  722,  735,  722,
      722,  722,  722,  722,  722,  722,  723,  736,  723,  723,

      723,  723,  723,  723,  723,  724,  737,  724,  724,  724,
      724,  724,  724,  724,  725,  738,  725,  725,  725,  725,
      725,  725,  725,  726,  736,  726,  726,  726,  726,  726,
      726,  726,  727,  737,  727,  727,  727,  727,  727,  727,
      727,  728,  738,  728,  728,  728,  728,  728,  728,  728,
      729,  739,  729,  729,  729,  729,  729,  729,  729,  730,
      740,  730,  730,  730,  730,  730,  730,  730,  731,  742,
      731,  731,  731,  731,  731,  731,  731,  743,  739,  744,
      745,  746,  747,  748,  749,  750,  751,  740,  752,  753,
      754,  755,  756,  757,  759,  760,  742,  761,    0,    0,

        0,    0,    0,    0,  743,    0,  744,  745,  746,  747,
      748,  749,  750,  751,    0,  752,  753,  754,  755,  756,
      757,  759,  760,    0,  761,  762,  762,  762,  762,  762,
      762,  762,  763,  776,  763,  763,  763,  763,  763,  763,
      763,  764,  780,  764,  764,  764,  764,  764,  764,  764,
      765,  781,  765,  765,  765,  765,  765,  765,  765,  766,
      776,  766,  766,  766,  766,  766,  766,  766,  767,  780,
      767,  767,  767,  767,  767,  767,  767,  768,  781,  768,
      768,  768,  768,  768,  768,  768,  769,  785,  769,  769,
      769,  769,  769,  769,  769,  770,    0,  770,  770,  770,

      770,  770,  770,  770,  771,    0,  771,  771,  771,  771,
      771,  771,  771,  772,  785,  772,  772,  772,  772,  772,
      772,  772,  773,  778,  773,  773,  773,  773,  773,  773,
      773,  774,  783,  774,  774,  774,  774,  774,  774,  774,
      775,  786,  775,  775,  775,  775,  775,  775,  775,  778,
      788,  790,  791,  792,  793,  795,  796,  797,  783,  798,
      799,  800,    0,  823,    0,    0,    0,  806,  786,  806,
      806,  806,  806,  806,  806,  806,    0,  788,  790,  791,
      792,  793,  795,  796,  797,    0,  798,  799,  800,  807,
      823,  807,  807,  807,  807,  807,  807,  807,  808,  826,

      808,  808,  808,  808,  808,  808,  808,  809,  827,  809,
      809,  809,  809,  809,  809,  809,  810,  829,  810,  810,
      810,  810,  810,  810,  810,  811,  826,  811,  811,  811,
      811,  811,  811,  811,  812,  827,  812,  812,  812,  812,
      812,  812,  812,  813,  829,  813,  813,  813,  813,  813,
      813,  813,  814,  830,  814,  814,  814,  814,  814,  814,
      814,  815,  831,  815,  815,  815,  815,  815,  815,  815,
      816,  833,  816,  816,  816,  816,  816,  816,  816,  817,
      830,  817,  817,  817,  817,  817,  817,  817,  818,  831,
      818,  818,  818,  818,  818,  818,  818,  819,  833,  819,

      819,  819,  819,  819,  819,  819,  820,  834,  820,  820,
      820,  820,  820,  820,  820,  821,  835,  821,  821,  821,
      821,  821,  821,  821,  822,  836,  822,  822,  822,  822,
      822,  822,  822,  837,  834,  838,  839,  840,  841,  842,
      843,  844,    0,  835,  846,  846,  846,  846,  846,  846,
      846,  847,  836,  847,  847,  847,  847,  847,  847,  847,
      837,  860,  838,  839,  840,  841,  842,  843,  844,  848,
      861,  848,  848,  848,  848,  848,  848,  848,  849,  862,
      849,  849,  849,  849,  849,  849,  849,  850,  860,  850,
      850,  850,  850,  850,  850,  850,  851,  861,  851,  851,

      851,  851,  851,  851,  851,  852,  862,  852,  852,  852,
      852,  852,  852,  852,  853,  863,  853,  853,  853,  853,
      853,  853,  853,  854,  864,  854,  854,  854,  854,  854,
      854,  854,  855,  865,  855,  855,  855,  855,  855,  855,
      855,  856,  863,  856,  856,  856,  856,  856,  856,  856,
      857,  864,  857,  857,  857,  857,  857,  857,  857,  858,
      865,  858,  858,  858,  858,  858,  858,  858,  859,  866,
      859,  859,  859,  859,  859,  859,  859,  867,  868,    0,
      869,  870,  871,  872,  874,  875,  876,  877,  878,  879,
      880,    0,    0,    0,    0,  885,  866,  885,  885,  885,

      885,  885,  885,  885,  867,  868,  869,    0,  870,  871,
      872,  874,  875,  876,  877,  878,  879,  880,  881,  881,
      881,  881,  881,  881,  881,  881,  881,  881,  882,  882,
      882,  882,  882,  882,  882,  882,  882,  882,  883,  883,
      883,  883,  883,  883,  883,  883,  883,  883,  884,  884,
      884,  884,  884,  884,  884,  884,  884,  884,  886,  899,
      886,  886,  886,  886,  886,  886,  886,  887,  900,  887,
      887,  887,  887,  887,  887,  887,  888,  902,  888,  888,
      888,  888,  888,  888,  888,  889,  899,  889,  889,  889,
      889,  889,  889,  889,  890,  900,  890,  890,  890,  890,

      890,  890,  890,  891,  902,  891,  891,  891,  891,  891,
      891,  891,  892,  903,  892,  892,  892,  892,  892,  892,
      892,  893,  905,  893,  893,  893,  893,  893,  893,  893,
      894,  906,  894,  894,  894,  894,  894,  894,  894,  895,
      903,  895,  895,  895,  895,  895,  895,  895,  896,  905,
      896,  896,  896,  896,  896,  896,  896,  897,  906,  897,
      897,  897,  897,  897,  897,  897,  907,  908,  911,  913,
      914,  915,  917,  918,  918,  918,  918,  918,  918,  918,
      919,  919,  919,  919,  919,  919,  919,    0,    0,    0,
        0,    0,    0,  907,  908,  911,  913,  914,  915,  917,

      934,  935,  936,  937,  938,  918,  920,  920,  920,  920,
      920,  920,  920,  920,  920,  920,  921,  921,  921,  921,
      921,  921,  921,  921,  921,  921,    0,  934,  935,  936,
      937,  938,  918,  922,  922,  922,  922,  922,  922,  922,
      922,  922,  922,  923,  923,  923,  923,  923,  923,  923,
      923,  923,  923,  924,  924,  924,  924,  924,  924,  924,
      924,  924,  924,  925,  925,  925,  925,  925,  925,  925,
      925,  925,  925,  926,  926,  926,  926,  926,  926,  926,
      926,  926,  926,  927,  927,  927,  927,  927,  927,  927,
      927,  927,  927,  928,  928,  928,  928,  928,  928,  928,

      928,  928,  928,  929,  929,  929,  929,  929,  929,  929,
      929,  929,  929,  930,  930,  930,  930,  930,  930,  930,
      930,  930,  930,  931,  931,  931,  931,  931,  931,  931,
      931,  931,  931,  932,  932,  932,  932,  932,  932,  932,
      932,  932,  932,  939,  940,  941,  942,  943,  944,  945,
      946,  948,  948,  948,  948,  948,  948,  948,    0,    0,
      966,  967,  968,  969,  970,  971,  948,    0,    0,    0,
      939,  940,  941,  942,  943,  944,  945,  946,  949,  949,
      949,  949,  949,  949,  949,  949,  949,  966,  967,  968,
      969,  970,  971,  948,  950,  950,  950,  950,  950,  950,

      950,  950,  950,  951,  951,  951,  951,  951,  951,  951,
      951,  951,  952,  952,  952,  952,  952,  952,  952,  952,
      952,  953,  953,  953,  953,  953,  953,  953,  953,  953,
      953,  954,  954,  954,  954,  954,  954,  954,  954,  954,
      954,  955,  955,  955,  955,  955,  955,  955,  955,  955,
      955,  956,  956,  956,  956,  956,  956,  956,  956,  956,
      956,  957,  957,  957,  957,  957,  957,  957,  957,  957,
      957,  958,  958,  958,  958,  958,  958,  958,  958,  958,
      958,  959,  959,  959,  959,  959,  959,  959,  959,  959,
      959,  960,  960,  960,  960,  960,  960,  960,  960,  960,

      960,  961,  961,  961,  961,  961,  961,  961,  961,  961,
      961,  962,  962,  962,  962,  962,  962,  962,  962,  962,
      962,  963,  963,  963,  963,  963,  963,  963,  963,  963,
      963,  964,  964,  964,  964,  964,  964,  964,  964,  964,
      964,  965,  965,  965,  965,  965,  965,  965,  965,  965,
      965,  973,  974,  975,    0,  978,  979,  979,  979,  979,
      979,  979,  979,    0, 1000, 1001, 1002, 1003, 1004,  979,
     1008, 1008, 1008, 1008, 1008, 1008, 1008,    0,  973,  974,
      975,  978,  980,  980,  980,  980,  980,  980,  980,  980,
      980, 1000, 1001, 1002, 1003, 1004,  979,  981,  981,  981,

      981,  981,  981,  981,  981,  981,  982,  982,  982,  982,
      982,  982,  982,  982,  982,  983,  983,  983,  983,  983,
      983,  983,  983,  983,  984,  984,  984,  984,  984,  984,
      984,  984,  984,  985,  985,  985,  985,  985,  985,  985,
      985,  985,  986,  986,  986,  986,  986,  986,  986,  986,
      986,  987,  987,  987,  987,  987,  987,  987,  987,  987,
      988,  988,  988,  988,  988,  988,  988,  988,  988,  989,
      989,  989,  989,  989,  989,  989,  989,  989,  990,  990,
      990,  990,  990,  990,  990,  990,  990,  991,  991,  991,
      991,  991,  991,  991,  991,  991,  992,  992,  992,  992,

      992,  992,  992,  992,  992,  993,  993,  993,  993,  993,
      993,  993,  993,  993,  994,  994,  994,  994,  994,  994,
      994,  994,  994,  995,  995,  995,  995,  995,  995,  995,
      995,  995,  996,  996,  996,  996,  996,  996,  996,  996,
      996, 1005, 1006, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
     1009, 1009, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
     1010, 1082, 1082, 1082, 1082, 1082, 1082, 1082, 1005, 1006,
     1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1012,
     1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 1013, 1013,
     1013, 1013, 1013, 1013, 1013, 1013, 1013, 1014, 1014, 1014,

     1014, 1014, 1014, 1014, 1014, 1014, 1015, 1015, 1015, 1015,
     1015, 1015, 1015, 1015, 1015, 1016, 1016, 1016, 1016, 1016,
     1016, 1016, 1016, 1016, 1017, 1017, 1017, 1017, 1017, 1017,
     1017, 1017, 1017, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
     1018, 1018, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
     1019, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
     1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 1022,
     1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1023, 1023,
     1023, 1023, 1023, 1023, 1023, 1023, 1023, 1024, 1024, 1024,
     1024, 1024, 1024, 1024, 1024, 1024, 1025, 1025, 1025, 1025,

     1025, 1025, 1025, 1025, 1025, 1026, 1026, 1026, 1026, 1026,
     1026, 1026, 1026, 1026, 1027, 1027, 1027, 1027, 1027, 1027,
     1027, 1027, 1027, 1028, 1028, 1028, 1028, 1028, 1028, 1028,
     1028, 1028, 1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029,
     1029, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030,
     1031, 1031, 1031, 1031, 1031, 1031, 1031, 1031, 1031, 1032,
     1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 1033, 1033,
     1033, 1033, 1033, 1033, 1033, 1033, 1033, 1034, 1034, 1034,
     1034, 1034, 1034, 1034, 1034, 1034, 1035, 1035, 1035, 1035,
     1035, 1035, 1035, 1035, 1035, 1036, 1036, 1036, 1036, 1036,

     1036, 1036, 1036, 1036, 1037, 1037, 1037, 1037, 1037, 1037,
     1037, 1037, 1037, 1038, 1038, 1038, 1038, 1038, 1038, 1038,
     1038, 1038, 1043,    0, 1044, 1046, 1047,    0, 1047, 1047,
     1047, 1047, 1047, 1047, 1047, 1048, 1048, 1048, 1048, 1048,
     1048, 1048, 1048, 1048,    0,    0,    0,    0,    0, 1043,
     1044,    0, 1046, 1049, 1049, 1049, 1049, 1049, 1049, 1049,
     1049, 1049, 1050, 1050, 1050, 1050, 1050, 1050, 1050, 1050,
     1050, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051,
     1052, 1052, 1052, 1052, 1052, 1052, 1052, 1052, 1052, 1053,
     1053, 1053, 1053, 1053, 1053, 1053, 1053, 1053, 1054, 1054,

     1054, 1054, 1054, 1054, 1054, 1054, 1054, 1055, 1055, 1055,
     1055, 1055, 1055, 1055, 1055, 1055, 1056, 1056, 1056, 1056,
     1056, 1056, 1056, 1056, 1056, 1057, 1057, 1057, 1057, 1057,
     1057, 1057, 1057, 1057, 1058, 1058, 1058, 1058, 1058, 1058,
     1058, 1058, 1058, 1059, 1059, 1059, 1059, 1059, 1059, 1059,
     1059, 1059, 1060, 1060, 1060, 1060, 1060, 1060, 1060, 1060,
     1060, 1061, 1061, 1061, 1061, 1061, 1061, 1061, 1061, 1061,
     1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1063,
     1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1064, 1064,
     1064, 1064, 1064, 1064, 1064, 1064, 1064, 1065, 1065, 1065,

     1065, 1065, 1065, 1065, 1065, 1065, 1066, 1066, 1066, 1066,
     1066, 1066, 1066, 1066, 1066, 1067, 1067, 1067, 1067, 1067,
     1067, 1067, 1067, 1067, 1068, 1068, 1068, 1068, 1068, 1068,
     1068, 1068, 1068, 1069, 1069, 1069, 1069, 1069, 1069, 1069,
     1069, 1069, 1070, 1070, 1070, 1070, 1070, 1070, 1070, 1070,
     1070, 1071, 1071, 1071, 1071, 1071, 1071, 1071, 1071, 1071,
     1072, 1072, 1072, 1072, 1072, 1072, 1072, 1072, 1072, 1073,
     1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1074, 1074,
     1074, 1074, 1074, 1074, 1074, 1074, 1074, 1075, 1075, 1075,
     1075, 1075, 1075, 1075, 1075, 1075, 1076, 1076, 1076, 1076,

     1076, 1076, 1076, 1076, 1076, 1077, 1077, 1077, 1077, 1077,
     1077, 1077, 1077, 1077, 1078, 1079, 1081, 1083, 1083, 1083,
     1083, 1083, 1083, 1083, 1083, 1083, 1084, 1084, 1084, 1084,
     1084, 1084, 1084, 1084, 1084,    0,    0,    0,    0,    0,
        0, 1078, 1079, 1081, 1085, 1085, 1085, 1085, 1085, 1085,
     1085, 1085, 1085, 1086, 1086, 1086, 1086, 1086, 1086, 1086,
     1086, 1086, 1087, 1087, 1087, 1087, 1087, 1087, 1087, 1087,
     1087, 1088, 1088, 1088, 1088, 1088, 1088, 1088, 1088, 1088,
     1089, 1089, 1089, 1089, 1089, 1089, 1089, 1089, 1089, 1090,
     1090, 1090, 1090, 1090, 1090, 1090, 1090, 1090, 1091, 1091,

     1091, 1091, 1091, 1091, 1091, 1091, 1091, 1092, 1092, 1092,
     1092, 1092, 1092, 1092, 1092, 1092, 1093, 1093, 1093, 1093,
     1093, 1093, 1093, 1093, 1093, 1094, 1094, 1094, 1094, 1094,
     1094, 1094, 1094, 1094, 1095, 1095, 1095, 1095, 1095, 1095,
     1095, 1095, 1095, 1096, 1096, 1096, 1096, 1096, 1096, 1096,
     1096, 1096, 1097, 1097, 1097, 1097, 1097, 1097, 1097, 1097,
     1097, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098,
     1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 1100,
     1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1101, 1101,
     1101, 1101, 1101, 1101, 1101, 1101, 1101, 1102, 1102, 1102,

     1102, 1102, 1102, 1102, 1102, 1102, 1103, 1103, 1103, 1103,
     1103, 1103, 1103, 1103, 1103, 1104, 1104, 1104, 1104, 1104,
     1104, 1104, 1104, 1104, 1105, 1105, 1105, 1105, 1105, 1105,
     1105, 1105, 1105, 1106, 1106, 1106, 1106, 1106, 1106, 1106,
     1106, 1106, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 1107,
     1107, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108, 1108,
     1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 1110,
     1110, 1110, 1110, 1110, 1110, 1110, 1110, 1110, 1111, 1111,
     1111, 1111, 1111, 1111, 1111, 1111, 1111, 1112, 1112, 1112,
     1112, 1112, 1112, 1112, 1112, 1112, 1113, 1115, 1116, 1117,

     1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 1118, 1119,
     1120, 1121, 1121, 1121, 1121, 1121, 1121, 1121, 1122, 1123,
     1124, 1126, 1127, 1113, 1115, 1116, 1125, 1125, 1125, 1125,
     1125, 1125, 1125, 1128, 1130, 1118, 1119, 1120, 1132, 1121,
        0,    0,    0,    0,    0, 1122, 1123, 1124, 1126, 1127,
        0,    0,    0,    0, 1135, 1125,    0, 1137,    0,    0,
     1128, 1130,    0,    0,    0, 1132, 1121, 1129, 1129, 1129,
     1129, 1129, 1129, 1129, 1133, 1133, 1133, 1133, 1133, 1133,
     1133, 1135, 1125, 1137,    0,    0,    0,    0, 1133,    0,
        0,    0,    0,    0, 1129, 1136, 1136, 1136, 1136, 1136,

     1136, 1136,    0,    0,    0, 1136, 1138, 1138, 1138, 1138,
     1138, 1138, 1138,    0,    0, 1133,    0,    0,    0,    0,
        0, 1129,    0,    0,    0,    0,    0,    0, 1138,    0,
        0,    0, 1136, 1140, 1140, 1140, 1140, 1140, 1140, 1140,
     1141, 1141, 1141, 1141, 1141, 1141, 1141,    0,    0,    0,
        0, 1140,    0, 1141,    0, 1138, 1142, 1142, 1142, 1142,
     1142, 1142, 1142,    0,    0, 1142, 1143, 1143, 1143, 1143,
     1143, 1143, 1143,    0,    0,    0,    0,    0, 1140, 1144,
     1141, 1144, 1144, 1144, 1144, 1144, 1144, 1144, 1145,    0,
     1145, 1145, 1145, 1145, 1145, 1145, 1145, 1147, 1147, 1147,

     1147, 1147, 1147, 1148, 1148, 1148, 1148, 1148, 1148, 1149,
     1149, 1150, 1150,    0,    0, 1150, 1150, 1153,    0,    0,
     1153, 1153, 1153, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
     1146, 1146, 1146, 1146, 1146, 1146

    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET

#include <string>

#include "parser.h"
#define yyterminate() return(END)

#define INITIAL 0
#define MATCH_STRING_STATE 1
#define MATCH_RESPONSE_CODE_STATE 2
#define SUPPORTED_METHODS_STATE 3
#define CONTENT_TYPE_STATE 4
#define SESSION_STATE 5
#define MATCH_PRESENTATION_URL 6
#define NUM_AS_HEX_MODE 7
#define MATCH_EDID_STATE 8

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#define YY_EXTRA_TYPE bool

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

static int yy_init_globals (yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int message_lex_init (yyscan_t* scanner);

int message_lex_init_extra (YY_EXTRA_TYPE user_defined,yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int message_lex_destroy (yyscan_t yyscanner );

int message_get_debug (yyscan_t yyscanner );

void message_set_debug (int debug_flag ,yyscan_t yyscanner );

YY_EXTRA_TYPE message_get_extra (yyscan_t yyscanner );

void message_set_extra (YY_EXTRA_TYPE user_defined ,yyscan_t yyscanner );

FILE *message_get_in (yyscan_t yyscanner );

void message_set_in  (FILE * in_str ,yyscan_t yyscanner );

FILE *message_get_out (yyscan_t yyscanner );

void message_set_out  (FILE * out_str ,yyscan_t yyscanner );

int message_get_leng (yyscan_t yyscanner );

char *message_get_text (yyscan_t yyscanner );

int message_get_lineno (yyscan_t yyscanner );

void message_set_lineno (int line_number ,yyscan_t yyscanner );

YYSTYPE * message_get_lval (yyscan_t yyscanner );

void message_set_lval (YYSTYPE * yylval_param ,yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int message_wrap (yyscan_t yyscanner );
#else
extern int message_wrap (yyscan_t yyscanner );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int ,yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * ,yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (yyscan_t yyscanner );
#else
static int input (yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int message_lex \
               (YYSTYPE * yylval_param ,yyscan_t yyscanner);

#define YY_DECL int message_lex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			message_ensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				message__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
		}

		message__load_buffer_state(yyscanner );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 1147 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 1146 );
		yy_cp = yyg->yy_last_accepting_cpos;
		yy_current_state = yyg->yy_last_accepting_state;

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
{ BEGIN(INITIAL); }
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
{ BEGIN(INITIAL); }
	YY_BREAK
case 3:
YY_RULE_SETUP
{ BEGIN(INITIAL); }
	YY_BREAK
/* Convert these */
case 4:
YY_RULE_SETUP
{ return '='; }
	YY_BREAK
case 5:
YY_RULE_SETUP
{ return '-'; }
	YY_BREAK
case 6:
YY_RULE_SETUP
{ return ','; }
	YY_BREAK
case 7:
YY_RULE_SETUP
{ return '*'; }
	YY_BREAK
case 8:
YY_RULE_SETUP
{ return ';'; }
	YY_BREAK
case 9:
YY_RULE_SETUP
{ return ':'; }
	YY_BREAK
case 10:
YY_RULE_SETUP
{ return '/'; }
	YY_BREAK
case 11:
YY_RULE_SETUP
return WFD_SP;
	YY_BREAK
case 12:
YY_RULE_SETUP
return WFD_NONE;
	YY_BREAK
case 13:
YY_RULE_SETUP
return WFD_AUDIO_CODEC_LPCM;
	YY_BREAK
case 14:
YY_RULE_SETUP
return WFD_AUDIO_CODEC_AAC;
	YY_BREAK
case 15:
YY_RULE_SETUP
return WFD_AUDIO_CODEC_AC3;
	YY_BREAK
case 16:
YY_RULE_SETUP
return WFD_HDCP_SPEC_2_0;
	YY_BREAK
case 17:
YY_RULE_SETUP
return WFD_HDCP_SPEC_2_1;
	YY_BREAK
case 18:
YY_RULE_SETUP
return WFD_IP_PORT;
	YY_BREAK
case 19:
YY_RULE_SETUP
return WFD_STREAM_PROFILE;
	YY_BREAK
case 20:
YY_RULE_SETUP
return WFD_MODE_PLAY;
	YY_BREAK
case 21:
YY_RULE_SETUP
return WFD_ROUTE_PRIMARY;
	YY_BREAK
case 22:
YY_RULE_SETUP
return WFD_ROUTE_SECONDARY;
	YY_BREAK
case 23:
YY_RULE_SETUP
return WFD_INPUT_CATEGORY_LIST;
	YY_BREAK
case 24:
YY_RULE_SETUP
return WFD_INPUT_CATEGORY_GENERIC;
	YY_BREAK
case 25:
YY_RULE_SETUP
return WFD_INPUT_CATEGORY_HIDC;
	YY_BREAK
case 26:
YY_RULE_SETUP
return WFD_GENERIC_CAP_LIST;
	YY_BREAK
case 27:
YY_RULE_SETUP
return WFD_INPUT_TYPE_KEYBOARD;
	YY_BREAK
case 28:
YY_RULE_SETUP
return WFD_INPUT_TYPE_MOUSE;
	YY_BREAK
case 29:
YY_RULE_SETUP
return WFD_INPUT_TYPE_SINGLE_TOUCH;
	YY_BREAK
case 30:
YY_RULE_SETUP
return WFD_INPUT_TYPE_MULTI_TOUCH;
	YY_BREAK
case 31:
YY_RULE_SETUP
return WFD_INPUT_TYPE_JOYSTICK;
	YY_BREAK
case 32:
YY_RULE_SETUP
return WFD_INPUT_TYPE_CAMERA;
	YY_BREAK
case 33:
YY_RULE_SETUP
return WFD_INPUT_TYPE_GESTURE;
	YY_BREAK
case 34:
YY_RULE_SETUP
return WFD_INPUT_TYPE_REMOTE_CONTROL;
	YY_BREAK
case 35:
YY_RULE_SETUP
return WFD_HIDC_CAP_LIST;
	YY_BREAK
case 36:
YY_RULE_SETUP
return WFD_INPUT_PATH_INFRARED;
	YY_BREAK
case 37:
YY_RULE_SETUP
return WFD_INPUT_PATH_USB;
	YY_BREAK
case 38:
YY_RULE_SETUP
return WFD_INPUT_PATH_BT;
	YY_BREAK
case 39:
YY_RULE_SETUP
return WFD_INPUT_PATH_WIFI;
	YY_BREAK
case 40:
YY_RULE_SETUP
return WFD_INPUT_PATH_ZIGBEE;
	YY_BREAK
case 41:
YY_RULE_SETUP
return WFD_INPUT_PATH_NOSP;
	YY_BREAK
case 42:
YY_RULE_SETUP
return WFD_UIBC_SETTING_DISABLE;
	YY_BREAK
case 43:
YY_RULE_SETUP
return WFD_UIBC_SETTING_ENABLE;
	YY_BREAK
case 44:
YY_RULE_SETUP
return WFD_SUPPORTED;
	YY_BREAK
case 45:
YY_RULE_SETUP
{
    std::string str(yytext, yyleng);
    str += '\0';
    errno = 0;
    yylval->nval = strtoull(str.c_str(), NULL, 16);
    if (errno)
      yyterminate();
    return WFD_NUM;
  }
	YY_BREAK
case 46:
YY_RULE_SETUP
{
    std::string str(yytext, yyleng);
    str += '\0';
    errno = 0;
    yylval->nval = strtoull(str.c_str(), NULL, 16);
    if (errno)
      yyterminate();
    return WFD_NUM;
  }
	YY_BREAK
case 47:
YY_RULE_SETUP
{
    yylval->sval = new std::string(yytext);
    return WFD_STRING;
  }
	YY_BREAK
case 48:
YY_RULE_SETUP
{
    yylval->sval = new std::string(yytext);
    return WFD_STRING;
  }
	YY_BREAK
case 49:
YY_RULE_SETUP
{
    BEGIN(NUM_AS_HEX_MODE);
    return WFD_AUDIO_CODECS;
  }
	YY_BREAK
case 50:
YY_RULE_SETUP
{
    BEGIN(NUM_AS_HEX_MODE);
    return WFD_VIDEO_FORMATS;
  }
	YY_BREAK
case 51:
YY_RULE_SETUP
{
    BEGIN(NUM_AS_HEX_MODE);
    return WFD_3D_FORMATS;
  }
	YY_BREAK
case 52:
YY_RULE_SETUP
{
    return WFD_CONTENT_PROTECTION;
  }
	YY_BREAK
case 53:
YY_RULE_SETUP
{
    BEGIN(MATCH_EDID_STATE);
    return WFD_DISPLAY_EDID;
  }
	YY_BREAK
case 54:
YY_RULE_SETUP
{
    BEGIN(NUM_AS_HEX_MODE);
    return WFD_COUPLED_SINK;
  }
	YY_BREAK
case 55:
YY_RULE_SETUP
{
    BEGIN(SUPPORTED_METHODS_STATE);
    return WFD_TRIGGER_METHOD;
  }
	YY_BREAK
case 56:
YY_RULE_SETUP
{
    BEGIN(MATCH_PRESENTATION_URL);
    return WFD_PRESENTATION_URL;
  }
	YY_BREAK
case 57:
YY_RULE_SETUP
{
    return WFD_CLIENT_RTP_PORTS;
  }
	YY_BREAK
case 58:
YY_RULE_SETUP
{
    return WFD_ROUTE;
  }
	YY_BREAK
case 59:
YY_RULE_SETUP
{
    return WFD_I2C;
  }
	YY_BREAK
case 60:
YY_RULE_SETUP
{
    BEGIN(NUM_AS_HEX_MODE);
    return WFD_AV_FORMAT_CHANGE_TIMING;
  }
	YY_BREAK
case 61:
YY_RULE_SETUP
{
    BEGIN(NUM_AS_HEX_MODE);
    return WFD_PREFERRED_DISPLAY_MODE;
  }
	YY_BREAK
case 62:
YY_RULE_SETUP
{
    return WFD_UIBC_CAPABILITY;
  }
	YY_BREAK
case 63:
YY_RULE_SETUP
{
    return WFD_UIBC_SETTING;
  }
	YY_BREAK
case 64:
YY_RULE_SETUP
{
    return WFD_STANDBY_RESUME_CAPABILITY;
  }
	YY_BREAK
case 65:
YY_RULE_SETUP
{
    if (yyextra)  // Is reply.
      return WFD_STANDBY_IN_RESPONSE;
    return WFD_STANDBY_IN_REQUEST;
  }
	YY_BREAK
case 66:
YY_RULE_SETUP
{
    BEGIN(NUM_AS_HEX_MODE);
    return WFD_CONNECTOR_TYPE;
  }
	YY_BREAK
case 67:
YY_RULE_SETUP
{
    return WFD_IDR_REQUEST;
  }
	YY_BREAK
case 68:
YY_RULE_SETUP
{
    BEGIN(MATCH_STRING_STATE);
    yylval->sval = new std::string(yytext, yyleng);
    return WFD_GENERIC_PROPERTY;
  }
	YY_BREAK
case 69:
YY_RULE_SETUP
{
    std::string str(yytext, yyleng);
    str += '\0';
    errno = 0;
    yylval->nval = strtoull(str.c_str(), NULL, 10);
    if (errno)
      yyterminate();
    return WFD_NUM;
  }
	YY_BREAK
case 70:
/* rule 70 can match eol */
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
{
    BEGIN(INITIAL);
    yylval->sval = new std::string(yytext);
    return WFD_STRING;
  }
	YY_BREAK
case 71:
YY_RULE_SETUP
{
    return WFD_OPTIONS;
  }
	YY_BREAK
case 72:
YY_RULE_SETUP
{
    return WFD_SET_PARAMETER;
  }
	YY_BREAK
case 73:
YY_RULE_SETUP
{
    return WFD_GET_PARAMETER;
  }
	YY_BREAK
case 74:
YY_RULE_SETUP
{
    return WFD_SETUP;
  }
	YY_BREAK
case 75:
YY_RULE_SETUP
{
    return WFD_PLAY;
  }
	YY_BREAK
case 76:
YY_RULE_SETUP
{
    return WFD_TEARDOWN;
  }
	YY_BREAK
case 77:
YY_RULE_SETUP
{
    return WFD_PAUSE;
  }
	YY_BREAK
case 78:
YY_RULE_SETUP
{
  return WFD_TAG;
  }
	YY_BREAK
case 79:
YY_RULE_SETUP
{
    yylval->sval = new std::string(yytext);
    return WFD_PRESENTATION_URL_0;
  }
	YY_BREAK
case 80:
YY_RULE_SETUP
{
    yylval->sval = new std::string(yytext);
    return WFD_PRESENTATION_URL_1;
  }
	YY_BREAK
/* all unmatched */
case 81:
YY_RULE_SETUP
{}
	YY_BREAK
case 82:
YY_RULE_SETUP
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(MATCH_STRING_STATE):
case YY_STATE_EOF(MATCH_RESPONSE_CODE_STATE):
case YY_STATE_EOF(SUPPORTED_METHODS_STATE):
case YY_STATE_EOF(CONTENT_TYPE_STATE):
case YY_STATE_EOF(SESSION_STATE):
case YY_STATE_EOF(MATCH_PRESENTATION_URL):
case YY_STATE_EOF(NUM_AS_HEX_MODE):
case YY_STATE_EOF(MATCH_EDID_STATE):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * message_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_last_accepting_cpos;
				yy_current_state = yyg->yy_last_accepting_state;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( message_wrap(yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of message_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = yyg->yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					message_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2 ,yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			message_restart(yyin  ,yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) (yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) message_realloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size ,yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 1147 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	register int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	register char *yy_cp = yyg->yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 1147 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 1146);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yyg->yy_c_buf_p - yyg->yytext_ptr;
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					message_restart(yyin ,yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( message_wrap(yyscanner ) )
						return EOF;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void message_restart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        message_ensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            message__create_buffer(yyin,YY_BUF_SIZE ,yyscanner);
	}

	message__init_buffer(YY_CURRENT_BUFFER,input_file ,yyscanner);
	message__load_buffer_state(yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void message__switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		message_pop_buffer_state();
	 *		message_push_buffer_state(new_buffer);
     */
	message_ensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	message__load_buffer_state(yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (message_wrap()) processing, but the only time this flag
	 * is looked at is after message_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void message__load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE message__create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) message_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in message__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) message_alloc(b->yy_buf_size + 2 ,yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in message__create_buffer()" );

	b->yy_is_our_buffer = 1;

	message__init_buffer(b,file ,yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with message__create_buffer()
 * @param yyscanner The scanner object.
 */
    void message__delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		message_free((void *) b->yy_ch_buf ,yyscanner );

	message_free((void *) b ,yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a message_restart() or at EOF.
 */
    static void message__init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	message__flush_buffer(b ,yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then message__init_buffer was _probably_
     * called from message_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void message__flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		message__load_buffer_state(yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void message_push_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	message_ensure_buffer_stack(yyscanner);

	/* This block is copied from message__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from message__switch_to_buffer. */
	message__load_buffer_state(yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void message_pop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	message__delete_buffer(YY_CURRENT_BUFFER ,yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		message__load_buffer_state(yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void message_ensure_buffer_stack (yyscan_t yyscanner)
{
	int num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)message_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in message_ensure_buffer_stack()" );
								  
		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)message_realloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in message_ensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE message__scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) message_alloc(sizeof( struct yy_buffer_state ) ,yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in message__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	message__switch_to_buffer(b ,yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to message_lex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       message__scan_bytes() instead.
 */
YY_BUFFER_STATE message__scan_string (yyconst char * yystr , yyscan_t yyscanner)
{
    
	return message__scan_bytes(yystr,strlen(yystr) ,yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to message_lex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE message__scan_bytes  (yyconst char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) message_alloc(n ,yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in message__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = message__scan_buffer(buf,n ,yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in message__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg , yyscan_t yyscanner)
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE message_get_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int message_get_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int message_get_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    
        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *message_get_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *message_get_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int message_get_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *message_get_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void message_set_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void message_set_lineno (int  line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "message_set_lineno called with no buffer" , yyscanner); 
    
    yylineno = line_number;
}

/** Set the current column.
 * @param line_number
 * @param yyscanner The scanner object.
 */
void message_set_column (int  column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           yy_fatal_error( "message_set_column called with no buffer" , yyscanner); 
    
    yycolumn = column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see message__switch_to_buffer
 */
void message_set_in (FILE *  in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = in_str ;
}

void message_set_out (FILE *  out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = out_str ;
}

int message_get_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void message_set_debug (int  bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * message_get_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void message_set_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* User-visible API */

/* message_lex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */

int message_lex_init(yyscan_t* ptr_yy_globals)

{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) message_alloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* message_lex_init_extra has the same functionality as message_lex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to message_alloc in
 * the yyextra field.
 */

int message_lex_init_extra(YY_EXTRA_TYPE yy_user_defined,yyscan_t* ptr_yy_globals )

{
    struct yyguts_t dummy_yyguts;

    message_set_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }
	
    *ptr_yy_globals = (yyscan_t) message_alloc ( sizeof( struct yyguts_t ), &dummy_yyguts );
	
    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }
    
    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));
    
    message_set_extra (yy_user_defined, *ptr_yy_globals);
    
    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from message_lex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = 0;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = (char *) 0;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * message_lex_init()
     */
    return 0;
}

/* message_lex_destroy is for both reentrant and non-reentrant scanners. */
int message_lex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		message__delete_buffer(YY_CURRENT_BUFFER ,yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		message_pop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	message_free(yyg->yy_buffer_stack ,yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        message_free(yyg->yy_start_stack ,yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * message_lex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    message_free ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n , yyscan_t yyscanner)
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s , yyscan_t yyscanner)
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *message_alloc (yy_size_t  size , yyscan_t yyscanner)
{
	return (void *) malloc( size );
}

void *message_realloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner)
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void message_free (void * ptr , yyscan_t yyscanner)
{
	free( (char *) ptr );	/* see message_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

