/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.perflib.analysis;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.collect.FluentIterable;
import com.squareup.haha.guava.collect.ImmutableList;
import com.squareup.haha.guava.collect.Iterators;
import com.squareup.haha.guava.collect.TransformedIterator;
import com.squareup.haha.perflib.ClassObj;
import com.squareup.haha.perflib.Heap;
import com.squareup.haha.perflib.Instance;
import com.squareup.haha.perflib.RootObj;
import com.squareup.haha.perflib.Snapshot;
import java.util.Collection;
import java.util.Iterator;

public class Dominators {
    private final Snapshot mSnapshot;
    private final ImmutableList<Instance> mTopSort;

    public Dominators(Snapshot snapshot, ImmutableList<Instance> topSort) {
        this.mSnapshot = snapshot;
        this.mTopSort = topSort;
        for (RootObj root : snapshot.getGCRoots()) {
            Instance ref = root.getReferredInstance();
            if (ref == null) continue;
            ref.setImmediateDominator(Snapshot.SENTINEL_ROOT);
        }
    }

    private void computeDominators() {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < this.mTopSort.size(); ++i) {
                Instance node = (Instance)this.mTopSort.get(i);
                if (node.getImmediateDominator() == Snapshot.SENTINEL_ROOT) continue;
                Instance dominator = null;
                for (int j = 0; j < node.getHardReferences().size(); ++j) {
                    Instance predecessor = node.getHardReferences().get(j);
                    if (predecessor.getImmediateDominator() == null) continue;
                    if (dominator == null) {
                        dominator = predecessor;
                        continue;
                    }
                    Instance fingerA = dominator;
                    Instance fingerB = predecessor;
                    while (fingerA != fingerB) {
                        if (fingerA.getTopologicalOrder() < fingerB.getTopologicalOrder()) {
                            fingerB = fingerB.getImmediateDominator();
                            continue;
                        }
                        fingerA = fingerA.getImmediateDominator();
                    }
                    dominator = fingerA;
                }
                if (node.getImmediateDominator() == dominator) continue;
                node.setImmediateDominator(dominator);
                changed = true;
            }
        }
    }

    public void computeRetainedSizes() {
        for (Heap heap : this.mSnapshot.getHeaps()) {
            Collection<Instance> collection = heap.getInstances();
            Collection<ClassObj> collection2 = heap.getClasses();
            ImmutableList<Collection<Instance>> immutableList = ImmutableList.of(collection2, collection);
            Ascii.checkNotNull(immutableList);
            for (Instance instance : new FluentIterable<T>(immutableList){
                private /* synthetic */ Iterable val$inputs;
                {
                    this.val$inputs = iterable;
                }

                public final Iterator<T> iterator() {
                    Iterable iterable;
                    Iterable iterable2 = iterable = this.val$inputs;
                    return Iterators.concat(new TransformedIterator<Iterable<? extends T>, Iterator<? extends T>>(iterable2.iterator()){});
                }
            }) {
                instance.resetRetainedSize();
            }
        }
        this.computeDominators();
        for (Instance node : this.mSnapshot.getReachableInstances()) {
            int heapIndex = this.mSnapshot.getHeapIndex(node.getHeap());
            for (Instance dom = node.getImmediateDominator(); dom != Snapshot.SENTINEL_ROOT; dom = dom.getImmediateDominator()) {
                dom.addRetainedSize(heapIndex, node.getSize());
            }
        }
    }
}

