r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Twilio - Api
    This is the public Twilio REST API.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""


from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from twilio.base import deserialize, serialize, values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version


class FeedbackInstance(InstanceResource):
    class Issues(object):
        AUDIO_LATENCY = "audio-latency"
        DIGITS_NOT_CAPTURED = "digits-not-captured"
        DROPPED_CALL = "dropped-call"
        IMPERFECT_AUDIO = "imperfect-audio"
        INCORRECT_CALLER_ID = "incorrect-caller-id"
        ONE_WAY_AUDIO = "one-way-audio"
        POST_DIAL_DELAY = "post-dial-delay"
        UNSOLICITED_CALL = "unsolicited-call"

    """
    :ivar account_sid: The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
    :ivar date_created: The date that this resource was created, given in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
    :ivar date_updated: The date that this resource was last updated, given in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
    :ivar issues: A list of issues experienced during the call. The issues can be: `imperfect-audio`, `dropped-call`, `incorrect-caller-id`, `post-dial-delay`, `digits-not-captured`, `audio-latency`, `unsolicited-call`, or `one-way-audio`.
    :ivar quality_score: `1` to `5` quality score where `1` represents imperfect experience and `5` represents a perfect call.
    :ivar sid: A 34 character string that uniquely identifies this resource.
    """

    def __init__(
        self, version: Version, payload: Dict[str, Any], account_sid: str, call_sid: str
    ):
        super().__init__(version)

        self.account_sid: Optional[str] = payload.get("account_sid")
        self.date_created: Optional[datetime] = deserialize.rfc2822_datetime(
            payload.get("date_created")
        )
        self.date_updated: Optional[datetime] = deserialize.rfc2822_datetime(
            payload.get("date_updated")
        )
        self.issues: Optional[List["FeedbackInstance.Issues"]] = payload.get("issues")
        self.quality_score: Optional[int] = deserialize.integer(
            payload.get("quality_score")
        )
        self.sid: Optional[str] = payload.get("sid")

        self._solution = {
            "account_sid": account_sid,
            "call_sid": call_sid,
        }
        self._context: Optional[FeedbackContext] = None

    @property
    def _proxy(self) -> "FeedbackContext":
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions. All instance actions are proxied to the context

        :returns: FeedbackContext for this FeedbackInstance
        """
        if self._context is None:
            self._context = FeedbackContext(
                self._version,
                account_sid=self._solution["account_sid"],
                call_sid=self._solution["call_sid"],
            )
        return self._context

    def fetch(self) -> "FeedbackInstance":
        """
        Fetch the FeedbackInstance


        :returns: The fetched FeedbackInstance
        """
        return self._proxy.fetch()

    async def fetch_async(self) -> "FeedbackInstance":
        """
        Asynchronous coroutine to fetch the FeedbackInstance


        :returns: The fetched FeedbackInstance
        """
        return await self._proxy.fetch_async()

    def update(
        self,
        quality_score: Union[int, object] = values.unset,
        issue: Union[List["FeedbackInstance.Issues"], object] = values.unset,
    ) -> "FeedbackInstance":
        """
        Update the FeedbackInstance

        :param quality_score: The call quality expressed as an integer from `1` to `5` where `1` represents very poor call quality and `5` represents a perfect call.
        :param issue: One or more issues experienced during the call. The issues can be: `imperfect-audio`, `dropped-call`, `incorrect-caller-id`, `post-dial-delay`, `digits-not-captured`, `audio-latency`, `unsolicited-call`, or `one-way-audio`.

        :returns: The updated FeedbackInstance
        """
        return self._proxy.update(
            quality_score=quality_score,
            issue=issue,
        )

    async def update_async(
        self,
        quality_score: Union[int, object] = values.unset,
        issue: Union[List["FeedbackInstance.Issues"], object] = values.unset,
    ) -> "FeedbackInstance":
        """
        Asynchronous coroutine to update the FeedbackInstance

        :param quality_score: The call quality expressed as an integer from `1` to `5` where `1` represents very poor call quality and `5` represents a perfect call.
        :param issue: One or more issues experienced during the call. The issues can be: `imperfect-audio`, `dropped-call`, `incorrect-caller-id`, `post-dial-delay`, `digits-not-captured`, `audio-latency`, `unsolicited-call`, or `one-way-audio`.

        :returns: The updated FeedbackInstance
        """
        return await self._proxy.update_async(
            quality_score=quality_score,
            issue=issue,
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Api.V2010.FeedbackInstance {}>".format(context)


class FeedbackContext(InstanceContext):
    def __init__(self, version: Version, account_sid: str, call_sid: str):
        """
        Initialize the FeedbackContext

        :param version: Version that contains the resource
        :param account_sid: The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
        :param call_sid: The call sid that uniquely identifies the call
        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "account_sid": account_sid,
            "call_sid": call_sid,
        }
        self._uri = "/Accounts/{account_sid}/Calls/{call_sid}/Feedback.json".format(
            **self._solution
        )

    def fetch(self) -> FeedbackInstance:
        """
        Fetch the FeedbackInstance


        :returns: The fetched FeedbackInstance
        """

        payload = self._version.fetch(
            method="GET",
            uri=self._uri,
        )

        return FeedbackInstance(
            self._version,
            payload,
            account_sid=self._solution["account_sid"],
            call_sid=self._solution["call_sid"],
        )

    async def fetch_async(self) -> FeedbackInstance:
        """
        Asynchronous coroutine to fetch the FeedbackInstance


        :returns: The fetched FeedbackInstance
        """

        payload = await self._version.fetch_async(
            method="GET",
            uri=self._uri,
        )

        return FeedbackInstance(
            self._version,
            payload,
            account_sid=self._solution["account_sid"],
            call_sid=self._solution["call_sid"],
        )

    def update(
        self,
        quality_score: Union[int, object] = values.unset,
        issue: Union[List["FeedbackInstance.Issues"], object] = values.unset,
    ) -> FeedbackInstance:
        """
        Update the FeedbackInstance

        :param quality_score: The call quality expressed as an integer from `1` to `5` where `1` represents very poor call quality and `5` represents a perfect call.
        :param issue: One or more issues experienced during the call. The issues can be: `imperfect-audio`, `dropped-call`, `incorrect-caller-id`, `post-dial-delay`, `digits-not-captured`, `audio-latency`, `unsolicited-call`, or `one-way-audio`.

        :returns: The updated FeedbackInstance
        """
        data = values.of(
            {
                "QualityScore": quality_score,
                "Issue": serialize.map(issue, lambda e: e),
            }
        )

        payload = self._version.update(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return FeedbackInstance(
            self._version,
            payload,
            account_sid=self._solution["account_sid"],
            call_sid=self._solution["call_sid"],
        )

    async def update_async(
        self,
        quality_score: Union[int, object] = values.unset,
        issue: Union[List["FeedbackInstance.Issues"], object] = values.unset,
    ) -> FeedbackInstance:
        """
        Asynchronous coroutine to update the FeedbackInstance

        :param quality_score: The call quality expressed as an integer from `1` to `5` where `1` represents very poor call quality and `5` represents a perfect call.
        :param issue: One or more issues experienced during the call. The issues can be: `imperfect-audio`, `dropped-call`, `incorrect-caller-id`, `post-dial-delay`, `digits-not-captured`, `audio-latency`, `unsolicited-call`, or `one-way-audio`.

        :returns: The updated FeedbackInstance
        """
        data = values.of(
            {
                "QualityScore": quality_score,
                "Issue": serialize.map(issue, lambda e: e),
            }
        )

        payload = await self._version.update_async(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return FeedbackInstance(
            self._version,
            payload,
            account_sid=self._solution["account_sid"],
            call_sid=self._solution["call_sid"],
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Api.V2010.FeedbackContext {}>".format(context)


class FeedbackList(ListResource):
    def __init__(self, version: Version, account_sid: str, call_sid: str):
        """
        Initialize the FeedbackList

        :param version: Version that contains the resource
        :param account_sid: The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
        :param call_sid: The call sid that uniquely identifies the call

        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "account_sid": account_sid,
            "call_sid": call_sid,
        }

    def get(self) -> FeedbackContext:
        """
        Constructs a FeedbackContext

        """
        return FeedbackContext(
            self._version,
            account_sid=self._solution["account_sid"],
            call_sid=self._solution["call_sid"],
        )

    def __call__(self) -> FeedbackContext:
        """
        Constructs a FeedbackContext

        """
        return FeedbackContext(
            self._version,
            account_sid=self._solution["account_sid"],
            call_sid=self._solution["call_sid"],
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Api.V2010.FeedbackList>"
