# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base import serialize
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class StreamMessageTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.sync.v1.services("ISXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                               .sync_streams("TOXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                               .stream_messages.create(data={})

        values = {'Data': serialize.object({}), }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://sync.twilio.com/v1/Services/ISXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Streams/TOXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Messages',
            data=values,
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "sid": "TZaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "data": {}
            }
            '''
        ))

        actual = self.client.sync.v1.services("ISXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                    .sync_streams("TOXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                    .stream_messages.create(data={})

        self.assertIsNotNone(actual)
