# This file is automatically generated by generate_ufuncs.py.
# Do not edit manually!

cdef extern from "_complexstuff.h":
    # numpy/npy_math.h doesn't have correct extern "C" declarations,
    # so we must include a wrapped version first
    pass

cdef extern from "numpy/npy_math.h":
    double NPY_NAN

cimport numpy as np
from numpy cimport (
    npy_float, npy_double, npy_longdouble,
    npy_cfloat, npy_cdouble, npy_clongdouble,
    npy_int, npy_long,
    NPY_FLOAT, NPY_DOUBLE, NPY_LONGDOUBLE,
    NPY_CFLOAT, NPY_CDOUBLE, NPY_CLONGDOUBLE,
    NPY_INT, NPY_LONG)

ctypedef double complex double_complex

cdef extern from "numpy/ufuncobject.h":
    int PyUFunc_getfperr() nogil

cdef public int wrap_PyUFunc_getfperr() nogil:
    """
    Call PyUFunc_getfperr in a context where PyUFunc_API array is initialized;
    this avoids messing with the UNIQUE_SYMBOL #defines
    """
    return PyUFunc_getfperr()

cimport libc

cimport sf_error

np.import_array()
np.import_ufunc()

cdef int _set_errprint(int flag) nogil:
    return sf_error.set_print(flag)

cimport scipy.special._ufuncs_cxx

def errprint(inflag=None):
    """
    errprint(inflag=None)

    Sets or returns the error printing flag for special functions.

    Parameters
    ----------
    inflag : bool, optional
        Whether warnings concerning evaluation of special functions in
        scipy.special are shown. If omitted, no change is made to the
        current setting.

    Returns
    -------
    old_flag
        Previous value of the error flag

    """
    if inflag is not None:
        scipy.special._ufuncs_cxx._set_errprint(int(bool(inflag)))
        return sf_error.set_print(int(bool(inflag)))
    else:
        return sf_error.get_print()
cdef void loop_d_dddd__As_ffff_f(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *op0 = args[4]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(double, double, double, double) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0], <double>(<float*>ip2)[0], <double>(<float*>ip3)[0])
        (<float *>op0)[0] = <float>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        op0 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_f_f__As_f_f(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1]
    cdef float ov0
    for i in range(n):
        ov0 = (<float(*)(float) nogil>func)(<float>(<float*>ip0)[0])
        (<float *>op0)[0] = <float>ov0
        ip0 += steps[0]
        op0 += steps[1]
    sf_error.check_fpe(func_name)

cdef void loop_d_ddi_d_As_ddl_dd(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3], *op1 = args[4]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        if <int>(<long*>ip2)[0] == (<long*>ip2)[0]:
            ov0 = (<double(*)(double, double, int, double *) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0], <int>(<long*>ip2)[0], &ov1)
        else:
            sf_error.error(func_name, sf_error.DOMAIN, "invalid input argument")
            ov0 = <double>NPY_NAN
            ov1 = <double>NPY_NAN
        (<double *>op0)[0] = <double>ov0
        (<double *>op1)[0] = <double>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
        op1 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_i_ddddd_dd_As_ddddd_dd(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *ip4 = args[4], *op0 = args[5], *op1 = args[6]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        (<int(*)(double, double, double, double, double, double *, double *) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0], <double>(<double*>ip2)[0], <double>(<double*>ip3)[0], <double>(<double*>ip4)[0], &ov0, &ov1)
        (<double *>op0)[0] = <double>ov0
        (<double *>op1)[0] = <double>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        ip4 += steps[4]
        op0 += steps[5]
        op1 += steps[6]
    sf_error.check_fpe(func_name)

cdef void loop_D_dD__As_dD_D(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double, double complex) nogil>func)(<double>(<double*>ip0)[0], <double complex>(<double complex*>ip1)[0])
        (<double complex *>op0)[0] = <double complex>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_i_d_dd_As_d_dd(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        (<int(*)(double, double *, double *) nogil>func)(<double>(<double*>ip0)[0], &ov0, &ov1)
        (<double *>op0)[0] = <double>ov0
        (<double *>op1)[0] = <double>ov1
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_D_DD__As_DD_D(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double complex, double complex) nogil>func)(<double complex>(<double complex*>ip0)[0], <double complex>(<double complex*>ip1)[0])
        (<double complex *>op0)[0] = <double complex>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_D_D__As_D_D(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double complex) nogil>func)(<double complex>(<double complex*>ip0)[0])
        (<double complex *>op0)[0] = <double complex>ov0
        ip0 += steps[0]
        op0 += steps[1]
    sf_error.check_fpe(func_name)

cdef void loop_d_dddi_d_As_fffl_ff(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *op0 = args[4], *op1 = args[5]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        if <int>(<long*>ip3)[0] == (<long*>ip3)[0]:
            ov0 = (<double(*)(double, double, double, int, double *) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0], <double>(<float*>ip2)[0], <int>(<long*>ip3)[0], &ov1)
        else:
            sf_error.error(func_name, sf_error.DOMAIN, "invalid input argument")
            ov0 = <double>NPY_NAN
            ov1 = <double>NPY_NAN
        (<float *>op0)[0] = <float>ov0
        (<float *>op1)[0] = <float>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        op0 += steps[4]
        op1 += steps[5]
    sf_error.check_fpe(func_name)

cdef void loop_i_D_DD_As_F_FF(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2]
    cdef double complex ov0
    cdef double complex ov1
    for i in range(n):
        (<int(*)(double complex, double complex *, double complex *) nogil>func)(<double complex>(<float complex*>ip0)[0], &ov0, &ov1)
        (<float complex *>op0)[0] = <float complex>ov0
        (<float complex *>op1)[0] = <float complex>ov1
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_i_d_DDDD_As_f_FFFF(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2], *op2 = args[3], *op3 = args[4]
    cdef double complex ov0
    cdef double complex ov1
    cdef double complex ov2
    cdef double complex ov3
    for i in range(n):
        (<int(*)(double, double complex *, double complex *, double complex *, double complex *) nogil>func)(<double>(<float*>ip0)[0], &ov0, &ov1, &ov2, &ov3)
        (<float complex *>op0)[0] = <float complex>ov0
        (<float complex *>op1)[0] = <float complex>ov1
        (<float complex *>op2)[0] = <float complex>ov2
        (<float complex *>op3)[0] = <float complex>ov3
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
        op2 += steps[3]
        op3 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_i_D_DDDD_As_F_FFFF(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2], *op2 = args[3], *op3 = args[4]
    cdef double complex ov0
    cdef double complex ov1
    cdef double complex ov2
    cdef double complex ov3
    for i in range(n):
        (<int(*)(double complex, double complex *, double complex *, double complex *, double complex *) nogil>func)(<double complex>(<float complex*>ip0)[0], &ov0, &ov1, &ov2, &ov3)
        (<float complex *>op0)[0] = <float complex>ov0
        (<float complex *>op1)[0] = <float complex>ov1
        (<float complex *>op2)[0] = <float complex>ov2
        (<float complex *>op3)[0] = <float complex>ov3
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
        op2 += steps[3]
        op3 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_d_dddi_d_As_dddl_dd(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *op0 = args[4], *op1 = args[5]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        if <int>(<long*>ip3)[0] == (<long*>ip3)[0]:
            ov0 = (<double(*)(double, double, double, int, double *) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0], <double>(<double*>ip2)[0], <int>(<long*>ip3)[0], &ov1)
        else:
            sf_error.error(func_name, sf_error.DOMAIN, "invalid input argument")
            ov0 = <double>NPY_NAN
            ov1 = <double>NPY_NAN
        (<double *>op0)[0] = <double>ov0
        (<double *>op1)[0] = <double>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        op0 += steps[4]
        op1 += steps[5]
    sf_error.check_fpe(func_name)

cdef void loop_d_ldd__As_ldd_d(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(long, double, double) nogil>func)(<long>(<long*>ip0)[0], <double>(<double*>ip1)[0], <double>(<double*>ip2)[0])
        (<double *>op0)[0] = <double>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_d_ddd__As_fff_f(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(double, double, double) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0], <double>(<float*>ip2)[0])
        (<float *>op0)[0] = <float>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_d_dd__As_ff_f(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(double, double) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0])
        (<float *>op0)[0] = <float>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_i_dd_dddd_As_ff_ffff(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2], *op1 = args[3], *op2 = args[4], *op3 = args[5]
    cdef double ov0
    cdef double ov1
    cdef double ov2
    cdef double ov3
    for i in range(n):
        (<int(*)(double, double, double *, double *, double *, double *) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0], &ov0, &ov1, &ov2, &ov3)
        (<float *>op0)[0] = <float>ov0
        (<float *>op1)[0] = <float>ov1
        (<float *>op2)[0] = <float>ov2
        (<float *>op3)[0] = <float>ov3
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
        op1 += steps[3]
        op2 += steps[4]
        op3 += steps[5]
    sf_error.check_fpe(func_name)

cdef void loop_i_dd_dd_As_dd_dd(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2], *op1 = args[3]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        (<int(*)(double, double, double *, double *) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0], &ov0, &ov1)
        (<double *>op0)[0] = <double>ov0
        (<double *>op1)[0] = <double>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
        op1 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_i_ddd_dd_As_fff_ff(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3], *op1 = args[4]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        (<int(*)(double, double, double, double *, double *) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0], <double>(<float*>ip2)[0], &ov0, &ov1)
        (<float *>op0)[0] = <float>ov0
        (<float *>op1)[0] = <float>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
        op1 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_D_ddD__As_ddD_D(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double, double, double complex) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0], <double complex>(<double complex*>ip2)[0])
        (<double complex *>op0)[0] = <double complex>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_D_dddD__As_dddD_D(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *op0 = args[4]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double, double, double, double complex) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0], <double>(<double*>ip2)[0], <double complex>(<double complex*>ip3)[0])
        (<double complex *>op0)[0] = <double complex>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        op0 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_i_d_dddd_As_d_dddd(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2], *op2 = args[3], *op3 = args[4]
    cdef double ov0
    cdef double ov1
    cdef double ov2
    cdef double ov3
    for i in range(n):
        (<int(*)(double, double *, double *, double *, double *) nogil>func)(<double>(<double*>ip0)[0], &ov0, &ov1, &ov2, &ov3)
        (<double *>op0)[0] = <double>ov0
        (<double *>op1)[0] = <double>ov1
        (<double *>op2)[0] = <double>ov2
        (<double *>op3)[0] = <double>ov3
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
        op2 += steps[3]
        op3 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_i_ddddd_dd_As_fffff_ff(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *ip4 = args[4], *op0 = args[5], *op1 = args[6]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        (<int(*)(double, double, double, double, double, double *, double *) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0], <double>(<float*>ip2)[0], <double>(<float*>ip3)[0], <double>(<float*>ip4)[0], &ov0, &ov1)
        (<float *>op0)[0] = <float>ov0
        (<float *>op1)[0] = <float>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        ip4 += steps[4]
        op0 += steps[5]
        op1 += steps[6]
    sf_error.check_fpe(func_name)

cdef void loop_D_D__As_F_F(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double complex) nogil>func)(<double complex>(<float complex*>ip0)[0])
        (<float complex *>op0)[0] = <float complex>ov0
        ip0 += steps[0]
        op0 += steps[1]
    sf_error.check_fpe(func_name)

cdef void loop_i_d_DDDD_As_d_DDDD(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2], *op2 = args[3], *op3 = args[4]
    cdef double complex ov0
    cdef double complex ov1
    cdef double complex ov2
    cdef double complex ov3
    for i in range(n):
        (<int(*)(double, double complex *, double complex *, double complex *, double complex *) nogil>func)(<double>(<double*>ip0)[0], &ov0, &ov1, &ov2, &ov3)
        (<double complex *>op0)[0] = <double complex>ov0
        (<double complex *>op1)[0] = <double complex>ov1
        (<double complex *>op2)[0] = <double complex>ov2
        (<double complex *>op3)[0] = <double complex>ov3
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
        op2 += steps[3]
        op3 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_i_ddd_dd_As_ddd_dd(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3], *op1 = args[4]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        (<int(*)(double, double, double, double *, double *) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0], <double>(<double*>ip2)[0], &ov0, &ov1)
        (<double *>op0)[0] = <double>ov0
        (<double *>op1)[0] = <double>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
        op1 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_D_Dld__As_Dld_D(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double complex, long, double) nogil>func)(<double complex>(<double complex*>ip0)[0], <long>(<long*>ip1)[0], <double>(<double*>ip2)[0])
        (<double complex *>op0)[0] = <double complex>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_d_ddi_d_As_ffl_ff(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3], *op1 = args[4]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        if <int>(<long*>ip2)[0] == (<long*>ip2)[0]:
            ov0 = (<double(*)(double, double, int, double *) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0], <int>(<long*>ip2)[0], &ov1)
        else:
            sf_error.error(func_name, sf_error.DOMAIN, "invalid input argument")
            ov0 = <double>NPY_NAN
            ov1 = <double>NPY_NAN
        (<float *>op0)[0] = <float>ov0
        (<float *>op1)[0] = <float>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
        op1 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_i_dd_dd_As_ff_ff(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2], *op1 = args[3]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        (<int(*)(double, double, double *, double *) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0], &ov0, &ov1)
        (<float *>op0)[0] = <float>ov0
        (<float *>op1)[0] = <float>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
        op1 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_D_dddD__As_fffF_F(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *op0 = args[4]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double, double, double, double complex) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0], <double>(<float*>ip2)[0], <double complex>(<float complex*>ip3)[0])
        (<float complex *>op0)[0] = <float complex>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        op0 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_d_id__As_lf_f(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2]
    cdef double ov0
    for i in range(n):
        if <int>(<long*>ip0)[0] == (<long*>ip0)[0]:
            ov0 = (<double(*)(int, double) nogil>func)(<int>(<long*>ip0)[0], <double>(<float*>ip1)[0])
        else:
            sf_error.error(func_name, sf_error.DOMAIN, "invalid input argument")
            ov0 = <double>NPY_NAN
        (<float *>op0)[0] = <float>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_d_dddd__As_dddd_d(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *op0 = args[4]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(double, double, double, double) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0], <double>(<double*>ip2)[0], <double>(<double*>ip3)[0])
        (<double *>op0)[0] = <double>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        op0 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_D_DD__As_FF_F(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double complex, double complex) nogil>func)(<double complex>(<float complex*>ip0)[0], <double complex>(<float complex*>ip1)[0])
        (<float complex *>op0)[0] = <float complex>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_d_iid__As_lld_d(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3]
    cdef double ov0
    for i in range(n):
        if <int>(<long*>ip0)[0] == (<long*>ip0)[0] and <int>(<long*>ip1)[0] == (<long*>ip1)[0]:
            ov0 = (<double(*)(int, int, double) nogil>func)(<int>(<long*>ip0)[0], <int>(<long*>ip1)[0], <double>(<double*>ip2)[0])
        else:
            sf_error.error(func_name, sf_error.DOMAIN, "invalid input argument")
            ov0 = <double>NPY_NAN
        (<double *>op0)[0] = <double>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_i_d_DD_As_d_DD(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2]
    cdef double complex ov0
    cdef double complex ov1
    for i in range(n):
        (<int(*)(double, double complex *, double complex *) nogil>func)(<double>(<double*>ip0)[0], &ov0, &ov1)
        (<double complex *>op0)[0] = <double complex>ov0
        (<double complex *>op1)[0] = <double complex>ov1
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_d_d__As_f_f(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(double) nogil>func)(<double>(<float*>ip0)[0])
        (<float *>op0)[0] = <float>ov0
        ip0 += steps[0]
        op0 += steps[1]
    sf_error.check_fpe(func_name)

cdef void loop_d_d__As_d_d(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(double) nogil>func)(<double>(<double*>ip0)[0])
        (<double *>op0)[0] = <double>ov0
        ip0 += steps[0]
        op0 += steps[1]
    sf_error.check_fpe(func_name)

cdef void loop_d_dddd_d_As_ffff_ff(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *op0 = args[4], *op1 = args[5]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        ov0 = (<double(*)(double, double, double, double, double *) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0], <double>(<float*>ip2)[0], <double>(<float*>ip3)[0], &ov1)
        (<float *>op0)[0] = <float>ov0
        (<float *>op1)[0] = <float>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        op0 += steps[4]
        op1 += steps[5]
    sf_error.check_fpe(func_name)

cdef void loop_d_iid__As_llf_f(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3]
    cdef double ov0
    for i in range(n):
        if <int>(<long*>ip0)[0] == (<long*>ip0)[0] and <int>(<long*>ip1)[0] == (<long*>ip1)[0]:
            ov0 = (<double(*)(int, int, double) nogil>func)(<int>(<long*>ip0)[0], <int>(<long*>ip1)[0], <double>(<float*>ip2)[0])
        else:
            sf_error.error(func_name, sf_error.DOMAIN, "invalid input argument")
            ov0 = <double>NPY_NAN
        (<float *>op0)[0] = <float>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_d_lddd__As_lddd_d(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *op0 = args[4]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(long, double, double, double) nogil>func)(<long>(<long*>ip0)[0], <double>(<double*>ip1)[0], <double>(<double*>ip2)[0], <double>(<double*>ip3)[0])
        (<double *>op0)[0] = <double>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        op0 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_D_ddD__As_ffF_F(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double, double, double complex) nogil>func)(<double>(<float*>ip0)[0], <double>(<float*>ip1)[0], <double complex>(<float complex*>ip2)[0])
        (<float complex *>op0)[0] = <float complex>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_i_d_dddd_As_f_ffff(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2], *op2 = args[3], *op3 = args[4]
    cdef double ov0
    cdef double ov1
    cdef double ov2
    cdef double ov3
    for i in range(n):
        (<int(*)(double, double *, double *, double *, double *) nogil>func)(<double>(<float*>ip0)[0], &ov0, &ov1, &ov2, &ov3)
        (<float *>op0)[0] = <float>ov0
        (<float *>op1)[0] = <float>ov1
        (<float *>op2)[0] = <float>ov2
        (<float *>op3)[0] = <float>ov3
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
        op2 += steps[3]
        op3 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_d_lddd__As_lfff_f(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *op0 = args[4]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(long, double, double, double) nogil>func)(<long>(<long*>ip0)[0], <double>(<float*>ip1)[0], <double>(<float*>ip2)[0], <double>(<float*>ip3)[0])
        (<float *>op0)[0] = <float>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        op0 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_d_dddd_d_As_dddd_dd(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *ip3 = args[3], *op0 = args[4], *op1 = args[5]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        ov0 = (<double(*)(double, double, double, double, double *) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0], <double>(<double*>ip2)[0], <double>(<double*>ip3)[0], &ov1)
        (<double *>op0)[0] = <double>ov0
        (<double *>op1)[0] = <double>ov1
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        ip3 += steps[3]
        op0 += steps[4]
        op1 += steps[5]
    sf_error.check_fpe(func_name)

cdef void loop_i_D_DD_As_D_DD(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2]
    cdef double complex ov0
    cdef double complex ov1
    for i in range(n):
        (<int(*)(double complex, double complex *, double complex *) nogil>func)(<double complex>(<double complex*>ip0)[0], &ov0, &ov1)
        (<double complex *>op0)[0] = <double complex>ov0
        (<double complex *>op1)[0] = <double complex>ov1
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_D_Dld__As_Flf_F(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double complex, long, double) nogil>func)(<double complex>(<float complex*>ip0)[0], <long>(<long*>ip1)[0], <double>(<float*>ip2)[0])
        (<float complex *>op0)[0] = <float complex>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_i_dd_dddd_As_dd_dddd(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2], *op1 = args[3], *op2 = args[4], *op3 = args[5]
    cdef double ov0
    cdef double ov1
    cdef double ov2
    cdef double ov3
    for i in range(n):
        (<int(*)(double, double, double *, double *, double *, double *) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0], &ov0, &ov1, &ov2, &ov3)
        (<double *>op0)[0] = <double>ov0
        (<double *>op1)[0] = <double>ov1
        (<double *>op2)[0] = <double>ov2
        (<double *>op3)[0] = <double>ov3
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
        op1 += steps[3]
        op2 += steps[4]
        op3 += steps[5]
    sf_error.check_fpe(func_name)

cdef void loop_D_dD__As_fF_F(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2]
    cdef double complex ov0
    for i in range(n):
        ov0 = (<double complex(*)(double, double complex) nogil>func)(<double>(<float*>ip0)[0], <double complex>(<float complex*>ip1)[0])
        (<float complex *>op0)[0] = <float complex>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_i_d_dd_As_f_ff(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2]
    cdef double ov0
    cdef double ov1
    for i in range(n):
        (<int(*)(double, double *, double *) nogil>func)(<double>(<float*>ip0)[0], &ov0, &ov1)
        (<float *>op0)[0] = <float>ov0
        (<float *>op1)[0] = <float>ov1
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_d_ld__As_lf_f(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(long, double) nogil>func)(<long>(<long*>ip0)[0], <double>(<float*>ip1)[0])
        (<float *>op0)[0] = <float>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_d_id__As_ld_d(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2]
    cdef double ov0
    for i in range(n):
        if <int>(<long*>ip0)[0] == (<long*>ip0)[0]:
            ov0 = (<double(*)(int, double) nogil>func)(<int>(<long*>ip0)[0], <double>(<double*>ip1)[0])
        else:
            sf_error.error(func_name, sf_error.DOMAIN, "invalid input argument")
            ov0 = <double>NPY_NAN
        (<double *>op0)[0] = <double>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_d_dd__As_dd_d(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(double, double) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0])
        (<double *>op0)[0] = <double>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_i_d_DD_As_f_FF(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2]
    cdef double complex ov0
    cdef double complex ov1
    for i in range(n):
        (<int(*)(double, double complex *, double complex *) nogil>func)(<double>(<float*>ip0)[0], &ov0, &ov1)
        (<float complex *>op0)[0] = <float complex>ov0
        (<float complex *>op1)[0] = <float complex>ov1
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
    sf_error.check_fpe(func_name)

cdef void loop_d_ddd__As_ddd_d(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(double, double, double) nogil>func)(<double>(<double*>ip0)[0], <double>(<double*>ip1)[0], <double>(<double*>ip2)[0])
        (<double *>op0)[0] = <double>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_i_D_DDDD_As_D_DDDD(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1], *op1 = args[2], *op2 = args[3], *op3 = args[4]
    cdef double complex ov0
    cdef double complex ov1
    cdef double complex ov2
    cdef double complex ov3
    for i in range(n):
        (<int(*)(double complex, double complex *, double complex *, double complex *, double complex *) nogil>func)(<double complex>(<double complex*>ip0)[0], &ov0, &ov1, &ov2, &ov3)
        (<double complex *>op0)[0] = <double complex>ov0
        (<double complex *>op1)[0] = <double complex>ov1
        (<double complex *>op2)[0] = <double complex>ov2
        (<double complex *>op3)[0] = <double complex>ov3
        ip0 += steps[0]
        op0 += steps[1]
        op1 += steps[2]
        op2 += steps[3]
        op3 += steps[4]
    sf_error.check_fpe(func_name)

cdef void loop_g_g__As_g_g(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *op0 = args[1]
    cdef long double ov0
    for i in range(n):
        ov0 = (<long double(*)(long double) nogil>func)(<long double>(<long double*>ip0)[0])
        (<long double *>op0)[0] = <long double>ov0
        ip0 += steps[0]
        op0 += steps[1]
    sf_error.check_fpe(func_name)

cdef void loop_d_ldd__As_lff_f(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *ip2 = args[2], *op0 = args[3]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(long, double, double) nogil>func)(<long>(<long*>ip0)[0], <double>(<float*>ip1)[0], <double>(<float*>ip2)[0])
        (<float *>op0)[0] = <float>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        ip2 += steps[2]
        op0 += steps[3]
    sf_error.check_fpe(func_name)

cdef void loop_d_ld__As_ld_d(char **args, np.npy_intp *dims, np.npy_intp *steps, void *data) nogil:
    cdef np.npy_intp i, n = dims[0]
    cdef void *func = (<void**>data)[0]
    cdef char *func_name = <char*>(<void**>data)[1]
    cdef char *ip0 = args[0], *ip1 = args[1], *op0 = args[2]
    cdef double ov0
    for i in range(n):
        ov0 = (<double(*)(long, double) nogil>func)(<long>(<long*>ip0)[0], <double>(<double*>ip1)[0])
        (<double *>op0)[0] = <double>ov0
        ip0 += steps[0]
        ip1 += steps[1]
        op0 += steps[2]
    sf_error.check_fpe(func_name)

from lambertw cimport lambertw_scalar as _func_lambertw_scalar
ctypedef double complex _proto_lambertw_scalar_t(double complex, long, double) nogil
cdef _proto_lambertw_scalar_t *_proto_lambertw_scalar_t_var = &_func_lambertw_scalar
cdef extern from "_ufuncs_defs.h":
    cdef double _func_struve_asymp_large_z "struve_asymp_large_z"(double, double, int, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_struve_bessel_series "struve_bessel_series"(double, double, int, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_struve_power_series "struve_power_series"(double, double, int, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_airy_wrap "airy_wrap"(double, double *, double *, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_cairy_wrap "cairy_wrap"(double complex, double complex *, double complex *, double complex *, double complex *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_cairy_wrap_e_real "cairy_wrap_e_real"(double, double *, double *, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_cairy_wrap_e "cairy_wrap_e"(double complex, double complex *, double complex *, double complex *, double complex *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_bdtr "bdtr"(int, int, double) nogil
from _legacy cimport bdtr_unsafe as _func_bdtr_unsafe
ctypedef double _proto_bdtr_unsafe_t(double, double, double) nogil
cdef _proto_bdtr_unsafe_t *_proto_bdtr_unsafe_t_var = &_func_bdtr_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_bdtrc "bdtrc"(int, int, double) nogil
from _legacy cimport bdtrc_unsafe as _func_bdtrc_unsafe
ctypedef double _proto_bdtrc_unsafe_t(double, double, double) nogil
cdef _proto_bdtrc_unsafe_t *_proto_bdtrc_unsafe_t_var = &_func_bdtrc_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_bdtri "bdtri"(int, int, double) nogil
from _legacy cimport bdtri_unsafe as _func_bdtri_unsafe
ctypedef double _proto_bdtri_unsafe_t(double, double, double) nogil
cdef _proto_bdtri_unsafe_t *_proto_bdtri_unsafe_t_var = &_func_bdtri_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfbin2_wrap "cdfbin2_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfbin3_wrap "cdfbin3_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_bei_wrap "bei_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_beip_wrap "beip_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_ber_wrap "ber_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_berp_wrap "berp_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_besselpoly "besselpoly"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_beta "beta"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_incbet "incbet"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_incbi "incbi"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_lbeta "lbeta"(double, double) nogil
from orthogonal_eval cimport binom as _func_binom
ctypedef double _proto_binom_t(double, double) nogil
cdef _proto_binom_t *_proto_binom_t_var = &_func_binom
cdef extern from "_ufuncs_defs.h":
    cdef double _func_btdtr "btdtr"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_incbi "incbi"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfbet3_wrap "cdfbet3_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfbet4_wrap "cdfbet4_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cbrt "cbrt"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_chdtr "chdtr"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_chdtrc "chdtrc"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_chdtri "chdtri"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfchi3_wrap "cdfchi3_wrap"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfchn1_wrap "cdfchn1_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfchn3_wrap "cdfchn3_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfchn4_wrap "cdfchn4_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfchn2_wrap "cdfchn2_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cosdg "cosdg"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cosm1 "cosm1"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cotdg "cotdg"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_ellpe "ellpe"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_ellie "ellie"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_ellpj "ellpj"(double, double, double *, double *, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_ellik "ellik"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_ellpk "ellpk"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_erf "erf"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_erfc "erfc"(double) nogil
from orthogonal_eval cimport eval_chebyc as _func_eval_chebyc
ctypedef double _proto_eval_chebyc_double__t(double, double) nogil
cdef _proto_eval_chebyc_double__t *_proto_eval_chebyc_double__t_var = &_func_eval_chebyc[double]
from orthogonal_eval cimport eval_chebyc as _func_eval_chebyc
ctypedef double complex _proto_eval_chebyc_double_complex__t(double, double complex) nogil
cdef _proto_eval_chebyc_double_complex__t *_proto_eval_chebyc_double_complex__t_var = &_func_eval_chebyc[double_complex]
from orthogonal_eval cimport eval_chebyc_l as _func_eval_chebyc_l
ctypedef double _proto_eval_chebyc_l_t(long, double) nogil
cdef _proto_eval_chebyc_l_t *_proto_eval_chebyc_l_t_var = &_func_eval_chebyc_l
from orthogonal_eval cimport eval_chebys as _func_eval_chebys
ctypedef double _proto_eval_chebys_double__t(double, double) nogil
cdef _proto_eval_chebys_double__t *_proto_eval_chebys_double__t_var = &_func_eval_chebys[double]
from orthogonal_eval cimport eval_chebys as _func_eval_chebys
ctypedef double complex _proto_eval_chebys_double_complex__t(double, double complex) nogil
cdef _proto_eval_chebys_double_complex__t *_proto_eval_chebys_double_complex__t_var = &_func_eval_chebys[double_complex]
from orthogonal_eval cimport eval_chebys_l as _func_eval_chebys_l
ctypedef double _proto_eval_chebys_l_t(long, double) nogil
cdef _proto_eval_chebys_l_t *_proto_eval_chebys_l_t_var = &_func_eval_chebys_l
from orthogonal_eval cimport eval_chebyt as _func_eval_chebyt
ctypedef double _proto_eval_chebyt_double__t(double, double) nogil
cdef _proto_eval_chebyt_double__t *_proto_eval_chebyt_double__t_var = &_func_eval_chebyt[double]
from orthogonal_eval cimport eval_chebyt as _func_eval_chebyt
ctypedef double complex _proto_eval_chebyt_double_complex__t(double, double complex) nogil
cdef _proto_eval_chebyt_double_complex__t *_proto_eval_chebyt_double_complex__t_var = &_func_eval_chebyt[double_complex]
from orthogonal_eval cimport eval_chebyt_l as _func_eval_chebyt_l
ctypedef double _proto_eval_chebyt_l_t(long, double) nogil
cdef _proto_eval_chebyt_l_t *_proto_eval_chebyt_l_t_var = &_func_eval_chebyt_l
from orthogonal_eval cimport eval_chebyu as _func_eval_chebyu
ctypedef double _proto_eval_chebyu_double__t(double, double) nogil
cdef _proto_eval_chebyu_double__t *_proto_eval_chebyu_double__t_var = &_func_eval_chebyu[double]
from orthogonal_eval cimport eval_chebyu as _func_eval_chebyu
ctypedef double complex _proto_eval_chebyu_double_complex__t(double, double complex) nogil
cdef _proto_eval_chebyu_double_complex__t *_proto_eval_chebyu_double_complex__t_var = &_func_eval_chebyu[double_complex]
from orthogonal_eval cimport eval_chebyu_l as _func_eval_chebyu_l
ctypedef double _proto_eval_chebyu_l_t(long, double) nogil
cdef _proto_eval_chebyu_l_t *_proto_eval_chebyu_l_t_var = &_func_eval_chebyu_l
from orthogonal_eval cimport eval_gegenbauer as _func_eval_gegenbauer
ctypedef double _proto_eval_gegenbauer_double__t(double, double, double) nogil
cdef _proto_eval_gegenbauer_double__t *_proto_eval_gegenbauer_double__t_var = &_func_eval_gegenbauer[double]
from orthogonal_eval cimport eval_gegenbauer as _func_eval_gegenbauer
ctypedef double complex _proto_eval_gegenbauer_double_complex__t(double, double, double complex) nogil
cdef _proto_eval_gegenbauer_double_complex__t *_proto_eval_gegenbauer_double_complex__t_var = &_func_eval_gegenbauer[double_complex]
from orthogonal_eval cimport eval_gegenbauer_l as _func_eval_gegenbauer_l
ctypedef double _proto_eval_gegenbauer_l_t(long, double, double) nogil
cdef _proto_eval_gegenbauer_l_t *_proto_eval_gegenbauer_l_t_var = &_func_eval_gegenbauer_l
from orthogonal_eval cimport eval_genlaguerre as _func_eval_genlaguerre
ctypedef double _proto_eval_genlaguerre_double__t(double, double, double) nogil
cdef _proto_eval_genlaguerre_double__t *_proto_eval_genlaguerre_double__t_var = &_func_eval_genlaguerre[double]
from orthogonal_eval cimport eval_genlaguerre as _func_eval_genlaguerre
ctypedef double complex _proto_eval_genlaguerre_double_complex__t(double, double, double complex) nogil
cdef _proto_eval_genlaguerre_double_complex__t *_proto_eval_genlaguerre_double_complex__t_var = &_func_eval_genlaguerre[double_complex]
from orthogonal_eval cimport eval_genlaguerre_l as _func_eval_genlaguerre_l
ctypedef double _proto_eval_genlaguerre_l_t(long, double, double) nogil
cdef _proto_eval_genlaguerre_l_t *_proto_eval_genlaguerre_l_t_var = &_func_eval_genlaguerre_l
from orthogonal_eval cimport eval_hermite as _func_eval_hermite
ctypedef double _proto_eval_hermite_t(long, double) nogil
cdef _proto_eval_hermite_t *_proto_eval_hermite_t_var = &_func_eval_hermite
from orthogonal_eval cimport eval_hermitenorm as _func_eval_hermitenorm
ctypedef double _proto_eval_hermitenorm_t(long, double) nogil
cdef _proto_eval_hermitenorm_t *_proto_eval_hermitenorm_t_var = &_func_eval_hermitenorm
from orthogonal_eval cimport eval_jacobi as _func_eval_jacobi
ctypedef double _proto_eval_jacobi_double__t(double, double, double, double) nogil
cdef _proto_eval_jacobi_double__t *_proto_eval_jacobi_double__t_var = &_func_eval_jacobi[double]
from orthogonal_eval cimport eval_jacobi as _func_eval_jacobi
ctypedef double complex _proto_eval_jacobi_double_complex__t(double, double, double, double complex) nogil
cdef _proto_eval_jacobi_double_complex__t *_proto_eval_jacobi_double_complex__t_var = &_func_eval_jacobi[double_complex]
from orthogonal_eval cimport eval_jacobi_l as _func_eval_jacobi_l
ctypedef double _proto_eval_jacobi_l_t(long, double, double, double) nogil
cdef _proto_eval_jacobi_l_t *_proto_eval_jacobi_l_t_var = &_func_eval_jacobi_l
from orthogonal_eval cimport eval_laguerre as _func_eval_laguerre
ctypedef double _proto_eval_laguerre_double__t(double, double) nogil
cdef _proto_eval_laguerre_double__t *_proto_eval_laguerre_double__t_var = &_func_eval_laguerre[double]
from orthogonal_eval cimport eval_laguerre as _func_eval_laguerre
ctypedef double complex _proto_eval_laguerre_double_complex__t(double, double complex) nogil
cdef _proto_eval_laguerre_double_complex__t *_proto_eval_laguerre_double_complex__t_var = &_func_eval_laguerre[double_complex]
from orthogonal_eval cimport eval_laguerre_l as _func_eval_laguerre_l
ctypedef double _proto_eval_laguerre_l_t(long, double) nogil
cdef _proto_eval_laguerre_l_t *_proto_eval_laguerre_l_t_var = &_func_eval_laguerre_l
from orthogonal_eval cimport eval_legendre as _func_eval_legendre
ctypedef double _proto_eval_legendre_double__t(double, double) nogil
cdef _proto_eval_legendre_double__t *_proto_eval_legendre_double__t_var = &_func_eval_legendre[double]
from orthogonal_eval cimport eval_legendre as _func_eval_legendre
ctypedef double complex _proto_eval_legendre_double_complex__t(double, double complex) nogil
cdef _proto_eval_legendre_double_complex__t *_proto_eval_legendre_double_complex__t_var = &_func_eval_legendre[double_complex]
from orthogonal_eval cimport eval_legendre_l as _func_eval_legendre_l
ctypedef double _proto_eval_legendre_l_t(long, double) nogil
cdef _proto_eval_legendre_l_t *_proto_eval_legendre_l_t_var = &_func_eval_legendre_l
from orthogonal_eval cimport eval_sh_chebyt as _func_eval_sh_chebyt
ctypedef double _proto_eval_sh_chebyt_double__t(double, double) nogil
cdef _proto_eval_sh_chebyt_double__t *_proto_eval_sh_chebyt_double__t_var = &_func_eval_sh_chebyt[double]
from orthogonal_eval cimport eval_sh_chebyt as _func_eval_sh_chebyt
ctypedef double complex _proto_eval_sh_chebyt_double_complex__t(double, double complex) nogil
cdef _proto_eval_sh_chebyt_double_complex__t *_proto_eval_sh_chebyt_double_complex__t_var = &_func_eval_sh_chebyt[double_complex]
from orthogonal_eval cimport eval_sh_chebyt_l as _func_eval_sh_chebyt_l
ctypedef double _proto_eval_sh_chebyt_l_t(long, double) nogil
cdef _proto_eval_sh_chebyt_l_t *_proto_eval_sh_chebyt_l_t_var = &_func_eval_sh_chebyt_l
from orthogonal_eval cimport eval_sh_chebyu as _func_eval_sh_chebyu
ctypedef double _proto_eval_sh_chebyu_double__t(double, double) nogil
cdef _proto_eval_sh_chebyu_double__t *_proto_eval_sh_chebyu_double__t_var = &_func_eval_sh_chebyu[double]
from orthogonal_eval cimport eval_sh_chebyu as _func_eval_sh_chebyu
ctypedef double complex _proto_eval_sh_chebyu_double_complex__t(double, double complex) nogil
cdef _proto_eval_sh_chebyu_double_complex__t *_proto_eval_sh_chebyu_double_complex__t_var = &_func_eval_sh_chebyu[double_complex]
from orthogonal_eval cimport eval_sh_chebyu_l as _func_eval_sh_chebyu_l
ctypedef double _proto_eval_sh_chebyu_l_t(long, double) nogil
cdef _proto_eval_sh_chebyu_l_t *_proto_eval_sh_chebyu_l_t_var = &_func_eval_sh_chebyu_l
from orthogonal_eval cimport eval_sh_jacobi as _func_eval_sh_jacobi
ctypedef double _proto_eval_sh_jacobi_double__t(double, double, double, double) nogil
cdef _proto_eval_sh_jacobi_double__t *_proto_eval_sh_jacobi_double__t_var = &_func_eval_sh_jacobi[double]
from orthogonal_eval cimport eval_sh_jacobi as _func_eval_sh_jacobi
ctypedef double complex _proto_eval_sh_jacobi_double_complex__t(double, double, double, double complex) nogil
cdef _proto_eval_sh_jacobi_double_complex__t *_proto_eval_sh_jacobi_double_complex__t_var = &_func_eval_sh_jacobi[double_complex]
from orthogonal_eval cimport eval_sh_jacobi_l as _func_eval_sh_jacobi_l
ctypedef double _proto_eval_sh_jacobi_l_t(long, double, double, double) nogil
cdef _proto_eval_sh_jacobi_l_t *_proto_eval_sh_jacobi_l_t_var = &_func_eval_sh_jacobi_l
from orthogonal_eval cimport eval_sh_legendre as _func_eval_sh_legendre
ctypedef double _proto_eval_sh_legendre_double__t(double, double) nogil
cdef _proto_eval_sh_legendre_double__t *_proto_eval_sh_legendre_double__t_var = &_func_eval_sh_legendre[double]
from orthogonal_eval cimport eval_sh_legendre as _func_eval_sh_legendre
ctypedef double complex _proto_eval_sh_legendre_double_complex__t(double, double complex) nogil
cdef _proto_eval_sh_legendre_double_complex__t *_proto_eval_sh_legendre_double_complex__t_var = &_func_eval_sh_legendre[double_complex]
from orthogonal_eval cimport eval_sh_legendre_l as _func_eval_sh_legendre_l
ctypedef double _proto_eval_sh_legendre_l_t(long, double) nogil
cdef _proto_eval_sh_legendre_l_t *_proto_eval_sh_legendre_l_t_var = &_func_eval_sh_legendre_l
cdef extern from "_ufuncs_defs.h":
    cdef double _func_exp1_wrap "exp1_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cexp1_wrap "cexp1_wrap"(double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_exp10 "exp10"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_exp2 "exp2"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_expi_wrap "expi_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cexpi_wrap "cexpi_wrap"(double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef float _func_expitf "expitf"(float) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_expit "expit"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef long double _func_expitl "expitl"(long double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_expm1 "expm1"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_expn "expn"(int, double) nogil
from _legacy cimport expn_unsafe as _func_expn_unsafe
ctypedef double _proto_expn_unsafe_t(double, double) nogil
cdef _proto_expn_unsafe_t *_proto_expn_unsafe_t_var = &_func_expn_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_fdtr "fdtr"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_fdtrc "fdtrc"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_fdtri "fdtri"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdff4_wrap "cdff4_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_fresnl "fresnl"(double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_cfresnl_wrap "cfresnl_wrap"(double complex, double complex *, double complex *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_Gamma "Gamma"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cgamma_wrap "cgamma_wrap"(double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_igam "igam"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_igamc "igamc"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_igami "igami"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_gammaincinv "gammaincinv"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_lgam "lgam"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_clngamma_wrap "clngamma_wrap"(double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_gammasgn "gammasgn"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_gdtr "gdtr"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_gdtrc "gdtrc"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfgam4_wrap "cdfgam4_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfgam3_wrap "cdfgam3_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfgam2_wrap "cdfgam2_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesh_wrap1 "cbesh_wrap1"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesh_wrap1_e "cbesh_wrap1_e"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesh_wrap2 "cbesh_wrap2"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesh_wrap2_e "cbesh_wrap2_e"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_hyp1f1_wrap "hyp1f1_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_chyp1f1_wrap "chyp1f1_wrap"(double, double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_onef2 "onef2"(double, double, double, double, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_hyp2f0 "hyp2f0"(double, double, double, int, double *) nogil
from _legacy cimport hyp2f0_unsafe as _func_hyp2f0_unsafe
ctypedef double _proto_hyp2f0_unsafe_t(double, double, double, double, double *) nogil
cdef _proto_hyp2f0_unsafe_t *_proto_hyp2f0_unsafe_t_var = &_func_hyp2f0_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_hyp2f1 "hyp2f1"(double, double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_chyp2f1_wrap "chyp2f1_wrap"(double, double, double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_threef0 "threef0"(double, double, double, double, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_hypU_wrap "hypU_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_i0 "i0"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_i0e "i0e"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_i1 "i1"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_i1e "i1e"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_it2i0k0_wrap "it2i0k0_wrap"(double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_it2j0y0_wrap "it2j0y0_wrap"(double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_it2struve0_wrap "it2struve0_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_itairy_wrap "itairy_wrap"(double, double *, double *, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_it1i0k0_wrap "it1i0k0_wrap"(double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_it1j0y0_wrap "it1j0y0_wrap"(double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_itmodstruve0_wrap "itmodstruve0_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_itstruve0_wrap "itstruve0_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_iv "iv"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesi_wrap "cbesi_wrap"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cbesi_wrap_e_real "cbesi_wrap_e_real"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesi_wrap_e "cbesi_wrap_e"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_j0 "j0"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_j1 "j1"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cbesj_wrap_real "cbesj_wrap_real"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesj_wrap "cbesj_wrap"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cbesj_wrap_e_real "cbesj_wrap_e_real"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesj_wrap_e "cbesj_wrap_e"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_k0 "k0"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_k0e "k0e"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_k1 "k1"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_k1e "k1e"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_kei_wrap "kei_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_keip_wrap "keip_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_kelvin_wrap "kelvin_wrap"(double, double complex *, double complex *, double complex *, double complex *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_ker_wrap "ker_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_kerp_wrap "kerp_wrap"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cbesk_wrap_real_int "cbesk_wrap_real_int"(int, double) nogil
from _legacy cimport kn_unsafe as _func_kn_unsafe
ctypedef double _proto_kn_unsafe_t(double, double) nogil
cdef _proto_kn_unsafe_t *_proto_kn_unsafe_t_var = &_func_kn_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_kolmogi "kolmogi"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_kolmogorov "kolmogorov"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cbesk_wrap_real "cbesk_wrap_real"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesk_wrap "cbesk_wrap"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cbesk_wrap_e_real "cbesk_wrap_e_real"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesk_wrap_e "cbesk_wrap_e"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_log1p "log1p"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_log_ndtr "log_ndtr"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef float _func_logitf "logitf"(float) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_logit "logit"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef long double _func_logitl "logitl"(long double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_pmv_wrap "pmv_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cem_cva_wrap "cem_cva_wrap"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_sem_cva_wrap "sem_cva_wrap"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_cem_wrap "cem_wrap"(double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_mcm1_wrap "mcm1_wrap"(double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_mcm2_wrap "mcm2_wrap"(double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_msm1_wrap "msm1_wrap"(double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_msm2_wrap "msm2_wrap"(double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_sem_wrap "sem_wrap"(double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_modified_fresnel_minus_wrap "modified_fresnel_minus_wrap"(double, double complex *, double complex *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_modified_fresnel_plus_wrap "modified_fresnel_plus_wrap"(double, double complex *, double complex *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_struve_l "struve_l"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_nbdtr "nbdtr"(int, int, double) nogil
from _legacy cimport nbdtr_unsafe as _func_nbdtr_unsafe
ctypedef double _proto_nbdtr_unsafe_t(double, double, double) nogil
cdef _proto_nbdtr_unsafe_t *_proto_nbdtr_unsafe_t_var = &_func_nbdtr_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_nbdtrc "nbdtrc"(int, int, double) nogil
from _legacy cimport nbdtrc_unsafe as _func_nbdtrc_unsafe
ctypedef double _proto_nbdtrc_unsafe_t(double, double, double) nogil
cdef _proto_nbdtrc_unsafe_t *_proto_nbdtrc_unsafe_t_var = &_func_nbdtrc_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_nbdtri "nbdtri"(int, int, double) nogil
from _legacy cimport nbdtri_unsafe as _func_nbdtri_unsafe
ctypedef double _proto_nbdtri_unsafe_t(double, double, double) nogil
cdef _proto_nbdtri_unsafe_t *_proto_nbdtri_unsafe_t_var = &_func_nbdtri_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfnbn2_wrap "cdfnbn2_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfnbn3_wrap "cdfnbn3_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdffnc1_wrap "cdffnc1_wrap"(double, double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdffnc2_wrap "cdffnc2_wrap"(double, double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdffnc4_wrap "cdffnc4_wrap"(double, double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdffnc3_wrap "cdffnc3_wrap"(double, double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdffnc5_wrap "cdffnc5_wrap"(double, double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdftnc1_wrap "cdftnc1_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdftnc3_wrap "cdftnc3_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdftnc4_wrap "cdftnc4_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdftnc2_wrap "cdftnc2_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_ndtr "ndtr"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_ndtri "ndtri"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfnor3_wrap "cdfnor3_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfnor4_wrap "cdfnor4_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_oblate_aswfa_nocv_wrap "oblate_aswfa_nocv_wrap"(double, double, double, double, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_oblate_aswfa_wrap "oblate_aswfa_wrap"(double, double, double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_oblate_segv_wrap "oblate_segv_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_oblate_radial1_nocv_wrap "oblate_radial1_nocv_wrap"(double, double, double, double, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_oblate_radial1_wrap "oblate_radial1_wrap"(double, double, double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_oblate_radial2_nocv_wrap "oblate_radial2_nocv_wrap"(double, double, double, double, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_oblate_radial2_wrap "oblate_radial2_wrap"(double, double, double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_pbdv_wrap "pbdv_wrap"(double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_pbvv_wrap "pbvv_wrap"(double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_pbwa_wrap "pbwa_wrap"(double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_pdtr "pdtr"(int, double) nogil
from _legacy cimport pdtr_unsafe as _func_pdtr_unsafe
ctypedef double _proto_pdtr_unsafe_t(double, double) nogil
cdef _proto_pdtr_unsafe_t *_proto_pdtr_unsafe_t_var = &_func_pdtr_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_pdtrc "pdtrc"(int, double) nogil
from _legacy cimport pdtrc_unsafe as _func_pdtrc_unsafe
ctypedef double _proto_pdtrc_unsafe_t(double, double) nogil
cdef _proto_pdtrc_unsafe_t *_proto_pdtrc_unsafe_t_var = &_func_pdtrc_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_pdtri "pdtri"(int, double) nogil
from _legacy cimport pdtri_unsafe as _func_pdtri_unsafe
ctypedef double _proto_pdtri_unsafe_t(double, double) nogil
cdef _proto_pdtri_unsafe_t *_proto_pdtri_unsafe_t_var = &_func_pdtri_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdfpoi2_wrap "cdfpoi2_wrap"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_prolate_aswfa_nocv_wrap "prolate_aswfa_nocv_wrap"(double, double, double, double, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_prolate_aswfa_wrap "prolate_aswfa_wrap"(double, double, double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_prolate_segv_wrap "prolate_segv_wrap"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_prolate_radial1_nocv_wrap "prolate_radial1_nocv_wrap"(double, double, double, double, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_prolate_radial1_wrap "prolate_radial1_wrap"(double, double, double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_prolate_radial2_nocv_wrap "prolate_radial2_nocv_wrap"(double, double, double, double, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_prolate_radial2_wrap "prolate_radial2_wrap"(double, double, double, double, double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_psi "psi"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cpsi_wrap "cpsi_wrap"(double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_radian "radian"(double, double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_rgamma "rgamma"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_crgamma_wrap "crgamma_wrap"(double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_round "round"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_shichi "shichi"(double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef int _func_sici "sici"(double, double *, double *) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_sindg "sindg"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_smirnov "smirnov"(int, double) nogil
from _legacy cimport smirnov_unsafe as _func_smirnov_unsafe
ctypedef double _proto_smirnov_unsafe_t(double, double) nogil
cdef _proto_smirnov_unsafe_t *_proto_smirnov_unsafe_t_var = &_func_smirnov_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_smirnovi "smirnovi"(int, double) nogil
from _legacy cimport smirnovi_unsafe as _func_smirnovi_unsafe
ctypedef double _proto_smirnovi_unsafe_t(double, double) nogil
cdef _proto_smirnovi_unsafe_t *_proto_smirnovi_unsafe_t_var = &_func_smirnovi_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_spence "spence"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdft1_wrap "cdft1_wrap"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdft3_wrap "cdft3_wrap"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cdft2_wrap "cdft2_wrap"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_struve_h "struve_h"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_tandg "tandg"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_tukeylambdacdf "tukeylambdacdf"(double, double) nogil
from _xlogy cimport xlog1py as _func_xlog1py
ctypedef double _proto_xlog1py_t(double, double) nogil
cdef _proto_xlog1py_t *_proto_xlog1py_t_var = &_func_xlog1py
from _xlogy cimport xlogy as _func_xlogy
ctypedef double _proto_xlogy_double__t(double, double) nogil
cdef _proto_xlogy_double__t *_proto_xlogy_double__t_var = &_func_xlogy[double]
from _xlogy cimport xlogy as _func_xlogy
ctypedef double complex _proto_xlogy_double_complex__t(double complex, double complex) nogil
cdef _proto_xlogy_double_complex__t *_proto_xlogy_double_complex__t_var = &_func_xlogy[double_complex]
cdef extern from "_ufuncs_defs.h":
    cdef double _func_y0 "y0"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_y1 "y1"(double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_yn "yn"(int, double) nogil
from _legacy cimport yn_unsafe as _func_yn_unsafe
ctypedef double _proto_yn_unsafe_t(double, double) nogil
cdef _proto_yn_unsafe_t *_proto_yn_unsafe_t_var = &_func_yn_unsafe
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cbesy_wrap_real "cbesy_wrap_real"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesy_wrap "cbesy_wrap"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_cbesy_wrap_e_real "cbesy_wrap_e_real"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double complex _func_cbesy_wrap_e "cbesy_wrap_e"(double, double complex) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_zeta "zeta"(double, double) nogil
cdef extern from "_ufuncs_defs.h":
    cdef double _func_zetac "zetac"(double) nogil
cdef np.PyUFuncGenericFunction ufunc__lambertw_loops[2]
cdef void *ufunc__lambertw_ptr[4]
cdef void *ufunc__lambertw_data[2]
cdef char ufunc__lambertw_types[8]
cdef char *ufunc__lambertw_doc = (
    "Internal function, use `lambertw` instead.")
ufunc__lambertw_loops[0] = <np.PyUFuncGenericFunction>loop_D_Dld__As_Flf_F
ufunc__lambertw_loops[1] = <np.PyUFuncGenericFunction>loop_D_Dld__As_Dld_D
ufunc__lambertw_types[0] = <char>NPY_CFLOAT
ufunc__lambertw_types[1] = <char>NPY_LONG
ufunc__lambertw_types[2] = <char>NPY_FLOAT
ufunc__lambertw_types[3] = <char>NPY_CFLOAT
ufunc__lambertw_types[4] = <char>NPY_CDOUBLE
ufunc__lambertw_types[5] = <char>NPY_LONG
ufunc__lambertw_types[6] = <char>NPY_DOUBLE
ufunc__lambertw_types[7] = <char>NPY_CDOUBLE
ufunc__lambertw_ptr[2*0] = <void*>_func_lambertw_scalar
ufunc__lambertw_ptr[2*0+1] = <void*>(<char*>"_lambertw")
ufunc__lambertw_ptr[2*1] = <void*>_func_lambertw_scalar
ufunc__lambertw_ptr[2*1+1] = <void*>(<char*>"_lambertw")
ufunc__lambertw_data[0] = &ufunc__lambertw_ptr[2*0]
ufunc__lambertw_data[1] = &ufunc__lambertw_ptr[2*1]
_lambertw = np.PyUFunc_FromFuncAndData(ufunc__lambertw_loops, ufunc__lambertw_data, ufunc__lambertw_types, 2, 3, 1, 0, "_lambertw", ufunc__lambertw_doc, 0)

cdef np.PyUFuncGenericFunction ufunc__struve_asymp_large_z_loops[2]
cdef void *ufunc__struve_asymp_large_z_ptr[4]
cdef void *ufunc__struve_asymp_large_z_data[2]
cdef char ufunc__struve_asymp_large_z_types[10]
cdef char *ufunc__struve_asymp_large_z_doc = (
    "Function for testing struve & modstruve")
ufunc__struve_asymp_large_z_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddi_d_As_ffl_ff
ufunc__struve_asymp_large_z_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddi_d_As_ddl_dd
ufunc__struve_asymp_large_z_types[0] = <char>NPY_FLOAT
ufunc__struve_asymp_large_z_types[1] = <char>NPY_FLOAT
ufunc__struve_asymp_large_z_types[2] = <char>NPY_LONG
ufunc__struve_asymp_large_z_types[3] = <char>NPY_FLOAT
ufunc__struve_asymp_large_z_types[4] = <char>NPY_FLOAT
ufunc__struve_asymp_large_z_types[5] = <char>NPY_DOUBLE
ufunc__struve_asymp_large_z_types[6] = <char>NPY_DOUBLE
ufunc__struve_asymp_large_z_types[7] = <char>NPY_LONG
ufunc__struve_asymp_large_z_types[8] = <char>NPY_DOUBLE
ufunc__struve_asymp_large_z_types[9] = <char>NPY_DOUBLE
ufunc__struve_asymp_large_z_ptr[2*0] = <void*>_func_struve_asymp_large_z
ufunc__struve_asymp_large_z_ptr[2*0+1] = <void*>(<char*>"_struve_asymp_large_z")
ufunc__struve_asymp_large_z_ptr[2*1] = <void*>_func_struve_asymp_large_z
ufunc__struve_asymp_large_z_ptr[2*1+1] = <void*>(<char*>"_struve_asymp_large_z")
ufunc__struve_asymp_large_z_data[0] = &ufunc__struve_asymp_large_z_ptr[2*0]
ufunc__struve_asymp_large_z_data[1] = &ufunc__struve_asymp_large_z_ptr[2*1]
_struve_asymp_large_z = np.PyUFunc_FromFuncAndData(ufunc__struve_asymp_large_z_loops, ufunc__struve_asymp_large_z_data, ufunc__struve_asymp_large_z_types, 2, 3, 2, 0, "_struve_asymp_large_z", ufunc__struve_asymp_large_z_doc, 0)

cdef np.PyUFuncGenericFunction ufunc__struve_bessel_series_loops[2]
cdef void *ufunc__struve_bessel_series_ptr[4]
cdef void *ufunc__struve_bessel_series_data[2]
cdef char ufunc__struve_bessel_series_types[10]
cdef char *ufunc__struve_bessel_series_doc = (
    "Function for testing struve & modstruve")
ufunc__struve_bessel_series_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddi_d_As_ffl_ff
ufunc__struve_bessel_series_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddi_d_As_ddl_dd
ufunc__struve_bessel_series_types[0] = <char>NPY_FLOAT
ufunc__struve_bessel_series_types[1] = <char>NPY_FLOAT
ufunc__struve_bessel_series_types[2] = <char>NPY_LONG
ufunc__struve_bessel_series_types[3] = <char>NPY_FLOAT
ufunc__struve_bessel_series_types[4] = <char>NPY_FLOAT
ufunc__struve_bessel_series_types[5] = <char>NPY_DOUBLE
ufunc__struve_bessel_series_types[6] = <char>NPY_DOUBLE
ufunc__struve_bessel_series_types[7] = <char>NPY_LONG
ufunc__struve_bessel_series_types[8] = <char>NPY_DOUBLE
ufunc__struve_bessel_series_types[9] = <char>NPY_DOUBLE
ufunc__struve_bessel_series_ptr[2*0] = <void*>_func_struve_bessel_series
ufunc__struve_bessel_series_ptr[2*0+1] = <void*>(<char*>"_struve_bessel_series")
ufunc__struve_bessel_series_ptr[2*1] = <void*>_func_struve_bessel_series
ufunc__struve_bessel_series_ptr[2*1+1] = <void*>(<char*>"_struve_bessel_series")
ufunc__struve_bessel_series_data[0] = &ufunc__struve_bessel_series_ptr[2*0]
ufunc__struve_bessel_series_data[1] = &ufunc__struve_bessel_series_ptr[2*1]
_struve_bessel_series = np.PyUFunc_FromFuncAndData(ufunc__struve_bessel_series_loops, ufunc__struve_bessel_series_data, ufunc__struve_bessel_series_types, 2, 3, 2, 0, "_struve_bessel_series", ufunc__struve_bessel_series_doc, 0)

cdef np.PyUFuncGenericFunction ufunc__struve_power_series_loops[2]
cdef void *ufunc__struve_power_series_ptr[4]
cdef void *ufunc__struve_power_series_data[2]
cdef char ufunc__struve_power_series_types[10]
cdef char *ufunc__struve_power_series_doc = (
    "Function for testing struve & modstruve")
ufunc__struve_power_series_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddi_d_As_ffl_ff
ufunc__struve_power_series_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddi_d_As_ddl_dd
ufunc__struve_power_series_types[0] = <char>NPY_FLOAT
ufunc__struve_power_series_types[1] = <char>NPY_FLOAT
ufunc__struve_power_series_types[2] = <char>NPY_LONG
ufunc__struve_power_series_types[3] = <char>NPY_FLOAT
ufunc__struve_power_series_types[4] = <char>NPY_FLOAT
ufunc__struve_power_series_types[5] = <char>NPY_DOUBLE
ufunc__struve_power_series_types[6] = <char>NPY_DOUBLE
ufunc__struve_power_series_types[7] = <char>NPY_LONG
ufunc__struve_power_series_types[8] = <char>NPY_DOUBLE
ufunc__struve_power_series_types[9] = <char>NPY_DOUBLE
ufunc__struve_power_series_ptr[2*0] = <void*>_func_struve_power_series
ufunc__struve_power_series_ptr[2*0+1] = <void*>(<char*>"_struve_power_series")
ufunc__struve_power_series_ptr[2*1] = <void*>_func_struve_power_series
ufunc__struve_power_series_ptr[2*1+1] = <void*>(<char*>"_struve_power_series")
ufunc__struve_power_series_data[0] = &ufunc__struve_power_series_ptr[2*0]
ufunc__struve_power_series_data[1] = &ufunc__struve_power_series_ptr[2*1]
_struve_power_series = np.PyUFunc_FromFuncAndData(ufunc__struve_power_series_loops, ufunc__struve_power_series_data, ufunc__struve_power_series_types, 2, 3, 2, 0, "_struve_power_series", ufunc__struve_power_series_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_airy_loops[4]
cdef void *ufunc_airy_ptr[8]
cdef void *ufunc_airy_data[4]
cdef char ufunc_airy_types[20]
cdef char *ufunc_airy_doc = (
    "(Ai,Aip,Bi,Bip)=airy(z) calculates the Airy functions and their derivatives\n"
    "evaluated at real or complex number z.  The Airy functions Ai and Bi\n"
    "are two independent solutions of y''(x)=xy.  Aip and Bip are the first derivatives\n"
    "evaluated at x of Ai and Bi respectively.")
ufunc_airy_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_dddd_As_f_ffff
ufunc_airy_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_dddd_As_d_dddd
ufunc_airy_loops[2] = <np.PyUFuncGenericFunction>loop_i_D_DDDD_As_F_FFFF
ufunc_airy_loops[3] = <np.PyUFuncGenericFunction>loop_i_D_DDDD_As_D_DDDD
ufunc_airy_types[0] = <char>NPY_FLOAT
ufunc_airy_types[1] = <char>NPY_FLOAT
ufunc_airy_types[2] = <char>NPY_FLOAT
ufunc_airy_types[3] = <char>NPY_FLOAT
ufunc_airy_types[4] = <char>NPY_FLOAT
ufunc_airy_types[5] = <char>NPY_DOUBLE
ufunc_airy_types[6] = <char>NPY_DOUBLE
ufunc_airy_types[7] = <char>NPY_DOUBLE
ufunc_airy_types[8] = <char>NPY_DOUBLE
ufunc_airy_types[9] = <char>NPY_DOUBLE
ufunc_airy_types[10] = <char>NPY_CFLOAT
ufunc_airy_types[11] = <char>NPY_CFLOAT
ufunc_airy_types[12] = <char>NPY_CFLOAT
ufunc_airy_types[13] = <char>NPY_CFLOAT
ufunc_airy_types[14] = <char>NPY_CFLOAT
ufunc_airy_types[15] = <char>NPY_CDOUBLE
ufunc_airy_types[16] = <char>NPY_CDOUBLE
ufunc_airy_types[17] = <char>NPY_CDOUBLE
ufunc_airy_types[18] = <char>NPY_CDOUBLE
ufunc_airy_types[19] = <char>NPY_CDOUBLE
ufunc_airy_ptr[2*0] = <void*>_func_airy_wrap
ufunc_airy_ptr[2*0+1] = <void*>(<char*>"airy")
ufunc_airy_ptr[2*1] = <void*>_func_airy_wrap
ufunc_airy_ptr[2*1+1] = <void*>(<char*>"airy")
ufunc_airy_ptr[2*2] = <void*>_func_cairy_wrap
ufunc_airy_ptr[2*2+1] = <void*>(<char*>"airy")
ufunc_airy_ptr[2*3] = <void*>_func_cairy_wrap
ufunc_airy_ptr[2*3+1] = <void*>(<char*>"airy")
ufunc_airy_data[0] = &ufunc_airy_ptr[2*0]
ufunc_airy_data[1] = &ufunc_airy_ptr[2*1]
ufunc_airy_data[2] = &ufunc_airy_ptr[2*2]
ufunc_airy_data[3] = &ufunc_airy_ptr[2*3]
airy = np.PyUFunc_FromFuncAndData(ufunc_airy_loops, ufunc_airy_data, ufunc_airy_types, 4, 1, 4, 0, "airy", ufunc_airy_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_airye_loops[4]
cdef void *ufunc_airye_ptr[8]
cdef void *ufunc_airye_data[4]
cdef char ufunc_airye_types[20]
cdef char *ufunc_airye_doc = (
    "(Aie,Aipe,Bie,Bipe)=airye(z) calculates the exponentially scaled Airy functions and\n"
    "their derivatives evaluated at real or complex number z.\n"
    "airye(z)[0:1] = airy(z)[0:1] * exp(2.0/3.0*z*sqrt(z))\n"
    "airye(z)[2:3] = airy(z)[2:3] * exp(-abs((2.0/3.0*z*sqrt(z)).real))")
ufunc_airye_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_dddd_As_f_ffff
ufunc_airye_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_dddd_As_d_dddd
ufunc_airye_loops[2] = <np.PyUFuncGenericFunction>loop_i_D_DDDD_As_F_FFFF
ufunc_airye_loops[3] = <np.PyUFuncGenericFunction>loop_i_D_DDDD_As_D_DDDD
ufunc_airye_types[0] = <char>NPY_FLOAT
ufunc_airye_types[1] = <char>NPY_FLOAT
ufunc_airye_types[2] = <char>NPY_FLOAT
ufunc_airye_types[3] = <char>NPY_FLOAT
ufunc_airye_types[4] = <char>NPY_FLOAT
ufunc_airye_types[5] = <char>NPY_DOUBLE
ufunc_airye_types[6] = <char>NPY_DOUBLE
ufunc_airye_types[7] = <char>NPY_DOUBLE
ufunc_airye_types[8] = <char>NPY_DOUBLE
ufunc_airye_types[9] = <char>NPY_DOUBLE
ufunc_airye_types[10] = <char>NPY_CFLOAT
ufunc_airye_types[11] = <char>NPY_CFLOAT
ufunc_airye_types[12] = <char>NPY_CFLOAT
ufunc_airye_types[13] = <char>NPY_CFLOAT
ufunc_airye_types[14] = <char>NPY_CFLOAT
ufunc_airye_types[15] = <char>NPY_CDOUBLE
ufunc_airye_types[16] = <char>NPY_CDOUBLE
ufunc_airye_types[17] = <char>NPY_CDOUBLE
ufunc_airye_types[18] = <char>NPY_CDOUBLE
ufunc_airye_types[19] = <char>NPY_CDOUBLE
ufunc_airye_ptr[2*0] = <void*>_func_cairy_wrap_e_real
ufunc_airye_ptr[2*0+1] = <void*>(<char*>"airye")
ufunc_airye_ptr[2*1] = <void*>_func_cairy_wrap_e_real
ufunc_airye_ptr[2*1+1] = <void*>(<char*>"airye")
ufunc_airye_ptr[2*2] = <void*>_func_cairy_wrap_e
ufunc_airye_ptr[2*2+1] = <void*>(<char*>"airye")
ufunc_airye_ptr[2*3] = <void*>_func_cairy_wrap_e
ufunc_airye_ptr[2*3+1] = <void*>(<char*>"airye")
ufunc_airye_data[0] = &ufunc_airye_ptr[2*0]
ufunc_airye_data[1] = &ufunc_airye_ptr[2*1]
ufunc_airye_data[2] = &ufunc_airye_ptr[2*2]
ufunc_airye_data[3] = &ufunc_airye_ptr[2*3]
airye = np.PyUFunc_FromFuncAndData(ufunc_airye_loops, ufunc_airye_data, ufunc_airye_types, 4, 1, 4, 0, "airye", ufunc_airye_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_bdtr_loops[4]
cdef void *ufunc_bdtr_ptr[8]
cdef void *ufunc_bdtr_data[4]
cdef char ufunc_bdtr_types[16]
cdef char *ufunc_bdtr_doc = (
    "y=bdtr(k,n,p) returns the sum of the terms 0 through k of the\n"
    "Binomial probability density:  sum(nCj p**j (1-p)**(n-j),j=0..k)")
ufunc_bdtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_iid__As_llf_f
ufunc_bdtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_iid__As_lld_d
ufunc_bdtr_loops[2] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_bdtr_loops[3] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_bdtr_types[0] = <char>NPY_LONG
ufunc_bdtr_types[1] = <char>NPY_LONG
ufunc_bdtr_types[2] = <char>NPY_FLOAT
ufunc_bdtr_types[3] = <char>NPY_FLOAT
ufunc_bdtr_types[4] = <char>NPY_LONG
ufunc_bdtr_types[5] = <char>NPY_LONG
ufunc_bdtr_types[6] = <char>NPY_DOUBLE
ufunc_bdtr_types[7] = <char>NPY_DOUBLE
ufunc_bdtr_types[8] = <char>NPY_FLOAT
ufunc_bdtr_types[9] = <char>NPY_FLOAT
ufunc_bdtr_types[10] = <char>NPY_FLOAT
ufunc_bdtr_types[11] = <char>NPY_FLOAT
ufunc_bdtr_types[12] = <char>NPY_DOUBLE
ufunc_bdtr_types[13] = <char>NPY_DOUBLE
ufunc_bdtr_types[14] = <char>NPY_DOUBLE
ufunc_bdtr_types[15] = <char>NPY_DOUBLE
ufunc_bdtr_ptr[2*0] = <void*>_func_bdtr
ufunc_bdtr_ptr[2*0+1] = <void*>(<char*>"bdtr")
ufunc_bdtr_ptr[2*1] = <void*>_func_bdtr
ufunc_bdtr_ptr[2*1+1] = <void*>(<char*>"bdtr")
ufunc_bdtr_ptr[2*2] = <void*>_func_bdtr_unsafe
ufunc_bdtr_ptr[2*2+1] = <void*>(<char*>"bdtr")
ufunc_bdtr_ptr[2*3] = <void*>_func_bdtr_unsafe
ufunc_bdtr_ptr[2*3+1] = <void*>(<char*>"bdtr")
ufunc_bdtr_data[0] = &ufunc_bdtr_ptr[2*0]
ufunc_bdtr_data[1] = &ufunc_bdtr_ptr[2*1]
ufunc_bdtr_data[2] = &ufunc_bdtr_ptr[2*2]
ufunc_bdtr_data[3] = &ufunc_bdtr_ptr[2*3]
bdtr = np.PyUFunc_FromFuncAndData(ufunc_bdtr_loops, ufunc_bdtr_data, ufunc_bdtr_types, 4, 3, 1, 0, "bdtr", ufunc_bdtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_bdtrc_loops[4]
cdef void *ufunc_bdtrc_ptr[8]
cdef void *ufunc_bdtrc_data[4]
cdef char ufunc_bdtrc_types[16]
cdef char *ufunc_bdtrc_doc = (
    "y=bdtrc(k,n,p) returns the sum of the terms k+1 through n of the\n"
    "Binomial probability density: sum(nCj p**j (1-p)**(n-j), j=k+1..n)")
ufunc_bdtrc_loops[0] = <np.PyUFuncGenericFunction>loop_d_iid__As_llf_f
ufunc_bdtrc_loops[1] = <np.PyUFuncGenericFunction>loop_d_iid__As_lld_d
ufunc_bdtrc_loops[2] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_bdtrc_loops[3] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_bdtrc_types[0] = <char>NPY_LONG
ufunc_bdtrc_types[1] = <char>NPY_LONG
ufunc_bdtrc_types[2] = <char>NPY_FLOAT
ufunc_bdtrc_types[3] = <char>NPY_FLOAT
ufunc_bdtrc_types[4] = <char>NPY_LONG
ufunc_bdtrc_types[5] = <char>NPY_LONG
ufunc_bdtrc_types[6] = <char>NPY_DOUBLE
ufunc_bdtrc_types[7] = <char>NPY_DOUBLE
ufunc_bdtrc_types[8] = <char>NPY_FLOAT
ufunc_bdtrc_types[9] = <char>NPY_FLOAT
ufunc_bdtrc_types[10] = <char>NPY_FLOAT
ufunc_bdtrc_types[11] = <char>NPY_FLOAT
ufunc_bdtrc_types[12] = <char>NPY_DOUBLE
ufunc_bdtrc_types[13] = <char>NPY_DOUBLE
ufunc_bdtrc_types[14] = <char>NPY_DOUBLE
ufunc_bdtrc_types[15] = <char>NPY_DOUBLE
ufunc_bdtrc_ptr[2*0] = <void*>_func_bdtrc
ufunc_bdtrc_ptr[2*0+1] = <void*>(<char*>"bdtrc")
ufunc_bdtrc_ptr[2*1] = <void*>_func_bdtrc
ufunc_bdtrc_ptr[2*1+1] = <void*>(<char*>"bdtrc")
ufunc_bdtrc_ptr[2*2] = <void*>_func_bdtrc_unsafe
ufunc_bdtrc_ptr[2*2+1] = <void*>(<char*>"bdtrc")
ufunc_bdtrc_ptr[2*3] = <void*>_func_bdtrc_unsafe
ufunc_bdtrc_ptr[2*3+1] = <void*>(<char*>"bdtrc")
ufunc_bdtrc_data[0] = &ufunc_bdtrc_ptr[2*0]
ufunc_bdtrc_data[1] = &ufunc_bdtrc_ptr[2*1]
ufunc_bdtrc_data[2] = &ufunc_bdtrc_ptr[2*2]
ufunc_bdtrc_data[3] = &ufunc_bdtrc_ptr[2*3]
bdtrc = np.PyUFunc_FromFuncAndData(ufunc_bdtrc_loops, ufunc_bdtrc_data, ufunc_bdtrc_types, 4, 3, 1, 0, "bdtrc", ufunc_bdtrc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_bdtri_loops[4]
cdef void *ufunc_bdtri_ptr[8]
cdef void *ufunc_bdtri_data[4]
cdef char ufunc_bdtri_types[16]
cdef char *ufunc_bdtri_doc = (
    "p=bdtri(k,n,y) finds the probability p such that the sum of the\n"
    "terms 0 through k of the Binomial probability density is equal to the\n"
    "given cumulative probability y.")
ufunc_bdtri_loops[0] = <np.PyUFuncGenericFunction>loop_d_iid__As_llf_f
ufunc_bdtri_loops[1] = <np.PyUFuncGenericFunction>loop_d_iid__As_lld_d
ufunc_bdtri_loops[2] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_bdtri_loops[3] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_bdtri_types[0] = <char>NPY_LONG
ufunc_bdtri_types[1] = <char>NPY_LONG
ufunc_bdtri_types[2] = <char>NPY_FLOAT
ufunc_bdtri_types[3] = <char>NPY_FLOAT
ufunc_bdtri_types[4] = <char>NPY_LONG
ufunc_bdtri_types[5] = <char>NPY_LONG
ufunc_bdtri_types[6] = <char>NPY_DOUBLE
ufunc_bdtri_types[7] = <char>NPY_DOUBLE
ufunc_bdtri_types[8] = <char>NPY_FLOAT
ufunc_bdtri_types[9] = <char>NPY_FLOAT
ufunc_bdtri_types[10] = <char>NPY_FLOAT
ufunc_bdtri_types[11] = <char>NPY_FLOAT
ufunc_bdtri_types[12] = <char>NPY_DOUBLE
ufunc_bdtri_types[13] = <char>NPY_DOUBLE
ufunc_bdtri_types[14] = <char>NPY_DOUBLE
ufunc_bdtri_types[15] = <char>NPY_DOUBLE
ufunc_bdtri_ptr[2*0] = <void*>_func_bdtri
ufunc_bdtri_ptr[2*0+1] = <void*>(<char*>"bdtri")
ufunc_bdtri_ptr[2*1] = <void*>_func_bdtri
ufunc_bdtri_ptr[2*1+1] = <void*>(<char*>"bdtri")
ufunc_bdtri_ptr[2*2] = <void*>_func_bdtri_unsafe
ufunc_bdtri_ptr[2*2+1] = <void*>(<char*>"bdtri")
ufunc_bdtri_ptr[2*3] = <void*>_func_bdtri_unsafe
ufunc_bdtri_ptr[2*3+1] = <void*>(<char*>"bdtri")
ufunc_bdtri_data[0] = &ufunc_bdtri_ptr[2*0]
ufunc_bdtri_data[1] = &ufunc_bdtri_ptr[2*1]
ufunc_bdtri_data[2] = &ufunc_bdtri_ptr[2*2]
ufunc_bdtri_data[3] = &ufunc_bdtri_ptr[2*3]
bdtri = np.PyUFunc_FromFuncAndData(ufunc_bdtri_loops, ufunc_bdtri_data, ufunc_bdtri_types, 4, 3, 1, 0, "bdtri", ufunc_bdtri_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_bdtrik_loops[2]
cdef void *ufunc_bdtrik_ptr[4]
cdef void *ufunc_bdtrik_data[2]
cdef char ufunc_bdtrik_types[8]
cdef char *ufunc_bdtrik_doc = (
    "")
ufunc_bdtrik_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_bdtrik_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_bdtrik_types[0] = <char>NPY_FLOAT
ufunc_bdtrik_types[1] = <char>NPY_FLOAT
ufunc_bdtrik_types[2] = <char>NPY_FLOAT
ufunc_bdtrik_types[3] = <char>NPY_FLOAT
ufunc_bdtrik_types[4] = <char>NPY_DOUBLE
ufunc_bdtrik_types[5] = <char>NPY_DOUBLE
ufunc_bdtrik_types[6] = <char>NPY_DOUBLE
ufunc_bdtrik_types[7] = <char>NPY_DOUBLE
ufunc_bdtrik_ptr[2*0] = <void*>_func_cdfbin2_wrap
ufunc_bdtrik_ptr[2*0+1] = <void*>(<char*>"bdtrik")
ufunc_bdtrik_ptr[2*1] = <void*>_func_cdfbin2_wrap
ufunc_bdtrik_ptr[2*1+1] = <void*>(<char*>"bdtrik")
ufunc_bdtrik_data[0] = &ufunc_bdtrik_ptr[2*0]
ufunc_bdtrik_data[1] = &ufunc_bdtrik_ptr[2*1]
bdtrik = np.PyUFunc_FromFuncAndData(ufunc_bdtrik_loops, ufunc_bdtrik_data, ufunc_bdtrik_types, 2, 3, 1, 0, "bdtrik", ufunc_bdtrik_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_bdtrin_loops[2]
cdef void *ufunc_bdtrin_ptr[4]
cdef void *ufunc_bdtrin_data[2]
cdef char ufunc_bdtrin_types[8]
cdef char *ufunc_bdtrin_doc = (
    "")
ufunc_bdtrin_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_bdtrin_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_bdtrin_types[0] = <char>NPY_FLOAT
ufunc_bdtrin_types[1] = <char>NPY_FLOAT
ufunc_bdtrin_types[2] = <char>NPY_FLOAT
ufunc_bdtrin_types[3] = <char>NPY_FLOAT
ufunc_bdtrin_types[4] = <char>NPY_DOUBLE
ufunc_bdtrin_types[5] = <char>NPY_DOUBLE
ufunc_bdtrin_types[6] = <char>NPY_DOUBLE
ufunc_bdtrin_types[7] = <char>NPY_DOUBLE
ufunc_bdtrin_ptr[2*0] = <void*>_func_cdfbin3_wrap
ufunc_bdtrin_ptr[2*0+1] = <void*>(<char*>"bdtrin")
ufunc_bdtrin_ptr[2*1] = <void*>_func_cdfbin3_wrap
ufunc_bdtrin_ptr[2*1+1] = <void*>(<char*>"bdtrin")
ufunc_bdtrin_data[0] = &ufunc_bdtrin_ptr[2*0]
ufunc_bdtrin_data[1] = &ufunc_bdtrin_ptr[2*1]
bdtrin = np.PyUFunc_FromFuncAndData(ufunc_bdtrin_loops, ufunc_bdtrin_data, ufunc_bdtrin_types, 2, 3, 1, 0, "bdtrin", ufunc_bdtrin_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_bei_loops[2]
cdef void *ufunc_bei_ptr[4]
cdef void *ufunc_bei_data[2]
cdef char ufunc_bei_types[4]
cdef char *ufunc_bei_doc = (
    "y=bei(x) returns the Kelvin function bei x")
ufunc_bei_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_bei_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_bei_types[0] = <char>NPY_FLOAT
ufunc_bei_types[1] = <char>NPY_FLOAT
ufunc_bei_types[2] = <char>NPY_DOUBLE
ufunc_bei_types[3] = <char>NPY_DOUBLE
ufunc_bei_ptr[2*0] = <void*>_func_bei_wrap
ufunc_bei_ptr[2*0+1] = <void*>(<char*>"bei")
ufunc_bei_ptr[2*1] = <void*>_func_bei_wrap
ufunc_bei_ptr[2*1+1] = <void*>(<char*>"bei")
ufunc_bei_data[0] = &ufunc_bei_ptr[2*0]
ufunc_bei_data[1] = &ufunc_bei_ptr[2*1]
bei = np.PyUFunc_FromFuncAndData(ufunc_bei_loops, ufunc_bei_data, ufunc_bei_types, 2, 1, 1, 0, "bei", ufunc_bei_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_beip_loops[2]
cdef void *ufunc_beip_ptr[4]
cdef void *ufunc_beip_data[2]
cdef char ufunc_beip_types[4]
cdef char *ufunc_beip_doc = (
    "y=beip(x) returns the derivative of the Kelvin function bei x")
ufunc_beip_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_beip_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_beip_types[0] = <char>NPY_FLOAT
ufunc_beip_types[1] = <char>NPY_FLOAT
ufunc_beip_types[2] = <char>NPY_DOUBLE
ufunc_beip_types[3] = <char>NPY_DOUBLE
ufunc_beip_ptr[2*0] = <void*>_func_beip_wrap
ufunc_beip_ptr[2*0+1] = <void*>(<char*>"beip")
ufunc_beip_ptr[2*1] = <void*>_func_beip_wrap
ufunc_beip_ptr[2*1+1] = <void*>(<char*>"beip")
ufunc_beip_data[0] = &ufunc_beip_ptr[2*0]
ufunc_beip_data[1] = &ufunc_beip_ptr[2*1]
beip = np.PyUFunc_FromFuncAndData(ufunc_beip_loops, ufunc_beip_data, ufunc_beip_types, 2, 1, 1, 0, "beip", ufunc_beip_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ber_loops[2]
cdef void *ufunc_ber_ptr[4]
cdef void *ufunc_ber_data[2]
cdef char ufunc_ber_types[4]
cdef char *ufunc_ber_doc = (
    "y=ber(x) returns the Kelvin function ber x")
ufunc_ber_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_ber_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_ber_types[0] = <char>NPY_FLOAT
ufunc_ber_types[1] = <char>NPY_FLOAT
ufunc_ber_types[2] = <char>NPY_DOUBLE
ufunc_ber_types[3] = <char>NPY_DOUBLE
ufunc_ber_ptr[2*0] = <void*>_func_ber_wrap
ufunc_ber_ptr[2*0+1] = <void*>(<char*>"ber")
ufunc_ber_ptr[2*1] = <void*>_func_ber_wrap
ufunc_ber_ptr[2*1+1] = <void*>(<char*>"ber")
ufunc_ber_data[0] = &ufunc_ber_ptr[2*0]
ufunc_ber_data[1] = &ufunc_ber_ptr[2*1]
ber = np.PyUFunc_FromFuncAndData(ufunc_ber_loops, ufunc_ber_data, ufunc_ber_types, 2, 1, 1, 0, "ber", ufunc_ber_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_berp_loops[2]
cdef void *ufunc_berp_ptr[4]
cdef void *ufunc_berp_data[2]
cdef char ufunc_berp_types[4]
cdef char *ufunc_berp_doc = (
    "y=berp(x) returns the derivative of the Kelvin function ber x")
ufunc_berp_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_berp_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_berp_types[0] = <char>NPY_FLOAT
ufunc_berp_types[1] = <char>NPY_FLOAT
ufunc_berp_types[2] = <char>NPY_DOUBLE
ufunc_berp_types[3] = <char>NPY_DOUBLE
ufunc_berp_ptr[2*0] = <void*>_func_berp_wrap
ufunc_berp_ptr[2*0+1] = <void*>(<char*>"berp")
ufunc_berp_ptr[2*1] = <void*>_func_berp_wrap
ufunc_berp_ptr[2*1+1] = <void*>(<char*>"berp")
ufunc_berp_data[0] = &ufunc_berp_ptr[2*0]
ufunc_berp_data[1] = &ufunc_berp_ptr[2*1]
berp = np.PyUFunc_FromFuncAndData(ufunc_berp_loops, ufunc_berp_data, ufunc_berp_types, 2, 1, 1, 0, "berp", ufunc_berp_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_besselpoly_loops[2]
cdef void *ufunc_besselpoly_ptr[4]
cdef void *ufunc_besselpoly_data[2]
cdef char ufunc_besselpoly_types[8]
cdef char *ufunc_besselpoly_doc = (
    "y=besselpoly(a,lam,nu) returns the value of the integral:\n"
    "integral(x**lam * jv(nu,2*a*x),x=0..1).")
ufunc_besselpoly_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_besselpoly_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_besselpoly_types[0] = <char>NPY_FLOAT
ufunc_besselpoly_types[1] = <char>NPY_FLOAT
ufunc_besselpoly_types[2] = <char>NPY_FLOAT
ufunc_besselpoly_types[3] = <char>NPY_FLOAT
ufunc_besselpoly_types[4] = <char>NPY_DOUBLE
ufunc_besselpoly_types[5] = <char>NPY_DOUBLE
ufunc_besselpoly_types[6] = <char>NPY_DOUBLE
ufunc_besselpoly_types[7] = <char>NPY_DOUBLE
ufunc_besselpoly_ptr[2*0] = <void*>_func_besselpoly
ufunc_besselpoly_ptr[2*0+1] = <void*>(<char*>"besselpoly")
ufunc_besselpoly_ptr[2*1] = <void*>_func_besselpoly
ufunc_besselpoly_ptr[2*1+1] = <void*>(<char*>"besselpoly")
ufunc_besselpoly_data[0] = &ufunc_besselpoly_ptr[2*0]
ufunc_besselpoly_data[1] = &ufunc_besselpoly_ptr[2*1]
besselpoly = np.PyUFunc_FromFuncAndData(ufunc_besselpoly_loops, ufunc_besselpoly_data, ufunc_besselpoly_types, 2, 3, 1, 0, "besselpoly", ufunc_besselpoly_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_beta_loops[2]
cdef void *ufunc_beta_ptr[4]
cdef void *ufunc_beta_data[2]
cdef char ufunc_beta_types[6]
cdef char *ufunc_beta_doc = (
    "y=beta(a,b) returns gamma(a) * gamma(b) / gamma(a+b)")
ufunc_beta_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_beta_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_beta_types[0] = <char>NPY_FLOAT
ufunc_beta_types[1] = <char>NPY_FLOAT
ufunc_beta_types[2] = <char>NPY_FLOAT
ufunc_beta_types[3] = <char>NPY_DOUBLE
ufunc_beta_types[4] = <char>NPY_DOUBLE
ufunc_beta_types[5] = <char>NPY_DOUBLE
ufunc_beta_ptr[2*0] = <void*>_func_beta
ufunc_beta_ptr[2*0+1] = <void*>(<char*>"beta")
ufunc_beta_ptr[2*1] = <void*>_func_beta
ufunc_beta_ptr[2*1+1] = <void*>(<char*>"beta")
ufunc_beta_data[0] = &ufunc_beta_ptr[2*0]
ufunc_beta_data[1] = &ufunc_beta_ptr[2*1]
beta = np.PyUFunc_FromFuncAndData(ufunc_beta_loops, ufunc_beta_data, ufunc_beta_types, 2, 2, 1, 0, "beta", ufunc_beta_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_betainc_loops[2]
cdef void *ufunc_betainc_ptr[4]
cdef void *ufunc_betainc_data[2]
cdef char ufunc_betainc_types[8]
cdef char *ufunc_betainc_doc = (
    "betainc(a, b, x)\n"
    "\n"
    "Compute the incomplete beta integral of the arguments, evaluated\n"
    "from zero to x::\n"
    "\n"
    "    gamma(a+b) / (gamma(a)*gamma(b)) * integral(t**(a-1) (1-t)**(b-1), t=0..x).\n"
    "\n"
    "Notes\n"
    "-----\n"
    "The incomplete beta is also sometimes defined without the terms\n"
    "in gamma, in which case the above definition is the so-called regularized\n"
    "incomplete beta. Under this definition, you can get the incomplete beta by\n"
    "multiplying the result of the scipy function by beta(a, b).")
ufunc_betainc_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_betainc_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_betainc_types[0] = <char>NPY_FLOAT
ufunc_betainc_types[1] = <char>NPY_FLOAT
ufunc_betainc_types[2] = <char>NPY_FLOAT
ufunc_betainc_types[3] = <char>NPY_FLOAT
ufunc_betainc_types[4] = <char>NPY_DOUBLE
ufunc_betainc_types[5] = <char>NPY_DOUBLE
ufunc_betainc_types[6] = <char>NPY_DOUBLE
ufunc_betainc_types[7] = <char>NPY_DOUBLE
ufunc_betainc_ptr[2*0] = <void*>_func_incbet
ufunc_betainc_ptr[2*0+1] = <void*>(<char*>"betainc")
ufunc_betainc_ptr[2*1] = <void*>_func_incbet
ufunc_betainc_ptr[2*1+1] = <void*>(<char*>"betainc")
ufunc_betainc_data[0] = &ufunc_betainc_ptr[2*0]
ufunc_betainc_data[1] = &ufunc_betainc_ptr[2*1]
betainc = np.PyUFunc_FromFuncAndData(ufunc_betainc_loops, ufunc_betainc_data, ufunc_betainc_types, 2, 3, 1, 0, "betainc", ufunc_betainc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_betaincinv_loops[2]
cdef void *ufunc_betaincinv_ptr[4]
cdef void *ufunc_betaincinv_data[2]
cdef char ufunc_betaincinv_types[8]
cdef char *ufunc_betaincinv_doc = (
    "betaincinv(a,b,y)\n"
    "\n"
    "Compute x such that betainc(a,b,x) = y.")
ufunc_betaincinv_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_betaincinv_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_betaincinv_types[0] = <char>NPY_FLOAT
ufunc_betaincinv_types[1] = <char>NPY_FLOAT
ufunc_betaincinv_types[2] = <char>NPY_FLOAT
ufunc_betaincinv_types[3] = <char>NPY_FLOAT
ufunc_betaincinv_types[4] = <char>NPY_DOUBLE
ufunc_betaincinv_types[5] = <char>NPY_DOUBLE
ufunc_betaincinv_types[6] = <char>NPY_DOUBLE
ufunc_betaincinv_types[7] = <char>NPY_DOUBLE
ufunc_betaincinv_ptr[2*0] = <void*>_func_incbi
ufunc_betaincinv_ptr[2*0+1] = <void*>(<char*>"betaincinv")
ufunc_betaincinv_ptr[2*1] = <void*>_func_incbi
ufunc_betaincinv_ptr[2*1+1] = <void*>(<char*>"betaincinv")
ufunc_betaincinv_data[0] = &ufunc_betaincinv_ptr[2*0]
ufunc_betaincinv_data[1] = &ufunc_betaincinv_ptr[2*1]
betaincinv = np.PyUFunc_FromFuncAndData(ufunc_betaincinv_loops, ufunc_betaincinv_data, ufunc_betaincinv_types, 2, 3, 1, 0, "betaincinv", ufunc_betaincinv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_betaln_loops[2]
cdef void *ufunc_betaln_ptr[4]
cdef void *ufunc_betaln_data[2]
cdef char ufunc_betaln_types[6]
cdef char *ufunc_betaln_doc = (
    "y=betaln(a,b) returns the natural logarithm of the absolute value of\n"
    "beta: ln(abs(beta(x))).")
ufunc_betaln_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_betaln_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_betaln_types[0] = <char>NPY_FLOAT
ufunc_betaln_types[1] = <char>NPY_FLOAT
ufunc_betaln_types[2] = <char>NPY_FLOAT
ufunc_betaln_types[3] = <char>NPY_DOUBLE
ufunc_betaln_types[4] = <char>NPY_DOUBLE
ufunc_betaln_types[5] = <char>NPY_DOUBLE
ufunc_betaln_ptr[2*0] = <void*>_func_lbeta
ufunc_betaln_ptr[2*0+1] = <void*>(<char*>"betaln")
ufunc_betaln_ptr[2*1] = <void*>_func_lbeta
ufunc_betaln_ptr[2*1+1] = <void*>(<char*>"betaln")
ufunc_betaln_data[0] = &ufunc_betaln_ptr[2*0]
ufunc_betaln_data[1] = &ufunc_betaln_ptr[2*1]
betaln = np.PyUFunc_FromFuncAndData(ufunc_betaln_loops, ufunc_betaln_data, ufunc_betaln_types, 2, 2, 1, 0, "betaln", ufunc_betaln_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_binom_loops[2]
cdef void *ufunc_binom_ptr[4]
cdef void *ufunc_binom_data[2]
cdef char ufunc_binom_types[6]
cdef char *ufunc_binom_doc = (
    "binom(n, k)\n"
    "\n"
    "Binomial coefficient")
ufunc_binom_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_binom_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_binom_types[0] = <char>NPY_FLOAT
ufunc_binom_types[1] = <char>NPY_FLOAT
ufunc_binom_types[2] = <char>NPY_FLOAT
ufunc_binom_types[3] = <char>NPY_DOUBLE
ufunc_binom_types[4] = <char>NPY_DOUBLE
ufunc_binom_types[5] = <char>NPY_DOUBLE
ufunc_binom_ptr[2*0] = <void*>_func_binom
ufunc_binom_ptr[2*0+1] = <void*>(<char*>"binom")
ufunc_binom_ptr[2*1] = <void*>_func_binom
ufunc_binom_ptr[2*1+1] = <void*>(<char*>"binom")
ufunc_binom_data[0] = &ufunc_binom_ptr[2*0]
ufunc_binom_data[1] = &ufunc_binom_ptr[2*1]
binom = np.PyUFunc_FromFuncAndData(ufunc_binom_loops, ufunc_binom_data, ufunc_binom_types, 2, 2, 1, 0, "binom", ufunc_binom_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_btdtr_loops[2]
cdef void *ufunc_btdtr_ptr[4]
cdef void *ufunc_btdtr_data[2]
cdef char ufunc_btdtr_types[8]
cdef char *ufunc_btdtr_doc = (
    "y=btdtr(a,b,x) returns the area from zero to x under the beta\n"
    "density function: gamma(a+b)/(gamma(a)*gamma(b)))*integral(t**(a-1)\n"
    "(1-t)**(b-1), t=0..x).  SEE ALSO betainc")
ufunc_btdtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_btdtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_btdtr_types[0] = <char>NPY_FLOAT
ufunc_btdtr_types[1] = <char>NPY_FLOAT
ufunc_btdtr_types[2] = <char>NPY_FLOAT
ufunc_btdtr_types[3] = <char>NPY_FLOAT
ufunc_btdtr_types[4] = <char>NPY_DOUBLE
ufunc_btdtr_types[5] = <char>NPY_DOUBLE
ufunc_btdtr_types[6] = <char>NPY_DOUBLE
ufunc_btdtr_types[7] = <char>NPY_DOUBLE
ufunc_btdtr_ptr[2*0] = <void*>_func_btdtr
ufunc_btdtr_ptr[2*0+1] = <void*>(<char*>"btdtr")
ufunc_btdtr_ptr[2*1] = <void*>_func_btdtr
ufunc_btdtr_ptr[2*1+1] = <void*>(<char*>"btdtr")
ufunc_btdtr_data[0] = &ufunc_btdtr_ptr[2*0]
ufunc_btdtr_data[1] = &ufunc_btdtr_ptr[2*1]
btdtr = np.PyUFunc_FromFuncAndData(ufunc_btdtr_loops, ufunc_btdtr_data, ufunc_btdtr_types, 2, 3, 1, 0, "btdtr", ufunc_btdtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_btdtri_loops[2]
cdef void *ufunc_btdtri_ptr[4]
cdef void *ufunc_btdtri_data[2]
cdef char ufunc_btdtri_types[8]
cdef char *ufunc_btdtri_doc = (
    "x=btdtri(a,b,p) returns the pth quantile of the beta distribution.  It is\n"
    "effectively the inverse of btdtr returning the value of x for which\n"
    "btdtr(a,b,x) = p.   SEE ALSO betaincinv")
ufunc_btdtri_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_btdtri_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_btdtri_types[0] = <char>NPY_FLOAT
ufunc_btdtri_types[1] = <char>NPY_FLOAT
ufunc_btdtri_types[2] = <char>NPY_FLOAT
ufunc_btdtri_types[3] = <char>NPY_FLOAT
ufunc_btdtri_types[4] = <char>NPY_DOUBLE
ufunc_btdtri_types[5] = <char>NPY_DOUBLE
ufunc_btdtri_types[6] = <char>NPY_DOUBLE
ufunc_btdtri_types[7] = <char>NPY_DOUBLE
ufunc_btdtri_ptr[2*0] = <void*>_func_incbi
ufunc_btdtri_ptr[2*0+1] = <void*>(<char*>"btdtri")
ufunc_btdtri_ptr[2*1] = <void*>_func_incbi
ufunc_btdtri_ptr[2*1+1] = <void*>(<char*>"btdtri")
ufunc_btdtri_data[0] = &ufunc_btdtri_ptr[2*0]
ufunc_btdtri_data[1] = &ufunc_btdtri_ptr[2*1]
btdtri = np.PyUFunc_FromFuncAndData(ufunc_btdtri_loops, ufunc_btdtri_data, ufunc_btdtri_types, 2, 3, 1, 0, "btdtri", ufunc_btdtri_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_btdtria_loops[2]
cdef void *ufunc_btdtria_ptr[4]
cdef void *ufunc_btdtria_data[2]
cdef char ufunc_btdtria_types[8]
cdef char *ufunc_btdtria_doc = (
    "")
ufunc_btdtria_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_btdtria_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_btdtria_types[0] = <char>NPY_FLOAT
ufunc_btdtria_types[1] = <char>NPY_FLOAT
ufunc_btdtria_types[2] = <char>NPY_FLOAT
ufunc_btdtria_types[3] = <char>NPY_FLOAT
ufunc_btdtria_types[4] = <char>NPY_DOUBLE
ufunc_btdtria_types[5] = <char>NPY_DOUBLE
ufunc_btdtria_types[6] = <char>NPY_DOUBLE
ufunc_btdtria_types[7] = <char>NPY_DOUBLE
ufunc_btdtria_ptr[2*0] = <void*>_func_cdfbet3_wrap
ufunc_btdtria_ptr[2*0+1] = <void*>(<char*>"btdtria")
ufunc_btdtria_ptr[2*1] = <void*>_func_cdfbet3_wrap
ufunc_btdtria_ptr[2*1+1] = <void*>(<char*>"btdtria")
ufunc_btdtria_data[0] = &ufunc_btdtria_ptr[2*0]
ufunc_btdtria_data[1] = &ufunc_btdtria_ptr[2*1]
btdtria = np.PyUFunc_FromFuncAndData(ufunc_btdtria_loops, ufunc_btdtria_data, ufunc_btdtria_types, 2, 3, 1, 0, "btdtria", ufunc_btdtria_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_btdtrib_loops[2]
cdef void *ufunc_btdtrib_ptr[4]
cdef void *ufunc_btdtrib_data[2]
cdef char ufunc_btdtrib_types[8]
cdef char *ufunc_btdtrib_doc = (
    "")
ufunc_btdtrib_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_btdtrib_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_btdtrib_types[0] = <char>NPY_FLOAT
ufunc_btdtrib_types[1] = <char>NPY_FLOAT
ufunc_btdtrib_types[2] = <char>NPY_FLOAT
ufunc_btdtrib_types[3] = <char>NPY_FLOAT
ufunc_btdtrib_types[4] = <char>NPY_DOUBLE
ufunc_btdtrib_types[5] = <char>NPY_DOUBLE
ufunc_btdtrib_types[6] = <char>NPY_DOUBLE
ufunc_btdtrib_types[7] = <char>NPY_DOUBLE
ufunc_btdtrib_ptr[2*0] = <void*>_func_cdfbet4_wrap
ufunc_btdtrib_ptr[2*0+1] = <void*>(<char*>"btdtrib")
ufunc_btdtrib_ptr[2*1] = <void*>_func_cdfbet4_wrap
ufunc_btdtrib_ptr[2*1+1] = <void*>(<char*>"btdtrib")
ufunc_btdtrib_data[0] = &ufunc_btdtrib_ptr[2*0]
ufunc_btdtrib_data[1] = &ufunc_btdtrib_ptr[2*1]
btdtrib = np.PyUFunc_FromFuncAndData(ufunc_btdtrib_loops, ufunc_btdtrib_data, ufunc_btdtrib_types, 2, 3, 1, 0, "btdtrib", ufunc_btdtrib_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_cbrt_loops[2]
cdef void *ufunc_cbrt_ptr[4]
cdef void *ufunc_cbrt_data[2]
cdef char ufunc_cbrt_types[4]
cdef char *ufunc_cbrt_doc = (
    "y=cbrt(x) returns the real cube root of x.")
ufunc_cbrt_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_cbrt_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_cbrt_types[0] = <char>NPY_FLOAT
ufunc_cbrt_types[1] = <char>NPY_FLOAT
ufunc_cbrt_types[2] = <char>NPY_DOUBLE
ufunc_cbrt_types[3] = <char>NPY_DOUBLE
ufunc_cbrt_ptr[2*0] = <void*>_func_cbrt
ufunc_cbrt_ptr[2*0+1] = <void*>(<char*>"cbrt")
ufunc_cbrt_ptr[2*1] = <void*>_func_cbrt
ufunc_cbrt_ptr[2*1+1] = <void*>(<char*>"cbrt")
ufunc_cbrt_data[0] = &ufunc_cbrt_ptr[2*0]
ufunc_cbrt_data[1] = &ufunc_cbrt_ptr[2*1]
cbrt = np.PyUFunc_FromFuncAndData(ufunc_cbrt_loops, ufunc_cbrt_data, ufunc_cbrt_types, 2, 1, 1, 0, "cbrt", ufunc_cbrt_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_chdtr_loops[2]
cdef void *ufunc_chdtr_ptr[4]
cdef void *ufunc_chdtr_data[2]
cdef char ufunc_chdtr_types[6]
cdef char *ufunc_chdtr_doc = (
    "p=chdtr(v,x) Returns the area under the left hand tail (from 0 to x) of the Chi\n"
    "square probability density function with v degrees of freedom:\n"
    "1/(2**(v/2) * gamma(v/2)) * integral(t**(v/2-1) * exp(-t/2), t=0..x)")
ufunc_chdtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_chdtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_chdtr_types[0] = <char>NPY_FLOAT
ufunc_chdtr_types[1] = <char>NPY_FLOAT
ufunc_chdtr_types[2] = <char>NPY_FLOAT
ufunc_chdtr_types[3] = <char>NPY_DOUBLE
ufunc_chdtr_types[4] = <char>NPY_DOUBLE
ufunc_chdtr_types[5] = <char>NPY_DOUBLE
ufunc_chdtr_ptr[2*0] = <void*>_func_chdtr
ufunc_chdtr_ptr[2*0+1] = <void*>(<char*>"chdtr")
ufunc_chdtr_ptr[2*1] = <void*>_func_chdtr
ufunc_chdtr_ptr[2*1+1] = <void*>(<char*>"chdtr")
ufunc_chdtr_data[0] = &ufunc_chdtr_ptr[2*0]
ufunc_chdtr_data[1] = &ufunc_chdtr_ptr[2*1]
chdtr = np.PyUFunc_FromFuncAndData(ufunc_chdtr_loops, ufunc_chdtr_data, ufunc_chdtr_types, 2, 2, 1, 0, "chdtr", ufunc_chdtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_chdtrc_loops[2]
cdef void *ufunc_chdtrc_ptr[4]
cdef void *ufunc_chdtrc_data[2]
cdef char ufunc_chdtrc_types[6]
cdef char *ufunc_chdtrc_doc = (
    "p=chdtrc(v,x) returns the area under the right hand tail (from x to\n"
    "infinity) of the Chi square probability density function with v\n"
    "degrees of freedom:\n"
    "1/(2**(v/2) * gamma(v/2)) * integral(t**(v/2-1) * exp(-t/2), t=x..inf)")
ufunc_chdtrc_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_chdtrc_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_chdtrc_types[0] = <char>NPY_FLOAT
ufunc_chdtrc_types[1] = <char>NPY_FLOAT
ufunc_chdtrc_types[2] = <char>NPY_FLOAT
ufunc_chdtrc_types[3] = <char>NPY_DOUBLE
ufunc_chdtrc_types[4] = <char>NPY_DOUBLE
ufunc_chdtrc_types[5] = <char>NPY_DOUBLE
ufunc_chdtrc_ptr[2*0] = <void*>_func_chdtrc
ufunc_chdtrc_ptr[2*0+1] = <void*>(<char*>"chdtrc")
ufunc_chdtrc_ptr[2*1] = <void*>_func_chdtrc
ufunc_chdtrc_ptr[2*1+1] = <void*>(<char*>"chdtrc")
ufunc_chdtrc_data[0] = &ufunc_chdtrc_ptr[2*0]
ufunc_chdtrc_data[1] = &ufunc_chdtrc_ptr[2*1]
chdtrc = np.PyUFunc_FromFuncAndData(ufunc_chdtrc_loops, ufunc_chdtrc_data, ufunc_chdtrc_types, 2, 2, 1, 0, "chdtrc", ufunc_chdtrc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_chdtri_loops[2]
cdef void *ufunc_chdtri_ptr[4]
cdef void *ufunc_chdtri_data[2]
cdef char ufunc_chdtri_types[6]
cdef char *ufunc_chdtri_doc = (
    "x=chdtri(v,p) returns the argument x such that chdtrc(v,x) is equal\n"
    "to p.")
ufunc_chdtri_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_chdtri_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_chdtri_types[0] = <char>NPY_FLOAT
ufunc_chdtri_types[1] = <char>NPY_FLOAT
ufunc_chdtri_types[2] = <char>NPY_FLOAT
ufunc_chdtri_types[3] = <char>NPY_DOUBLE
ufunc_chdtri_types[4] = <char>NPY_DOUBLE
ufunc_chdtri_types[5] = <char>NPY_DOUBLE
ufunc_chdtri_ptr[2*0] = <void*>_func_chdtri
ufunc_chdtri_ptr[2*0+1] = <void*>(<char*>"chdtri")
ufunc_chdtri_ptr[2*1] = <void*>_func_chdtri
ufunc_chdtri_ptr[2*1+1] = <void*>(<char*>"chdtri")
ufunc_chdtri_data[0] = &ufunc_chdtri_ptr[2*0]
ufunc_chdtri_data[1] = &ufunc_chdtri_ptr[2*1]
chdtri = np.PyUFunc_FromFuncAndData(ufunc_chdtri_loops, ufunc_chdtri_data, ufunc_chdtri_types, 2, 2, 1, 0, "chdtri", ufunc_chdtri_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_chdtriv_loops[2]
cdef void *ufunc_chdtriv_ptr[4]
cdef void *ufunc_chdtriv_data[2]
cdef char ufunc_chdtriv_types[6]
cdef char *ufunc_chdtriv_doc = (
    "")
ufunc_chdtriv_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_chdtriv_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_chdtriv_types[0] = <char>NPY_FLOAT
ufunc_chdtriv_types[1] = <char>NPY_FLOAT
ufunc_chdtriv_types[2] = <char>NPY_FLOAT
ufunc_chdtriv_types[3] = <char>NPY_DOUBLE
ufunc_chdtriv_types[4] = <char>NPY_DOUBLE
ufunc_chdtriv_types[5] = <char>NPY_DOUBLE
ufunc_chdtriv_ptr[2*0] = <void*>_func_cdfchi3_wrap
ufunc_chdtriv_ptr[2*0+1] = <void*>(<char*>"chdtriv")
ufunc_chdtriv_ptr[2*1] = <void*>_func_cdfchi3_wrap
ufunc_chdtriv_ptr[2*1+1] = <void*>(<char*>"chdtriv")
ufunc_chdtriv_data[0] = &ufunc_chdtriv_ptr[2*0]
ufunc_chdtriv_data[1] = &ufunc_chdtriv_ptr[2*1]
chdtriv = np.PyUFunc_FromFuncAndData(ufunc_chdtriv_loops, ufunc_chdtriv_data, ufunc_chdtriv_types, 2, 2, 1, 0, "chdtriv", ufunc_chdtriv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_chndtr_loops[2]
cdef void *ufunc_chndtr_ptr[4]
cdef void *ufunc_chndtr_data[2]
cdef char ufunc_chndtr_types[8]
cdef char *ufunc_chndtr_doc = (
    "")
ufunc_chndtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_chndtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_chndtr_types[0] = <char>NPY_FLOAT
ufunc_chndtr_types[1] = <char>NPY_FLOAT
ufunc_chndtr_types[2] = <char>NPY_FLOAT
ufunc_chndtr_types[3] = <char>NPY_FLOAT
ufunc_chndtr_types[4] = <char>NPY_DOUBLE
ufunc_chndtr_types[5] = <char>NPY_DOUBLE
ufunc_chndtr_types[6] = <char>NPY_DOUBLE
ufunc_chndtr_types[7] = <char>NPY_DOUBLE
ufunc_chndtr_ptr[2*0] = <void*>_func_cdfchn1_wrap
ufunc_chndtr_ptr[2*0+1] = <void*>(<char*>"chndtr")
ufunc_chndtr_ptr[2*1] = <void*>_func_cdfchn1_wrap
ufunc_chndtr_ptr[2*1+1] = <void*>(<char*>"chndtr")
ufunc_chndtr_data[0] = &ufunc_chndtr_ptr[2*0]
ufunc_chndtr_data[1] = &ufunc_chndtr_ptr[2*1]
chndtr = np.PyUFunc_FromFuncAndData(ufunc_chndtr_loops, ufunc_chndtr_data, ufunc_chndtr_types, 2, 3, 1, 0, "chndtr", ufunc_chndtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_chndtridf_loops[2]
cdef void *ufunc_chndtridf_ptr[4]
cdef void *ufunc_chndtridf_data[2]
cdef char ufunc_chndtridf_types[8]
cdef char *ufunc_chndtridf_doc = (
    "")
ufunc_chndtridf_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_chndtridf_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_chndtridf_types[0] = <char>NPY_FLOAT
ufunc_chndtridf_types[1] = <char>NPY_FLOAT
ufunc_chndtridf_types[2] = <char>NPY_FLOAT
ufunc_chndtridf_types[3] = <char>NPY_FLOAT
ufunc_chndtridf_types[4] = <char>NPY_DOUBLE
ufunc_chndtridf_types[5] = <char>NPY_DOUBLE
ufunc_chndtridf_types[6] = <char>NPY_DOUBLE
ufunc_chndtridf_types[7] = <char>NPY_DOUBLE
ufunc_chndtridf_ptr[2*0] = <void*>_func_cdfchn3_wrap
ufunc_chndtridf_ptr[2*0+1] = <void*>(<char*>"chndtridf")
ufunc_chndtridf_ptr[2*1] = <void*>_func_cdfchn3_wrap
ufunc_chndtridf_ptr[2*1+1] = <void*>(<char*>"chndtridf")
ufunc_chndtridf_data[0] = &ufunc_chndtridf_ptr[2*0]
ufunc_chndtridf_data[1] = &ufunc_chndtridf_ptr[2*1]
chndtridf = np.PyUFunc_FromFuncAndData(ufunc_chndtridf_loops, ufunc_chndtridf_data, ufunc_chndtridf_types, 2, 3, 1, 0, "chndtridf", ufunc_chndtridf_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_chndtrinc_loops[2]
cdef void *ufunc_chndtrinc_ptr[4]
cdef void *ufunc_chndtrinc_data[2]
cdef char ufunc_chndtrinc_types[8]
cdef char *ufunc_chndtrinc_doc = (
    "")
ufunc_chndtrinc_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_chndtrinc_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_chndtrinc_types[0] = <char>NPY_FLOAT
ufunc_chndtrinc_types[1] = <char>NPY_FLOAT
ufunc_chndtrinc_types[2] = <char>NPY_FLOAT
ufunc_chndtrinc_types[3] = <char>NPY_FLOAT
ufunc_chndtrinc_types[4] = <char>NPY_DOUBLE
ufunc_chndtrinc_types[5] = <char>NPY_DOUBLE
ufunc_chndtrinc_types[6] = <char>NPY_DOUBLE
ufunc_chndtrinc_types[7] = <char>NPY_DOUBLE
ufunc_chndtrinc_ptr[2*0] = <void*>_func_cdfchn4_wrap
ufunc_chndtrinc_ptr[2*0+1] = <void*>(<char*>"chndtrinc")
ufunc_chndtrinc_ptr[2*1] = <void*>_func_cdfchn4_wrap
ufunc_chndtrinc_ptr[2*1+1] = <void*>(<char*>"chndtrinc")
ufunc_chndtrinc_data[0] = &ufunc_chndtrinc_ptr[2*0]
ufunc_chndtrinc_data[1] = &ufunc_chndtrinc_ptr[2*1]
chndtrinc = np.PyUFunc_FromFuncAndData(ufunc_chndtrinc_loops, ufunc_chndtrinc_data, ufunc_chndtrinc_types, 2, 3, 1, 0, "chndtrinc", ufunc_chndtrinc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_chndtrix_loops[2]
cdef void *ufunc_chndtrix_ptr[4]
cdef void *ufunc_chndtrix_data[2]
cdef char ufunc_chndtrix_types[8]
cdef char *ufunc_chndtrix_doc = (
    "")
ufunc_chndtrix_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_chndtrix_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_chndtrix_types[0] = <char>NPY_FLOAT
ufunc_chndtrix_types[1] = <char>NPY_FLOAT
ufunc_chndtrix_types[2] = <char>NPY_FLOAT
ufunc_chndtrix_types[3] = <char>NPY_FLOAT
ufunc_chndtrix_types[4] = <char>NPY_DOUBLE
ufunc_chndtrix_types[5] = <char>NPY_DOUBLE
ufunc_chndtrix_types[6] = <char>NPY_DOUBLE
ufunc_chndtrix_types[7] = <char>NPY_DOUBLE
ufunc_chndtrix_ptr[2*0] = <void*>_func_cdfchn2_wrap
ufunc_chndtrix_ptr[2*0+1] = <void*>(<char*>"chndtrix")
ufunc_chndtrix_ptr[2*1] = <void*>_func_cdfchn2_wrap
ufunc_chndtrix_ptr[2*1+1] = <void*>(<char*>"chndtrix")
ufunc_chndtrix_data[0] = &ufunc_chndtrix_ptr[2*0]
ufunc_chndtrix_data[1] = &ufunc_chndtrix_ptr[2*1]
chndtrix = np.PyUFunc_FromFuncAndData(ufunc_chndtrix_loops, ufunc_chndtrix_data, ufunc_chndtrix_types, 2, 3, 1, 0, "chndtrix", ufunc_chndtrix_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_cosdg_loops[2]
cdef void *ufunc_cosdg_ptr[4]
cdef void *ufunc_cosdg_data[2]
cdef char ufunc_cosdg_types[4]
cdef char *ufunc_cosdg_doc = (
    "y=cosdg(x) calculates the cosine of the angle x given in degrees.")
ufunc_cosdg_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_cosdg_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_cosdg_types[0] = <char>NPY_FLOAT
ufunc_cosdg_types[1] = <char>NPY_FLOAT
ufunc_cosdg_types[2] = <char>NPY_DOUBLE
ufunc_cosdg_types[3] = <char>NPY_DOUBLE
ufunc_cosdg_ptr[2*0] = <void*>_func_cosdg
ufunc_cosdg_ptr[2*0+1] = <void*>(<char*>"cosdg")
ufunc_cosdg_ptr[2*1] = <void*>_func_cosdg
ufunc_cosdg_ptr[2*1+1] = <void*>(<char*>"cosdg")
ufunc_cosdg_data[0] = &ufunc_cosdg_ptr[2*0]
ufunc_cosdg_data[1] = &ufunc_cosdg_ptr[2*1]
cosdg = np.PyUFunc_FromFuncAndData(ufunc_cosdg_loops, ufunc_cosdg_data, ufunc_cosdg_types, 2, 1, 1, 0, "cosdg", ufunc_cosdg_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_cosm1_loops[2]
cdef void *ufunc_cosm1_ptr[4]
cdef void *ufunc_cosm1_data[2]
cdef char ufunc_cosm1_types[4]
cdef char *ufunc_cosm1_doc = (
    "y=calculates cos(x) - 1 for use when x is near zero.")
ufunc_cosm1_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_cosm1_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_cosm1_types[0] = <char>NPY_FLOAT
ufunc_cosm1_types[1] = <char>NPY_FLOAT
ufunc_cosm1_types[2] = <char>NPY_DOUBLE
ufunc_cosm1_types[3] = <char>NPY_DOUBLE
ufunc_cosm1_ptr[2*0] = <void*>_func_cosm1
ufunc_cosm1_ptr[2*0+1] = <void*>(<char*>"cosm1")
ufunc_cosm1_ptr[2*1] = <void*>_func_cosm1
ufunc_cosm1_ptr[2*1+1] = <void*>(<char*>"cosm1")
ufunc_cosm1_data[0] = &ufunc_cosm1_ptr[2*0]
ufunc_cosm1_data[1] = &ufunc_cosm1_ptr[2*1]
cosm1 = np.PyUFunc_FromFuncAndData(ufunc_cosm1_loops, ufunc_cosm1_data, ufunc_cosm1_types, 2, 1, 1, 0, "cosm1", ufunc_cosm1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_cotdg_loops[2]
cdef void *ufunc_cotdg_ptr[4]
cdef void *ufunc_cotdg_data[2]
cdef char ufunc_cotdg_types[4]
cdef char *ufunc_cotdg_doc = (
    "y=cotdg(x) calculates the cotangent of the angle x given in degrees.")
ufunc_cotdg_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_cotdg_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_cotdg_types[0] = <char>NPY_FLOAT
ufunc_cotdg_types[1] = <char>NPY_FLOAT
ufunc_cotdg_types[2] = <char>NPY_DOUBLE
ufunc_cotdg_types[3] = <char>NPY_DOUBLE
ufunc_cotdg_ptr[2*0] = <void*>_func_cotdg
ufunc_cotdg_ptr[2*0+1] = <void*>(<char*>"cotdg")
ufunc_cotdg_ptr[2*1] = <void*>_func_cotdg
ufunc_cotdg_ptr[2*1+1] = <void*>(<char*>"cotdg")
ufunc_cotdg_data[0] = &ufunc_cotdg_ptr[2*0]
ufunc_cotdg_data[1] = &ufunc_cotdg_ptr[2*1]
cotdg = np.PyUFunc_FromFuncAndData(ufunc_cotdg_loops, ufunc_cotdg_data, ufunc_cotdg_types, 2, 1, 1, 0, "cotdg", ufunc_cotdg_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_dawsn_loops[4]
cdef void *ufunc_dawsn_ptr[8]
cdef void *ufunc_dawsn_data[4]
cdef char ufunc_dawsn_types[8]
cdef char *ufunc_dawsn_doc = (
    "y=dawsn(x) returns dawson's integral: exp(-x**2) *\n"
    "integral(exp(t**2),t=0..x).\n"
    "\n"
    "References\n"
    "----------\n"
    ".. [1] Steven G. Johnson, Faddeeva W function implementation.\n"
    "   http://ab-initio.mit.edu/Faddeeva")
ufunc_dawsn_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_dawsn_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_dawsn_loops[2] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_dawsn_loops[3] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_dawsn_types[0] = <char>NPY_FLOAT
ufunc_dawsn_types[1] = <char>NPY_FLOAT
ufunc_dawsn_types[2] = <char>NPY_DOUBLE
ufunc_dawsn_types[3] = <char>NPY_DOUBLE
ufunc_dawsn_types[4] = <char>NPY_CFLOAT
ufunc_dawsn_types[5] = <char>NPY_CFLOAT
ufunc_dawsn_types[6] = <char>NPY_CDOUBLE
ufunc_dawsn_types[7] = <char>NPY_CDOUBLE
ufunc_dawsn_ptr[2*0] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_dawsn
ufunc_dawsn_ptr[2*0+1] = <void*>(<char*>"dawsn")
ufunc_dawsn_ptr[2*1] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_dawsn
ufunc_dawsn_ptr[2*1+1] = <void*>(<char*>"dawsn")
ufunc_dawsn_ptr[2*2] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_dawsn_complex
ufunc_dawsn_ptr[2*2+1] = <void*>(<char*>"dawsn")
ufunc_dawsn_ptr[2*3] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_dawsn_complex
ufunc_dawsn_ptr[2*3+1] = <void*>(<char*>"dawsn")
ufunc_dawsn_data[0] = &ufunc_dawsn_ptr[2*0]
ufunc_dawsn_data[1] = &ufunc_dawsn_ptr[2*1]
ufunc_dawsn_data[2] = &ufunc_dawsn_ptr[2*2]
ufunc_dawsn_data[3] = &ufunc_dawsn_ptr[2*3]
dawsn = np.PyUFunc_FromFuncAndData(ufunc_dawsn_loops, ufunc_dawsn_data, ufunc_dawsn_types, 4, 1, 1, 0, "dawsn", ufunc_dawsn_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ellipe_loops[2]
cdef void *ufunc_ellipe_ptr[4]
cdef void *ufunc_ellipe_data[2]
cdef char ufunc_ellipe_types[4]
cdef char *ufunc_ellipe_doc = (
    "y=ellipe(m) returns the complete integral of the second kind:\n"
    "integral(sqrt(1-m*sin(t)**2),t=0..pi/2)")
ufunc_ellipe_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_ellipe_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_ellipe_types[0] = <char>NPY_FLOAT
ufunc_ellipe_types[1] = <char>NPY_FLOAT
ufunc_ellipe_types[2] = <char>NPY_DOUBLE
ufunc_ellipe_types[3] = <char>NPY_DOUBLE
ufunc_ellipe_ptr[2*0] = <void*>_func_ellpe
ufunc_ellipe_ptr[2*0+1] = <void*>(<char*>"ellipe")
ufunc_ellipe_ptr[2*1] = <void*>_func_ellpe
ufunc_ellipe_ptr[2*1+1] = <void*>(<char*>"ellipe")
ufunc_ellipe_data[0] = &ufunc_ellipe_ptr[2*0]
ufunc_ellipe_data[1] = &ufunc_ellipe_ptr[2*1]
ellipe = np.PyUFunc_FromFuncAndData(ufunc_ellipe_loops, ufunc_ellipe_data, ufunc_ellipe_types, 2, 1, 1, 0, "ellipe", ufunc_ellipe_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ellipeinc_loops[2]
cdef void *ufunc_ellipeinc_ptr[4]
cdef void *ufunc_ellipeinc_data[2]
cdef char ufunc_ellipeinc_types[6]
cdef char *ufunc_ellipeinc_doc = (
    "y=ellipeinc(phi,m) returns the incomplete elliptic integral of the\n"
    "second kind: integral(sqrt(1-m*sin(t)**2),t=0..phi)")
ufunc_ellipeinc_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_ellipeinc_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_ellipeinc_types[0] = <char>NPY_FLOAT
ufunc_ellipeinc_types[1] = <char>NPY_FLOAT
ufunc_ellipeinc_types[2] = <char>NPY_FLOAT
ufunc_ellipeinc_types[3] = <char>NPY_DOUBLE
ufunc_ellipeinc_types[4] = <char>NPY_DOUBLE
ufunc_ellipeinc_types[5] = <char>NPY_DOUBLE
ufunc_ellipeinc_ptr[2*0] = <void*>_func_ellie
ufunc_ellipeinc_ptr[2*0+1] = <void*>(<char*>"ellipeinc")
ufunc_ellipeinc_ptr[2*1] = <void*>_func_ellie
ufunc_ellipeinc_ptr[2*1+1] = <void*>(<char*>"ellipeinc")
ufunc_ellipeinc_data[0] = &ufunc_ellipeinc_ptr[2*0]
ufunc_ellipeinc_data[1] = &ufunc_ellipeinc_ptr[2*1]
ellipeinc = np.PyUFunc_FromFuncAndData(ufunc_ellipeinc_loops, ufunc_ellipeinc_data, ufunc_ellipeinc_types, 2, 2, 1, 0, "ellipeinc", ufunc_ellipeinc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ellipj_loops[2]
cdef void *ufunc_ellipj_ptr[4]
cdef void *ufunc_ellipj_data[2]
cdef char ufunc_ellipj_types[12]
cdef char *ufunc_ellipj_doc = (
    "(sn,cn,dn,ph)=ellipj(u,m) calculates the Jacobian elliptic functions of\n"
    "parameter m between 0 and 1, and real u.  The returned functions are\n"
    "often written sn(u|m), cn(u|m), and dn(u|m).  The value of ph is such\n"
    "that if u = ellik(ph,m), then sn(u|m) = sin(ph) and cn(u|m) = cos(ph).")
ufunc_ellipj_loops[0] = <np.PyUFuncGenericFunction>loop_i_dd_dddd_As_ff_ffff
ufunc_ellipj_loops[1] = <np.PyUFuncGenericFunction>loop_i_dd_dddd_As_dd_dddd
ufunc_ellipj_types[0] = <char>NPY_FLOAT
ufunc_ellipj_types[1] = <char>NPY_FLOAT
ufunc_ellipj_types[2] = <char>NPY_FLOAT
ufunc_ellipj_types[3] = <char>NPY_FLOAT
ufunc_ellipj_types[4] = <char>NPY_FLOAT
ufunc_ellipj_types[5] = <char>NPY_FLOAT
ufunc_ellipj_types[6] = <char>NPY_DOUBLE
ufunc_ellipj_types[7] = <char>NPY_DOUBLE
ufunc_ellipj_types[8] = <char>NPY_DOUBLE
ufunc_ellipj_types[9] = <char>NPY_DOUBLE
ufunc_ellipj_types[10] = <char>NPY_DOUBLE
ufunc_ellipj_types[11] = <char>NPY_DOUBLE
ufunc_ellipj_ptr[2*0] = <void*>_func_ellpj
ufunc_ellipj_ptr[2*0+1] = <void*>(<char*>"ellipj")
ufunc_ellipj_ptr[2*1] = <void*>_func_ellpj
ufunc_ellipj_ptr[2*1+1] = <void*>(<char*>"ellipj")
ufunc_ellipj_data[0] = &ufunc_ellipj_ptr[2*0]
ufunc_ellipj_data[1] = &ufunc_ellipj_ptr[2*1]
ellipj = np.PyUFunc_FromFuncAndData(ufunc_ellipj_loops, ufunc_ellipj_data, ufunc_ellipj_types, 2, 2, 4, 0, "ellipj", ufunc_ellipj_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ellipkinc_loops[2]
cdef void *ufunc_ellipkinc_ptr[4]
cdef void *ufunc_ellipkinc_data[2]
cdef char ufunc_ellipkinc_types[6]
cdef char *ufunc_ellipkinc_doc = (
    "y=ellipkinc(phi,m) returns the incomplete elliptic integral of the first\n"
    "kind: integral(1/sqrt(1-m*sin(t)**2),t=0..phi)")
ufunc_ellipkinc_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_ellipkinc_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_ellipkinc_types[0] = <char>NPY_FLOAT
ufunc_ellipkinc_types[1] = <char>NPY_FLOAT
ufunc_ellipkinc_types[2] = <char>NPY_FLOAT
ufunc_ellipkinc_types[3] = <char>NPY_DOUBLE
ufunc_ellipkinc_types[4] = <char>NPY_DOUBLE
ufunc_ellipkinc_types[5] = <char>NPY_DOUBLE
ufunc_ellipkinc_ptr[2*0] = <void*>_func_ellik
ufunc_ellipkinc_ptr[2*0+1] = <void*>(<char*>"ellipkinc")
ufunc_ellipkinc_ptr[2*1] = <void*>_func_ellik
ufunc_ellipkinc_ptr[2*1+1] = <void*>(<char*>"ellipkinc")
ufunc_ellipkinc_data[0] = &ufunc_ellipkinc_ptr[2*0]
ufunc_ellipkinc_data[1] = &ufunc_ellipkinc_ptr[2*1]
ellipkinc = np.PyUFunc_FromFuncAndData(ufunc_ellipkinc_loops, ufunc_ellipkinc_data, ufunc_ellipkinc_types, 2, 2, 1, 0, "ellipkinc", ufunc_ellipkinc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ellipkm1_loops[2]
cdef void *ufunc_ellipkm1_ptr[4]
cdef void *ufunc_ellipkm1_data[2]
cdef char ufunc_ellipkm1_types[4]
cdef char *ufunc_ellipkm1_doc = (
    "ellipkm1(p)\n"
    "\n"
    "The complete elliptic integral of the first kind around m=1.\n"
    "\n"
    "This function is defined as\n"
    "\n"
    ".. math:: K(p) = \int_0^{\pi/2} [1 - m \sin(t)^2]^{-1/2} dt\n"
    "\n"
    "where `m = 1 - p`.\n"
    "\n"
    "Parameters\n"
    "----------\n"
    "p : array_like\n"
    "    Defines the parameter of the elliptic integral as m = 1 - p.\n"
    "\n"
    "Returns\n"
    "-------\n"
    "K : array_like\n"
    "    Value of the elliptic integral.\n"
    "\n"
    "See Also\n"
    "--------\n"
    "ellipk")
ufunc_ellipkm1_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_ellipkm1_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_ellipkm1_types[0] = <char>NPY_FLOAT
ufunc_ellipkm1_types[1] = <char>NPY_FLOAT
ufunc_ellipkm1_types[2] = <char>NPY_DOUBLE
ufunc_ellipkm1_types[3] = <char>NPY_DOUBLE
ufunc_ellipkm1_ptr[2*0] = <void*>_func_ellpk
ufunc_ellipkm1_ptr[2*0+1] = <void*>(<char*>"ellipkm1")
ufunc_ellipkm1_ptr[2*1] = <void*>_func_ellpk
ufunc_ellipkm1_ptr[2*1+1] = <void*>(<char*>"ellipkm1")
ufunc_ellipkm1_data[0] = &ufunc_ellipkm1_ptr[2*0]
ufunc_ellipkm1_data[1] = &ufunc_ellipkm1_ptr[2*1]
ellipkm1 = np.PyUFunc_FromFuncAndData(ufunc_ellipkm1_loops, ufunc_ellipkm1_data, ufunc_ellipkm1_types, 2, 1, 1, 0, "ellipkm1", ufunc_ellipkm1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_erf_loops[4]
cdef void *ufunc_erf_ptr[8]
cdef void *ufunc_erf_data[4]
cdef char ufunc_erf_types[8]
cdef char *ufunc_erf_doc = (
    "erf(z)\n"
    "\n"
    "Returns the error function of complex argument.\n"
    "\n"
    "It is defined as ``2/sqrt(pi)*integral(exp(-t**2), t=0..z)``.\n"
    "\n"
    "Parameters\n"
    "----------\n"
    "x : ndarray\n"
    "    Input array.\n"
    "\n"
    "Returns\n"
    "-------\n"
    "res : ndarray\n"
    "    The values of the error function at the given points x.\n"
    "\n"
    "See Also\n"
    "--------\n"
    "erfc, erfinv, erfcinv\n"
    "\n"
    "Notes\n"
    "-----\n"
    "The cumulative of the unit normal distribution is given by\n"
    "``Phi(z) = 1/2[1 + erf(z/sqrt(2))]``.\n"
    "\n"
    "References\n"
    "----------\n"
    ".. [1] http://en.wikipedia.org/wiki/Error_function\n"
    ".. [2] Milton Abramowitz and Irene A. Stegun, eds.\n"
    "    Handbook of Mathematical Functions with Formulas,\n"
    "    Graphs, and Mathematical Tables. New York: Dover,\n"
    "    1972. http://www.math.sfu.ca/~cbm/aands/page_297.htm\n"
    ".. [3] Steven G. Johnson, Faddeeva W function implementation.\n"
    "   http://ab-initio.mit.edu/Faddeeva")
ufunc_erf_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_erf_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_erf_loops[2] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_erf_loops[3] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_erf_types[0] = <char>NPY_FLOAT
ufunc_erf_types[1] = <char>NPY_FLOAT
ufunc_erf_types[2] = <char>NPY_DOUBLE
ufunc_erf_types[3] = <char>NPY_DOUBLE
ufunc_erf_types[4] = <char>NPY_CFLOAT
ufunc_erf_types[5] = <char>NPY_CFLOAT
ufunc_erf_types[6] = <char>NPY_CDOUBLE
ufunc_erf_types[7] = <char>NPY_CDOUBLE
ufunc_erf_ptr[2*0] = <void*>_func_erf
ufunc_erf_ptr[2*0+1] = <void*>(<char*>"erf")
ufunc_erf_ptr[2*1] = <void*>_func_erf
ufunc_erf_ptr[2*1+1] = <void*>(<char*>"erf")
ufunc_erf_ptr[2*2] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erf
ufunc_erf_ptr[2*2+1] = <void*>(<char*>"erf")
ufunc_erf_ptr[2*3] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erf
ufunc_erf_ptr[2*3+1] = <void*>(<char*>"erf")
ufunc_erf_data[0] = &ufunc_erf_ptr[2*0]
ufunc_erf_data[1] = &ufunc_erf_ptr[2*1]
ufunc_erf_data[2] = &ufunc_erf_ptr[2*2]
ufunc_erf_data[3] = &ufunc_erf_ptr[2*3]
erf = np.PyUFunc_FromFuncAndData(ufunc_erf_loops, ufunc_erf_data, ufunc_erf_types, 4, 1, 1, 0, "erf", ufunc_erf_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_erfc_loops[4]
cdef void *ufunc_erfc_ptr[8]
cdef void *ufunc_erfc_data[4]
cdef char ufunc_erfc_types[8]
cdef char *ufunc_erfc_doc = (
    "y=erfc(x) returns 1 - erf(x).\n"
    "\n"
    "References\n"
    "----------\n"
    ".. [1] Steven G. Johnson, Faddeeva W function implementation.\n"
    "   http://ab-initio.mit.edu/Faddeeva")
ufunc_erfc_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_erfc_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_erfc_loops[2] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_erfc_loops[3] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_erfc_types[0] = <char>NPY_FLOAT
ufunc_erfc_types[1] = <char>NPY_FLOAT
ufunc_erfc_types[2] = <char>NPY_DOUBLE
ufunc_erfc_types[3] = <char>NPY_DOUBLE
ufunc_erfc_types[4] = <char>NPY_CFLOAT
ufunc_erfc_types[5] = <char>NPY_CFLOAT
ufunc_erfc_types[6] = <char>NPY_CDOUBLE
ufunc_erfc_types[7] = <char>NPY_CDOUBLE
ufunc_erfc_ptr[2*0] = <void*>_func_erfc
ufunc_erfc_ptr[2*0+1] = <void*>(<char*>"erfc")
ufunc_erfc_ptr[2*1] = <void*>_func_erfc
ufunc_erfc_ptr[2*1+1] = <void*>(<char*>"erfc")
ufunc_erfc_ptr[2*2] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erfc
ufunc_erfc_ptr[2*2+1] = <void*>(<char*>"erfc")
ufunc_erfc_ptr[2*3] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erfc
ufunc_erfc_ptr[2*3+1] = <void*>(<char*>"erfc")
ufunc_erfc_data[0] = &ufunc_erfc_ptr[2*0]
ufunc_erfc_data[1] = &ufunc_erfc_ptr[2*1]
ufunc_erfc_data[2] = &ufunc_erfc_ptr[2*2]
ufunc_erfc_data[3] = &ufunc_erfc_ptr[2*3]
erfc = np.PyUFunc_FromFuncAndData(ufunc_erfc_loops, ufunc_erfc_data, ufunc_erfc_types, 4, 1, 1, 0, "erfc", ufunc_erfc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_erfcx_loops[4]
cdef void *ufunc_erfcx_ptr[8]
cdef void *ufunc_erfcx_data[4]
cdef char ufunc_erfcx_types[8]
cdef char *ufunc_erfcx_doc = (
    "Scaled complementary error function, exp(x^2) erfc(x)\n"
    "\n"
    ".. versionadded:: 0.12.0\n"
    "\n"
    "References\n"
    "----------\n"
    ".. [1] Steven G. Johnson, Faddeeva W function implementation.\n"
    "   http://ab-initio.mit.edu/Faddeeva")
ufunc_erfcx_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_erfcx_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_erfcx_loops[2] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_erfcx_loops[3] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_erfcx_types[0] = <char>NPY_FLOAT
ufunc_erfcx_types[1] = <char>NPY_FLOAT
ufunc_erfcx_types[2] = <char>NPY_DOUBLE
ufunc_erfcx_types[3] = <char>NPY_DOUBLE
ufunc_erfcx_types[4] = <char>NPY_CFLOAT
ufunc_erfcx_types[5] = <char>NPY_CFLOAT
ufunc_erfcx_types[6] = <char>NPY_CDOUBLE
ufunc_erfcx_types[7] = <char>NPY_CDOUBLE
ufunc_erfcx_ptr[2*0] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erfcx
ufunc_erfcx_ptr[2*0+1] = <void*>(<char*>"erfcx")
ufunc_erfcx_ptr[2*1] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erfcx
ufunc_erfcx_ptr[2*1+1] = <void*>(<char*>"erfcx")
ufunc_erfcx_ptr[2*2] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erfcx_complex
ufunc_erfcx_ptr[2*2+1] = <void*>(<char*>"erfcx")
ufunc_erfcx_ptr[2*3] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erfcx_complex
ufunc_erfcx_ptr[2*3+1] = <void*>(<char*>"erfcx")
ufunc_erfcx_data[0] = &ufunc_erfcx_ptr[2*0]
ufunc_erfcx_data[1] = &ufunc_erfcx_ptr[2*1]
ufunc_erfcx_data[2] = &ufunc_erfcx_ptr[2*2]
ufunc_erfcx_data[3] = &ufunc_erfcx_ptr[2*3]
erfcx = np.PyUFunc_FromFuncAndData(ufunc_erfcx_loops, ufunc_erfcx_data, ufunc_erfcx_types, 4, 1, 1, 0, "erfcx", ufunc_erfcx_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_erfi_loops[4]
cdef void *ufunc_erfi_ptr[8]
cdef void *ufunc_erfi_data[4]
cdef char ufunc_erfi_types[8]
cdef char *ufunc_erfi_doc = (
    "Imaginary error function, -i erf(i z)\n"
    "\n"
    ".. versionadded:: 0.12.0\n"
    "\n"
    "References\n"
    "----------\n"
    ".. [1] Steven G. Johnson, Faddeeva W function implementation.\n"
    "   http://ab-initio.mit.edu/Faddeeva")
ufunc_erfi_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_erfi_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_erfi_loops[2] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_erfi_loops[3] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_erfi_types[0] = <char>NPY_FLOAT
ufunc_erfi_types[1] = <char>NPY_FLOAT
ufunc_erfi_types[2] = <char>NPY_DOUBLE
ufunc_erfi_types[3] = <char>NPY_DOUBLE
ufunc_erfi_types[4] = <char>NPY_CFLOAT
ufunc_erfi_types[5] = <char>NPY_CFLOAT
ufunc_erfi_types[6] = <char>NPY_CDOUBLE
ufunc_erfi_types[7] = <char>NPY_CDOUBLE
ufunc_erfi_ptr[2*0] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erfi
ufunc_erfi_ptr[2*0+1] = <void*>(<char*>"erfi")
ufunc_erfi_ptr[2*1] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erfi
ufunc_erfi_ptr[2*1+1] = <void*>(<char*>"erfi")
ufunc_erfi_ptr[2*2] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erfi_complex
ufunc_erfi_ptr[2*2+1] = <void*>(<char*>"erfi")
ufunc_erfi_ptr[2*3] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_erfi_complex
ufunc_erfi_ptr[2*3+1] = <void*>(<char*>"erfi")
ufunc_erfi_data[0] = &ufunc_erfi_ptr[2*0]
ufunc_erfi_data[1] = &ufunc_erfi_ptr[2*1]
ufunc_erfi_data[2] = &ufunc_erfi_ptr[2*2]
ufunc_erfi_data[3] = &ufunc_erfi_ptr[2*3]
erfi = np.PyUFunc_FromFuncAndData(ufunc_erfi_loops, ufunc_erfi_data, ufunc_erfi_types, 4, 1, 1, 0, "erfi", ufunc_erfi_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_chebyc_loops[6]
cdef void *ufunc_eval_chebyc_ptr[12]
cdef void *ufunc_eval_chebyc_data[6]
cdef char ufunc_eval_chebyc_types[18]
cdef char *ufunc_eval_chebyc_doc = (
    "eval_chebyc(n, x, out=None)\n"
    "\n"
    "Evaluate Chebyshev C polynomial at a point.")
ufunc_eval_chebyc_loops[0] = <np.PyUFuncGenericFunction>loop_d_ld__As_lf_f
ufunc_eval_chebyc_loops[1] = <np.PyUFuncGenericFunction>loop_d_ld__As_ld_d
ufunc_eval_chebyc_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_eval_chebyc_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_eval_chebyc_loops[4] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_eval_chebyc_loops[5] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_eval_chebyc_types[0] = <char>NPY_LONG
ufunc_eval_chebyc_types[1] = <char>NPY_FLOAT
ufunc_eval_chebyc_types[2] = <char>NPY_FLOAT
ufunc_eval_chebyc_types[3] = <char>NPY_LONG
ufunc_eval_chebyc_types[4] = <char>NPY_DOUBLE
ufunc_eval_chebyc_types[5] = <char>NPY_DOUBLE
ufunc_eval_chebyc_types[6] = <char>NPY_FLOAT
ufunc_eval_chebyc_types[7] = <char>NPY_FLOAT
ufunc_eval_chebyc_types[8] = <char>NPY_FLOAT
ufunc_eval_chebyc_types[9] = <char>NPY_FLOAT
ufunc_eval_chebyc_types[10] = <char>NPY_CFLOAT
ufunc_eval_chebyc_types[11] = <char>NPY_CFLOAT
ufunc_eval_chebyc_types[12] = <char>NPY_DOUBLE
ufunc_eval_chebyc_types[13] = <char>NPY_DOUBLE
ufunc_eval_chebyc_types[14] = <char>NPY_DOUBLE
ufunc_eval_chebyc_types[15] = <char>NPY_DOUBLE
ufunc_eval_chebyc_types[16] = <char>NPY_CDOUBLE
ufunc_eval_chebyc_types[17] = <char>NPY_CDOUBLE
ufunc_eval_chebyc_ptr[2*0] = <void*>_func_eval_chebyc_l
ufunc_eval_chebyc_ptr[2*0+1] = <void*>(<char*>"eval_chebyc")
ufunc_eval_chebyc_ptr[2*1] = <void*>_func_eval_chebyc_l
ufunc_eval_chebyc_ptr[2*1+1] = <void*>(<char*>"eval_chebyc")
ufunc_eval_chebyc_ptr[2*2] = <void*>_func_eval_chebyc[double]
ufunc_eval_chebyc_ptr[2*2+1] = <void*>(<char*>"eval_chebyc")
ufunc_eval_chebyc_ptr[2*3] = <void*>_func_eval_chebyc[double_complex]
ufunc_eval_chebyc_ptr[2*3+1] = <void*>(<char*>"eval_chebyc")
ufunc_eval_chebyc_ptr[2*4] = <void*>_func_eval_chebyc[double]
ufunc_eval_chebyc_ptr[2*4+1] = <void*>(<char*>"eval_chebyc")
ufunc_eval_chebyc_ptr[2*5] = <void*>_func_eval_chebyc[double_complex]
ufunc_eval_chebyc_ptr[2*5+1] = <void*>(<char*>"eval_chebyc")
ufunc_eval_chebyc_data[0] = &ufunc_eval_chebyc_ptr[2*0]
ufunc_eval_chebyc_data[1] = &ufunc_eval_chebyc_ptr[2*1]
ufunc_eval_chebyc_data[2] = &ufunc_eval_chebyc_ptr[2*2]
ufunc_eval_chebyc_data[3] = &ufunc_eval_chebyc_ptr[2*3]
ufunc_eval_chebyc_data[4] = &ufunc_eval_chebyc_ptr[2*4]
ufunc_eval_chebyc_data[5] = &ufunc_eval_chebyc_ptr[2*5]
eval_chebyc = np.PyUFunc_FromFuncAndData(ufunc_eval_chebyc_loops, ufunc_eval_chebyc_data, ufunc_eval_chebyc_types, 6, 2, 1, 0, "eval_chebyc", ufunc_eval_chebyc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_chebys_loops[6]
cdef void *ufunc_eval_chebys_ptr[12]
cdef void *ufunc_eval_chebys_data[6]
cdef char ufunc_eval_chebys_types[18]
cdef char *ufunc_eval_chebys_doc = (
    "eval_chebys(n, x, out=None)\n"
    "\n"
    "Evaluate Chebyshev S polynomial at a point.")
ufunc_eval_chebys_loops[0] = <np.PyUFuncGenericFunction>loop_d_ld__As_lf_f
ufunc_eval_chebys_loops[1] = <np.PyUFuncGenericFunction>loop_d_ld__As_ld_d
ufunc_eval_chebys_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_eval_chebys_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_eval_chebys_loops[4] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_eval_chebys_loops[5] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_eval_chebys_types[0] = <char>NPY_LONG
ufunc_eval_chebys_types[1] = <char>NPY_FLOAT
ufunc_eval_chebys_types[2] = <char>NPY_FLOAT
ufunc_eval_chebys_types[3] = <char>NPY_LONG
ufunc_eval_chebys_types[4] = <char>NPY_DOUBLE
ufunc_eval_chebys_types[5] = <char>NPY_DOUBLE
ufunc_eval_chebys_types[6] = <char>NPY_FLOAT
ufunc_eval_chebys_types[7] = <char>NPY_FLOAT
ufunc_eval_chebys_types[8] = <char>NPY_FLOAT
ufunc_eval_chebys_types[9] = <char>NPY_FLOAT
ufunc_eval_chebys_types[10] = <char>NPY_CFLOAT
ufunc_eval_chebys_types[11] = <char>NPY_CFLOAT
ufunc_eval_chebys_types[12] = <char>NPY_DOUBLE
ufunc_eval_chebys_types[13] = <char>NPY_DOUBLE
ufunc_eval_chebys_types[14] = <char>NPY_DOUBLE
ufunc_eval_chebys_types[15] = <char>NPY_DOUBLE
ufunc_eval_chebys_types[16] = <char>NPY_CDOUBLE
ufunc_eval_chebys_types[17] = <char>NPY_CDOUBLE
ufunc_eval_chebys_ptr[2*0] = <void*>_func_eval_chebys_l
ufunc_eval_chebys_ptr[2*0+1] = <void*>(<char*>"eval_chebys")
ufunc_eval_chebys_ptr[2*1] = <void*>_func_eval_chebys_l
ufunc_eval_chebys_ptr[2*1+1] = <void*>(<char*>"eval_chebys")
ufunc_eval_chebys_ptr[2*2] = <void*>_func_eval_chebys[double]
ufunc_eval_chebys_ptr[2*2+1] = <void*>(<char*>"eval_chebys")
ufunc_eval_chebys_ptr[2*3] = <void*>_func_eval_chebys[double_complex]
ufunc_eval_chebys_ptr[2*3+1] = <void*>(<char*>"eval_chebys")
ufunc_eval_chebys_ptr[2*4] = <void*>_func_eval_chebys[double]
ufunc_eval_chebys_ptr[2*4+1] = <void*>(<char*>"eval_chebys")
ufunc_eval_chebys_ptr[2*5] = <void*>_func_eval_chebys[double_complex]
ufunc_eval_chebys_ptr[2*5+1] = <void*>(<char*>"eval_chebys")
ufunc_eval_chebys_data[0] = &ufunc_eval_chebys_ptr[2*0]
ufunc_eval_chebys_data[1] = &ufunc_eval_chebys_ptr[2*1]
ufunc_eval_chebys_data[2] = &ufunc_eval_chebys_ptr[2*2]
ufunc_eval_chebys_data[3] = &ufunc_eval_chebys_ptr[2*3]
ufunc_eval_chebys_data[4] = &ufunc_eval_chebys_ptr[2*4]
ufunc_eval_chebys_data[5] = &ufunc_eval_chebys_ptr[2*5]
eval_chebys = np.PyUFunc_FromFuncAndData(ufunc_eval_chebys_loops, ufunc_eval_chebys_data, ufunc_eval_chebys_types, 6, 2, 1, 0, "eval_chebys", ufunc_eval_chebys_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_chebyt_loops[6]
cdef void *ufunc_eval_chebyt_ptr[12]
cdef void *ufunc_eval_chebyt_data[6]
cdef char ufunc_eval_chebyt_types[18]
cdef char *ufunc_eval_chebyt_doc = (
    "eval_chebyt(n, x, out=None)\n"
    "\n"
    "Evaluate Chebyshev T polynomial at a point.\n"
    "\n"
    "This routine is numerically stable for `x` in ``[-1, 1]`` at least\n"
    "up to order ``10000``.")
ufunc_eval_chebyt_loops[0] = <np.PyUFuncGenericFunction>loop_d_ld__As_lf_f
ufunc_eval_chebyt_loops[1] = <np.PyUFuncGenericFunction>loop_d_ld__As_ld_d
ufunc_eval_chebyt_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_eval_chebyt_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_eval_chebyt_loops[4] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_eval_chebyt_loops[5] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_eval_chebyt_types[0] = <char>NPY_LONG
ufunc_eval_chebyt_types[1] = <char>NPY_FLOAT
ufunc_eval_chebyt_types[2] = <char>NPY_FLOAT
ufunc_eval_chebyt_types[3] = <char>NPY_LONG
ufunc_eval_chebyt_types[4] = <char>NPY_DOUBLE
ufunc_eval_chebyt_types[5] = <char>NPY_DOUBLE
ufunc_eval_chebyt_types[6] = <char>NPY_FLOAT
ufunc_eval_chebyt_types[7] = <char>NPY_FLOAT
ufunc_eval_chebyt_types[8] = <char>NPY_FLOAT
ufunc_eval_chebyt_types[9] = <char>NPY_FLOAT
ufunc_eval_chebyt_types[10] = <char>NPY_CFLOAT
ufunc_eval_chebyt_types[11] = <char>NPY_CFLOAT
ufunc_eval_chebyt_types[12] = <char>NPY_DOUBLE
ufunc_eval_chebyt_types[13] = <char>NPY_DOUBLE
ufunc_eval_chebyt_types[14] = <char>NPY_DOUBLE
ufunc_eval_chebyt_types[15] = <char>NPY_DOUBLE
ufunc_eval_chebyt_types[16] = <char>NPY_CDOUBLE
ufunc_eval_chebyt_types[17] = <char>NPY_CDOUBLE
ufunc_eval_chebyt_ptr[2*0] = <void*>_func_eval_chebyt_l
ufunc_eval_chebyt_ptr[2*0+1] = <void*>(<char*>"eval_chebyt")
ufunc_eval_chebyt_ptr[2*1] = <void*>_func_eval_chebyt_l
ufunc_eval_chebyt_ptr[2*1+1] = <void*>(<char*>"eval_chebyt")
ufunc_eval_chebyt_ptr[2*2] = <void*>_func_eval_chebyt[double]
ufunc_eval_chebyt_ptr[2*2+1] = <void*>(<char*>"eval_chebyt")
ufunc_eval_chebyt_ptr[2*3] = <void*>_func_eval_chebyt[double_complex]
ufunc_eval_chebyt_ptr[2*3+1] = <void*>(<char*>"eval_chebyt")
ufunc_eval_chebyt_ptr[2*4] = <void*>_func_eval_chebyt[double]
ufunc_eval_chebyt_ptr[2*4+1] = <void*>(<char*>"eval_chebyt")
ufunc_eval_chebyt_ptr[2*5] = <void*>_func_eval_chebyt[double_complex]
ufunc_eval_chebyt_ptr[2*5+1] = <void*>(<char*>"eval_chebyt")
ufunc_eval_chebyt_data[0] = &ufunc_eval_chebyt_ptr[2*0]
ufunc_eval_chebyt_data[1] = &ufunc_eval_chebyt_ptr[2*1]
ufunc_eval_chebyt_data[2] = &ufunc_eval_chebyt_ptr[2*2]
ufunc_eval_chebyt_data[3] = &ufunc_eval_chebyt_ptr[2*3]
ufunc_eval_chebyt_data[4] = &ufunc_eval_chebyt_ptr[2*4]
ufunc_eval_chebyt_data[5] = &ufunc_eval_chebyt_ptr[2*5]
eval_chebyt = np.PyUFunc_FromFuncAndData(ufunc_eval_chebyt_loops, ufunc_eval_chebyt_data, ufunc_eval_chebyt_types, 6, 2, 1, 0, "eval_chebyt", ufunc_eval_chebyt_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_chebyu_loops[6]
cdef void *ufunc_eval_chebyu_ptr[12]
cdef void *ufunc_eval_chebyu_data[6]
cdef char ufunc_eval_chebyu_types[18]
cdef char *ufunc_eval_chebyu_doc = (
    "eval_chebyu(n, x, out=None)\n"
    "\n"
    "Evaluate Chebyshev U polynomial at a point.")
ufunc_eval_chebyu_loops[0] = <np.PyUFuncGenericFunction>loop_d_ld__As_lf_f
ufunc_eval_chebyu_loops[1] = <np.PyUFuncGenericFunction>loop_d_ld__As_ld_d
ufunc_eval_chebyu_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_eval_chebyu_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_eval_chebyu_loops[4] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_eval_chebyu_loops[5] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_eval_chebyu_types[0] = <char>NPY_LONG
ufunc_eval_chebyu_types[1] = <char>NPY_FLOAT
ufunc_eval_chebyu_types[2] = <char>NPY_FLOAT
ufunc_eval_chebyu_types[3] = <char>NPY_LONG
ufunc_eval_chebyu_types[4] = <char>NPY_DOUBLE
ufunc_eval_chebyu_types[5] = <char>NPY_DOUBLE
ufunc_eval_chebyu_types[6] = <char>NPY_FLOAT
ufunc_eval_chebyu_types[7] = <char>NPY_FLOAT
ufunc_eval_chebyu_types[8] = <char>NPY_FLOAT
ufunc_eval_chebyu_types[9] = <char>NPY_FLOAT
ufunc_eval_chebyu_types[10] = <char>NPY_CFLOAT
ufunc_eval_chebyu_types[11] = <char>NPY_CFLOAT
ufunc_eval_chebyu_types[12] = <char>NPY_DOUBLE
ufunc_eval_chebyu_types[13] = <char>NPY_DOUBLE
ufunc_eval_chebyu_types[14] = <char>NPY_DOUBLE
ufunc_eval_chebyu_types[15] = <char>NPY_DOUBLE
ufunc_eval_chebyu_types[16] = <char>NPY_CDOUBLE
ufunc_eval_chebyu_types[17] = <char>NPY_CDOUBLE
ufunc_eval_chebyu_ptr[2*0] = <void*>_func_eval_chebyu_l
ufunc_eval_chebyu_ptr[2*0+1] = <void*>(<char*>"eval_chebyu")
ufunc_eval_chebyu_ptr[2*1] = <void*>_func_eval_chebyu_l
ufunc_eval_chebyu_ptr[2*1+1] = <void*>(<char*>"eval_chebyu")
ufunc_eval_chebyu_ptr[2*2] = <void*>_func_eval_chebyu[double]
ufunc_eval_chebyu_ptr[2*2+1] = <void*>(<char*>"eval_chebyu")
ufunc_eval_chebyu_ptr[2*3] = <void*>_func_eval_chebyu[double_complex]
ufunc_eval_chebyu_ptr[2*3+1] = <void*>(<char*>"eval_chebyu")
ufunc_eval_chebyu_ptr[2*4] = <void*>_func_eval_chebyu[double]
ufunc_eval_chebyu_ptr[2*4+1] = <void*>(<char*>"eval_chebyu")
ufunc_eval_chebyu_ptr[2*5] = <void*>_func_eval_chebyu[double_complex]
ufunc_eval_chebyu_ptr[2*5+1] = <void*>(<char*>"eval_chebyu")
ufunc_eval_chebyu_data[0] = &ufunc_eval_chebyu_ptr[2*0]
ufunc_eval_chebyu_data[1] = &ufunc_eval_chebyu_ptr[2*1]
ufunc_eval_chebyu_data[2] = &ufunc_eval_chebyu_ptr[2*2]
ufunc_eval_chebyu_data[3] = &ufunc_eval_chebyu_ptr[2*3]
ufunc_eval_chebyu_data[4] = &ufunc_eval_chebyu_ptr[2*4]
ufunc_eval_chebyu_data[5] = &ufunc_eval_chebyu_ptr[2*5]
eval_chebyu = np.PyUFunc_FromFuncAndData(ufunc_eval_chebyu_loops, ufunc_eval_chebyu_data, ufunc_eval_chebyu_types, 6, 2, 1, 0, "eval_chebyu", ufunc_eval_chebyu_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_gegenbauer_loops[6]
cdef void *ufunc_eval_gegenbauer_ptr[12]
cdef void *ufunc_eval_gegenbauer_data[6]
cdef char ufunc_eval_gegenbauer_types[24]
cdef char *ufunc_eval_gegenbauer_doc = (
    "eval_gegenbauer(n, alpha, x, out=None)\n"
    "\n"
    "Evaluate Gegenbauer polynomial at a point.")
ufunc_eval_gegenbauer_loops[0] = <np.PyUFuncGenericFunction>loop_d_ldd__As_lff_f
ufunc_eval_gegenbauer_loops[1] = <np.PyUFuncGenericFunction>loop_d_ldd__As_ldd_d
ufunc_eval_gegenbauer_loops[2] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_eval_gegenbauer_loops[3] = <np.PyUFuncGenericFunction>loop_D_ddD__As_ffF_F
ufunc_eval_gegenbauer_loops[4] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_eval_gegenbauer_loops[5] = <np.PyUFuncGenericFunction>loop_D_ddD__As_ddD_D
ufunc_eval_gegenbauer_types[0] = <char>NPY_LONG
ufunc_eval_gegenbauer_types[1] = <char>NPY_FLOAT
ufunc_eval_gegenbauer_types[2] = <char>NPY_FLOAT
ufunc_eval_gegenbauer_types[3] = <char>NPY_FLOAT
ufunc_eval_gegenbauer_types[4] = <char>NPY_LONG
ufunc_eval_gegenbauer_types[5] = <char>NPY_DOUBLE
ufunc_eval_gegenbauer_types[6] = <char>NPY_DOUBLE
ufunc_eval_gegenbauer_types[7] = <char>NPY_DOUBLE
ufunc_eval_gegenbauer_types[8] = <char>NPY_FLOAT
ufunc_eval_gegenbauer_types[9] = <char>NPY_FLOAT
ufunc_eval_gegenbauer_types[10] = <char>NPY_FLOAT
ufunc_eval_gegenbauer_types[11] = <char>NPY_FLOAT
ufunc_eval_gegenbauer_types[12] = <char>NPY_FLOAT
ufunc_eval_gegenbauer_types[13] = <char>NPY_FLOAT
ufunc_eval_gegenbauer_types[14] = <char>NPY_CFLOAT
ufunc_eval_gegenbauer_types[15] = <char>NPY_CFLOAT
ufunc_eval_gegenbauer_types[16] = <char>NPY_DOUBLE
ufunc_eval_gegenbauer_types[17] = <char>NPY_DOUBLE
ufunc_eval_gegenbauer_types[18] = <char>NPY_DOUBLE
ufunc_eval_gegenbauer_types[19] = <char>NPY_DOUBLE
ufunc_eval_gegenbauer_types[20] = <char>NPY_DOUBLE
ufunc_eval_gegenbauer_types[21] = <char>NPY_DOUBLE
ufunc_eval_gegenbauer_types[22] = <char>NPY_CDOUBLE
ufunc_eval_gegenbauer_types[23] = <char>NPY_CDOUBLE
ufunc_eval_gegenbauer_ptr[2*0] = <void*>_func_eval_gegenbauer_l
ufunc_eval_gegenbauer_ptr[2*0+1] = <void*>(<char*>"eval_gegenbauer")
ufunc_eval_gegenbauer_ptr[2*1] = <void*>_func_eval_gegenbauer_l
ufunc_eval_gegenbauer_ptr[2*1+1] = <void*>(<char*>"eval_gegenbauer")
ufunc_eval_gegenbauer_ptr[2*2] = <void*>_func_eval_gegenbauer[double]
ufunc_eval_gegenbauer_ptr[2*2+1] = <void*>(<char*>"eval_gegenbauer")
ufunc_eval_gegenbauer_ptr[2*3] = <void*>_func_eval_gegenbauer[double_complex]
ufunc_eval_gegenbauer_ptr[2*3+1] = <void*>(<char*>"eval_gegenbauer")
ufunc_eval_gegenbauer_ptr[2*4] = <void*>_func_eval_gegenbauer[double]
ufunc_eval_gegenbauer_ptr[2*4+1] = <void*>(<char*>"eval_gegenbauer")
ufunc_eval_gegenbauer_ptr[2*5] = <void*>_func_eval_gegenbauer[double_complex]
ufunc_eval_gegenbauer_ptr[2*5+1] = <void*>(<char*>"eval_gegenbauer")
ufunc_eval_gegenbauer_data[0] = &ufunc_eval_gegenbauer_ptr[2*0]
ufunc_eval_gegenbauer_data[1] = &ufunc_eval_gegenbauer_ptr[2*1]
ufunc_eval_gegenbauer_data[2] = &ufunc_eval_gegenbauer_ptr[2*2]
ufunc_eval_gegenbauer_data[3] = &ufunc_eval_gegenbauer_ptr[2*3]
ufunc_eval_gegenbauer_data[4] = &ufunc_eval_gegenbauer_ptr[2*4]
ufunc_eval_gegenbauer_data[5] = &ufunc_eval_gegenbauer_ptr[2*5]
eval_gegenbauer = np.PyUFunc_FromFuncAndData(ufunc_eval_gegenbauer_loops, ufunc_eval_gegenbauer_data, ufunc_eval_gegenbauer_types, 6, 3, 1, 0, "eval_gegenbauer", ufunc_eval_gegenbauer_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_genlaguerre_loops[6]
cdef void *ufunc_eval_genlaguerre_ptr[12]
cdef void *ufunc_eval_genlaguerre_data[6]
cdef char ufunc_eval_genlaguerre_types[24]
cdef char *ufunc_eval_genlaguerre_doc = (
    "eval_genlaguerre(n, alpha, x, out=None)\n"
    "\n"
    "Evaluate generalized Laguerre polynomial at a point.")
ufunc_eval_genlaguerre_loops[0] = <np.PyUFuncGenericFunction>loop_d_ldd__As_lff_f
ufunc_eval_genlaguerre_loops[1] = <np.PyUFuncGenericFunction>loop_d_ldd__As_ldd_d
ufunc_eval_genlaguerre_loops[2] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_eval_genlaguerre_loops[3] = <np.PyUFuncGenericFunction>loop_D_ddD__As_ffF_F
ufunc_eval_genlaguerre_loops[4] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_eval_genlaguerre_loops[5] = <np.PyUFuncGenericFunction>loop_D_ddD__As_ddD_D
ufunc_eval_genlaguerre_types[0] = <char>NPY_LONG
ufunc_eval_genlaguerre_types[1] = <char>NPY_FLOAT
ufunc_eval_genlaguerre_types[2] = <char>NPY_FLOAT
ufunc_eval_genlaguerre_types[3] = <char>NPY_FLOAT
ufunc_eval_genlaguerre_types[4] = <char>NPY_LONG
ufunc_eval_genlaguerre_types[5] = <char>NPY_DOUBLE
ufunc_eval_genlaguerre_types[6] = <char>NPY_DOUBLE
ufunc_eval_genlaguerre_types[7] = <char>NPY_DOUBLE
ufunc_eval_genlaguerre_types[8] = <char>NPY_FLOAT
ufunc_eval_genlaguerre_types[9] = <char>NPY_FLOAT
ufunc_eval_genlaguerre_types[10] = <char>NPY_FLOAT
ufunc_eval_genlaguerre_types[11] = <char>NPY_FLOAT
ufunc_eval_genlaguerre_types[12] = <char>NPY_FLOAT
ufunc_eval_genlaguerre_types[13] = <char>NPY_FLOAT
ufunc_eval_genlaguerre_types[14] = <char>NPY_CFLOAT
ufunc_eval_genlaguerre_types[15] = <char>NPY_CFLOAT
ufunc_eval_genlaguerre_types[16] = <char>NPY_DOUBLE
ufunc_eval_genlaguerre_types[17] = <char>NPY_DOUBLE
ufunc_eval_genlaguerre_types[18] = <char>NPY_DOUBLE
ufunc_eval_genlaguerre_types[19] = <char>NPY_DOUBLE
ufunc_eval_genlaguerre_types[20] = <char>NPY_DOUBLE
ufunc_eval_genlaguerre_types[21] = <char>NPY_DOUBLE
ufunc_eval_genlaguerre_types[22] = <char>NPY_CDOUBLE
ufunc_eval_genlaguerre_types[23] = <char>NPY_CDOUBLE
ufunc_eval_genlaguerre_ptr[2*0] = <void*>_func_eval_genlaguerre_l
ufunc_eval_genlaguerre_ptr[2*0+1] = <void*>(<char*>"eval_genlaguerre")
ufunc_eval_genlaguerre_ptr[2*1] = <void*>_func_eval_genlaguerre_l
ufunc_eval_genlaguerre_ptr[2*1+1] = <void*>(<char*>"eval_genlaguerre")
ufunc_eval_genlaguerre_ptr[2*2] = <void*>_func_eval_genlaguerre[double]
ufunc_eval_genlaguerre_ptr[2*2+1] = <void*>(<char*>"eval_genlaguerre")
ufunc_eval_genlaguerre_ptr[2*3] = <void*>_func_eval_genlaguerre[double_complex]
ufunc_eval_genlaguerre_ptr[2*3+1] = <void*>(<char*>"eval_genlaguerre")
ufunc_eval_genlaguerre_ptr[2*4] = <void*>_func_eval_genlaguerre[double]
ufunc_eval_genlaguerre_ptr[2*4+1] = <void*>(<char*>"eval_genlaguerre")
ufunc_eval_genlaguerre_ptr[2*5] = <void*>_func_eval_genlaguerre[double_complex]
ufunc_eval_genlaguerre_ptr[2*5+1] = <void*>(<char*>"eval_genlaguerre")
ufunc_eval_genlaguerre_data[0] = &ufunc_eval_genlaguerre_ptr[2*0]
ufunc_eval_genlaguerre_data[1] = &ufunc_eval_genlaguerre_ptr[2*1]
ufunc_eval_genlaguerre_data[2] = &ufunc_eval_genlaguerre_ptr[2*2]
ufunc_eval_genlaguerre_data[3] = &ufunc_eval_genlaguerre_ptr[2*3]
ufunc_eval_genlaguerre_data[4] = &ufunc_eval_genlaguerre_ptr[2*4]
ufunc_eval_genlaguerre_data[5] = &ufunc_eval_genlaguerre_ptr[2*5]
eval_genlaguerre = np.PyUFunc_FromFuncAndData(ufunc_eval_genlaguerre_loops, ufunc_eval_genlaguerre_data, ufunc_eval_genlaguerre_types, 6, 3, 1, 0, "eval_genlaguerre", ufunc_eval_genlaguerre_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_hermite_loops[2]
cdef void *ufunc_eval_hermite_ptr[4]
cdef void *ufunc_eval_hermite_data[2]
cdef char ufunc_eval_hermite_types[6]
cdef char *ufunc_eval_hermite_doc = (
    "eval_hermite(n, x, out=None)\n"
    "\n"
    "Evaluate Hermite polynomial at a point.")
ufunc_eval_hermite_loops[0] = <np.PyUFuncGenericFunction>loop_d_ld__As_lf_f
ufunc_eval_hermite_loops[1] = <np.PyUFuncGenericFunction>loop_d_ld__As_ld_d
ufunc_eval_hermite_types[0] = <char>NPY_LONG
ufunc_eval_hermite_types[1] = <char>NPY_FLOAT
ufunc_eval_hermite_types[2] = <char>NPY_FLOAT
ufunc_eval_hermite_types[3] = <char>NPY_LONG
ufunc_eval_hermite_types[4] = <char>NPY_DOUBLE
ufunc_eval_hermite_types[5] = <char>NPY_DOUBLE
ufunc_eval_hermite_ptr[2*0] = <void*>_func_eval_hermite
ufunc_eval_hermite_ptr[2*0+1] = <void*>(<char*>"eval_hermite")
ufunc_eval_hermite_ptr[2*1] = <void*>_func_eval_hermite
ufunc_eval_hermite_ptr[2*1+1] = <void*>(<char*>"eval_hermite")
ufunc_eval_hermite_data[0] = &ufunc_eval_hermite_ptr[2*0]
ufunc_eval_hermite_data[1] = &ufunc_eval_hermite_ptr[2*1]
eval_hermite = np.PyUFunc_FromFuncAndData(ufunc_eval_hermite_loops, ufunc_eval_hermite_data, ufunc_eval_hermite_types, 2, 2, 1, 0, "eval_hermite", ufunc_eval_hermite_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_hermitenorm_loops[2]
cdef void *ufunc_eval_hermitenorm_ptr[4]
cdef void *ufunc_eval_hermitenorm_data[2]
cdef char ufunc_eval_hermitenorm_types[6]
cdef char *ufunc_eval_hermitenorm_doc = (
    "eval_hermitenorm(n, x, out=None)\n"
    "\n"
    "Evaluate normalized Hermite polynomial at a point.")
ufunc_eval_hermitenorm_loops[0] = <np.PyUFuncGenericFunction>loop_d_ld__As_lf_f
ufunc_eval_hermitenorm_loops[1] = <np.PyUFuncGenericFunction>loop_d_ld__As_ld_d
ufunc_eval_hermitenorm_types[0] = <char>NPY_LONG
ufunc_eval_hermitenorm_types[1] = <char>NPY_FLOAT
ufunc_eval_hermitenorm_types[2] = <char>NPY_FLOAT
ufunc_eval_hermitenorm_types[3] = <char>NPY_LONG
ufunc_eval_hermitenorm_types[4] = <char>NPY_DOUBLE
ufunc_eval_hermitenorm_types[5] = <char>NPY_DOUBLE
ufunc_eval_hermitenorm_ptr[2*0] = <void*>_func_eval_hermitenorm
ufunc_eval_hermitenorm_ptr[2*0+1] = <void*>(<char*>"eval_hermitenorm")
ufunc_eval_hermitenorm_ptr[2*1] = <void*>_func_eval_hermitenorm
ufunc_eval_hermitenorm_ptr[2*1+1] = <void*>(<char*>"eval_hermitenorm")
ufunc_eval_hermitenorm_data[0] = &ufunc_eval_hermitenorm_ptr[2*0]
ufunc_eval_hermitenorm_data[1] = &ufunc_eval_hermitenorm_ptr[2*1]
eval_hermitenorm = np.PyUFunc_FromFuncAndData(ufunc_eval_hermitenorm_loops, ufunc_eval_hermitenorm_data, ufunc_eval_hermitenorm_types, 2, 2, 1, 0, "eval_hermitenorm", ufunc_eval_hermitenorm_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_jacobi_loops[6]
cdef void *ufunc_eval_jacobi_ptr[12]
cdef void *ufunc_eval_jacobi_data[6]
cdef char ufunc_eval_jacobi_types[30]
cdef char *ufunc_eval_jacobi_doc = (
    "eval_jacobi(n, alpha, beta, x, out=None)\n"
    "\n"
    "Evaluate Jacobi polynomial at a point.")
ufunc_eval_jacobi_loops[0] = <np.PyUFuncGenericFunction>loop_d_lddd__As_lfff_f
ufunc_eval_jacobi_loops[1] = <np.PyUFuncGenericFunction>loop_d_lddd__As_lddd_d
ufunc_eval_jacobi_loops[2] = <np.PyUFuncGenericFunction>loop_d_dddd__As_ffff_f
ufunc_eval_jacobi_loops[3] = <np.PyUFuncGenericFunction>loop_D_dddD__As_fffF_F
ufunc_eval_jacobi_loops[4] = <np.PyUFuncGenericFunction>loop_d_dddd__As_dddd_d
ufunc_eval_jacobi_loops[5] = <np.PyUFuncGenericFunction>loop_D_dddD__As_dddD_D
ufunc_eval_jacobi_types[0] = <char>NPY_LONG
ufunc_eval_jacobi_types[1] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[2] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[3] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[4] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[5] = <char>NPY_LONG
ufunc_eval_jacobi_types[6] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[7] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[8] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[9] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[10] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[11] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[12] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[13] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[14] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[15] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[16] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[17] = <char>NPY_FLOAT
ufunc_eval_jacobi_types[18] = <char>NPY_CFLOAT
ufunc_eval_jacobi_types[19] = <char>NPY_CFLOAT
ufunc_eval_jacobi_types[20] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[21] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[22] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[23] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[24] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[25] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[26] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[27] = <char>NPY_DOUBLE
ufunc_eval_jacobi_types[28] = <char>NPY_CDOUBLE
ufunc_eval_jacobi_types[29] = <char>NPY_CDOUBLE
ufunc_eval_jacobi_ptr[2*0] = <void*>_func_eval_jacobi_l
ufunc_eval_jacobi_ptr[2*0+1] = <void*>(<char*>"eval_jacobi")
ufunc_eval_jacobi_ptr[2*1] = <void*>_func_eval_jacobi_l
ufunc_eval_jacobi_ptr[2*1+1] = <void*>(<char*>"eval_jacobi")
ufunc_eval_jacobi_ptr[2*2] = <void*>_func_eval_jacobi[double]
ufunc_eval_jacobi_ptr[2*2+1] = <void*>(<char*>"eval_jacobi")
ufunc_eval_jacobi_ptr[2*3] = <void*>_func_eval_jacobi[double_complex]
ufunc_eval_jacobi_ptr[2*3+1] = <void*>(<char*>"eval_jacobi")
ufunc_eval_jacobi_ptr[2*4] = <void*>_func_eval_jacobi[double]
ufunc_eval_jacobi_ptr[2*4+1] = <void*>(<char*>"eval_jacobi")
ufunc_eval_jacobi_ptr[2*5] = <void*>_func_eval_jacobi[double_complex]
ufunc_eval_jacobi_ptr[2*5+1] = <void*>(<char*>"eval_jacobi")
ufunc_eval_jacobi_data[0] = &ufunc_eval_jacobi_ptr[2*0]
ufunc_eval_jacobi_data[1] = &ufunc_eval_jacobi_ptr[2*1]
ufunc_eval_jacobi_data[2] = &ufunc_eval_jacobi_ptr[2*2]
ufunc_eval_jacobi_data[3] = &ufunc_eval_jacobi_ptr[2*3]
ufunc_eval_jacobi_data[4] = &ufunc_eval_jacobi_ptr[2*4]
ufunc_eval_jacobi_data[5] = &ufunc_eval_jacobi_ptr[2*5]
eval_jacobi = np.PyUFunc_FromFuncAndData(ufunc_eval_jacobi_loops, ufunc_eval_jacobi_data, ufunc_eval_jacobi_types, 6, 4, 1, 0, "eval_jacobi", ufunc_eval_jacobi_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_laguerre_loops[6]
cdef void *ufunc_eval_laguerre_ptr[12]
cdef void *ufunc_eval_laguerre_data[6]
cdef char ufunc_eval_laguerre_types[18]
cdef char *ufunc_eval_laguerre_doc = (
    "eval_laguerre(n, x, out=None)\n"
    "\n"
    "Evaluate Laguerre polynomial at a point.")
ufunc_eval_laguerre_loops[0] = <np.PyUFuncGenericFunction>loop_d_ld__As_lf_f
ufunc_eval_laguerre_loops[1] = <np.PyUFuncGenericFunction>loop_d_ld__As_ld_d
ufunc_eval_laguerre_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_eval_laguerre_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_eval_laguerre_loops[4] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_eval_laguerre_loops[5] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_eval_laguerre_types[0] = <char>NPY_LONG
ufunc_eval_laguerre_types[1] = <char>NPY_FLOAT
ufunc_eval_laguerre_types[2] = <char>NPY_FLOAT
ufunc_eval_laguerre_types[3] = <char>NPY_LONG
ufunc_eval_laguerre_types[4] = <char>NPY_DOUBLE
ufunc_eval_laguerre_types[5] = <char>NPY_DOUBLE
ufunc_eval_laguerre_types[6] = <char>NPY_FLOAT
ufunc_eval_laguerre_types[7] = <char>NPY_FLOAT
ufunc_eval_laguerre_types[8] = <char>NPY_FLOAT
ufunc_eval_laguerre_types[9] = <char>NPY_FLOAT
ufunc_eval_laguerre_types[10] = <char>NPY_CFLOAT
ufunc_eval_laguerre_types[11] = <char>NPY_CFLOAT
ufunc_eval_laguerre_types[12] = <char>NPY_DOUBLE
ufunc_eval_laguerre_types[13] = <char>NPY_DOUBLE
ufunc_eval_laguerre_types[14] = <char>NPY_DOUBLE
ufunc_eval_laguerre_types[15] = <char>NPY_DOUBLE
ufunc_eval_laguerre_types[16] = <char>NPY_CDOUBLE
ufunc_eval_laguerre_types[17] = <char>NPY_CDOUBLE
ufunc_eval_laguerre_ptr[2*0] = <void*>_func_eval_laguerre_l
ufunc_eval_laguerre_ptr[2*0+1] = <void*>(<char*>"eval_laguerre")
ufunc_eval_laguerre_ptr[2*1] = <void*>_func_eval_laguerre_l
ufunc_eval_laguerre_ptr[2*1+1] = <void*>(<char*>"eval_laguerre")
ufunc_eval_laguerre_ptr[2*2] = <void*>_func_eval_laguerre[double]
ufunc_eval_laguerre_ptr[2*2+1] = <void*>(<char*>"eval_laguerre")
ufunc_eval_laguerre_ptr[2*3] = <void*>_func_eval_laguerre[double_complex]
ufunc_eval_laguerre_ptr[2*3+1] = <void*>(<char*>"eval_laguerre")
ufunc_eval_laguerre_ptr[2*4] = <void*>_func_eval_laguerre[double]
ufunc_eval_laguerre_ptr[2*4+1] = <void*>(<char*>"eval_laguerre")
ufunc_eval_laguerre_ptr[2*5] = <void*>_func_eval_laguerre[double_complex]
ufunc_eval_laguerre_ptr[2*5+1] = <void*>(<char*>"eval_laguerre")
ufunc_eval_laguerre_data[0] = &ufunc_eval_laguerre_ptr[2*0]
ufunc_eval_laguerre_data[1] = &ufunc_eval_laguerre_ptr[2*1]
ufunc_eval_laguerre_data[2] = &ufunc_eval_laguerre_ptr[2*2]
ufunc_eval_laguerre_data[3] = &ufunc_eval_laguerre_ptr[2*3]
ufunc_eval_laguerre_data[4] = &ufunc_eval_laguerre_ptr[2*4]
ufunc_eval_laguerre_data[5] = &ufunc_eval_laguerre_ptr[2*5]
eval_laguerre = np.PyUFunc_FromFuncAndData(ufunc_eval_laguerre_loops, ufunc_eval_laguerre_data, ufunc_eval_laguerre_types, 6, 2, 1, 0, "eval_laguerre", ufunc_eval_laguerre_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_legendre_loops[6]
cdef void *ufunc_eval_legendre_ptr[12]
cdef void *ufunc_eval_legendre_data[6]
cdef char ufunc_eval_legendre_types[18]
cdef char *ufunc_eval_legendre_doc = (
    "eval_legendre(n, x, out=None)\n"
    "\n"
    "Evaluate Legendre polynomial at a point.")
ufunc_eval_legendre_loops[0] = <np.PyUFuncGenericFunction>loop_d_ld__As_lf_f
ufunc_eval_legendre_loops[1] = <np.PyUFuncGenericFunction>loop_d_ld__As_ld_d
ufunc_eval_legendre_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_eval_legendre_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_eval_legendre_loops[4] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_eval_legendre_loops[5] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_eval_legendre_types[0] = <char>NPY_LONG
ufunc_eval_legendre_types[1] = <char>NPY_FLOAT
ufunc_eval_legendre_types[2] = <char>NPY_FLOAT
ufunc_eval_legendre_types[3] = <char>NPY_LONG
ufunc_eval_legendre_types[4] = <char>NPY_DOUBLE
ufunc_eval_legendre_types[5] = <char>NPY_DOUBLE
ufunc_eval_legendre_types[6] = <char>NPY_FLOAT
ufunc_eval_legendre_types[7] = <char>NPY_FLOAT
ufunc_eval_legendre_types[8] = <char>NPY_FLOAT
ufunc_eval_legendre_types[9] = <char>NPY_FLOAT
ufunc_eval_legendre_types[10] = <char>NPY_CFLOAT
ufunc_eval_legendre_types[11] = <char>NPY_CFLOAT
ufunc_eval_legendre_types[12] = <char>NPY_DOUBLE
ufunc_eval_legendre_types[13] = <char>NPY_DOUBLE
ufunc_eval_legendre_types[14] = <char>NPY_DOUBLE
ufunc_eval_legendre_types[15] = <char>NPY_DOUBLE
ufunc_eval_legendre_types[16] = <char>NPY_CDOUBLE
ufunc_eval_legendre_types[17] = <char>NPY_CDOUBLE
ufunc_eval_legendre_ptr[2*0] = <void*>_func_eval_legendre_l
ufunc_eval_legendre_ptr[2*0+1] = <void*>(<char*>"eval_legendre")
ufunc_eval_legendre_ptr[2*1] = <void*>_func_eval_legendre_l
ufunc_eval_legendre_ptr[2*1+1] = <void*>(<char*>"eval_legendre")
ufunc_eval_legendre_ptr[2*2] = <void*>_func_eval_legendre[double]
ufunc_eval_legendre_ptr[2*2+1] = <void*>(<char*>"eval_legendre")
ufunc_eval_legendre_ptr[2*3] = <void*>_func_eval_legendre[double_complex]
ufunc_eval_legendre_ptr[2*3+1] = <void*>(<char*>"eval_legendre")
ufunc_eval_legendre_ptr[2*4] = <void*>_func_eval_legendre[double]
ufunc_eval_legendre_ptr[2*4+1] = <void*>(<char*>"eval_legendre")
ufunc_eval_legendre_ptr[2*5] = <void*>_func_eval_legendre[double_complex]
ufunc_eval_legendre_ptr[2*5+1] = <void*>(<char*>"eval_legendre")
ufunc_eval_legendre_data[0] = &ufunc_eval_legendre_ptr[2*0]
ufunc_eval_legendre_data[1] = &ufunc_eval_legendre_ptr[2*1]
ufunc_eval_legendre_data[2] = &ufunc_eval_legendre_ptr[2*2]
ufunc_eval_legendre_data[3] = &ufunc_eval_legendre_ptr[2*3]
ufunc_eval_legendre_data[4] = &ufunc_eval_legendre_ptr[2*4]
ufunc_eval_legendre_data[5] = &ufunc_eval_legendre_ptr[2*5]
eval_legendre = np.PyUFunc_FromFuncAndData(ufunc_eval_legendre_loops, ufunc_eval_legendre_data, ufunc_eval_legendre_types, 6, 2, 1, 0, "eval_legendre", ufunc_eval_legendre_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_sh_chebyt_loops[6]
cdef void *ufunc_eval_sh_chebyt_ptr[12]
cdef void *ufunc_eval_sh_chebyt_data[6]
cdef char ufunc_eval_sh_chebyt_types[18]
cdef char *ufunc_eval_sh_chebyt_doc = (
    "eval_sh_chebyt(n, x, out=None)\n"
    "\n"
    "Evaluate shifted Chebyshev T polynomial at a point.")
ufunc_eval_sh_chebyt_loops[0] = <np.PyUFuncGenericFunction>loop_d_ld__As_lf_f
ufunc_eval_sh_chebyt_loops[1] = <np.PyUFuncGenericFunction>loop_d_ld__As_ld_d
ufunc_eval_sh_chebyt_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_eval_sh_chebyt_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_eval_sh_chebyt_loops[4] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_eval_sh_chebyt_loops[5] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_eval_sh_chebyt_types[0] = <char>NPY_LONG
ufunc_eval_sh_chebyt_types[1] = <char>NPY_FLOAT
ufunc_eval_sh_chebyt_types[2] = <char>NPY_FLOAT
ufunc_eval_sh_chebyt_types[3] = <char>NPY_LONG
ufunc_eval_sh_chebyt_types[4] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyt_types[5] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyt_types[6] = <char>NPY_FLOAT
ufunc_eval_sh_chebyt_types[7] = <char>NPY_FLOAT
ufunc_eval_sh_chebyt_types[8] = <char>NPY_FLOAT
ufunc_eval_sh_chebyt_types[9] = <char>NPY_FLOAT
ufunc_eval_sh_chebyt_types[10] = <char>NPY_CFLOAT
ufunc_eval_sh_chebyt_types[11] = <char>NPY_CFLOAT
ufunc_eval_sh_chebyt_types[12] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyt_types[13] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyt_types[14] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyt_types[15] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyt_types[16] = <char>NPY_CDOUBLE
ufunc_eval_sh_chebyt_types[17] = <char>NPY_CDOUBLE
ufunc_eval_sh_chebyt_ptr[2*0] = <void*>_func_eval_sh_chebyt_l
ufunc_eval_sh_chebyt_ptr[2*0+1] = <void*>(<char*>"eval_sh_chebyt")
ufunc_eval_sh_chebyt_ptr[2*1] = <void*>_func_eval_sh_chebyt_l
ufunc_eval_sh_chebyt_ptr[2*1+1] = <void*>(<char*>"eval_sh_chebyt")
ufunc_eval_sh_chebyt_ptr[2*2] = <void*>_func_eval_sh_chebyt[double]
ufunc_eval_sh_chebyt_ptr[2*2+1] = <void*>(<char*>"eval_sh_chebyt")
ufunc_eval_sh_chebyt_ptr[2*3] = <void*>_func_eval_sh_chebyt[double_complex]
ufunc_eval_sh_chebyt_ptr[2*3+1] = <void*>(<char*>"eval_sh_chebyt")
ufunc_eval_sh_chebyt_ptr[2*4] = <void*>_func_eval_sh_chebyt[double]
ufunc_eval_sh_chebyt_ptr[2*4+1] = <void*>(<char*>"eval_sh_chebyt")
ufunc_eval_sh_chebyt_ptr[2*5] = <void*>_func_eval_sh_chebyt[double_complex]
ufunc_eval_sh_chebyt_ptr[2*5+1] = <void*>(<char*>"eval_sh_chebyt")
ufunc_eval_sh_chebyt_data[0] = &ufunc_eval_sh_chebyt_ptr[2*0]
ufunc_eval_sh_chebyt_data[1] = &ufunc_eval_sh_chebyt_ptr[2*1]
ufunc_eval_sh_chebyt_data[2] = &ufunc_eval_sh_chebyt_ptr[2*2]
ufunc_eval_sh_chebyt_data[3] = &ufunc_eval_sh_chebyt_ptr[2*3]
ufunc_eval_sh_chebyt_data[4] = &ufunc_eval_sh_chebyt_ptr[2*4]
ufunc_eval_sh_chebyt_data[5] = &ufunc_eval_sh_chebyt_ptr[2*5]
eval_sh_chebyt = np.PyUFunc_FromFuncAndData(ufunc_eval_sh_chebyt_loops, ufunc_eval_sh_chebyt_data, ufunc_eval_sh_chebyt_types, 6, 2, 1, 0, "eval_sh_chebyt", ufunc_eval_sh_chebyt_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_sh_chebyu_loops[6]
cdef void *ufunc_eval_sh_chebyu_ptr[12]
cdef void *ufunc_eval_sh_chebyu_data[6]
cdef char ufunc_eval_sh_chebyu_types[18]
cdef char *ufunc_eval_sh_chebyu_doc = (
    "eval_sh_chebyu(n, x, out=None)\n"
    "\n"
    "Evaluate shifted Chebyshev U polynomial at a point.")
ufunc_eval_sh_chebyu_loops[0] = <np.PyUFuncGenericFunction>loop_d_ld__As_lf_f
ufunc_eval_sh_chebyu_loops[1] = <np.PyUFuncGenericFunction>loop_d_ld__As_ld_d
ufunc_eval_sh_chebyu_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_eval_sh_chebyu_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_eval_sh_chebyu_loops[4] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_eval_sh_chebyu_loops[5] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_eval_sh_chebyu_types[0] = <char>NPY_LONG
ufunc_eval_sh_chebyu_types[1] = <char>NPY_FLOAT
ufunc_eval_sh_chebyu_types[2] = <char>NPY_FLOAT
ufunc_eval_sh_chebyu_types[3] = <char>NPY_LONG
ufunc_eval_sh_chebyu_types[4] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyu_types[5] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyu_types[6] = <char>NPY_FLOAT
ufunc_eval_sh_chebyu_types[7] = <char>NPY_FLOAT
ufunc_eval_sh_chebyu_types[8] = <char>NPY_FLOAT
ufunc_eval_sh_chebyu_types[9] = <char>NPY_FLOAT
ufunc_eval_sh_chebyu_types[10] = <char>NPY_CFLOAT
ufunc_eval_sh_chebyu_types[11] = <char>NPY_CFLOAT
ufunc_eval_sh_chebyu_types[12] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyu_types[13] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyu_types[14] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyu_types[15] = <char>NPY_DOUBLE
ufunc_eval_sh_chebyu_types[16] = <char>NPY_CDOUBLE
ufunc_eval_sh_chebyu_types[17] = <char>NPY_CDOUBLE
ufunc_eval_sh_chebyu_ptr[2*0] = <void*>_func_eval_sh_chebyu_l
ufunc_eval_sh_chebyu_ptr[2*0+1] = <void*>(<char*>"eval_sh_chebyu")
ufunc_eval_sh_chebyu_ptr[2*1] = <void*>_func_eval_sh_chebyu_l
ufunc_eval_sh_chebyu_ptr[2*1+1] = <void*>(<char*>"eval_sh_chebyu")
ufunc_eval_sh_chebyu_ptr[2*2] = <void*>_func_eval_sh_chebyu[double]
ufunc_eval_sh_chebyu_ptr[2*2+1] = <void*>(<char*>"eval_sh_chebyu")
ufunc_eval_sh_chebyu_ptr[2*3] = <void*>_func_eval_sh_chebyu[double_complex]
ufunc_eval_sh_chebyu_ptr[2*3+1] = <void*>(<char*>"eval_sh_chebyu")
ufunc_eval_sh_chebyu_ptr[2*4] = <void*>_func_eval_sh_chebyu[double]
ufunc_eval_sh_chebyu_ptr[2*4+1] = <void*>(<char*>"eval_sh_chebyu")
ufunc_eval_sh_chebyu_ptr[2*5] = <void*>_func_eval_sh_chebyu[double_complex]
ufunc_eval_sh_chebyu_ptr[2*5+1] = <void*>(<char*>"eval_sh_chebyu")
ufunc_eval_sh_chebyu_data[0] = &ufunc_eval_sh_chebyu_ptr[2*0]
ufunc_eval_sh_chebyu_data[1] = &ufunc_eval_sh_chebyu_ptr[2*1]
ufunc_eval_sh_chebyu_data[2] = &ufunc_eval_sh_chebyu_ptr[2*2]
ufunc_eval_sh_chebyu_data[3] = &ufunc_eval_sh_chebyu_ptr[2*3]
ufunc_eval_sh_chebyu_data[4] = &ufunc_eval_sh_chebyu_ptr[2*4]
ufunc_eval_sh_chebyu_data[5] = &ufunc_eval_sh_chebyu_ptr[2*5]
eval_sh_chebyu = np.PyUFunc_FromFuncAndData(ufunc_eval_sh_chebyu_loops, ufunc_eval_sh_chebyu_data, ufunc_eval_sh_chebyu_types, 6, 2, 1, 0, "eval_sh_chebyu", ufunc_eval_sh_chebyu_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_sh_jacobi_loops[6]
cdef void *ufunc_eval_sh_jacobi_ptr[12]
cdef void *ufunc_eval_sh_jacobi_data[6]
cdef char ufunc_eval_sh_jacobi_types[30]
cdef char *ufunc_eval_sh_jacobi_doc = (
    "eval_sh_jacobi(n, p, q, x, out=None)\n"
    "\n"
    "Evaluate shifted Jacobi polynomial at a point.")
ufunc_eval_sh_jacobi_loops[0] = <np.PyUFuncGenericFunction>loop_d_lddd__As_lfff_f
ufunc_eval_sh_jacobi_loops[1] = <np.PyUFuncGenericFunction>loop_d_lddd__As_lddd_d
ufunc_eval_sh_jacobi_loops[2] = <np.PyUFuncGenericFunction>loop_d_dddd__As_ffff_f
ufunc_eval_sh_jacobi_loops[3] = <np.PyUFuncGenericFunction>loop_D_dddD__As_fffF_F
ufunc_eval_sh_jacobi_loops[4] = <np.PyUFuncGenericFunction>loop_d_dddd__As_dddd_d
ufunc_eval_sh_jacobi_loops[5] = <np.PyUFuncGenericFunction>loop_D_dddD__As_dddD_D
ufunc_eval_sh_jacobi_types[0] = <char>NPY_LONG
ufunc_eval_sh_jacobi_types[1] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[2] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[3] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[4] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[5] = <char>NPY_LONG
ufunc_eval_sh_jacobi_types[6] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[7] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[8] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[9] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[10] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[11] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[12] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[13] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[14] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[15] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[16] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[17] = <char>NPY_FLOAT
ufunc_eval_sh_jacobi_types[18] = <char>NPY_CFLOAT
ufunc_eval_sh_jacobi_types[19] = <char>NPY_CFLOAT
ufunc_eval_sh_jacobi_types[20] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[21] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[22] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[23] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[24] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[25] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[26] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[27] = <char>NPY_DOUBLE
ufunc_eval_sh_jacobi_types[28] = <char>NPY_CDOUBLE
ufunc_eval_sh_jacobi_types[29] = <char>NPY_CDOUBLE
ufunc_eval_sh_jacobi_ptr[2*0] = <void*>_func_eval_sh_jacobi_l
ufunc_eval_sh_jacobi_ptr[2*0+1] = <void*>(<char*>"eval_sh_jacobi")
ufunc_eval_sh_jacobi_ptr[2*1] = <void*>_func_eval_sh_jacobi_l
ufunc_eval_sh_jacobi_ptr[2*1+1] = <void*>(<char*>"eval_sh_jacobi")
ufunc_eval_sh_jacobi_ptr[2*2] = <void*>_func_eval_sh_jacobi[double]
ufunc_eval_sh_jacobi_ptr[2*2+1] = <void*>(<char*>"eval_sh_jacobi")
ufunc_eval_sh_jacobi_ptr[2*3] = <void*>_func_eval_sh_jacobi[double_complex]
ufunc_eval_sh_jacobi_ptr[2*3+1] = <void*>(<char*>"eval_sh_jacobi")
ufunc_eval_sh_jacobi_ptr[2*4] = <void*>_func_eval_sh_jacobi[double]
ufunc_eval_sh_jacobi_ptr[2*4+1] = <void*>(<char*>"eval_sh_jacobi")
ufunc_eval_sh_jacobi_ptr[2*5] = <void*>_func_eval_sh_jacobi[double_complex]
ufunc_eval_sh_jacobi_ptr[2*5+1] = <void*>(<char*>"eval_sh_jacobi")
ufunc_eval_sh_jacobi_data[0] = &ufunc_eval_sh_jacobi_ptr[2*0]
ufunc_eval_sh_jacobi_data[1] = &ufunc_eval_sh_jacobi_ptr[2*1]
ufunc_eval_sh_jacobi_data[2] = &ufunc_eval_sh_jacobi_ptr[2*2]
ufunc_eval_sh_jacobi_data[3] = &ufunc_eval_sh_jacobi_ptr[2*3]
ufunc_eval_sh_jacobi_data[4] = &ufunc_eval_sh_jacobi_ptr[2*4]
ufunc_eval_sh_jacobi_data[5] = &ufunc_eval_sh_jacobi_ptr[2*5]
eval_sh_jacobi = np.PyUFunc_FromFuncAndData(ufunc_eval_sh_jacobi_loops, ufunc_eval_sh_jacobi_data, ufunc_eval_sh_jacobi_types, 6, 4, 1, 0, "eval_sh_jacobi", ufunc_eval_sh_jacobi_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_eval_sh_legendre_loops[6]
cdef void *ufunc_eval_sh_legendre_ptr[12]
cdef void *ufunc_eval_sh_legendre_data[6]
cdef char ufunc_eval_sh_legendre_types[18]
cdef char *ufunc_eval_sh_legendre_doc = (
    "eval_sh_legendre(n, x, out=None)\n"
    "\n"
    "Evaluate shifted Legendre polynomial at a point.")
ufunc_eval_sh_legendre_loops[0] = <np.PyUFuncGenericFunction>loop_d_ld__As_lf_f
ufunc_eval_sh_legendre_loops[1] = <np.PyUFuncGenericFunction>loop_d_ld__As_ld_d
ufunc_eval_sh_legendre_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_eval_sh_legendre_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_eval_sh_legendre_loops[4] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_eval_sh_legendre_loops[5] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_eval_sh_legendre_types[0] = <char>NPY_LONG
ufunc_eval_sh_legendre_types[1] = <char>NPY_FLOAT
ufunc_eval_sh_legendre_types[2] = <char>NPY_FLOAT
ufunc_eval_sh_legendre_types[3] = <char>NPY_LONG
ufunc_eval_sh_legendre_types[4] = <char>NPY_DOUBLE
ufunc_eval_sh_legendre_types[5] = <char>NPY_DOUBLE
ufunc_eval_sh_legendre_types[6] = <char>NPY_FLOAT
ufunc_eval_sh_legendre_types[7] = <char>NPY_FLOAT
ufunc_eval_sh_legendre_types[8] = <char>NPY_FLOAT
ufunc_eval_sh_legendre_types[9] = <char>NPY_FLOAT
ufunc_eval_sh_legendre_types[10] = <char>NPY_CFLOAT
ufunc_eval_sh_legendre_types[11] = <char>NPY_CFLOAT
ufunc_eval_sh_legendre_types[12] = <char>NPY_DOUBLE
ufunc_eval_sh_legendre_types[13] = <char>NPY_DOUBLE
ufunc_eval_sh_legendre_types[14] = <char>NPY_DOUBLE
ufunc_eval_sh_legendre_types[15] = <char>NPY_DOUBLE
ufunc_eval_sh_legendre_types[16] = <char>NPY_CDOUBLE
ufunc_eval_sh_legendre_types[17] = <char>NPY_CDOUBLE
ufunc_eval_sh_legendre_ptr[2*0] = <void*>_func_eval_sh_legendre_l
ufunc_eval_sh_legendre_ptr[2*0+1] = <void*>(<char*>"eval_sh_legendre")
ufunc_eval_sh_legendre_ptr[2*1] = <void*>_func_eval_sh_legendre_l
ufunc_eval_sh_legendre_ptr[2*1+1] = <void*>(<char*>"eval_sh_legendre")
ufunc_eval_sh_legendre_ptr[2*2] = <void*>_func_eval_sh_legendre[double]
ufunc_eval_sh_legendre_ptr[2*2+1] = <void*>(<char*>"eval_sh_legendre")
ufunc_eval_sh_legendre_ptr[2*3] = <void*>_func_eval_sh_legendre[double_complex]
ufunc_eval_sh_legendre_ptr[2*3+1] = <void*>(<char*>"eval_sh_legendre")
ufunc_eval_sh_legendre_ptr[2*4] = <void*>_func_eval_sh_legendre[double]
ufunc_eval_sh_legendre_ptr[2*4+1] = <void*>(<char*>"eval_sh_legendre")
ufunc_eval_sh_legendre_ptr[2*5] = <void*>_func_eval_sh_legendre[double_complex]
ufunc_eval_sh_legendre_ptr[2*5+1] = <void*>(<char*>"eval_sh_legendre")
ufunc_eval_sh_legendre_data[0] = &ufunc_eval_sh_legendre_ptr[2*0]
ufunc_eval_sh_legendre_data[1] = &ufunc_eval_sh_legendre_ptr[2*1]
ufunc_eval_sh_legendre_data[2] = &ufunc_eval_sh_legendre_ptr[2*2]
ufunc_eval_sh_legendre_data[3] = &ufunc_eval_sh_legendre_ptr[2*3]
ufunc_eval_sh_legendre_data[4] = &ufunc_eval_sh_legendre_ptr[2*4]
ufunc_eval_sh_legendre_data[5] = &ufunc_eval_sh_legendre_ptr[2*5]
eval_sh_legendre = np.PyUFunc_FromFuncAndData(ufunc_eval_sh_legendre_loops, ufunc_eval_sh_legendre_data, ufunc_eval_sh_legendre_types, 6, 2, 1, 0, "eval_sh_legendre", ufunc_eval_sh_legendre_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_exp1_loops[4]
cdef void *ufunc_exp1_ptr[8]
cdef void *ufunc_exp1_data[4]
cdef char ufunc_exp1_types[8]
cdef char *ufunc_exp1_doc = (
    "y=exp1(z) returns the exponential integral (n=1) of complex argument\n"
    "z: integral(exp(-z*t)/t,t=1..inf).")
ufunc_exp1_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_exp1_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_exp1_loops[2] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_exp1_loops[3] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_exp1_types[0] = <char>NPY_FLOAT
ufunc_exp1_types[1] = <char>NPY_FLOAT
ufunc_exp1_types[2] = <char>NPY_DOUBLE
ufunc_exp1_types[3] = <char>NPY_DOUBLE
ufunc_exp1_types[4] = <char>NPY_CFLOAT
ufunc_exp1_types[5] = <char>NPY_CFLOAT
ufunc_exp1_types[6] = <char>NPY_CDOUBLE
ufunc_exp1_types[7] = <char>NPY_CDOUBLE
ufunc_exp1_ptr[2*0] = <void*>_func_exp1_wrap
ufunc_exp1_ptr[2*0+1] = <void*>(<char*>"exp1")
ufunc_exp1_ptr[2*1] = <void*>_func_exp1_wrap
ufunc_exp1_ptr[2*1+1] = <void*>(<char*>"exp1")
ufunc_exp1_ptr[2*2] = <void*>_func_cexp1_wrap
ufunc_exp1_ptr[2*2+1] = <void*>(<char*>"exp1")
ufunc_exp1_ptr[2*3] = <void*>_func_cexp1_wrap
ufunc_exp1_ptr[2*3+1] = <void*>(<char*>"exp1")
ufunc_exp1_data[0] = &ufunc_exp1_ptr[2*0]
ufunc_exp1_data[1] = &ufunc_exp1_ptr[2*1]
ufunc_exp1_data[2] = &ufunc_exp1_ptr[2*2]
ufunc_exp1_data[3] = &ufunc_exp1_ptr[2*3]
exp1 = np.PyUFunc_FromFuncAndData(ufunc_exp1_loops, ufunc_exp1_data, ufunc_exp1_types, 4, 1, 1, 0, "exp1", ufunc_exp1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_exp10_loops[2]
cdef void *ufunc_exp10_ptr[4]
cdef void *ufunc_exp10_data[2]
cdef char ufunc_exp10_types[4]
cdef char *ufunc_exp10_doc = (
    "y=exp10(x) returns 10 raised to the x power.")
ufunc_exp10_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_exp10_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_exp10_types[0] = <char>NPY_FLOAT
ufunc_exp10_types[1] = <char>NPY_FLOAT
ufunc_exp10_types[2] = <char>NPY_DOUBLE
ufunc_exp10_types[3] = <char>NPY_DOUBLE
ufunc_exp10_ptr[2*0] = <void*>_func_exp10
ufunc_exp10_ptr[2*0+1] = <void*>(<char*>"exp10")
ufunc_exp10_ptr[2*1] = <void*>_func_exp10
ufunc_exp10_ptr[2*1+1] = <void*>(<char*>"exp10")
ufunc_exp10_data[0] = &ufunc_exp10_ptr[2*0]
ufunc_exp10_data[1] = &ufunc_exp10_ptr[2*1]
exp10 = np.PyUFunc_FromFuncAndData(ufunc_exp10_loops, ufunc_exp10_data, ufunc_exp10_types, 2, 1, 1, 0, "exp10", ufunc_exp10_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_exp2_loops[2]
cdef void *ufunc_exp2_ptr[4]
cdef void *ufunc_exp2_data[2]
cdef char ufunc_exp2_types[4]
cdef char *ufunc_exp2_doc = (
    "y=exp2(x) returns 2 raised to the x power.")
ufunc_exp2_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_exp2_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_exp2_types[0] = <char>NPY_FLOAT
ufunc_exp2_types[1] = <char>NPY_FLOAT
ufunc_exp2_types[2] = <char>NPY_DOUBLE
ufunc_exp2_types[3] = <char>NPY_DOUBLE
ufunc_exp2_ptr[2*0] = <void*>_func_exp2
ufunc_exp2_ptr[2*0+1] = <void*>(<char*>"exp2")
ufunc_exp2_ptr[2*1] = <void*>_func_exp2
ufunc_exp2_ptr[2*1+1] = <void*>(<char*>"exp2")
ufunc_exp2_data[0] = &ufunc_exp2_ptr[2*0]
ufunc_exp2_data[1] = &ufunc_exp2_ptr[2*1]
exp2 = np.PyUFunc_FromFuncAndData(ufunc_exp2_loops, ufunc_exp2_data, ufunc_exp2_types, 2, 1, 1, 0, "exp2", ufunc_exp2_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_expi_loops[4]
cdef void *ufunc_expi_ptr[8]
cdef void *ufunc_expi_data[4]
cdef char ufunc_expi_types[8]
cdef char *ufunc_expi_doc = (
    "y=expi(x) returns an exponential integral of argument x defined as\n"
    "integral(exp(t)/t,t=-inf..x).  See expn for a different exponential\n"
    "integral.")
ufunc_expi_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_expi_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_expi_loops[2] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_expi_loops[3] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_expi_types[0] = <char>NPY_FLOAT
ufunc_expi_types[1] = <char>NPY_FLOAT
ufunc_expi_types[2] = <char>NPY_DOUBLE
ufunc_expi_types[3] = <char>NPY_DOUBLE
ufunc_expi_types[4] = <char>NPY_CFLOAT
ufunc_expi_types[5] = <char>NPY_CFLOAT
ufunc_expi_types[6] = <char>NPY_CDOUBLE
ufunc_expi_types[7] = <char>NPY_CDOUBLE
ufunc_expi_ptr[2*0] = <void*>_func_expi_wrap
ufunc_expi_ptr[2*0+1] = <void*>(<char*>"expi")
ufunc_expi_ptr[2*1] = <void*>_func_expi_wrap
ufunc_expi_ptr[2*1+1] = <void*>(<char*>"expi")
ufunc_expi_ptr[2*2] = <void*>_func_cexpi_wrap
ufunc_expi_ptr[2*2+1] = <void*>(<char*>"expi")
ufunc_expi_ptr[2*3] = <void*>_func_cexpi_wrap
ufunc_expi_ptr[2*3+1] = <void*>(<char*>"expi")
ufunc_expi_data[0] = &ufunc_expi_ptr[2*0]
ufunc_expi_data[1] = &ufunc_expi_ptr[2*1]
ufunc_expi_data[2] = &ufunc_expi_ptr[2*2]
ufunc_expi_data[3] = &ufunc_expi_ptr[2*3]
expi = np.PyUFunc_FromFuncAndData(ufunc_expi_loops, ufunc_expi_data, ufunc_expi_types, 4, 1, 1, 0, "expi", ufunc_expi_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_expit_loops[3]
cdef void *ufunc_expit_ptr[6]
cdef void *ufunc_expit_data[3]
cdef char ufunc_expit_types[6]
cdef char *ufunc_expit_doc = (
    "Expit ufunc for ndarrays.\n"
    "\n"
    "The expit function is defined as expit(x) = 1/(1+exp(-x)).\n"
    "Note that expit is the inverse logit function.\n"
    "\n"
    "Parameters\n"
    "----------\n"
    "x : ndarray\n"
    "    The ndarray to apply expit to element-wise.\n"
    "\n"
    "Returns\n"
    "-------\n"
    "out : ndarray\n"
    "    An ndarray of the same shape as x. Its entries\n"
    "    are expit of the corresponding entry of x.\n"
    "\n"
    "Notes\n"
    "-----\n"
    "As a ufunc logit takes a number of optional\n"
    "keywork arguments. For more information\n"
    "see `ufuncs <http://docs.scipy.org/doc/numpy/reference/ufuncs.html>`_")
ufunc_expit_loops[0] = <np.PyUFuncGenericFunction>loop_f_f__As_f_f
ufunc_expit_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_expit_loops[2] = <np.PyUFuncGenericFunction>loop_g_g__As_g_g
ufunc_expit_types[0] = <char>NPY_FLOAT
ufunc_expit_types[1] = <char>NPY_FLOAT
ufunc_expit_types[2] = <char>NPY_DOUBLE
ufunc_expit_types[3] = <char>NPY_DOUBLE
ufunc_expit_types[4] = <char>NPY_LONGDOUBLE
ufunc_expit_types[5] = <char>NPY_LONGDOUBLE
ufunc_expit_ptr[2*0] = <void*>_func_expitf
ufunc_expit_ptr[2*0+1] = <void*>(<char*>"expit")
ufunc_expit_ptr[2*1] = <void*>_func_expit
ufunc_expit_ptr[2*1+1] = <void*>(<char*>"expit")
ufunc_expit_ptr[2*2] = <void*>_func_expitl
ufunc_expit_ptr[2*2+1] = <void*>(<char*>"expit")
ufunc_expit_data[0] = &ufunc_expit_ptr[2*0]
ufunc_expit_data[1] = &ufunc_expit_ptr[2*1]
ufunc_expit_data[2] = &ufunc_expit_ptr[2*2]
expit = np.PyUFunc_FromFuncAndData(ufunc_expit_loops, ufunc_expit_data, ufunc_expit_types, 3, 1, 1, 0, "expit", ufunc_expit_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_expm1_loops[2]
cdef void *ufunc_expm1_ptr[4]
cdef void *ufunc_expm1_data[2]
cdef char ufunc_expm1_types[4]
cdef char *ufunc_expm1_doc = (
    "y=expm1(x) calculates exp(x) - 1 for use when x is near zero.")
ufunc_expm1_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_expm1_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_expm1_types[0] = <char>NPY_FLOAT
ufunc_expm1_types[1] = <char>NPY_FLOAT
ufunc_expm1_types[2] = <char>NPY_DOUBLE
ufunc_expm1_types[3] = <char>NPY_DOUBLE
ufunc_expm1_ptr[2*0] = <void*>_func_expm1
ufunc_expm1_ptr[2*0+1] = <void*>(<char*>"expm1")
ufunc_expm1_ptr[2*1] = <void*>_func_expm1
ufunc_expm1_ptr[2*1+1] = <void*>(<char*>"expm1")
ufunc_expm1_data[0] = &ufunc_expm1_ptr[2*0]
ufunc_expm1_data[1] = &ufunc_expm1_ptr[2*1]
expm1 = np.PyUFunc_FromFuncAndData(ufunc_expm1_loops, ufunc_expm1_data, ufunc_expm1_types, 2, 1, 1, 0, "expm1", ufunc_expm1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_expn_loops[4]
cdef void *ufunc_expn_ptr[8]
cdef void *ufunc_expn_data[4]
cdef char ufunc_expn_types[12]
cdef char *ufunc_expn_doc = (
    "y=expn(n,x) returns the exponential integral for integer n and\n"
    "non-negative x and n: integral(exp(-x*t) / t**n, t=1..inf).")
ufunc_expn_loops[0] = <np.PyUFuncGenericFunction>loop_d_id__As_lf_f
ufunc_expn_loops[1] = <np.PyUFuncGenericFunction>loop_d_id__As_ld_d
ufunc_expn_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_expn_loops[3] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_expn_types[0] = <char>NPY_LONG
ufunc_expn_types[1] = <char>NPY_FLOAT
ufunc_expn_types[2] = <char>NPY_FLOAT
ufunc_expn_types[3] = <char>NPY_LONG
ufunc_expn_types[4] = <char>NPY_DOUBLE
ufunc_expn_types[5] = <char>NPY_DOUBLE
ufunc_expn_types[6] = <char>NPY_FLOAT
ufunc_expn_types[7] = <char>NPY_FLOAT
ufunc_expn_types[8] = <char>NPY_FLOAT
ufunc_expn_types[9] = <char>NPY_DOUBLE
ufunc_expn_types[10] = <char>NPY_DOUBLE
ufunc_expn_types[11] = <char>NPY_DOUBLE
ufunc_expn_ptr[2*0] = <void*>_func_expn
ufunc_expn_ptr[2*0+1] = <void*>(<char*>"expn")
ufunc_expn_ptr[2*1] = <void*>_func_expn
ufunc_expn_ptr[2*1+1] = <void*>(<char*>"expn")
ufunc_expn_ptr[2*2] = <void*>_func_expn_unsafe
ufunc_expn_ptr[2*2+1] = <void*>(<char*>"expn")
ufunc_expn_ptr[2*3] = <void*>_func_expn_unsafe
ufunc_expn_ptr[2*3+1] = <void*>(<char*>"expn")
ufunc_expn_data[0] = &ufunc_expn_ptr[2*0]
ufunc_expn_data[1] = &ufunc_expn_ptr[2*1]
ufunc_expn_data[2] = &ufunc_expn_ptr[2*2]
ufunc_expn_data[3] = &ufunc_expn_ptr[2*3]
expn = np.PyUFunc_FromFuncAndData(ufunc_expn_loops, ufunc_expn_data, ufunc_expn_types, 4, 2, 1, 0, "expn", ufunc_expn_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_fdtr_loops[2]
cdef void *ufunc_fdtr_ptr[4]
cdef void *ufunc_fdtr_data[2]
cdef char ufunc_fdtr_types[8]
cdef char *ufunc_fdtr_doc = (
    "y=fdtr(dfn,dfd,x) returns the area from zero to x under the F density\n"
    "function (also known as Snedcor's density or the variance ratio\n"
    "density).  This is the density of X = (unum/dfn)/(uden/dfd), where unum and\n"
    "uden are random variables having Chi square distributions with dfn and\n"
    "dfd degrees of freedom, respectively.")
ufunc_fdtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_fdtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_fdtr_types[0] = <char>NPY_FLOAT
ufunc_fdtr_types[1] = <char>NPY_FLOAT
ufunc_fdtr_types[2] = <char>NPY_FLOAT
ufunc_fdtr_types[3] = <char>NPY_FLOAT
ufunc_fdtr_types[4] = <char>NPY_DOUBLE
ufunc_fdtr_types[5] = <char>NPY_DOUBLE
ufunc_fdtr_types[6] = <char>NPY_DOUBLE
ufunc_fdtr_types[7] = <char>NPY_DOUBLE
ufunc_fdtr_ptr[2*0] = <void*>_func_fdtr
ufunc_fdtr_ptr[2*0+1] = <void*>(<char*>"fdtr")
ufunc_fdtr_ptr[2*1] = <void*>_func_fdtr
ufunc_fdtr_ptr[2*1+1] = <void*>(<char*>"fdtr")
ufunc_fdtr_data[0] = &ufunc_fdtr_ptr[2*0]
ufunc_fdtr_data[1] = &ufunc_fdtr_ptr[2*1]
fdtr = np.PyUFunc_FromFuncAndData(ufunc_fdtr_loops, ufunc_fdtr_data, ufunc_fdtr_types, 2, 3, 1, 0, "fdtr", ufunc_fdtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_fdtrc_loops[2]
cdef void *ufunc_fdtrc_ptr[4]
cdef void *ufunc_fdtrc_data[2]
cdef char ufunc_fdtrc_types[8]
cdef char *ufunc_fdtrc_doc = (
    "y=fdtrc(dfn,dfd,x) returns the complemented F distribution function.")
ufunc_fdtrc_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_fdtrc_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_fdtrc_types[0] = <char>NPY_FLOAT
ufunc_fdtrc_types[1] = <char>NPY_FLOAT
ufunc_fdtrc_types[2] = <char>NPY_FLOAT
ufunc_fdtrc_types[3] = <char>NPY_FLOAT
ufunc_fdtrc_types[4] = <char>NPY_DOUBLE
ufunc_fdtrc_types[5] = <char>NPY_DOUBLE
ufunc_fdtrc_types[6] = <char>NPY_DOUBLE
ufunc_fdtrc_types[7] = <char>NPY_DOUBLE
ufunc_fdtrc_ptr[2*0] = <void*>_func_fdtrc
ufunc_fdtrc_ptr[2*0+1] = <void*>(<char*>"fdtrc")
ufunc_fdtrc_ptr[2*1] = <void*>_func_fdtrc
ufunc_fdtrc_ptr[2*1+1] = <void*>(<char*>"fdtrc")
ufunc_fdtrc_data[0] = &ufunc_fdtrc_ptr[2*0]
ufunc_fdtrc_data[1] = &ufunc_fdtrc_ptr[2*1]
fdtrc = np.PyUFunc_FromFuncAndData(ufunc_fdtrc_loops, ufunc_fdtrc_data, ufunc_fdtrc_types, 2, 3, 1, 0, "fdtrc", ufunc_fdtrc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_fdtri_loops[2]
cdef void *ufunc_fdtri_ptr[4]
cdef void *ufunc_fdtri_data[2]
cdef char ufunc_fdtri_types[8]
cdef char *ufunc_fdtri_doc = (
    "x=fdtri(dfn,dfd,p) finds the F density argument x such that\n"
    "fdtr(dfn,dfd,x)=p.")
ufunc_fdtri_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_fdtri_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_fdtri_types[0] = <char>NPY_FLOAT
ufunc_fdtri_types[1] = <char>NPY_FLOAT
ufunc_fdtri_types[2] = <char>NPY_FLOAT
ufunc_fdtri_types[3] = <char>NPY_FLOAT
ufunc_fdtri_types[4] = <char>NPY_DOUBLE
ufunc_fdtri_types[5] = <char>NPY_DOUBLE
ufunc_fdtri_types[6] = <char>NPY_DOUBLE
ufunc_fdtri_types[7] = <char>NPY_DOUBLE
ufunc_fdtri_ptr[2*0] = <void*>_func_fdtri
ufunc_fdtri_ptr[2*0+1] = <void*>(<char*>"fdtri")
ufunc_fdtri_ptr[2*1] = <void*>_func_fdtri
ufunc_fdtri_ptr[2*1+1] = <void*>(<char*>"fdtri")
ufunc_fdtri_data[0] = &ufunc_fdtri_ptr[2*0]
ufunc_fdtri_data[1] = &ufunc_fdtri_ptr[2*1]
fdtri = np.PyUFunc_FromFuncAndData(ufunc_fdtri_loops, ufunc_fdtri_data, ufunc_fdtri_types, 2, 3, 1, 0, "fdtri", ufunc_fdtri_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_fdtridfd_loops[2]
cdef void *ufunc_fdtridfd_ptr[4]
cdef void *ufunc_fdtridfd_data[2]
cdef char ufunc_fdtridfd_types[8]
cdef char *ufunc_fdtridfd_doc = (
    "x=fdtridfd(dfn,p,x) finds the F density argument dfd such that\n"
    "fdtr(dfn,dfd,x)=p.")
ufunc_fdtridfd_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_fdtridfd_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_fdtridfd_types[0] = <char>NPY_FLOAT
ufunc_fdtridfd_types[1] = <char>NPY_FLOAT
ufunc_fdtridfd_types[2] = <char>NPY_FLOAT
ufunc_fdtridfd_types[3] = <char>NPY_FLOAT
ufunc_fdtridfd_types[4] = <char>NPY_DOUBLE
ufunc_fdtridfd_types[5] = <char>NPY_DOUBLE
ufunc_fdtridfd_types[6] = <char>NPY_DOUBLE
ufunc_fdtridfd_types[7] = <char>NPY_DOUBLE
ufunc_fdtridfd_ptr[2*0] = <void*>_func_cdff4_wrap
ufunc_fdtridfd_ptr[2*0+1] = <void*>(<char*>"fdtridfd")
ufunc_fdtridfd_ptr[2*1] = <void*>_func_cdff4_wrap
ufunc_fdtridfd_ptr[2*1+1] = <void*>(<char*>"fdtridfd")
ufunc_fdtridfd_data[0] = &ufunc_fdtridfd_ptr[2*0]
ufunc_fdtridfd_data[1] = &ufunc_fdtridfd_ptr[2*1]
fdtridfd = np.PyUFunc_FromFuncAndData(ufunc_fdtridfd_loops, ufunc_fdtridfd_data, ufunc_fdtridfd_types, 2, 3, 1, 0, "fdtridfd", ufunc_fdtridfd_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_fresnel_loops[4]
cdef void *ufunc_fresnel_ptr[8]
cdef void *ufunc_fresnel_data[4]
cdef char ufunc_fresnel_types[12]
cdef char *ufunc_fresnel_doc = (
    "(ssa,cca)=fresnel(z) returns the Fresnel sin and cos integrals: integral(sin(pi/2\n"
    "* t**2),t=0..z) and integral(cos(pi/2 * t**2),t=0..z) for real or\n"
    "complex z.")
ufunc_fresnel_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_f_ff
ufunc_fresnel_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_d_dd
ufunc_fresnel_loops[2] = <np.PyUFuncGenericFunction>loop_i_D_DD_As_F_FF
ufunc_fresnel_loops[3] = <np.PyUFuncGenericFunction>loop_i_D_DD_As_D_DD
ufunc_fresnel_types[0] = <char>NPY_FLOAT
ufunc_fresnel_types[1] = <char>NPY_FLOAT
ufunc_fresnel_types[2] = <char>NPY_FLOAT
ufunc_fresnel_types[3] = <char>NPY_DOUBLE
ufunc_fresnel_types[4] = <char>NPY_DOUBLE
ufunc_fresnel_types[5] = <char>NPY_DOUBLE
ufunc_fresnel_types[6] = <char>NPY_CFLOAT
ufunc_fresnel_types[7] = <char>NPY_CFLOAT
ufunc_fresnel_types[8] = <char>NPY_CFLOAT
ufunc_fresnel_types[9] = <char>NPY_CDOUBLE
ufunc_fresnel_types[10] = <char>NPY_CDOUBLE
ufunc_fresnel_types[11] = <char>NPY_CDOUBLE
ufunc_fresnel_ptr[2*0] = <void*>_func_fresnl
ufunc_fresnel_ptr[2*0+1] = <void*>(<char*>"fresnel")
ufunc_fresnel_ptr[2*1] = <void*>_func_fresnl
ufunc_fresnel_ptr[2*1+1] = <void*>(<char*>"fresnel")
ufunc_fresnel_ptr[2*2] = <void*>_func_cfresnl_wrap
ufunc_fresnel_ptr[2*2+1] = <void*>(<char*>"fresnel")
ufunc_fresnel_ptr[2*3] = <void*>_func_cfresnl_wrap
ufunc_fresnel_ptr[2*3+1] = <void*>(<char*>"fresnel")
ufunc_fresnel_data[0] = &ufunc_fresnel_ptr[2*0]
ufunc_fresnel_data[1] = &ufunc_fresnel_ptr[2*1]
ufunc_fresnel_data[2] = &ufunc_fresnel_ptr[2*2]
ufunc_fresnel_data[3] = &ufunc_fresnel_ptr[2*3]
fresnel = np.PyUFunc_FromFuncAndData(ufunc_fresnel_loops, ufunc_fresnel_data, ufunc_fresnel_types, 4, 1, 2, 0, "fresnel", ufunc_fresnel_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gamma_loops[4]
cdef void *ufunc_gamma_ptr[8]
cdef void *ufunc_gamma_data[4]
cdef char ufunc_gamma_types[8]
cdef char *ufunc_gamma_doc = (
    "y=gamma(z) returns the gamma function of the argument.  The gamma\n"
    "function is often referred to as the generalized factorial since\n"
    "z*gamma(z) = gamma(z+1) and gamma(n+1) = n! for natural number n.")
ufunc_gamma_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_gamma_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_gamma_loops[2] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_gamma_loops[3] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_gamma_types[0] = <char>NPY_FLOAT
ufunc_gamma_types[1] = <char>NPY_FLOAT
ufunc_gamma_types[2] = <char>NPY_DOUBLE
ufunc_gamma_types[3] = <char>NPY_DOUBLE
ufunc_gamma_types[4] = <char>NPY_CFLOAT
ufunc_gamma_types[5] = <char>NPY_CFLOAT
ufunc_gamma_types[6] = <char>NPY_CDOUBLE
ufunc_gamma_types[7] = <char>NPY_CDOUBLE
ufunc_gamma_ptr[2*0] = <void*>_func_Gamma
ufunc_gamma_ptr[2*0+1] = <void*>(<char*>"gamma")
ufunc_gamma_ptr[2*1] = <void*>_func_Gamma
ufunc_gamma_ptr[2*1+1] = <void*>(<char*>"gamma")
ufunc_gamma_ptr[2*2] = <void*>_func_cgamma_wrap
ufunc_gamma_ptr[2*2+1] = <void*>(<char*>"gamma")
ufunc_gamma_ptr[2*3] = <void*>_func_cgamma_wrap
ufunc_gamma_ptr[2*3+1] = <void*>(<char*>"gamma")
ufunc_gamma_data[0] = &ufunc_gamma_ptr[2*0]
ufunc_gamma_data[1] = &ufunc_gamma_ptr[2*1]
ufunc_gamma_data[2] = &ufunc_gamma_ptr[2*2]
ufunc_gamma_data[3] = &ufunc_gamma_ptr[2*3]
gamma = np.PyUFunc_FromFuncAndData(ufunc_gamma_loops, ufunc_gamma_data, ufunc_gamma_types, 4, 1, 1, 0, "gamma", ufunc_gamma_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gammainc_loops[2]
cdef void *ufunc_gammainc_ptr[4]
cdef void *ufunc_gammainc_data[2]
cdef char ufunc_gammainc_types[6]
cdef char *ufunc_gammainc_doc = (
    "y=gammainc(a,x) returns the incomplete gamma integral defined as\n"
    "1 / gamma(a) * integral(exp(-t) * t**(a-1), t=0..x).  a must be\n"
    "positive and x must be >= 0.")
ufunc_gammainc_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_gammainc_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_gammainc_types[0] = <char>NPY_FLOAT
ufunc_gammainc_types[1] = <char>NPY_FLOAT
ufunc_gammainc_types[2] = <char>NPY_FLOAT
ufunc_gammainc_types[3] = <char>NPY_DOUBLE
ufunc_gammainc_types[4] = <char>NPY_DOUBLE
ufunc_gammainc_types[5] = <char>NPY_DOUBLE
ufunc_gammainc_ptr[2*0] = <void*>_func_igam
ufunc_gammainc_ptr[2*0+1] = <void*>(<char*>"gammainc")
ufunc_gammainc_ptr[2*1] = <void*>_func_igam
ufunc_gammainc_ptr[2*1+1] = <void*>(<char*>"gammainc")
ufunc_gammainc_data[0] = &ufunc_gammainc_ptr[2*0]
ufunc_gammainc_data[1] = &ufunc_gammainc_ptr[2*1]
gammainc = np.PyUFunc_FromFuncAndData(ufunc_gammainc_loops, ufunc_gammainc_data, ufunc_gammainc_types, 2, 2, 1, 0, "gammainc", ufunc_gammainc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gammaincc_loops[2]
cdef void *ufunc_gammaincc_ptr[4]
cdef void *ufunc_gammaincc_data[2]
cdef char ufunc_gammaincc_types[6]
cdef char *ufunc_gammaincc_doc = (
    "y=gammaincc(a,x) returns the complemented incomplete gamma integral\n"
    "defined as 1 / gamma(a) * integral(exp(-t) * t**(a-1), t=x..inf) = 1 -\n"
    "gammainc(a,x).  a must be positive and x must be >= 0.")
ufunc_gammaincc_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_gammaincc_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_gammaincc_types[0] = <char>NPY_FLOAT
ufunc_gammaincc_types[1] = <char>NPY_FLOAT
ufunc_gammaincc_types[2] = <char>NPY_FLOAT
ufunc_gammaincc_types[3] = <char>NPY_DOUBLE
ufunc_gammaincc_types[4] = <char>NPY_DOUBLE
ufunc_gammaincc_types[5] = <char>NPY_DOUBLE
ufunc_gammaincc_ptr[2*0] = <void*>_func_igamc
ufunc_gammaincc_ptr[2*0+1] = <void*>(<char*>"gammaincc")
ufunc_gammaincc_ptr[2*1] = <void*>_func_igamc
ufunc_gammaincc_ptr[2*1+1] = <void*>(<char*>"gammaincc")
ufunc_gammaincc_data[0] = &ufunc_gammaincc_ptr[2*0]
ufunc_gammaincc_data[1] = &ufunc_gammaincc_ptr[2*1]
gammaincc = np.PyUFunc_FromFuncAndData(ufunc_gammaincc_loops, ufunc_gammaincc_data, ufunc_gammaincc_types, 2, 2, 1, 0, "gammaincc", ufunc_gammaincc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gammainccinv_loops[2]
cdef void *ufunc_gammainccinv_ptr[4]
cdef void *ufunc_gammainccinv_data[2]
cdef char ufunc_gammainccinv_types[6]
cdef char *ufunc_gammainccinv_doc = (
    "x=gammainccinv(a,y) returns x such that gammaincc(a,x) = y.")
ufunc_gammainccinv_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_gammainccinv_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_gammainccinv_types[0] = <char>NPY_FLOAT
ufunc_gammainccinv_types[1] = <char>NPY_FLOAT
ufunc_gammainccinv_types[2] = <char>NPY_FLOAT
ufunc_gammainccinv_types[3] = <char>NPY_DOUBLE
ufunc_gammainccinv_types[4] = <char>NPY_DOUBLE
ufunc_gammainccinv_types[5] = <char>NPY_DOUBLE
ufunc_gammainccinv_ptr[2*0] = <void*>_func_igami
ufunc_gammainccinv_ptr[2*0+1] = <void*>(<char*>"gammainccinv")
ufunc_gammainccinv_ptr[2*1] = <void*>_func_igami
ufunc_gammainccinv_ptr[2*1+1] = <void*>(<char*>"gammainccinv")
ufunc_gammainccinv_data[0] = &ufunc_gammainccinv_ptr[2*0]
ufunc_gammainccinv_data[1] = &ufunc_gammainccinv_ptr[2*1]
gammainccinv = np.PyUFunc_FromFuncAndData(ufunc_gammainccinv_loops, ufunc_gammainccinv_data, ufunc_gammainccinv_types, 2, 2, 1, 0, "gammainccinv", ufunc_gammainccinv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gammaincinv_loops[2]
cdef void *ufunc_gammaincinv_ptr[4]
cdef void *ufunc_gammaincinv_data[2]
cdef char ufunc_gammaincinv_types[6]
cdef char *ufunc_gammaincinv_doc = (
    "gammaincinv(a, y) returns x such that gammainc(a, x) = y.")
ufunc_gammaincinv_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_gammaincinv_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_gammaincinv_types[0] = <char>NPY_FLOAT
ufunc_gammaincinv_types[1] = <char>NPY_FLOAT
ufunc_gammaincinv_types[2] = <char>NPY_FLOAT
ufunc_gammaincinv_types[3] = <char>NPY_DOUBLE
ufunc_gammaincinv_types[4] = <char>NPY_DOUBLE
ufunc_gammaincinv_types[5] = <char>NPY_DOUBLE
ufunc_gammaincinv_ptr[2*0] = <void*>_func_gammaincinv
ufunc_gammaincinv_ptr[2*0+1] = <void*>(<char*>"gammaincinv")
ufunc_gammaincinv_ptr[2*1] = <void*>_func_gammaincinv
ufunc_gammaincinv_ptr[2*1+1] = <void*>(<char*>"gammaincinv")
ufunc_gammaincinv_data[0] = &ufunc_gammaincinv_ptr[2*0]
ufunc_gammaincinv_data[1] = &ufunc_gammaincinv_ptr[2*1]
gammaincinv = np.PyUFunc_FromFuncAndData(ufunc_gammaincinv_loops, ufunc_gammaincinv_data, ufunc_gammaincinv_types, 2, 2, 1, 0, "gammaincinv", ufunc_gammaincinv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gammaln_loops[4]
cdef void *ufunc_gammaln_ptr[8]
cdef void *ufunc_gammaln_data[4]
cdef char ufunc_gammaln_types[8]
cdef char *ufunc_gammaln_doc = (
    "y=gammaln(z) returns the base e logarithm of the absolute value of the\n"
    "gamma function of z: ln(abs(gamma(z)))\n"
    "\n"
    "See Also\n"
    "--------\n"
    "gammasgn")
ufunc_gammaln_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_gammaln_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_gammaln_loops[2] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_gammaln_loops[3] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_gammaln_types[0] = <char>NPY_FLOAT
ufunc_gammaln_types[1] = <char>NPY_FLOAT
ufunc_gammaln_types[2] = <char>NPY_DOUBLE
ufunc_gammaln_types[3] = <char>NPY_DOUBLE
ufunc_gammaln_types[4] = <char>NPY_CFLOAT
ufunc_gammaln_types[5] = <char>NPY_CFLOAT
ufunc_gammaln_types[6] = <char>NPY_CDOUBLE
ufunc_gammaln_types[7] = <char>NPY_CDOUBLE
ufunc_gammaln_ptr[2*0] = <void*>_func_lgam
ufunc_gammaln_ptr[2*0+1] = <void*>(<char*>"gammaln")
ufunc_gammaln_ptr[2*1] = <void*>_func_lgam
ufunc_gammaln_ptr[2*1+1] = <void*>(<char*>"gammaln")
ufunc_gammaln_ptr[2*2] = <void*>_func_clngamma_wrap
ufunc_gammaln_ptr[2*2+1] = <void*>(<char*>"gammaln")
ufunc_gammaln_ptr[2*3] = <void*>_func_clngamma_wrap
ufunc_gammaln_ptr[2*3+1] = <void*>(<char*>"gammaln")
ufunc_gammaln_data[0] = &ufunc_gammaln_ptr[2*0]
ufunc_gammaln_data[1] = &ufunc_gammaln_ptr[2*1]
ufunc_gammaln_data[2] = &ufunc_gammaln_ptr[2*2]
ufunc_gammaln_data[3] = &ufunc_gammaln_ptr[2*3]
gammaln = np.PyUFunc_FromFuncAndData(ufunc_gammaln_loops, ufunc_gammaln_data, ufunc_gammaln_types, 4, 1, 1, 0, "gammaln", ufunc_gammaln_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gammasgn_loops[2]
cdef void *ufunc_gammasgn_ptr[4]
cdef void *ufunc_gammasgn_data[2]
cdef char ufunc_gammasgn_types[4]
cdef char *ufunc_gammasgn_doc = (
    "y=gammasgn(x) returns the sign of the gamma function.\n"
    "\n"
    "See Also\n"
    "--------\n"
    "gammaln")
ufunc_gammasgn_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_gammasgn_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_gammasgn_types[0] = <char>NPY_FLOAT
ufunc_gammasgn_types[1] = <char>NPY_FLOAT
ufunc_gammasgn_types[2] = <char>NPY_DOUBLE
ufunc_gammasgn_types[3] = <char>NPY_DOUBLE
ufunc_gammasgn_ptr[2*0] = <void*>_func_gammasgn
ufunc_gammasgn_ptr[2*0+1] = <void*>(<char*>"gammasgn")
ufunc_gammasgn_ptr[2*1] = <void*>_func_gammasgn
ufunc_gammasgn_ptr[2*1+1] = <void*>(<char*>"gammasgn")
ufunc_gammasgn_data[0] = &ufunc_gammasgn_ptr[2*0]
ufunc_gammasgn_data[1] = &ufunc_gammasgn_ptr[2*1]
gammasgn = np.PyUFunc_FromFuncAndData(ufunc_gammasgn_loops, ufunc_gammasgn_data, ufunc_gammasgn_types, 2, 1, 1, 0, "gammasgn", ufunc_gammasgn_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gdtr_loops[2]
cdef void *ufunc_gdtr_ptr[4]
cdef void *ufunc_gdtr_data[2]
cdef char ufunc_gdtr_types[8]
cdef char *ufunc_gdtr_doc = (
    "y=gdtr(a,b,x) returns the integral from zero to x of the gamma\n"
    "probability density function: a**b / gamma(b) * integral(t**(b-1) exp(-at),t=0..x).\n"
    "The arguments a and b are used differently here than in other definitions.")
ufunc_gdtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_gdtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_gdtr_types[0] = <char>NPY_FLOAT
ufunc_gdtr_types[1] = <char>NPY_FLOAT
ufunc_gdtr_types[2] = <char>NPY_FLOAT
ufunc_gdtr_types[3] = <char>NPY_FLOAT
ufunc_gdtr_types[4] = <char>NPY_DOUBLE
ufunc_gdtr_types[5] = <char>NPY_DOUBLE
ufunc_gdtr_types[6] = <char>NPY_DOUBLE
ufunc_gdtr_types[7] = <char>NPY_DOUBLE
ufunc_gdtr_ptr[2*0] = <void*>_func_gdtr
ufunc_gdtr_ptr[2*0+1] = <void*>(<char*>"gdtr")
ufunc_gdtr_ptr[2*1] = <void*>_func_gdtr
ufunc_gdtr_ptr[2*1+1] = <void*>(<char*>"gdtr")
ufunc_gdtr_data[0] = &ufunc_gdtr_ptr[2*0]
ufunc_gdtr_data[1] = &ufunc_gdtr_ptr[2*1]
gdtr = np.PyUFunc_FromFuncAndData(ufunc_gdtr_loops, ufunc_gdtr_data, ufunc_gdtr_types, 2, 3, 1, 0, "gdtr", ufunc_gdtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gdtrc_loops[2]
cdef void *ufunc_gdtrc_ptr[4]
cdef void *ufunc_gdtrc_data[2]
cdef char ufunc_gdtrc_types[8]
cdef char *ufunc_gdtrc_doc = (
    "y=gdtrc(a,b,x) returns the integral from x to infinity of the gamma\n"
    "probability density function.  SEE gdtr, gdtri")
ufunc_gdtrc_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_gdtrc_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_gdtrc_types[0] = <char>NPY_FLOAT
ufunc_gdtrc_types[1] = <char>NPY_FLOAT
ufunc_gdtrc_types[2] = <char>NPY_FLOAT
ufunc_gdtrc_types[3] = <char>NPY_FLOAT
ufunc_gdtrc_types[4] = <char>NPY_DOUBLE
ufunc_gdtrc_types[5] = <char>NPY_DOUBLE
ufunc_gdtrc_types[6] = <char>NPY_DOUBLE
ufunc_gdtrc_types[7] = <char>NPY_DOUBLE
ufunc_gdtrc_ptr[2*0] = <void*>_func_gdtrc
ufunc_gdtrc_ptr[2*0+1] = <void*>(<char*>"gdtrc")
ufunc_gdtrc_ptr[2*1] = <void*>_func_gdtrc
ufunc_gdtrc_ptr[2*1+1] = <void*>(<char*>"gdtrc")
ufunc_gdtrc_data[0] = &ufunc_gdtrc_ptr[2*0]
ufunc_gdtrc_data[1] = &ufunc_gdtrc_ptr[2*1]
gdtrc = np.PyUFunc_FromFuncAndData(ufunc_gdtrc_loops, ufunc_gdtrc_data, ufunc_gdtrc_types, 2, 3, 1, 0, "gdtrc", ufunc_gdtrc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gdtria_loops[2]
cdef void *ufunc_gdtria_ptr[4]
cdef void *ufunc_gdtria_data[2]
cdef char ufunc_gdtria_types[8]
cdef char *ufunc_gdtria_doc = (
    "gdtria(p, b, x, out=None)\n"
    "\n"
    "Inverse with respect to `a` of `gdtr(a, b, x)`.\n"
    "\n"
    "`a = gdtria(p, b, x)` returns the inverse with respect to the parameter `a`\n"
    "of `p = gdtr(a, b, x)`, the cumulative distribution function of the gamma\n"
    "distribution.\n"
    "\n"
    "Parameters\n"
    "----------\n"
    "p : array_like\n"
    "    Probability values.\n"
    "b : array_like\n"
    "    `b` parameter values of `gdtr(a, b, x)`.  `b` is the \"shape\" parameter\n"
    "    of the gamma distribution.\n"
    "x : array_like\n"
    "    Nonnegative real values, from the domain of the gamma distribution.\n"
    "out : ndarray, optional\n"
    "    If a fourth argument is given, it must be a numpy.ndarray whose size\n"
    "    matches the broadcast result of `a`, `b` and `x`.  `out` is then the\n"
    "    array returned by the function.\n"
    "\n"
    "Returns\n"
    "-------\n"
    "a : ndarray\n"
    "    Values of the `a` parameter such that `p = gdtr(a, b, x)`.  `1/a`\n"
    "    is the \"scale\" parameter of the gamma distribution.\n"
    "\n"
    "See Also\n"
    "--------\n"
    "gdtr : CDF of the gamma distribution.\n"
    "gdtrib : Inverse with respect to `b` of `gdtr(a, b, x)`.\n"
    "gdtrix : Inverse with respect to `x` of `gdtr(a, b, x)`.\n"
    "\n"
    "Examples\n"
    "--------\n"
    "First evaluate `gdtr`.\n"
    "\n"
    ">>> p = gdtr(1.2, 3.4, 5.6)\n"
    ">>> print(p)\n"
    "0.94378087442\n"
    "\n"
    "Verify the inverse.\n"
    "\n"
    ">>> gdtria(p, 3.4, 5.6)\n"
    "1.2")
ufunc_gdtria_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_gdtria_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_gdtria_types[0] = <char>NPY_FLOAT
ufunc_gdtria_types[1] = <char>NPY_FLOAT
ufunc_gdtria_types[2] = <char>NPY_FLOAT
ufunc_gdtria_types[3] = <char>NPY_FLOAT
ufunc_gdtria_types[4] = <char>NPY_DOUBLE
ufunc_gdtria_types[5] = <char>NPY_DOUBLE
ufunc_gdtria_types[6] = <char>NPY_DOUBLE
ufunc_gdtria_types[7] = <char>NPY_DOUBLE
ufunc_gdtria_ptr[2*0] = <void*>_func_cdfgam4_wrap
ufunc_gdtria_ptr[2*0+1] = <void*>(<char*>"gdtria")
ufunc_gdtria_ptr[2*1] = <void*>_func_cdfgam4_wrap
ufunc_gdtria_ptr[2*1+1] = <void*>(<char*>"gdtria")
ufunc_gdtria_data[0] = &ufunc_gdtria_ptr[2*0]
ufunc_gdtria_data[1] = &ufunc_gdtria_ptr[2*1]
gdtria = np.PyUFunc_FromFuncAndData(ufunc_gdtria_loops, ufunc_gdtria_data, ufunc_gdtria_types, 2, 3, 1, 0, "gdtria", ufunc_gdtria_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gdtrib_loops[2]
cdef void *ufunc_gdtrib_ptr[4]
cdef void *ufunc_gdtrib_data[2]
cdef char ufunc_gdtrib_types[8]
cdef char *ufunc_gdtrib_doc = (
    "gdtrib(a, p, x, out=None)\n"
    "\n"
    "Inverse with respect to `b` of `gdtr(a, b, x)`.\n"
    "\n"
    "`b = gdtrib(a, p, x)` returns the inverse with respect to the parameter `b`\n"
    "of `p = gdtr(a, b, x)`, the cumulative distribution function of the gamma\n"
    "distribution.\n"
    "\n"
    "Parameters\n"
    "----------\n"
    "a : array_like\n"
    "    `a` parameter values of `gdtr(a, b, x)`. `1/a` is the \"scale\"\n"
    "    parameter of the gamma distribution.\n"
    "p : array_like\n"
    "    Probability values.\n"
    "x : array_like\n"
    "    Nonnegative real values, from the domain of the gamma distribution.\n"
    "out : ndarray, optional\n"
    "    If a fourth argument is given, it must be a numpy.ndarray whose size\n"
    "    matches the broadcast result of `a`, `b` and `x`.  `out` is then the\n"
    "    array returned by the function.\n"
    "\n"
    "Returns\n"
    "-------\n"
    "b : ndarray\n"
    "    Values of the `b` parameter such that `p = gdtr(a, b, x)`.  `b` is\n"
    "    the \"shape\" parameter of the gamma distribution.\n"
    "\n"
    "See Also\n"
    "--------\n"
    "gdtr : CDF of the gamma distribution.\n"
    "gdtria : Inverse with respect to `a` of `gdtr(a, b, x)`.\n"
    "gdtrix : Inverse with respect to `x` of `gdtr(a, b, x)`.\n"
    "\n"
    "Examples\n"
    "--------\n"
    "First evaluate `gdtr`.\n"
    "\n"
    ">>> p = gdtr(1.2, 3.4, 5.6)\n"
    ">>> print(p)\n"
    "0.94378087442\n"
    "\n"
    "Verify the inverse.\n"
    "\n"
    ">>> gdtrib(1.2, p, 5.6)\n"
    "3.3999999999723882")
ufunc_gdtrib_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_gdtrib_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_gdtrib_types[0] = <char>NPY_FLOAT
ufunc_gdtrib_types[1] = <char>NPY_FLOAT
ufunc_gdtrib_types[2] = <char>NPY_FLOAT
ufunc_gdtrib_types[3] = <char>NPY_FLOAT
ufunc_gdtrib_types[4] = <char>NPY_DOUBLE
ufunc_gdtrib_types[5] = <char>NPY_DOUBLE
ufunc_gdtrib_types[6] = <char>NPY_DOUBLE
ufunc_gdtrib_types[7] = <char>NPY_DOUBLE
ufunc_gdtrib_ptr[2*0] = <void*>_func_cdfgam3_wrap
ufunc_gdtrib_ptr[2*0+1] = <void*>(<char*>"gdtrib")
ufunc_gdtrib_ptr[2*1] = <void*>_func_cdfgam3_wrap
ufunc_gdtrib_ptr[2*1+1] = <void*>(<char*>"gdtrib")
ufunc_gdtrib_data[0] = &ufunc_gdtrib_ptr[2*0]
ufunc_gdtrib_data[1] = &ufunc_gdtrib_ptr[2*1]
gdtrib = np.PyUFunc_FromFuncAndData(ufunc_gdtrib_loops, ufunc_gdtrib_data, ufunc_gdtrib_types, 2, 3, 1, 0, "gdtrib", ufunc_gdtrib_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_gdtrix_loops[2]
cdef void *ufunc_gdtrix_ptr[4]
cdef void *ufunc_gdtrix_data[2]
cdef char ufunc_gdtrix_types[8]
cdef char *ufunc_gdtrix_doc = (
    "gdtrix(a, b, p, out=None)\n"
    "\n"
    "Inverse with respect to `x` of `gdtr(a, b, x)`.\n"
    "\n"
    "`x = gdtrix(a, b, p)` returns the inverse with respect to the parameter `x`\n"
    "of `p = gdtr(a, b, x)`, the cumulative distribution function of the gamma\n"
    "distribution. This is also known as the p'th quantile of the distribution.\n"
    "\n"
    "Parameters\n"
    "----------\n"
    "a : array_like\n"
    "    `a` parameter values of `gdtr(a, b, x)`.  `1/a` is the \"scale\"\n"
    "    parameter of the gamma distribution.\n"
    "b : array_like\n"
    "    `b` parameter values of `gdtr(a, b, x)`.  `b` is the \"shape\" parameter\n"
    "    of the gamma distribution.\n"
    "p : array_like\n"
    "    Probability values.\n"
    "out : ndarray, optional\n"
    "    If a fourth argument is given, it must be a numpy.ndarray whose size\n"
    "    matches the broadcast result of `a`, `b` and `x`.  `out` is then the\n"
    "    array returned by the function.\n"
    "\n"
    "Returns\n"
    "-------\n"
    "x : ndarray\n"
    "    Values of the `x` parameter such that `p = gdtr(a, b, x)`.\n"
    "\n"
    "See Also\n"
    "--------\n"
    "gdtr : CDF of the gamma distribution.\n"
    "gdtria : Inverse with respect to `a` of `gdtr(a, b, x)`.\n"
    "gdtrib : Inverse with respect to `b` of `gdtr(a, b, x)`.\n"
    "\n"
    "Examples\n"
    "--------\n"
    "First evaluate `gdtr`.\n"
    "\n"
    ">>> p = gdtr(1.2, 3.4, 5.6)\n"
    ">>> print(p)\n"
    "0.94378087442\n"
    "\n"
    "Verify the inverse.\n"
    "\n"
    ">>> gdtrix(1.2, 3.4, p)\n"
    "5.5999999999999996")
ufunc_gdtrix_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_gdtrix_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_gdtrix_types[0] = <char>NPY_FLOAT
ufunc_gdtrix_types[1] = <char>NPY_FLOAT
ufunc_gdtrix_types[2] = <char>NPY_FLOAT
ufunc_gdtrix_types[3] = <char>NPY_FLOAT
ufunc_gdtrix_types[4] = <char>NPY_DOUBLE
ufunc_gdtrix_types[5] = <char>NPY_DOUBLE
ufunc_gdtrix_types[6] = <char>NPY_DOUBLE
ufunc_gdtrix_types[7] = <char>NPY_DOUBLE
ufunc_gdtrix_ptr[2*0] = <void*>_func_cdfgam2_wrap
ufunc_gdtrix_ptr[2*0+1] = <void*>(<char*>"gdtrix")
ufunc_gdtrix_ptr[2*1] = <void*>_func_cdfgam2_wrap
ufunc_gdtrix_ptr[2*1+1] = <void*>(<char*>"gdtrix")
ufunc_gdtrix_data[0] = &ufunc_gdtrix_ptr[2*0]
ufunc_gdtrix_data[1] = &ufunc_gdtrix_ptr[2*1]
gdtrix = np.PyUFunc_FromFuncAndData(ufunc_gdtrix_loops, ufunc_gdtrix_data, ufunc_gdtrix_types, 2, 3, 1, 0, "gdtrix", ufunc_gdtrix_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_hankel1_loops[2]
cdef void *ufunc_hankel1_ptr[4]
cdef void *ufunc_hankel1_data[2]
cdef char ufunc_hankel1_types[6]
cdef char *ufunc_hankel1_doc = (
    "y=hankel1(v,z) returns the Hankel function of the first kind for real order v and complex argument z.")
ufunc_hankel1_loops[0] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_hankel1_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_hankel1_types[0] = <char>NPY_FLOAT
ufunc_hankel1_types[1] = <char>NPY_CFLOAT
ufunc_hankel1_types[2] = <char>NPY_CFLOAT
ufunc_hankel1_types[3] = <char>NPY_DOUBLE
ufunc_hankel1_types[4] = <char>NPY_CDOUBLE
ufunc_hankel1_types[5] = <char>NPY_CDOUBLE
ufunc_hankel1_ptr[2*0] = <void*>_func_cbesh_wrap1
ufunc_hankel1_ptr[2*0+1] = <void*>(<char*>"hankel1")
ufunc_hankel1_ptr[2*1] = <void*>_func_cbesh_wrap1
ufunc_hankel1_ptr[2*1+1] = <void*>(<char*>"hankel1")
ufunc_hankel1_data[0] = &ufunc_hankel1_ptr[2*0]
ufunc_hankel1_data[1] = &ufunc_hankel1_ptr[2*1]
hankel1 = np.PyUFunc_FromFuncAndData(ufunc_hankel1_loops, ufunc_hankel1_data, ufunc_hankel1_types, 2, 2, 1, 0, "hankel1", ufunc_hankel1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_hankel1e_loops[2]
cdef void *ufunc_hankel1e_ptr[4]
cdef void *ufunc_hankel1e_data[2]
cdef char ufunc_hankel1e_types[6]
cdef char *ufunc_hankel1e_doc = (
    "y=hankel1e(v,z) returns the exponentially scaled Hankel function of the first\n"
    "kind for real order v and complex argument z:\n"
    "hankel1e(v,z) = hankel1(v,z) * exp(-1j * z)")
ufunc_hankel1e_loops[0] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_hankel1e_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_hankel1e_types[0] = <char>NPY_FLOAT
ufunc_hankel1e_types[1] = <char>NPY_CFLOAT
ufunc_hankel1e_types[2] = <char>NPY_CFLOAT
ufunc_hankel1e_types[3] = <char>NPY_DOUBLE
ufunc_hankel1e_types[4] = <char>NPY_CDOUBLE
ufunc_hankel1e_types[5] = <char>NPY_CDOUBLE
ufunc_hankel1e_ptr[2*0] = <void*>_func_cbesh_wrap1_e
ufunc_hankel1e_ptr[2*0+1] = <void*>(<char*>"hankel1e")
ufunc_hankel1e_ptr[2*1] = <void*>_func_cbesh_wrap1_e
ufunc_hankel1e_ptr[2*1+1] = <void*>(<char*>"hankel1e")
ufunc_hankel1e_data[0] = &ufunc_hankel1e_ptr[2*0]
ufunc_hankel1e_data[1] = &ufunc_hankel1e_ptr[2*1]
hankel1e = np.PyUFunc_FromFuncAndData(ufunc_hankel1e_loops, ufunc_hankel1e_data, ufunc_hankel1e_types, 2, 2, 1, 0, "hankel1e", ufunc_hankel1e_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_hankel2_loops[2]
cdef void *ufunc_hankel2_ptr[4]
cdef void *ufunc_hankel2_data[2]
cdef char ufunc_hankel2_types[6]
cdef char *ufunc_hankel2_doc = (
    "y=hankel2(v,z) returns the Hankel function of the second kind for real order v and complex argument z.")
ufunc_hankel2_loops[0] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_hankel2_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_hankel2_types[0] = <char>NPY_FLOAT
ufunc_hankel2_types[1] = <char>NPY_CFLOAT
ufunc_hankel2_types[2] = <char>NPY_CFLOAT
ufunc_hankel2_types[3] = <char>NPY_DOUBLE
ufunc_hankel2_types[4] = <char>NPY_CDOUBLE
ufunc_hankel2_types[5] = <char>NPY_CDOUBLE
ufunc_hankel2_ptr[2*0] = <void*>_func_cbesh_wrap2
ufunc_hankel2_ptr[2*0+1] = <void*>(<char*>"hankel2")
ufunc_hankel2_ptr[2*1] = <void*>_func_cbesh_wrap2
ufunc_hankel2_ptr[2*1+1] = <void*>(<char*>"hankel2")
ufunc_hankel2_data[0] = &ufunc_hankel2_ptr[2*0]
ufunc_hankel2_data[1] = &ufunc_hankel2_ptr[2*1]
hankel2 = np.PyUFunc_FromFuncAndData(ufunc_hankel2_loops, ufunc_hankel2_data, ufunc_hankel2_types, 2, 2, 1, 0, "hankel2", ufunc_hankel2_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_hankel2e_loops[2]
cdef void *ufunc_hankel2e_ptr[4]
cdef void *ufunc_hankel2e_data[2]
cdef char ufunc_hankel2e_types[6]
cdef char *ufunc_hankel2e_doc = (
    "y=hankel2e(v,z) returns the exponentially scaled Hankel function of the second\n"
    "kind for real order v and complex argument z:\n"
    "hankel1e(v,z) = hankel1(v,z) * exp(1j * z)")
ufunc_hankel2e_loops[0] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_hankel2e_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_hankel2e_types[0] = <char>NPY_FLOAT
ufunc_hankel2e_types[1] = <char>NPY_CFLOAT
ufunc_hankel2e_types[2] = <char>NPY_CFLOAT
ufunc_hankel2e_types[3] = <char>NPY_DOUBLE
ufunc_hankel2e_types[4] = <char>NPY_CDOUBLE
ufunc_hankel2e_types[5] = <char>NPY_CDOUBLE
ufunc_hankel2e_ptr[2*0] = <void*>_func_cbesh_wrap2_e
ufunc_hankel2e_ptr[2*0+1] = <void*>(<char*>"hankel2e")
ufunc_hankel2e_ptr[2*1] = <void*>_func_cbesh_wrap2_e
ufunc_hankel2e_ptr[2*1+1] = <void*>(<char*>"hankel2e")
ufunc_hankel2e_data[0] = &ufunc_hankel2e_ptr[2*0]
ufunc_hankel2e_data[1] = &ufunc_hankel2e_ptr[2*1]
hankel2e = np.PyUFunc_FromFuncAndData(ufunc_hankel2e_loops, ufunc_hankel2e_data, ufunc_hankel2e_types, 2, 2, 1, 0, "hankel2e", ufunc_hankel2e_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_hyp1f1_loops[4]
cdef void *ufunc_hyp1f1_ptr[8]
cdef void *ufunc_hyp1f1_data[4]
cdef char ufunc_hyp1f1_types[16]
cdef char *ufunc_hyp1f1_doc = (
    "y=hyp1f1(a,b,x) returns the confluent hypergeometeric function\n"
    "( 1F1(a,b;x) ) evaluated at the values a, b, and x.")
ufunc_hyp1f1_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_hyp1f1_loops[1] = <np.PyUFuncGenericFunction>loop_D_ddD__As_ffF_F
ufunc_hyp1f1_loops[2] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_hyp1f1_loops[3] = <np.PyUFuncGenericFunction>loop_D_ddD__As_ddD_D
ufunc_hyp1f1_types[0] = <char>NPY_FLOAT
ufunc_hyp1f1_types[1] = <char>NPY_FLOAT
ufunc_hyp1f1_types[2] = <char>NPY_FLOAT
ufunc_hyp1f1_types[3] = <char>NPY_FLOAT
ufunc_hyp1f1_types[4] = <char>NPY_FLOAT
ufunc_hyp1f1_types[5] = <char>NPY_FLOAT
ufunc_hyp1f1_types[6] = <char>NPY_CFLOAT
ufunc_hyp1f1_types[7] = <char>NPY_CFLOAT
ufunc_hyp1f1_types[8] = <char>NPY_DOUBLE
ufunc_hyp1f1_types[9] = <char>NPY_DOUBLE
ufunc_hyp1f1_types[10] = <char>NPY_DOUBLE
ufunc_hyp1f1_types[11] = <char>NPY_DOUBLE
ufunc_hyp1f1_types[12] = <char>NPY_DOUBLE
ufunc_hyp1f1_types[13] = <char>NPY_DOUBLE
ufunc_hyp1f1_types[14] = <char>NPY_CDOUBLE
ufunc_hyp1f1_types[15] = <char>NPY_CDOUBLE
ufunc_hyp1f1_ptr[2*0] = <void*>_func_hyp1f1_wrap
ufunc_hyp1f1_ptr[2*0+1] = <void*>(<char*>"hyp1f1")
ufunc_hyp1f1_ptr[2*1] = <void*>_func_chyp1f1_wrap
ufunc_hyp1f1_ptr[2*1+1] = <void*>(<char*>"hyp1f1")
ufunc_hyp1f1_ptr[2*2] = <void*>_func_hyp1f1_wrap
ufunc_hyp1f1_ptr[2*2+1] = <void*>(<char*>"hyp1f1")
ufunc_hyp1f1_ptr[2*3] = <void*>_func_chyp1f1_wrap
ufunc_hyp1f1_ptr[2*3+1] = <void*>(<char*>"hyp1f1")
ufunc_hyp1f1_data[0] = &ufunc_hyp1f1_ptr[2*0]
ufunc_hyp1f1_data[1] = &ufunc_hyp1f1_ptr[2*1]
ufunc_hyp1f1_data[2] = &ufunc_hyp1f1_ptr[2*2]
ufunc_hyp1f1_data[3] = &ufunc_hyp1f1_ptr[2*3]
hyp1f1 = np.PyUFunc_FromFuncAndData(ufunc_hyp1f1_loops, ufunc_hyp1f1_data, ufunc_hyp1f1_types, 4, 3, 1, 0, "hyp1f1", ufunc_hyp1f1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_hyp1f2_loops[2]
cdef void *ufunc_hyp1f2_ptr[4]
cdef void *ufunc_hyp1f2_data[2]
cdef char ufunc_hyp1f2_types[12]
cdef char *ufunc_hyp1f2_doc = (
    "(y,err)=hyp1f2(a,b,c,x) returns (y,err) with the hypergeometric function 1F2 in y and an error estimate in err.")
ufunc_hyp1f2_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_ffff_ff
ufunc_hyp1f2_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_dddd_dd
ufunc_hyp1f2_types[0] = <char>NPY_FLOAT
ufunc_hyp1f2_types[1] = <char>NPY_FLOAT
ufunc_hyp1f2_types[2] = <char>NPY_FLOAT
ufunc_hyp1f2_types[3] = <char>NPY_FLOAT
ufunc_hyp1f2_types[4] = <char>NPY_FLOAT
ufunc_hyp1f2_types[5] = <char>NPY_FLOAT
ufunc_hyp1f2_types[6] = <char>NPY_DOUBLE
ufunc_hyp1f2_types[7] = <char>NPY_DOUBLE
ufunc_hyp1f2_types[8] = <char>NPY_DOUBLE
ufunc_hyp1f2_types[9] = <char>NPY_DOUBLE
ufunc_hyp1f2_types[10] = <char>NPY_DOUBLE
ufunc_hyp1f2_types[11] = <char>NPY_DOUBLE
ufunc_hyp1f2_ptr[2*0] = <void*>_func_onef2
ufunc_hyp1f2_ptr[2*0+1] = <void*>(<char*>"hyp1f2")
ufunc_hyp1f2_ptr[2*1] = <void*>_func_onef2
ufunc_hyp1f2_ptr[2*1+1] = <void*>(<char*>"hyp1f2")
ufunc_hyp1f2_data[0] = &ufunc_hyp1f2_ptr[2*0]
ufunc_hyp1f2_data[1] = &ufunc_hyp1f2_ptr[2*1]
hyp1f2 = np.PyUFunc_FromFuncAndData(ufunc_hyp1f2_loops, ufunc_hyp1f2_data, ufunc_hyp1f2_types, 2, 4, 2, 0, "hyp1f2", ufunc_hyp1f2_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_hyp2f0_loops[4]
cdef void *ufunc_hyp2f0_ptr[8]
cdef void *ufunc_hyp2f0_data[4]
cdef char ufunc_hyp2f0_types[24]
cdef char *ufunc_hyp2f0_doc = (
    "(y,err)=hyp2f0(a,b,x,type) returns (y,err) with the hypergeometric function 2F0 in y and an error estimate in err.  The input type determines a convergence factor and\n"
    "can be either 1 or 2.")
ufunc_hyp2f0_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddi_d_As_fffl_ff
ufunc_hyp2f0_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_ffff_ff
ufunc_hyp2f0_loops[2] = <np.PyUFuncGenericFunction>loop_d_dddi_d_As_dddl_dd
ufunc_hyp2f0_loops[3] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_dddd_dd
ufunc_hyp2f0_types[0] = <char>NPY_FLOAT
ufunc_hyp2f0_types[1] = <char>NPY_FLOAT
ufunc_hyp2f0_types[2] = <char>NPY_FLOAT
ufunc_hyp2f0_types[3] = <char>NPY_LONG
ufunc_hyp2f0_types[4] = <char>NPY_FLOAT
ufunc_hyp2f0_types[5] = <char>NPY_FLOAT
ufunc_hyp2f0_types[6] = <char>NPY_FLOAT
ufunc_hyp2f0_types[7] = <char>NPY_FLOAT
ufunc_hyp2f0_types[8] = <char>NPY_FLOAT
ufunc_hyp2f0_types[9] = <char>NPY_FLOAT
ufunc_hyp2f0_types[10] = <char>NPY_FLOAT
ufunc_hyp2f0_types[11] = <char>NPY_FLOAT
ufunc_hyp2f0_types[12] = <char>NPY_DOUBLE
ufunc_hyp2f0_types[13] = <char>NPY_DOUBLE
ufunc_hyp2f0_types[14] = <char>NPY_DOUBLE
ufunc_hyp2f0_types[15] = <char>NPY_LONG
ufunc_hyp2f0_types[16] = <char>NPY_DOUBLE
ufunc_hyp2f0_types[17] = <char>NPY_DOUBLE
ufunc_hyp2f0_types[18] = <char>NPY_DOUBLE
ufunc_hyp2f0_types[19] = <char>NPY_DOUBLE
ufunc_hyp2f0_types[20] = <char>NPY_DOUBLE
ufunc_hyp2f0_types[21] = <char>NPY_DOUBLE
ufunc_hyp2f0_types[22] = <char>NPY_DOUBLE
ufunc_hyp2f0_types[23] = <char>NPY_DOUBLE
ufunc_hyp2f0_ptr[2*0] = <void*>_func_hyp2f0
ufunc_hyp2f0_ptr[2*0+1] = <void*>(<char*>"hyp2f0")
ufunc_hyp2f0_ptr[2*1] = <void*>_func_hyp2f0_unsafe
ufunc_hyp2f0_ptr[2*1+1] = <void*>(<char*>"hyp2f0")
ufunc_hyp2f0_ptr[2*2] = <void*>_func_hyp2f0
ufunc_hyp2f0_ptr[2*2+1] = <void*>(<char*>"hyp2f0")
ufunc_hyp2f0_ptr[2*3] = <void*>_func_hyp2f0_unsafe
ufunc_hyp2f0_ptr[2*3+1] = <void*>(<char*>"hyp2f0")
ufunc_hyp2f0_data[0] = &ufunc_hyp2f0_ptr[2*0]
ufunc_hyp2f0_data[1] = &ufunc_hyp2f0_ptr[2*1]
ufunc_hyp2f0_data[2] = &ufunc_hyp2f0_ptr[2*2]
ufunc_hyp2f0_data[3] = &ufunc_hyp2f0_ptr[2*3]
hyp2f0 = np.PyUFunc_FromFuncAndData(ufunc_hyp2f0_loops, ufunc_hyp2f0_data, ufunc_hyp2f0_types, 4, 4, 2, 0, "hyp2f0", ufunc_hyp2f0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_hyp2f1_loops[4]
cdef void *ufunc_hyp2f1_ptr[8]
cdef void *ufunc_hyp2f1_data[4]
cdef char ufunc_hyp2f1_types[20]
cdef char *ufunc_hyp2f1_doc = (
    "y=hyp2f1(a,b,c,z) returns the Gauss hypergeometric function\n"
    "( 2F1(a,b;c;z) ).")
ufunc_hyp2f1_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd__As_ffff_f
ufunc_hyp2f1_loops[1] = <np.PyUFuncGenericFunction>loop_D_dddD__As_fffF_F
ufunc_hyp2f1_loops[2] = <np.PyUFuncGenericFunction>loop_d_dddd__As_dddd_d
ufunc_hyp2f1_loops[3] = <np.PyUFuncGenericFunction>loop_D_dddD__As_dddD_D
ufunc_hyp2f1_types[0] = <char>NPY_FLOAT
ufunc_hyp2f1_types[1] = <char>NPY_FLOAT
ufunc_hyp2f1_types[2] = <char>NPY_FLOAT
ufunc_hyp2f1_types[3] = <char>NPY_FLOAT
ufunc_hyp2f1_types[4] = <char>NPY_FLOAT
ufunc_hyp2f1_types[5] = <char>NPY_FLOAT
ufunc_hyp2f1_types[6] = <char>NPY_FLOAT
ufunc_hyp2f1_types[7] = <char>NPY_FLOAT
ufunc_hyp2f1_types[8] = <char>NPY_CFLOAT
ufunc_hyp2f1_types[9] = <char>NPY_CFLOAT
ufunc_hyp2f1_types[10] = <char>NPY_DOUBLE
ufunc_hyp2f1_types[11] = <char>NPY_DOUBLE
ufunc_hyp2f1_types[12] = <char>NPY_DOUBLE
ufunc_hyp2f1_types[13] = <char>NPY_DOUBLE
ufunc_hyp2f1_types[14] = <char>NPY_DOUBLE
ufunc_hyp2f1_types[15] = <char>NPY_DOUBLE
ufunc_hyp2f1_types[16] = <char>NPY_DOUBLE
ufunc_hyp2f1_types[17] = <char>NPY_DOUBLE
ufunc_hyp2f1_types[18] = <char>NPY_CDOUBLE
ufunc_hyp2f1_types[19] = <char>NPY_CDOUBLE
ufunc_hyp2f1_ptr[2*0] = <void*>_func_hyp2f1
ufunc_hyp2f1_ptr[2*0+1] = <void*>(<char*>"hyp2f1")
ufunc_hyp2f1_ptr[2*1] = <void*>_func_chyp2f1_wrap
ufunc_hyp2f1_ptr[2*1+1] = <void*>(<char*>"hyp2f1")
ufunc_hyp2f1_ptr[2*2] = <void*>_func_hyp2f1
ufunc_hyp2f1_ptr[2*2+1] = <void*>(<char*>"hyp2f1")
ufunc_hyp2f1_ptr[2*3] = <void*>_func_chyp2f1_wrap
ufunc_hyp2f1_ptr[2*3+1] = <void*>(<char*>"hyp2f1")
ufunc_hyp2f1_data[0] = &ufunc_hyp2f1_ptr[2*0]
ufunc_hyp2f1_data[1] = &ufunc_hyp2f1_ptr[2*1]
ufunc_hyp2f1_data[2] = &ufunc_hyp2f1_ptr[2*2]
ufunc_hyp2f1_data[3] = &ufunc_hyp2f1_ptr[2*3]
hyp2f1 = np.PyUFunc_FromFuncAndData(ufunc_hyp2f1_loops, ufunc_hyp2f1_data, ufunc_hyp2f1_types, 4, 4, 1, 0, "hyp2f1", ufunc_hyp2f1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_hyp3f0_loops[2]
cdef void *ufunc_hyp3f0_ptr[4]
cdef void *ufunc_hyp3f0_data[2]
cdef char ufunc_hyp3f0_types[12]
cdef char *ufunc_hyp3f0_doc = (
    "(y,err)=hyp3f0(a,b,c,x) returns (y,err) with the hypergeometric function 3F0 in y and an error estimate in err.")
ufunc_hyp3f0_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_ffff_ff
ufunc_hyp3f0_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_dddd_dd
ufunc_hyp3f0_types[0] = <char>NPY_FLOAT
ufunc_hyp3f0_types[1] = <char>NPY_FLOAT
ufunc_hyp3f0_types[2] = <char>NPY_FLOAT
ufunc_hyp3f0_types[3] = <char>NPY_FLOAT
ufunc_hyp3f0_types[4] = <char>NPY_FLOAT
ufunc_hyp3f0_types[5] = <char>NPY_FLOAT
ufunc_hyp3f0_types[6] = <char>NPY_DOUBLE
ufunc_hyp3f0_types[7] = <char>NPY_DOUBLE
ufunc_hyp3f0_types[8] = <char>NPY_DOUBLE
ufunc_hyp3f0_types[9] = <char>NPY_DOUBLE
ufunc_hyp3f0_types[10] = <char>NPY_DOUBLE
ufunc_hyp3f0_types[11] = <char>NPY_DOUBLE
ufunc_hyp3f0_ptr[2*0] = <void*>_func_threef0
ufunc_hyp3f0_ptr[2*0+1] = <void*>(<char*>"hyp3f0")
ufunc_hyp3f0_ptr[2*1] = <void*>_func_threef0
ufunc_hyp3f0_ptr[2*1+1] = <void*>(<char*>"hyp3f0")
ufunc_hyp3f0_data[0] = &ufunc_hyp3f0_ptr[2*0]
ufunc_hyp3f0_data[1] = &ufunc_hyp3f0_ptr[2*1]
hyp3f0 = np.PyUFunc_FromFuncAndData(ufunc_hyp3f0_loops, ufunc_hyp3f0_data, ufunc_hyp3f0_types, 2, 4, 2, 0, "hyp3f0", ufunc_hyp3f0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_hyperu_loops[2]
cdef void *ufunc_hyperu_ptr[4]
cdef void *ufunc_hyperu_data[2]
cdef char ufunc_hyperu_types[8]
cdef char *ufunc_hyperu_doc = (
    "y=hyperu(a,b,x) returns the confluent hypergeometric function of the\n"
    "second kind U(a,b,x).")
ufunc_hyperu_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_hyperu_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_hyperu_types[0] = <char>NPY_FLOAT
ufunc_hyperu_types[1] = <char>NPY_FLOAT
ufunc_hyperu_types[2] = <char>NPY_FLOAT
ufunc_hyperu_types[3] = <char>NPY_FLOAT
ufunc_hyperu_types[4] = <char>NPY_DOUBLE
ufunc_hyperu_types[5] = <char>NPY_DOUBLE
ufunc_hyperu_types[6] = <char>NPY_DOUBLE
ufunc_hyperu_types[7] = <char>NPY_DOUBLE
ufunc_hyperu_ptr[2*0] = <void*>_func_hypU_wrap
ufunc_hyperu_ptr[2*0+1] = <void*>(<char*>"hyperu")
ufunc_hyperu_ptr[2*1] = <void*>_func_hypU_wrap
ufunc_hyperu_ptr[2*1+1] = <void*>(<char*>"hyperu")
ufunc_hyperu_data[0] = &ufunc_hyperu_ptr[2*0]
ufunc_hyperu_data[1] = &ufunc_hyperu_ptr[2*1]
hyperu = np.PyUFunc_FromFuncAndData(ufunc_hyperu_loops, ufunc_hyperu_data, ufunc_hyperu_types, 2, 3, 1, 0, "hyperu", ufunc_hyperu_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_i0_loops[2]
cdef void *ufunc_i0_ptr[4]
cdef void *ufunc_i0_data[2]
cdef char ufunc_i0_types[4]
cdef char *ufunc_i0_doc = (
    "y=i0(x) returns the modified Bessel function of order 0 at x.")
ufunc_i0_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_i0_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_i0_types[0] = <char>NPY_FLOAT
ufunc_i0_types[1] = <char>NPY_FLOAT
ufunc_i0_types[2] = <char>NPY_DOUBLE
ufunc_i0_types[3] = <char>NPY_DOUBLE
ufunc_i0_ptr[2*0] = <void*>_func_i0
ufunc_i0_ptr[2*0+1] = <void*>(<char*>"i0")
ufunc_i0_ptr[2*1] = <void*>_func_i0
ufunc_i0_ptr[2*1+1] = <void*>(<char*>"i0")
ufunc_i0_data[0] = &ufunc_i0_ptr[2*0]
ufunc_i0_data[1] = &ufunc_i0_ptr[2*1]
i0 = np.PyUFunc_FromFuncAndData(ufunc_i0_loops, ufunc_i0_data, ufunc_i0_types, 2, 1, 1, 0, "i0", ufunc_i0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_i0e_loops[2]
cdef void *ufunc_i0e_ptr[4]
cdef void *ufunc_i0e_data[2]
cdef char ufunc_i0e_types[4]
cdef char *ufunc_i0e_doc = (
    "y=i0e(x) returns the exponentially scaled modified Bessel function\n"
    "of order 0 at x.  i0e(x) = exp(-abs(x)) * i0(x).")
ufunc_i0e_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_i0e_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_i0e_types[0] = <char>NPY_FLOAT
ufunc_i0e_types[1] = <char>NPY_FLOAT
ufunc_i0e_types[2] = <char>NPY_DOUBLE
ufunc_i0e_types[3] = <char>NPY_DOUBLE
ufunc_i0e_ptr[2*0] = <void*>_func_i0e
ufunc_i0e_ptr[2*0+1] = <void*>(<char*>"i0e")
ufunc_i0e_ptr[2*1] = <void*>_func_i0e
ufunc_i0e_ptr[2*1+1] = <void*>(<char*>"i0e")
ufunc_i0e_data[0] = &ufunc_i0e_ptr[2*0]
ufunc_i0e_data[1] = &ufunc_i0e_ptr[2*1]
i0e = np.PyUFunc_FromFuncAndData(ufunc_i0e_loops, ufunc_i0e_data, ufunc_i0e_types, 2, 1, 1, 0, "i0e", ufunc_i0e_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_i1_loops[2]
cdef void *ufunc_i1_ptr[4]
cdef void *ufunc_i1_data[2]
cdef char ufunc_i1_types[4]
cdef char *ufunc_i1_doc = (
    "y=i1(x) returns the modified Bessel function of order 1 at x.")
ufunc_i1_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_i1_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_i1_types[0] = <char>NPY_FLOAT
ufunc_i1_types[1] = <char>NPY_FLOAT
ufunc_i1_types[2] = <char>NPY_DOUBLE
ufunc_i1_types[3] = <char>NPY_DOUBLE
ufunc_i1_ptr[2*0] = <void*>_func_i1
ufunc_i1_ptr[2*0+1] = <void*>(<char*>"i1")
ufunc_i1_ptr[2*1] = <void*>_func_i1
ufunc_i1_ptr[2*1+1] = <void*>(<char*>"i1")
ufunc_i1_data[0] = &ufunc_i1_ptr[2*0]
ufunc_i1_data[1] = &ufunc_i1_ptr[2*1]
i1 = np.PyUFunc_FromFuncAndData(ufunc_i1_loops, ufunc_i1_data, ufunc_i1_types, 2, 1, 1, 0, "i1", ufunc_i1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_i1e_loops[2]
cdef void *ufunc_i1e_ptr[4]
cdef void *ufunc_i1e_data[2]
cdef char ufunc_i1e_types[4]
cdef char *ufunc_i1e_doc = (
    "y=i1e(x) returns the exponentially scaled modified Bessel function\n"
    "of order 0 at x.  i1e(x) = exp(-abs(x)) * i1(x).")
ufunc_i1e_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_i1e_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_i1e_types[0] = <char>NPY_FLOAT
ufunc_i1e_types[1] = <char>NPY_FLOAT
ufunc_i1e_types[2] = <char>NPY_DOUBLE
ufunc_i1e_types[3] = <char>NPY_DOUBLE
ufunc_i1e_ptr[2*0] = <void*>_func_i1e
ufunc_i1e_ptr[2*0+1] = <void*>(<char*>"i1e")
ufunc_i1e_ptr[2*1] = <void*>_func_i1e
ufunc_i1e_ptr[2*1+1] = <void*>(<char*>"i1e")
ufunc_i1e_data[0] = &ufunc_i1e_ptr[2*0]
ufunc_i1e_data[1] = &ufunc_i1e_ptr[2*1]
i1e = np.PyUFunc_FromFuncAndData(ufunc_i1e_loops, ufunc_i1e_data, ufunc_i1e_types, 2, 1, 1, 0, "i1e", ufunc_i1e_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_it2i0k0_loops[2]
cdef void *ufunc_it2i0k0_ptr[4]
cdef void *ufunc_it2i0k0_data[2]
cdef char ufunc_it2i0k0_types[6]
cdef char *ufunc_it2i0k0_doc = (
    "(ii0,ik0)=it2i0k0(x) returns the integrals int((i0(t)-1)/t,t=0..x) and\n"
    "int(k0(t)/t,t=x..infinitity).")
ufunc_it2i0k0_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_f_ff
ufunc_it2i0k0_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_d_dd
ufunc_it2i0k0_types[0] = <char>NPY_FLOAT
ufunc_it2i0k0_types[1] = <char>NPY_FLOAT
ufunc_it2i0k0_types[2] = <char>NPY_FLOAT
ufunc_it2i0k0_types[3] = <char>NPY_DOUBLE
ufunc_it2i0k0_types[4] = <char>NPY_DOUBLE
ufunc_it2i0k0_types[5] = <char>NPY_DOUBLE
ufunc_it2i0k0_ptr[2*0] = <void*>_func_it2i0k0_wrap
ufunc_it2i0k0_ptr[2*0+1] = <void*>(<char*>"it2i0k0")
ufunc_it2i0k0_ptr[2*1] = <void*>_func_it2i0k0_wrap
ufunc_it2i0k0_ptr[2*1+1] = <void*>(<char*>"it2i0k0")
ufunc_it2i0k0_data[0] = &ufunc_it2i0k0_ptr[2*0]
ufunc_it2i0k0_data[1] = &ufunc_it2i0k0_ptr[2*1]
it2i0k0 = np.PyUFunc_FromFuncAndData(ufunc_it2i0k0_loops, ufunc_it2i0k0_data, ufunc_it2i0k0_types, 2, 1, 2, 0, "it2i0k0", ufunc_it2i0k0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_it2j0y0_loops[2]
cdef void *ufunc_it2j0y0_ptr[4]
cdef void *ufunc_it2j0y0_data[2]
cdef char ufunc_it2j0y0_types[6]
cdef char *ufunc_it2j0y0_doc = (
    "(ij0,iy0)=it2j0y0(x) returns the integrals int((1-j0(t))/t,t=0..x) and\n"
    "int(y0(t)/t,t=x..infinitity).")
ufunc_it2j0y0_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_f_ff
ufunc_it2j0y0_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_d_dd
ufunc_it2j0y0_types[0] = <char>NPY_FLOAT
ufunc_it2j0y0_types[1] = <char>NPY_FLOAT
ufunc_it2j0y0_types[2] = <char>NPY_FLOAT
ufunc_it2j0y0_types[3] = <char>NPY_DOUBLE
ufunc_it2j0y0_types[4] = <char>NPY_DOUBLE
ufunc_it2j0y0_types[5] = <char>NPY_DOUBLE
ufunc_it2j0y0_ptr[2*0] = <void*>_func_it2j0y0_wrap
ufunc_it2j0y0_ptr[2*0+1] = <void*>(<char*>"it2j0y0")
ufunc_it2j0y0_ptr[2*1] = <void*>_func_it2j0y0_wrap
ufunc_it2j0y0_ptr[2*1+1] = <void*>(<char*>"it2j0y0")
ufunc_it2j0y0_data[0] = &ufunc_it2j0y0_ptr[2*0]
ufunc_it2j0y0_data[1] = &ufunc_it2j0y0_ptr[2*1]
it2j0y0 = np.PyUFunc_FromFuncAndData(ufunc_it2j0y0_loops, ufunc_it2j0y0_data, ufunc_it2j0y0_types, 2, 1, 2, 0, "it2j0y0", ufunc_it2j0y0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_it2struve0_loops[2]
cdef void *ufunc_it2struve0_ptr[4]
cdef void *ufunc_it2struve0_data[2]
cdef char ufunc_it2struve0_types[4]
cdef char *ufunc_it2struve0_doc = (
    "y=it2struve0(x) returns the integral of the Struve function of order 0\n"
    "divided by t from x to infinity:  integral(H0(t)/t, t=x..inf).")
ufunc_it2struve0_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_it2struve0_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_it2struve0_types[0] = <char>NPY_FLOAT
ufunc_it2struve0_types[1] = <char>NPY_FLOAT
ufunc_it2struve0_types[2] = <char>NPY_DOUBLE
ufunc_it2struve0_types[3] = <char>NPY_DOUBLE
ufunc_it2struve0_ptr[2*0] = <void*>_func_it2struve0_wrap
ufunc_it2struve0_ptr[2*0+1] = <void*>(<char*>"it2struve0")
ufunc_it2struve0_ptr[2*1] = <void*>_func_it2struve0_wrap
ufunc_it2struve0_ptr[2*1+1] = <void*>(<char*>"it2struve0")
ufunc_it2struve0_data[0] = &ufunc_it2struve0_ptr[2*0]
ufunc_it2struve0_data[1] = &ufunc_it2struve0_ptr[2*1]
it2struve0 = np.PyUFunc_FromFuncAndData(ufunc_it2struve0_loops, ufunc_it2struve0_data, ufunc_it2struve0_types, 2, 1, 1, 0, "it2struve0", ufunc_it2struve0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_itairy_loops[2]
cdef void *ufunc_itairy_ptr[4]
cdef void *ufunc_itairy_data[2]
cdef char ufunc_itairy_types[10]
cdef char *ufunc_itairy_doc = (
    "(Apt,Bpt,Ant,Bnt)=itairy(x) calculates the integral of Airy functions from 0 to x\n"
    "for positive (Apt, Bpt) and negative (Ant, Bnt) arguments.")
ufunc_itairy_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_dddd_As_f_ffff
ufunc_itairy_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_dddd_As_d_dddd
ufunc_itairy_types[0] = <char>NPY_FLOAT
ufunc_itairy_types[1] = <char>NPY_FLOAT
ufunc_itairy_types[2] = <char>NPY_FLOAT
ufunc_itairy_types[3] = <char>NPY_FLOAT
ufunc_itairy_types[4] = <char>NPY_FLOAT
ufunc_itairy_types[5] = <char>NPY_DOUBLE
ufunc_itairy_types[6] = <char>NPY_DOUBLE
ufunc_itairy_types[7] = <char>NPY_DOUBLE
ufunc_itairy_types[8] = <char>NPY_DOUBLE
ufunc_itairy_types[9] = <char>NPY_DOUBLE
ufunc_itairy_ptr[2*0] = <void*>_func_itairy_wrap
ufunc_itairy_ptr[2*0+1] = <void*>(<char*>"itairy")
ufunc_itairy_ptr[2*1] = <void*>_func_itairy_wrap
ufunc_itairy_ptr[2*1+1] = <void*>(<char*>"itairy")
ufunc_itairy_data[0] = &ufunc_itairy_ptr[2*0]
ufunc_itairy_data[1] = &ufunc_itairy_ptr[2*1]
itairy = np.PyUFunc_FromFuncAndData(ufunc_itairy_loops, ufunc_itairy_data, ufunc_itairy_types, 2, 1, 4, 0, "itairy", ufunc_itairy_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_iti0k0_loops[2]
cdef void *ufunc_iti0k0_ptr[4]
cdef void *ufunc_iti0k0_data[2]
cdef char ufunc_iti0k0_types[6]
cdef char *ufunc_iti0k0_doc = (
    "(ii0,ik0)=iti0k0(x) returns simple integrals from 0 to x of the zeroth order\n"
    "modified Bessel functions i0 and k0.")
ufunc_iti0k0_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_f_ff
ufunc_iti0k0_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_d_dd
ufunc_iti0k0_types[0] = <char>NPY_FLOAT
ufunc_iti0k0_types[1] = <char>NPY_FLOAT
ufunc_iti0k0_types[2] = <char>NPY_FLOAT
ufunc_iti0k0_types[3] = <char>NPY_DOUBLE
ufunc_iti0k0_types[4] = <char>NPY_DOUBLE
ufunc_iti0k0_types[5] = <char>NPY_DOUBLE
ufunc_iti0k0_ptr[2*0] = <void*>_func_it1i0k0_wrap
ufunc_iti0k0_ptr[2*0+1] = <void*>(<char*>"iti0k0")
ufunc_iti0k0_ptr[2*1] = <void*>_func_it1i0k0_wrap
ufunc_iti0k0_ptr[2*1+1] = <void*>(<char*>"iti0k0")
ufunc_iti0k0_data[0] = &ufunc_iti0k0_ptr[2*0]
ufunc_iti0k0_data[1] = &ufunc_iti0k0_ptr[2*1]
iti0k0 = np.PyUFunc_FromFuncAndData(ufunc_iti0k0_loops, ufunc_iti0k0_data, ufunc_iti0k0_types, 2, 1, 2, 0, "iti0k0", ufunc_iti0k0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_itj0y0_loops[2]
cdef void *ufunc_itj0y0_ptr[4]
cdef void *ufunc_itj0y0_data[2]
cdef char ufunc_itj0y0_types[6]
cdef char *ufunc_itj0y0_doc = (
    "(ij0,iy0)=itj0y0(x) returns simple integrals from 0 to x of the zeroth order\n"
    "Bessel functions j0 and y0.")
ufunc_itj0y0_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_f_ff
ufunc_itj0y0_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_d_dd
ufunc_itj0y0_types[0] = <char>NPY_FLOAT
ufunc_itj0y0_types[1] = <char>NPY_FLOAT
ufunc_itj0y0_types[2] = <char>NPY_FLOAT
ufunc_itj0y0_types[3] = <char>NPY_DOUBLE
ufunc_itj0y0_types[4] = <char>NPY_DOUBLE
ufunc_itj0y0_types[5] = <char>NPY_DOUBLE
ufunc_itj0y0_ptr[2*0] = <void*>_func_it1j0y0_wrap
ufunc_itj0y0_ptr[2*0+1] = <void*>(<char*>"itj0y0")
ufunc_itj0y0_ptr[2*1] = <void*>_func_it1j0y0_wrap
ufunc_itj0y0_ptr[2*1+1] = <void*>(<char*>"itj0y0")
ufunc_itj0y0_data[0] = &ufunc_itj0y0_ptr[2*0]
ufunc_itj0y0_data[1] = &ufunc_itj0y0_ptr[2*1]
itj0y0 = np.PyUFunc_FromFuncAndData(ufunc_itj0y0_loops, ufunc_itj0y0_data, ufunc_itj0y0_types, 2, 1, 2, 0, "itj0y0", ufunc_itj0y0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_itmodstruve0_loops[2]
cdef void *ufunc_itmodstruve0_ptr[4]
cdef void *ufunc_itmodstruve0_data[2]
cdef char ufunc_itmodstruve0_types[4]
cdef char *ufunc_itmodstruve0_doc = (
    "y=itmodstruve0(x) returns the integral of the modified Struve function\n"
    "of order 0 from 0 to x:  integral(L0(t), t=0..x).")
ufunc_itmodstruve0_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_itmodstruve0_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_itmodstruve0_types[0] = <char>NPY_FLOAT
ufunc_itmodstruve0_types[1] = <char>NPY_FLOAT
ufunc_itmodstruve0_types[2] = <char>NPY_DOUBLE
ufunc_itmodstruve0_types[3] = <char>NPY_DOUBLE
ufunc_itmodstruve0_ptr[2*0] = <void*>_func_itmodstruve0_wrap
ufunc_itmodstruve0_ptr[2*0+1] = <void*>(<char*>"itmodstruve0")
ufunc_itmodstruve0_ptr[2*1] = <void*>_func_itmodstruve0_wrap
ufunc_itmodstruve0_ptr[2*1+1] = <void*>(<char*>"itmodstruve0")
ufunc_itmodstruve0_data[0] = &ufunc_itmodstruve0_ptr[2*0]
ufunc_itmodstruve0_data[1] = &ufunc_itmodstruve0_ptr[2*1]
itmodstruve0 = np.PyUFunc_FromFuncAndData(ufunc_itmodstruve0_loops, ufunc_itmodstruve0_data, ufunc_itmodstruve0_types, 2, 1, 1, 0, "itmodstruve0", ufunc_itmodstruve0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_itstruve0_loops[2]
cdef void *ufunc_itstruve0_ptr[4]
cdef void *ufunc_itstruve0_data[2]
cdef char ufunc_itstruve0_types[4]
cdef char *ufunc_itstruve0_doc = (
    "y=itstruve0(x) returns the integral of the Struve function of order 0\n"
    "from 0 to x:  integral(H0(t), t=0..x).")
ufunc_itstruve0_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_itstruve0_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_itstruve0_types[0] = <char>NPY_FLOAT
ufunc_itstruve0_types[1] = <char>NPY_FLOAT
ufunc_itstruve0_types[2] = <char>NPY_DOUBLE
ufunc_itstruve0_types[3] = <char>NPY_DOUBLE
ufunc_itstruve0_ptr[2*0] = <void*>_func_itstruve0_wrap
ufunc_itstruve0_ptr[2*0+1] = <void*>(<char*>"itstruve0")
ufunc_itstruve0_ptr[2*1] = <void*>_func_itstruve0_wrap
ufunc_itstruve0_ptr[2*1+1] = <void*>(<char*>"itstruve0")
ufunc_itstruve0_data[0] = &ufunc_itstruve0_ptr[2*0]
ufunc_itstruve0_data[1] = &ufunc_itstruve0_ptr[2*1]
itstruve0 = np.PyUFunc_FromFuncAndData(ufunc_itstruve0_loops, ufunc_itstruve0_data, ufunc_itstruve0_types, 2, 1, 1, 0, "itstruve0", ufunc_itstruve0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_iv_loops[4]
cdef void *ufunc_iv_ptr[8]
cdef void *ufunc_iv_data[4]
cdef char ufunc_iv_types[12]
cdef char *ufunc_iv_doc = (
    "y=iv(v,z) returns the modified Bessel function of real order v of\n"
    "z.  If z is of real type and negative, v must be integer valued.")
ufunc_iv_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_iv_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_iv_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_iv_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_iv_types[0] = <char>NPY_FLOAT
ufunc_iv_types[1] = <char>NPY_FLOAT
ufunc_iv_types[2] = <char>NPY_FLOAT
ufunc_iv_types[3] = <char>NPY_FLOAT
ufunc_iv_types[4] = <char>NPY_CFLOAT
ufunc_iv_types[5] = <char>NPY_CFLOAT
ufunc_iv_types[6] = <char>NPY_DOUBLE
ufunc_iv_types[7] = <char>NPY_DOUBLE
ufunc_iv_types[8] = <char>NPY_DOUBLE
ufunc_iv_types[9] = <char>NPY_DOUBLE
ufunc_iv_types[10] = <char>NPY_CDOUBLE
ufunc_iv_types[11] = <char>NPY_CDOUBLE
ufunc_iv_ptr[2*0] = <void*>_func_iv
ufunc_iv_ptr[2*0+1] = <void*>(<char*>"iv")
ufunc_iv_ptr[2*1] = <void*>_func_cbesi_wrap
ufunc_iv_ptr[2*1+1] = <void*>(<char*>"iv")
ufunc_iv_ptr[2*2] = <void*>_func_iv
ufunc_iv_ptr[2*2+1] = <void*>(<char*>"iv")
ufunc_iv_ptr[2*3] = <void*>_func_cbesi_wrap
ufunc_iv_ptr[2*3+1] = <void*>(<char*>"iv")
ufunc_iv_data[0] = &ufunc_iv_ptr[2*0]
ufunc_iv_data[1] = &ufunc_iv_ptr[2*1]
ufunc_iv_data[2] = &ufunc_iv_ptr[2*2]
ufunc_iv_data[3] = &ufunc_iv_ptr[2*3]
iv = np.PyUFunc_FromFuncAndData(ufunc_iv_loops, ufunc_iv_data, ufunc_iv_types, 4, 2, 1, 0, "iv", ufunc_iv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ive_loops[4]
cdef void *ufunc_ive_ptr[8]
cdef void *ufunc_ive_data[4]
cdef char ufunc_ive_types[12]
cdef char *ufunc_ive_doc = (
    "y=ive(v,z) returns the exponentially scaled modified Bessel function of\n"
    "real order v and complex z: ive(v,z) = iv(v,z) * exp(-abs(z.real))")
ufunc_ive_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_ive_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_ive_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_ive_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_ive_types[0] = <char>NPY_FLOAT
ufunc_ive_types[1] = <char>NPY_FLOAT
ufunc_ive_types[2] = <char>NPY_FLOAT
ufunc_ive_types[3] = <char>NPY_FLOAT
ufunc_ive_types[4] = <char>NPY_CFLOAT
ufunc_ive_types[5] = <char>NPY_CFLOAT
ufunc_ive_types[6] = <char>NPY_DOUBLE
ufunc_ive_types[7] = <char>NPY_DOUBLE
ufunc_ive_types[8] = <char>NPY_DOUBLE
ufunc_ive_types[9] = <char>NPY_DOUBLE
ufunc_ive_types[10] = <char>NPY_CDOUBLE
ufunc_ive_types[11] = <char>NPY_CDOUBLE
ufunc_ive_ptr[2*0] = <void*>_func_cbesi_wrap_e_real
ufunc_ive_ptr[2*0+1] = <void*>(<char*>"ive")
ufunc_ive_ptr[2*1] = <void*>_func_cbesi_wrap_e
ufunc_ive_ptr[2*1+1] = <void*>(<char*>"ive")
ufunc_ive_ptr[2*2] = <void*>_func_cbesi_wrap_e_real
ufunc_ive_ptr[2*2+1] = <void*>(<char*>"ive")
ufunc_ive_ptr[2*3] = <void*>_func_cbesi_wrap_e
ufunc_ive_ptr[2*3+1] = <void*>(<char*>"ive")
ufunc_ive_data[0] = &ufunc_ive_ptr[2*0]
ufunc_ive_data[1] = &ufunc_ive_ptr[2*1]
ufunc_ive_data[2] = &ufunc_ive_ptr[2*2]
ufunc_ive_data[3] = &ufunc_ive_ptr[2*3]
ive = np.PyUFunc_FromFuncAndData(ufunc_ive_loops, ufunc_ive_data, ufunc_ive_types, 4, 2, 1, 0, "ive", ufunc_ive_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_j0_loops[2]
cdef void *ufunc_j0_ptr[4]
cdef void *ufunc_j0_data[2]
cdef char ufunc_j0_types[4]
cdef char *ufunc_j0_doc = (
    "y=j0(x) returns the Bessel function of order 0 at x.")
ufunc_j0_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_j0_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_j0_types[0] = <char>NPY_FLOAT
ufunc_j0_types[1] = <char>NPY_FLOAT
ufunc_j0_types[2] = <char>NPY_DOUBLE
ufunc_j0_types[3] = <char>NPY_DOUBLE
ufunc_j0_ptr[2*0] = <void*>_func_j0
ufunc_j0_ptr[2*0+1] = <void*>(<char*>"j0")
ufunc_j0_ptr[2*1] = <void*>_func_j0
ufunc_j0_ptr[2*1+1] = <void*>(<char*>"j0")
ufunc_j0_data[0] = &ufunc_j0_ptr[2*0]
ufunc_j0_data[1] = &ufunc_j0_ptr[2*1]
j0 = np.PyUFunc_FromFuncAndData(ufunc_j0_loops, ufunc_j0_data, ufunc_j0_types, 2, 1, 1, 0, "j0", ufunc_j0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_j1_loops[2]
cdef void *ufunc_j1_ptr[4]
cdef void *ufunc_j1_data[2]
cdef char ufunc_j1_types[4]
cdef char *ufunc_j1_doc = (
    "y=j1(x) returns the Bessel function of order 1 at x.")
ufunc_j1_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_j1_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_j1_types[0] = <char>NPY_FLOAT
ufunc_j1_types[1] = <char>NPY_FLOAT
ufunc_j1_types[2] = <char>NPY_DOUBLE
ufunc_j1_types[3] = <char>NPY_DOUBLE
ufunc_j1_ptr[2*0] = <void*>_func_j1
ufunc_j1_ptr[2*0+1] = <void*>(<char*>"j1")
ufunc_j1_ptr[2*1] = <void*>_func_j1
ufunc_j1_ptr[2*1+1] = <void*>(<char*>"j1")
ufunc_j1_data[0] = &ufunc_j1_ptr[2*0]
ufunc_j1_data[1] = &ufunc_j1_ptr[2*1]
j1 = np.PyUFunc_FromFuncAndData(ufunc_j1_loops, ufunc_j1_data, ufunc_j1_types, 2, 1, 1, 0, "j1", ufunc_j1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_jv_loops[4]
cdef void *ufunc_jv_ptr[8]
cdef void *ufunc_jv_data[4]
cdef char ufunc_jv_types[12]
cdef char *ufunc_jv_doc = (
    "y=jv(v,z) returns the Bessel function of real order v at complex z.")
ufunc_jv_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_jv_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_jv_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_jv_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_jv_types[0] = <char>NPY_FLOAT
ufunc_jv_types[1] = <char>NPY_FLOAT
ufunc_jv_types[2] = <char>NPY_FLOAT
ufunc_jv_types[3] = <char>NPY_FLOAT
ufunc_jv_types[4] = <char>NPY_CFLOAT
ufunc_jv_types[5] = <char>NPY_CFLOAT
ufunc_jv_types[6] = <char>NPY_DOUBLE
ufunc_jv_types[7] = <char>NPY_DOUBLE
ufunc_jv_types[8] = <char>NPY_DOUBLE
ufunc_jv_types[9] = <char>NPY_DOUBLE
ufunc_jv_types[10] = <char>NPY_CDOUBLE
ufunc_jv_types[11] = <char>NPY_CDOUBLE
ufunc_jv_ptr[2*0] = <void*>_func_cbesj_wrap_real
ufunc_jv_ptr[2*0+1] = <void*>(<char*>"jv")
ufunc_jv_ptr[2*1] = <void*>_func_cbesj_wrap
ufunc_jv_ptr[2*1+1] = <void*>(<char*>"jv")
ufunc_jv_ptr[2*2] = <void*>_func_cbesj_wrap_real
ufunc_jv_ptr[2*2+1] = <void*>(<char*>"jv")
ufunc_jv_ptr[2*3] = <void*>_func_cbesj_wrap
ufunc_jv_ptr[2*3+1] = <void*>(<char*>"jv")
ufunc_jv_data[0] = &ufunc_jv_ptr[2*0]
ufunc_jv_data[1] = &ufunc_jv_ptr[2*1]
ufunc_jv_data[2] = &ufunc_jv_ptr[2*2]
ufunc_jv_data[3] = &ufunc_jv_ptr[2*3]
jv = np.PyUFunc_FromFuncAndData(ufunc_jv_loops, ufunc_jv_data, ufunc_jv_types, 4, 2, 1, 0, "jv", ufunc_jv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_jve_loops[4]
cdef void *ufunc_jve_ptr[8]
cdef void *ufunc_jve_data[4]
cdef char ufunc_jve_types[12]
cdef char *ufunc_jve_doc = (
    "y=jve(v,z) returns the exponentially scaled Bessel function of real order\n"
    "v at complex z: jve(v,z) = jv(v,z) * exp(-abs(z.imag))")
ufunc_jve_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_jve_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_jve_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_jve_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_jve_types[0] = <char>NPY_FLOAT
ufunc_jve_types[1] = <char>NPY_FLOAT
ufunc_jve_types[2] = <char>NPY_FLOAT
ufunc_jve_types[3] = <char>NPY_FLOAT
ufunc_jve_types[4] = <char>NPY_CFLOAT
ufunc_jve_types[5] = <char>NPY_CFLOAT
ufunc_jve_types[6] = <char>NPY_DOUBLE
ufunc_jve_types[7] = <char>NPY_DOUBLE
ufunc_jve_types[8] = <char>NPY_DOUBLE
ufunc_jve_types[9] = <char>NPY_DOUBLE
ufunc_jve_types[10] = <char>NPY_CDOUBLE
ufunc_jve_types[11] = <char>NPY_CDOUBLE
ufunc_jve_ptr[2*0] = <void*>_func_cbesj_wrap_e_real
ufunc_jve_ptr[2*0+1] = <void*>(<char*>"jve")
ufunc_jve_ptr[2*1] = <void*>_func_cbesj_wrap_e
ufunc_jve_ptr[2*1+1] = <void*>(<char*>"jve")
ufunc_jve_ptr[2*2] = <void*>_func_cbesj_wrap_e_real
ufunc_jve_ptr[2*2+1] = <void*>(<char*>"jve")
ufunc_jve_ptr[2*3] = <void*>_func_cbesj_wrap_e
ufunc_jve_ptr[2*3+1] = <void*>(<char*>"jve")
ufunc_jve_data[0] = &ufunc_jve_ptr[2*0]
ufunc_jve_data[1] = &ufunc_jve_ptr[2*1]
ufunc_jve_data[2] = &ufunc_jve_ptr[2*2]
ufunc_jve_data[3] = &ufunc_jve_ptr[2*3]
jve = np.PyUFunc_FromFuncAndData(ufunc_jve_loops, ufunc_jve_data, ufunc_jve_types, 4, 2, 1, 0, "jve", ufunc_jve_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_k0_loops[2]
cdef void *ufunc_k0_ptr[4]
cdef void *ufunc_k0_data[2]
cdef char ufunc_k0_types[4]
cdef char *ufunc_k0_doc = (
    "y=k0(x) returns the modified Bessel function of the second kind (sometimes called the third kind) of\n"
    "order 0 at x.")
ufunc_k0_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_k0_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_k0_types[0] = <char>NPY_FLOAT
ufunc_k0_types[1] = <char>NPY_FLOAT
ufunc_k0_types[2] = <char>NPY_DOUBLE
ufunc_k0_types[3] = <char>NPY_DOUBLE
ufunc_k0_ptr[2*0] = <void*>_func_k0
ufunc_k0_ptr[2*0+1] = <void*>(<char*>"k0")
ufunc_k0_ptr[2*1] = <void*>_func_k0
ufunc_k0_ptr[2*1+1] = <void*>(<char*>"k0")
ufunc_k0_data[0] = &ufunc_k0_ptr[2*0]
ufunc_k0_data[1] = &ufunc_k0_ptr[2*1]
k0 = np.PyUFunc_FromFuncAndData(ufunc_k0_loops, ufunc_k0_data, ufunc_k0_types, 2, 1, 1, 0, "k0", ufunc_k0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_k0e_loops[2]
cdef void *ufunc_k0e_ptr[4]
cdef void *ufunc_k0e_data[2]
cdef char ufunc_k0e_types[4]
cdef char *ufunc_k0e_doc = (
    "y=k0e(x) returns the exponentially scaled modified Bessel function\n"
    "of the second kind (sometimes called the third kind) of order 0 at x.  k0e(x) = exp(x) * k0(x).")
ufunc_k0e_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_k0e_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_k0e_types[0] = <char>NPY_FLOAT
ufunc_k0e_types[1] = <char>NPY_FLOAT
ufunc_k0e_types[2] = <char>NPY_DOUBLE
ufunc_k0e_types[3] = <char>NPY_DOUBLE
ufunc_k0e_ptr[2*0] = <void*>_func_k0e
ufunc_k0e_ptr[2*0+1] = <void*>(<char*>"k0e")
ufunc_k0e_ptr[2*1] = <void*>_func_k0e
ufunc_k0e_ptr[2*1+1] = <void*>(<char*>"k0e")
ufunc_k0e_data[0] = &ufunc_k0e_ptr[2*0]
ufunc_k0e_data[1] = &ufunc_k0e_ptr[2*1]
k0e = np.PyUFunc_FromFuncAndData(ufunc_k0e_loops, ufunc_k0e_data, ufunc_k0e_types, 2, 1, 1, 0, "k0e", ufunc_k0e_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_k1_loops[2]
cdef void *ufunc_k1_ptr[4]
cdef void *ufunc_k1_data[2]
cdef char ufunc_k1_types[4]
cdef char *ufunc_k1_doc = (
    "y=i1(x) returns the modified Bessel function of the second kind (sometimes called the third kind) of\n"
    "order 1 at x.")
ufunc_k1_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_k1_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_k1_types[0] = <char>NPY_FLOAT
ufunc_k1_types[1] = <char>NPY_FLOAT
ufunc_k1_types[2] = <char>NPY_DOUBLE
ufunc_k1_types[3] = <char>NPY_DOUBLE
ufunc_k1_ptr[2*0] = <void*>_func_k1
ufunc_k1_ptr[2*0+1] = <void*>(<char*>"k1")
ufunc_k1_ptr[2*1] = <void*>_func_k1
ufunc_k1_ptr[2*1+1] = <void*>(<char*>"k1")
ufunc_k1_data[0] = &ufunc_k1_ptr[2*0]
ufunc_k1_data[1] = &ufunc_k1_ptr[2*1]
k1 = np.PyUFunc_FromFuncAndData(ufunc_k1_loops, ufunc_k1_data, ufunc_k1_types, 2, 1, 1, 0, "k1", ufunc_k1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_k1e_loops[2]
cdef void *ufunc_k1e_ptr[4]
cdef void *ufunc_k1e_data[2]
cdef char ufunc_k1e_types[4]
cdef char *ufunc_k1e_doc = (
    "y=k1e(x) returns the exponentially scaled modified Bessel function\n"
    "of the second kind (sometimes called the third kind) of order 1 at x.  k1e(x) = exp(x) * k1(x)")
ufunc_k1e_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_k1e_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_k1e_types[0] = <char>NPY_FLOAT
ufunc_k1e_types[1] = <char>NPY_FLOAT
ufunc_k1e_types[2] = <char>NPY_DOUBLE
ufunc_k1e_types[3] = <char>NPY_DOUBLE
ufunc_k1e_ptr[2*0] = <void*>_func_k1e
ufunc_k1e_ptr[2*0+1] = <void*>(<char*>"k1e")
ufunc_k1e_ptr[2*1] = <void*>_func_k1e
ufunc_k1e_ptr[2*1+1] = <void*>(<char*>"k1e")
ufunc_k1e_data[0] = &ufunc_k1e_ptr[2*0]
ufunc_k1e_data[1] = &ufunc_k1e_ptr[2*1]
k1e = np.PyUFunc_FromFuncAndData(ufunc_k1e_loops, ufunc_k1e_data, ufunc_k1e_types, 2, 1, 1, 0, "k1e", ufunc_k1e_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_kei_loops[2]
cdef void *ufunc_kei_ptr[4]
cdef void *ufunc_kei_data[2]
cdef char ufunc_kei_types[4]
cdef char *ufunc_kei_doc = (
    "y=kei(x) returns the Kelvin function ker x")
ufunc_kei_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_kei_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_kei_types[0] = <char>NPY_FLOAT
ufunc_kei_types[1] = <char>NPY_FLOAT
ufunc_kei_types[2] = <char>NPY_DOUBLE
ufunc_kei_types[3] = <char>NPY_DOUBLE
ufunc_kei_ptr[2*0] = <void*>_func_kei_wrap
ufunc_kei_ptr[2*0+1] = <void*>(<char*>"kei")
ufunc_kei_ptr[2*1] = <void*>_func_kei_wrap
ufunc_kei_ptr[2*1+1] = <void*>(<char*>"kei")
ufunc_kei_data[0] = &ufunc_kei_ptr[2*0]
ufunc_kei_data[1] = &ufunc_kei_ptr[2*1]
kei = np.PyUFunc_FromFuncAndData(ufunc_kei_loops, ufunc_kei_data, ufunc_kei_types, 2, 1, 1, 0, "kei", ufunc_kei_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_keip_loops[2]
cdef void *ufunc_keip_ptr[4]
cdef void *ufunc_keip_data[2]
cdef char ufunc_keip_types[4]
cdef char *ufunc_keip_doc = (
    "y=keip(x) returns the derivative of the Kelvin function kei x")
ufunc_keip_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_keip_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_keip_types[0] = <char>NPY_FLOAT
ufunc_keip_types[1] = <char>NPY_FLOAT
ufunc_keip_types[2] = <char>NPY_DOUBLE
ufunc_keip_types[3] = <char>NPY_DOUBLE
ufunc_keip_ptr[2*0] = <void*>_func_keip_wrap
ufunc_keip_ptr[2*0+1] = <void*>(<char*>"keip")
ufunc_keip_ptr[2*1] = <void*>_func_keip_wrap
ufunc_keip_ptr[2*1+1] = <void*>(<char*>"keip")
ufunc_keip_data[0] = &ufunc_keip_ptr[2*0]
ufunc_keip_data[1] = &ufunc_keip_ptr[2*1]
keip = np.PyUFunc_FromFuncAndData(ufunc_keip_loops, ufunc_keip_data, ufunc_keip_types, 2, 1, 1, 0, "keip", ufunc_keip_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_kelvin_loops[2]
cdef void *ufunc_kelvin_ptr[4]
cdef void *ufunc_kelvin_data[2]
cdef char ufunc_kelvin_types[10]
cdef char *ufunc_kelvin_doc = (
    "(Be, Ke, Bep, Kep)=kelvin(x) returns the tuple (Be, Ke, Bep, Kep) which contains\n"
    "complex numbers representing the real and imaginary Kelvin functions\n"
    "and their derivatives evaluated at x.  For example,\n"
    "kelvin(x)[0].real = ber x and kelvin(x)[0].imag = bei x with similar\n"
    "relationships for ker and kei.")
ufunc_kelvin_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_DDDD_As_f_FFFF
ufunc_kelvin_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_DDDD_As_d_DDDD
ufunc_kelvin_types[0] = <char>NPY_FLOAT
ufunc_kelvin_types[1] = <char>NPY_CFLOAT
ufunc_kelvin_types[2] = <char>NPY_CFLOAT
ufunc_kelvin_types[3] = <char>NPY_CFLOAT
ufunc_kelvin_types[4] = <char>NPY_CFLOAT
ufunc_kelvin_types[5] = <char>NPY_DOUBLE
ufunc_kelvin_types[6] = <char>NPY_CDOUBLE
ufunc_kelvin_types[7] = <char>NPY_CDOUBLE
ufunc_kelvin_types[8] = <char>NPY_CDOUBLE
ufunc_kelvin_types[9] = <char>NPY_CDOUBLE
ufunc_kelvin_ptr[2*0] = <void*>_func_kelvin_wrap
ufunc_kelvin_ptr[2*0+1] = <void*>(<char*>"kelvin")
ufunc_kelvin_ptr[2*1] = <void*>_func_kelvin_wrap
ufunc_kelvin_ptr[2*1+1] = <void*>(<char*>"kelvin")
ufunc_kelvin_data[0] = &ufunc_kelvin_ptr[2*0]
ufunc_kelvin_data[1] = &ufunc_kelvin_ptr[2*1]
kelvin = np.PyUFunc_FromFuncAndData(ufunc_kelvin_loops, ufunc_kelvin_data, ufunc_kelvin_types, 2, 1, 4, 0, "kelvin", ufunc_kelvin_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ker_loops[2]
cdef void *ufunc_ker_ptr[4]
cdef void *ufunc_ker_data[2]
cdef char ufunc_ker_types[4]
cdef char *ufunc_ker_doc = (
    "y=ker(x) returns the Kelvin function ker x")
ufunc_ker_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_ker_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_ker_types[0] = <char>NPY_FLOAT
ufunc_ker_types[1] = <char>NPY_FLOAT
ufunc_ker_types[2] = <char>NPY_DOUBLE
ufunc_ker_types[3] = <char>NPY_DOUBLE
ufunc_ker_ptr[2*0] = <void*>_func_ker_wrap
ufunc_ker_ptr[2*0+1] = <void*>(<char*>"ker")
ufunc_ker_ptr[2*1] = <void*>_func_ker_wrap
ufunc_ker_ptr[2*1+1] = <void*>(<char*>"ker")
ufunc_ker_data[0] = &ufunc_ker_ptr[2*0]
ufunc_ker_data[1] = &ufunc_ker_ptr[2*1]
ker = np.PyUFunc_FromFuncAndData(ufunc_ker_loops, ufunc_ker_data, ufunc_ker_types, 2, 1, 1, 0, "ker", ufunc_ker_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_kerp_loops[2]
cdef void *ufunc_kerp_ptr[4]
cdef void *ufunc_kerp_data[2]
cdef char ufunc_kerp_types[4]
cdef char *ufunc_kerp_doc = (
    "y=kerp(x) returns the derivative of the Kelvin function ker x")
ufunc_kerp_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_kerp_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_kerp_types[0] = <char>NPY_FLOAT
ufunc_kerp_types[1] = <char>NPY_FLOAT
ufunc_kerp_types[2] = <char>NPY_DOUBLE
ufunc_kerp_types[3] = <char>NPY_DOUBLE
ufunc_kerp_ptr[2*0] = <void*>_func_kerp_wrap
ufunc_kerp_ptr[2*0+1] = <void*>(<char*>"kerp")
ufunc_kerp_ptr[2*1] = <void*>_func_kerp_wrap
ufunc_kerp_ptr[2*1+1] = <void*>(<char*>"kerp")
ufunc_kerp_data[0] = &ufunc_kerp_ptr[2*0]
ufunc_kerp_data[1] = &ufunc_kerp_ptr[2*1]
kerp = np.PyUFunc_FromFuncAndData(ufunc_kerp_loops, ufunc_kerp_data, ufunc_kerp_types, 2, 1, 1, 0, "kerp", ufunc_kerp_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_kn_loops[4]
cdef void *ufunc_kn_ptr[8]
cdef void *ufunc_kn_data[4]
cdef char ufunc_kn_types[12]
cdef char *ufunc_kn_doc = (
    "y=kn(n,x) returns the modified Bessel function of the second kind (sometimes called the third kind) for\n"
    "integer order n at x.")
ufunc_kn_loops[0] = <np.PyUFuncGenericFunction>loop_d_id__As_lf_f
ufunc_kn_loops[1] = <np.PyUFuncGenericFunction>loop_d_id__As_ld_d
ufunc_kn_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_kn_loops[3] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_kn_types[0] = <char>NPY_LONG
ufunc_kn_types[1] = <char>NPY_FLOAT
ufunc_kn_types[2] = <char>NPY_FLOAT
ufunc_kn_types[3] = <char>NPY_LONG
ufunc_kn_types[4] = <char>NPY_DOUBLE
ufunc_kn_types[5] = <char>NPY_DOUBLE
ufunc_kn_types[6] = <char>NPY_FLOAT
ufunc_kn_types[7] = <char>NPY_FLOAT
ufunc_kn_types[8] = <char>NPY_FLOAT
ufunc_kn_types[9] = <char>NPY_DOUBLE
ufunc_kn_types[10] = <char>NPY_DOUBLE
ufunc_kn_types[11] = <char>NPY_DOUBLE
ufunc_kn_ptr[2*0] = <void*>_func_cbesk_wrap_real_int
ufunc_kn_ptr[2*0+1] = <void*>(<char*>"kn")
ufunc_kn_ptr[2*1] = <void*>_func_cbesk_wrap_real_int
ufunc_kn_ptr[2*1+1] = <void*>(<char*>"kn")
ufunc_kn_ptr[2*2] = <void*>_func_kn_unsafe
ufunc_kn_ptr[2*2+1] = <void*>(<char*>"kn")
ufunc_kn_ptr[2*3] = <void*>_func_kn_unsafe
ufunc_kn_ptr[2*3+1] = <void*>(<char*>"kn")
ufunc_kn_data[0] = &ufunc_kn_ptr[2*0]
ufunc_kn_data[1] = &ufunc_kn_ptr[2*1]
ufunc_kn_data[2] = &ufunc_kn_ptr[2*2]
ufunc_kn_data[3] = &ufunc_kn_ptr[2*3]
kn = np.PyUFunc_FromFuncAndData(ufunc_kn_loops, ufunc_kn_data, ufunc_kn_types, 4, 2, 1, 0, "kn", ufunc_kn_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_kolmogi_loops[2]
cdef void *ufunc_kolmogi_ptr[4]
cdef void *ufunc_kolmogi_data[2]
cdef char ufunc_kolmogi_types[4]
cdef char *ufunc_kolmogi_doc = (
    "y=kolmogi(p) returns y such that kolmogorov(y) = p")
ufunc_kolmogi_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_kolmogi_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_kolmogi_types[0] = <char>NPY_FLOAT
ufunc_kolmogi_types[1] = <char>NPY_FLOAT
ufunc_kolmogi_types[2] = <char>NPY_DOUBLE
ufunc_kolmogi_types[3] = <char>NPY_DOUBLE
ufunc_kolmogi_ptr[2*0] = <void*>_func_kolmogi
ufunc_kolmogi_ptr[2*0+1] = <void*>(<char*>"kolmogi")
ufunc_kolmogi_ptr[2*1] = <void*>_func_kolmogi
ufunc_kolmogi_ptr[2*1+1] = <void*>(<char*>"kolmogi")
ufunc_kolmogi_data[0] = &ufunc_kolmogi_ptr[2*0]
ufunc_kolmogi_data[1] = &ufunc_kolmogi_ptr[2*1]
kolmogi = np.PyUFunc_FromFuncAndData(ufunc_kolmogi_loops, ufunc_kolmogi_data, ufunc_kolmogi_types, 2, 1, 1, 0, "kolmogi", ufunc_kolmogi_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_kolmogorov_loops[2]
cdef void *ufunc_kolmogorov_ptr[4]
cdef void *ufunc_kolmogorov_data[2]
cdef char ufunc_kolmogorov_types[4]
cdef char *ufunc_kolmogorov_doc = (
    "p=kolmogorov(y) returns the complementary cumulative distribution\n"
    "function of Kolmogorov's limiting distribution (Kn* for large n)\n"
    "of a two-sided test for equality between an empirical and a theoretical\n"
    "distribution. It is equal to the (limit as n->infinity of the) probability\n"
    "that sqrt(n) * max absolute deviation > y.")
ufunc_kolmogorov_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_kolmogorov_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_kolmogorov_types[0] = <char>NPY_FLOAT
ufunc_kolmogorov_types[1] = <char>NPY_FLOAT
ufunc_kolmogorov_types[2] = <char>NPY_DOUBLE
ufunc_kolmogorov_types[3] = <char>NPY_DOUBLE
ufunc_kolmogorov_ptr[2*0] = <void*>_func_kolmogorov
ufunc_kolmogorov_ptr[2*0+1] = <void*>(<char*>"kolmogorov")
ufunc_kolmogorov_ptr[2*1] = <void*>_func_kolmogorov
ufunc_kolmogorov_ptr[2*1+1] = <void*>(<char*>"kolmogorov")
ufunc_kolmogorov_data[0] = &ufunc_kolmogorov_ptr[2*0]
ufunc_kolmogorov_data[1] = &ufunc_kolmogorov_ptr[2*1]
kolmogorov = np.PyUFunc_FromFuncAndData(ufunc_kolmogorov_loops, ufunc_kolmogorov_data, ufunc_kolmogorov_types, 2, 1, 1, 0, "kolmogorov", ufunc_kolmogorov_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_kv_loops[4]
cdef void *ufunc_kv_ptr[8]
cdef void *ufunc_kv_data[4]
cdef char ufunc_kv_types[12]
cdef char *ufunc_kv_doc = (
    "y=kv(v,z) returns the modified Bessel function of the second kind (sometimes called the third kind) for\n"
    "real order v at complex z.")
ufunc_kv_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_kv_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_kv_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_kv_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_kv_types[0] = <char>NPY_FLOAT
ufunc_kv_types[1] = <char>NPY_FLOAT
ufunc_kv_types[2] = <char>NPY_FLOAT
ufunc_kv_types[3] = <char>NPY_FLOAT
ufunc_kv_types[4] = <char>NPY_CFLOAT
ufunc_kv_types[5] = <char>NPY_CFLOAT
ufunc_kv_types[6] = <char>NPY_DOUBLE
ufunc_kv_types[7] = <char>NPY_DOUBLE
ufunc_kv_types[8] = <char>NPY_DOUBLE
ufunc_kv_types[9] = <char>NPY_DOUBLE
ufunc_kv_types[10] = <char>NPY_CDOUBLE
ufunc_kv_types[11] = <char>NPY_CDOUBLE
ufunc_kv_ptr[2*0] = <void*>_func_cbesk_wrap_real
ufunc_kv_ptr[2*0+1] = <void*>(<char*>"kv")
ufunc_kv_ptr[2*1] = <void*>_func_cbesk_wrap
ufunc_kv_ptr[2*1+1] = <void*>(<char*>"kv")
ufunc_kv_ptr[2*2] = <void*>_func_cbesk_wrap_real
ufunc_kv_ptr[2*2+1] = <void*>(<char*>"kv")
ufunc_kv_ptr[2*3] = <void*>_func_cbesk_wrap
ufunc_kv_ptr[2*3+1] = <void*>(<char*>"kv")
ufunc_kv_data[0] = &ufunc_kv_ptr[2*0]
ufunc_kv_data[1] = &ufunc_kv_ptr[2*1]
ufunc_kv_data[2] = &ufunc_kv_ptr[2*2]
ufunc_kv_data[3] = &ufunc_kv_ptr[2*3]
kv = np.PyUFunc_FromFuncAndData(ufunc_kv_loops, ufunc_kv_data, ufunc_kv_types, 4, 2, 1, 0, "kv", ufunc_kv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_kve_loops[4]
cdef void *ufunc_kve_ptr[8]
cdef void *ufunc_kve_data[4]
cdef char ufunc_kve_types[12]
cdef char *ufunc_kve_doc = (
    "y=kve(v,z) returns the exponentially scaled, modified Bessel function\n"
    "of the second kind (sometimes called the third kind) for real order v at complex z: kve(v,z) = kv(v,z) * exp(z)")
ufunc_kve_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_kve_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_kve_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_kve_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_kve_types[0] = <char>NPY_FLOAT
ufunc_kve_types[1] = <char>NPY_FLOAT
ufunc_kve_types[2] = <char>NPY_FLOAT
ufunc_kve_types[3] = <char>NPY_FLOAT
ufunc_kve_types[4] = <char>NPY_CFLOAT
ufunc_kve_types[5] = <char>NPY_CFLOAT
ufunc_kve_types[6] = <char>NPY_DOUBLE
ufunc_kve_types[7] = <char>NPY_DOUBLE
ufunc_kve_types[8] = <char>NPY_DOUBLE
ufunc_kve_types[9] = <char>NPY_DOUBLE
ufunc_kve_types[10] = <char>NPY_CDOUBLE
ufunc_kve_types[11] = <char>NPY_CDOUBLE
ufunc_kve_ptr[2*0] = <void*>_func_cbesk_wrap_e_real
ufunc_kve_ptr[2*0+1] = <void*>(<char*>"kve")
ufunc_kve_ptr[2*1] = <void*>_func_cbesk_wrap_e
ufunc_kve_ptr[2*1+1] = <void*>(<char*>"kve")
ufunc_kve_ptr[2*2] = <void*>_func_cbesk_wrap_e_real
ufunc_kve_ptr[2*2+1] = <void*>(<char*>"kve")
ufunc_kve_ptr[2*3] = <void*>_func_cbesk_wrap_e
ufunc_kve_ptr[2*3+1] = <void*>(<char*>"kve")
ufunc_kve_data[0] = &ufunc_kve_ptr[2*0]
ufunc_kve_data[1] = &ufunc_kve_ptr[2*1]
ufunc_kve_data[2] = &ufunc_kve_ptr[2*2]
ufunc_kve_data[3] = &ufunc_kve_ptr[2*3]
kve = np.PyUFunc_FromFuncAndData(ufunc_kve_loops, ufunc_kve_data, ufunc_kve_types, 4, 2, 1, 0, "kve", ufunc_kve_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_log1p_loops[2]
cdef void *ufunc_log1p_ptr[4]
cdef void *ufunc_log1p_data[2]
cdef char ufunc_log1p_types[4]
cdef char *ufunc_log1p_doc = (
    "y=log1p(x) calculates log(1+x) for use when x is near zero.")
ufunc_log1p_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_log1p_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_log1p_types[0] = <char>NPY_FLOAT
ufunc_log1p_types[1] = <char>NPY_FLOAT
ufunc_log1p_types[2] = <char>NPY_DOUBLE
ufunc_log1p_types[3] = <char>NPY_DOUBLE
ufunc_log1p_ptr[2*0] = <void*>_func_log1p
ufunc_log1p_ptr[2*0+1] = <void*>(<char*>"log1p")
ufunc_log1p_ptr[2*1] = <void*>_func_log1p
ufunc_log1p_ptr[2*1+1] = <void*>(<char*>"log1p")
ufunc_log1p_data[0] = &ufunc_log1p_ptr[2*0]
ufunc_log1p_data[1] = &ufunc_log1p_ptr[2*1]
log1p = np.PyUFunc_FromFuncAndData(ufunc_log1p_loops, ufunc_log1p_data, ufunc_log1p_types, 2, 1, 1, 0, "log1p", ufunc_log1p_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_log_ndtr_loops[2]
cdef void *ufunc_log_ndtr_ptr[4]
cdef void *ufunc_log_ndtr_data[2]
cdef char ufunc_log_ndtr_types[4]
cdef char *ufunc_log_ndtr_doc = (
    "y=log_ndtr(x) returns the log of the area under the standard Gaussian probability\n"
    "density function, integrated from minus infinity to x:\n"
    "1/sqrt(2*pi) * integral(exp(-t**2 / 2),t=-inf..x)")
ufunc_log_ndtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_log_ndtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_log_ndtr_types[0] = <char>NPY_FLOAT
ufunc_log_ndtr_types[1] = <char>NPY_FLOAT
ufunc_log_ndtr_types[2] = <char>NPY_DOUBLE
ufunc_log_ndtr_types[3] = <char>NPY_DOUBLE
ufunc_log_ndtr_ptr[2*0] = <void*>_func_log_ndtr
ufunc_log_ndtr_ptr[2*0+1] = <void*>(<char*>"log_ndtr")
ufunc_log_ndtr_ptr[2*1] = <void*>_func_log_ndtr
ufunc_log_ndtr_ptr[2*1+1] = <void*>(<char*>"log_ndtr")
ufunc_log_ndtr_data[0] = &ufunc_log_ndtr_ptr[2*0]
ufunc_log_ndtr_data[1] = &ufunc_log_ndtr_ptr[2*1]
log_ndtr = np.PyUFunc_FromFuncAndData(ufunc_log_ndtr_loops, ufunc_log_ndtr_data, ufunc_log_ndtr_types, 2, 1, 1, 0, "log_ndtr", ufunc_log_ndtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_logit_loops[3]
cdef void *ufunc_logit_ptr[6]
cdef void *ufunc_logit_data[3]
cdef char ufunc_logit_types[6]
cdef char *ufunc_logit_doc = (
    "Logit ufunc for ndarrays.\n"
    "\n"
    "The logit function is defined as logit(p) = log(p/(1-p)).\n"
    "Note that logit(0) = -inf, logit(1) = inf, and logit(p)\n"
    "for p<0 or p>1 yields nan.\n"
    "\n"
    "Parameters\n"
    "----------\n"
    "x : ndarray\n"
    "    The ndarray to apply logit to element-wise.\n"
    "\n"
    "Returns\n"
    "-------\n"
    "out : ndarray\n"
    "    An ndarray of the same shape as x. Its entries\n"
    "    are logit of the corresponding entry of x.\n"
    "\n"
    "Notes\n"
    "-----\n"
    "As a ufunc logit takes a number of optional\n"
    "keywork arguments. For more information\n"
    "see `ufuncs <http://docs.scipy.org/doc/numpy/reference/ufuncs.html>`_")
ufunc_logit_loops[0] = <np.PyUFuncGenericFunction>loop_f_f__As_f_f
ufunc_logit_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_logit_loops[2] = <np.PyUFuncGenericFunction>loop_g_g__As_g_g
ufunc_logit_types[0] = <char>NPY_FLOAT
ufunc_logit_types[1] = <char>NPY_FLOAT
ufunc_logit_types[2] = <char>NPY_DOUBLE
ufunc_logit_types[3] = <char>NPY_DOUBLE
ufunc_logit_types[4] = <char>NPY_LONGDOUBLE
ufunc_logit_types[5] = <char>NPY_LONGDOUBLE
ufunc_logit_ptr[2*0] = <void*>_func_logitf
ufunc_logit_ptr[2*0+1] = <void*>(<char*>"logit")
ufunc_logit_ptr[2*1] = <void*>_func_logit
ufunc_logit_ptr[2*1+1] = <void*>(<char*>"logit")
ufunc_logit_ptr[2*2] = <void*>_func_logitl
ufunc_logit_ptr[2*2+1] = <void*>(<char*>"logit")
ufunc_logit_data[0] = &ufunc_logit_ptr[2*0]
ufunc_logit_data[1] = &ufunc_logit_ptr[2*1]
ufunc_logit_data[2] = &ufunc_logit_ptr[2*2]
logit = np.PyUFunc_FromFuncAndData(ufunc_logit_loops, ufunc_logit_data, ufunc_logit_types, 3, 1, 1, 0, "logit", ufunc_logit_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_lpmv_loops[2]
cdef void *ufunc_lpmv_ptr[4]
cdef void *ufunc_lpmv_data[2]
cdef char ufunc_lpmv_types[8]
cdef char *ufunc_lpmv_doc = (
    "y=lpmv(m,v,x) returns the associated legendre function of integer order\n"
    "m and real degree v (s.t. v>-m-1 or v<m): ``|x| <= 1``.")
ufunc_lpmv_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_lpmv_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_lpmv_types[0] = <char>NPY_FLOAT
ufunc_lpmv_types[1] = <char>NPY_FLOAT
ufunc_lpmv_types[2] = <char>NPY_FLOAT
ufunc_lpmv_types[3] = <char>NPY_FLOAT
ufunc_lpmv_types[4] = <char>NPY_DOUBLE
ufunc_lpmv_types[5] = <char>NPY_DOUBLE
ufunc_lpmv_types[6] = <char>NPY_DOUBLE
ufunc_lpmv_types[7] = <char>NPY_DOUBLE
ufunc_lpmv_ptr[2*0] = <void*>_func_pmv_wrap
ufunc_lpmv_ptr[2*0+1] = <void*>(<char*>"lpmv")
ufunc_lpmv_ptr[2*1] = <void*>_func_pmv_wrap
ufunc_lpmv_ptr[2*1+1] = <void*>(<char*>"lpmv")
ufunc_lpmv_data[0] = &ufunc_lpmv_ptr[2*0]
ufunc_lpmv_data[1] = &ufunc_lpmv_ptr[2*1]
lpmv = np.PyUFunc_FromFuncAndData(ufunc_lpmv_loops, ufunc_lpmv_data, ufunc_lpmv_types, 2, 3, 1, 0, "lpmv", ufunc_lpmv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_mathieu_a_loops[2]
cdef void *ufunc_mathieu_a_ptr[4]
cdef void *ufunc_mathieu_a_data[2]
cdef char ufunc_mathieu_a_types[6]
cdef char *ufunc_mathieu_a_doc = (
    "lmbda=mathieu_a(m,q) returns the characteristic value for the even solution,\n"
    "ce_m(z,q), of Mathieu's equation")
ufunc_mathieu_a_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_mathieu_a_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_mathieu_a_types[0] = <char>NPY_FLOAT
ufunc_mathieu_a_types[1] = <char>NPY_FLOAT
ufunc_mathieu_a_types[2] = <char>NPY_FLOAT
ufunc_mathieu_a_types[3] = <char>NPY_DOUBLE
ufunc_mathieu_a_types[4] = <char>NPY_DOUBLE
ufunc_mathieu_a_types[5] = <char>NPY_DOUBLE
ufunc_mathieu_a_ptr[2*0] = <void*>_func_cem_cva_wrap
ufunc_mathieu_a_ptr[2*0+1] = <void*>(<char*>"mathieu_a")
ufunc_mathieu_a_ptr[2*1] = <void*>_func_cem_cva_wrap
ufunc_mathieu_a_ptr[2*1+1] = <void*>(<char*>"mathieu_a")
ufunc_mathieu_a_data[0] = &ufunc_mathieu_a_ptr[2*0]
ufunc_mathieu_a_data[1] = &ufunc_mathieu_a_ptr[2*1]
mathieu_a = np.PyUFunc_FromFuncAndData(ufunc_mathieu_a_loops, ufunc_mathieu_a_data, ufunc_mathieu_a_types, 2, 2, 1, 0, "mathieu_a", ufunc_mathieu_a_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_mathieu_b_loops[2]
cdef void *ufunc_mathieu_b_ptr[4]
cdef void *ufunc_mathieu_b_data[2]
cdef char ufunc_mathieu_b_types[6]
cdef char *ufunc_mathieu_b_doc = (
    "lmbda=mathieu_b(m,q) returns the characteristic value for the odd solution,\n"
    "se_m(z,q), of Mathieu's equation")
ufunc_mathieu_b_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_mathieu_b_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_mathieu_b_types[0] = <char>NPY_FLOAT
ufunc_mathieu_b_types[1] = <char>NPY_FLOAT
ufunc_mathieu_b_types[2] = <char>NPY_FLOAT
ufunc_mathieu_b_types[3] = <char>NPY_DOUBLE
ufunc_mathieu_b_types[4] = <char>NPY_DOUBLE
ufunc_mathieu_b_types[5] = <char>NPY_DOUBLE
ufunc_mathieu_b_ptr[2*0] = <void*>_func_sem_cva_wrap
ufunc_mathieu_b_ptr[2*0+1] = <void*>(<char*>"mathieu_b")
ufunc_mathieu_b_ptr[2*1] = <void*>_func_sem_cva_wrap
ufunc_mathieu_b_ptr[2*1+1] = <void*>(<char*>"mathieu_b")
ufunc_mathieu_b_data[0] = &ufunc_mathieu_b_ptr[2*0]
ufunc_mathieu_b_data[1] = &ufunc_mathieu_b_ptr[2*1]
mathieu_b = np.PyUFunc_FromFuncAndData(ufunc_mathieu_b_loops, ufunc_mathieu_b_data, ufunc_mathieu_b_types, 2, 2, 1, 0, "mathieu_b", ufunc_mathieu_b_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_mathieu_cem_loops[2]
cdef void *ufunc_mathieu_cem_ptr[4]
cdef void *ufunc_mathieu_cem_data[2]
cdef char ufunc_mathieu_cem_types[10]
cdef char *ufunc_mathieu_cem_doc = (
    "(y,yp)=mathieu_cem(m,q,x) returns the even Mathieu function, ce_m(x,q),\n"
    "of order m and parameter q evaluated at x (given in degrees).\n"
    "Also returns the derivative with respect to x of ce_m(x,q)")
ufunc_mathieu_cem_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_fff_ff
ufunc_mathieu_cem_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_ddd_dd
ufunc_mathieu_cem_types[0] = <char>NPY_FLOAT
ufunc_mathieu_cem_types[1] = <char>NPY_FLOAT
ufunc_mathieu_cem_types[2] = <char>NPY_FLOAT
ufunc_mathieu_cem_types[3] = <char>NPY_FLOAT
ufunc_mathieu_cem_types[4] = <char>NPY_FLOAT
ufunc_mathieu_cem_types[5] = <char>NPY_DOUBLE
ufunc_mathieu_cem_types[6] = <char>NPY_DOUBLE
ufunc_mathieu_cem_types[7] = <char>NPY_DOUBLE
ufunc_mathieu_cem_types[8] = <char>NPY_DOUBLE
ufunc_mathieu_cem_types[9] = <char>NPY_DOUBLE
ufunc_mathieu_cem_ptr[2*0] = <void*>_func_cem_wrap
ufunc_mathieu_cem_ptr[2*0+1] = <void*>(<char*>"mathieu_cem")
ufunc_mathieu_cem_ptr[2*1] = <void*>_func_cem_wrap
ufunc_mathieu_cem_ptr[2*1+1] = <void*>(<char*>"mathieu_cem")
ufunc_mathieu_cem_data[0] = &ufunc_mathieu_cem_ptr[2*0]
ufunc_mathieu_cem_data[1] = &ufunc_mathieu_cem_ptr[2*1]
mathieu_cem = np.PyUFunc_FromFuncAndData(ufunc_mathieu_cem_loops, ufunc_mathieu_cem_data, ufunc_mathieu_cem_types, 2, 3, 2, 0, "mathieu_cem", ufunc_mathieu_cem_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_mathieu_modcem1_loops[2]
cdef void *ufunc_mathieu_modcem1_ptr[4]
cdef void *ufunc_mathieu_modcem1_data[2]
cdef char ufunc_mathieu_modcem1_types[10]
cdef char *ufunc_mathieu_modcem1_doc = (
    "(y,yp)=mathieu_modcem1(m,q,x) evaluates the even modified Mathieu function\n"
    "of the first kind, Mc1m(x,q), and its derivative at x for order m and\n"
    "parameter q.")
ufunc_mathieu_modcem1_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_fff_ff
ufunc_mathieu_modcem1_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_ddd_dd
ufunc_mathieu_modcem1_types[0] = <char>NPY_FLOAT
ufunc_mathieu_modcem1_types[1] = <char>NPY_FLOAT
ufunc_mathieu_modcem1_types[2] = <char>NPY_FLOAT
ufunc_mathieu_modcem1_types[3] = <char>NPY_FLOAT
ufunc_mathieu_modcem1_types[4] = <char>NPY_FLOAT
ufunc_mathieu_modcem1_types[5] = <char>NPY_DOUBLE
ufunc_mathieu_modcem1_types[6] = <char>NPY_DOUBLE
ufunc_mathieu_modcem1_types[7] = <char>NPY_DOUBLE
ufunc_mathieu_modcem1_types[8] = <char>NPY_DOUBLE
ufunc_mathieu_modcem1_types[9] = <char>NPY_DOUBLE
ufunc_mathieu_modcem1_ptr[2*0] = <void*>_func_mcm1_wrap
ufunc_mathieu_modcem1_ptr[2*0+1] = <void*>(<char*>"mathieu_modcem1")
ufunc_mathieu_modcem1_ptr[2*1] = <void*>_func_mcm1_wrap
ufunc_mathieu_modcem1_ptr[2*1+1] = <void*>(<char*>"mathieu_modcem1")
ufunc_mathieu_modcem1_data[0] = &ufunc_mathieu_modcem1_ptr[2*0]
ufunc_mathieu_modcem1_data[1] = &ufunc_mathieu_modcem1_ptr[2*1]
mathieu_modcem1 = np.PyUFunc_FromFuncAndData(ufunc_mathieu_modcem1_loops, ufunc_mathieu_modcem1_data, ufunc_mathieu_modcem1_types, 2, 3, 2, 0, "mathieu_modcem1", ufunc_mathieu_modcem1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_mathieu_modcem2_loops[2]
cdef void *ufunc_mathieu_modcem2_ptr[4]
cdef void *ufunc_mathieu_modcem2_data[2]
cdef char ufunc_mathieu_modcem2_types[10]
cdef char *ufunc_mathieu_modcem2_doc = (
    "(y,yp)=mathieu_modcem2(m,q,x) evaluates the even modified Mathieu function\n"
    "of the second kind, Mc2m(x,q), and its derivative at x (given in degrees)\n"
    "for order m and parameter q.")
ufunc_mathieu_modcem2_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_fff_ff
ufunc_mathieu_modcem2_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_ddd_dd
ufunc_mathieu_modcem2_types[0] = <char>NPY_FLOAT
ufunc_mathieu_modcem2_types[1] = <char>NPY_FLOAT
ufunc_mathieu_modcem2_types[2] = <char>NPY_FLOAT
ufunc_mathieu_modcem2_types[3] = <char>NPY_FLOAT
ufunc_mathieu_modcem2_types[4] = <char>NPY_FLOAT
ufunc_mathieu_modcem2_types[5] = <char>NPY_DOUBLE
ufunc_mathieu_modcem2_types[6] = <char>NPY_DOUBLE
ufunc_mathieu_modcem2_types[7] = <char>NPY_DOUBLE
ufunc_mathieu_modcem2_types[8] = <char>NPY_DOUBLE
ufunc_mathieu_modcem2_types[9] = <char>NPY_DOUBLE
ufunc_mathieu_modcem2_ptr[2*0] = <void*>_func_mcm2_wrap
ufunc_mathieu_modcem2_ptr[2*0+1] = <void*>(<char*>"mathieu_modcem2")
ufunc_mathieu_modcem2_ptr[2*1] = <void*>_func_mcm2_wrap
ufunc_mathieu_modcem2_ptr[2*1+1] = <void*>(<char*>"mathieu_modcem2")
ufunc_mathieu_modcem2_data[0] = &ufunc_mathieu_modcem2_ptr[2*0]
ufunc_mathieu_modcem2_data[1] = &ufunc_mathieu_modcem2_ptr[2*1]
mathieu_modcem2 = np.PyUFunc_FromFuncAndData(ufunc_mathieu_modcem2_loops, ufunc_mathieu_modcem2_data, ufunc_mathieu_modcem2_types, 2, 3, 2, 0, "mathieu_modcem2", ufunc_mathieu_modcem2_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_mathieu_modsem1_loops[2]
cdef void *ufunc_mathieu_modsem1_ptr[4]
cdef void *ufunc_mathieu_modsem1_data[2]
cdef char ufunc_mathieu_modsem1_types[10]
cdef char *ufunc_mathieu_modsem1_doc = (
    "(y,yp)=mathieu_modsem1(m,q,x) evaluates the odd modified Mathieu function\n"
    "of the first kind, Ms1m(x,q), and its derivative at x (given in degrees)\n"
    "for order m and parameter q.")
ufunc_mathieu_modsem1_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_fff_ff
ufunc_mathieu_modsem1_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_ddd_dd
ufunc_mathieu_modsem1_types[0] = <char>NPY_FLOAT
ufunc_mathieu_modsem1_types[1] = <char>NPY_FLOAT
ufunc_mathieu_modsem1_types[2] = <char>NPY_FLOAT
ufunc_mathieu_modsem1_types[3] = <char>NPY_FLOAT
ufunc_mathieu_modsem1_types[4] = <char>NPY_FLOAT
ufunc_mathieu_modsem1_types[5] = <char>NPY_DOUBLE
ufunc_mathieu_modsem1_types[6] = <char>NPY_DOUBLE
ufunc_mathieu_modsem1_types[7] = <char>NPY_DOUBLE
ufunc_mathieu_modsem1_types[8] = <char>NPY_DOUBLE
ufunc_mathieu_modsem1_types[9] = <char>NPY_DOUBLE
ufunc_mathieu_modsem1_ptr[2*0] = <void*>_func_msm1_wrap
ufunc_mathieu_modsem1_ptr[2*0+1] = <void*>(<char*>"mathieu_modsem1")
ufunc_mathieu_modsem1_ptr[2*1] = <void*>_func_msm1_wrap
ufunc_mathieu_modsem1_ptr[2*1+1] = <void*>(<char*>"mathieu_modsem1")
ufunc_mathieu_modsem1_data[0] = &ufunc_mathieu_modsem1_ptr[2*0]
ufunc_mathieu_modsem1_data[1] = &ufunc_mathieu_modsem1_ptr[2*1]
mathieu_modsem1 = np.PyUFunc_FromFuncAndData(ufunc_mathieu_modsem1_loops, ufunc_mathieu_modsem1_data, ufunc_mathieu_modsem1_types, 2, 3, 2, 0, "mathieu_modsem1", ufunc_mathieu_modsem1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_mathieu_modsem2_loops[2]
cdef void *ufunc_mathieu_modsem2_ptr[4]
cdef void *ufunc_mathieu_modsem2_data[2]
cdef char ufunc_mathieu_modsem2_types[10]
cdef char *ufunc_mathieu_modsem2_doc = (
    "(y,yp)=mathieu_modsem2(m,q,x) evaluates the odd modified Mathieu function\n"
    "of the second kind, Ms2m(x,q), and its derivative at x (given in degrees)\n"
    "for order m and parameter q.")
ufunc_mathieu_modsem2_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_fff_ff
ufunc_mathieu_modsem2_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_ddd_dd
ufunc_mathieu_modsem2_types[0] = <char>NPY_FLOAT
ufunc_mathieu_modsem2_types[1] = <char>NPY_FLOAT
ufunc_mathieu_modsem2_types[2] = <char>NPY_FLOAT
ufunc_mathieu_modsem2_types[3] = <char>NPY_FLOAT
ufunc_mathieu_modsem2_types[4] = <char>NPY_FLOAT
ufunc_mathieu_modsem2_types[5] = <char>NPY_DOUBLE
ufunc_mathieu_modsem2_types[6] = <char>NPY_DOUBLE
ufunc_mathieu_modsem2_types[7] = <char>NPY_DOUBLE
ufunc_mathieu_modsem2_types[8] = <char>NPY_DOUBLE
ufunc_mathieu_modsem2_types[9] = <char>NPY_DOUBLE
ufunc_mathieu_modsem2_ptr[2*0] = <void*>_func_msm2_wrap
ufunc_mathieu_modsem2_ptr[2*0+1] = <void*>(<char*>"mathieu_modsem2")
ufunc_mathieu_modsem2_ptr[2*1] = <void*>_func_msm2_wrap
ufunc_mathieu_modsem2_ptr[2*1+1] = <void*>(<char*>"mathieu_modsem2")
ufunc_mathieu_modsem2_data[0] = &ufunc_mathieu_modsem2_ptr[2*0]
ufunc_mathieu_modsem2_data[1] = &ufunc_mathieu_modsem2_ptr[2*1]
mathieu_modsem2 = np.PyUFunc_FromFuncAndData(ufunc_mathieu_modsem2_loops, ufunc_mathieu_modsem2_data, ufunc_mathieu_modsem2_types, 2, 3, 2, 0, "mathieu_modsem2", ufunc_mathieu_modsem2_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_mathieu_sem_loops[2]
cdef void *ufunc_mathieu_sem_ptr[4]
cdef void *ufunc_mathieu_sem_data[2]
cdef char ufunc_mathieu_sem_types[10]
cdef char *ufunc_mathieu_sem_doc = (
    "(y,yp)=mathieu_sem(m,q,x) returns the odd Mathieu function, se_m(x,q),\n"
    "of order m and parameter q evaluated at x (given in degrees).\n"
    "Also returns the derivative with respect to x of se_m(x,q).")
ufunc_mathieu_sem_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_fff_ff
ufunc_mathieu_sem_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddd_dd_As_ddd_dd
ufunc_mathieu_sem_types[0] = <char>NPY_FLOAT
ufunc_mathieu_sem_types[1] = <char>NPY_FLOAT
ufunc_mathieu_sem_types[2] = <char>NPY_FLOAT
ufunc_mathieu_sem_types[3] = <char>NPY_FLOAT
ufunc_mathieu_sem_types[4] = <char>NPY_FLOAT
ufunc_mathieu_sem_types[5] = <char>NPY_DOUBLE
ufunc_mathieu_sem_types[6] = <char>NPY_DOUBLE
ufunc_mathieu_sem_types[7] = <char>NPY_DOUBLE
ufunc_mathieu_sem_types[8] = <char>NPY_DOUBLE
ufunc_mathieu_sem_types[9] = <char>NPY_DOUBLE
ufunc_mathieu_sem_ptr[2*0] = <void*>_func_sem_wrap
ufunc_mathieu_sem_ptr[2*0+1] = <void*>(<char*>"mathieu_sem")
ufunc_mathieu_sem_ptr[2*1] = <void*>_func_sem_wrap
ufunc_mathieu_sem_ptr[2*1+1] = <void*>(<char*>"mathieu_sem")
ufunc_mathieu_sem_data[0] = &ufunc_mathieu_sem_ptr[2*0]
ufunc_mathieu_sem_data[1] = &ufunc_mathieu_sem_ptr[2*1]
mathieu_sem = np.PyUFunc_FromFuncAndData(ufunc_mathieu_sem_loops, ufunc_mathieu_sem_data, ufunc_mathieu_sem_types, 2, 3, 2, 0, "mathieu_sem", ufunc_mathieu_sem_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_modfresnelm_loops[2]
cdef void *ufunc_modfresnelm_ptr[4]
cdef void *ufunc_modfresnelm_data[2]
cdef char ufunc_modfresnelm_types[6]
cdef char *ufunc_modfresnelm_doc = (
    "(fm,km)=modfresnelp(x) returns the modified Fresnel integrals ``F_-(x)`` and ``K_-(x)``\n"
    "as ``fp=integral(exp(-1j*t*t),t=x..inf)`` and ``kp=1/sqrt(pi)*exp(1j*(x*x+pi/4))*fp``")
ufunc_modfresnelm_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_DD_As_f_FF
ufunc_modfresnelm_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_DD_As_d_DD
ufunc_modfresnelm_types[0] = <char>NPY_FLOAT
ufunc_modfresnelm_types[1] = <char>NPY_CFLOAT
ufunc_modfresnelm_types[2] = <char>NPY_CFLOAT
ufunc_modfresnelm_types[3] = <char>NPY_DOUBLE
ufunc_modfresnelm_types[4] = <char>NPY_CDOUBLE
ufunc_modfresnelm_types[5] = <char>NPY_CDOUBLE
ufunc_modfresnelm_ptr[2*0] = <void*>_func_modified_fresnel_minus_wrap
ufunc_modfresnelm_ptr[2*0+1] = <void*>(<char*>"modfresnelm")
ufunc_modfresnelm_ptr[2*1] = <void*>_func_modified_fresnel_minus_wrap
ufunc_modfresnelm_ptr[2*1+1] = <void*>(<char*>"modfresnelm")
ufunc_modfresnelm_data[0] = &ufunc_modfresnelm_ptr[2*0]
ufunc_modfresnelm_data[1] = &ufunc_modfresnelm_ptr[2*1]
modfresnelm = np.PyUFunc_FromFuncAndData(ufunc_modfresnelm_loops, ufunc_modfresnelm_data, ufunc_modfresnelm_types, 2, 1, 2, 0, "modfresnelm", ufunc_modfresnelm_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_modfresnelp_loops[2]
cdef void *ufunc_modfresnelp_ptr[4]
cdef void *ufunc_modfresnelp_data[2]
cdef char ufunc_modfresnelp_types[6]
cdef char *ufunc_modfresnelp_doc = (
    "(fp,kp)=modfresnelp(x) returns the modified Fresnel integrals F_+(x) and K_+(x)\n"
    "as fp=integral(exp(1j*t*t),t=x..inf) and kp=1/sqrt(pi)*exp(-1j*(x*x+pi/4))*fp")
ufunc_modfresnelp_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_DD_As_f_FF
ufunc_modfresnelp_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_DD_As_d_DD
ufunc_modfresnelp_types[0] = <char>NPY_FLOAT
ufunc_modfresnelp_types[1] = <char>NPY_CFLOAT
ufunc_modfresnelp_types[2] = <char>NPY_CFLOAT
ufunc_modfresnelp_types[3] = <char>NPY_DOUBLE
ufunc_modfresnelp_types[4] = <char>NPY_CDOUBLE
ufunc_modfresnelp_types[5] = <char>NPY_CDOUBLE
ufunc_modfresnelp_ptr[2*0] = <void*>_func_modified_fresnel_plus_wrap
ufunc_modfresnelp_ptr[2*0+1] = <void*>(<char*>"modfresnelp")
ufunc_modfresnelp_ptr[2*1] = <void*>_func_modified_fresnel_plus_wrap
ufunc_modfresnelp_ptr[2*1+1] = <void*>(<char*>"modfresnelp")
ufunc_modfresnelp_data[0] = &ufunc_modfresnelp_ptr[2*0]
ufunc_modfresnelp_data[1] = &ufunc_modfresnelp_ptr[2*1]
modfresnelp = np.PyUFunc_FromFuncAndData(ufunc_modfresnelp_loops, ufunc_modfresnelp_data, ufunc_modfresnelp_types, 2, 1, 2, 0, "modfresnelp", ufunc_modfresnelp_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_modstruve_loops[2]
cdef void *ufunc_modstruve_ptr[4]
cdef void *ufunc_modstruve_data[2]
cdef char ufunc_modstruve_types[6]
cdef char *ufunc_modstruve_doc = (
    "y=modstruve(v,x) returns the modified Struve function Lv(x) of order\n"
    "v at x, x must be positive unless v is an integer and it is recommended\n"
    "that ``|v| <= 20``.")
ufunc_modstruve_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_modstruve_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_modstruve_types[0] = <char>NPY_FLOAT
ufunc_modstruve_types[1] = <char>NPY_FLOAT
ufunc_modstruve_types[2] = <char>NPY_FLOAT
ufunc_modstruve_types[3] = <char>NPY_DOUBLE
ufunc_modstruve_types[4] = <char>NPY_DOUBLE
ufunc_modstruve_types[5] = <char>NPY_DOUBLE
ufunc_modstruve_ptr[2*0] = <void*>_func_struve_l
ufunc_modstruve_ptr[2*0+1] = <void*>(<char*>"modstruve")
ufunc_modstruve_ptr[2*1] = <void*>_func_struve_l
ufunc_modstruve_ptr[2*1+1] = <void*>(<char*>"modstruve")
ufunc_modstruve_data[0] = &ufunc_modstruve_ptr[2*0]
ufunc_modstruve_data[1] = &ufunc_modstruve_ptr[2*1]
modstruve = np.PyUFunc_FromFuncAndData(ufunc_modstruve_loops, ufunc_modstruve_data, ufunc_modstruve_types, 2, 2, 1, 0, "modstruve", ufunc_modstruve_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_nbdtr_loops[4]
cdef void *ufunc_nbdtr_ptr[8]
cdef void *ufunc_nbdtr_data[4]
cdef char ufunc_nbdtr_types[16]
cdef char *ufunc_nbdtr_doc = (
    "y=nbdtr(k,n,p) returns the sum of the terms 0 through k of the\n"
    "negative binomial distribution: sum((n+j-1)Cj p**n (1-p)**j,j=0..k).\n"
    "In a sequence of Bernoulli trials this is the probability that k or\n"
    "fewer failures precede the nth success.")
ufunc_nbdtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_iid__As_llf_f
ufunc_nbdtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_iid__As_lld_d
ufunc_nbdtr_loops[2] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_nbdtr_loops[3] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_nbdtr_types[0] = <char>NPY_LONG
ufunc_nbdtr_types[1] = <char>NPY_LONG
ufunc_nbdtr_types[2] = <char>NPY_FLOAT
ufunc_nbdtr_types[3] = <char>NPY_FLOAT
ufunc_nbdtr_types[4] = <char>NPY_LONG
ufunc_nbdtr_types[5] = <char>NPY_LONG
ufunc_nbdtr_types[6] = <char>NPY_DOUBLE
ufunc_nbdtr_types[7] = <char>NPY_DOUBLE
ufunc_nbdtr_types[8] = <char>NPY_FLOAT
ufunc_nbdtr_types[9] = <char>NPY_FLOAT
ufunc_nbdtr_types[10] = <char>NPY_FLOAT
ufunc_nbdtr_types[11] = <char>NPY_FLOAT
ufunc_nbdtr_types[12] = <char>NPY_DOUBLE
ufunc_nbdtr_types[13] = <char>NPY_DOUBLE
ufunc_nbdtr_types[14] = <char>NPY_DOUBLE
ufunc_nbdtr_types[15] = <char>NPY_DOUBLE
ufunc_nbdtr_ptr[2*0] = <void*>_func_nbdtr
ufunc_nbdtr_ptr[2*0+1] = <void*>(<char*>"nbdtr")
ufunc_nbdtr_ptr[2*1] = <void*>_func_nbdtr
ufunc_nbdtr_ptr[2*1+1] = <void*>(<char*>"nbdtr")
ufunc_nbdtr_ptr[2*2] = <void*>_func_nbdtr_unsafe
ufunc_nbdtr_ptr[2*2+1] = <void*>(<char*>"nbdtr")
ufunc_nbdtr_ptr[2*3] = <void*>_func_nbdtr_unsafe
ufunc_nbdtr_ptr[2*3+1] = <void*>(<char*>"nbdtr")
ufunc_nbdtr_data[0] = &ufunc_nbdtr_ptr[2*0]
ufunc_nbdtr_data[1] = &ufunc_nbdtr_ptr[2*1]
ufunc_nbdtr_data[2] = &ufunc_nbdtr_ptr[2*2]
ufunc_nbdtr_data[3] = &ufunc_nbdtr_ptr[2*3]
nbdtr = np.PyUFunc_FromFuncAndData(ufunc_nbdtr_loops, ufunc_nbdtr_data, ufunc_nbdtr_types, 4, 3, 1, 0, "nbdtr", ufunc_nbdtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_nbdtrc_loops[4]
cdef void *ufunc_nbdtrc_ptr[8]
cdef void *ufunc_nbdtrc_data[4]
cdef char ufunc_nbdtrc_types[16]
cdef char *ufunc_nbdtrc_doc = (
    "y=nbdtrc(k,n,p) returns the sum of the terms k+1 to infinity of the\n"
    "negative binomial distribution.")
ufunc_nbdtrc_loops[0] = <np.PyUFuncGenericFunction>loop_d_iid__As_llf_f
ufunc_nbdtrc_loops[1] = <np.PyUFuncGenericFunction>loop_d_iid__As_lld_d
ufunc_nbdtrc_loops[2] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_nbdtrc_loops[3] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_nbdtrc_types[0] = <char>NPY_LONG
ufunc_nbdtrc_types[1] = <char>NPY_LONG
ufunc_nbdtrc_types[2] = <char>NPY_FLOAT
ufunc_nbdtrc_types[3] = <char>NPY_FLOAT
ufunc_nbdtrc_types[4] = <char>NPY_LONG
ufunc_nbdtrc_types[5] = <char>NPY_LONG
ufunc_nbdtrc_types[6] = <char>NPY_DOUBLE
ufunc_nbdtrc_types[7] = <char>NPY_DOUBLE
ufunc_nbdtrc_types[8] = <char>NPY_FLOAT
ufunc_nbdtrc_types[9] = <char>NPY_FLOAT
ufunc_nbdtrc_types[10] = <char>NPY_FLOAT
ufunc_nbdtrc_types[11] = <char>NPY_FLOAT
ufunc_nbdtrc_types[12] = <char>NPY_DOUBLE
ufunc_nbdtrc_types[13] = <char>NPY_DOUBLE
ufunc_nbdtrc_types[14] = <char>NPY_DOUBLE
ufunc_nbdtrc_types[15] = <char>NPY_DOUBLE
ufunc_nbdtrc_ptr[2*0] = <void*>_func_nbdtrc
ufunc_nbdtrc_ptr[2*0+1] = <void*>(<char*>"nbdtrc")
ufunc_nbdtrc_ptr[2*1] = <void*>_func_nbdtrc
ufunc_nbdtrc_ptr[2*1+1] = <void*>(<char*>"nbdtrc")
ufunc_nbdtrc_ptr[2*2] = <void*>_func_nbdtrc_unsafe
ufunc_nbdtrc_ptr[2*2+1] = <void*>(<char*>"nbdtrc")
ufunc_nbdtrc_ptr[2*3] = <void*>_func_nbdtrc_unsafe
ufunc_nbdtrc_ptr[2*3+1] = <void*>(<char*>"nbdtrc")
ufunc_nbdtrc_data[0] = &ufunc_nbdtrc_ptr[2*0]
ufunc_nbdtrc_data[1] = &ufunc_nbdtrc_ptr[2*1]
ufunc_nbdtrc_data[2] = &ufunc_nbdtrc_ptr[2*2]
ufunc_nbdtrc_data[3] = &ufunc_nbdtrc_ptr[2*3]
nbdtrc = np.PyUFunc_FromFuncAndData(ufunc_nbdtrc_loops, ufunc_nbdtrc_data, ufunc_nbdtrc_types, 4, 3, 1, 0, "nbdtrc", ufunc_nbdtrc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_nbdtri_loops[4]
cdef void *ufunc_nbdtri_ptr[8]
cdef void *ufunc_nbdtri_data[4]
cdef char ufunc_nbdtri_types[16]
cdef char *ufunc_nbdtri_doc = (
    "p=nbdtri(k,n,y) finds the argument p such that nbdtr(k,n,p)=y.")
ufunc_nbdtri_loops[0] = <np.PyUFuncGenericFunction>loop_d_iid__As_llf_f
ufunc_nbdtri_loops[1] = <np.PyUFuncGenericFunction>loop_d_iid__As_lld_d
ufunc_nbdtri_loops[2] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_nbdtri_loops[3] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_nbdtri_types[0] = <char>NPY_LONG
ufunc_nbdtri_types[1] = <char>NPY_LONG
ufunc_nbdtri_types[2] = <char>NPY_FLOAT
ufunc_nbdtri_types[3] = <char>NPY_FLOAT
ufunc_nbdtri_types[4] = <char>NPY_LONG
ufunc_nbdtri_types[5] = <char>NPY_LONG
ufunc_nbdtri_types[6] = <char>NPY_DOUBLE
ufunc_nbdtri_types[7] = <char>NPY_DOUBLE
ufunc_nbdtri_types[8] = <char>NPY_FLOAT
ufunc_nbdtri_types[9] = <char>NPY_FLOAT
ufunc_nbdtri_types[10] = <char>NPY_FLOAT
ufunc_nbdtri_types[11] = <char>NPY_FLOAT
ufunc_nbdtri_types[12] = <char>NPY_DOUBLE
ufunc_nbdtri_types[13] = <char>NPY_DOUBLE
ufunc_nbdtri_types[14] = <char>NPY_DOUBLE
ufunc_nbdtri_types[15] = <char>NPY_DOUBLE
ufunc_nbdtri_ptr[2*0] = <void*>_func_nbdtri
ufunc_nbdtri_ptr[2*0+1] = <void*>(<char*>"nbdtri")
ufunc_nbdtri_ptr[2*1] = <void*>_func_nbdtri
ufunc_nbdtri_ptr[2*1+1] = <void*>(<char*>"nbdtri")
ufunc_nbdtri_ptr[2*2] = <void*>_func_nbdtri_unsafe
ufunc_nbdtri_ptr[2*2+1] = <void*>(<char*>"nbdtri")
ufunc_nbdtri_ptr[2*3] = <void*>_func_nbdtri_unsafe
ufunc_nbdtri_ptr[2*3+1] = <void*>(<char*>"nbdtri")
ufunc_nbdtri_data[0] = &ufunc_nbdtri_ptr[2*0]
ufunc_nbdtri_data[1] = &ufunc_nbdtri_ptr[2*1]
ufunc_nbdtri_data[2] = &ufunc_nbdtri_ptr[2*2]
ufunc_nbdtri_data[3] = &ufunc_nbdtri_ptr[2*3]
nbdtri = np.PyUFunc_FromFuncAndData(ufunc_nbdtri_loops, ufunc_nbdtri_data, ufunc_nbdtri_types, 4, 3, 1, 0, "nbdtri", ufunc_nbdtri_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_nbdtrik_loops[2]
cdef void *ufunc_nbdtrik_ptr[4]
cdef void *ufunc_nbdtrik_data[2]
cdef char ufunc_nbdtrik_types[8]
cdef char *ufunc_nbdtrik_doc = (
    "k=nbdtrik(y,n,p) finds the argument k such that nbdtr(k,n,p)=y.")
ufunc_nbdtrik_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_nbdtrik_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_nbdtrik_types[0] = <char>NPY_FLOAT
ufunc_nbdtrik_types[1] = <char>NPY_FLOAT
ufunc_nbdtrik_types[2] = <char>NPY_FLOAT
ufunc_nbdtrik_types[3] = <char>NPY_FLOAT
ufunc_nbdtrik_types[4] = <char>NPY_DOUBLE
ufunc_nbdtrik_types[5] = <char>NPY_DOUBLE
ufunc_nbdtrik_types[6] = <char>NPY_DOUBLE
ufunc_nbdtrik_types[7] = <char>NPY_DOUBLE
ufunc_nbdtrik_ptr[2*0] = <void*>_func_cdfnbn2_wrap
ufunc_nbdtrik_ptr[2*0+1] = <void*>(<char*>"nbdtrik")
ufunc_nbdtrik_ptr[2*1] = <void*>_func_cdfnbn2_wrap
ufunc_nbdtrik_ptr[2*1+1] = <void*>(<char*>"nbdtrik")
ufunc_nbdtrik_data[0] = &ufunc_nbdtrik_ptr[2*0]
ufunc_nbdtrik_data[1] = &ufunc_nbdtrik_ptr[2*1]
nbdtrik = np.PyUFunc_FromFuncAndData(ufunc_nbdtrik_loops, ufunc_nbdtrik_data, ufunc_nbdtrik_types, 2, 3, 1, 0, "nbdtrik", ufunc_nbdtrik_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_nbdtrin_loops[2]
cdef void *ufunc_nbdtrin_ptr[4]
cdef void *ufunc_nbdtrin_data[2]
cdef char ufunc_nbdtrin_types[8]
cdef char *ufunc_nbdtrin_doc = (
    "n=nbdtrin(k,y,p) finds the argument n such that nbdtr(k,n,p)=y.")
ufunc_nbdtrin_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_nbdtrin_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_nbdtrin_types[0] = <char>NPY_FLOAT
ufunc_nbdtrin_types[1] = <char>NPY_FLOAT
ufunc_nbdtrin_types[2] = <char>NPY_FLOAT
ufunc_nbdtrin_types[3] = <char>NPY_FLOAT
ufunc_nbdtrin_types[4] = <char>NPY_DOUBLE
ufunc_nbdtrin_types[5] = <char>NPY_DOUBLE
ufunc_nbdtrin_types[6] = <char>NPY_DOUBLE
ufunc_nbdtrin_types[7] = <char>NPY_DOUBLE
ufunc_nbdtrin_ptr[2*0] = <void*>_func_cdfnbn3_wrap
ufunc_nbdtrin_ptr[2*0+1] = <void*>(<char*>"nbdtrin")
ufunc_nbdtrin_ptr[2*1] = <void*>_func_cdfnbn3_wrap
ufunc_nbdtrin_ptr[2*1+1] = <void*>(<char*>"nbdtrin")
ufunc_nbdtrin_data[0] = &ufunc_nbdtrin_ptr[2*0]
ufunc_nbdtrin_data[1] = &ufunc_nbdtrin_ptr[2*1]
nbdtrin = np.PyUFunc_FromFuncAndData(ufunc_nbdtrin_loops, ufunc_nbdtrin_data, ufunc_nbdtrin_types, 2, 3, 1, 0, "nbdtrin", ufunc_nbdtrin_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ncfdtr_loops[2]
cdef void *ufunc_ncfdtr_ptr[4]
cdef void *ufunc_ncfdtr_data[2]
cdef char ufunc_ncfdtr_types[10]
cdef char *ufunc_ncfdtr_doc = (
    "")
ufunc_ncfdtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd__As_ffff_f
ufunc_ncfdtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd__As_dddd_d
ufunc_ncfdtr_types[0] = <char>NPY_FLOAT
ufunc_ncfdtr_types[1] = <char>NPY_FLOAT
ufunc_ncfdtr_types[2] = <char>NPY_FLOAT
ufunc_ncfdtr_types[3] = <char>NPY_FLOAT
ufunc_ncfdtr_types[4] = <char>NPY_FLOAT
ufunc_ncfdtr_types[5] = <char>NPY_DOUBLE
ufunc_ncfdtr_types[6] = <char>NPY_DOUBLE
ufunc_ncfdtr_types[7] = <char>NPY_DOUBLE
ufunc_ncfdtr_types[8] = <char>NPY_DOUBLE
ufunc_ncfdtr_types[9] = <char>NPY_DOUBLE
ufunc_ncfdtr_ptr[2*0] = <void*>_func_cdffnc1_wrap
ufunc_ncfdtr_ptr[2*0+1] = <void*>(<char*>"ncfdtr")
ufunc_ncfdtr_ptr[2*1] = <void*>_func_cdffnc1_wrap
ufunc_ncfdtr_ptr[2*1+1] = <void*>(<char*>"ncfdtr")
ufunc_ncfdtr_data[0] = &ufunc_ncfdtr_ptr[2*0]
ufunc_ncfdtr_data[1] = &ufunc_ncfdtr_ptr[2*1]
ncfdtr = np.PyUFunc_FromFuncAndData(ufunc_ncfdtr_loops, ufunc_ncfdtr_data, ufunc_ncfdtr_types, 2, 4, 1, 0, "ncfdtr", ufunc_ncfdtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ncfdtri_loops[2]
cdef void *ufunc_ncfdtri_ptr[4]
cdef void *ufunc_ncfdtri_data[2]
cdef char ufunc_ncfdtri_types[10]
cdef char *ufunc_ncfdtri_doc = (
    "")
ufunc_ncfdtri_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd__As_ffff_f
ufunc_ncfdtri_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd__As_dddd_d
ufunc_ncfdtri_types[0] = <char>NPY_FLOAT
ufunc_ncfdtri_types[1] = <char>NPY_FLOAT
ufunc_ncfdtri_types[2] = <char>NPY_FLOAT
ufunc_ncfdtri_types[3] = <char>NPY_FLOAT
ufunc_ncfdtri_types[4] = <char>NPY_FLOAT
ufunc_ncfdtri_types[5] = <char>NPY_DOUBLE
ufunc_ncfdtri_types[6] = <char>NPY_DOUBLE
ufunc_ncfdtri_types[7] = <char>NPY_DOUBLE
ufunc_ncfdtri_types[8] = <char>NPY_DOUBLE
ufunc_ncfdtri_types[9] = <char>NPY_DOUBLE
ufunc_ncfdtri_ptr[2*0] = <void*>_func_cdffnc2_wrap
ufunc_ncfdtri_ptr[2*0+1] = <void*>(<char*>"ncfdtri")
ufunc_ncfdtri_ptr[2*1] = <void*>_func_cdffnc2_wrap
ufunc_ncfdtri_ptr[2*1+1] = <void*>(<char*>"ncfdtri")
ufunc_ncfdtri_data[0] = &ufunc_ncfdtri_ptr[2*0]
ufunc_ncfdtri_data[1] = &ufunc_ncfdtri_ptr[2*1]
ncfdtri = np.PyUFunc_FromFuncAndData(ufunc_ncfdtri_loops, ufunc_ncfdtri_data, ufunc_ncfdtri_types, 2, 4, 1, 0, "ncfdtri", ufunc_ncfdtri_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ncfdtridfd_loops[2]
cdef void *ufunc_ncfdtridfd_ptr[4]
cdef void *ufunc_ncfdtridfd_data[2]
cdef char ufunc_ncfdtridfd_types[10]
cdef char *ufunc_ncfdtridfd_doc = (
    "")
ufunc_ncfdtridfd_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd__As_ffff_f
ufunc_ncfdtridfd_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd__As_dddd_d
ufunc_ncfdtridfd_types[0] = <char>NPY_FLOAT
ufunc_ncfdtridfd_types[1] = <char>NPY_FLOAT
ufunc_ncfdtridfd_types[2] = <char>NPY_FLOAT
ufunc_ncfdtridfd_types[3] = <char>NPY_FLOAT
ufunc_ncfdtridfd_types[4] = <char>NPY_FLOAT
ufunc_ncfdtridfd_types[5] = <char>NPY_DOUBLE
ufunc_ncfdtridfd_types[6] = <char>NPY_DOUBLE
ufunc_ncfdtridfd_types[7] = <char>NPY_DOUBLE
ufunc_ncfdtridfd_types[8] = <char>NPY_DOUBLE
ufunc_ncfdtridfd_types[9] = <char>NPY_DOUBLE
ufunc_ncfdtridfd_ptr[2*0] = <void*>_func_cdffnc4_wrap
ufunc_ncfdtridfd_ptr[2*0+1] = <void*>(<char*>"ncfdtridfd")
ufunc_ncfdtridfd_ptr[2*1] = <void*>_func_cdffnc4_wrap
ufunc_ncfdtridfd_ptr[2*1+1] = <void*>(<char*>"ncfdtridfd")
ufunc_ncfdtridfd_data[0] = &ufunc_ncfdtridfd_ptr[2*0]
ufunc_ncfdtridfd_data[1] = &ufunc_ncfdtridfd_ptr[2*1]
ncfdtridfd = np.PyUFunc_FromFuncAndData(ufunc_ncfdtridfd_loops, ufunc_ncfdtridfd_data, ufunc_ncfdtridfd_types, 2, 4, 1, 0, "ncfdtridfd", ufunc_ncfdtridfd_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ncfdtridfn_loops[2]
cdef void *ufunc_ncfdtridfn_ptr[4]
cdef void *ufunc_ncfdtridfn_data[2]
cdef char ufunc_ncfdtridfn_types[10]
cdef char *ufunc_ncfdtridfn_doc = (
    "")
ufunc_ncfdtridfn_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd__As_ffff_f
ufunc_ncfdtridfn_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd__As_dddd_d
ufunc_ncfdtridfn_types[0] = <char>NPY_FLOAT
ufunc_ncfdtridfn_types[1] = <char>NPY_FLOAT
ufunc_ncfdtridfn_types[2] = <char>NPY_FLOAT
ufunc_ncfdtridfn_types[3] = <char>NPY_FLOAT
ufunc_ncfdtridfn_types[4] = <char>NPY_FLOAT
ufunc_ncfdtridfn_types[5] = <char>NPY_DOUBLE
ufunc_ncfdtridfn_types[6] = <char>NPY_DOUBLE
ufunc_ncfdtridfn_types[7] = <char>NPY_DOUBLE
ufunc_ncfdtridfn_types[8] = <char>NPY_DOUBLE
ufunc_ncfdtridfn_types[9] = <char>NPY_DOUBLE
ufunc_ncfdtridfn_ptr[2*0] = <void*>_func_cdffnc3_wrap
ufunc_ncfdtridfn_ptr[2*0+1] = <void*>(<char*>"ncfdtridfn")
ufunc_ncfdtridfn_ptr[2*1] = <void*>_func_cdffnc3_wrap
ufunc_ncfdtridfn_ptr[2*1+1] = <void*>(<char*>"ncfdtridfn")
ufunc_ncfdtridfn_data[0] = &ufunc_ncfdtridfn_ptr[2*0]
ufunc_ncfdtridfn_data[1] = &ufunc_ncfdtridfn_ptr[2*1]
ncfdtridfn = np.PyUFunc_FromFuncAndData(ufunc_ncfdtridfn_loops, ufunc_ncfdtridfn_data, ufunc_ncfdtridfn_types, 2, 4, 1, 0, "ncfdtridfn", ufunc_ncfdtridfn_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ncfdtrinc_loops[2]
cdef void *ufunc_ncfdtrinc_ptr[4]
cdef void *ufunc_ncfdtrinc_data[2]
cdef char ufunc_ncfdtrinc_types[10]
cdef char *ufunc_ncfdtrinc_doc = (
    "")
ufunc_ncfdtrinc_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd__As_ffff_f
ufunc_ncfdtrinc_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd__As_dddd_d
ufunc_ncfdtrinc_types[0] = <char>NPY_FLOAT
ufunc_ncfdtrinc_types[1] = <char>NPY_FLOAT
ufunc_ncfdtrinc_types[2] = <char>NPY_FLOAT
ufunc_ncfdtrinc_types[3] = <char>NPY_FLOAT
ufunc_ncfdtrinc_types[4] = <char>NPY_FLOAT
ufunc_ncfdtrinc_types[5] = <char>NPY_DOUBLE
ufunc_ncfdtrinc_types[6] = <char>NPY_DOUBLE
ufunc_ncfdtrinc_types[7] = <char>NPY_DOUBLE
ufunc_ncfdtrinc_types[8] = <char>NPY_DOUBLE
ufunc_ncfdtrinc_types[9] = <char>NPY_DOUBLE
ufunc_ncfdtrinc_ptr[2*0] = <void*>_func_cdffnc5_wrap
ufunc_ncfdtrinc_ptr[2*0+1] = <void*>(<char*>"ncfdtrinc")
ufunc_ncfdtrinc_ptr[2*1] = <void*>_func_cdffnc5_wrap
ufunc_ncfdtrinc_ptr[2*1+1] = <void*>(<char*>"ncfdtrinc")
ufunc_ncfdtrinc_data[0] = &ufunc_ncfdtrinc_ptr[2*0]
ufunc_ncfdtrinc_data[1] = &ufunc_ncfdtrinc_ptr[2*1]
ncfdtrinc = np.PyUFunc_FromFuncAndData(ufunc_ncfdtrinc_loops, ufunc_ncfdtrinc_data, ufunc_ncfdtrinc_types, 2, 4, 1, 0, "ncfdtrinc", ufunc_ncfdtrinc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_nctdtr_loops[2]
cdef void *ufunc_nctdtr_ptr[4]
cdef void *ufunc_nctdtr_data[2]
cdef char ufunc_nctdtr_types[8]
cdef char *ufunc_nctdtr_doc = (
    "")
ufunc_nctdtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_nctdtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_nctdtr_types[0] = <char>NPY_FLOAT
ufunc_nctdtr_types[1] = <char>NPY_FLOAT
ufunc_nctdtr_types[2] = <char>NPY_FLOAT
ufunc_nctdtr_types[3] = <char>NPY_FLOAT
ufunc_nctdtr_types[4] = <char>NPY_DOUBLE
ufunc_nctdtr_types[5] = <char>NPY_DOUBLE
ufunc_nctdtr_types[6] = <char>NPY_DOUBLE
ufunc_nctdtr_types[7] = <char>NPY_DOUBLE
ufunc_nctdtr_ptr[2*0] = <void*>_func_cdftnc1_wrap
ufunc_nctdtr_ptr[2*0+1] = <void*>(<char*>"nctdtr")
ufunc_nctdtr_ptr[2*1] = <void*>_func_cdftnc1_wrap
ufunc_nctdtr_ptr[2*1+1] = <void*>(<char*>"nctdtr")
ufunc_nctdtr_data[0] = &ufunc_nctdtr_ptr[2*0]
ufunc_nctdtr_data[1] = &ufunc_nctdtr_ptr[2*1]
nctdtr = np.PyUFunc_FromFuncAndData(ufunc_nctdtr_loops, ufunc_nctdtr_data, ufunc_nctdtr_types, 2, 3, 1, 0, "nctdtr", ufunc_nctdtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_nctdtridf_loops[2]
cdef void *ufunc_nctdtridf_ptr[4]
cdef void *ufunc_nctdtridf_data[2]
cdef char ufunc_nctdtridf_types[8]
cdef char *ufunc_nctdtridf_doc = (
    "")
ufunc_nctdtridf_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_nctdtridf_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_nctdtridf_types[0] = <char>NPY_FLOAT
ufunc_nctdtridf_types[1] = <char>NPY_FLOAT
ufunc_nctdtridf_types[2] = <char>NPY_FLOAT
ufunc_nctdtridf_types[3] = <char>NPY_FLOAT
ufunc_nctdtridf_types[4] = <char>NPY_DOUBLE
ufunc_nctdtridf_types[5] = <char>NPY_DOUBLE
ufunc_nctdtridf_types[6] = <char>NPY_DOUBLE
ufunc_nctdtridf_types[7] = <char>NPY_DOUBLE
ufunc_nctdtridf_ptr[2*0] = <void*>_func_cdftnc3_wrap
ufunc_nctdtridf_ptr[2*0+1] = <void*>(<char*>"nctdtridf")
ufunc_nctdtridf_ptr[2*1] = <void*>_func_cdftnc3_wrap
ufunc_nctdtridf_ptr[2*1+1] = <void*>(<char*>"nctdtridf")
ufunc_nctdtridf_data[0] = &ufunc_nctdtridf_ptr[2*0]
ufunc_nctdtridf_data[1] = &ufunc_nctdtridf_ptr[2*1]
nctdtridf = np.PyUFunc_FromFuncAndData(ufunc_nctdtridf_loops, ufunc_nctdtridf_data, ufunc_nctdtridf_types, 2, 3, 1, 0, "nctdtridf", ufunc_nctdtridf_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_nctdtrinc_loops[2]
cdef void *ufunc_nctdtrinc_ptr[4]
cdef void *ufunc_nctdtrinc_data[2]
cdef char ufunc_nctdtrinc_types[8]
cdef char *ufunc_nctdtrinc_doc = (
    "")
ufunc_nctdtrinc_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_nctdtrinc_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_nctdtrinc_types[0] = <char>NPY_FLOAT
ufunc_nctdtrinc_types[1] = <char>NPY_FLOAT
ufunc_nctdtrinc_types[2] = <char>NPY_FLOAT
ufunc_nctdtrinc_types[3] = <char>NPY_FLOAT
ufunc_nctdtrinc_types[4] = <char>NPY_DOUBLE
ufunc_nctdtrinc_types[5] = <char>NPY_DOUBLE
ufunc_nctdtrinc_types[6] = <char>NPY_DOUBLE
ufunc_nctdtrinc_types[7] = <char>NPY_DOUBLE
ufunc_nctdtrinc_ptr[2*0] = <void*>_func_cdftnc4_wrap
ufunc_nctdtrinc_ptr[2*0+1] = <void*>(<char*>"nctdtrinc")
ufunc_nctdtrinc_ptr[2*1] = <void*>_func_cdftnc4_wrap
ufunc_nctdtrinc_ptr[2*1+1] = <void*>(<char*>"nctdtrinc")
ufunc_nctdtrinc_data[0] = &ufunc_nctdtrinc_ptr[2*0]
ufunc_nctdtrinc_data[1] = &ufunc_nctdtrinc_ptr[2*1]
nctdtrinc = np.PyUFunc_FromFuncAndData(ufunc_nctdtrinc_loops, ufunc_nctdtrinc_data, ufunc_nctdtrinc_types, 2, 3, 1, 0, "nctdtrinc", ufunc_nctdtrinc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_nctdtrit_loops[2]
cdef void *ufunc_nctdtrit_ptr[4]
cdef void *ufunc_nctdtrit_data[2]
cdef char ufunc_nctdtrit_types[8]
cdef char *ufunc_nctdtrit_doc = (
    "")
ufunc_nctdtrit_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_nctdtrit_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_nctdtrit_types[0] = <char>NPY_FLOAT
ufunc_nctdtrit_types[1] = <char>NPY_FLOAT
ufunc_nctdtrit_types[2] = <char>NPY_FLOAT
ufunc_nctdtrit_types[3] = <char>NPY_FLOAT
ufunc_nctdtrit_types[4] = <char>NPY_DOUBLE
ufunc_nctdtrit_types[5] = <char>NPY_DOUBLE
ufunc_nctdtrit_types[6] = <char>NPY_DOUBLE
ufunc_nctdtrit_types[7] = <char>NPY_DOUBLE
ufunc_nctdtrit_ptr[2*0] = <void*>_func_cdftnc2_wrap
ufunc_nctdtrit_ptr[2*0+1] = <void*>(<char*>"nctdtrit")
ufunc_nctdtrit_ptr[2*1] = <void*>_func_cdftnc2_wrap
ufunc_nctdtrit_ptr[2*1+1] = <void*>(<char*>"nctdtrit")
ufunc_nctdtrit_data[0] = &ufunc_nctdtrit_ptr[2*0]
ufunc_nctdtrit_data[1] = &ufunc_nctdtrit_ptr[2*1]
nctdtrit = np.PyUFunc_FromFuncAndData(ufunc_nctdtrit_loops, ufunc_nctdtrit_data, ufunc_nctdtrit_types, 2, 3, 1, 0, "nctdtrit", ufunc_nctdtrit_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ndtr_loops[2]
cdef void *ufunc_ndtr_ptr[4]
cdef void *ufunc_ndtr_data[2]
cdef char ufunc_ndtr_types[4]
cdef char *ufunc_ndtr_doc = (
    "y=ndtr(x) returns the area under the standard Gaussian probability\n"
    "density function, integrated from minus infinity to x:\n"
    "1/sqrt(2*pi) * integral(exp(-t**2 / 2),t=-inf..x)")
ufunc_ndtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_ndtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_ndtr_types[0] = <char>NPY_FLOAT
ufunc_ndtr_types[1] = <char>NPY_FLOAT
ufunc_ndtr_types[2] = <char>NPY_DOUBLE
ufunc_ndtr_types[3] = <char>NPY_DOUBLE
ufunc_ndtr_ptr[2*0] = <void*>_func_ndtr
ufunc_ndtr_ptr[2*0+1] = <void*>(<char*>"ndtr")
ufunc_ndtr_ptr[2*1] = <void*>_func_ndtr
ufunc_ndtr_ptr[2*1+1] = <void*>(<char*>"ndtr")
ufunc_ndtr_data[0] = &ufunc_ndtr_ptr[2*0]
ufunc_ndtr_data[1] = &ufunc_ndtr_ptr[2*1]
ndtr = np.PyUFunc_FromFuncAndData(ufunc_ndtr_loops, ufunc_ndtr_data, ufunc_ndtr_types, 2, 1, 1, 0, "ndtr", ufunc_ndtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_ndtri_loops[2]
cdef void *ufunc_ndtri_ptr[4]
cdef void *ufunc_ndtri_data[2]
cdef char ufunc_ndtri_types[4]
cdef char *ufunc_ndtri_doc = (
    "x=ndtri(y) returns the argument x for which the area udnder the\n"
    "Gaussian probability density function (integrated from minus infinity\n"
    "to x) is equal to y.")
ufunc_ndtri_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_ndtri_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_ndtri_types[0] = <char>NPY_FLOAT
ufunc_ndtri_types[1] = <char>NPY_FLOAT
ufunc_ndtri_types[2] = <char>NPY_DOUBLE
ufunc_ndtri_types[3] = <char>NPY_DOUBLE
ufunc_ndtri_ptr[2*0] = <void*>_func_ndtri
ufunc_ndtri_ptr[2*0+1] = <void*>(<char*>"ndtri")
ufunc_ndtri_ptr[2*1] = <void*>_func_ndtri
ufunc_ndtri_ptr[2*1+1] = <void*>(<char*>"ndtri")
ufunc_ndtri_data[0] = &ufunc_ndtri_ptr[2*0]
ufunc_ndtri_data[1] = &ufunc_ndtri_ptr[2*1]
ndtri = np.PyUFunc_FromFuncAndData(ufunc_ndtri_loops, ufunc_ndtri_data, ufunc_ndtri_types, 2, 1, 1, 0, "ndtri", ufunc_ndtri_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_nrdtrimn_loops[2]
cdef void *ufunc_nrdtrimn_ptr[4]
cdef void *ufunc_nrdtrimn_data[2]
cdef char ufunc_nrdtrimn_types[8]
cdef char *ufunc_nrdtrimn_doc = (
    "")
ufunc_nrdtrimn_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_nrdtrimn_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_nrdtrimn_types[0] = <char>NPY_FLOAT
ufunc_nrdtrimn_types[1] = <char>NPY_FLOAT
ufunc_nrdtrimn_types[2] = <char>NPY_FLOAT
ufunc_nrdtrimn_types[3] = <char>NPY_FLOAT
ufunc_nrdtrimn_types[4] = <char>NPY_DOUBLE
ufunc_nrdtrimn_types[5] = <char>NPY_DOUBLE
ufunc_nrdtrimn_types[6] = <char>NPY_DOUBLE
ufunc_nrdtrimn_types[7] = <char>NPY_DOUBLE
ufunc_nrdtrimn_ptr[2*0] = <void*>_func_cdfnor3_wrap
ufunc_nrdtrimn_ptr[2*0+1] = <void*>(<char*>"nrdtrimn")
ufunc_nrdtrimn_ptr[2*1] = <void*>_func_cdfnor3_wrap
ufunc_nrdtrimn_ptr[2*1+1] = <void*>(<char*>"nrdtrimn")
ufunc_nrdtrimn_data[0] = &ufunc_nrdtrimn_ptr[2*0]
ufunc_nrdtrimn_data[1] = &ufunc_nrdtrimn_ptr[2*1]
nrdtrimn = np.PyUFunc_FromFuncAndData(ufunc_nrdtrimn_loops, ufunc_nrdtrimn_data, ufunc_nrdtrimn_types, 2, 3, 1, 0, "nrdtrimn", ufunc_nrdtrimn_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_nrdtrisd_loops[2]
cdef void *ufunc_nrdtrisd_ptr[4]
cdef void *ufunc_nrdtrisd_data[2]
cdef char ufunc_nrdtrisd_types[8]
cdef char *ufunc_nrdtrisd_doc = (
    "")
ufunc_nrdtrisd_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_nrdtrisd_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_nrdtrisd_types[0] = <char>NPY_FLOAT
ufunc_nrdtrisd_types[1] = <char>NPY_FLOAT
ufunc_nrdtrisd_types[2] = <char>NPY_FLOAT
ufunc_nrdtrisd_types[3] = <char>NPY_FLOAT
ufunc_nrdtrisd_types[4] = <char>NPY_DOUBLE
ufunc_nrdtrisd_types[5] = <char>NPY_DOUBLE
ufunc_nrdtrisd_types[6] = <char>NPY_DOUBLE
ufunc_nrdtrisd_types[7] = <char>NPY_DOUBLE
ufunc_nrdtrisd_ptr[2*0] = <void*>_func_cdfnor4_wrap
ufunc_nrdtrisd_ptr[2*0+1] = <void*>(<char*>"nrdtrisd")
ufunc_nrdtrisd_ptr[2*1] = <void*>_func_cdfnor4_wrap
ufunc_nrdtrisd_ptr[2*1+1] = <void*>(<char*>"nrdtrisd")
ufunc_nrdtrisd_data[0] = &ufunc_nrdtrisd_ptr[2*0]
ufunc_nrdtrisd_data[1] = &ufunc_nrdtrisd_ptr[2*1]
nrdtrisd = np.PyUFunc_FromFuncAndData(ufunc_nrdtrisd_loops, ufunc_nrdtrisd_data, ufunc_nrdtrisd_types, 2, 3, 1, 0, "nrdtrisd", ufunc_nrdtrisd_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_obl_ang1_loops[2]
cdef void *ufunc_obl_ang1_ptr[4]
cdef void *ufunc_obl_ang1_data[2]
cdef char ufunc_obl_ang1_types[12]
cdef char *ufunc_obl_ang1_doc = (
    "(s,sp)=obl_ang1(m,n,c,x) computes the oblate sheroidal angular function\n"
    "of the first kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and ``|x| < 1.0``.")
ufunc_obl_ang1_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_ffff_ff
ufunc_obl_ang1_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_dddd_dd
ufunc_obl_ang1_types[0] = <char>NPY_FLOAT
ufunc_obl_ang1_types[1] = <char>NPY_FLOAT
ufunc_obl_ang1_types[2] = <char>NPY_FLOAT
ufunc_obl_ang1_types[3] = <char>NPY_FLOAT
ufunc_obl_ang1_types[4] = <char>NPY_FLOAT
ufunc_obl_ang1_types[5] = <char>NPY_FLOAT
ufunc_obl_ang1_types[6] = <char>NPY_DOUBLE
ufunc_obl_ang1_types[7] = <char>NPY_DOUBLE
ufunc_obl_ang1_types[8] = <char>NPY_DOUBLE
ufunc_obl_ang1_types[9] = <char>NPY_DOUBLE
ufunc_obl_ang1_types[10] = <char>NPY_DOUBLE
ufunc_obl_ang1_types[11] = <char>NPY_DOUBLE
ufunc_obl_ang1_ptr[2*0] = <void*>_func_oblate_aswfa_nocv_wrap
ufunc_obl_ang1_ptr[2*0+1] = <void*>(<char*>"obl_ang1")
ufunc_obl_ang1_ptr[2*1] = <void*>_func_oblate_aswfa_nocv_wrap
ufunc_obl_ang1_ptr[2*1+1] = <void*>(<char*>"obl_ang1")
ufunc_obl_ang1_data[0] = &ufunc_obl_ang1_ptr[2*0]
ufunc_obl_ang1_data[1] = &ufunc_obl_ang1_ptr[2*1]
obl_ang1 = np.PyUFunc_FromFuncAndData(ufunc_obl_ang1_loops, ufunc_obl_ang1_data, ufunc_obl_ang1_types, 2, 4, 2, 0, "obl_ang1", ufunc_obl_ang1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_obl_ang1_cv_loops[2]
cdef void *ufunc_obl_ang1_cv_ptr[4]
cdef void *ufunc_obl_ang1_cv_data[2]
cdef char ufunc_obl_ang1_cv_types[14]
cdef char *ufunc_obl_ang1_cv_doc = (
    "(s,sp)=obl_ang1_cv(m,n,c,cv,x) computes the oblate sheroidal angular function\n"
    "of the first kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and ``|x| < 1.0``. Requires pre-computed\n"
    "characteristic value.")
ufunc_obl_ang1_cv_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_fffff_ff
ufunc_obl_ang1_cv_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_ddddd_dd
ufunc_obl_ang1_cv_types[0] = <char>NPY_FLOAT
ufunc_obl_ang1_cv_types[1] = <char>NPY_FLOAT
ufunc_obl_ang1_cv_types[2] = <char>NPY_FLOAT
ufunc_obl_ang1_cv_types[3] = <char>NPY_FLOAT
ufunc_obl_ang1_cv_types[4] = <char>NPY_FLOAT
ufunc_obl_ang1_cv_types[5] = <char>NPY_FLOAT
ufunc_obl_ang1_cv_types[6] = <char>NPY_FLOAT
ufunc_obl_ang1_cv_types[7] = <char>NPY_DOUBLE
ufunc_obl_ang1_cv_types[8] = <char>NPY_DOUBLE
ufunc_obl_ang1_cv_types[9] = <char>NPY_DOUBLE
ufunc_obl_ang1_cv_types[10] = <char>NPY_DOUBLE
ufunc_obl_ang1_cv_types[11] = <char>NPY_DOUBLE
ufunc_obl_ang1_cv_types[12] = <char>NPY_DOUBLE
ufunc_obl_ang1_cv_types[13] = <char>NPY_DOUBLE
ufunc_obl_ang1_cv_ptr[2*0] = <void*>_func_oblate_aswfa_wrap
ufunc_obl_ang1_cv_ptr[2*0+1] = <void*>(<char*>"obl_ang1_cv")
ufunc_obl_ang1_cv_ptr[2*1] = <void*>_func_oblate_aswfa_wrap
ufunc_obl_ang1_cv_ptr[2*1+1] = <void*>(<char*>"obl_ang1_cv")
ufunc_obl_ang1_cv_data[0] = &ufunc_obl_ang1_cv_ptr[2*0]
ufunc_obl_ang1_cv_data[1] = &ufunc_obl_ang1_cv_ptr[2*1]
obl_ang1_cv = np.PyUFunc_FromFuncAndData(ufunc_obl_ang1_cv_loops, ufunc_obl_ang1_cv_data, ufunc_obl_ang1_cv_types, 2, 5, 2, 0, "obl_ang1_cv", ufunc_obl_ang1_cv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_obl_cv_loops[2]
cdef void *ufunc_obl_cv_ptr[4]
cdef void *ufunc_obl_cv_data[2]
cdef char ufunc_obl_cv_types[8]
cdef char *ufunc_obl_cv_doc = (
    "cv=obl_cv(m,n,c) computes the characteristic value of oblate spheroidal\n"
    "wave functions of order m,n (n>=m) and spheroidal parameter c.")
ufunc_obl_cv_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_obl_cv_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_obl_cv_types[0] = <char>NPY_FLOAT
ufunc_obl_cv_types[1] = <char>NPY_FLOAT
ufunc_obl_cv_types[2] = <char>NPY_FLOAT
ufunc_obl_cv_types[3] = <char>NPY_FLOAT
ufunc_obl_cv_types[4] = <char>NPY_DOUBLE
ufunc_obl_cv_types[5] = <char>NPY_DOUBLE
ufunc_obl_cv_types[6] = <char>NPY_DOUBLE
ufunc_obl_cv_types[7] = <char>NPY_DOUBLE
ufunc_obl_cv_ptr[2*0] = <void*>_func_oblate_segv_wrap
ufunc_obl_cv_ptr[2*0+1] = <void*>(<char*>"obl_cv")
ufunc_obl_cv_ptr[2*1] = <void*>_func_oblate_segv_wrap
ufunc_obl_cv_ptr[2*1+1] = <void*>(<char*>"obl_cv")
ufunc_obl_cv_data[0] = &ufunc_obl_cv_ptr[2*0]
ufunc_obl_cv_data[1] = &ufunc_obl_cv_ptr[2*1]
obl_cv = np.PyUFunc_FromFuncAndData(ufunc_obl_cv_loops, ufunc_obl_cv_data, ufunc_obl_cv_types, 2, 3, 1, 0, "obl_cv", ufunc_obl_cv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_obl_rad1_loops[2]
cdef void *ufunc_obl_rad1_ptr[4]
cdef void *ufunc_obl_rad1_data[2]
cdef char ufunc_obl_rad1_types[12]
cdef char *ufunc_obl_rad1_doc = (
    "(s,sp)=obl_rad1(m,n,c,x) computes the oblate sheroidal radial function\n"
    "of the first kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and ``|x| < 1.0``.")
ufunc_obl_rad1_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_ffff_ff
ufunc_obl_rad1_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_dddd_dd
ufunc_obl_rad1_types[0] = <char>NPY_FLOAT
ufunc_obl_rad1_types[1] = <char>NPY_FLOAT
ufunc_obl_rad1_types[2] = <char>NPY_FLOAT
ufunc_obl_rad1_types[3] = <char>NPY_FLOAT
ufunc_obl_rad1_types[4] = <char>NPY_FLOAT
ufunc_obl_rad1_types[5] = <char>NPY_FLOAT
ufunc_obl_rad1_types[6] = <char>NPY_DOUBLE
ufunc_obl_rad1_types[7] = <char>NPY_DOUBLE
ufunc_obl_rad1_types[8] = <char>NPY_DOUBLE
ufunc_obl_rad1_types[9] = <char>NPY_DOUBLE
ufunc_obl_rad1_types[10] = <char>NPY_DOUBLE
ufunc_obl_rad1_types[11] = <char>NPY_DOUBLE
ufunc_obl_rad1_ptr[2*0] = <void*>_func_oblate_radial1_nocv_wrap
ufunc_obl_rad1_ptr[2*0+1] = <void*>(<char*>"obl_rad1")
ufunc_obl_rad1_ptr[2*1] = <void*>_func_oblate_radial1_nocv_wrap
ufunc_obl_rad1_ptr[2*1+1] = <void*>(<char*>"obl_rad1")
ufunc_obl_rad1_data[0] = &ufunc_obl_rad1_ptr[2*0]
ufunc_obl_rad1_data[1] = &ufunc_obl_rad1_ptr[2*1]
obl_rad1 = np.PyUFunc_FromFuncAndData(ufunc_obl_rad1_loops, ufunc_obl_rad1_data, ufunc_obl_rad1_types, 2, 4, 2, 0, "obl_rad1", ufunc_obl_rad1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_obl_rad1_cv_loops[2]
cdef void *ufunc_obl_rad1_cv_ptr[4]
cdef void *ufunc_obl_rad1_cv_data[2]
cdef char ufunc_obl_rad1_cv_types[14]
cdef char *ufunc_obl_rad1_cv_doc = (
    "(s,sp)=obl_rad1_cv(m,n,c,cv,x) computes the oblate sheroidal radial function\n"
    "of the first kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and ``|x| < 1.0``. Requires pre-computed\n"
    "characteristic value.")
ufunc_obl_rad1_cv_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_fffff_ff
ufunc_obl_rad1_cv_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_ddddd_dd
ufunc_obl_rad1_cv_types[0] = <char>NPY_FLOAT
ufunc_obl_rad1_cv_types[1] = <char>NPY_FLOAT
ufunc_obl_rad1_cv_types[2] = <char>NPY_FLOAT
ufunc_obl_rad1_cv_types[3] = <char>NPY_FLOAT
ufunc_obl_rad1_cv_types[4] = <char>NPY_FLOAT
ufunc_obl_rad1_cv_types[5] = <char>NPY_FLOAT
ufunc_obl_rad1_cv_types[6] = <char>NPY_FLOAT
ufunc_obl_rad1_cv_types[7] = <char>NPY_DOUBLE
ufunc_obl_rad1_cv_types[8] = <char>NPY_DOUBLE
ufunc_obl_rad1_cv_types[9] = <char>NPY_DOUBLE
ufunc_obl_rad1_cv_types[10] = <char>NPY_DOUBLE
ufunc_obl_rad1_cv_types[11] = <char>NPY_DOUBLE
ufunc_obl_rad1_cv_types[12] = <char>NPY_DOUBLE
ufunc_obl_rad1_cv_types[13] = <char>NPY_DOUBLE
ufunc_obl_rad1_cv_ptr[2*0] = <void*>_func_oblate_radial1_wrap
ufunc_obl_rad1_cv_ptr[2*0+1] = <void*>(<char*>"obl_rad1_cv")
ufunc_obl_rad1_cv_ptr[2*1] = <void*>_func_oblate_radial1_wrap
ufunc_obl_rad1_cv_ptr[2*1+1] = <void*>(<char*>"obl_rad1_cv")
ufunc_obl_rad1_cv_data[0] = &ufunc_obl_rad1_cv_ptr[2*0]
ufunc_obl_rad1_cv_data[1] = &ufunc_obl_rad1_cv_ptr[2*1]
obl_rad1_cv = np.PyUFunc_FromFuncAndData(ufunc_obl_rad1_cv_loops, ufunc_obl_rad1_cv_data, ufunc_obl_rad1_cv_types, 2, 5, 2, 0, "obl_rad1_cv", ufunc_obl_rad1_cv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_obl_rad2_loops[2]
cdef void *ufunc_obl_rad2_ptr[4]
cdef void *ufunc_obl_rad2_data[2]
cdef char ufunc_obl_rad2_types[12]
cdef char *ufunc_obl_rad2_doc = (
    "(s,sp)=obl_rad2(m,n,c,x) computes the oblate sheroidal radial function\n"
    "of the second kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and ``|x| < 1.0``.")
ufunc_obl_rad2_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_ffff_ff
ufunc_obl_rad2_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_dddd_dd
ufunc_obl_rad2_types[0] = <char>NPY_FLOAT
ufunc_obl_rad2_types[1] = <char>NPY_FLOAT
ufunc_obl_rad2_types[2] = <char>NPY_FLOAT
ufunc_obl_rad2_types[3] = <char>NPY_FLOAT
ufunc_obl_rad2_types[4] = <char>NPY_FLOAT
ufunc_obl_rad2_types[5] = <char>NPY_FLOAT
ufunc_obl_rad2_types[6] = <char>NPY_DOUBLE
ufunc_obl_rad2_types[7] = <char>NPY_DOUBLE
ufunc_obl_rad2_types[8] = <char>NPY_DOUBLE
ufunc_obl_rad2_types[9] = <char>NPY_DOUBLE
ufunc_obl_rad2_types[10] = <char>NPY_DOUBLE
ufunc_obl_rad2_types[11] = <char>NPY_DOUBLE
ufunc_obl_rad2_ptr[2*0] = <void*>_func_oblate_radial2_nocv_wrap
ufunc_obl_rad2_ptr[2*0+1] = <void*>(<char*>"obl_rad2")
ufunc_obl_rad2_ptr[2*1] = <void*>_func_oblate_radial2_nocv_wrap
ufunc_obl_rad2_ptr[2*1+1] = <void*>(<char*>"obl_rad2")
ufunc_obl_rad2_data[0] = &ufunc_obl_rad2_ptr[2*0]
ufunc_obl_rad2_data[1] = &ufunc_obl_rad2_ptr[2*1]
obl_rad2 = np.PyUFunc_FromFuncAndData(ufunc_obl_rad2_loops, ufunc_obl_rad2_data, ufunc_obl_rad2_types, 2, 4, 2, 0, "obl_rad2", ufunc_obl_rad2_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_obl_rad2_cv_loops[2]
cdef void *ufunc_obl_rad2_cv_ptr[4]
cdef void *ufunc_obl_rad2_cv_data[2]
cdef char ufunc_obl_rad2_cv_types[14]
cdef char *ufunc_obl_rad2_cv_doc = (
    "(s,sp)=obl_rad2_cv(m,n,c,cv,x) computes the oblate sheroidal radial function\n"
    "of the second kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and ``|x| < 1.0``. Requires pre-computed\n"
    "characteristic value.")
ufunc_obl_rad2_cv_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_fffff_ff
ufunc_obl_rad2_cv_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_ddddd_dd
ufunc_obl_rad2_cv_types[0] = <char>NPY_FLOAT
ufunc_obl_rad2_cv_types[1] = <char>NPY_FLOAT
ufunc_obl_rad2_cv_types[2] = <char>NPY_FLOAT
ufunc_obl_rad2_cv_types[3] = <char>NPY_FLOAT
ufunc_obl_rad2_cv_types[4] = <char>NPY_FLOAT
ufunc_obl_rad2_cv_types[5] = <char>NPY_FLOAT
ufunc_obl_rad2_cv_types[6] = <char>NPY_FLOAT
ufunc_obl_rad2_cv_types[7] = <char>NPY_DOUBLE
ufunc_obl_rad2_cv_types[8] = <char>NPY_DOUBLE
ufunc_obl_rad2_cv_types[9] = <char>NPY_DOUBLE
ufunc_obl_rad2_cv_types[10] = <char>NPY_DOUBLE
ufunc_obl_rad2_cv_types[11] = <char>NPY_DOUBLE
ufunc_obl_rad2_cv_types[12] = <char>NPY_DOUBLE
ufunc_obl_rad2_cv_types[13] = <char>NPY_DOUBLE
ufunc_obl_rad2_cv_ptr[2*0] = <void*>_func_oblate_radial2_wrap
ufunc_obl_rad2_cv_ptr[2*0+1] = <void*>(<char*>"obl_rad2_cv")
ufunc_obl_rad2_cv_ptr[2*1] = <void*>_func_oblate_radial2_wrap
ufunc_obl_rad2_cv_ptr[2*1+1] = <void*>(<char*>"obl_rad2_cv")
ufunc_obl_rad2_cv_data[0] = &ufunc_obl_rad2_cv_ptr[2*0]
ufunc_obl_rad2_cv_data[1] = &ufunc_obl_rad2_cv_ptr[2*1]
obl_rad2_cv = np.PyUFunc_FromFuncAndData(ufunc_obl_rad2_cv_loops, ufunc_obl_rad2_cv_data, ufunc_obl_rad2_cv_types, 2, 5, 2, 0, "obl_rad2_cv", ufunc_obl_rad2_cv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pbdv_loops[2]
cdef void *ufunc_pbdv_ptr[4]
cdef void *ufunc_pbdv_data[2]
cdef char ufunc_pbdv_types[8]
cdef char *ufunc_pbdv_doc = (
    "(d,dp)=pbdv(v,x) returns (d,dp) with the parabolic cylinder function Dv(x) in\n"
    "d and the derivative, Dv'(x) in dp.")
ufunc_pbdv_loops[0] = <np.PyUFuncGenericFunction>loop_i_dd_dd_As_ff_ff
ufunc_pbdv_loops[1] = <np.PyUFuncGenericFunction>loop_i_dd_dd_As_dd_dd
ufunc_pbdv_types[0] = <char>NPY_FLOAT
ufunc_pbdv_types[1] = <char>NPY_FLOAT
ufunc_pbdv_types[2] = <char>NPY_FLOAT
ufunc_pbdv_types[3] = <char>NPY_FLOAT
ufunc_pbdv_types[4] = <char>NPY_DOUBLE
ufunc_pbdv_types[5] = <char>NPY_DOUBLE
ufunc_pbdv_types[6] = <char>NPY_DOUBLE
ufunc_pbdv_types[7] = <char>NPY_DOUBLE
ufunc_pbdv_ptr[2*0] = <void*>_func_pbdv_wrap
ufunc_pbdv_ptr[2*0+1] = <void*>(<char*>"pbdv")
ufunc_pbdv_ptr[2*1] = <void*>_func_pbdv_wrap
ufunc_pbdv_ptr[2*1+1] = <void*>(<char*>"pbdv")
ufunc_pbdv_data[0] = &ufunc_pbdv_ptr[2*0]
ufunc_pbdv_data[1] = &ufunc_pbdv_ptr[2*1]
pbdv = np.PyUFunc_FromFuncAndData(ufunc_pbdv_loops, ufunc_pbdv_data, ufunc_pbdv_types, 2, 2, 2, 0, "pbdv", ufunc_pbdv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pbvv_loops[2]
cdef void *ufunc_pbvv_ptr[4]
cdef void *ufunc_pbvv_data[2]
cdef char ufunc_pbvv_types[8]
cdef char *ufunc_pbvv_doc = (
    "(v,vp)=pbvv(v,x) returns (v,vp) with the parabolic cylinder function Vv(x) in\n"
    "v and the derivative, Vv'(x) in vp.")
ufunc_pbvv_loops[0] = <np.PyUFuncGenericFunction>loop_i_dd_dd_As_ff_ff
ufunc_pbvv_loops[1] = <np.PyUFuncGenericFunction>loop_i_dd_dd_As_dd_dd
ufunc_pbvv_types[0] = <char>NPY_FLOAT
ufunc_pbvv_types[1] = <char>NPY_FLOAT
ufunc_pbvv_types[2] = <char>NPY_FLOAT
ufunc_pbvv_types[3] = <char>NPY_FLOAT
ufunc_pbvv_types[4] = <char>NPY_DOUBLE
ufunc_pbvv_types[5] = <char>NPY_DOUBLE
ufunc_pbvv_types[6] = <char>NPY_DOUBLE
ufunc_pbvv_types[7] = <char>NPY_DOUBLE
ufunc_pbvv_ptr[2*0] = <void*>_func_pbvv_wrap
ufunc_pbvv_ptr[2*0+1] = <void*>(<char*>"pbvv")
ufunc_pbvv_ptr[2*1] = <void*>_func_pbvv_wrap
ufunc_pbvv_ptr[2*1+1] = <void*>(<char*>"pbvv")
ufunc_pbvv_data[0] = &ufunc_pbvv_ptr[2*0]
ufunc_pbvv_data[1] = &ufunc_pbvv_ptr[2*1]
pbvv = np.PyUFunc_FromFuncAndData(ufunc_pbvv_loops, ufunc_pbvv_data, ufunc_pbvv_types, 2, 2, 2, 0, "pbvv", ufunc_pbvv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pbwa_loops[2]
cdef void *ufunc_pbwa_ptr[4]
cdef void *ufunc_pbwa_data[2]
cdef char ufunc_pbwa_types[8]
cdef char *ufunc_pbwa_doc = (
    "(w,wp)=pbwa(a,x) returns (w,wp) with the parabolic cylinder function W(a,x) in\n"
    "w and the derivative, W'(a,x) in wp.  May not be accurate for large (>5)\n"
    "arguments in a and/or x.")
ufunc_pbwa_loops[0] = <np.PyUFuncGenericFunction>loop_i_dd_dd_As_ff_ff
ufunc_pbwa_loops[1] = <np.PyUFuncGenericFunction>loop_i_dd_dd_As_dd_dd
ufunc_pbwa_types[0] = <char>NPY_FLOAT
ufunc_pbwa_types[1] = <char>NPY_FLOAT
ufunc_pbwa_types[2] = <char>NPY_FLOAT
ufunc_pbwa_types[3] = <char>NPY_FLOAT
ufunc_pbwa_types[4] = <char>NPY_DOUBLE
ufunc_pbwa_types[5] = <char>NPY_DOUBLE
ufunc_pbwa_types[6] = <char>NPY_DOUBLE
ufunc_pbwa_types[7] = <char>NPY_DOUBLE
ufunc_pbwa_ptr[2*0] = <void*>_func_pbwa_wrap
ufunc_pbwa_ptr[2*0+1] = <void*>(<char*>"pbwa")
ufunc_pbwa_ptr[2*1] = <void*>_func_pbwa_wrap
ufunc_pbwa_ptr[2*1+1] = <void*>(<char*>"pbwa")
ufunc_pbwa_data[0] = &ufunc_pbwa_ptr[2*0]
ufunc_pbwa_data[1] = &ufunc_pbwa_ptr[2*1]
pbwa = np.PyUFunc_FromFuncAndData(ufunc_pbwa_loops, ufunc_pbwa_data, ufunc_pbwa_types, 2, 2, 2, 0, "pbwa", ufunc_pbwa_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pdtr_loops[4]
cdef void *ufunc_pdtr_ptr[8]
cdef void *ufunc_pdtr_data[4]
cdef char ufunc_pdtr_types[12]
cdef char *ufunc_pdtr_doc = (
    "y=pdtr(k,m) returns the sum of the first k terms of the Poisson\n"
    "distribution: sum(exp(-m) * m**j / j!, j=0..k) = gammaincc( k+1, m).\n"
    "Arguments must both be positive and k an integer.")
ufunc_pdtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_id__As_lf_f
ufunc_pdtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_id__As_ld_d
ufunc_pdtr_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_pdtr_loops[3] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_pdtr_types[0] = <char>NPY_LONG
ufunc_pdtr_types[1] = <char>NPY_FLOAT
ufunc_pdtr_types[2] = <char>NPY_FLOAT
ufunc_pdtr_types[3] = <char>NPY_LONG
ufunc_pdtr_types[4] = <char>NPY_DOUBLE
ufunc_pdtr_types[5] = <char>NPY_DOUBLE
ufunc_pdtr_types[6] = <char>NPY_FLOAT
ufunc_pdtr_types[7] = <char>NPY_FLOAT
ufunc_pdtr_types[8] = <char>NPY_FLOAT
ufunc_pdtr_types[9] = <char>NPY_DOUBLE
ufunc_pdtr_types[10] = <char>NPY_DOUBLE
ufunc_pdtr_types[11] = <char>NPY_DOUBLE
ufunc_pdtr_ptr[2*0] = <void*>_func_pdtr
ufunc_pdtr_ptr[2*0+1] = <void*>(<char*>"pdtr")
ufunc_pdtr_ptr[2*1] = <void*>_func_pdtr
ufunc_pdtr_ptr[2*1+1] = <void*>(<char*>"pdtr")
ufunc_pdtr_ptr[2*2] = <void*>_func_pdtr_unsafe
ufunc_pdtr_ptr[2*2+1] = <void*>(<char*>"pdtr")
ufunc_pdtr_ptr[2*3] = <void*>_func_pdtr_unsafe
ufunc_pdtr_ptr[2*3+1] = <void*>(<char*>"pdtr")
ufunc_pdtr_data[0] = &ufunc_pdtr_ptr[2*0]
ufunc_pdtr_data[1] = &ufunc_pdtr_ptr[2*1]
ufunc_pdtr_data[2] = &ufunc_pdtr_ptr[2*2]
ufunc_pdtr_data[3] = &ufunc_pdtr_ptr[2*3]
pdtr = np.PyUFunc_FromFuncAndData(ufunc_pdtr_loops, ufunc_pdtr_data, ufunc_pdtr_types, 4, 2, 1, 0, "pdtr", ufunc_pdtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pdtrc_loops[4]
cdef void *ufunc_pdtrc_ptr[8]
cdef void *ufunc_pdtrc_data[4]
cdef char ufunc_pdtrc_types[12]
cdef char *ufunc_pdtrc_doc = (
    "y=pdtrc(k,m) returns the sum of the terms from k+1 to infinity of the\n"
    "Poisson distribution: sum(exp(-m) * m**j / j!, j=k+1..inf) = gammainc( k+1, m).\n"
    "Arguments must both be positive and k an integer.")
ufunc_pdtrc_loops[0] = <np.PyUFuncGenericFunction>loop_d_id__As_lf_f
ufunc_pdtrc_loops[1] = <np.PyUFuncGenericFunction>loop_d_id__As_ld_d
ufunc_pdtrc_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_pdtrc_loops[3] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_pdtrc_types[0] = <char>NPY_LONG
ufunc_pdtrc_types[1] = <char>NPY_FLOAT
ufunc_pdtrc_types[2] = <char>NPY_FLOAT
ufunc_pdtrc_types[3] = <char>NPY_LONG
ufunc_pdtrc_types[4] = <char>NPY_DOUBLE
ufunc_pdtrc_types[5] = <char>NPY_DOUBLE
ufunc_pdtrc_types[6] = <char>NPY_FLOAT
ufunc_pdtrc_types[7] = <char>NPY_FLOAT
ufunc_pdtrc_types[8] = <char>NPY_FLOAT
ufunc_pdtrc_types[9] = <char>NPY_DOUBLE
ufunc_pdtrc_types[10] = <char>NPY_DOUBLE
ufunc_pdtrc_types[11] = <char>NPY_DOUBLE
ufunc_pdtrc_ptr[2*0] = <void*>_func_pdtrc
ufunc_pdtrc_ptr[2*0+1] = <void*>(<char*>"pdtrc")
ufunc_pdtrc_ptr[2*1] = <void*>_func_pdtrc
ufunc_pdtrc_ptr[2*1+1] = <void*>(<char*>"pdtrc")
ufunc_pdtrc_ptr[2*2] = <void*>_func_pdtrc_unsafe
ufunc_pdtrc_ptr[2*2+1] = <void*>(<char*>"pdtrc")
ufunc_pdtrc_ptr[2*3] = <void*>_func_pdtrc_unsafe
ufunc_pdtrc_ptr[2*3+1] = <void*>(<char*>"pdtrc")
ufunc_pdtrc_data[0] = &ufunc_pdtrc_ptr[2*0]
ufunc_pdtrc_data[1] = &ufunc_pdtrc_ptr[2*1]
ufunc_pdtrc_data[2] = &ufunc_pdtrc_ptr[2*2]
ufunc_pdtrc_data[3] = &ufunc_pdtrc_ptr[2*3]
pdtrc = np.PyUFunc_FromFuncAndData(ufunc_pdtrc_loops, ufunc_pdtrc_data, ufunc_pdtrc_types, 4, 2, 1, 0, "pdtrc", ufunc_pdtrc_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pdtri_loops[4]
cdef void *ufunc_pdtri_ptr[8]
cdef void *ufunc_pdtri_data[4]
cdef char ufunc_pdtri_types[12]
cdef char *ufunc_pdtri_doc = (
    "m=pdtri(k,y) returns the Poisson variable m such that the sum\n"
    "from 0 to k of the Poisson density is equal to the given probability\n"
    "y:  calculated by gammaincinv( k+1, y).  k must be a nonnegative integer and\n"
    "y between 0 and 1.")
ufunc_pdtri_loops[0] = <np.PyUFuncGenericFunction>loop_d_id__As_lf_f
ufunc_pdtri_loops[1] = <np.PyUFuncGenericFunction>loop_d_id__As_ld_d
ufunc_pdtri_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_pdtri_loops[3] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_pdtri_types[0] = <char>NPY_LONG
ufunc_pdtri_types[1] = <char>NPY_FLOAT
ufunc_pdtri_types[2] = <char>NPY_FLOAT
ufunc_pdtri_types[3] = <char>NPY_LONG
ufunc_pdtri_types[4] = <char>NPY_DOUBLE
ufunc_pdtri_types[5] = <char>NPY_DOUBLE
ufunc_pdtri_types[6] = <char>NPY_FLOAT
ufunc_pdtri_types[7] = <char>NPY_FLOAT
ufunc_pdtri_types[8] = <char>NPY_FLOAT
ufunc_pdtri_types[9] = <char>NPY_DOUBLE
ufunc_pdtri_types[10] = <char>NPY_DOUBLE
ufunc_pdtri_types[11] = <char>NPY_DOUBLE
ufunc_pdtri_ptr[2*0] = <void*>_func_pdtri
ufunc_pdtri_ptr[2*0+1] = <void*>(<char*>"pdtri")
ufunc_pdtri_ptr[2*1] = <void*>_func_pdtri
ufunc_pdtri_ptr[2*1+1] = <void*>(<char*>"pdtri")
ufunc_pdtri_ptr[2*2] = <void*>_func_pdtri_unsafe
ufunc_pdtri_ptr[2*2+1] = <void*>(<char*>"pdtri")
ufunc_pdtri_ptr[2*3] = <void*>_func_pdtri_unsafe
ufunc_pdtri_ptr[2*3+1] = <void*>(<char*>"pdtri")
ufunc_pdtri_data[0] = &ufunc_pdtri_ptr[2*0]
ufunc_pdtri_data[1] = &ufunc_pdtri_ptr[2*1]
ufunc_pdtri_data[2] = &ufunc_pdtri_ptr[2*2]
ufunc_pdtri_data[3] = &ufunc_pdtri_ptr[2*3]
pdtri = np.PyUFunc_FromFuncAndData(ufunc_pdtri_loops, ufunc_pdtri_data, ufunc_pdtri_types, 4, 2, 1, 0, "pdtri", ufunc_pdtri_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pdtrik_loops[2]
cdef void *ufunc_pdtrik_ptr[4]
cdef void *ufunc_pdtrik_data[2]
cdef char ufunc_pdtrik_types[6]
cdef char *ufunc_pdtrik_doc = (
    "k=pdtrik(p,m) returns the quantile k such that pdtr(k,m)=p")
ufunc_pdtrik_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_pdtrik_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_pdtrik_types[0] = <char>NPY_FLOAT
ufunc_pdtrik_types[1] = <char>NPY_FLOAT
ufunc_pdtrik_types[2] = <char>NPY_FLOAT
ufunc_pdtrik_types[3] = <char>NPY_DOUBLE
ufunc_pdtrik_types[4] = <char>NPY_DOUBLE
ufunc_pdtrik_types[5] = <char>NPY_DOUBLE
ufunc_pdtrik_ptr[2*0] = <void*>_func_cdfpoi2_wrap
ufunc_pdtrik_ptr[2*0+1] = <void*>(<char*>"pdtrik")
ufunc_pdtrik_ptr[2*1] = <void*>_func_cdfpoi2_wrap
ufunc_pdtrik_ptr[2*1+1] = <void*>(<char*>"pdtrik")
ufunc_pdtrik_data[0] = &ufunc_pdtrik_ptr[2*0]
ufunc_pdtrik_data[1] = &ufunc_pdtrik_ptr[2*1]
pdtrik = np.PyUFunc_FromFuncAndData(ufunc_pdtrik_loops, ufunc_pdtrik_data, ufunc_pdtrik_types, 2, 2, 1, 0, "pdtrik", ufunc_pdtrik_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pro_ang1_loops[2]
cdef void *ufunc_pro_ang1_ptr[4]
cdef void *ufunc_pro_ang1_data[2]
cdef char ufunc_pro_ang1_types[12]
cdef char *ufunc_pro_ang1_doc = (
    "(s,sp)=pro_ang1(m,n,c,x) computes the prolate sheroidal angular function\n"
    "of the first kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and ``|x| < 1.0``.")
ufunc_pro_ang1_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_ffff_ff
ufunc_pro_ang1_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_dddd_dd
ufunc_pro_ang1_types[0] = <char>NPY_FLOAT
ufunc_pro_ang1_types[1] = <char>NPY_FLOAT
ufunc_pro_ang1_types[2] = <char>NPY_FLOAT
ufunc_pro_ang1_types[3] = <char>NPY_FLOAT
ufunc_pro_ang1_types[4] = <char>NPY_FLOAT
ufunc_pro_ang1_types[5] = <char>NPY_FLOAT
ufunc_pro_ang1_types[6] = <char>NPY_DOUBLE
ufunc_pro_ang1_types[7] = <char>NPY_DOUBLE
ufunc_pro_ang1_types[8] = <char>NPY_DOUBLE
ufunc_pro_ang1_types[9] = <char>NPY_DOUBLE
ufunc_pro_ang1_types[10] = <char>NPY_DOUBLE
ufunc_pro_ang1_types[11] = <char>NPY_DOUBLE
ufunc_pro_ang1_ptr[2*0] = <void*>_func_prolate_aswfa_nocv_wrap
ufunc_pro_ang1_ptr[2*0+1] = <void*>(<char*>"pro_ang1")
ufunc_pro_ang1_ptr[2*1] = <void*>_func_prolate_aswfa_nocv_wrap
ufunc_pro_ang1_ptr[2*1+1] = <void*>(<char*>"pro_ang1")
ufunc_pro_ang1_data[0] = &ufunc_pro_ang1_ptr[2*0]
ufunc_pro_ang1_data[1] = &ufunc_pro_ang1_ptr[2*1]
pro_ang1 = np.PyUFunc_FromFuncAndData(ufunc_pro_ang1_loops, ufunc_pro_ang1_data, ufunc_pro_ang1_types, 2, 4, 2, 0, "pro_ang1", ufunc_pro_ang1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pro_ang1_cv_loops[2]
cdef void *ufunc_pro_ang1_cv_ptr[4]
cdef void *ufunc_pro_ang1_cv_data[2]
cdef char ufunc_pro_ang1_cv_types[14]
cdef char *ufunc_pro_ang1_cv_doc = (
    "(s,sp)=pro_ang1_cv(m,n,c,cv,x) computes the prolate sheroidal angular function\n"
    "of the first kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and ``|x| < 1.0``. Requires pre-computed\n"
    "characteristic value.")
ufunc_pro_ang1_cv_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_fffff_ff
ufunc_pro_ang1_cv_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_ddddd_dd
ufunc_pro_ang1_cv_types[0] = <char>NPY_FLOAT
ufunc_pro_ang1_cv_types[1] = <char>NPY_FLOAT
ufunc_pro_ang1_cv_types[2] = <char>NPY_FLOAT
ufunc_pro_ang1_cv_types[3] = <char>NPY_FLOAT
ufunc_pro_ang1_cv_types[4] = <char>NPY_FLOAT
ufunc_pro_ang1_cv_types[5] = <char>NPY_FLOAT
ufunc_pro_ang1_cv_types[6] = <char>NPY_FLOAT
ufunc_pro_ang1_cv_types[7] = <char>NPY_DOUBLE
ufunc_pro_ang1_cv_types[8] = <char>NPY_DOUBLE
ufunc_pro_ang1_cv_types[9] = <char>NPY_DOUBLE
ufunc_pro_ang1_cv_types[10] = <char>NPY_DOUBLE
ufunc_pro_ang1_cv_types[11] = <char>NPY_DOUBLE
ufunc_pro_ang1_cv_types[12] = <char>NPY_DOUBLE
ufunc_pro_ang1_cv_types[13] = <char>NPY_DOUBLE
ufunc_pro_ang1_cv_ptr[2*0] = <void*>_func_prolate_aswfa_wrap
ufunc_pro_ang1_cv_ptr[2*0+1] = <void*>(<char*>"pro_ang1_cv")
ufunc_pro_ang1_cv_ptr[2*1] = <void*>_func_prolate_aswfa_wrap
ufunc_pro_ang1_cv_ptr[2*1+1] = <void*>(<char*>"pro_ang1_cv")
ufunc_pro_ang1_cv_data[0] = &ufunc_pro_ang1_cv_ptr[2*0]
ufunc_pro_ang1_cv_data[1] = &ufunc_pro_ang1_cv_ptr[2*1]
pro_ang1_cv = np.PyUFunc_FromFuncAndData(ufunc_pro_ang1_cv_loops, ufunc_pro_ang1_cv_data, ufunc_pro_ang1_cv_types, 2, 5, 2, 0, "pro_ang1_cv", ufunc_pro_ang1_cv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pro_cv_loops[2]
cdef void *ufunc_pro_cv_ptr[4]
cdef void *ufunc_pro_cv_data[2]
cdef char ufunc_pro_cv_types[8]
cdef char *ufunc_pro_cv_doc = (
    "cv=pro_cv(m,n,c) computes the characteristic value of prolate spheroidal\n"
    "wave functions of order m,n (n>=m) and spheroidal parameter c.")
ufunc_pro_cv_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_pro_cv_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_pro_cv_types[0] = <char>NPY_FLOAT
ufunc_pro_cv_types[1] = <char>NPY_FLOAT
ufunc_pro_cv_types[2] = <char>NPY_FLOAT
ufunc_pro_cv_types[3] = <char>NPY_FLOAT
ufunc_pro_cv_types[4] = <char>NPY_DOUBLE
ufunc_pro_cv_types[5] = <char>NPY_DOUBLE
ufunc_pro_cv_types[6] = <char>NPY_DOUBLE
ufunc_pro_cv_types[7] = <char>NPY_DOUBLE
ufunc_pro_cv_ptr[2*0] = <void*>_func_prolate_segv_wrap
ufunc_pro_cv_ptr[2*0+1] = <void*>(<char*>"pro_cv")
ufunc_pro_cv_ptr[2*1] = <void*>_func_prolate_segv_wrap
ufunc_pro_cv_ptr[2*1+1] = <void*>(<char*>"pro_cv")
ufunc_pro_cv_data[0] = &ufunc_pro_cv_ptr[2*0]
ufunc_pro_cv_data[1] = &ufunc_pro_cv_ptr[2*1]
pro_cv = np.PyUFunc_FromFuncAndData(ufunc_pro_cv_loops, ufunc_pro_cv_data, ufunc_pro_cv_types, 2, 3, 1, 0, "pro_cv", ufunc_pro_cv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pro_rad1_loops[2]
cdef void *ufunc_pro_rad1_ptr[4]
cdef void *ufunc_pro_rad1_data[2]
cdef char ufunc_pro_rad1_types[12]
cdef char *ufunc_pro_rad1_doc = (
    "(s,sp)=pro_rad1(m,n,c,x) computes the prolate sheroidal radial function\n"
    "of the first kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and ``|x| < 1.0``.")
ufunc_pro_rad1_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_ffff_ff
ufunc_pro_rad1_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_dddd_dd
ufunc_pro_rad1_types[0] = <char>NPY_FLOAT
ufunc_pro_rad1_types[1] = <char>NPY_FLOAT
ufunc_pro_rad1_types[2] = <char>NPY_FLOAT
ufunc_pro_rad1_types[3] = <char>NPY_FLOAT
ufunc_pro_rad1_types[4] = <char>NPY_FLOAT
ufunc_pro_rad1_types[5] = <char>NPY_FLOAT
ufunc_pro_rad1_types[6] = <char>NPY_DOUBLE
ufunc_pro_rad1_types[7] = <char>NPY_DOUBLE
ufunc_pro_rad1_types[8] = <char>NPY_DOUBLE
ufunc_pro_rad1_types[9] = <char>NPY_DOUBLE
ufunc_pro_rad1_types[10] = <char>NPY_DOUBLE
ufunc_pro_rad1_types[11] = <char>NPY_DOUBLE
ufunc_pro_rad1_ptr[2*0] = <void*>_func_prolate_radial1_nocv_wrap
ufunc_pro_rad1_ptr[2*0+1] = <void*>(<char*>"pro_rad1")
ufunc_pro_rad1_ptr[2*1] = <void*>_func_prolate_radial1_nocv_wrap
ufunc_pro_rad1_ptr[2*1+1] = <void*>(<char*>"pro_rad1")
ufunc_pro_rad1_data[0] = &ufunc_pro_rad1_ptr[2*0]
ufunc_pro_rad1_data[1] = &ufunc_pro_rad1_ptr[2*1]
pro_rad1 = np.PyUFunc_FromFuncAndData(ufunc_pro_rad1_loops, ufunc_pro_rad1_data, ufunc_pro_rad1_types, 2, 4, 2, 0, "pro_rad1", ufunc_pro_rad1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pro_rad1_cv_loops[2]
cdef void *ufunc_pro_rad1_cv_ptr[4]
cdef void *ufunc_pro_rad1_cv_data[2]
cdef char ufunc_pro_rad1_cv_types[14]
cdef char *ufunc_pro_rad1_cv_doc = (
    "(s,sp)=pro_rad1_cv(m,n,c,cv,x) computes the prolate sheroidal radial function\n"
    "of the first kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and ``|x| < 1.0``. Requires pre-computed\n"
    "characteristic value.")
ufunc_pro_rad1_cv_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_fffff_ff
ufunc_pro_rad1_cv_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_ddddd_dd
ufunc_pro_rad1_cv_types[0] = <char>NPY_FLOAT
ufunc_pro_rad1_cv_types[1] = <char>NPY_FLOAT
ufunc_pro_rad1_cv_types[2] = <char>NPY_FLOAT
ufunc_pro_rad1_cv_types[3] = <char>NPY_FLOAT
ufunc_pro_rad1_cv_types[4] = <char>NPY_FLOAT
ufunc_pro_rad1_cv_types[5] = <char>NPY_FLOAT
ufunc_pro_rad1_cv_types[6] = <char>NPY_FLOAT
ufunc_pro_rad1_cv_types[7] = <char>NPY_DOUBLE
ufunc_pro_rad1_cv_types[8] = <char>NPY_DOUBLE
ufunc_pro_rad1_cv_types[9] = <char>NPY_DOUBLE
ufunc_pro_rad1_cv_types[10] = <char>NPY_DOUBLE
ufunc_pro_rad1_cv_types[11] = <char>NPY_DOUBLE
ufunc_pro_rad1_cv_types[12] = <char>NPY_DOUBLE
ufunc_pro_rad1_cv_types[13] = <char>NPY_DOUBLE
ufunc_pro_rad1_cv_ptr[2*0] = <void*>_func_prolate_radial1_wrap
ufunc_pro_rad1_cv_ptr[2*0+1] = <void*>(<char*>"pro_rad1_cv")
ufunc_pro_rad1_cv_ptr[2*1] = <void*>_func_prolate_radial1_wrap
ufunc_pro_rad1_cv_ptr[2*1+1] = <void*>(<char*>"pro_rad1_cv")
ufunc_pro_rad1_cv_data[0] = &ufunc_pro_rad1_cv_ptr[2*0]
ufunc_pro_rad1_cv_data[1] = &ufunc_pro_rad1_cv_ptr[2*1]
pro_rad1_cv = np.PyUFunc_FromFuncAndData(ufunc_pro_rad1_cv_loops, ufunc_pro_rad1_cv_data, ufunc_pro_rad1_cv_types, 2, 5, 2, 0, "pro_rad1_cv", ufunc_pro_rad1_cv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pro_rad2_loops[2]
cdef void *ufunc_pro_rad2_ptr[4]
cdef void *ufunc_pro_rad2_data[2]
cdef char ufunc_pro_rad2_types[12]
cdef char *ufunc_pro_rad2_doc = (
    "(s,sp)=pro_rad2(m,n,c,x) computes the prolate sheroidal radial function\n"
    "of the second kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and |x|<1.0.")
ufunc_pro_rad2_loops[0] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_ffff_ff
ufunc_pro_rad2_loops[1] = <np.PyUFuncGenericFunction>loop_d_dddd_d_As_dddd_dd
ufunc_pro_rad2_types[0] = <char>NPY_FLOAT
ufunc_pro_rad2_types[1] = <char>NPY_FLOAT
ufunc_pro_rad2_types[2] = <char>NPY_FLOAT
ufunc_pro_rad2_types[3] = <char>NPY_FLOAT
ufunc_pro_rad2_types[4] = <char>NPY_FLOAT
ufunc_pro_rad2_types[5] = <char>NPY_FLOAT
ufunc_pro_rad2_types[6] = <char>NPY_DOUBLE
ufunc_pro_rad2_types[7] = <char>NPY_DOUBLE
ufunc_pro_rad2_types[8] = <char>NPY_DOUBLE
ufunc_pro_rad2_types[9] = <char>NPY_DOUBLE
ufunc_pro_rad2_types[10] = <char>NPY_DOUBLE
ufunc_pro_rad2_types[11] = <char>NPY_DOUBLE
ufunc_pro_rad2_ptr[2*0] = <void*>_func_prolate_radial2_nocv_wrap
ufunc_pro_rad2_ptr[2*0+1] = <void*>(<char*>"pro_rad2")
ufunc_pro_rad2_ptr[2*1] = <void*>_func_prolate_radial2_nocv_wrap
ufunc_pro_rad2_ptr[2*1+1] = <void*>(<char*>"pro_rad2")
ufunc_pro_rad2_data[0] = &ufunc_pro_rad2_ptr[2*0]
ufunc_pro_rad2_data[1] = &ufunc_pro_rad2_ptr[2*1]
pro_rad2 = np.PyUFunc_FromFuncAndData(ufunc_pro_rad2_loops, ufunc_pro_rad2_data, ufunc_pro_rad2_types, 2, 4, 2, 0, "pro_rad2", ufunc_pro_rad2_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_pro_rad2_cv_loops[2]
cdef void *ufunc_pro_rad2_cv_ptr[4]
cdef void *ufunc_pro_rad2_cv_data[2]
cdef char ufunc_pro_rad2_cv_types[14]
cdef char *ufunc_pro_rad2_cv_doc = (
    "(s,sp)=pro_rad2_cv(m,n,c,cv,x) computes the prolate sheroidal radial function\n"
    "of the second kind and its derivative (with respect to x) for mode parameters\n"
    "m>=0 and n>=m, spheroidal parameter c and ``|x| < 1.0``. Requires pre-computed\n"
    "characteristic value.")
ufunc_pro_rad2_cv_loops[0] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_fffff_ff
ufunc_pro_rad2_cv_loops[1] = <np.PyUFuncGenericFunction>loop_i_ddddd_dd_As_ddddd_dd
ufunc_pro_rad2_cv_types[0] = <char>NPY_FLOAT
ufunc_pro_rad2_cv_types[1] = <char>NPY_FLOAT
ufunc_pro_rad2_cv_types[2] = <char>NPY_FLOAT
ufunc_pro_rad2_cv_types[3] = <char>NPY_FLOAT
ufunc_pro_rad2_cv_types[4] = <char>NPY_FLOAT
ufunc_pro_rad2_cv_types[5] = <char>NPY_FLOAT
ufunc_pro_rad2_cv_types[6] = <char>NPY_FLOAT
ufunc_pro_rad2_cv_types[7] = <char>NPY_DOUBLE
ufunc_pro_rad2_cv_types[8] = <char>NPY_DOUBLE
ufunc_pro_rad2_cv_types[9] = <char>NPY_DOUBLE
ufunc_pro_rad2_cv_types[10] = <char>NPY_DOUBLE
ufunc_pro_rad2_cv_types[11] = <char>NPY_DOUBLE
ufunc_pro_rad2_cv_types[12] = <char>NPY_DOUBLE
ufunc_pro_rad2_cv_types[13] = <char>NPY_DOUBLE
ufunc_pro_rad2_cv_ptr[2*0] = <void*>_func_prolate_radial2_wrap
ufunc_pro_rad2_cv_ptr[2*0+1] = <void*>(<char*>"pro_rad2_cv")
ufunc_pro_rad2_cv_ptr[2*1] = <void*>_func_prolate_radial2_wrap
ufunc_pro_rad2_cv_ptr[2*1+1] = <void*>(<char*>"pro_rad2_cv")
ufunc_pro_rad2_cv_data[0] = &ufunc_pro_rad2_cv_ptr[2*0]
ufunc_pro_rad2_cv_data[1] = &ufunc_pro_rad2_cv_ptr[2*1]
pro_rad2_cv = np.PyUFunc_FromFuncAndData(ufunc_pro_rad2_cv_loops, ufunc_pro_rad2_cv_data, ufunc_pro_rad2_cv_types, 2, 5, 2, 0, "pro_rad2_cv", ufunc_pro_rad2_cv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_psi_loops[4]
cdef void *ufunc_psi_ptr[8]
cdef void *ufunc_psi_data[4]
cdef char ufunc_psi_types[8]
cdef char *ufunc_psi_doc = (
    "y=psi(z) is the derivative of the logarithm of the gamma function\n"
    "evaluated at z (also called the digamma function).")
ufunc_psi_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_psi_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_psi_loops[2] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_psi_loops[3] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_psi_types[0] = <char>NPY_FLOAT
ufunc_psi_types[1] = <char>NPY_FLOAT
ufunc_psi_types[2] = <char>NPY_DOUBLE
ufunc_psi_types[3] = <char>NPY_DOUBLE
ufunc_psi_types[4] = <char>NPY_CFLOAT
ufunc_psi_types[5] = <char>NPY_CFLOAT
ufunc_psi_types[6] = <char>NPY_CDOUBLE
ufunc_psi_types[7] = <char>NPY_CDOUBLE
ufunc_psi_ptr[2*0] = <void*>_func_psi
ufunc_psi_ptr[2*0+1] = <void*>(<char*>"psi")
ufunc_psi_ptr[2*1] = <void*>_func_psi
ufunc_psi_ptr[2*1+1] = <void*>(<char*>"psi")
ufunc_psi_ptr[2*2] = <void*>_func_cpsi_wrap
ufunc_psi_ptr[2*2+1] = <void*>(<char*>"psi")
ufunc_psi_ptr[2*3] = <void*>_func_cpsi_wrap
ufunc_psi_ptr[2*3+1] = <void*>(<char*>"psi")
ufunc_psi_data[0] = &ufunc_psi_ptr[2*0]
ufunc_psi_data[1] = &ufunc_psi_ptr[2*1]
ufunc_psi_data[2] = &ufunc_psi_ptr[2*2]
ufunc_psi_data[3] = &ufunc_psi_ptr[2*3]
psi = np.PyUFunc_FromFuncAndData(ufunc_psi_loops, ufunc_psi_data, ufunc_psi_types, 4, 1, 1, 0, "psi", ufunc_psi_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_radian_loops[2]
cdef void *ufunc_radian_ptr[4]
cdef void *ufunc_radian_data[2]
cdef char ufunc_radian_types[8]
cdef char *ufunc_radian_doc = (
    "y=radian(d,m,s) returns the angle given in (d)egrees, (m)inutes, and\n"
    "(s)econds in radians.")
ufunc_radian_loops[0] = <np.PyUFuncGenericFunction>loop_d_ddd__As_fff_f
ufunc_radian_loops[1] = <np.PyUFuncGenericFunction>loop_d_ddd__As_ddd_d
ufunc_radian_types[0] = <char>NPY_FLOAT
ufunc_radian_types[1] = <char>NPY_FLOAT
ufunc_radian_types[2] = <char>NPY_FLOAT
ufunc_radian_types[3] = <char>NPY_FLOAT
ufunc_radian_types[4] = <char>NPY_DOUBLE
ufunc_radian_types[5] = <char>NPY_DOUBLE
ufunc_radian_types[6] = <char>NPY_DOUBLE
ufunc_radian_types[7] = <char>NPY_DOUBLE
ufunc_radian_ptr[2*0] = <void*>_func_radian
ufunc_radian_ptr[2*0+1] = <void*>(<char*>"radian")
ufunc_radian_ptr[2*1] = <void*>_func_radian
ufunc_radian_ptr[2*1+1] = <void*>(<char*>"radian")
ufunc_radian_data[0] = &ufunc_radian_ptr[2*0]
ufunc_radian_data[1] = &ufunc_radian_ptr[2*1]
radian = np.PyUFunc_FromFuncAndData(ufunc_radian_loops, ufunc_radian_data, ufunc_radian_types, 2, 3, 1, 0, "radian", ufunc_radian_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_rgamma_loops[4]
cdef void *ufunc_rgamma_ptr[8]
cdef void *ufunc_rgamma_data[4]
cdef char ufunc_rgamma_types[8]
cdef char *ufunc_rgamma_doc = (
    "y=rgamma(z) returns one divided by the gamma function of x.")
ufunc_rgamma_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_rgamma_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_rgamma_loops[2] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_rgamma_loops[3] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_rgamma_types[0] = <char>NPY_FLOAT
ufunc_rgamma_types[1] = <char>NPY_FLOAT
ufunc_rgamma_types[2] = <char>NPY_DOUBLE
ufunc_rgamma_types[3] = <char>NPY_DOUBLE
ufunc_rgamma_types[4] = <char>NPY_CFLOAT
ufunc_rgamma_types[5] = <char>NPY_CFLOAT
ufunc_rgamma_types[6] = <char>NPY_CDOUBLE
ufunc_rgamma_types[7] = <char>NPY_CDOUBLE
ufunc_rgamma_ptr[2*0] = <void*>_func_rgamma
ufunc_rgamma_ptr[2*0+1] = <void*>(<char*>"rgamma")
ufunc_rgamma_ptr[2*1] = <void*>_func_rgamma
ufunc_rgamma_ptr[2*1+1] = <void*>(<char*>"rgamma")
ufunc_rgamma_ptr[2*2] = <void*>_func_crgamma_wrap
ufunc_rgamma_ptr[2*2+1] = <void*>(<char*>"rgamma")
ufunc_rgamma_ptr[2*3] = <void*>_func_crgamma_wrap
ufunc_rgamma_ptr[2*3+1] = <void*>(<char*>"rgamma")
ufunc_rgamma_data[0] = &ufunc_rgamma_ptr[2*0]
ufunc_rgamma_data[1] = &ufunc_rgamma_ptr[2*1]
ufunc_rgamma_data[2] = &ufunc_rgamma_ptr[2*2]
ufunc_rgamma_data[3] = &ufunc_rgamma_ptr[2*3]
rgamma = np.PyUFunc_FromFuncAndData(ufunc_rgamma_loops, ufunc_rgamma_data, ufunc_rgamma_types, 4, 1, 1, 0, "rgamma", ufunc_rgamma_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_round_loops[2]
cdef void *ufunc_round_ptr[4]
cdef void *ufunc_round_data[2]
cdef char ufunc_round_types[4]
cdef char *ufunc_round_doc = (
    "y=Returns the nearest integer to x as a double precision\n"
    "floating point result.  If x ends in 0.5 exactly, the\n"
    "nearest even integer is chosen.")
ufunc_round_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_round_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_round_types[0] = <char>NPY_FLOAT
ufunc_round_types[1] = <char>NPY_FLOAT
ufunc_round_types[2] = <char>NPY_DOUBLE
ufunc_round_types[3] = <char>NPY_DOUBLE
ufunc_round_ptr[2*0] = <void*>_func_round
ufunc_round_ptr[2*0+1] = <void*>(<char*>"round")
ufunc_round_ptr[2*1] = <void*>_func_round
ufunc_round_ptr[2*1+1] = <void*>(<char*>"round")
ufunc_round_data[0] = &ufunc_round_ptr[2*0]
ufunc_round_data[1] = &ufunc_round_ptr[2*1]
round = np.PyUFunc_FromFuncAndData(ufunc_round_loops, ufunc_round_data, ufunc_round_types, 2, 1, 1, 0, "round", ufunc_round_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_shichi_loops[2]
cdef void *ufunc_shichi_ptr[4]
cdef void *ufunc_shichi_data[2]
cdef char ufunc_shichi_types[6]
cdef char *ufunc_shichi_doc = (
    "(shi,chi)=shichi(x) returns the hyperbolic sine and cosine integrals:\n"
    "integral(sinh(t)/t,t=0..x) and eul + ln x +\n"
    "integral((cosh(t)-1)/t,t=0..x) where eul is Euler's Constant.")
ufunc_shichi_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_f_ff
ufunc_shichi_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_d_dd
ufunc_shichi_types[0] = <char>NPY_FLOAT
ufunc_shichi_types[1] = <char>NPY_FLOAT
ufunc_shichi_types[2] = <char>NPY_FLOAT
ufunc_shichi_types[3] = <char>NPY_DOUBLE
ufunc_shichi_types[4] = <char>NPY_DOUBLE
ufunc_shichi_types[5] = <char>NPY_DOUBLE
ufunc_shichi_ptr[2*0] = <void*>_func_shichi
ufunc_shichi_ptr[2*0+1] = <void*>(<char*>"shichi")
ufunc_shichi_ptr[2*1] = <void*>_func_shichi
ufunc_shichi_ptr[2*1+1] = <void*>(<char*>"shichi")
ufunc_shichi_data[0] = &ufunc_shichi_ptr[2*0]
ufunc_shichi_data[1] = &ufunc_shichi_ptr[2*1]
shichi = np.PyUFunc_FromFuncAndData(ufunc_shichi_loops, ufunc_shichi_data, ufunc_shichi_types, 2, 1, 2, 0, "shichi", ufunc_shichi_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_sici_loops[2]
cdef void *ufunc_sici_ptr[4]
cdef void *ufunc_sici_data[2]
cdef char ufunc_sici_types[6]
cdef char *ufunc_sici_doc = (
    "(si,ci)=sici(x) returns in si the integral of the sinc function from 0 to x:\n"
    "integral(sin(t)/t,t=0..x).  It returns in ci the cosine integral: eul + ln x +\n"
    "integral((cos(t) - 1)/t,t=0..x).")
ufunc_sici_loops[0] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_f_ff
ufunc_sici_loops[1] = <np.PyUFuncGenericFunction>loop_i_d_dd_As_d_dd
ufunc_sici_types[0] = <char>NPY_FLOAT
ufunc_sici_types[1] = <char>NPY_FLOAT
ufunc_sici_types[2] = <char>NPY_FLOAT
ufunc_sici_types[3] = <char>NPY_DOUBLE
ufunc_sici_types[4] = <char>NPY_DOUBLE
ufunc_sici_types[5] = <char>NPY_DOUBLE
ufunc_sici_ptr[2*0] = <void*>_func_sici
ufunc_sici_ptr[2*0+1] = <void*>(<char*>"sici")
ufunc_sici_ptr[2*1] = <void*>_func_sici
ufunc_sici_ptr[2*1+1] = <void*>(<char*>"sici")
ufunc_sici_data[0] = &ufunc_sici_ptr[2*0]
ufunc_sici_data[1] = &ufunc_sici_ptr[2*1]
sici = np.PyUFunc_FromFuncAndData(ufunc_sici_loops, ufunc_sici_data, ufunc_sici_types, 2, 1, 2, 0, "sici", ufunc_sici_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_sindg_loops[2]
cdef void *ufunc_sindg_ptr[4]
cdef void *ufunc_sindg_data[2]
cdef char ufunc_sindg_types[4]
cdef char *ufunc_sindg_doc = (
    "y=sindg(x) calculates the sine of the angle x given in degrees.")
ufunc_sindg_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_sindg_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_sindg_types[0] = <char>NPY_FLOAT
ufunc_sindg_types[1] = <char>NPY_FLOAT
ufunc_sindg_types[2] = <char>NPY_DOUBLE
ufunc_sindg_types[3] = <char>NPY_DOUBLE
ufunc_sindg_ptr[2*0] = <void*>_func_sindg
ufunc_sindg_ptr[2*0+1] = <void*>(<char*>"sindg")
ufunc_sindg_ptr[2*1] = <void*>_func_sindg
ufunc_sindg_ptr[2*1+1] = <void*>(<char*>"sindg")
ufunc_sindg_data[0] = &ufunc_sindg_ptr[2*0]
ufunc_sindg_data[1] = &ufunc_sindg_ptr[2*1]
sindg = np.PyUFunc_FromFuncAndData(ufunc_sindg_loops, ufunc_sindg_data, ufunc_sindg_types, 2, 1, 1, 0, "sindg", ufunc_sindg_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_smirnov_loops[4]
cdef void *ufunc_smirnov_ptr[8]
cdef void *ufunc_smirnov_data[4]
cdef char ufunc_smirnov_types[12]
cdef char *ufunc_smirnov_doc = (
    "y=smirnov(n,e) returns the exact Kolmogorov-Smirnov complementary\n"
    "cumulative distribution function (Dn+ or Dn-) for a one-sided test of\n"
    "equality between an empirical and a theoretical distribution. It is equal\n"
    "to the probability that the maximum difference between a theoretical\n"
    "distribution and an empirical one based on n samples is greater than e.")
ufunc_smirnov_loops[0] = <np.PyUFuncGenericFunction>loop_d_id__As_lf_f
ufunc_smirnov_loops[1] = <np.PyUFuncGenericFunction>loop_d_id__As_ld_d
ufunc_smirnov_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_smirnov_loops[3] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_smirnov_types[0] = <char>NPY_LONG
ufunc_smirnov_types[1] = <char>NPY_FLOAT
ufunc_smirnov_types[2] = <char>NPY_FLOAT
ufunc_smirnov_types[3] = <char>NPY_LONG
ufunc_smirnov_types[4] = <char>NPY_DOUBLE
ufunc_smirnov_types[5] = <char>NPY_DOUBLE
ufunc_smirnov_types[6] = <char>NPY_FLOAT
ufunc_smirnov_types[7] = <char>NPY_FLOAT
ufunc_smirnov_types[8] = <char>NPY_FLOAT
ufunc_smirnov_types[9] = <char>NPY_DOUBLE
ufunc_smirnov_types[10] = <char>NPY_DOUBLE
ufunc_smirnov_types[11] = <char>NPY_DOUBLE
ufunc_smirnov_ptr[2*0] = <void*>_func_smirnov
ufunc_smirnov_ptr[2*0+1] = <void*>(<char*>"smirnov")
ufunc_smirnov_ptr[2*1] = <void*>_func_smirnov
ufunc_smirnov_ptr[2*1+1] = <void*>(<char*>"smirnov")
ufunc_smirnov_ptr[2*2] = <void*>_func_smirnov_unsafe
ufunc_smirnov_ptr[2*2+1] = <void*>(<char*>"smirnov")
ufunc_smirnov_ptr[2*3] = <void*>_func_smirnov_unsafe
ufunc_smirnov_ptr[2*3+1] = <void*>(<char*>"smirnov")
ufunc_smirnov_data[0] = &ufunc_smirnov_ptr[2*0]
ufunc_smirnov_data[1] = &ufunc_smirnov_ptr[2*1]
ufunc_smirnov_data[2] = &ufunc_smirnov_ptr[2*2]
ufunc_smirnov_data[3] = &ufunc_smirnov_ptr[2*3]
smirnov = np.PyUFunc_FromFuncAndData(ufunc_smirnov_loops, ufunc_smirnov_data, ufunc_smirnov_types, 4, 2, 1, 0, "smirnov", ufunc_smirnov_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_smirnovi_loops[4]
cdef void *ufunc_smirnovi_ptr[8]
cdef void *ufunc_smirnovi_data[4]
cdef char ufunc_smirnovi_types[12]
cdef char *ufunc_smirnovi_doc = (
    "e=smirnovi(n,y) returns e such that smirnov(n,e) = y.")
ufunc_smirnovi_loops[0] = <np.PyUFuncGenericFunction>loop_d_id__As_lf_f
ufunc_smirnovi_loops[1] = <np.PyUFuncGenericFunction>loop_d_id__As_ld_d
ufunc_smirnovi_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_smirnovi_loops[3] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_smirnovi_types[0] = <char>NPY_LONG
ufunc_smirnovi_types[1] = <char>NPY_FLOAT
ufunc_smirnovi_types[2] = <char>NPY_FLOAT
ufunc_smirnovi_types[3] = <char>NPY_LONG
ufunc_smirnovi_types[4] = <char>NPY_DOUBLE
ufunc_smirnovi_types[5] = <char>NPY_DOUBLE
ufunc_smirnovi_types[6] = <char>NPY_FLOAT
ufunc_smirnovi_types[7] = <char>NPY_FLOAT
ufunc_smirnovi_types[8] = <char>NPY_FLOAT
ufunc_smirnovi_types[9] = <char>NPY_DOUBLE
ufunc_smirnovi_types[10] = <char>NPY_DOUBLE
ufunc_smirnovi_types[11] = <char>NPY_DOUBLE
ufunc_smirnovi_ptr[2*0] = <void*>_func_smirnovi
ufunc_smirnovi_ptr[2*0+1] = <void*>(<char*>"smirnovi")
ufunc_smirnovi_ptr[2*1] = <void*>_func_smirnovi
ufunc_smirnovi_ptr[2*1+1] = <void*>(<char*>"smirnovi")
ufunc_smirnovi_ptr[2*2] = <void*>_func_smirnovi_unsafe
ufunc_smirnovi_ptr[2*2+1] = <void*>(<char*>"smirnovi")
ufunc_smirnovi_ptr[2*3] = <void*>_func_smirnovi_unsafe
ufunc_smirnovi_ptr[2*3+1] = <void*>(<char*>"smirnovi")
ufunc_smirnovi_data[0] = &ufunc_smirnovi_ptr[2*0]
ufunc_smirnovi_data[1] = &ufunc_smirnovi_ptr[2*1]
ufunc_smirnovi_data[2] = &ufunc_smirnovi_ptr[2*2]
ufunc_smirnovi_data[3] = &ufunc_smirnovi_ptr[2*3]
smirnovi = np.PyUFunc_FromFuncAndData(ufunc_smirnovi_loops, ufunc_smirnovi_data, ufunc_smirnovi_types, 4, 2, 1, 0, "smirnovi", ufunc_smirnovi_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_spence_loops[2]
cdef void *ufunc_spence_ptr[4]
cdef void *ufunc_spence_data[2]
cdef char ufunc_spence_types[4]
cdef char *ufunc_spence_doc = (
    "y=spence(x) returns the dilogarithm integral: -integral(log t /\n"
    "(t-1),t=1..x)")
ufunc_spence_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_spence_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_spence_types[0] = <char>NPY_FLOAT
ufunc_spence_types[1] = <char>NPY_FLOAT
ufunc_spence_types[2] = <char>NPY_DOUBLE
ufunc_spence_types[3] = <char>NPY_DOUBLE
ufunc_spence_ptr[2*0] = <void*>_func_spence
ufunc_spence_ptr[2*0+1] = <void*>(<char*>"spence")
ufunc_spence_ptr[2*1] = <void*>_func_spence
ufunc_spence_ptr[2*1+1] = <void*>(<char*>"spence")
ufunc_spence_data[0] = &ufunc_spence_ptr[2*0]
ufunc_spence_data[1] = &ufunc_spence_ptr[2*1]
spence = np.PyUFunc_FromFuncAndData(ufunc_spence_loops, ufunc_spence_data, ufunc_spence_types, 2, 1, 1, 0, "spence", ufunc_spence_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_stdtr_loops[2]
cdef void *ufunc_stdtr_ptr[4]
cdef void *ufunc_stdtr_data[2]
cdef char ufunc_stdtr_types[6]
cdef char *ufunc_stdtr_doc = (
    "p=stdtr(df,t) returns the integral from minus infinity to t of the Student t\n"
    "distribution with df > 0 degrees of freedom:\n"
    "gamma((df+1)/2)/(sqrt(df*pi)*gamma(df/2)) * integral((1+x**2/df)**(-df/2-1/2),\n"
    "x=-inf..t)")
ufunc_stdtr_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_stdtr_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_stdtr_types[0] = <char>NPY_FLOAT
ufunc_stdtr_types[1] = <char>NPY_FLOAT
ufunc_stdtr_types[2] = <char>NPY_FLOAT
ufunc_stdtr_types[3] = <char>NPY_DOUBLE
ufunc_stdtr_types[4] = <char>NPY_DOUBLE
ufunc_stdtr_types[5] = <char>NPY_DOUBLE
ufunc_stdtr_ptr[2*0] = <void*>_func_cdft1_wrap
ufunc_stdtr_ptr[2*0+1] = <void*>(<char*>"stdtr")
ufunc_stdtr_ptr[2*1] = <void*>_func_cdft1_wrap
ufunc_stdtr_ptr[2*1+1] = <void*>(<char*>"stdtr")
ufunc_stdtr_data[0] = &ufunc_stdtr_ptr[2*0]
ufunc_stdtr_data[1] = &ufunc_stdtr_ptr[2*1]
stdtr = np.PyUFunc_FromFuncAndData(ufunc_stdtr_loops, ufunc_stdtr_data, ufunc_stdtr_types, 2, 2, 1, 0, "stdtr", ufunc_stdtr_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_stdtridf_loops[2]
cdef void *ufunc_stdtridf_ptr[4]
cdef void *ufunc_stdtridf_data[2]
cdef char ufunc_stdtridf_types[6]
cdef char *ufunc_stdtridf_doc = (
    "t=stdtridf(p,t) returns the argument df such that stdtr(df,t) is equal to p.")
ufunc_stdtridf_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_stdtridf_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_stdtridf_types[0] = <char>NPY_FLOAT
ufunc_stdtridf_types[1] = <char>NPY_FLOAT
ufunc_stdtridf_types[2] = <char>NPY_FLOAT
ufunc_stdtridf_types[3] = <char>NPY_DOUBLE
ufunc_stdtridf_types[4] = <char>NPY_DOUBLE
ufunc_stdtridf_types[5] = <char>NPY_DOUBLE
ufunc_stdtridf_ptr[2*0] = <void*>_func_cdft3_wrap
ufunc_stdtridf_ptr[2*0+1] = <void*>(<char*>"stdtridf")
ufunc_stdtridf_ptr[2*1] = <void*>_func_cdft3_wrap
ufunc_stdtridf_ptr[2*1+1] = <void*>(<char*>"stdtridf")
ufunc_stdtridf_data[0] = &ufunc_stdtridf_ptr[2*0]
ufunc_stdtridf_data[1] = &ufunc_stdtridf_ptr[2*1]
stdtridf = np.PyUFunc_FromFuncAndData(ufunc_stdtridf_loops, ufunc_stdtridf_data, ufunc_stdtridf_types, 2, 2, 1, 0, "stdtridf", ufunc_stdtridf_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_stdtrit_loops[2]
cdef void *ufunc_stdtrit_ptr[4]
cdef void *ufunc_stdtrit_data[2]
cdef char ufunc_stdtrit_types[6]
cdef char *ufunc_stdtrit_doc = (
    "t=stdtrit(df,p) returns the argument t such that stdtr(df,t) is equal to p.")
ufunc_stdtrit_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_stdtrit_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_stdtrit_types[0] = <char>NPY_FLOAT
ufunc_stdtrit_types[1] = <char>NPY_FLOAT
ufunc_stdtrit_types[2] = <char>NPY_FLOAT
ufunc_stdtrit_types[3] = <char>NPY_DOUBLE
ufunc_stdtrit_types[4] = <char>NPY_DOUBLE
ufunc_stdtrit_types[5] = <char>NPY_DOUBLE
ufunc_stdtrit_ptr[2*0] = <void*>_func_cdft2_wrap
ufunc_stdtrit_ptr[2*0+1] = <void*>(<char*>"stdtrit")
ufunc_stdtrit_ptr[2*1] = <void*>_func_cdft2_wrap
ufunc_stdtrit_ptr[2*1+1] = <void*>(<char*>"stdtrit")
ufunc_stdtrit_data[0] = &ufunc_stdtrit_ptr[2*0]
ufunc_stdtrit_data[1] = &ufunc_stdtrit_ptr[2*1]
stdtrit = np.PyUFunc_FromFuncAndData(ufunc_stdtrit_loops, ufunc_stdtrit_data, ufunc_stdtrit_types, 2, 2, 1, 0, "stdtrit", ufunc_stdtrit_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_struve_loops[2]
cdef void *ufunc_struve_ptr[4]
cdef void *ufunc_struve_data[2]
cdef char ufunc_struve_types[6]
cdef char *ufunc_struve_doc = (
    "y=struve(v,x) returns the Struve function Hv(x) of order v at x, x\n"
    "must be positive unless v is an integer.")
ufunc_struve_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_struve_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_struve_types[0] = <char>NPY_FLOAT
ufunc_struve_types[1] = <char>NPY_FLOAT
ufunc_struve_types[2] = <char>NPY_FLOAT
ufunc_struve_types[3] = <char>NPY_DOUBLE
ufunc_struve_types[4] = <char>NPY_DOUBLE
ufunc_struve_types[5] = <char>NPY_DOUBLE
ufunc_struve_ptr[2*0] = <void*>_func_struve_h
ufunc_struve_ptr[2*0+1] = <void*>(<char*>"struve")
ufunc_struve_ptr[2*1] = <void*>_func_struve_h
ufunc_struve_ptr[2*1+1] = <void*>(<char*>"struve")
ufunc_struve_data[0] = &ufunc_struve_ptr[2*0]
ufunc_struve_data[1] = &ufunc_struve_ptr[2*1]
struve = np.PyUFunc_FromFuncAndData(ufunc_struve_loops, ufunc_struve_data, ufunc_struve_types, 2, 2, 1, 0, "struve", ufunc_struve_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_tandg_loops[2]
cdef void *ufunc_tandg_ptr[4]
cdef void *ufunc_tandg_data[2]
cdef char ufunc_tandg_types[4]
cdef char *ufunc_tandg_doc = (
    "y=tandg(x) calculates the tangent of the angle x given in degrees.")
ufunc_tandg_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_tandg_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_tandg_types[0] = <char>NPY_FLOAT
ufunc_tandg_types[1] = <char>NPY_FLOAT
ufunc_tandg_types[2] = <char>NPY_DOUBLE
ufunc_tandg_types[3] = <char>NPY_DOUBLE
ufunc_tandg_ptr[2*0] = <void*>_func_tandg
ufunc_tandg_ptr[2*0+1] = <void*>(<char*>"tandg")
ufunc_tandg_ptr[2*1] = <void*>_func_tandg
ufunc_tandg_ptr[2*1+1] = <void*>(<char*>"tandg")
ufunc_tandg_data[0] = &ufunc_tandg_ptr[2*0]
ufunc_tandg_data[1] = &ufunc_tandg_ptr[2*1]
tandg = np.PyUFunc_FromFuncAndData(ufunc_tandg_loops, ufunc_tandg_data, ufunc_tandg_types, 2, 1, 1, 0, "tandg", ufunc_tandg_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_tklmbda_loops[2]
cdef void *ufunc_tklmbda_ptr[4]
cdef void *ufunc_tklmbda_data[2]
cdef char ufunc_tklmbda_types[6]
cdef char *ufunc_tklmbda_doc = (
    "")
ufunc_tklmbda_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_tklmbda_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_tklmbda_types[0] = <char>NPY_FLOAT
ufunc_tklmbda_types[1] = <char>NPY_FLOAT
ufunc_tklmbda_types[2] = <char>NPY_FLOAT
ufunc_tklmbda_types[3] = <char>NPY_DOUBLE
ufunc_tklmbda_types[4] = <char>NPY_DOUBLE
ufunc_tklmbda_types[5] = <char>NPY_DOUBLE
ufunc_tklmbda_ptr[2*0] = <void*>_func_tukeylambdacdf
ufunc_tklmbda_ptr[2*0+1] = <void*>(<char*>"tklmbda")
ufunc_tklmbda_ptr[2*1] = <void*>_func_tukeylambdacdf
ufunc_tklmbda_ptr[2*1+1] = <void*>(<char*>"tklmbda")
ufunc_tklmbda_data[0] = &ufunc_tklmbda_ptr[2*0]
ufunc_tklmbda_data[1] = &ufunc_tklmbda_ptr[2*1]
tklmbda = np.PyUFunc_FromFuncAndData(ufunc_tklmbda_loops, ufunc_tklmbda_data, ufunc_tklmbda_types, 2, 2, 1, 0, "tklmbda", ufunc_tklmbda_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_wofz_loops[2]
cdef void *ufunc_wofz_ptr[4]
cdef void *ufunc_wofz_data[2]
cdef char ufunc_wofz_types[4]
cdef char *ufunc_wofz_doc = (
    "y=wofz(z) returns the value of the fadeeva function for complex argument\n"
    "z: exp(-z**2)*erfc(-i*z)\n"
    "\n"
    "References\n"
    "----------\n"
    ".. [1] Steven G. Johnson, Faddeeva W function implementation.\n"
    "   http://ab-initio.mit.edu/Faddeeva")
ufunc_wofz_loops[0] = <np.PyUFuncGenericFunction>loop_D_D__As_F_F
ufunc_wofz_loops[1] = <np.PyUFuncGenericFunction>loop_D_D__As_D_D
ufunc_wofz_types[0] = <char>NPY_CFLOAT
ufunc_wofz_types[1] = <char>NPY_CFLOAT
ufunc_wofz_types[2] = <char>NPY_CDOUBLE
ufunc_wofz_types[3] = <char>NPY_CDOUBLE
ufunc_wofz_ptr[2*0] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_w
ufunc_wofz_ptr[2*0+1] = <void*>(<char*>"wofz")
ufunc_wofz_ptr[2*1] = <void*>scipy.special._ufuncs_cxx._export_faddeeva_w
ufunc_wofz_ptr[2*1+1] = <void*>(<char*>"wofz")
ufunc_wofz_data[0] = &ufunc_wofz_ptr[2*0]
ufunc_wofz_data[1] = &ufunc_wofz_ptr[2*1]
wofz = np.PyUFunc_FromFuncAndData(ufunc_wofz_loops, ufunc_wofz_data, ufunc_wofz_types, 2, 1, 1, 0, "wofz", ufunc_wofz_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_xlog1py_loops[2]
cdef void *ufunc_xlog1py_ptr[4]
cdef void *ufunc_xlog1py_data[2]
cdef char ufunc_xlog1py_types[6]
cdef char *ufunc_xlog1py_doc = (
    "xlog1py(x, y)\n"
    "\n"
    "Compute ``x*log1p(y)`` so that the result is 0 if `x = 0`.\n"
    "\n"
    "Parameters\n"
    "----------\n"
    "x : array_like\n"
    "    Multiplier\n"
    "y : array_like\n"
    "    Argument\n"
    "\n"
    "Returns\n"
    "-------\n"
    "z : array_like\n"
    "    Computed x*log1p(y)")
ufunc_xlog1py_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_xlog1py_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_xlog1py_types[0] = <char>NPY_FLOAT
ufunc_xlog1py_types[1] = <char>NPY_FLOAT
ufunc_xlog1py_types[2] = <char>NPY_FLOAT
ufunc_xlog1py_types[3] = <char>NPY_DOUBLE
ufunc_xlog1py_types[4] = <char>NPY_DOUBLE
ufunc_xlog1py_types[5] = <char>NPY_DOUBLE
ufunc_xlog1py_ptr[2*0] = <void*>_func_xlog1py
ufunc_xlog1py_ptr[2*0+1] = <void*>(<char*>"xlog1py")
ufunc_xlog1py_ptr[2*1] = <void*>_func_xlog1py
ufunc_xlog1py_ptr[2*1+1] = <void*>(<char*>"xlog1py")
ufunc_xlog1py_data[0] = &ufunc_xlog1py_ptr[2*0]
ufunc_xlog1py_data[1] = &ufunc_xlog1py_ptr[2*1]
xlog1py = np.PyUFunc_FromFuncAndData(ufunc_xlog1py_loops, ufunc_xlog1py_data, ufunc_xlog1py_types, 2, 2, 1, 0, "xlog1py", ufunc_xlog1py_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_xlogy_loops[4]
cdef void *ufunc_xlogy_ptr[8]
cdef void *ufunc_xlogy_data[4]
cdef char ufunc_xlogy_types[12]
cdef char *ufunc_xlogy_doc = (
    "xlogy(x, y)\n"
    "\n"
    "Compute ``x*log(y)`` so that the result is 0 if `x = 0`.\n"
    "\n"
    "Parameters\n"
    "----------\n"
    "x : array_like\n"
    "    Multiplier\n"
    "y : array_like\n"
    "    Argument\n"
    "\n"
    "Returns\n"
    "-------\n"
    "z : array_like\n"
    "    Computed x*log(y)")
ufunc_xlogy_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_xlogy_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_xlogy_loops[2] = <np.PyUFuncGenericFunction>loop_D_DD__As_FF_F
ufunc_xlogy_loops[3] = <np.PyUFuncGenericFunction>loop_D_DD__As_DD_D
ufunc_xlogy_types[0] = <char>NPY_FLOAT
ufunc_xlogy_types[1] = <char>NPY_FLOAT
ufunc_xlogy_types[2] = <char>NPY_FLOAT
ufunc_xlogy_types[3] = <char>NPY_DOUBLE
ufunc_xlogy_types[4] = <char>NPY_DOUBLE
ufunc_xlogy_types[5] = <char>NPY_DOUBLE
ufunc_xlogy_types[6] = <char>NPY_CFLOAT
ufunc_xlogy_types[7] = <char>NPY_CFLOAT
ufunc_xlogy_types[8] = <char>NPY_CFLOAT
ufunc_xlogy_types[9] = <char>NPY_CDOUBLE
ufunc_xlogy_types[10] = <char>NPY_CDOUBLE
ufunc_xlogy_types[11] = <char>NPY_CDOUBLE
ufunc_xlogy_ptr[2*0] = <void*>_func_xlogy[double]
ufunc_xlogy_ptr[2*0+1] = <void*>(<char*>"xlogy")
ufunc_xlogy_ptr[2*1] = <void*>_func_xlogy[double]
ufunc_xlogy_ptr[2*1+1] = <void*>(<char*>"xlogy")
ufunc_xlogy_ptr[2*2] = <void*>_func_xlogy[double_complex]
ufunc_xlogy_ptr[2*2+1] = <void*>(<char*>"xlogy")
ufunc_xlogy_ptr[2*3] = <void*>_func_xlogy[double_complex]
ufunc_xlogy_ptr[2*3+1] = <void*>(<char*>"xlogy")
ufunc_xlogy_data[0] = &ufunc_xlogy_ptr[2*0]
ufunc_xlogy_data[1] = &ufunc_xlogy_ptr[2*1]
ufunc_xlogy_data[2] = &ufunc_xlogy_ptr[2*2]
ufunc_xlogy_data[3] = &ufunc_xlogy_ptr[2*3]
xlogy = np.PyUFunc_FromFuncAndData(ufunc_xlogy_loops, ufunc_xlogy_data, ufunc_xlogy_types, 4, 2, 1, 0, "xlogy", ufunc_xlogy_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_y0_loops[2]
cdef void *ufunc_y0_ptr[4]
cdef void *ufunc_y0_data[2]
cdef char ufunc_y0_types[4]
cdef char *ufunc_y0_doc = (
    "y=y0(x) returns the Bessel function of the second kind of order 0 at x.")
ufunc_y0_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_y0_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_y0_types[0] = <char>NPY_FLOAT
ufunc_y0_types[1] = <char>NPY_FLOAT
ufunc_y0_types[2] = <char>NPY_DOUBLE
ufunc_y0_types[3] = <char>NPY_DOUBLE
ufunc_y0_ptr[2*0] = <void*>_func_y0
ufunc_y0_ptr[2*0+1] = <void*>(<char*>"y0")
ufunc_y0_ptr[2*1] = <void*>_func_y0
ufunc_y0_ptr[2*1+1] = <void*>(<char*>"y0")
ufunc_y0_data[0] = &ufunc_y0_ptr[2*0]
ufunc_y0_data[1] = &ufunc_y0_ptr[2*1]
y0 = np.PyUFunc_FromFuncAndData(ufunc_y0_loops, ufunc_y0_data, ufunc_y0_types, 2, 1, 1, 0, "y0", ufunc_y0_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_y1_loops[2]
cdef void *ufunc_y1_ptr[4]
cdef void *ufunc_y1_data[2]
cdef char ufunc_y1_types[4]
cdef char *ufunc_y1_doc = (
    "y=y1(x) returns the Bessel function of the second kind of order 1 at x.")
ufunc_y1_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_y1_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_y1_types[0] = <char>NPY_FLOAT
ufunc_y1_types[1] = <char>NPY_FLOAT
ufunc_y1_types[2] = <char>NPY_DOUBLE
ufunc_y1_types[3] = <char>NPY_DOUBLE
ufunc_y1_ptr[2*0] = <void*>_func_y1
ufunc_y1_ptr[2*0+1] = <void*>(<char*>"y1")
ufunc_y1_ptr[2*1] = <void*>_func_y1
ufunc_y1_ptr[2*1+1] = <void*>(<char*>"y1")
ufunc_y1_data[0] = &ufunc_y1_ptr[2*0]
ufunc_y1_data[1] = &ufunc_y1_ptr[2*1]
y1 = np.PyUFunc_FromFuncAndData(ufunc_y1_loops, ufunc_y1_data, ufunc_y1_types, 2, 1, 1, 0, "y1", ufunc_y1_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_yn_loops[4]
cdef void *ufunc_yn_ptr[8]
cdef void *ufunc_yn_data[4]
cdef char ufunc_yn_types[12]
cdef char *ufunc_yn_doc = (
    "y=yn(n,x) returns the Bessel function of the second kind of integer\n"
    "order n at x.")
ufunc_yn_loops[0] = <np.PyUFuncGenericFunction>loop_d_id__As_lf_f
ufunc_yn_loops[1] = <np.PyUFuncGenericFunction>loop_d_id__As_ld_d
ufunc_yn_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_yn_loops[3] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_yn_types[0] = <char>NPY_LONG
ufunc_yn_types[1] = <char>NPY_FLOAT
ufunc_yn_types[2] = <char>NPY_FLOAT
ufunc_yn_types[3] = <char>NPY_LONG
ufunc_yn_types[4] = <char>NPY_DOUBLE
ufunc_yn_types[5] = <char>NPY_DOUBLE
ufunc_yn_types[6] = <char>NPY_FLOAT
ufunc_yn_types[7] = <char>NPY_FLOAT
ufunc_yn_types[8] = <char>NPY_FLOAT
ufunc_yn_types[9] = <char>NPY_DOUBLE
ufunc_yn_types[10] = <char>NPY_DOUBLE
ufunc_yn_types[11] = <char>NPY_DOUBLE
ufunc_yn_ptr[2*0] = <void*>_func_yn
ufunc_yn_ptr[2*0+1] = <void*>(<char*>"yn")
ufunc_yn_ptr[2*1] = <void*>_func_yn
ufunc_yn_ptr[2*1+1] = <void*>(<char*>"yn")
ufunc_yn_ptr[2*2] = <void*>_func_yn_unsafe
ufunc_yn_ptr[2*2+1] = <void*>(<char*>"yn")
ufunc_yn_ptr[2*3] = <void*>_func_yn_unsafe
ufunc_yn_ptr[2*3+1] = <void*>(<char*>"yn")
ufunc_yn_data[0] = &ufunc_yn_ptr[2*0]
ufunc_yn_data[1] = &ufunc_yn_ptr[2*1]
ufunc_yn_data[2] = &ufunc_yn_ptr[2*2]
ufunc_yn_data[3] = &ufunc_yn_ptr[2*3]
yn = np.PyUFunc_FromFuncAndData(ufunc_yn_loops, ufunc_yn_data, ufunc_yn_types, 4, 2, 1, 0, "yn", ufunc_yn_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_yv_loops[4]
cdef void *ufunc_yv_ptr[8]
cdef void *ufunc_yv_data[4]
cdef char ufunc_yv_types[12]
cdef char *ufunc_yv_doc = (
    "y=yv(v,z) returns the Bessel function of the second kind of real\n"
    "order v at complex z.")
ufunc_yv_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_yv_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_yv_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_yv_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_yv_types[0] = <char>NPY_FLOAT
ufunc_yv_types[1] = <char>NPY_FLOAT
ufunc_yv_types[2] = <char>NPY_FLOAT
ufunc_yv_types[3] = <char>NPY_FLOAT
ufunc_yv_types[4] = <char>NPY_CFLOAT
ufunc_yv_types[5] = <char>NPY_CFLOAT
ufunc_yv_types[6] = <char>NPY_DOUBLE
ufunc_yv_types[7] = <char>NPY_DOUBLE
ufunc_yv_types[8] = <char>NPY_DOUBLE
ufunc_yv_types[9] = <char>NPY_DOUBLE
ufunc_yv_types[10] = <char>NPY_CDOUBLE
ufunc_yv_types[11] = <char>NPY_CDOUBLE
ufunc_yv_ptr[2*0] = <void*>_func_cbesy_wrap_real
ufunc_yv_ptr[2*0+1] = <void*>(<char*>"yv")
ufunc_yv_ptr[2*1] = <void*>_func_cbesy_wrap
ufunc_yv_ptr[2*1+1] = <void*>(<char*>"yv")
ufunc_yv_ptr[2*2] = <void*>_func_cbesy_wrap_real
ufunc_yv_ptr[2*2+1] = <void*>(<char*>"yv")
ufunc_yv_ptr[2*3] = <void*>_func_cbesy_wrap
ufunc_yv_ptr[2*3+1] = <void*>(<char*>"yv")
ufunc_yv_data[0] = &ufunc_yv_ptr[2*0]
ufunc_yv_data[1] = &ufunc_yv_ptr[2*1]
ufunc_yv_data[2] = &ufunc_yv_ptr[2*2]
ufunc_yv_data[3] = &ufunc_yv_ptr[2*3]
yv = np.PyUFunc_FromFuncAndData(ufunc_yv_loops, ufunc_yv_data, ufunc_yv_types, 4, 2, 1, 0, "yv", ufunc_yv_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_yve_loops[4]
cdef void *ufunc_yve_ptr[8]
cdef void *ufunc_yve_data[4]
cdef char ufunc_yve_types[12]
cdef char *ufunc_yve_doc = (
    "y=yve(v,z) returns the exponentially scaled Bessel function of the second\n"
    "kind of real order v at complex z: yve(v,z) = yv(v,z) * exp(-abs(z.imag))")
ufunc_yve_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_yve_loops[1] = <np.PyUFuncGenericFunction>loop_D_dD__As_fF_F
ufunc_yve_loops[2] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_yve_loops[3] = <np.PyUFuncGenericFunction>loop_D_dD__As_dD_D
ufunc_yve_types[0] = <char>NPY_FLOAT
ufunc_yve_types[1] = <char>NPY_FLOAT
ufunc_yve_types[2] = <char>NPY_FLOAT
ufunc_yve_types[3] = <char>NPY_FLOAT
ufunc_yve_types[4] = <char>NPY_CFLOAT
ufunc_yve_types[5] = <char>NPY_CFLOAT
ufunc_yve_types[6] = <char>NPY_DOUBLE
ufunc_yve_types[7] = <char>NPY_DOUBLE
ufunc_yve_types[8] = <char>NPY_DOUBLE
ufunc_yve_types[9] = <char>NPY_DOUBLE
ufunc_yve_types[10] = <char>NPY_CDOUBLE
ufunc_yve_types[11] = <char>NPY_CDOUBLE
ufunc_yve_ptr[2*0] = <void*>_func_cbesy_wrap_e_real
ufunc_yve_ptr[2*0+1] = <void*>(<char*>"yve")
ufunc_yve_ptr[2*1] = <void*>_func_cbesy_wrap_e
ufunc_yve_ptr[2*1+1] = <void*>(<char*>"yve")
ufunc_yve_ptr[2*2] = <void*>_func_cbesy_wrap_e_real
ufunc_yve_ptr[2*2+1] = <void*>(<char*>"yve")
ufunc_yve_ptr[2*3] = <void*>_func_cbesy_wrap_e
ufunc_yve_ptr[2*3+1] = <void*>(<char*>"yve")
ufunc_yve_data[0] = &ufunc_yve_ptr[2*0]
ufunc_yve_data[1] = &ufunc_yve_ptr[2*1]
ufunc_yve_data[2] = &ufunc_yve_ptr[2*2]
ufunc_yve_data[3] = &ufunc_yve_ptr[2*3]
yve = np.PyUFunc_FromFuncAndData(ufunc_yve_loops, ufunc_yve_data, ufunc_yve_types, 4, 2, 1, 0, "yve", ufunc_yve_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_zeta_loops[2]
cdef void *ufunc_zeta_ptr[4]
cdef void *ufunc_zeta_data[2]
cdef char ufunc_zeta_types[6]
cdef char *ufunc_zeta_doc = (
    "y=zeta(x,q) returns the Riemann zeta function of two arguments:\n"
    "sum((k+q)**(-x),k=0..inf)")
ufunc_zeta_loops[0] = <np.PyUFuncGenericFunction>loop_d_dd__As_ff_f
ufunc_zeta_loops[1] = <np.PyUFuncGenericFunction>loop_d_dd__As_dd_d
ufunc_zeta_types[0] = <char>NPY_FLOAT
ufunc_zeta_types[1] = <char>NPY_FLOAT
ufunc_zeta_types[2] = <char>NPY_FLOAT
ufunc_zeta_types[3] = <char>NPY_DOUBLE
ufunc_zeta_types[4] = <char>NPY_DOUBLE
ufunc_zeta_types[5] = <char>NPY_DOUBLE
ufunc_zeta_ptr[2*0] = <void*>_func_zeta
ufunc_zeta_ptr[2*0+1] = <void*>(<char*>"zeta")
ufunc_zeta_ptr[2*1] = <void*>_func_zeta
ufunc_zeta_ptr[2*1+1] = <void*>(<char*>"zeta")
ufunc_zeta_data[0] = &ufunc_zeta_ptr[2*0]
ufunc_zeta_data[1] = &ufunc_zeta_ptr[2*1]
zeta = np.PyUFunc_FromFuncAndData(ufunc_zeta_loops, ufunc_zeta_data, ufunc_zeta_types, 2, 2, 1, 0, "zeta", ufunc_zeta_doc, 0)

cdef np.PyUFuncGenericFunction ufunc_zetac_loops[2]
cdef void *ufunc_zetac_ptr[4]
cdef void *ufunc_zetac_data[2]
cdef char ufunc_zetac_types[4]
cdef char *ufunc_zetac_doc = (
    "y=zetac(x) returns 1.0 - the Riemann zeta function: sum(k**(-x), k=2..inf)")
ufunc_zetac_loops[0] = <np.PyUFuncGenericFunction>loop_d_d__As_f_f
ufunc_zetac_loops[1] = <np.PyUFuncGenericFunction>loop_d_d__As_d_d
ufunc_zetac_types[0] = <char>NPY_FLOAT
ufunc_zetac_types[1] = <char>NPY_FLOAT
ufunc_zetac_types[2] = <char>NPY_DOUBLE
ufunc_zetac_types[3] = <char>NPY_DOUBLE
ufunc_zetac_ptr[2*0] = <void*>_func_zetac
ufunc_zetac_ptr[2*0+1] = <void*>(<char*>"zetac")
ufunc_zetac_ptr[2*1] = <void*>_func_zetac
ufunc_zetac_ptr[2*1+1] = <void*>(<char*>"zetac")
ufunc_zetac_data[0] = &ufunc_zetac_ptr[2*0]
ufunc_zetac_data[1] = &ufunc_zetac_ptr[2*1]
zetac = np.PyUFunc_FromFuncAndData(ufunc_zetac_loops, ufunc_zetac_data, ufunc_zetac_types, 2, 1, 1, 0, "zetac", ufunc_zetac_doc, 0)

#
# Aliases
#
jn = jv
