# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CheckNameAvailabilityRequest(_serialization.Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the resource for which availability needs to be checked.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponse(_serialization.Model):
    """The check availability result.

    :ivar name_available: Indicates if the resource name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the given name is not available. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.communication.models.CheckNameAvailabilityReason
    :ivar message: Detailed reason why the given name is available.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Indicates if the resource name is available.
        :paramtype name_available: bool
        :keyword reason: The reason why the given name is not available. Known values are: "Invalid"
         and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.communication.models.CheckNameAvailabilityReason
        :keyword message: Detailed reason why the given name is available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class CommunicationServiceKeys(_serialization.Model):
    """A class representing the access keys of a CommunicationService.

    :ivar primary_key: The primary access key.
    :vartype primary_key: str
    :ivar secondary_key: The secondary access key.
    :vartype secondary_key: str
    :ivar primary_connection_string: CommunicationService connection string constructed via the
     primaryKey.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: CommunicationService connection string constructed via the
     secondaryKey.
    :vartype secondary_connection_string: str
    """

    _attribute_map = {
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
        "primary_connection_string": {"key": "primaryConnectionString", "type": "str"},
        "secondary_connection_string": {"key": "secondaryConnectionString", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        primary_connection_string: Optional[str] = None,
        secondary_connection_string: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_key: The primary access key.
        :paramtype primary_key: str
        :keyword secondary_key: The secondary access key.
        :paramtype secondary_key: str
        :keyword primary_connection_string: CommunicationService connection string constructed via the
         primaryKey.
        :paramtype primary_connection_string: str
        :keyword secondary_connection_string: CommunicationService connection string constructed via
         the secondaryKey.
        :paramtype secondary_connection_string: str
        """
        super().__init__(**kwargs)
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.primary_connection_string = primary_connection_string
        self.secondary_connection_string = secondary_connection_string


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.communication.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.communication.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class CommunicationServiceResource(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A class representing a CommunicationService resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.communication.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.communication.models.ManagedServiceIdentity
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Running", "Creating", "Updating", "Deleting", and "Moving".
    :vartype provisioning_state: str or
     ~azure.mgmt.communication.models.CommunicationServicesProvisioningState
    :ivar host_name: FQDN of the CommunicationService instance.
    :vartype host_name: str
    :ivar data_location: The location where the communication service stores its data at rest.
    :vartype data_location: str
    :ivar notification_hub_id: Resource ID of an Azure Notification Hub linked to this resource.
    :vartype notification_hub_id: str
    :ivar version: Version of the CommunicationService resource. Probably you need the same or
     higher version of client SDKs.
    :vartype version: str
    :ivar immutable_resource_id: The immutable resource Id of the communication service.
    :vartype immutable_resource_id: str
    :ivar linked_domains: List of email Domain resource Ids.
    :vartype linked_domains: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "host_name": {"readonly": True},
        "notification_hub_id": {"readonly": True},
        "version": {"readonly": True},
        "immutable_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "data_location": {"key": "properties.dataLocation", "type": "str"},
        "notification_hub_id": {"key": "properties.notificationHubId", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "immutable_resource_id": {"key": "properties.immutableResourceId", "type": "str"},
        "linked_domains": {"key": "properties.linkedDomains", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        data_location: Optional[str] = None,
        linked_domains: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.communication.models.ManagedServiceIdentity
        :keyword data_location: The location where the communication service stores its data at rest.
        :paramtype data_location: str
        :keyword linked_domains: List of email Domain resource Ids.
        :paramtype linked_domains: list[str]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.host_name = None
        self.data_location = data_location
        self.notification_hub_id = None
        self.version = None
        self.immutable_resource_id = None
        self.linked_domains = linked_domains


class CommunicationServiceResourceList(_serialization.Model):
    """Object that includes an array of CommunicationServices and a possible link for next set.

    :ivar value: List of CommunicationService.
    :vartype value: list[~azure.mgmt.communication.models.CommunicationServiceResource]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CommunicationServiceResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.CommunicationServiceResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of CommunicationService.
        :paramtype value: list[~azure.mgmt.communication.models.CommunicationServiceResource]
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TaggedResource(_serialization.Model):
    """An ARM resource with that can accept tags.

    :ivar tags: Tags of the service which is a list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Tags of the service which is a list of key value pairs that describe the
         resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class CommunicationServiceResourceUpdate(TaggedResource):
    """A class representing update parameters for CommunicationService resource.

    :ivar tags: Tags of the service which is a list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.communication.models.ManagedServiceIdentity
    :ivar linked_domains: List of email Domain resource Ids.
    :vartype linked_domains: list[str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "linked_domains": {"key": "properties.linkedDomains", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        linked_domains: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Tags of the service which is a list of key value pairs that describe the
         resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity (system assigned and/or user assigned identities).
        :paramtype identity: ~azure.mgmt.communication.models.ManagedServiceIdentity
        :keyword linked_domains: List of email Domain resource Ids.
        :paramtype linked_domains: list[str]
        """
        super().__init__(tags=tags, **kwargs)
        self.identity = identity
        self.linked_domains = linked_domains


class DnsRecord(_serialization.Model):
    """A class that represents a VerificationStatus record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of the DNS record. Example: TXT.
    :vartype type: str
    :ivar name: Name of the DNS record.
    :vartype name: str
    :ivar value: Value of the DNS record.
    :vartype value: str
    :ivar ttl: Represents an expiry time in seconds to represent how long this entry can be cached
     by the resolver, default = 3600sec.
    :vartype ttl: int
    """

    _validation = {
        "type": {"readonly": True},
        "name": {"readonly": True},
        "value": {"readonly": True},
        "ttl": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "ttl": {"key": "ttl", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.name = None
        self.value = None
        self.ttl = None


class DomainPropertiesVerificationRecords(_serialization.Model):
    """List of DnsRecord.

    :ivar domain: A class that represents a VerificationStatus record.
    :vartype domain: ~azure.mgmt.communication.models.DnsRecord
    :ivar spf: A class that represents a VerificationStatus record.
    :vartype spf: ~azure.mgmt.communication.models.DnsRecord
    :ivar dkim: A class that represents a VerificationStatus record.
    :vartype dkim: ~azure.mgmt.communication.models.DnsRecord
    :ivar dkim2: A class that represents a VerificationStatus record.
    :vartype dkim2: ~azure.mgmt.communication.models.DnsRecord
    :ivar dmarc: A class that represents a VerificationStatus record.
    :vartype dmarc: ~azure.mgmt.communication.models.DnsRecord
    """

    _attribute_map = {
        "domain": {"key": "Domain", "type": "DnsRecord"},
        "spf": {"key": "SPF", "type": "DnsRecord"},
        "dkim": {"key": "DKIM", "type": "DnsRecord"},
        "dkim2": {"key": "DKIM2", "type": "DnsRecord"},
        "dmarc": {"key": "DMARC", "type": "DnsRecord"},
    }

    def __init__(
        self,
        *,
        domain: Optional["_models.DnsRecord"] = None,
        spf: Optional["_models.DnsRecord"] = None,
        dkim: Optional["_models.DnsRecord"] = None,
        dkim2: Optional["_models.DnsRecord"] = None,
        dmarc: Optional["_models.DnsRecord"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword domain: A class that represents a VerificationStatus record.
        :paramtype domain: ~azure.mgmt.communication.models.DnsRecord
        :keyword spf: A class that represents a VerificationStatus record.
        :paramtype spf: ~azure.mgmt.communication.models.DnsRecord
        :keyword dkim: A class that represents a VerificationStatus record.
        :paramtype dkim: ~azure.mgmt.communication.models.DnsRecord
        :keyword dkim2: A class that represents a VerificationStatus record.
        :paramtype dkim2: ~azure.mgmt.communication.models.DnsRecord
        :keyword dmarc: A class that represents a VerificationStatus record.
        :paramtype dmarc: ~azure.mgmt.communication.models.DnsRecord
        """
        super().__init__(**kwargs)
        self.domain = domain
        self.spf = spf
        self.dkim = dkim
        self.dkim2 = dkim2
        self.dmarc = dmarc


class DomainPropertiesVerificationStates(_serialization.Model):
    """List of VerificationStatusRecord.

    :ivar domain: A class that represents a VerificationStatus record.
    :vartype domain: ~azure.mgmt.communication.models.VerificationStatusRecord
    :ivar spf: A class that represents a VerificationStatus record.
    :vartype spf: ~azure.mgmt.communication.models.VerificationStatusRecord
    :ivar dkim: A class that represents a VerificationStatus record.
    :vartype dkim: ~azure.mgmt.communication.models.VerificationStatusRecord
    :ivar dkim2: A class that represents a VerificationStatus record.
    :vartype dkim2: ~azure.mgmt.communication.models.VerificationStatusRecord
    :ivar dmarc: A class that represents a VerificationStatus record.
    :vartype dmarc: ~azure.mgmt.communication.models.VerificationStatusRecord
    """

    _attribute_map = {
        "domain": {"key": "Domain", "type": "VerificationStatusRecord"},
        "spf": {"key": "SPF", "type": "VerificationStatusRecord"},
        "dkim": {"key": "DKIM", "type": "VerificationStatusRecord"},
        "dkim2": {"key": "DKIM2", "type": "VerificationStatusRecord"},
        "dmarc": {"key": "DMARC", "type": "VerificationStatusRecord"},
    }

    def __init__(
        self,
        *,
        domain: Optional["_models.VerificationStatusRecord"] = None,
        spf: Optional["_models.VerificationStatusRecord"] = None,
        dkim: Optional["_models.VerificationStatusRecord"] = None,
        dkim2: Optional["_models.VerificationStatusRecord"] = None,
        dmarc: Optional["_models.VerificationStatusRecord"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword domain: A class that represents a VerificationStatus record.
        :paramtype domain: ~azure.mgmt.communication.models.VerificationStatusRecord
        :keyword spf: A class that represents a VerificationStatus record.
        :paramtype spf: ~azure.mgmt.communication.models.VerificationStatusRecord
        :keyword dkim: A class that represents a VerificationStatus record.
        :paramtype dkim: ~azure.mgmt.communication.models.VerificationStatusRecord
        :keyword dkim2: A class that represents a VerificationStatus record.
        :paramtype dkim2: ~azure.mgmt.communication.models.VerificationStatusRecord
        :keyword dmarc: A class that represents a VerificationStatus record.
        :paramtype dmarc: ~azure.mgmt.communication.models.VerificationStatusRecord
        """
        super().__init__(**kwargs)
        self.domain = domain
        self.spf = spf
        self.dkim = dkim
        self.dkim2 = dkim2
        self.dmarc = dmarc


class DomainResource(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A class representing a Domains resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.communication.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Running", "Creating", "Updating", "Deleting", and "Moving".
    :vartype provisioning_state: str or ~azure.mgmt.communication.models.DomainsProvisioningState
    :ivar data_location: The location where the Domains resource data is stored at rest.
    :vartype data_location: str
    :ivar from_sender_domain: P2 sender domain that is displayed to the email recipients [RFC
     5322].
    :vartype from_sender_domain: str
    :ivar mail_from_sender_domain: P1 sender domain that is present on the email envelope [RFC
     5321].
    :vartype mail_from_sender_domain: str
    :ivar domain_management: Describes how a Domains resource is being managed. Known values are:
     "AzureManaged", "CustomerManaged", and "CustomerManagedInExchangeOnline".
    :vartype domain_management: str or ~azure.mgmt.communication.models.DomainManagement
    :ivar verification_states: List of VerificationStatusRecord.
    :vartype verification_states:
     ~azure.mgmt.communication.models.DomainPropertiesVerificationStates
    :ivar verification_records: List of DnsRecord.
    :vartype verification_records:
     ~azure.mgmt.communication.models.DomainPropertiesVerificationRecords
    :ivar user_engagement_tracking: Describes whether user engagement tracking is enabled or
     disabled. Known values are: "Disabled" and "Enabled".
    :vartype user_engagement_tracking: str or
     ~azure.mgmt.communication.models.UserEngagementTracking
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "data_location": {"readonly": True},
        "from_sender_domain": {"readonly": True},
        "mail_from_sender_domain": {"readonly": True},
        "verification_states": {"readonly": True},
        "verification_records": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "data_location": {"key": "properties.dataLocation", "type": "str"},
        "from_sender_domain": {"key": "properties.fromSenderDomain", "type": "str"},
        "mail_from_sender_domain": {"key": "properties.mailFromSenderDomain", "type": "str"},
        "domain_management": {"key": "properties.domainManagement", "type": "str"},
        "verification_states": {"key": "properties.verificationStates", "type": "DomainPropertiesVerificationStates"},
        "verification_records": {
            "key": "properties.verificationRecords",
            "type": "DomainPropertiesVerificationRecords",
        },
        "user_engagement_tracking": {"key": "properties.userEngagementTracking", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        domain_management: Optional[Union[str, "_models.DomainManagement"]] = None,
        user_engagement_tracking: Optional[Union[str, "_models.UserEngagementTracking"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword domain_management: Describes how a Domains resource is being managed. Known values
         are: "AzureManaged", "CustomerManaged", and "CustomerManagedInExchangeOnline".
        :paramtype domain_management: str or ~azure.mgmt.communication.models.DomainManagement
        :keyword user_engagement_tracking: Describes whether user engagement tracking is enabled or
         disabled. Known values are: "Disabled" and "Enabled".
        :paramtype user_engagement_tracking: str or
         ~azure.mgmt.communication.models.UserEngagementTracking
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.data_location = None
        self.from_sender_domain = None
        self.mail_from_sender_domain = None
        self.domain_management = domain_management
        self.verification_states = None
        self.verification_records = None
        self.user_engagement_tracking = user_engagement_tracking


class DomainResourceList(_serialization.Model):
    """Object that includes an array of Domains resource and a possible link for next set.

    :ivar value: List of Domains resource.
    :vartype value: list[~azure.mgmt.communication.models.DomainResource]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DomainResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.DomainResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Domains resource.
        :paramtype value: list[~azure.mgmt.communication.models.DomainResource]
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EmailServiceResource(TrackedResource):
    """A class representing an EmailService resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.communication.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Running", "Creating", "Updating", "Deleting", and "Moving".
    :vartype provisioning_state: str or
     ~azure.mgmt.communication.models.EmailServicesProvisioningState
    :ivar data_location: The location where the email service stores its data at rest.
    :vartype data_location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "data_location": {"key": "properties.dataLocation", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        data_location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword data_location: The location where the email service stores its data at rest.
        :paramtype data_location: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.data_location = data_location


class EmailServiceResourceList(_serialization.Model):
    """Object that includes an array of EmailServices and a possible link for next set.

    :ivar value: List of EmailService.
    :vartype value: list[~azure.mgmt.communication.models.EmailServiceResource]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EmailServiceResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EmailServiceResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of EmailService.
        :paramtype value: list[~azure.mgmt.communication.models.EmailServiceResource]
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EmailServiceResourceUpdate(TaggedResource):
    """A class representing update parameters for EmailService resource.

    :ivar tags: Tags of the service which is a list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Tags of the service which is a list of key value pairs that describe the
         resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(tags=tags, **kwargs)


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.communication.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.communication.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.communication.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.communication.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class LinkedNotificationHub(_serialization.Model):
    """A notification hub that has been linked to the communication service.

    :ivar resource_id: The resource ID of the notification hub.
    :vartype resource_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: The resource ID of the notification hub.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id


class LinkNotificationHubParameters(_serialization.Model):
    """Description of an Azure Notification Hub to link to the communication service.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: The resource ID of the notification hub. Required.
    :vartype resource_id: str
    :ivar connection_string: Connection string for the notification hub. Required.
    :vartype connection_string: str
    """

    _validation = {
        "resource_id": {"required": True},
        "connection_string": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
    }

    def __init__(self, *, resource_id: str, connection_string: str, **kwargs: Any) -> None:
        """
        :keyword resource_id: The resource ID of the notification hub. Required.
        :paramtype resource_id: str
        :keyword connection_string: Connection string for the notification hub. Required.
        :paramtype connection_string: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.connection_string = connection_string


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.communication.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.communication.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.communication.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.communication.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class NameAvailabilityParameters(CheckNameAvailabilityRequest):
    """Data POST-ed to the nameAvailability action.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the resource for which availability needs to be checked.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        """
        super().__init__(name=name, type=type, **kwargs)


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.communication.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.communication.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.communication.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.communication.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.communication.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.communication.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class RegenerateKeyParameters(_serialization.Model):
    """Parameters describes the request to regenerate access keys.

    :ivar key_type: The keyType to regenerate. Must be either 'primary' or
     'secondary'(case-insensitive). Known values are: "Primary" and "Secondary".
    :vartype key_type: str or ~azure.mgmt.communication.models.KeyType
    """

    _attribute_map = {
        "key_type": {"key": "keyType", "type": "str"},
    }

    def __init__(self, *, key_type: Optional[Union[str, "_models.KeyType"]] = None, **kwargs: Any) -> None:
        """
        :keyword key_type: The keyType to regenerate. Must be either 'primary' or
         'secondary'(case-insensitive). Known values are: "Primary" and "Secondary".
        :paramtype key_type: str or ~azure.mgmt.communication.models.KeyType
        """
        super().__init__(**kwargs)
        self.key_type = key_type


class SenderUsernameResource(ProxyResource):
    """A class representing a SenderUsername resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.communication.models.SystemData
    :ivar data_location: The location where the SenderUsername resource data is stored at rest.
    :vartype data_location: str
    :ivar username: A sender senderUsername to be used when sending emails.
    :vartype username: str
    :ivar display_name: The display name for the senderUsername.
    :vartype display_name: str
    :ivar provisioning_state: Provisioning state of the resource. Unknown is the default state for
     Communication Services. Known values are: "Unknown", "Succeeded", "Failed", "Canceled",
     "Running", "Creating", "Updating", "Deleting", and "Moving".
    :vartype provisioning_state: str or ~azure.mgmt.communication.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "data_location": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "data_location": {"key": "properties.dataLocation", "type": "str"},
        "username": {"key": "properties.username", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, username: Optional[str] = None, display_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword username: A sender senderUsername to be used when sending emails.
        :paramtype username: str
        :keyword display_name: The display name for the senderUsername.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.data_location = None
        self.username = username
        self.display_name = display_name
        self.provisioning_state = None


class SenderUsernameResourceCollection(_serialization.Model):
    """A class representing a Domains SenderUsernames collection.

    :ivar value: List of SenderUsernames.
    :vartype value: list[~azure.mgmt.communication.models.SenderUsernameResource]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SenderUsernameResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SenderUsernameResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of SenderUsernames.
        :paramtype value: list[~azure.mgmt.communication.models.SenderUsernameResource]
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.communication.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.communication.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.communication.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.communication.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UpdateDomainRequestParameters(TaggedResource):
    """A class that describes the PATCH request parameters of a Domains resource.

    :ivar tags: Tags of the service which is a list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar user_engagement_tracking: Describes whether user engagement tracking is enabled or
     disabled. Known values are: "Disabled" and "Enabled".
    :vartype user_engagement_tracking: str or
     ~azure.mgmt.communication.models.UserEngagementTracking
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "user_engagement_tracking": {"key": "properties.userEngagementTracking", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        user_engagement_tracking: Optional[Union[str, "_models.UserEngagementTracking"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Tags of the service which is a list of key value pairs that describe the
         resource.
        :paramtype tags: dict[str, str]
        :keyword user_engagement_tracking: Describes whether user engagement tracking is enabled or
         disabled. Known values are: "Disabled" and "Enabled".
        :paramtype user_engagement_tracking: str or
         ~azure.mgmt.communication.models.UserEngagementTracking
        """
        super().__init__(tags=tags, **kwargs)
        self.user_engagement_tracking = user_engagement_tracking


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VerificationParameter(_serialization.Model):
    """Input parameter for verification APIs.

    All required parameters must be populated in order to send to Azure.

    :ivar verification_type: Type of verification. Required. Known values are: "Domain", "SPF",
     "DKIM", "DKIM2", and "DMARC".
    :vartype verification_type: str or ~azure.mgmt.communication.models.VerificationType
    """

    _validation = {
        "verification_type": {"required": True},
    }

    _attribute_map = {
        "verification_type": {"key": "verificationType", "type": "str"},
    }

    def __init__(self, *, verification_type: Union[str, "_models.VerificationType"], **kwargs: Any) -> None:
        """
        :keyword verification_type: Type of verification. Required. Known values are: "Domain", "SPF",
         "DKIM", "DKIM2", and "DMARC".
        :paramtype verification_type: str or ~azure.mgmt.communication.models.VerificationType
        """
        super().__init__(**kwargs)
        self.verification_type = verification_type


class VerificationStatusRecord(_serialization.Model):
    """A class that represents a VerificationStatus record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Status of the verification operation. Known values are: "NotStarted",
     "VerificationRequested", "VerificationInProgress", "VerificationFailed", "Verified", and
     "CancellationRequested".
    :vartype status: str or ~azure.mgmt.communication.models.VerificationStatus
    :ivar error_code: Error code. This property will only be present if the status is
     UnableToVerify.
    :vartype error_code: str
    """

    _validation = {
        "status": {"readonly": True},
        "error_code": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.error_code = None
