# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, IO, Optional, TypeVar, Union

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class PathOperations(object):
    """PathOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.storage.filedatalake.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def create(
        self,
        request_id_parameter=None,  # type: Optional[str]
        timeout=None,  # type: Optional[int]
        resource=None,  # type: Optional[Union[str, "_models.PathResourceType"]]
        continuation=None,  # type: Optional[str]
        mode=None,  # type: Optional[Union[str, "_models.PathRenameMode"]]
        rename_source=None,  # type: Optional[str]
        source_lease_id=None,  # type: Optional[str]
        properties=None,  # type: Optional[str]
        permissions=None,  # type: Optional[str]
        umask=None,  # type: Optional[str]
        path_http_headers=None,  # type: Optional["_models.PathHTTPHeaders"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        source_modified_access_conditions=None,  # type: Optional["_models.SourceModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Create File | Create Directory | Rename File | Rename Directory.

        Create or rename a file or directory.    By default, the destination is overwritten and if the
        destination already exists and has a lease the lease is broken.  This operation supports
        conditional HTTP requests.  For more information, see `Specifying Conditional Headers for Blob
        Service Operations
        <https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations>`_.
        To fail if the destination already exists, use a conditional request with If-None-Match: "*".

        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param resource: Required only for Create File and Create Directory. The value must be "file"
         or "directory".
        :type resource: str or ~azure.storage.filedatalake.models.PathResourceType
        :param continuation: Optional.  When deleting a directory, the number of paths that are deleted
         with each invocation is limited.  If the number of paths to be deleted exceeds this limit, a
         continuation token is returned in this response header.  When a continuation token is returned
         in the response, it must be specified in a subsequent invocation of the delete operation to
         continue deleting the directory.
        :type continuation: str
        :param mode: Optional. Valid only when namespace is enabled. This parameter determines the
         behavior of the rename operation. The value must be "legacy" or "posix", and the default value
         will be "posix".
        :type mode: str or ~azure.storage.filedatalake.models.PathRenameMode
        :param rename_source: An optional file or directory to be renamed.  The value must have the
         following format: "/{filesystem}/{path}".  If "x-ms-properties" is specified, the properties
         will overwrite the existing properties; otherwise, the existing properties will be preserved.
         This value must be a URL percent-encoded string. Note that the string may only contain ASCII
         characters in the ISO-8859-1 character set.
        :type rename_source: str
        :param source_lease_id: A lease ID for the source path. If specified, the source path must have
         an active lease and the lease ID must match.
        :type source_lease_id: str
        :param properties: Optional. User-defined properties to be stored with the filesystem, in the
         format of a comma-separated list of name and value pairs "n1=v1, n2=v2, ...", where each value
         is a base64 encoded string. Note that the string may only contain ASCII characters in the
         ISO-8859-1 character set.  If the filesystem exists, any properties not included in the list
         will be removed.  All properties are removed if the header is omitted.  To merge new and
         existing properties, first get all existing properties and the current E-Tag, then make a
         conditional request with the E-Tag and include values for all properties.
        :type properties: str
        :param permissions: Optional and only valid if Hierarchical Namespace is enabled for the
         account. Sets POSIX access permissions for the file owner, the file owning group, and others.
         Each class may be granted read, write, or execute permission.  The sticky bit is also
         supported.  Both symbolic (rwxrw-rw-) and 4-digit octal notation (e.g. 0766) are supported.
        :type permissions: str
        :param umask: Optional and only valid if Hierarchical Namespace is enabled for the account.
         When creating a file or directory and the parent folder does not have a default ACL, the umask
         restricts the permissions of the file or directory to be created.  The resulting permission is
         given by p bitwise and not u, where p is the permission and u is the umask.  For example, if p
         is 0777 and u is 0057, then the resulting permission is 0720.  The default permission is 0777
         for a directory and 0666 for a file.  The default umask is 0027.  The umask must be specified
         in 4-digit octal notation (e.g. 0766).
        :type umask: str
        :param path_http_headers: Parameter group.
        :type path_http_headers: ~azure.storage.filedatalake.models.PathHTTPHeaders
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :param source_modified_access_conditions: Parameter group.
        :type source_modified_access_conditions: ~azure.storage.filedatalake.models.SourceModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _cache_control = None
        _content_encoding = None
        _content_language = None
        _content_disposition = None
        _content_type = None
        _lease_id = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        _source_if_match = None
        _source_if_none_match = None
        _source_if_modified_since = None
        _source_if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        if path_http_headers is not None:
            _cache_control = path_http_headers.cache_control
            _content_encoding = path_http_headers.content_encoding
            _content_language = path_http_headers.content_language
            _content_disposition = path_http_headers.content_disposition
            _content_type = path_http_headers.content_type
        if source_modified_access_conditions is not None:
            _source_if_match = source_modified_access_conditions.source_if_match
            _source_if_none_match = source_modified_access_conditions.source_if_none_match
            _source_if_modified_since = source_modified_access_conditions.source_if_modified_since
            _source_if_unmodified_since = source_modified_access_conditions.source_if_unmodified_since
        accept = "application/json"

        # Construct URL
        url = self.create.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if resource is not None:
            query_parameters['resource'] = self._serialize.query("resource", resource, 'str')
        if continuation is not None:
            query_parameters['continuation'] = self._serialize.query("continuation", continuation, 'str')
        if mode is not None:
            query_parameters['mode'] = self._serialize.query("mode", mode, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if _cache_control is not None:
            header_parameters['x-ms-cache-control'] = self._serialize.header("cache_control", _cache_control, 'str')
        if _content_encoding is not None:
            header_parameters['x-ms-content-encoding'] = self._serialize.header("content_encoding", _content_encoding, 'str')
        if _content_language is not None:
            header_parameters['x-ms-content-language'] = self._serialize.header("content_language", _content_language, 'str')
        if _content_disposition is not None:
            header_parameters['x-ms-content-disposition'] = self._serialize.header("content_disposition", _content_disposition, 'str')
        if _content_type is not None:
            header_parameters['x-ms-content-type'] = self._serialize.header("content_type", _content_type, 'str')
        if rename_source is not None:
            header_parameters['x-ms-rename-source'] = self._serialize.header("rename_source", rename_source, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if source_lease_id is not None:
            header_parameters['x-ms-source-lease-id'] = self._serialize.header("source_lease_id", source_lease_id, 'str')
        if properties is not None:
            header_parameters['x-ms-properties'] = self._serialize.header("properties", properties, 'str')
        if permissions is not None:
            header_parameters['x-ms-permissions'] = self._serialize.header("permissions", permissions, 'str')
        if umask is not None:
            header_parameters['x-ms-umask'] = self._serialize.header("umask", umask, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _source_if_match is not None:
            header_parameters['x-ms-source-if-match'] = self._serialize.header("source_if_match", _source_if_match, 'str')
        if _source_if_none_match is not None:
            header_parameters['x-ms-source-if-none-match'] = self._serialize.header("source_if_none_match", _source_if_none_match, 'str')
        if _source_if_modified_since is not None:
            header_parameters['x-ms-source-if-modified-since'] = self._serialize.header("source_if_modified_since", _source_if_modified_since, 'rfc-1123')
        if _source_if_unmodified_since is not None:
            header_parameters['x-ms-source-if-unmodified-since'] = self._serialize.header("source_if_unmodified_since", _source_if_unmodified_since, 'rfc-1123')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['x-ms-continuation']=self._deserialize('str', response.headers.get('x-ms-continuation'))
        response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    create.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def update(
        self,
        action,  # type: Union[str, "_models.PathUpdateAction"]
        mode,  # type: Union[str, "_models.PathSetAccessControlRecursiveMode"]
        body,  # type: IO
        request_id_parameter=None,  # type: Optional[str]
        timeout=None,  # type: Optional[int]
        max_records=None,  # type: Optional[int]
        continuation=None,  # type: Optional[str]
        force_flag=None,  # type: Optional[bool]
        position=None,  # type: Optional[int]
        retain_uncommitted_data=None,  # type: Optional[bool]
        close=None,  # type: Optional[bool]
        content_length=None,  # type: Optional[int]
        properties=None,  # type: Optional[str]
        owner=None,  # type: Optional[str]
        group=None,  # type: Optional[str]
        permissions=None,  # type: Optional[str]
        acl=None,  # type: Optional[str]
        path_http_headers=None,  # type: Optional["_models.PathHTTPHeaders"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional["_models.SetAccessControlRecursiveResponse"]
        """Append Data | Flush Data | Set Properties | Set Access Control.

        Uploads data to be appended to a file, flushes (writes) previously uploaded data to a file,
        sets properties for a file or directory, or sets access control for a file or directory. Data
        can only be appended to a file. Concurrent writes to the same file using multiple clients are
        not supported. This operation supports conditional HTTP requests. For more information, see
        `Specifying Conditional Headers for Blob Service Operations
        <https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations>`_.

        :param action: The action must be "append" to upload data to be appended to a file, "flush" to
         flush previously uploaded data to a file, "setProperties" to set the properties of a file or
         directory, "setAccessControl" to set the owner, group, permissions, or access control list for
         a file or directory, or  "setAccessControlRecursive" to set the access control list for a
         directory recursively. Note that Hierarchical Namespace must be enabled for the account in
         order to use access control.  Also note that the Access Control List (ACL) includes permissions
         for the owner, owning group, and others, so the x-ms-permissions and x-ms-acl request headers
         are mutually exclusive.
        :type action: str or ~azure.storage.filedatalake.models.PathUpdateAction
        :param mode: Mode "set" sets POSIX access control rights on files and directories, "modify"
         modifies one or more POSIX access control rights  that pre-exist on files and directories,
         "remove" removes one or more POSIX access control rights  that were present earlier on files
         and directories.
        :type mode: str or ~azure.storage.filedatalake.models.PathSetAccessControlRecursiveMode
        :param body: Initial data.
        :type body: IO
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param max_records: Optional. Valid for "SetAccessControlRecursive" operation. It specifies the
         maximum number of files or directories on which the acl change will be applied. If omitted or
         greater than 2,000, the request will process up to 2,000 items.
        :type max_records: int
        :param continuation: Optional. The number of paths processed with each invocation is limited.
         If the number of paths to be processed exceeds this limit, a continuation token is returned in
         the response header x-ms-continuation. When a continuation token is  returned in the response,
         it must be percent-encoded and specified in a subsequent invocation of
         setAccessControlRecursive operation.
        :type continuation: str
        :param force_flag: Optional. Valid for "SetAccessControlRecursive" operation. If set to false,
         the operation will terminate quickly on encountering user errors (4XX). If true, the operation
         will ignore user errors and proceed with the operation on other sub-entities of the directory.
         Continuation token will only be returned when forceFlag is true in case of user errors. If not
         set the default value is false for this.
        :type force_flag: bool
        :param position: This parameter allows the caller to upload data in parallel and control the
         order in which it is appended to the file.  It is required when uploading data to be appended
         to the file and when flushing previously uploaded data to the file.  The value must be the
         position where the data is to be appended.  Uploaded data is not immediately flushed, or
         written, to the file.  To flush, the previously uploaded data must be contiguous, the position
         parameter must be specified and equal to the length of the file after all data has been
         written, and there must not be a request entity body included with the request.
        :type position: long
        :param retain_uncommitted_data: Valid only for flush operations.  If "true", uncommitted data
         is retained after the flush operation completes; otherwise, the uncommitted data is deleted
         after the flush operation.  The default is false.  Data at offsets less than the specified
         position are written to the file when flush succeeds, but this optional parameter allows data
         after the flush position to be retained for a future flush operation.
        :type retain_uncommitted_data: bool
        :param close: Azure Storage Events allow applications to receive notifications when files
         change. When Azure Storage Events are enabled, a file changed event is raised. This event has a
         property indicating whether this is the final change to distinguish the difference between an
         intermediate flush to a file stream and the final close of a file stream. The close query
         parameter is valid only when the action is "flush" and change notifications are enabled. If the
         value of close is "true" and the flush operation completes successfully, the service raises a
         file change notification with a property indicating that this is the final update (the file
         stream has been closed). If "false" a change notification is raised indicating the file has
         changed. The default is false. This query parameter is set to true by the Hadoop ABFS driver to
         indicate that the file stream has been closed.".
        :type close: bool
        :param content_length: Required for "Append Data" and "Flush Data".  Must be 0 for "Flush
         Data".  Must be the length of the request content in bytes for "Append Data".
        :type content_length: long
        :param properties: Optional. User-defined properties to be stored with the filesystem, in the
         format of a comma-separated list of name and value pairs "n1=v1, n2=v2, ...", where each value
         is a base64 encoded string. Note that the string may only contain ASCII characters in the
         ISO-8859-1 character set.  If the filesystem exists, any properties not included in the list
         will be removed.  All properties are removed if the header is omitted.  To merge new and
         existing properties, first get all existing properties and the current E-Tag, then make a
         conditional request with the E-Tag and include values for all properties.
        :type properties: str
        :param owner: Optional. The owner of the blob or directory.
        :type owner: str
        :param group: Optional. The owning group of the blob or directory.
        :type group: str
        :param permissions: Optional and only valid if Hierarchical Namespace is enabled for the
         account. Sets POSIX access permissions for the file owner, the file owning group, and others.
         Each class may be granted read, write, or execute permission.  The sticky bit is also
         supported.  Both symbolic (rwxrw-rw-) and 4-digit octal notation (e.g. 0766) are supported.
        :type permissions: str
        :param acl: Sets POSIX access control rights on files and directories. The value is a
         comma-separated list of access control entries. Each access control entry (ACE) consists of a
         scope, a type, a user or group identifier, and permissions in the format
         "[scope:][type]:[id]:[permissions]".
        :type acl: str
        :param path_http_headers: Parameter group.
        :type path_http_headers: ~azure.storage.filedatalake.models.PathHTTPHeaders
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SetAccessControlRecursiveResponse, or the result of cls(response)
        :rtype: ~azure.storage.filedatalake.models.SetAccessControlRecursiveResponse or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional["_models.SetAccessControlRecursiveResponse"]]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _content_md5 = None
        _lease_id = None
        _cache_control = None
        _content_type = None
        _content_disposition = None
        _content_encoding = None
        _content_language = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        if path_http_headers is not None:
            _content_md5 = path_http_headers.content_md5
            _cache_control = path_http_headers.cache_control
            _content_type = path_http_headers.content_type
            _content_disposition = path_http_headers.content_disposition
            _content_encoding = path_http_headers.content_encoding
            _content_language = path_http_headers.content_language
        content_type = kwargs.pop("content_type", "application/octet-stream")
        accept = "application/json"

        # Construct URL
        url = self.update.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['action'] = self._serialize.query("action", action, 'str')
        if max_records is not None:
            query_parameters['maxRecords'] = self._serialize.query("max_records", max_records, 'int', minimum=1)
        if continuation is not None:
            query_parameters['continuation'] = self._serialize.query("continuation", continuation, 'str')
        query_parameters['mode'] = self._serialize.query("mode", mode, 'str')
        if force_flag is not None:
            query_parameters['forceFlag'] = self._serialize.query("force_flag", force_flag, 'bool')
        if position is not None:
            query_parameters['position'] = self._serialize.query("position", position, 'long')
        if retain_uncommitted_data is not None:
            query_parameters['retainUncommittedData'] = self._serialize.query("retain_uncommitted_data", retain_uncommitted_data, 'bool')
        if close is not None:
            query_parameters['close'] = self._serialize.query("close", close, 'bool')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if content_length is not None:
            header_parameters['Content-Length'] = self._serialize.header("content_length", content_length, 'long', minimum=0)
        if _content_md5 is not None:
            header_parameters['x-ms-content-md5'] = self._serialize.header("content_md5", _content_md5, 'bytearray')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _cache_control is not None:
            header_parameters['x-ms-cache-control'] = self._serialize.header("cache_control", _cache_control, 'str')
        if _content_type is not None:
            header_parameters['x-ms-content-type'] = self._serialize.header("content_type", _content_type, 'str')
        if _content_disposition is not None:
            header_parameters['x-ms-content-disposition'] = self._serialize.header("content_disposition", _content_disposition, 'str')
        if _content_encoding is not None:
            header_parameters['x-ms-content-encoding'] = self._serialize.header("content_encoding", _content_encoding, 'str')
        if _content_language is not None:
            header_parameters['x-ms-content-language'] = self._serialize.header("content_language", _content_language, 'str')
        if properties is not None:
            header_parameters['x-ms-properties'] = self._serialize.header("properties", properties, 'str')
        if owner is not None:
            header_parameters['x-ms-owner'] = self._serialize.header("owner", owner, 'str')
        if group is not None:
            header_parameters['x-ms-group'] = self._serialize.header("group", group, 'str')
        if permissions is not None:
            header_parameters['x-ms-permissions'] = self._serialize.header("permissions", permissions, 'str')
        if acl is not None:
            header_parameters['x-ms-acl'] = self._serialize.header("acl", acl, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content_kwargs['stream_content'] = body
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        deserialized = None
        if response.status_code == 200:
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
            response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
            response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
            response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
            response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
            response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
            response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
            response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
            response_headers['Content-MD5']=self._deserialize('str', response.headers.get('Content-MD5'))
            response_headers['x-ms-properties']=self._deserialize('str', response.headers.get('x-ms-properties'))
            response_headers['x-ms-continuation']=self._deserialize('str', response.headers.get('x-ms-continuation'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            deserialized = self._deserialize('SetAccessControlRecursiveResponse', pipeline_response)

        if response.status_code == 202:
            response_headers['Content-MD5']=self._deserialize('str', response.headers.get('Content-MD5'))
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    update.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def lease(
        self,
        x_ms_lease_action,  # type: Union[str, "_models.PathLeaseAction"]
        request_id_parameter=None,  # type: Optional[str]
        timeout=None,  # type: Optional[int]
        x_ms_lease_duration=None,  # type: Optional[int]
        x_ms_lease_break_period=None,  # type: Optional[int]
        proposed_lease_id=None,  # type: Optional[str]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Lease Path.

        Create and manage a lease to restrict write and delete access to the path. This operation
        supports conditional HTTP requests.  For more information, see `Specifying Conditional Headers
        for Blob Service Operations
        <https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations>`_.

        :param x_ms_lease_action: There are five lease actions: "acquire", "break", "change", "renew",
         and "release". Use "acquire" and specify the "x-ms-proposed-lease-id" and "x-ms-lease-duration"
         to acquire a new lease. Use "break" to break an existing lease. When a lease is broken, the
         lease break period is allowed to elapse, during which time no lease operation except break and
         release can be performed on the file. When a lease is successfully broken, the response
         indicates the interval in seconds until a new lease can be acquired. Use "change" and specify
         the current lease ID in "x-ms-lease-id" and the new lease ID in "x-ms-proposed-lease-id" to
         change the lease ID of an active lease. Use "renew" and specify the "x-ms-lease-id" to renew an
         existing lease. Use "release" and specify the "x-ms-lease-id" to release a lease.
        :type x_ms_lease_action: str or ~azure.storage.filedatalake.models.PathLeaseAction
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param x_ms_lease_duration: The lease duration is required to acquire a lease, and specifies
         the duration of the lease in seconds.  The lease duration must be between 15 and 60 seconds or
         -1 for infinite lease.
        :type x_ms_lease_duration: int
        :param x_ms_lease_break_period: The lease break period duration is optional to break a lease,
         and  specifies the break period of the lease in seconds.  The lease break  duration must be
         between 0 and 60 seconds.
        :type x_ms_lease_break_period: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The Blob service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats.
        :type proposed_lease_id: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        accept = "application/json"

        # Construct URL
        url = self.lease.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        header_parameters['x-ms-lease-action'] = self._serialize.header("x_ms_lease_action", x_ms_lease_action, 'str')
        if x_ms_lease_duration is not None:
            header_parameters['x-ms-lease-duration'] = self._serialize.header("x_ms_lease_duration", x_ms_lease_duration, 'int')
        if x_ms_lease_break_period is not None:
            header_parameters['x-ms-lease-break-period'] = self._serialize.header("x_ms_lease_break_period", x_ms_lease_break_period, 'int')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if proposed_lease_id is not None:
            header_parameters['x-ms-proposed-lease-id'] = self._serialize.header("proposed_lease_id", proposed_lease_id, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))

        if response.status_code == 201:
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))

        if response.status_code == 202:
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['x-ms-lease-time']=self._deserialize('str', response.headers.get('x-ms-lease-time'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    lease.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def read(
        self,
        request_id_parameter=None,  # type: Optional[str]
        timeout=None,  # type: Optional[int]
        range=None,  # type: Optional[str]
        x_ms_range_get_content_md5=None,  # type: Optional[bool]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> IO
        """Read File.

        Read the contents of a file.  For read operations, range requests are supported. This operation
        supports conditional HTTP requests.  For more information, see `Specifying Conditional Headers
        for Blob Service Operations
        <https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations>`_.

        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param range: The HTTP Range request header specifies one or more byte ranges of the resource
         to be retrieved.
        :type range: str
        :param x_ms_range_get_content_md5: Optional. When this header is set to "true" and specified
         together with the Range header, the service returns the MD5 hash for the range, as long as the
         range is less than or equal to 4MB in size. If this header is specified without the Range
         header, the service returns status code 400 (Bad Request). If this header is set to true when
         the range exceeds 4 MB in size, the service returns status code 400 (Bad Request).
        :type x_ms_range_get_content_md5: bool
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IO, or the result of cls(response)
        :rtype: IO
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[IO]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        accept = "application/json"

        # Construct URL
        url = self.read.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if range is not None:
            header_parameters['Range'] = self._serialize.header("range", range, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if x_ms_range_get_content_md5 is not None:
            header_parameters['x-ms-range-get-content-md5'] = self._serialize.header("x_ms_range_get_content_md5", x_ms_range_get_content_md5, 'bool')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
            response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
            response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
            response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
            response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
            response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
            response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
            response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
            response_headers['Content-MD5']=self._deserialize('str', response.headers.get('Content-MD5'))
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['x-ms-resource-type']=self._deserialize('str', response.headers.get('x-ms-resource-type'))
            response_headers['x-ms-properties']=self._deserialize('str', response.headers.get('x-ms-properties'))
            response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
            response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
            response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
            deserialized = response.stream_download(self._client._pipeline)

        if response.status_code == 206:
            response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
            response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
            response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
            response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
            response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
            response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
            response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
            response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
            response_headers['Content-MD5']=self._deserialize('str', response.headers.get('Content-MD5'))
            response_headers['x-ms-content-md5']=self._deserialize('str', response.headers.get('x-ms-content-md5'))
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['x-ms-resource-type']=self._deserialize('str', response.headers.get('x-ms-resource-type'))
            response_headers['x-ms-properties']=self._deserialize('str', response.headers.get('x-ms-properties'))
            response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
            response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
            response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
            deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    read.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def get_properties(
        self,
        request_id_parameter=None,  # type: Optional[str]
        timeout=None,  # type: Optional[int]
        action=None,  # type: Optional[Union[str, "_models.PathGetPropertiesAction"]]
        upn=None,  # type: Optional[bool]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Get Properties | Get Status | Get Access Control List.

        Get Properties returns all system and user defined properties for a path. Get Status returns
        all system defined properties for a path. Get Access Control List returns the access control
        list for a path. This operation supports conditional HTTP requests.  For more information, see
        `Specifying Conditional Headers for Blob Service Operations
        <https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations>`_.

        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param action: Optional. If the value is "getStatus" only the system defined properties for the
         path are returned. If the value is "getAccessControl" the access control list is returned in
         the response headers (Hierarchical Namespace must be enabled for the account), otherwise the
         properties are returned.
        :type action: str or ~azure.storage.filedatalake.models.PathGetPropertiesAction
        :param upn: Optional. Valid only when Hierarchical Namespace is enabled for the account. If
         "true", the user identity values returned in the x-ms-owner, x-ms-group, and x-ms-acl response
         headers will be transformed from Azure Active Directory Object IDs to User Principal Names.  If
         "false", the values will be returned as Azure Active Directory Object IDs. The default value is
         false. Note that group and application Object IDs are not translated because they do not have
         unique friendly names.
        :type upn: bool
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        accept = "application/json"

        # Construct URL
        url = self.get_properties.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if action is not None:
            query_parameters['action'] = self._serialize.query("action", action, 'str')
        if upn is not None:
            query_parameters['upn'] = self._serialize.query("upn", upn, 'bool')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
        response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
        response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
        response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
        response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
        response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
        response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
        response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
        response_headers['Content-MD5']=self._deserialize('str', response.headers.get('Content-MD5'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['x-ms-resource-type']=self._deserialize('str', response.headers.get('x-ms-resource-type'))
        response_headers['x-ms-properties']=self._deserialize('str', response.headers.get('x-ms-properties'))
        response_headers['x-ms-owner']=self._deserialize('str', response.headers.get('x-ms-owner'))
        response_headers['x-ms-group']=self._deserialize('str', response.headers.get('x-ms-group'))
        response_headers['x-ms-permissions']=self._deserialize('str', response.headers.get('x-ms-permissions'))
        response_headers['x-ms-acl']=self._deserialize('str', response.headers.get('x-ms-acl'))
        response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
        response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
        response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    get_properties.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def delete(
        self,
        request_id_parameter=None,  # type: Optional[str]
        timeout=None,  # type: Optional[int]
        recursive=None,  # type: Optional[bool]
        continuation=None,  # type: Optional[str]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete File | Delete Directory.

        Delete the file or directory. This operation supports conditional HTTP requests.  For more
        information, see `Specifying Conditional Headers for Blob Service Operations
        <https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations>`_.

        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param recursive: Required.
        :type recursive: bool
        :param continuation: Optional.  When deleting a directory, the number of paths that are deleted
         with each invocation is limited.  If the number of paths to be deleted exceeds this limit, a
         continuation token is returned in this response header.  When a continuation token is returned
         in the response, it must be specified in a subsequent invocation of the delete operation to
         continue deleting the directory.
        :type continuation: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        accept = "application/json"

        # Construct URL
        url = self.delete.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if recursive is not None:
            query_parameters['recursive'] = self._serialize.query("recursive", recursive, 'bool')
        if continuation is not None:
            query_parameters['continuation'] = self._serialize.query("continuation", continuation, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['x-ms-continuation']=self._deserialize('str', response.headers.get('x-ms-continuation'))
        response_headers['x-ms-deletion-id']=self._deserialize('str', response.headers.get('x-ms-deletion-id'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    delete.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def set_access_control(
        self,
        timeout=None,  # type: Optional[int]
        owner=None,  # type: Optional[str]
        group=None,  # type: Optional[str]
        permissions=None,  # type: Optional[str]
        acl=None,  # type: Optional[str]
        request_id_parameter=None,  # type: Optional[str]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Set the owner, group, permissions, or access control list for a path.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param owner: Optional. The owner of the blob or directory.
        :type owner: str
        :param group: Optional. The owning group of the blob or directory.
        :type group: str
        :param permissions: Optional and only valid if Hierarchical Namespace is enabled for the
         account. Sets POSIX access permissions for the file owner, the file owning group, and others.
         Each class may be granted read, write, or execute permission.  The sticky bit is also
         supported.  Both symbolic (rwxrw-rw-) and 4-digit octal notation (e.g. 0766) are supported.
        :type permissions: str
        :param acl: Sets POSIX access control rights on files and directories. The value is a
         comma-separated list of access control entries. Each access control entry (ACE) consists of a
         scope, a type, a user or group identifier, and permissions in the format
         "[scope:][type]:[id]:[permissions]".
        :type acl: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        action = "setAccessControl"
        accept = "application/json"

        # Construct URL
        url = self.set_access_control.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['action'] = self._serialize.query("action", action, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if owner is not None:
            header_parameters['x-ms-owner'] = self._serialize.header("owner", owner, 'str')
        if group is not None:
            header_parameters['x-ms-group'] = self._serialize.header("group", group, 'str')
        if permissions is not None:
            header_parameters['x-ms-permissions'] = self._serialize.header("permissions", permissions, 'str')
        if acl is not None:
            header_parameters['x-ms-acl'] = self._serialize.header("acl", acl, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.patch(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_access_control.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def set_access_control_recursive(
        self,
        mode,  # type: Union[str, "_models.PathSetAccessControlRecursiveMode"]
        timeout=None,  # type: Optional[int]
        continuation=None,  # type: Optional[str]
        force_flag=None,  # type: Optional[bool]
        max_records=None,  # type: Optional[int]
        acl=None,  # type: Optional[str]
        request_id_parameter=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SetAccessControlRecursiveResponse"
        """Set the access control list for a path and sub-paths.

        :param mode: Mode "set" sets POSIX access control rights on files and directories, "modify"
         modifies one or more POSIX access control rights  that pre-exist on files and directories,
         "remove" removes one or more POSIX access control rights  that were present earlier on files
         and directories.
        :type mode: str or ~azure.storage.filedatalake.models.PathSetAccessControlRecursiveMode
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param continuation: Optional.  When deleting a directory, the number of paths that are deleted
         with each invocation is limited.  If the number of paths to be deleted exceeds this limit, a
         continuation token is returned in this response header.  When a continuation token is returned
         in the response, it must be specified in a subsequent invocation of the delete operation to
         continue deleting the directory.
        :type continuation: str
        :param force_flag: Optional. Valid for "SetAccessControlRecursive" operation. If set to false,
         the operation will terminate quickly on encountering user errors (4XX). If true, the operation
         will ignore user errors and proceed with the operation on other sub-entities of the directory.
         Continuation token will only be returned when forceFlag is true in case of user errors. If not
         set the default value is false for this.
        :type force_flag: bool
        :param max_records: Optional. It specifies the maximum number of files or directories on which
         the acl change will be applied. If omitted or greater than 2,000, the request will process up
         to 2,000 items.
        :type max_records: int
        :param acl: Sets POSIX access control rights on files and directories. The value is a
         comma-separated list of access control entries. Each access control entry (ACE) consists of a
         scope, a type, a user or group identifier, and permissions in the format
         "[scope:][type]:[id]:[permissions]".
        :type acl: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SetAccessControlRecursiveResponse, or the result of cls(response)
        :rtype: ~azure.storage.filedatalake.models.SetAccessControlRecursiveResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SetAccessControlRecursiveResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        action = "setAccessControlRecursive"
        accept = "application/json"

        # Construct URL
        url = self.set_access_control_recursive.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['action'] = self._serialize.query("action", action, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if continuation is not None:
            query_parameters['continuation'] = self._serialize.query("continuation", continuation, 'str')
        query_parameters['mode'] = self._serialize.query("mode", mode, 'str')
        if force_flag is not None:
            query_parameters['forceFlag'] = self._serialize.query("force_flag", force_flag, 'bool')
        if max_records is not None:
            query_parameters['maxRecords'] = self._serialize.query("max_records", max_records, 'int', minimum=1)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if acl is not None:
            header_parameters['x-ms-acl'] = self._serialize.header("acl", acl, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.patch(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-continuation']=self._deserialize('str', response.headers.get('x-ms-continuation'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        deserialized = self._deserialize('SetAccessControlRecursiveResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    set_access_control_recursive.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def flush_data(
        self,
        timeout=None,  # type: Optional[int]
        position=None,  # type: Optional[int]
        retain_uncommitted_data=None,  # type: Optional[bool]
        close=None,  # type: Optional[bool]
        content_length=None,  # type: Optional[int]
        request_id_parameter=None,  # type: Optional[str]
        path_http_headers=None,  # type: Optional["_models.PathHTTPHeaders"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        modified_access_conditions=None,  # type: Optional["_models.ModifiedAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Set the owner, group, permissions, or access control list for a path.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param position: This parameter allows the caller to upload data in parallel and control the
         order in which it is appended to the file.  It is required when uploading data to be appended
         to the file and when flushing previously uploaded data to the file.  The value must be the
         position where the data is to be appended.  Uploaded data is not immediately flushed, or
         written, to the file.  To flush, the previously uploaded data must be contiguous, the position
         parameter must be specified and equal to the length of the file after all data has been
         written, and there must not be a request entity body included with the request.
        :type position: long
        :param retain_uncommitted_data: Valid only for flush operations.  If "true", uncommitted data
         is retained after the flush operation completes; otherwise, the uncommitted data is deleted
         after the flush operation.  The default is false.  Data at offsets less than the specified
         position are written to the file when flush succeeds, but this optional parameter allows data
         after the flush position to be retained for a future flush operation.
        :type retain_uncommitted_data: bool
        :param close: Azure Storage Events allow applications to receive notifications when files
         change. When Azure Storage Events are enabled, a file changed event is raised. This event has a
         property indicating whether this is the final change to distinguish the difference between an
         intermediate flush to a file stream and the final close of a file stream. The close query
         parameter is valid only when the action is "flush" and change notifications are enabled. If the
         value of close is "true" and the flush operation completes successfully, the service raises a
         file change notification with a property indicating that this is the final update (the file
         stream has been closed). If "false" a change notification is raised indicating the file has
         changed. The default is false. This query parameter is set to true by the Hadoop ABFS driver to
         indicate that the file stream has been closed.".
        :type close: bool
        :param content_length: Required for "Append Data" and "Flush Data".  Must be 0 for "Flush
         Data".  Must be the length of the request content in bytes for "Append Data".
        :type content_length: long
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param path_http_headers: Parameter group.
        :type path_http_headers: ~azure.storage.filedatalake.models.PathHTTPHeaders
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.filedatalake.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.filedatalake.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _content_md5 = None
        _lease_id = None
        _cache_control = None
        _content_type = None
        _content_disposition = None
        _content_encoding = None
        _content_language = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        if path_http_headers is not None:
            _content_md5 = path_http_headers.content_md5
            _cache_control = path_http_headers.cache_control
            _content_type = path_http_headers.content_type
            _content_disposition = path_http_headers.content_disposition
            _content_encoding = path_http_headers.content_encoding
            _content_language = path_http_headers.content_language
        action = "flush"
        accept = "application/json"

        # Construct URL
        url = self.flush_data.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['action'] = self._serialize.query("action", action, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if position is not None:
            query_parameters['position'] = self._serialize.query("position", position, 'long')
        if retain_uncommitted_data is not None:
            query_parameters['retainUncommittedData'] = self._serialize.query("retain_uncommitted_data", retain_uncommitted_data, 'bool')
        if close is not None:
            query_parameters['close'] = self._serialize.query("close", close, 'bool')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if content_length is not None:
            header_parameters['Content-Length'] = self._serialize.header("content_length", content_length, 'long', minimum=0)
        if _content_md5 is not None:
            header_parameters['x-ms-content-md5'] = self._serialize.header("content_md5", _content_md5, 'bytearray')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _cache_control is not None:
            header_parameters['x-ms-cache-control'] = self._serialize.header("cache_control", _cache_control, 'str')
        if _content_type is not None:
            header_parameters['x-ms-content-type'] = self._serialize.header("content_type", _content_type, 'str')
        if _content_disposition is not None:
            header_parameters['x-ms-content-disposition'] = self._serialize.header("content_disposition", _content_disposition, 'str')
        if _content_encoding is not None:
            header_parameters['x-ms-content-encoding'] = self._serialize.header("content_encoding", _content_encoding, 'str')
        if _content_language is not None:
            header_parameters['x-ms-content-language'] = self._serialize.header("content_language", _content_language, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.patch(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    flush_data.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def append_data(
        self,
        body,  # type: IO
        position=None,  # type: Optional[int]
        timeout=None,  # type: Optional[int]
        content_length=None,  # type: Optional[int]
        transactional_content_crc64=None,  # type: Optional[bytearray]
        request_id_parameter=None,  # type: Optional[str]
        path_http_headers=None,  # type: Optional["_models.PathHTTPHeaders"]
        lease_access_conditions=None,  # type: Optional["_models.LeaseAccessConditions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Append data to the file.

        :param body: Initial data.
        :type body: IO
        :param position: This parameter allows the caller to upload data in parallel and control the
         order in which it is appended to the file.  It is required when uploading data to be appended
         to the file and when flushing previously uploaded data to the file.  The value must be the
         position where the data is to be appended.  Uploaded data is not immediately flushed, or
         written, to the file.  To flush, the previously uploaded data must be contiguous, the position
         parameter must be specified and equal to the length of the file after all data has been
         written, and there must not be a request entity body included with the request.
        :type position: long
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param content_length: Required for "Append Data" and "Flush Data".  Must be 0 for "Flush
         Data".  Must be the length of the request content in bytes for "Append Data".
        :type content_length: long
        :param transactional_content_crc64: Specify the transactional crc64 for the body, to be
         validated by the service.
        :type transactional_content_crc64: bytearray
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param path_http_headers: Parameter group.
        :type path_http_headers: ~azure.storage.filedatalake.models.PathHTTPHeaders
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.filedatalake.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _transactional_content_hash = None
        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if path_http_headers is not None:
            _transactional_content_hash = path_http_headers.transactional_content_hash
        action = "append"
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self.append_data.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['action'] = self._serialize.query("action", action, 'str')
        if position is not None:
            query_parameters['position'] = self._serialize.query("position", position, 'long')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if content_length is not None:
            header_parameters['Content-Length'] = self._serialize.header("content_length", content_length, 'long', minimum=0)
        if _transactional_content_hash is not None:
            header_parameters['Content-MD5'] = self._serialize.header("transactional_content_hash", _transactional_content_hash, 'bytearray')
        if transactional_content_crc64 is not None:
            header_parameters['x-ms-content-crc64'] = self._serialize.header("transactional_content_crc64", transactional_content_crc64, 'bytearray')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content_kwargs['stream_content'] = body
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['x-ms-content-crc64']=self._deserialize('bytearray', response.headers.get('x-ms-content-crc64'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    append_data.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def set_expiry(
        self,
        expiry_options,  # type: Union[str, "_models.PathExpiryOptions"]
        timeout=None,  # type: Optional[int]
        request_id_parameter=None,  # type: Optional[str]
        expires_on=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Sets the time a blob will expire and be deleted.

        :param expiry_options: Required. Indicates mode of the expiry time.
        :type expiry_options: str or ~azure.storage.filedatalake.models.PathExpiryOptions
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param expires_on: The time to set the blob to expiry.
        :type expires_on: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        comp = "expiry"
        accept = "application/json"

        # Construct URL
        url = self.set_expiry.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-expiry-option'] = self._serialize.header("expiry_options", expiry_options, 'str')
        if expires_on is not None:
            header_parameters['x-ms-expiry-time'] = self._serialize.header("expires_on", expires_on, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_expiry.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    def undelete(
        self,
        timeout=None,  # type: Optional[int]
        undelete_source=None,  # type: Optional[str]
        request_id_parameter=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Undelete a path that was previously soft deleted.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
         Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param undelete_source: Only for hierarchical namespace enabled accounts. Optional. The path of
         the soft deleted blob to undelete.
        :type undelete_source: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        comp = "undelete"
        accept = "application/json"

        # Construct URL
        url = self.undelete.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if undelete_source is not None:
            header_parameters['x-ms-undelete-source'] = self._serialize.header("undelete_source", undelete_source, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-resource-type']=self._deserialize('str', response.headers.get('x-ms-resource-type'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    undelete.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore
