# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class WebhookCreateOrUpdateParameters(Model):
    """The parameters supplied to the create or update webhook operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the name of the webhook.
    :type name: str
    :param is_enabled: Gets or sets the value of the enabled flag of webhook.
    :type is_enabled: bool
    :param uri: Gets or sets the uri.
    :type uri: str
    :param expiry_time: Gets or sets the expiry time.
    :type expiry_time: datetime
    :param parameters: Gets or sets the parameters of the job.
    :type parameters: dict[str, str]
    :param runbook: Gets or sets the runbook.
    :type runbook: ~azure.mgmt.automation.models.RunbookAssociationProperty
    :param run_on: Gets or sets the name of the hybrid worker group the
     webhook job will run on.
    :type run_on: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'expiry_time': {'key': 'properties.expiryTime', 'type': 'iso-8601'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'runbook': {'key': 'properties.runbook', 'type': 'RunbookAssociationProperty'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WebhookCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_enabled = kwargs.get('is_enabled', None)
        self.uri = kwargs.get('uri', None)
        self.expiry_time = kwargs.get('expiry_time', None)
        self.parameters = kwargs.get('parameters', None)
        self.runbook = kwargs.get('runbook', None)
        self.run_on = kwargs.get('run_on', None)
