# Documentation

* [PostCSS Architecture](https://github.com/postcss/postcss/blob/main/docs/architecture.md#postcss-architecture)
  * [Overview](https://github.com/postcss/postcss/blob/main/docs/architecture.md#overview)
  * [Workflow](https://github.com/postcss/postcss/blob/main/docs/architecture.md#workflow)
  * [Core Structures](https://github.com/postcss/postcss/blob/main/docs/architecture.md#core-structures)
  * [API Reference](https://github.com/postcss/postcss/blob/main/docs/architecture.md#api-reference)
* [PostCSS Plugins](https://github.com/postcss/postcss/blob/main/docs/plugins.md#postcss-plugins)
  * [Control](https://github.com/postcss/postcss/blob/main/docs/plugins.md#control)
  * [Packs](https://github.com/postcss/postcss/blob/main/docs/plugins.md#packs)
  * [Future CSS Syntax](https://github.com/postcss/postcss/blob/main/docs/plugins.md#future-css-syntax)
  * [Fallbacks](https://github.com/postcss/postcss/blob/main/docs/plugins.md#fallbacks)
  * [Language Extensions](https://github.com/postcss/postcss/blob/main/docs/plugins.md#language-extensions)
  * [Colors](https://github.com/postcss/postcss/blob/main/docs/plugins.md#colors)
  * [Images and Fonts](https://github.com/postcss/postcss/blob/main/docs/plugins.md#images-and-fonts)
  * [Grids](https://github.com/postcss/postcss/blob/main/docs/plugins.md#grids)
  * [Optimizations](https://github.com/postcss/postcss/blob/main/docs/plugins.md#optimizations)
  * [Shortcuts](https://github.com/postcss/postcss/blob/main/docs/plugins.md#shortcuts)
  * [Others](https://github.com/postcss/postcss/blob/main/docs/plugins.md#others)
  * [Analysis](https://github.com/postcss/postcss/blob/main/docs/plugins.md#analysis)
  * [Reporters](https://github.com/postcss/postcss/blob/main/docs/plugins.md#reporters)
  * [Fun](https://github.com/postcss/postcss/blob/main/docs/plugins.md#fun)
* [PostCSS and Source Maps](https://github.com/postcss/postcss/blob/main/docs/source-maps.md#postcss-and-source-maps)

* [How to Write Custom Syntax](https://github.com/postcss/postcss/blob/main/docs/syntax.md#how-to-write-custom-syntax)
  * [Syntax](https://github.com/postcss/postcss/blob/main/docs/syntax.md#syntax)
  * [Parser](https://github.com/postcss/postcss/blob/main/docs/syntax.md#parser)
    * [Main Theory](https://github.com/postcss/postcss/blob/main/docs/syntax.md#main-theory)
    * [Performance](https://github.com/postcss/postcss/blob/main/docs/syntax.md#performance)
    * [Node Source](https://github.com/postcss/postcss/blob/main/docs/syntax.md#node-source)
    * [Raw Values](https://github.com/postcss/postcss/blob/main/docs/syntax.md#raw-values)
    * [Tests](https://github.com/postcss/postcss/blob/main/docs/syntax.md#tests)
   * [Stringifier](https://github.com/postcss/postcss/blob/main/docs/syntax.md#stringifier)
     * [Main Theory](https://github.com/postcss/postcss/blob/main/docs/syntax.md#main-theory-1)
     * [Builder Function](https://github.com/postcss/postcss/blob/main/docs/syntax.md#builder-function)
     * [Raw Values](https://github.com/postcss/postcss/blob/main/docs/syntax.md#raw-values-1)
     * [Tests](https://github.com/postcss/postcss/blob/main/docs/syntax.md#tests-1)
* [Writing a PostCSS Plugin](https://github.com/postcss/postcss/blob/main/docs/writing-a-plugin.md#writing-a-postcss-plugin)
  * [Links](https://github.com/postcss/postcss/blob/main/docs/writing-a-plugin.md#links)
  * [Step 1: Create an idea](https://github.com/postcss/postcss/blob/main/docs/writing-a-plugin.md#step-1-create-an-idea)
  * [Step 2: Create a project](https://github.com/postcss/postcss/blob/main/docs/writing-a-plugin.md#step-2-create-a-project)
  * [Step 3: Find nodes](https://github.com/postcss/postcss/blob/main/docs/writing-a-plugin.md#step-3-find-nodes)
  * [Step 4: Change nodes](https://github.com/postcss/postcss/blob/main/docs/writing-a-plugin.md#step-4-change-nodes)
  * [Step 5: Fight with frustration](https://github.com/postcss/postcss/blob/main/docs/writing-a-plugin.md#step-5-fight-with-frustration)
  * [Step 6: Make it public](https://github.com/postcss/postcss/blob/main/docs/writing-a-plugin.md#step-6-make-it-public)

**Guidlines**
* [PostCSS Plugin Guidelines](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#postcss-plugin-guidelines)
  * [API](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#1-api)
    * [1.1 Clear name with `postcss-` prefix](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#11-clear-name-with-postcss--prefix)
    * [1.2. Do one thing, and do it well](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#12-do-one-thing-and-do-it-well)
    * [1.3. Do not use mixins](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#13-do-not-use-mixins)
    * [1.4. Keep `postcss` to `peerDependencies`](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#14-keep-postcss-to-peerdependencies)
    * [1.5. Set `plugin.postcssPlugin` with plugin name](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#15-set-pluginpostcssplugin-with-plugin-name)
  * [Processing](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#2-processing)
    * [2.1. Plugin must be tested](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#21-plugin-must-be-tested)
    * [2.2. Use asynchronous methods whenever possible](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#22-use-asynchronous-methods-whenever-possible)
    * [2.3. Use fast node’s scanning](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#23-use-fast-nodes-scanning)
    * [2.4. Set `node.source` for new nodes](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#24-set-nodesource-for-new-nodes)
    * [2.5. Use only the public PostCSS API](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#25-use-only-the-public-postcss-api)
  * [Dependencies](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#3-dependencies)
    * [3.1. Use messages to specify dependencies](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#31-use-messages-to-specify-dependencies)
  * [Errors](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#4-errors)
    * [4.1. Use `node.error` on CSS relevant errors](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#41-use-nodeerror-on-css-relevant-errors)
    * [4.2. Use `result.warn` for warnings](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#42-use-resultwarn-for-warnings)
  * [Documentation](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#5-documentation)
    * [5.1. Document your plugin in English](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#51-document-your-plugin-in-english)
    * [5.2. Include input and output examples](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#52-include-input-and-output-examples)
    * [5.3. Maintain a changelog](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#53-maintain-a-changelog)
    * [5.4. Include `postcss-plugin` keyword in `package.json`](https://github.com/postcss/postcss/blob/main/docs/guidelines/plugin.md#54-include-postcss-plugin-keyword-in-packagejson)

* [PostCSS Runner Guidelines](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#postcss-runner-guidelines)
  * [API](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#1-api)
    * [1.1. Accept functions in plugin parameters](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#11-accept-functions-in-plugin-parameters)
  * [Processing](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#21-set-from-and-to-processing-options)
    * [2.1. Set `from` and `to` processing options](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#21-set-from-and-to-processing-options)
    * [2.2. Use only the asynchronous API](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#22-use-only-the-asynchronous-api)
    * [2.3. Use only the public PostCSS API](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#23-use-only-the-public-postcss-api)
    * [3.1. Rebuild when dependencies change](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#31-rebuild-when-dependencies-change)
  * [Output](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#4-output)
    * [4.1. Don’t show JS stack for `CssSyntaxError`](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#41-dont-show-js-stack-for-csssyntaxerror)
    * [4.2. Display `result.warnings()`](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#42-display-resultwarnings)
    * [4.3. Allow the user to write source maps to different files](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#43-allow-the-user-to-write-source-maps-to-different-files)
  * [Documentation](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#5-documentation)
    * [5.1. Document your runner in English](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#51-document-your-runner-in-english)
    * [5.2. Maintain a changelog](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#52-maintain-a-changelog)
    * [5.3. `postcss-runner` keyword in `package.json`](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#53-postcss-runner-keyword-in-packagejson)
    * [5.4. Keep postcss to peerDependencies](https://github.com/postcss/postcss/blob/main/docs/guidelines/runner.md#54-keep-postcss-to-peerdependencies)
