const path = require('path');
const fs = require('fs');

const pify = require('pify');

const readFile = pify(fs.readFile);
const testFolder = path.resolve(__dirname, '..');

function readCssFixture(testId) {
  return readFile(
    path.resolve(testFolder, 'fixtures', 'css', `${testId}.css`),
    'utf8'
  );
}

function readSourceMap(testId) {
  return (
    readFile(
      path.resolve(testFolder, 'fixtures', 'css', `${testId}.css.map`),
      'utf8'
    )
      .then(JSON.parse)
      // The map that is generated by our loader does not have a file property because the
      // output file is unknown when the Less API is used. That's why we need to remove that from our fixture.
      .then(({ file, ...map }) => map)
  ); // eslint-disable-line no-unused-vars
}

exports.readCssFixture = readCssFixture;
exports.readSourceMap = readSourceMap;
