/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import sharpen.core.framework.resources.SimpleProject;

public class JavaModelUtility {
    public static void collectCompilationUnits(List<ICompilationUnit> result, IPackageFragmentRoot root) throws JavaModelException {
        IJavaElement[] elements = root.getChildren();
        int j = 0;
        while (j < elements.length) {
            IPackageFragment p = (IPackageFragment)elements[j];
            result.addAll((Collection<ICompilationUnit>)Arrays.asList(p.getCompilationUnits()));
            ++j;
        }
    }

    public static List<ICompilationUnit> collectCompilationUnits(IJavaProject project) throws JavaModelException {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>();
        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (1 == root.getKind()) {
                JavaModelUtility.collectCompilationUnits(result, root);
            }
            ++i;
        }
        return result;
    }

    public static IProject getTargetProject(IJavaProject project, IProgressMonitor monitor) throws CoreException {
        SimpleProject targetProject = new SimpleProject(JavaModelUtility.getTargetProjectName(project), monitor);
        return targetProject.getProject();
    }

    public static String getTargetProjectName(IJavaProject project) {
        return String.valueOf(project.getElementName()) + ".net";
    }

    public static List<ICompilationUnit> collectCompilationUnits(IPackageFragmentRoot root) throws JavaModelException {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>();
        JavaModelUtility.collectCompilationUnits(result, root);
        return result;
    }

    public static IProject deleteTargetProject(IJavaProject javaProject) throws CoreException {
        IProject target = JavaModelUtility.getTargetProject(javaProject, null);
        if (target.exists()) {
            target.close(null);
            target.delete(true, true, null);
        }
        return target;
    }

    public static IWorkspaceRoot workspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

