package org.jboss.cache.commands.read;

import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.util.MapCopy;

/**
 * Implements functionality defined by {@link org.jboss.cache.Cache#getData(org.jboss.cache.Fqn)}
 * <p/>
 * This is the equivalent of the old MethodCallDefinitions.getDataMapMethodLocal method call from 2.1.x.
 * <p/>
 *
 * @author Mircea.Markus@jboss.com
 * @since 2.2.0
 */
public class GetDataMapCommand extends AbstractDataCommand
{
   public static final int METHOD_ID = 24;

   public GetDataMapCommand(Fqn fqn)
   {
      this.fqn = fqn;
   }

   public GetDataMapCommand()
   {
   }

   /**
    * Retrieves an unmodifiable map of data contained in a node referenced by the specified Fqn.
    *
    * @return an unmodifiable Map<K, V> of data contained in a node for a given Fqn, or null if the Fqn refers to a node that does not exist.
    */
   public Object perform(InvocationContext ctx)
   {
      NodeSPI n = dataContainer.peek(fqn);
      if (n == null) return null;
      return new MapCopy(n.getDataDirect());
   }

   public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable
   {
      return visitor.visitGetDataMapCommand(ctx, this);
   }

   public int getCommandId()
   {
      return METHOD_ID;
   }
}
