/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

import java.io.ByteArrayOutputStream;

/**
 * This class is for unit testing {@link DataPoster} classes.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class ByteArrayDataPosterTest
	extends junit.framework.TestCase
{
	public ByteArrayDataPosterTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ByteArrayDataPosterTest.class);
	}

	public void testSend()
		throws Exception
	{
		DataPoster poster = new ByteArrayDataPoster(new byte[] { 1, 2, 3});
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		poster.sendData(baos);
		assertEquals(3, baos.size());
		assertEquals(1, baos.toByteArray()[0]);
	}

	public void testSend2()
		throws Exception
	{
		DataPoster poster = new ByteArrayDataPoster(new byte[] { 1, 2, 3, 4}, 1, 2);
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		poster.sendData(baos);
		assertEquals(2, baos.size());
		assertEquals(2, baos.toByteArray()[0]);
	}

	public void testExceptions()
		throws Exception
	{
		try {
			new ByteArrayDataPoster(null);
			fail("null array");
		} catch (IllegalArgumentException e) { }
		DataPoster poster = new ByteArrayDataPoster(new byte[0]);
		try {
			poster.sendData(null);
			fail("null os");
		} catch (IllegalArgumentException e) { }
	}


}
