/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.ConstantPool;
import com.claritysys.jvm.classfile.CpEntry;
import com.claritysys.jvm.classfile.CpUtf8;
import java.io.DataOutput;
import java.io.IOException;

public final class CpString
extends CpEntry {
    CpUtf8 str;

    CpString(ConstantPool cpool, int hash, CpUtf8 str) {
        super(cpool, (byte)8, hash);
        this.str = str;
    }

    CpString(ConstantPool cpool) {
        super(cpool, (byte)8, 0);
    }

    public final CpUtf8 getString() {
        return this.str;
    }

    static final int hashCode(CpUtf8 str) {
        return str.hashCode() ^ 0xF30F;
    }

    public void computeHash() {
        if (this.str.hash == 0) {
            this.str.computeHash();
        }
        this.hash = CpString.hashCode(this.str);
    }

    void write(DataOutput dstr) throws IOException {
        dstr.writeByte(8);
        dstr.writeShort(this.str.index);
    }

    public String toJavaString() {
        return this.str.getString();
    }

    public String toString() {
        return "String:  " + this.str.getIndex();
    }

    void postClone() {
        super.postClone();
        this.str = (CpUtf8)this.pool.getPoolEntry(this.str.index);
    }
}

